
registerType('appdoo', (function () { function RoundSegmentedControl() {} var __super = setSupertypeFromDomain(RoundSegmentedControl, 'View', 'Core.UI');

RoundSegmentedControl.prototype.initFromData = function RoundSegmentedControl_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data) 
			=== null) return null;
		
		this.buttonWrapper = createComponentFromDomain("View", "Core.UI", this.context, {
			style: {
				display: 'inline'
			}})
		;
		this.addSubview(this.buttonWrapper);
		
		this.selectedIndex = data.selectedIndex;
		this.localizeLabels = data.localizeLabels;
		this.segments = data.segments;
		this.delegate = data.delegate;

		return this;};
	

RoundSegmentedControl.prototype.initPropertiesFromData = function RoundSegmentedControl__initPropertiesFromData() {
			
			};
		
	
	Object.defineProperty(RoundSegmentedControl.prototype, "segments", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_segments")) Object.defineProperty(this, "_segments", { writable: true, configurable: true });
		
			this._segments = v;
			
			this.buttonWrapper.removeAllSubviews();
			
			if (Array.isArray(v)) {
				var i = 0;
				if (Array.isArray(v)) v.every(function (segmentData) {
					var text = segmentData.label;
					if (this.localizeLabels) text = LocalizedString(text);
					var button = createComponentFromDomain("Label", "Core.UI", this.context, {
						style: {
							position: 'inline',
							display: 'inline-block',
							padding: '4px 14px',
							paddingTop: '5px',
							margin: '0 0',
							fontSize: '11px',
							fontWeight: 'bold',
							color: '#444',
							textShadow: '0 1px 0 hsla(0,0%,100%,.4)',
						},
						text: text,
						tag: i})
					;
					button.DOMNode.onmousedown = function () {
						this.segmentedControl.selectedIndex = button.tag;
					}.bind({ segmentedControl: this, button: button });
					this.buttonWrapper.addSubview(button);
					i++;return true; }, this);
				
			}
		}, get:function () { return this._segments; }});
	
	
RoundSegmentedControl.prototype.viewDidLoad = function RoundSegmentedControl_viewDidLoad() {
		this.selectedIndex = this.selectedIndex;};
	
	
RoundSegmentedControl.prototype.layoutSubviews = function RoundSegmentedControl_layoutSubviews() {

		var width = this.buttonWrapper.DOMNode.offsetWidth,
			offsetX = Math.round(this.size.width/2-width/2)-1;
			
		this.buttonWrapper.position.left = offsetX;
		this.buttonWrapper.position.top = Math.round(this.size.height-23)/2;

		this.positionButtonBackground();};
	
	
RoundSegmentedControl.prototype.positionButtonBackground = function RoundSegmentedControl__positionButtonBackground() {
		var button = this.buttonWrapper.subviews[this._selectedIndex];
		if (!button) return;
		
		var buttonWidth = button.DOMNode.offsetWidth-9,
			buttonX = this.buttonWrapper.position.left + button.DOMNode.offsetLeft + 4;
		
		if (!this.selectedSegmentBackground) {
			this.selectedSegmentBackground = createComponentFromDomain("SmartScalingImage", "Core.UI", this.context, {
				imageSrc: this.context.pathForResource('RoundSegmentSelected.png'),
				contentInset: [15,11,0,0],
				size: { width: buttonWidth, height: 22 },
				position: { top: 1, left: buttonX }})
			;
			this.insertSubviewAtIndex(this.selectedSegmentBackground, 0);
		}
		
		else {
			this.selectedSegmentBackground.position.left = buttonX;
			this.selectedSegmentBackground.position.top = this.buttonWrapper.position.top+1;
			this.selectedSegmentBackground.size.width = buttonWidth;
		}};
	
	
	Object.defineProperty(RoundSegmentedControl.prototype, "selectedIndex", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_selectedIndex")) Object.defineProperty(this, "_selectedIndex", { writable: true, configurable: true });
			var isUpdating = this._selectedIndex !== undefined;
		
			this._selectedIndex = v;
			this.positionButtonBackground();
			
			if (isUpdating === true) {
				this.callDelegate('segmentedControlDidChangeValue', [this]);
			}

		}, get:function () { return this._selectedIndex; }});
	
	
RoundSegmentedControl.prototype.expectedTypeForProperty = function RoundSegmentedControl_expectedTypeForProperty(key) {
	if (key === "segments") return "";
	if (key === "selectedIndex") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return RoundSegmentedControl; }()));