
registerType('appdoo', (function () { function appdoo() {} var __super = setSupertypeFromDomain(appdoo, 'ApplicationContext', 'Core');

appdoo.prototype.changeSimulatedDevice = function appdoo_changeSimulatedDevice(identifier) {
		if(identifier == 'iPhone-Widescreen') {
			identifier = 'iPhone-5';
		}
		this.projectContext.metadata.deviceProfile = identifier;
		if(this.editor !== undefined && this.editor.editedScene !== undefined) {
			this.editor.contentFrameController.interfaceOrientationDidChangeForScene(this.editor.editedScene);
			this.updateAllPreviewImages(this.editor.editedScene.viewController.$id);
		} else {
			this.updateAllPreviewImages();
		}};
	
	
appdoo.prototype.changeSimulatedDeviceInEditor = function appdoo_changeSimulatedDeviceInEditor(identifier) {
		if(this.editor && this.editorIsVisible()) {
			this.editor.deviceIdentifierChanged(identifier);
		}};
	
	
appdoo.prototype.simulatedDevice = function appdoo_simulatedDevice() {
		return this.projectContext.metadata.deviceProfile;};
	
	
	var kEditorVersion = 363
		kFormatVersion = kEditorVersion;

	var showOverviewOnStart = 1;

	Object.defineProperty(appdoo.prototype, "isDebugging", {
	outlet: true, get:function () { return this._isDebugging; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isDebugging")) Object.defineProperty(this, "_isDebugging", { writable: true, configurable: true }); this._isDebugging = v; }});
	

	Object.defineProperty(appdoo.prototype, "isOffscreen", {
	outlet: true, get:function () { return this._isOffscreen; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isOffscreen")) Object.defineProperty(this, "_isOffscreen", { writable: true, configurable: true }); this._isOffscreen = v; }});
	
	
	Object.defineProperty(appdoo.prototype, "disableInAppPreferences", {
	outlet: true, get:function () { return this._disableInAppPreferences; }, set:function (v) {if (!Object.hasOwnProperty(this, "_disableInAppPreferences")) Object.defineProperty(this, "_disableInAppPreferences", { writable: true, configurable: true }); this._disableInAppPreferences = v; }});
	
	
	Object.defineProperty(appdoo.prototype, "themeName", {
	outlet: true, 
		get: function () {
			if(document && document.body) {
				var theme = document.body.className;
				if(theme == 'dark' || theme == 'light') {
					return theme;
				}
			}
			return 'light';
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_themeName")) Object.defineProperty(this, "_themeName", { writable: true, configurable: true }); this._themeName = v; }});
	
	
	Object.defineProperty(appdoo.prototype, "objectTreeDataType", {
		value: 'appdoo.object-tree'});
	
	
	Object.defineProperty(appdoo.prototype, "objectBlueprintDataType", {
		value: 'appdoo.component-blueprint'});
	

	Object.defineProperty(appdoo.prototype, "resourceReferenceDataType", {
		value: 'appdoo.resource-reference'});
	

	Object.defineProperty(appdoo.prototype, "promisedRealObjectsDataType", {
		value: 'appdoo.promised-objects'});
	

	Object.defineProperty(appdoo.prototype, "scenesDataType", {
		value: 'appdoo.scenes'});
	
	
	Object.defineProperty(appdoo.prototype, "supportedImageMimeTypes", {
		value: [
			'image/jpeg','image/png','image/gif','image/tiff','image/bmp','image/x-icon','image/x-xbitmap'
		]});
	
	
	Object.defineProperty(appdoo.prototype, "supportedOfficeMimeTypes", {
		value: [
			'application/pdf',
			'text/rtf',
			'application/msword',
			'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
			'application/vnd.ms-excel',
			'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
			'application/vnd.oasis.opendocument.spreadsheet',
			'application/vnd.oasis.opendocument.text',
			'application/x-iwork-numbers-sffnumbers',
			'application/x-iwork-pages-sffpages',
			'application/x-iwork-keynote-sffkeynote'
		]});
	

appdoo.prototype.nativeProxyIsReady = function appdoo__nativeProxyIsReady() {
		__super.prototype.nativeProxyIsReady.call(this);
		this.isDebugging = this.nativeProxy.sendMessage('isDebugging');
		this.loadPlugins();};
	


appdoo.prototype.init = function appdoo_init() {
		var self = __super.prototype.init.call(this);
		if (self) {
			
			
			self.disableInAppPreferences = true;
			
			self.projectScenesController = createComponentFromDomain("ProjectScenesController", "appdoo", this, {
				globalBindingsSymbol: 'projectScenesController',
				canUndo: true})
			;

			self.projectScenesByIDController = createComponentFromDomain("ProjectScenesByIDController", "appdoo", this, {
				globalBindingsSymbol: 'projectScenesByIDController',
				canUndo: true})
			;

			self.projectMetadataController = createComponentFromDomain("ProjectMetadataController", "appdoo", this, {
				globalBindingsSymbol: 'projectMetadataController',
				canUndo: true})
			;
			
			self.connectableObjects["projectScenesController"] = self.projectScenesController;
			self.connectableObjects["projectScenesByIDController"] = self.projectScenesByIDController;
			self.connectableObjects["projectMetadataController"] = self.projectMetadataController;
			
			setTimeout(function () {
				self.preloadImages();
			}, 0);

			self.userPlugInManager = createComponentFromDomain("UserPlugInManager", "appdoo", this, {})
			;

		}
		
		if (!this.isOffscreen) {
			this._didBecomeMainEventHandlerBound = this.didBecomeMainEventHandler.bind(this);
			window.addEventListener('didBecomeMain', this._didBecomeMainEventHandlerBound);
	
			this._didResignMainEventHandlerBound = this.didResignMainEventHandler.bind(this);
			window.addEventListener('didResignMain', this._didResignMainEventHandlerBound);
		}
		else {
		}
		
		return self;};
	
	
appdoo.prototype.didBecomeMainEventHandler = function appdoo__didBecomeMainEventHandler(e) {
		if (this.fileUpdateInterval) {
			clearInterval(this.fileUpdateInterval);
			this.fileUpdateInterval = 0;
		}};
	

appdoo.prototype.didResignMainEventHandler = function appdoo__didResignMainEventHandler(e) {
		if (!this.fileUpdateInterval) {
			this.fileUpdateInterval = setInterval(function () {
				this.checkIfFilesWereUpdated();
			}.bind(this), 250);
		}};
	

appdoo.prototype.loadLocalization = function appdoo__loadLocalization() {
		window.language = this.nativeProxy.sendMessage('currentLanguage'); 
		window.systemVersion = JSON.parse(this.nativeProxy.sendMessage('systemVersion'));
		window.localizedStrings = JSON.parse(this.nativeProxy.sendMessage('stringFromFile', 'Resources/'+window.language+'.lproj/Strings.json'));
		this.nativeProxyAccoutDidChange();};
	
	
appdoo.prototype.nativeProxyAccoutDidChange = function appdoo_nativeProxyAccoutDidChange() {
		window.userIsSubscribed = this.nativeProxy.sendMessage('userIsSubscribed'); };
	


	

appdoo.prototype.loadData = function appdoo_loadData(JSONString) {

		var projectData;

		try {
			projectData = this.parseProjectData(JSONString);
		}
		catch(err) {
			this.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
				message: LocalizedString("The project file is damaged and cannot be read."),
				details: LocalizedString(err.message)
			}));
			this.nativeProxy.sendMessage('close');
			return;
		}

		this.loadProjectData(projectData);
		
		if (!this.isOffscreen)
			this.lookForPrototypeDevices();
		};
	
	
appdoo.prototype.lookForPrototypeDevices = function appdoo__lookForPrototypeDevices() {
		if (this.isOffscreen) return;
		var info = JSON.parse(this.nativeProxy.sendMessage('getCurrentPrototypeDevices'));
		this.prototypeDevicesBar.updateDevicesList(info);};
	
	
appdoo.prototype.loadProjectData = function appdoo_loadProjectData(projectData) {

		if (!this.projectContext) {
			this.projectContext = createComponentFromDomain('ProjectContext', 'appdoo', null, {
				temporaryDataDirectory: this.temporaryDataDirectory,
				projectDataDirectory: this.projectDataDirectory,
				nativeProxy: this.nativeProxy,
				undoManager: this.undoManager,
				highResolutionEnabled: this.highResolutionEnabled,
				isOffscreen: this.isOffscreen,
			});
		}
		
		this.projectContext.loadProjectData(projectData);
		this.projectScenesController.setValues(this.projectContext.scenes, this);
		this.projectMetadataController.replaceWithData(this.projectContext.metadata, this);
		if (this.isOffscreen) return;
		
		if (showOverviewOnStart) {

			this.loadOverview(function (overview) {
				_context.showOverview();
				setTimeout(function () {
					
					
				}, 10);
			});

		}
		else this.showEditor();
		
		setTimeout(function () {
			this.checkIfFilesWereUpdated();
		}.bind(this), 1000);
};
	

appdoo.prototype.getUnsavedData = function appdoo_getUnsavedData() {

		if (this.isOffscreen) return;
	
		var editor = this.connectableObjects.editor;

		if (editor !== undefined)
			editor.saveItem();
		
		var unsavedData = {
			projectData: this.collectProjectData(),
			changedRegistrationStates: this.projectContext.changedRegistrationStates,
			changedMediaItems: this.projectContext.changedMediaItems
		};

		this.projectContext.cleanUpRegistrations();
					
		return JSON.stringify(unsavedData, null, "	");};
	
	
appdoo.prototype.goBack = function appdoo_goBack() {
		if (this.editorIsVisible()) {
			this.editor.goBack();
			this.nativeProxy.sendMessage('updateProjectWindowToolbar');
		}};
	

appdoo.prototype.goForward = function appdoo_goForward() {
		if (this.editorIsVisible()) {
			this.editor.goForward();
			this.nativeProxy.sendMessage('updateProjectWindowToolbar');
		}};
	

appdoo.prototype.canGoForward = function appdoo_canGoForward() {
		if (this.editorIsVisible()) return this.editor.historyManager.canGoForward;};
	

appdoo.prototype.canGoBack = function appdoo_canGoBack() {
		if (this.editorIsVisible()) return this.editor.historyManager.canGoBack;};
	
	
	Object.defineProperty(appdoo.prototype, "projectDataDirectory", {
		get: function () {
			return this.nativeProxy.sendMessage('projectDataDirectory');
		}});
	

	Object.defineProperty(appdoo.prototype, "temporaryDataDirectory", {
		get: function () {
			return this.nativeProxy.sendMessage('temporaryDataDirectory');
		}});
	
	
appdoo.prototype.revertDocumentToSaved = function appdoo_revertDocumentToSaved(JSONString) {
	
		this.reset();
		this.loadData(JSONString);
		this.showEditor();
	};
	
	
appdoo.prototype.reset = function appdoo_reset() {
		if (this.editor) {
			this.editor.destroy();
			if (this.overview) this.overview.destroy();
			delete this.editor;
			delete this.overview;
			delete this.projectContext;
			delete this.keyViewController;
		}
		__super.prototype.reset.call(this);};
	
	
appdoo.prototype.applicationDidSaveProjectWithName = function appdoo_applicationDidSaveProjectWithName(name) {
		var currentName = this.projectMetadataController.get('title');
		if (!currentName || currentName === LocalizedString('Untitled'))
			this.projectMetadataController.setValueForKeyPath(name, 'title');};
	
	
	Object.defineProperty(appdoo.prototype, "isEditingNewProject", {
		get: function () { return this.projectMetadataController.get('title') === ''; }});
	
	
appdoo.prototype.updateMetadata = function appdoo_updateMetadata(jsonString) {
	
		var metadata = JSON.parse(jsonString);
		this.projectContext.metadata = metadata;

		
		this.projectMetadataController.replaceWithData(metadata);};
	
	
	
	
	
appdoo.prototype.showEditorWithOptions = function appdoo_showEditorWithOptions(options) {
		if (!this.editor)
			return this.loadEditor(arguments.callee.bind(this, options));
		
		this.registerKeyViewController(this.editor);
		
		if (!this.editor.editedViewController ||
			 this.editor.editedViewController.$id !== options.itemId) {
			 
			var itemToOpen;
			if (options.itemId) { itemToOpen = this.projectContext.sceneWithID(options.itemId); }
			if (!itemToOpen) { itemToOpen = this.projectContext.sceneWithID(this.projectContext.metadata.editedObject); }
			if (!itemToOpen) { itemToOpen = this.projectContext.sceneWithID(this.projectMetadataController.get("initialViewController")); }
			if (!itemToOpen) { itemToOpen = this.projectContext.initialScene; }
			this.nativeProxy.sendMessage('updateProjectWindowToolbar');
			this.editor.openItem(itemToOpen);
		
		}
		
		this.nativeProxy.sendMessage('updateMainMenu');
		this.nativeProxy.sendMessage('updateProjectWindowToolbar');
		return true;
		};
	
	
appdoo.prototype.showEditor = function appdoo_showEditor() {
		return this.showEditorWithOptions({});};
	

appdoo.prototype.showOverview = function appdoo_showOverview(recursiveCall) {
		if (!this.overview) {
			return this.loadOverview(arguments.callee.bind(this, true));
		}
		this.nativeProxy.sendMessage('updateProjectWindowToolbar');
		this.registerKeyViewController(this.overview);
		this.nativeProxy.sendMessage('updateMainMenu');
		this.updateAllSceneViews();
		return true;};
	
	

appdoo.prototype.loadEditor = function appdoo__loadEditor(callback) {
	
		if (this.editor !== undefined)
			return callback(this.editor);
		
		var editorBundleFile;
		if (!this.isOffscreen) {
			editorBundleFile = 'Serialized/Editor.json';
		}
		else {
			editorBundleFile = 'Serialized/ThumbnailGenerator.json';
		}
			 	
		var bundle = JSON.parse(this.nativeProxy.sendMessage('stringFromFile', editorBundleFile));

		if (this.isDebugging) {
			var s = 'Tests_EditorTests.js';
			if (editorResources.indexOf(s) === -1) editorResources.push(s);
		}

		this.callWhenResourcesAreLoaded(function () {

			this.decodeArchive(bundle);

			this.editor = this.connectableObjects['editor'];
			if (!this.editor) return;
			
			this.editor.performAfterLoading(function () {
			
				this.registerMainViewController(this.editor);
				
				this.editor.setEditorAppearance(this.projectContext.metadata.editorAppearance);
				
				if (!this.isOffscreen) {
					this.editor.showPrototypeDevicesBar(this._prototypeDevicesBar);
				}
				
				if (callback) {
					callback(this.editor);
				}


			}.bind(this));


		}.bind(this), editorResources);

		return true;
	};
	

appdoo.prototype.loadOverview = function appdoo__loadOverview(callback, preload) {

		if (this.overview !== undefined) {
			if (!callback) return;
			return callback(this.overview);
		}
		
		if (this.isLoadingOverview) return;
		this.isLoadingOverview = true;
	
		var bundle = JSON.parse(this.nativeProxy.sendMessage('stringFromFile', 'Serialized/Overview.json'));

		this.callWhenResourcesAreLoaded(function () {

			this.decodeArchive(bundle);
			
			var overview = this.connectableObjects['overview'];
			this.overview = overview;
			overview.performAfterLoading(function () {

				if (!this.isOffscreen) {
					
				}
				overview.setOverviewAppearance(this.projectContext.metadata.overviewAppearance);
				overview.view.hidden = true;
				this.registerMainViewController(overview);
				
				if (callback) callback(overview);
				
			}.bind(this));
			
		
		}.bind(this), overviewResources);

		return true;
	};
	

appdoo.prototype.preloadImages = function appdoo_preloadImages() {

		this.callWhenResourcesAreLoaded(function () {
		}, [
			this.pathForOptimizedImage('Resources/SquaredFocusRing.png'),
			this.pathForOptimizedImage('Resources/SquaredFocusRingGraphite.png'),
			this.pathForOptimizedImage('Resources/SizeModifierButton.png'),
			this.pathForOptimizedImage('Resources/SegmentedControlEC.png')
		]);
		};
	

appdoo.prototype.preloadOverview = function appdoo_preloadOverview() {
		if (this.isOffscreen) return;
		if (!this.overview) this.loadOverview(null, true);};
	
	
appdoo.prototype.isEditingViewControllerId = function appdoo_isEditingViewControllerId(id) {
		return this.editor && this.editor.editedViewController && this.editor.editedViewController.$id === id;};
	
		

	

appdoo.prototype.arrangeElement = function appdoo_arrangeElement(arrangeType) {
		this.connectableObjects['editor'].arrangeElementFromMenu(arrangeType);};
	
	
appdoo.prototype.collectProjectData = function appdoo_collectProjectData(forCapturingPreview) {

		var metadata = this.projectMetadataController.contents;
		if (this.editor)	metadata.editorAppearance = this.editor.getEditorAppearance();
		if (this.overview)	metadata.overviewAppearance = this.overview.getOverviewAppearance();
			
		metadata.formatVersion = kFormatVersion;
		metadata.editorVersion = kEditorVersion;
		metadata.simulatedSystemVersion = this.projectContext.simulatedSystemVersion;

		if (this.editor && this.editor.editedScene)
			metadata.editedObject = this.editor.editedScene.$id;

		var projectData = this.projectContext.collectProjectData(forCapturingPreview);
		projectData.metadata = metadata;

		return projectData;
	};
	


	

appdoo.prototype.colorPanelDidChangeColor = function appdoo_colorPanelDidChangeColor(rgbaColor) {
		if (this.colorPanelDelegate !== undefined)
			this.colorPanelDelegate.colorPanelDidChangeColor(rgbaColor);};
	
	
appdoo.prototype.colorPanelDidClose = function appdoo_colorPanelDidClose() {
		if (this.colorPanelDelegate !== undefined)
			this.colorPanelDelegate.colorPanelDidClose();};
	
	
	
	
	
appdoo.prototype.loadProjectItemForCapturing = function appdoo_loadProjectItemForCapturing(dataJSON) {
	
		
		if (this.editor) {
			this.editor.destroy();
			delete this.editor;
		}
	
		var data = JSON.parse(dataJSON);

		this.loadProjectData(data.projectData);

		this.loadEditor(function () {

			var tbcData = this.projectContext.tabBarController,
				viewControllerIdToLoad = data.itemId,
				scene = this.projectContext.sceneContainingViewController(viewControllerIdToLoad);

			var didWork = false;
			try {
				this.editor.openItem(
					this.projectContext.sceneContainingViewController(viewControllerIdToLoad),
					{
						tbcData: tbcData,
						tbIndex: tbcData ? (tbcData.viewControllerIDs ? tbcData.viewControllerIDs.indexOf(viewControllerIdToLoad) : 0) : 0
					}
				);
				didWork = true;
			}
			catch (err) {
				 console.warn('An error occured while opening an scene for thumbnail generation.', err);
			}
			
			if (didWork) {
				
				setTimeout(function () {
					
					this.nativeProxy.sendMessage('readyToGenerateThumbnailForItemID',
						data.itemId,
						JSON.stringify(scene.simulatedWindowSize));

				}.bind(this), 500);
			}
		}.bind(this));};
	
	
appdoo.prototype.updateAllSceneViews = function appdoo_updateAllSceneViews() {
		if (Array.isArray(this.overview.scenesView.sceneViewsController.contents)) this.overview.scenesView.sceneViewsController.contents.every(function (sceneView) {
			sceneView.updateView();return true; }, this);
		};
	
	
appdoo.prototype.updateAllPreviewImages = function appdoo_updateAllPreviewImages(firstItemID) {
		if (firstItemID) {
			this.captureProjectItemImage(firstItemID);
		}

		

		if (Array.isArray(this.projectScenesController.contents)) this.projectScenesController.contents.every(function (scene) {
			
			var viewControllerId = scene.viewController.$id;

			if (viewControllerId === firstItemID)
				return true;

			this.captureProjectItemImage(viewControllerId);return true; }, this);
		};
	
	
appdoo.prototype.captureProjectItemImage = function appdoo_captureProjectItemImage(itemId, useCache) {

		if (this.isOffscreen) return;

		var dataJSON = JSON.stringify({
			itemId: itemId,
			projectData: this.collectProjectData(useCache),
		});

		this.nativeProxy.sendMessage('requestThumbnailForJSONString', dataJSON);
	};
	
	
appdoo.prototype.nativeClientDidGeneratePreview = function appdoo_nativeClientDidGeneratePreview(dataJSON) {
		
		var data = JSON.parse(dataJSON),
			viewControllerID = data.itemID,
			imageSrc = data.savedImageURL;
		
		var scene = this.projectContext.sceneContainingViewController(viewControllerID);

		this.undoManager.disableRegistration();
		this.projectScenesByIDController.setValueForKeyPath(imageSrc, scene.$id+'.temporaryPreviewImagePath', this);
		this.sceneDidChangeSize(scene);
		this.overview.scenesView.updateSegues();
		this.undoManager.enableRegistration();
};
	
	
appdoo.prototype.nativeClientDidUpdatePrototypeDevicesList = function appdoo_nativeClientDidUpdatePrototypeDevicesList(infoJSON) {
		var info = JSON.parse(infoJSON);
		this.prototypeDevicesBar.updateDevicesList(info);};
	

appdoo.prototype.nativeClientPrototypeDeviceDidRequestCompleteProject = function appdoo_nativeClientPrototypeDeviceDidRequestCompleteProject(sessionID) {
		this.prototypeDevicesBar.publishForDeviceWithSessionID(sessionID);};
	
	
appdoo.prototype.nativeClientPrototypeDeviceDidChangeCurrentProject = function appdoo_nativeClientPrototypeDeviceDidChangeCurrentProject(infoJSON) {
		var info = JSON.parse(infoJSON);
		this.prototypeDevicesBar.deviceDidChangeCurrentProject(info);};
	
	
	Object.defineProperty(appdoo.prototype, "prototypeDevicesBar", {
		get: function () {
			if (!this._prototypeDevicesBar) {
				this._prototypeDevicesBar = createComponentFromDomain("PrototypeDevicesBar", "appdoo", this, {
					size: { width: window.innerWidth, height: 0 },
					autoresizingMask: 2,
					position: { bottom: 0 },})
				;
			}
			return this._prototypeDevicesBar;
		}});
	

appdoo.prototype.fileURLForPreviewWithID = function appdoo_fileURLForPreviewWithID(ID) {
		return this.nativeProxy.sendMessage('fileURLForPreviewWithID', ID);};
	
	
appdoo.prototype.sceneDidChangeSize = function appdoo_sceneDidChangeSize(scene) {
		this.broadcastValueChangeForKeyPathInObject(scene.$id+'.previewSize', this.projectScenesByIDController, this);};
	
	
	
	
	
appdoo.prototype.validateToolbarItem = function appdoo_validateToolbarItem(identifier) {
	
		if (this.editorIsVisible()) {
			return this.editor.validateToolbarItem(identifier);
		} else {
			
				
		}
		return false;
		};
	
	
appdoo.prototype.validateInsertion = function appdoo_validateInsertion(elementUTI) {
		if (!this.editorIsVisible())
			return false;
		return this.editor.validateInsertion(elementUTI);};
	
	
appdoo.prototype.validateMenuItem = function appdoo_validateMenuItem(tag) {
		tag = parseInt(tag);
		if (this.keyViewController) {
			return this.keyViewController.validateMenuItem(tag);
		}
		return false;};
	
	
	
	
	
appdoo.prototype.changeLayout = function appdoo_changeLayout(tag) {
	
		tag = parseInt(tag);
		
		
		
		
		

		if (tag >= 1 && tag <= 3) {
			var splitView, viewIndex, animated = (tag===3);

			switch (tag) {
				case 1:
					splitView = this.editor.mainSplitView;
					viewIndex = 0;
					break;
				case 2:
					
					if (this.editor.mainSplitView.viewIsCollapsedAtIndex(2)) {
						this.changeLayout(2);
						if (!this.editorOutlineIsCollapsed()) return;
					}
				
					splitView = this.editor.rightSplitView;
					viewIndex = 1;
					break;
			}

			if (splitView.viewIsCollapsedAtIndex(viewIndex)) {
				splitView.expandViewAtIndexAnimated(viewIndex, animated);
			}
			else {
				splitView.collapseViewAtIndexAnimated(viewIndex, animated);
			}

		}
		else if (tag === 100) {
			this.editor.contentFrameController.toggle3_5InchDisplay();
		}
		else if (tag === 101) {
			this.editor.contentFrameController.rotate();
		}
		else if (tag === 102) {
			this.editor.toggleSimulatedSystem();
		}
		else if (tag === 200) {
			this.editor.contentFrameController.zoomIn();
		}
		else if (tag === 201) {
			this.editor.contentFrameController.zoomOut();
		}
		else if (tag === 202) {
			this.editor.contentFrameController.zoomToOriginalSize();
		}
		};
	
	
appdoo.prototype.editorIsVisible = function appdoo_editorIsVisible() {
		return this.editor && this.keyViewController === this.editor;};
	
	
appdoo.prototype.editorOutlineIsCollapsed = function appdoo_editorOutlineIsCollapsed() {
		if (!this.editor) return;
		return this.editorInspectorIsCollapsed() || this.editor.rightSplitView.viewIsCollapsedAtIndex(1);};
	

appdoo.prototype.editorElementsAreCollapsed = function appdoo_editorElementsAreCollapsed() {
		if (!this.editor) return;
		return this.editor.mainSplitView.viewIsCollapsedAtIndex(0);};
	

appdoo.prototype.editorInspectorIsCollapsed = function appdoo_editorInspectorIsCollapsed() {
		if (!this.editor) return;
		return this.editor.mainSplitView.viewIsCollapsedAtIndex(2);};
	
	
appdoo.prototype.editorIsSimulating3_5InchDisplay = function appdoo_editorIsSimulating3_5InchDisplay() {
		if (!this.editor) return;
		return this.editor.contentFrameController.isSimulating3_5InchDisplay;};
	
	
appdoo.prototype.currentZoomIsOriginalSize = function appdoo_currentZoomIsOriginalSize() {
		if (this.keyViewController) {
			return this.keyViewController.currentZoomIsOriginalSize;
		}};
	
	
	
	
	
appdoo.prototype.prepareForUndoManagerWithID = function appdoo_prepareForUndoManagerWithID(ID) {
	
		if (this.isOffscreen) return;

		if (this.undoManagers === undefined)
			this.undoManagers = [];
	
		if (this.undoManagers[ID] === undefined)
			this.undoManagers[ID] = createComponentFromDomain("UndoManager", "Core", this, {})
			;

		this.undoManager = this.undoManagers[ID];
		this.undoManager.prepare();

		this.nativeProxy.sendMessage('prepareForUndoManagerWithID', ID);};
	

// role UndoManagerPersistanceIDProvider 
		
appdoo.prototype.persistantIDForController = function appdoo_persistantIDForController(controller) {

			if (controller === this.projectMetadataController)
				return '{ "path": "projectMetadataController" }';

			if (controller === this.projectScenesController)
				return '{ "path": "projectScenesController" }';

			if (controller === this.projectScenesByIDController)
				return '{ "path": "projectScenesByIDController" }';

			if (this.editor)
				return this.editor.persistantIDForController(controller);};
		
		
appdoo.prototype.controllerForPersistantID = function appdoo_controllerForPersistantID(pID) {

			if (pID === '{ "path": "projectMetadataController" }')
				return this.projectMetadataController;

			if (pID === '{ "path": "projectScenesController" }')
				return this.projectScenesController;

			if (pID === '{ "path": "projectScenesByIDController" }')
				return this.projectScenesByIDController;
			
			if (this.editor)
				return this.editor.controllerForPersistantID(pID);};
		
		
	
	
	
appdoo.prototype.showProjectMetadataEditor = function appdoo_showProjectMetadataEditor() {
		this.nativeProxy.sendMessage('editProjectMetadata', JSON.stringify(this.projectMetadataController.contents));};
	
	
appdoo.prototype.setProjectMetadata = function appdoo_setProjectMetadata(json) {
		var data = JSON.parse(json);
		this.projectMetadataController.replaceWithData(data);};
	
	

	
	
	
appdoo.prototype.loadPlugins = function appdoo__loadPlugins() {
		
			var bp = this.nativeProxy.sendMessage('bundlePath');
			window.availablePlugins = {
				'info.appdoo-mac.SegmentedNavigationArrows': {
					path: bp+'/PlugIns/SegmentedNavigationArrows.cpsplugin',
					resources: [
						{ path: 'info.appdoo-mac.SegmentedNavigationArrows/System6ArrowDown.png', type: 'image/png' },
						{ path: 'info.appdoo-mac.SegmentedNavigationArrows/System6ArrowUp.png', type: 'image/png' },
						{ path: 'info.appdoo-mac.SegmentedNavigationArrows/System6ArrowDown@2x.png', type: 'image/png' },
						{ path: 'info.appdoo-mac.SegmentedNavigationArrows/System6ArrowUp@2x.png', type: 'image/png' },
						{ path: 'info.appdoo-mac.SegmentedNavigationArrows/System7ArrowDown@2x.png', type: 'image/png' },
						{ path: 'info.appdoo-mac.SegmentedNavigationArrows/System7ArrowUp@2x.png', type: 'image/png' },
					],
					buildFiles: [ 'SegmentedNavigationArrows.m' ],
					systemFrameworks: { "CoreGraphics": true },
					includeHeader: 'SegmentedNavigationArrows.h',
					"providesNavigation": true,
				},
				'info.appdoo-mac.Hyperlink': {
					path: bp+'/PlugIns/Hyperlink.cpsplugin',
					resources: [],
					buildFiles: [ 'Hyperlink.m' ],
					includeHeader: 'Hyperlink.h',
					systemFrameworks: { "CoreGraphics": true },
					systemLibraries: { }
				},
				'info.appdoo-mac.UICollectionView': {
					path: bp+'/PlugIns/UICollectionView.cpsplugin',
					"requiresPlugins": ["info.appdoo-mac.StaticCollectionViewDataSource","info.appdoo-mac.DataSourceBase"],
					resources: []
				},
				'info.appdoo-mac.CollectionViewDataProvider': {
					path: bp+'/PlugIns/CollectionViewDataProvider.cpsplugin',
					includeHeader: 'CollectionViewDataProvider.h',
					buildFiles: [ 'CollectionViewDataProvider.m' ],
					"requiresPlugins": ["info.appdoo-mac.StaticCollectionViewDataSource","info.appdoo-mac.DataSourceBase"],
					resources: []
				},
				'info.appdoo-mac.TableViewSelectionDataProvider': {
					path: bp+'/PlugIns/TableViewSelectionDataProvider.cpsplugin',
					includeHeader: 'TableViewSelectionDataProvider.h',
					buildFiles: [ 'TableViewSelectionDataProvider.m' ],
					"requiresPlugins": ["info.appdoo-mac.DataSourceBase"],
					resources: []
				},
				'info.appdoo-mac.CPSUITableView': {
					path: bp+'/PlugIns/CPSUITableView.cpsplugin',
					includeHeader: 'CPSUITableView.h',
					buildFiles: [ 'CPSUITableView.m' ],
					"requiresPlugins": ["info.appdoo-mac.CPSObservable"],
					resources: []
				},
				'info.appdoo-mac.CPSObservable': {
					path: bp+'/PlugIns/CPSObservable.cpsplugin',
					includeHeader: 'CPSObservable.h',
					buildFiles: [ 'CPSObservable.m' ],
					"requiresPlugins": [],
					resources: []
				},
				'info.appdoo-mac.CPSUIWebViewScriptObject': {
					path: bp+'/PlugIns/CPSUIWebViewScriptObject.cpsplugin',
					includeHeader: 'CPSUIWebViewScriptObject.h',
					buildFiles: [ 'CPSUIWebViewScriptObject.m' ],
					"requiresPlugins": ["info.appdoo-mac.CPSObservable"],
					resources: []
				},
				'info.appdoo-mac.TextFieldInputViewSystem8Compatible': {
					path: bp+'/PlugIns/TextFieldInputViewSystem8Compatible.cpsplugin',
					buildFiles: [ 'TextFieldInputViewSystem8Compatible.m' ],
					includeHeader: 'TextFieldInputViewSystem8Compatible.h',
					resources: []
				},
				'info.appdoo-mac.MoviePlayerView': {
					path: bp+'/PlugIns/MoviePlayerView.cpsplugin',
					includeHeader: 'MoviePlayerView.h',
					buildFiles: [ 'MoviePlayerView.m','MoviePlayerDataProvider.m' ],
                    systemFrameworks: { "AVKit": true, "CoreMedia": true, "AVFoundation": true },
					resources: []
				},
				'info.appdoo-mac.SimpleDatabase': {
					path: bp+'/PlugIns/SimpleDatabase.cpsplugin',
					resources: [],
					buildFiles: [
						'SimpleDatabase.m',
						'NanoStore/Classes/Public/NSFNanoBag.m',
						'NanoStore/Classes/Public/NSFNanoExpression.m',
						'NanoStore/Classes/Public/NSFNanoGlobals.m',
						'NanoStore/Classes/Public/NSFNanoObject.m',
						'NanoStore/Classes/Public/NSFNanoPredicate.m',
						'NanoStore/Classes/Public/NSFNanoSearch.m',
						'NanoStore/Classes/Public/NSFNanoSortDescriptor.m',
						'NanoStore/Classes/Public/NSFNanoStore.m',
						'NanoStore/Classes/Advanced/NSFNanoEngine.m',
						'NanoStore/Classes/Advanced/NSFNanoResult.m',
						'NanoStore/Classes/Advanced/NSFOrderedDictionary.m',
					],
					headerFiles: [
						'NanoStore/Classes/Advanced/NSFNanoEngine.h',
						'NanoStore/Classes/Advanced/NSFNanoResult.h',
						'NanoStore/Classes/Advanced/NSFOrderedDictionary.h',
						'NanoStore/Classes/Private/NanoStore_Private.h',
						'NanoStore/Classes/Private/NSFNanoBag_Private.h',
						'NanoStore/Classes/Private/NSFNanoEngine_Private.h',
						'NanoStore/Classes/Private/NSFNanoExpression_Private.h',
						'NanoStore/Classes/Private/NSFNanoGlobals_Private.h',
						'NanoStore/Classes/Private/NSFNanoObject_Private.h',
						'NanoStore/Classes/Private/NSFNanoPredicate_Private.h',
						'NanoStore/Classes/Private/NSFNanoResult_Private.h',
						'NanoStore/Classes/Private/NSFNanoSearch_Private.h',
						'NanoStore/Classes/Private/NSFNanoStore_Private.h',
						'NanoStore/Classes/Public/NanoStore.h',
						'NanoStore/Classes/Public/NSFNanoBag.h',
						'NanoStore/Classes/Public/NSFNanoExpression.h',
						'NanoStore/Classes/Public/NSFNanoGlobals.h',
						'NanoStore/Classes/Public/NSFNanoObject.h',
						'NanoStore/Classes/Public/NSFNanoObjectProtocol.h',
						'NanoStore/Classes/Public/NSFNanoPredicate.h',
						'NanoStore/Classes/Public/NSFNanoSearch.h',
						'NanoStore/Classes/Public/NSFNanoSortDescriptor.h',
						'NanoStore/Classes/Public/NSFNanoStore.h',
					],
					includeHeader: 'SimpleDatabase.h',
					systemFrameworks: {  },
					systemLibraries: { "libsqlite3": true },
					copyright: 'NanoStore Copyright (c) 2010, Tito Ciuro, Webbo, L.L.C. All rights reserved.',
					licenceFile: 'NanoStore/Licence.txt',
					licenceProductNames: 'NanoStore',
				},
				'info.appdoo-mac.JSONDataSource': {
					path: bp+'/PlugIns/JSONDataSource.cpsplugin',
					resources: [],
					buildFiles: [
						"JSONDataSource.m",
					],
					includeHeader: 'JSONDataSource.h'
				},
				'info.appdoo-mac.TextualListDataSource': {
					path: bp+'/PlugIns/TextualListDataSource.cpsplugin',
					resources: [],
					buildFiles: [
						"TextualListDataSource.m",
					],
					includeHeader: 'TextualListDataSource.h'
				},













				
				'info.appdoo-mac.KeyValueStore': {
					path: bp+'/PlugIns/KeyValueStore.cpsplugin',
					resources: [],
					buildFiles: [
						"KeyValueStore.m",
					],
					includeHeader: 'KeyValueStore.h'
				},
				'info.appdoo-mac.AtomDataSource': {
					path: bp+'/PlugIns/AtomDataSource.cpsplugin',
					resources: [],
					buildFiles: [
						"AtomDataSource.m",
						"BSAtomParser/BSAtomFeed.m",
						"BSAtomParser/BSAtomFeedBase.m",
						"BSAtomParser/BSAtomFeedCategory.m",
						"BSAtomParser/BSAtomFeedCustomElement.m",
						"BSAtomParser/BSAtomFeedEntry.m",
						"BSAtomParser/BSAtomFeedGenerator.m",
						"BSAtomParser/BSAtomFeedLink.m",
						"BSAtomParser/BSAtomFeedPerson.m",
						"BSAtomParser/BSAtomFeedTextElement.m",
						"BSAtomParser/BSAtomParser.m",
					],
					includeHeader: 'AtomDataSource.h'
				},
				'info.appdoo-mac.RSS2DataSource': {
					path: bp+'/PlugIns/RSS2DataSource.cpsplugin',
					resources: [],
					buildFiles: [
						"RSS2DataSource.m", "RSS2Parser.m", "RXMLElement.m"
					],
					systemLibraries: { "libxml2": true },
					includeHeader: 'RSS2DataSource.h',
					licenceFile: 'License.txt',
					licenceProductNames: 'RXMLElement',
					copyright: 'RXMLElement Copyright (c) 2013 John Blanco',
				},
				'info.appdoo-mac.CSVDataSource': {
					path: bp+'/PlugIns/CSVDataSource.cpsplugin',
					resources: [],
					buildFiles: [
						"CSVDataSource.m",
						"CSV2JSON.m",
					],
					includeHeader: 'CSVDataSource.h'
				},
				'info.appdoo-mac.FilteredDataSource': {
					path: bp+'/PlugIns/FilteredDataSource.cpsplugin',
					resources: [],
					buildFiles: [
						"FilteredDataSource.m"
					],
					includeHeader: 'FilteredDataSource.h'
				},
				'info.appdoo-mac.SimpleMapView': {
					path: bp+'/PlugIns/SimpleMapView.cpsplugin',
					resources: [],
					buildFiles: [
						"SimpleMapView.m",
					],
					includeHeader: 'SimpleMapView.h',
					systemFrameworks: { "MapKit": true, "CoreLocation": true },
					localizedStringFiles: {"SimpleMapViewLocalized.strings": ["de","en"] }
				},
				'info.appdoo-mac.SearchBarDataProvider': {
					path: bp+'/PlugIns/SearchBarDataProvider.cpsplugin',
					resources: [],
					buildFiles: [
						"SearchBarDataProvider.m",
					],
					includeHeader: 'SearchBarDataProvider.h'
				},
				'info.appdoo-mac.SystemActions': {
					path: bp+'/PlugIns/SystemActions.cpsplugin',
					resources: [],
					buildFiles: [
						"SystemActions.m",
					],
					includeHeader: 'SystemActions.h'
				},
				'info.appdoo-mac.MapActions': {
					path: bp+'/PlugIns/MapActions.cpsplugin',
					resources: [],
					buildFiles: [
						"MapActions.m",
					],
					systemFrameworks: { "MapKit": true, "CoreLocation": true },
					includeHeader: 'MapActions.h'
				},
				'info.appdoo-mac.DataSensor': {
					path: bp+'/PlugIns/DataSensor.cpsplugin',
					resources: [],
					buildFiles: [ "DataSensor.m" ],
					includeHeader: 'DataSensor.h'
				},
				'info.appdoo-mac.DatePickerDataProvider': {
					path: bp+'/PlugIns/DatePickerDataProvider.cpsplugin',
					resources: [],
					buildFiles: [ "DatePickerDataProvider.m" ],
					includeHeader: 'DatePickerDataProvider.h'
				},
				'info.appdoo-mac.UITableViewPullToRefresh': {
					path: bp+'/PlugIns/UITableViewPullToRefresh.cpsplugin',
					resources: [],
					buildFiles: [ "UITableView+PullToRefresh.m" ],
					systemFrameworks: { },
				},
				'info.appdoo-mac.PatternView': {
					path: bp+'/PlugIns/PatternView.cpsplugin',
					resources: [],
					buildFiles: [ "PatternView.m" ],
					systemFrameworks: { },
					includeHeader: 'PatternView.h'
				},











				
				'info.appdoo-mac.ExtendedImageView': {
					path: bp+'/PlugIns/ExtendedImageView.cpsplugin',
					resources: [],
					buildFiles: [ "ExtendedImageView.m" ],
					systemFrameworks: { },
					includeHeader: 'ExtendedImageView.h'
				},
				'info.appdoo-mac.LineView': {
					path: bp+'/PlugIns/LineView.cpsplugin',
					resources: [],
					buildFiles: [ "LineView.m" ],
					systemFrameworks: { },
					includeHeader: 'LineView.h'
				},
				'info.appdoo-mac.LineView': {
					path: bp+'/PlugIns/LineView.cpsplugin',
					resources: [],
					buildFiles: [ "LineView.m" ],
					systemFrameworks: { },
					includeHeader: 'LineView.h'
				},
				'info.appdoo-mac.UIImageView+URL': {
					path: bp+'/PlugIns/UIImageView+URL.cpsplugin',
					resources: [],
					buildFiles: [
						"UIImageView+URL.m",
						"SDWebImage/NSData+ImageContentType.m",
						"SDWebImage/SDImageCache.m",
						"SDWebImage/SDWebImageCompat.m",
						"SDWebImage/SDWebImageDecoder.m",
						"SDWebImage/SDWebImageDownloader.m",
						"SDWebImage/SDWebImageDownloaderOperation.m",
						"SDWebImage/SDWebImageManager.m",
						"SDWebImage/SDWebImagePrefetcher.m",
						"SDWebImage/UIButton+WebCache.m",
						"SDWebImage/UIImage+GIF.m",
						"SDWebImage/UIImage+MultiFormat.m",
						"SDWebImage/UIImage+WebP.m",
						"SDWebImage/UIImageView+WebCache.m", 
						"SDWebImage/UIView+WebCacheOperation.m", 
					],
					headerFiles: [
						"UIImageView+URL.h",
						"SDWebImage/NSData+ImageContentType.h",
						"SDWebImage/SDImageCache.h",
						"SDWebImage/SDWebImageCompat.h",
						"SDWebImage/SDWebImageDecoder.h",
						"SDWebImage/SDWebImageDownloader.h",
						"SDWebImage/SDWebImageDownloaderOperation.h",
						"SDWebImage/SDWebImageManager.h",
						"SDWebImage/SDWebImagePrefetcher.h",
						"SDWebImage/UIButton+WebCache.h",
						"SDWebImage/UIImage+GIF.h",
						"SDWebImage/UIImage+MultiFormat.h",
						"SDWebImage/UIImage+WebP.h",
						"SDWebImage/UIImageView+WebCache.h",
						"SDWebImage/UIView+WebCacheOperation.h",
					],
					systemFrameworks: { "CoreGraphics": true, "ImageIO": true },
					includeHeader: 'UIImageView+URL.h',
					copyright: 'SDWebImage Copyright (c) 2009 Olivier Poitrey <rs@dailymotion.com>',
					licenceFile: 'SDWebImage/Licence.txt',
					licenceProductNames: 'SDWebImage',
				},
				'info.appdoo-mac.UILabelAutoSize': {
					path: bp+'/PlugIns/UILabelAutoSize.cpsplugin',
					resources: [],
					buildFiles: [ "UILabel+AutoSize.m" ],
					systemFrameworks: { },
					includeHeader: 'UILabel+AutoSize.h'
				},
				'info.appdoo-mac.UILabelHighlightedColorPre7': {
					path: bp+'/PlugIns/UILabelHighlightedColorPre7.cpsplugin',
					resources: [],
					buildFiles: [ "UILabel+HighlightedColorPre7.m" ],
					systemFrameworks: { },
				},
				'info.appdoo-mac.LayoutResolver': {
					path: bp+'/PlugIns/LayoutResolver.cpsplugin',
					resources: [],
					buildFiles: [ "LayoutResolver.m", "UIView+FindLowestSubview.m" ],
					systemFrameworks: { },
					includeHeader: 'LayoutResolver.h'
				},
				'info.appdoo-mac.SimpleScrollView': {
					path: bp+'/PlugIns/SimpleScrollView.cpsplugin',
					resources: [],
					buildFiles: [ "SimpleScrollView.m" ],
					systemFrameworks: { },
					includeHeader: 'SimpleScrollView.h'
				},
				'info.appdoo-mac.SimpleAudioPlayer': {
					path: bp+'/PlugIns/SimpleAudioPlayer.cpsplugin',
					resources: [],
					buildFiles: [ "SimpleAudioPlayer.m", "SimpleAudioPlayerDataProvider.m" ],
					systemFrameworks: { "AudioToolbox": true, "AVFoundation": true },
					includeHeader: 'SimpleAudioPlayer.h'
				},
				'info.appdoo-mac.SimpleHTMLView': {
					path: bp+'/PlugIns/SimpleHTMLView.cpsplugin',
					resources: [],
					buildFiles: [ "SimpleHTMLView.m", "NSURLImageProtocol.m" ],
					systemFrameworks: { },
					includeHeader: 'SimpleHTMLView.h',
					copyright: 'NSURLImageProtocol Copyright (c) 2013 Sufiyan Yasa. All rights reserved.',
					licenceFile: ''
				},






				
				'info.appdoo-mac.UINavigationBarDefaultTint': {
					description: 'A category for UINavigationBar that memorizes the global tint-property set in an Xcode 5 storyboard.',
					path: bp+'/PlugIns/UINavigationBarDefaultTint.cpsplugin',
					resources: [],
					buildFiles: [ "UINavigationBar+DefaultTint.m" ],
					systemFrameworks: { },
					includeHeader: 'UINavigationBar+DefaultTint.h'
				},
				'info.appdoo-mac.StatusBarBackgroundViewSystem6': {
					description: 'A category implementing ‘- setIsStatusBarBackgroundView:(BOOL)‘ for UIViews. Hides the view on iOS 6 and makes the sibling view full-screen.',
					path: bp+'/PlugIns/StatusBarBackgroundViewSystem6.cpsplugin',
					resources: [],
					buildFiles: [ "UIView+StatusBarBackgroundViewSystem6.m" ],
					systemFrameworks: { },
					includeHeader: 'UIView+StatusBarBackgroundViewSystem6.h'
				},
				'info.appdoo-mac.NSStringPunycodeAdditions': {
					description: 'Categories for NSString and NSURL that enable support for international domain names (IDN).',
					path: bp+'/PlugIns/NSStringPunycodeAdditions.cpsplugin',
					resources: [],
					buildFiles: [ "NSStringPunycodeAdditions.m" ],
					systemFrameworks: { },
					includeHeader: 'NSStringPunycodeAdditions.h',
					licenceFile: 'Licence.txt',
					licenceType: 'MIT',
					licenceProductNames: 'NSStringPunycodeAdditions',
					copyright: 'NSStringPunycodeAdditions Copyright 2005-2012 Derailer. All rights reserved.'
				},
				'info.appdoo-mac.UIAlertControllerAdditions': {
					description: 'Category for UIAlertController.',
					path: bp+'/PlugIns/UIAlertControllerAdditions.cpsplugin',
					resources: [],
					buildFiles: [ "UIAlertControllerAdditions.m" ],
					systemFrameworks: { },
					includeHeader: 'UIAlertControllerAdditions.h',
				},
				'info.appdoo-mac.UITabBarItemUnselectedImage': {
					description: 'Adds an `unselectedImageName`-property to UITabBarItem that only responds in iOS7+.',
					path: bp+'/PlugIns/UITabBarItemUnselectedImage.cpsplugin',
					resources: [],
					buildFiles: [ "UITabBarItem+UnselectedImageSystem7.m" ],
					systemFrameworks: { },
				},
				'info.appdoo-mac.DataSourceBase': {
					description: 'Provides a base class for various data sources including AtomDataSource, RSS2DataSource, CSVDataSource and JSONDataSource.',
					path: bp+'/PlugIns/DataSourceBase.cpsplugin',
					resources: [],
					buildFiles: [ "DataSourceBase.m" ],
					headerFiles: [ "DataSourceBase.h" ],
					systemFrameworks: { },
					localizedStringFiles: {"DataSourceBaseLocalized.strings": ["ar","bn","de","en","es","fr","hi","ja","pt","zh","it","nl","pl"] }
				},
				'info.appdoo-mac.NativeObjectPlaceholder': {
					description: 'Provides a placeholder for any object that can be instantiated in Objective-C.',
					path: bp+'/PlugIns/NativeObjectPlaceholder.cpsplugin',
					resources: [],
					
					systemFrameworks: { },
				},
				'info.appdoo-mac.SlideshowView': {
					description: 'Displays an interactive slide show.',
					path: bp+'/PlugIns/SlideshowView.cpsplugin',
					resources: [],
					buildFiles: [
						"SlideshowView.m",
						"MWCaptionView.m","MWPhoto.m","MWPhotoBrowser.m","MWTapDetectingImageView.m","MWTapDetectingView.m","MWZoomingScrollView.m",
					],
					includeHeader: 'SlideshowView.h',
					systemFrameworks: { "AssetsLibrary": true, "QuartzCore": true, "ImageIO": true, "MessageUI": true }
				},
				'info.appdoo-mac.ProgressView': {
					description: 'Displays a customizable progress view.',
					path: bp+'/PlugIns/ProgressView.cpsplugin',
					resources: [],
					buildFiles: [ "DACircularProgressView.m", "MBProgressHUD.m" ],
					systemFrameworks: { "QuartzCore": true, "CoreGraphics": true },
				},
				'info.appdoo-mac.Timer': {
					description: 'Triggers an action after a configurable time or interval',
					path: bp+'/PlugIns/Timer.cpsplugin',
					buildFiles: [ "Timer.m" ],
					includeHeader: 'Timer.h',
					resources: [],
				},
				'info.appdoo-mac.StaticCollectionViewDataSource': {
					path: bp+'/PlugIns/StaticCollectionViewDataSource.cpsplugin',
					resources: [],
					buildFiles: [ "StaticCollectionViewDataSource.m" ],
				},
				'info.appdoo-mac.UIViewControllerSharedMethods': {
					path: bp+'/PlugIns/UIViewControllerSharedMethods.cpsplugin',
					resources: [],
					buildFiles: [ "UIViewControllerSharedMethods.m" ],
					includeHeader: 'UIViewControllerSharedMethods.h',
				},
				'info.appdoo-mac.BindingsHandler': {
					path: bp+'/PlugIns/BindingsHandler.cpsplugin',
					resources: [],
					buildFiles: [ "BindingsHandler.m" ],
					includeHeader: 'BindingsHandler.h',
				},
				'info.appdoo-mac.SceneInputDataSource': {
					path: bp+'/PlugIns/SceneInputDataSource.cpsplugin',
					resources: [],
					buildFiles: [ "SceneInputDataSource.m" ],
					includeHeader: 'SceneInputDataSource.h',
				},
				'info.appdoo-mac.UIWebViewURLString': {
					path: bp+'/PlugIns/UIWebViewURLString.cpsplugin',
					resources: [],
					buildFiles: [ "UIWebView+URLString.m" ],
				},
				'info.appdoo-mac.WebViewDelegate': {
					path: bp+'/PlugIns/WebViewDelegate.cpsplugin',
					resources: [],
					buildFiles: [ "WebViewDelegate.m" ],
				},
				'info.appdoo-mac.WebViewDataProvider': {
					path: bp+'/PlugIns/WebViewDataProvider.cpsplugin',
					resources: [],
					buildFiles: [ "WebViewDataProvider.m" ],
					includeHeader: 'WebViewDataProvider.h',
				},
				'info.appdoo-mac.ButtonWithSubviews': {
					path: bp+'/PlugIns/ButtonWithSubviews.cpsplugin',
					resources: [],
					buildFiles: [ "ButtonWithSubviews.m" ],
					includeHeader: 'ButtonWithSubviews.h',
				},
				'info.appdoo-mac.UICollectionViewSelectedItem': {
					path: bp+'/PlugIns/UICollectionViewSelectedItem.cpsplugin',
					resources: [],
					buildFiles: [ "UICollectionView+SelectedItemIndex.m", "CollectionViewDelegate.m" ],
					includeHeader: 'CollectionViewDelegate.h',
				},
				'info.appdoo-mac.FormProcessor': {
					path: bp+'/PlugIns/FormProcessor.cpsplugin',
					resources: [],
					buildFiles: [ "FormProcessor.m" ],
					includeHeader: 'FormProcessor.h',
				},
				'info.appdoo-mac.PickerViewDataSource': {
					path: bp+'/PlugIns/PickerViewDataSource.cpsplugin',
					resources: [],
					buildFiles: [ "PickerViewDataSource.m", "PickerViewDataProvider.m" ],
					includeHeader: 'PickerViewDataSource.h',
				},
				'info.appdoo-mac.AlertViewGenerator': {
					path: bp+'/PlugIns/AlertViewGenerator.cpsplugin',
					resources: [],
					buildFiles: [ "AlertViewGenerator.m" ],
					includeHeader: 'AlertViewGenerator.h',
				},
				'info.appdoo-mac.TextFieldDelegate': {
					path: bp+'/PlugIns/TextFieldDelegate.cpsplugin',
					resources: [],
					buildFiles: [ "TextFieldDelegate.m" ],
					includeHeader: 'TextFieldDelegate.h',
				},
				'info.appdoo-mac.TextViewDelegate': {
					path: bp+'/PlugIns/TextViewDelegate.cpsplugin',
					resources: [],
					buildFiles: [ "TextViewDelegate.m" ],
					includeHeader: 'TextViewDelegate.h',
				},
				'info.appdoo-mac.SegmentedControlDataLinks': {
					path: bp+'/PlugIns/SegmentedControlDataLinks.cpsplugin',
					resources: [],
					buildFiles: [ "SegmentedControlDataLinks.m" ],
				},
				'info.appdoo-mac.UISegmentedControl+TitleTextAttributesString': {
					path: bp+'/PlugIns/UISegmentedControl+TitleTextAttributesString.cpsplugin',
					buildFiles: [ "UISegmentedControl+TitleTextAttributesString.m" ],
				},
				'info.appdoo-mac.UIButton+Text': {
					path: bp+'/PlugIns/UIButton+Text.cpsplugin',
					buildFiles: [ "UIButton+Text.m" ],
				},
				'info.appdoo-mac.SegmentedControlDataProvider': {
					path: bp+'/PlugIns/SegmentedControlDataProvider.cpsplugin',
					buildFiles: [ "SegmentedControlDataProvider.m" ],
					includeHeader: 'SegmentedControlDataProvider.h',
				},
				'info.appdoo-mac.SliderDataProvider': {
					path: bp+'/PlugIns/SliderDataProvider.cpsplugin',
					buildFiles: [ "SliderDataProvider.m" ],
					includeHeader: 'SliderDataProvider.h',
				},
				'info.appdoo-mac.SwitchDataProvider': {
					path: bp+'/PlugIns/SwitchDataProvider.cpsplugin',
					buildFiles: [ "SwitchDataProvider.m" ],
					includeHeader: 'SwitchDataProvider.h',
				},
				'info.appdoo-mac.StepperDataProvider': {
					path: bp+'/PlugIns/StepperDataProvider.cpsplugin',
					buildFiles: [ "StepperDataProvider.m" ],
					includeHeader: 'StepperDataProvider.h',
				},
				'info.appdoo-mac.ActivityViewGenerator': {
					path: bp+'/PlugIns/ActivityViewGenerator.cpsplugin',
					buildFiles: [ "ActivityViewGenerator.m" ],
					includeHeader: 'ActivityViewGenerator.h',
				},
				'info.appdoo-mac.FileURLHelper': {
					path: bp+'/PlugIns/FileURLHelper.cpsplugin',
					buildFiles: [ "FileURLHelper.m" ],
					includeHeader: 'FileURLHelper.h',
				},
				'info.appdoo-mac.UIViewFontNameAndSizeProperty': {
					path: bp+'/PlugIns/UIViewFontNameAndSizeProperty.cpsplugin',
					buildFiles: [ "UIViewFontNameAndSizeProperty.m" ],
				},
				'info.appdoo-mac.SimpleAnimation': {
					path: bp+'/PlugIns/SimpleAnimation.cpsplugin',
					buildFiles: [ "SimpleAnimation.m" ],
					includeHeader: 'SimpleAnimation.h',
					systemFrameworks: { "QuartzCore": true, "CoreGraphics": true }
				},
				'info.appdoo-mac.OutletCollectionExtensions': {
					path: bp+'/PlugIns/OutletCollectionExtensions.cpsplugin',
					buildFiles: [ "OutletCollectionExtensions.m" ],
				},
				'info.appdoo-mac.EditableObjectContainer': {
					path: bp+'/PlugIns/EditableObjectContainer.cpsplugin',
					buildFiles: [ "EditableObjectContainer.m", ],
					includeHeader: 'EditableObjectContainer.h'
				},
				'info.appdoo-mac.JavaScriptContainer': {
					path: bp+'/PlugIns/JavaScriptContainer.cpsplugin',
					buildFiles: [ "JavaScriptContainer.m", ],
					includeHeader: 'JavaScriptContainer.h',
					systemFrameworks: { "JavaScriptCore": true },
				},
				'info.appdoo-mac.ImagePicker': {
					path: bp+'/PlugIns/ImagePicker.cpsplugin',
					buildFiles: [ "ImagePicker.m", ],
					includeHeader: 'ImagePicker.h',
					localizedStringFiles: {"ImagePickerLocalized.strings": ["ar","bn","de","en","es","fr","hi","ja","pt","zh","it","nl","pl"] },
				},

				'info.appdoo-mac.ObjectProxy': {
					path: bp+'/PlugIns/ObjectProxy.cpsplugin',
					buildFiles: [ "ObjectProxy.m", ],
					includeHeader: 'ObjectProxy.h',
				},
				'info.appdoo-mac.DocumentViewer': {
					"UTI":"info.appdoo-mac.GenericViewPlugIn",
					"isView":true,
					"cocoaCustomType":"DocumentViewer",
					"providesNavigation":true,
					"takesFullSpace":true,
					"minimumAppdooBuildVersion":361,
					"path":bp+"/PlugIns/DocumentViewer.cpsplugin",
					"outlineIconURL":bp+"/PlugIns/DocumentViewer.cpsplugin/Editor/DocumentViewer.png",
					"icon":bp+"/PlugIns/DocumentViewer.cpsplugin/Editor/DocumentViewer48.png",
					"cocoaType":"UIView",
					"properties":{
						"propertyValues":{},
						"pluginVersion":1,
						"pluginIdentifier":"info.appdoo-mac.DocumentViewer"
					},
					"objectProperties":[
						{
							"localizedName":LocalizedString("Document URLs"),
							"multiple":true,
							"contentTypes":this.supportedOfficeMimeTypes,
							"key":"documentURLs",
							"type":"fileReference",
							"bindable":true,
							"numberOfVisibleItems":4,
							"labelOnTop":true,
							"name":"Document URLs",
							"keyPath":"propertyValues.documentURLs",
							"dataKeyPath":"documentURLs"
						},
						{
							"key":"viewController",
							"type":"currentViewController",
							"hidden":true,
							"keyPath":"propertyValues.viewController",
							"dataKeyPath":"viewController"
						}
					],
					"name":LocalizedString("Document View"),
					"description":LocalizedString("Displays images, PDFs, iWork or Office documents"),
					"resources":[],
					"pluginIdentifier":"info.appdoo-mac.DocumentViewer",
					"pluginVersion":1,
					"requiresPreviewBuildVersion": 8,
					"includeHeader":"DocumentViewer.h",
					"buildFiles":["DocumentViewer.m"],
					"systemFrameworks":{"QuickLook":true}
				},
				'info.appdoo-mac.PhotoZoom': 		{
					"isView": true,
					"cocoaCustomType": "PhotoZoom",
					"UTI": "info.appdoo-mac.GenericViewPlugIn",
					"providesNavigation": true,
					"takesFullSpace": true,
					"minimumAppdooBuildVersion": 361,
					"icon": bp+"/PlugIns/PhotoZoom.cpsplugin/Editor/PhotoZoom48.png",
					"outlineIconURL": bp+"/PlugIns/PhotoZoom.cpsplugin/Editor/PhotoZoom48.png",
					"iconURL": bp+"/PlugIns/PhotoZoom.cpsplugin/Editor/PhotoZoom48.png",
					"path": bp+"/PlugIns/PhotoZoom.cpsplugin",
					"cocoaType": "UIView",
					"properties": {
						"propertyValues": {
							"imageURLs": {
								"source": "local"
							},
							"spaceBetweenImages": 40
						},
						"pluginVersion": 1,
						"pluginIdentifier": "info.appdoo-mac.PhotoZoom"
					},
					"objectProperties": [
						{
							"localizedName":LocalizedString("Image URLs"),
							"multiple": true,
							"key": "imageURLs",
							"bindable": true,
							"type": "imageURL",
							"name": "Image URL",
							"keyPath": "propertyValues.imageURLs",
							"dataKeyPath": "imageURLs"
						},
						{
							"key": "spaceBetweenImages",
							"type": "number",
							"hidden": true,
							"keyPath": "propertyValues.spaceBetweenImages",
							"dataKeyPath": "spaceBetweenImages"
						},
						{
							"key": "viewController",
							"type": "currentViewController",
							"hidden": true,
							"keyPath": "propertyValues.viewController",
							"dataKeyPath": "viewController"
						},
						{
							"key": "inputDataSource",
							"type": "currentInputDataSource",
							"hidden": true,
							"keyPath": "propertyValues.inputDataSource",
							"dataKeyPath": "inputDataSource"
						},
						{
							"key": "bindingsInfoString",
							"type": "bindingsInfoString",
							"hidden": true,
							"keyPath": "propertyValues.bindingsInfoString",
							"dataKeyPath": "bindingsInfoString"
						}
					],
					"name": LocalizedString("Photo Slider"),
					"description": LocalizedString("A view for photos with swipe and zoom"),
					"resources": [],
					"isUserPlugIn": true,
					"requiresPreviewBuildVersion": 8,
					"pluginIdentifier": "info.appdoo-mac.PhotoZoom",
					"pluginVersion": 1,
					"includeHeader": "PhotoZoom.h",
					"buildFiles": [
						"PhotoZoom.m",
						"PhotoZoomImageViewController.m",
						"PhotoZoomImageViewController.xib"
					],
					"systemFrameworks": {
						"CoreGraphics": true
					},
					licenceFile: "",
					licenceProductNames: 'PhotoZoom',
					licenceType: 'BSD',
				},
				'info.appdoo-mac.Drawables': {
					path: bp+'/PlugIns/Drawables.cpsplugin',
					resources: [],
					buildFiles: [
						"Drawables.m"
					],
					includeHeader: 'Drawables.h',
					"systemFrameworks":{"CoreGraphics":true}
				},
				'info.appdoo-mac.FormattedTextContainer': {
					path: bp+'/PlugIns/FormattedTextContainer.cpsplugin',
					resources: [],
					buildFiles: [
						"FormattedTextContainer.m"
					],
					includeHeader: 'FormattedTextContainer.h'
				},
			};
		
		var userPlugIns = JSON.parse(this.nativeProxy.sendMessage('userPlugInsInfo'));
		window.userPlugIns = [];
		
		if (Array.isArray(userPlugIns)) userPlugIns.every(function (plugIn) {
			var pluginIdentifier = plugIn.pluginIdentifier || plugIn.UTI;
			
			
			if (availablePlugins[pluginIdentifier]) return true;

			availablePlugins[pluginIdentifier] = plugIn;
			window.userPlugIns.push(plugIn);return true; }, this);
		
};
	


	
	
	
appdoo.prototype.exportToXcode = function appdoo_exportToXcode() {

		this.callWhenResourcesAreLoaded(function () {
		
			if (this.editor) this.editor.saveItem();
            
            
            var metadata = this.projectMetadataController.contents;
            var buildNumber = parseInt(metadata.build);
            buildNumber += 1;
            this.projectMetadataController.contents.build = buildNumber.toString();
            
			var projectData = this.collectProjectData(),
				projectDataJSON = JSON.stringify(projectData);
			this.nativeProxy.sendMessage('generateXcodeProject', projectDataJSON);
			
		}.bind(this), iOSGeneratorResources);
	};
	

	
appdoo.prototype.generateApplicationFiles = function appdoo_generateApplicationFiles(optionsAsJSON) {
	
		var options = JSON.parse(optionsAsJSON);
	
		if (this.editor !== undefined)
			this.editor.saveItem();
		
		try {
			var generator = createComponentFromDomain(
				'iOSAppGenerator', 'appdoo.iOSGenerator', this, options);
		
			return generator.generateFromData(options.projectData);
		} catch (err) {
			setTimeout(function () {
			
				this.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
					message: LocalizedString("Sorry, something went wrong when trying to export the project. Please contact the support for further assistance."),
					details: LocalizedString1("Error: %1", (err.message+' in '+componentNameFromSourceURL(err.sourceURL)+', line '+err.line+', stack: '+err.stack))
				}));
				if (this.isDebugging)
					throw err;
			}.bind(this), 1000);
			 console.log(err);
		}
};
	


	
	
appdoo.prototype.parseProjectData = function appdoo__parseProjectData(JSONString) {
		var projectData = JSON.parse(JSONString);
		projectData = this.checkCompatibility(projectData);
		return projectData;};
	

appdoo.prototype.checkCompatibility = function appdoo__checkCompatibility(projectData) {
		var formatVersion = projectData.metadata.formatVersion ||
							projectData.metadata.editorVersion ||
							28;
		
		if (formatVersion < kFormatVersion) {
			
			var methodName;
			for (var i = formatVersion+1; i <= kFormatVersion; i++) {
				
				methodName = 'transformProjectData_'+i;

				if (this[methodName])
					projectData = this[methodName](projectData);
			}
		}
		
		return projectData;};
			

appdoo.prototype.transformProjectData_29 = function appdoo__transformProjectData_29(projectData) {
		var JSONString = JSON.stringify(projectData);
		
		JSONString = JSONString.replace(/AppStudio/g, 'appdoo');
		return JSON.parse(JSONString);};
	
	
appdoo.prototype.transformProjectData_30 = function appdoo__transformProjectData_30(projectData) {
	
		
		
		

		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (instance.type === 'UIViewController') {
				if (instance.navigationBarType === 'colored')
					instance.navigationBarType = 'custom';
				instance.navigationBarTitleLabelFontName = projectData.metadata.globalTitleBarFontFamily;
				instance.navigationBarTitleLabelFontSize = projectData.metadata.globalTitleBarFontSize;
				instance.navigationBarTitleLabelOffset = projectData.metadata.globalTitleBarLabelOffsetY;
			}return true; }, this);
		

		projectData.metadata.viewControllerGlobals = {
			navigationBarType: 'default'
		};
		delete projectData.metadata.globalTitleBarFontFamily;
		delete projectData.metadata.globalTitleBarFontSize;
		delete projectData.metadata.globalTitleBarLabelOffsetY;

		return projectData;};
	

appdoo.prototype.transformProjectData_33 = function appdoo__transformProjectData_33(projectData) {
		var JSONString = JSON.stringify(projectData);

		
		JSONString = JSONString.replace(/destinationKeypath/g, 'destinationKeyPath');
		
		return JSON.parse(JSONString);};
	

appdoo.prototype.transformProjectData_42 = function appdoo__transformProjectData_42(projectData) {

		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (!instance.view) return true;
			instance.view.type = 'UIViewGroup';
			if (instance.view.subviews) {
				if (Array.isArray(instance.view.subviews)) instance.view.subviews.every(function (subview) {

					
					if (subview.cellPrototypeData) {
						subview.cellPrototype = subview.cellPrototypeData;
						subview.cellPrototype.type = 'CollectionViewCellContentView';
						delete subview.cellPrototypeData;
					}
					
					if (subview.rowTemplate) {
						subview.cellPrototype = subview.rowTemplate;
						subview.cellPrototype.type = 'TableViewCellContentView';
						delete subview.rowTemplate;
					}
					if (subview.listHeaderView) {
						subview.listHeaderView.type = 'TableViewHeaderView';
						if (subview.listHeaderView.style)
							delete subview.listHeaderView.style.pointerEvents;
					}
					if (subview.listFooterView) {
						subview.listFooterView.type = 'TableViewFooterView';
						if (subview.listFooterView.style)
							delete subview.listFooterView.style.pointerEvents;
					}

					if (subview.cellPrototype) {
						if (subview.cellPrototype.style)
							delete subview.cellPrototype.style.pointerEvents;
					}
					
					
					if (subview.type === 'ASStaticTableView' ||
						subview.type === 'ASFeedTableView') {
						subview.type = 'UITableView';
					}
					return true; }, this);
				
			}return true; }, this);
		
		
		return projectData;};
	

appdoo.prototype.transformProjectData_43 = function appdoo__transformProjectData_43(projectData) {

		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (instance.type !== 'UIViewController') return true;
			
			if (instance.previewSize)
				instance.previewSize.height -= 20; 
			else
				instance.previewSize = { "height": 548, "width": 320 };return true; }, this);
		
		
		return projectData;};
	
	
appdoo.prototype.transformProjectData_46 = function appdoo__transformProjectData_46(projectData) {
	
		
		

		var updateSubview = function (subview) {

			if (['UILabel', 'Hyperlink', 'ASSimpleHTMLView'].indexOf(subview.type) !== -1 && !subview.fontName) {
				subview.fontName = subview.fontFamily;
				subview.fontFamily = fontFamilyNameForFontNamed(subview.fontFamily);
			}
		
			if (subview.subviews)
			if (Array.isArray(subview.subviews)) subview.subviews.every(function (_subview) {
				updateSubview(_subview);return true; }, this);
			

			if (subview.cellPrototype)
				updateSubview(subview.cellPrototype);

			if (subview.listHeaderView)
				updateSubview(subview.listHeaderView);

			if (subview.listFooterView)
				updateSubview(subview.listFooterView);
		}

		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (!instance.view) return true;

			if (instance.view.subviews)
			if (Array.isArray(instance.view.subviews)) instance.view.subviews.every(function (subview) {
				updateSubview(subview);return true; }, this);
			return true; }, this);
		
		
		return projectData;};
	

appdoo.prototype.transformProjectData_51 = function appdoo__transformProjectData_51(projectData) {

		

		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (!instance.view) return true;
			
			if (instance.navigationItemTitleViewImageID) {
				instance.navigationItemTitleViewImage = { type: 'ImageReference', domain: 'appdoo', imageID: instance.navigationItemTitleViewImageID };
				delete instance.navigationItemTitleViewImageID;
			}

			if (instance.navigationBarBackgroundImageID) {
				instance.navigationBarBackgroundImage = { type: 'ImageReference', domain: 'appdoo', imageID: instance.navigationBarBackgroundImageID };
				delete instance.navigationBarBackgroundImageID;
			}

			if (instance.tabBarIcon) {
				
				
				var oldID = instance.tabBarIcon;
				instance.tabBarIconImage = { type: 'ImageReference', domain: 'appdoo', imageID: oldID+'@2x' };
				setTimeout(function () { this.projectContext.unregisterImageWithID(oldID); }.bind(this));
				delete instance.tabBarIcon;
			}
			
			updateSubviewsWithCallback(instance.view, function (subview) {
				if (['UIImageView', 'ASImageView'].indexOf(subview.type) !== -1 && subview.imageID) {
					subview.imageRef = { type: 'ImageReference', domain: 'appdoo', imageID: subview.imageID };
					delete subview.imageID;
				}
			});
return true; }, this);
		

		if (projectData.metadata.viewControllerGlobals.navigationBarBackgroundImageID) {
			projectData.metadata.viewControllerGlobals.navigationBarBackgroundImage = { type: 'ImageReference', domain: 'appdoo', imageID: projectData.metadata.viewControllerGlobals.navigationBarBackgroundImageID };
			delete projectData.metadata.viewControllerGlobals.navigationBarBackgroundImageID;
		}

		if (projectData.metadata.iconImageID) {
			var oldID = projectData.metadata.iconImageID;
			projectData.metadata.iconImage = { type: 'ImageReference', domain: 'appdoo', imageID: projectData.metadata.iconImageID+'-AppStore' };
			setTimeout(function () {
				this.projectContext.unregisterImageWithID(oldID);
				this.projectContext.unregisterImageWithID(oldID+'@2x');
			}.bind(this));
			delete projectData.metadata.iconImageID;
		}

		return projectData;};
	

appdoo.prototype.transformProjectData_53 = function appdoo__transformProjectData_53(projectData) {

		
		
		
		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (!instance.view) return true;

			updateSubviewsWithCallback(instance.view, function (subview) {
				if (subview.style) {
					delete subview.style.pointerEvents;
				}
			});
return true; }, this);
		


		return projectData;};
	

appdoo.prototype.transformProjectData_54 = function appdoo__transformProjectData_54(projectData) {

		
		
		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (!instance.view) return true;

			if (instance.navigationBarType === 'hidden') {
				instance.navigationBarType = 'default';
				instance.navigationBarIsVisible = false;
			}
			else {
				instance.navigationBarIsVisible = true;
			}
return true; }, this);
		


		return projectData;};
	

appdoo.prototype.transformProjectData_55 = function appdoo__transformProjectData_55(projectData) {

		
		
		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (!instance.view) return true;

			instance.navigationItem = {
				type: 'UINavigationItem',
				domain: 'appdoo.iOS',
				leftBarButtonItem: instance.navigationItemLeftBarButtonItem,
				rightBarButtonItem: instance.navigationItemRightBarButtonItem,
				v_titleViewImage: instance.navigationItemTitleViewImage
			};
			
			delete instance.navigationItemLeftBarButtonItem;
			delete instance.navigationItemRightBarButtonItem;
			delete instance.navigationItemTitleViewImage;
			
			
return true; }, this);
		


		return projectData;};
	

appdoo.prototype.transformProjectData_56 = function appdoo__transformProjectData_56(projectData) {

		
		
		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {

			if (!instance.view) return true;
			
			updateSubviewsWithCallback(instance.view, function (subview) {
				if (subview.type === 'ASRemoteImageView')
					subview.type = 'UIImageView_URI';
				if (subview.type === 'ASImageView')
					subview.type = 'UIImageView';
			});
return true; }, this);
		
		
		return projectData;};
	

appdoo.prototype.transformProjectData_57 = function appdoo__transformProjectData_57(projectData) {
	
		function updateDomain(instance) {
			if (!instance) return;
			if (!instance.domain) {
				 console.warn('no domain? will delete.', instance);
				return false;
			}
			if (instance.domain.indexOf('Compose') === 0) {
				instance.domain = instance.domain.replace(/Compose/, 'appdoo');
			}
			return true;
		}

		
		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (!updateDomain(instance)) {
				projectData.instances.splice(projectData.instances.indexOf(instance), 1);
				return true;
			}

			if (instance.navigationItem) {
				var propertiesToUpdate = ['leftBarButtonItem','rightBarButtonItem','v_titleViewImage'];
				if (Array.isArray(propertiesToUpdate)) propertiesToUpdate.every(function (p) {
					updateDomain(instance.navigationItem[p]);return true; }, this);
				
			}
			updateDomain(instance.navigationBarBackgroundImage);
			updateDomain(instance.tabBarIconImage);

			
			if (!instance.view) return true;
			updateSubviewsWithCallback(instance.view, function (subview) {
				updateDomain(subview);
				if (subview.imageRef)
					updateDomain(subview.imageRef);
			});return true; }, this);
		
		
		updateDomain(projectData.metadata.viewControllerGlobals.navigationBarBackgroundImage);
		
		return projectData;
	};
	

appdoo.prototype.transformProjectData_58 = function appdoo__transformProjectData_58(projectData) {
		
		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (instance.view) {
				instance.view.type = 'ViewGroup';
				updateSubviewsWithCallback(instance.view, function (subview) {
					if (subview.type === 'UIViewGroup')
						subview.type = 'ViewGroup';
				});
			}return true; }, this);
		
		return projectData;};
	

appdoo.prototype.transformProjectData_59 = function appdoo__transformProjectData_59(projectData) {
	
		var i = 1;
		
		
		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (!instance.view) return true;
			
			instance.view.v_scrollsVertically = instance.contentCanScrollVertically;

			instance.viewController = {
				type: 'UIViewController',
				domain: 'appdoo.iOS',
				view: instance.view,
				title: instance.title,
				id: instance.id
			};
			
			
			if (instance.tabBarControllerId) {
				instance.viewController.tabBarItem = {
					type: 'UITabBarItem',
					domain: 'appdoo.iOS',
					title: instance.tabBarItemTitle || instance.title,
					image: instance.tabBarIconImage
				};
			}
			
			instance.navigationBar = {
				type: 'UINavigationBar',
				domain: 'appdoo.iOS',
				hidden: (instance.navigationBarType == 'none'),
				items: [ instance.navigationItem ],
				tintColor: (instance.navigationBarType === 'custom') ? instance.navigationBarTintColor : '',
				barStyle: UIBarStyleDefault,
				v_usesGlobalAppearance: instance.usesGlobalNavigationBarAppearance,
				v_backgroundImage: instance.navigationBarBackgroundImage,
				v_titleViewImage: instance.navigationItemTitleViewImage,
			};
			
			if (instance.navigationItem.leftBarButtonItem)
				instance.navigationItem.leftBarButtonItem.domain = 'appdoo.iOS';
			
			delete instance.view;
			delete instance.title;
			delete instance.navigationItem;
			delete instance.navigationBarIsVisible;
			delete instance.navigationBarType;
			delete instance.navigationBarTintColor;
			delete instance.navigationBarBackgroundImage;
			delete instance.navigationBarTitleLabelFontName;
			delete instance.navigationBarTitleLabelFontSize;
			delete instance.tabBarIconImage;
			delete instance.tabBarItemTitle;
			delete instance.usesGlobalNavigationBarAppearance;
			
			instance.type = 'Scene';
			instance.id = 'Scene'+i;

			
			instance.viewController.view.isExpandedInEditorOutline = true;
			instance.navigationObjectsNodeIsExpandedInEditorOutline = true;
			instance.sceneObjectsNodeIsExpandedInEditorOutline = true;
			
			i++;
			return true; }, this);
		
		
		
		projectData.metadata.navigationBarGlobals = projectData.metadata.viewControllerGlobals;
		delete projectData.metadata.viewControllerGlobals;
		delete projectData.metadata.editorVersion;
		if (!projectData.metadata.editorAppearance) projectData.metadata.editorAppearance = {};
		projectData.metadata.editorAppearance.globalObjectsNodeIsExpandedInEditorOutline = true;
		
		return projectData;};
	
	
appdoo.prototype.transformProjectData_60 = function appdoo__transformProjectData_60(projectData) {
		function updateView(view) {
			if (!view) return;
			if (view.style) {
				if (view.style.backgroundColor)
					view.backgroundColor = view.style.backgroundColor;
				if (view.style.overflow)
					view.clipsSubviews = (view.style.overflow === 'hidden');
				if (view.style.textAlign)
					view.textAlignment = view.style.textAlign;
				
				delete view.style;
				
			}
		}
	
		
		if (Array.isArray(projectData.instances)) projectData.instances.every(function (instance) {
			if (instance.viewController) {
				updateSubviewsWithCallback(instance.viewController.view, function (subview) {
					updateView(subview);
				});
			}return true; }, this);
		

		return projectData;};
	

appdoo.prototype.transformProjectData_61 = function appdoo__transformProjectData_61(projectData) {
		var JSONString = JSON.stringify(projectData);
		JSONString = JSONString.replace(/\"type\"\:/g, '"$type":');
		JSONString = JSONString.replace(/\"domain\"\:/g, '"$domain":');
		JSONString = JSONString.replace(/\"id\"\:/g, '"$id":');
		return JSON.parse(JSONString);};
	

appdoo.prototype.transformProjectData_63 = function appdoo__transformProjectData_63(projectData) {
		projectData.$type = 'Projekt';
		projectData.$domain = 'appdoo';
		projectData.scenes = projectData.instances;
		delete projectData.instances;
		return projectData;};
	

appdoo.prototype.transformProjectData_64 = function appdoo__transformProjectData_64(projectData) {
		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			if (scene.tabBarControllerId) {
				scene.v_showsInTabBar = true;
			}return true; }, this);
		

		return projectData;};
	

appdoo.prototype.transformProjectData_65 = function appdoo__transformProjectData_65(projectData) {

		var JSONString = JSON.stringify(projectData);
		JSONString = JSONString.replace(/appdoo.DataSources/g, 'info.appdoo');
		projectData = JSON.parse(JSONString);

		if (!projectData.objects)
			projectData.objects = [];
		else
			return projectData;
		
		function sortInDataSource(ds) {
		
			var sceneToSortIn;
		
			if (Array.isArray(clone(projectData.scenes))) clone(projectData.scenes).every(function (scene) {
				if (!scene.viewController) return true;
				if (Array.isArray(scene.viewController.view.subviews)) scene.viewController.view.subviews.every(function (subview) {
					if (subview.dataSourceId === ds.$id) {
						sceneToSortIn = scene;
						return false;
					}return true; }, this);
				
				if (sceneToSortIn) return false;return true; }, this);
			
			
			if (!sceneToSortIn) {
				 console.warn('A data source was removed from the project because it is not used.', ds);
				return;
			}
			
			if (!sceneToSortIn.objects) sceneToSortIn.objects = [];
			sceneToSortIn.objects.push(ds);

		}
	
		if (Array.isArray(clone(projectData.scenes))) clone(projectData.scenes).every(function (scene) {

			
			if (scene.$type !== 'Scene' &&
				scene.$type !== 'UITabBarController') {
				projectData.scenes.splice(
					projectData.scenes.indexOf(scene), 1);
				sortInDataSource(scene);
				return true;
			}
				
			
			if (scene.viewController) {
				updateSubviewsWithCallback(scene.viewController.view, function (subview) {
					
					if (subview && subview.dataSource) {
						if (!scene.objects) scene.objects = [];
						scene.objects.push(subview.dataSource);
						subview.dataSourceId = subview.dataSource.$id;
						delete subview.dataSource;
					}
					
				});
			}return true; }, this);
		

		return projectData;};
	

appdoo.prototype.transformProjectData_66 = function appdoo__transformProjectData_66(projectData) {
		if (Array.isArray(clone(projectData.scenes))) clone(projectData.scenes).every(function (scene) {
			if (scene.$type !== 'Scene') {
				
				if (scene.$type === 'UITabBarController') {
					projectData.tabBarController = scene;
				}
			
				projectData.scenes.splice(
					projectData.scenes.indexOf(scene), 1);
			}return true; }, this);
		
	
		return projectData;};
	

appdoo.prototype.transformProjectData_67 = function appdoo__transformProjectData_67(projectData) {

		var JSONString = JSON.stringify(projectData);
		JSONString = JSONString.replace(/UIImageView_URI/g, 'UIImageViewWithURL');
		JSONString = JSONString.replace(/resource:/g, 'file:');
		projectData = JSON.parse(JSONString);
		
		return projectData;
};
	

appdoo.prototype.transformProjectData_68 = function appdoo__transformProjectData_68(projectData) {

		
		var nativeProxy = this.nativeProxy;
		
		function updateObjects(objects) {
			if (Array.isArray(objects)) objects.every(function (obj) {
				if (obj.$type === 'SQLite3DataSource') {
					obj.$type = 'CSVDataSource';
					obj.$domain = 'info.appdoo';
					obj.location = 'local';
					obj.localData = nativeProxy.sendMessage('getCSVDataFromLegacyFile', obj.$id);
				}return true; }, this);
			
		}
		

		if (Array.isArray(clone(projectData.scenes))) clone(projectData.scenes).every(function (scene) {
			updateObjects(scene.objects);return true; }, this);
		
		updateObjects(projectData.objects);

		if (Array.isArray(projectData.media)) projectData.media.every(function (mediaItem) {
		
			var fileExtension = mediaItem.contentType.split('/')[1];
			
			projectData.objects.push({
				$type: 'ResourceReference',
				$domain: 'appdoo',
				resourceID: mediaItem.$id+'.'+fileExtension,
				name: mediaItem.name,
				size: mediaItem.size,
				lastModified: mediaItem.lastModified,
				contentType: mediaItem.contentType
			});
return true; }, this);
		

		return projectData;};
	
	
appdoo.prototype.transformProjectData_69 = function appdoo__transformProjectData_69(projectData) {

		if (projectData.tabBarController) {
			projectData.tabBarController.viewControllerIDs = 
			projectData.tabBarController.viewControllerIds;
			delete projectData.tabBarController.viewControllerIds;
			
			projectData.tabBarController.tabBar = {
				$type: "UITabBar",
				$domain: "appdoo.iOS",
				size: { width: 320 },
				barStyle: (projectData.tabBarController.tabBarBarStyle === 'black') ? UIBarStyleBlack : UIBarStyleDefault,
				tintColor: projectData.tabBarController.tabBarTintColor
			};
		}
	
		return projectData;};
	

	function sceneFromVCID(vcid, scenes) {
		var result;
		if (Array.isArray(scenes)) scenes.every(function (scene) {
			if (scene && scene.viewController && scene.viewController.$id === vcid) {
				result = scene;
				return false;
			}return true; }, this);
		
		return result;
	}

appdoo.prototype.transformProjectData_70 = function appdoo__transformProjectData_70(projectData) {

		function sceneIDFromVCID(vcid) {
			var scene = sceneFromVCID(vcid, projectData.scenes);
			if (scene) return scene.$id;
		}
		
		function updateDetailSceneBindings(bindings, scene) {
			if (Array.isArray(bindings)) bindings.every(function (binding) {
				binding.destination = scene.$id+'InputData';
				binding.destinationKeyPath = 'contents.'+binding.destinationKeyPath;
				delete binding.hasDynamicContext;return true; }, this);
			
		}


		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			if (!scene.viewController) return true;
			
			
			scene.viewController.viewData = scene.viewController.view; 
			delete scene.viewController.view;return true; }, this);
		
		
		
		
		if (projectData.metadata.navigationBarGlobals) {
			var g = projectData.metadata.navigationBarGlobals;
			
			if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			
				if (!scene.navigationBar) return true;

				if (scene.navigationBar.v_usesGlobalAppearance) {
					scene.navigationBar.v_backgroundImage = g.navigationBarBackgroundImage;
					scene.navigationBar.tintColor = g.navigationBarTintColor;
					scene.navigationBar.translucent = (g.navigationBarType === 'translucent');
					delete scene.navigationBar.v_usesGlobalAppearance;
				}
				
				var bindingsRelateToContextData = !!scene.masterViewControllerId;

				if (bindingsRelateToContextData) {
					updateDetailSceneBindings(scene.bindings, scene);
					if (!scene.objects) scene.objects = [];
					scene.objects.push({
					  "$id" : scene.$id+"InputData",
					  "location" : "local",
					  "$type" : "SceneInputDataSource",
					  "$domain" : "appdoo"
					})
				}

				updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {

					
					if (subview.detailViewControllerId) {
						subview.detailSceneID = sceneIDFromVCID(subview.detailViewControllerId);
					}
					
					
					
					if (bindingsRelateToContextData) {
						updateDetailSceneBindings(subview.bindings, scene);
					}

					
					if (Array.isArray(subview.layoutRelations)) subview.layoutRelations.every(function (lr) {
						lr.type = lr.$type;
						delete lr.$type;return true; }, this);
					
				});return true; }, this);
			

			delete projectData.metadata.navigationBarGlobals;
		}

		
		projectData.metadata.simulatedSystemVersion = 6;
	
		return projectData;};
	

appdoo.prototype.transformProjectData_71 = function appdoo__transformProjectData_71(projectData) {
	
		function viewIDForSegueInScene(segue, scene) {
			
			var result;
			updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {
				if (subview && subview.detailSceneID === segue.destinationSceneID) {
					result = subview;
					return false;
				}
			});
			if (result) return result.$id;
			return '';
		
		}
	
		if (Array.isArray(clone(projectData.scenes))) clone(projectData.scenes).every(function (scene) {
		
			
			if (!scene.viewController) {
				 console.warn('Removed a scene without a view controller.');
				projectData.scenes.splice(projectData.scenes.indexOf(scene), 1);
				return true;
			}
			
			if (Array.isArray(clone(scene.segues))) clone(scene.segues).every(function (segue) {
			
				
				var s = sceneFromVCID(segue.destination, projectData.scenes);
				if (!s) {
					scene.segues.splice(scene.segues.indexOf(segue), 1);
					return true;
				}

				segue.$type = 'Segue';
				segue.$domain = 'appdoo.iOS';
				segue.destinationSceneID = s.$id;
				segue.viewID = viewIDForSegueInScene(segue, scene);return true; }, this);
			return true; }, this);
		

		this.arrangeScenesForOverview(projectData);

		return projectData;
		};
	
	
appdoo.prototype.transformProjectData_72 = function appdoo__transformProjectData_72(projectData) {
	
		
		
		

		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {
				if (Array.isArray(subview.bindings)) subview.bindings.every(function (binding) {
					if (binding.hasDynamicContext) {
						binding.enumerableItemAccess = true;
						binding.destination = binding.destination.substr(0, binding.destination.length-2);
					}
					delete binding.hasDynamicContext;return true; }, this);
				
			});return true; }, this);
		
		
		return projectData;
};
	

appdoo.prototype.transformProjectData_73 = function appdoo__transformProjectData_73(projectData) {
	
		

		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			if (Array.isArray(scene.bindings)) scene.bindings.every(function (binding) {
				if (binding.key === 'navigationBarTitle') {
					scene.bindings = [];
					binding.key = 'title';
					if (scene.navigationBar)
						scene.navigationBar.bindings = [binding];
				}return true; }, this);
			
			if (scene.navigationBar)
				scene.navigationBar.title = scene.viewController.title;return true; }, this);
		
		
		return projectData;};
	

appdoo.prototype.transformProjectData_74 = function appdoo__transformProjectData_74(projectData) {
	
		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {

				
				
				if (subview.$type === 'UIImageViewWithURL') {
					subview.$type = 'UIImageView';
					subview.isReferenced = true;
				}

				
				if (!subview.autoresizingMask)
					subview.autoresizingMask = 36;

				
				if (subview.$type === 'ASSimpleHTMLView') {
					subview.$type = 'SimpleHTMLView';
					subview.$domain = 'info.appdoo';
				}

			});return true; }, this);
		
		
		return projectData;};
	

appdoo.prototype.transformProjectData_75 = function appdoo__transformProjectData_75(projectData) {
		
		var scenesToDelete = [];
		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {

			if (!scene.viewController || !scene.viewController.viewData) {
				scenesToDelete.push(scene);
				return true;
			}
			scene.viewController.viewData.$type = 'SceneRootView';
			if (!scene.viewController.viewData.backgroundColor)
				scene.viewController.viewData.backgroundColor = 'rgb(255, 255, 255)';return true; }, this);
		

		console.log(scenesToDelete);
		if (Array.isArray(scenesToDelete)) scenesToDelete.every(function (scene) {
			projectData.scenes.splice(projectData.scenes.indexOf(scene, 1));return true; }, this);
		
		
		return projectData;};
	

appdoo.prototype.transformProjectData_76 = function appdoo__transformProjectData_76(projectData) {
		
		projectData.metadata.appleAppBundlePrefix =
		projectData.metadata.appleTeamIdentifier;
		
		delete projectData.metadata.appleTeamIdentifier ;
	
		return projectData;};
	
	
appdoo.prototype.transformProjectData_77 = function appdoo__transformProjectData_77(projectData) {
	
		
		
		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			if (scene.navigationBar &&
				scene.navigationBar.bindings &&
				scene.navigationBar.bindings.length &&
				typeof scene.navigationBar.bindings[0].destination === 'string' &&
				scene.navigationBar.bindings[0].destination.indexOf('UIViewController') === 0) {
				
				scene.navigationBar.bindings.shift();
				
			}return true; }, this);
		
		
		return projectData;};
	

appdoo.prototype.transformProjectData_78 = function appdoo__transformProjectData_78(projectData) {
	
		
		
		
		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			scene.showsTabBar = true;

			updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {
				if (subview.dataSourceId) {
					subview.usesDataSource = true;
				}
			});return true; }, this);
		
		
		return projectData;};
	
	
appdoo.prototype.transformProjectData_79 = function appdoo__transformProjectData_79(projectData) {
	
		
		

		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
		
			if (scene.statusBarBackgroundView) {
				scene.statusBarBackgroundView.autoresizingMask = 2;
				scene.statusBarBackgroundView.frame.size.width = scene.viewController.viewData.frame.size.width;
			}

			updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {
				if (subview.staticCells) {
					subview.staticSections = [{
						$type: subview.$type+'Section',
						$domain: 'appdoo.iOS',
						numberOfStaticCells: subview.staticCells.length,
						staticCells: subview.staticCells
					}];
					subview.numberOfStaticSections = 1;
					delete subview.staticCells;
				}
			});
		return true; }, this);
		

		return projectData;};
	
	
appdoo.prototype.transformProjectData_81 = function appdoo__transformProjectData_81(projectData) {
	
		
		
		
		

		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {

			if (scene.navigationBar &&
				scene.navigationBar.bindings &&
				scene.navigationBar.bindings.length) {
				scene.navigationBar.bindings[0].sourceKeyPath = 'topItem.title';
				delete scene.navigationBar.bindings[0].key;
			}
			updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {
				if (subview.bindings) {
					if (Array.isArray(subview.bindings)) subview.bindings.every(function (binding) {
						binding.sourceKeyPath = (binding.key||binding.keyPath);
						delete binding.key;return true; }, this);
					
				}
			});return true; }, this);
		

		return projectData;};
	

appdoo.prototype.transformProjectData_82 = function appdoo__transformProjectData_82(projectData) {

		
		
		
		var JSONString = JSON.stringify(projectData);
		JSONString = JSONString.replace(/imageURL/g, 'imageURLString');
		projectData = JSON.parse(JSONString);
		
	
		
		

		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {

			if (scene.navigationBar) {
				if (scene.navigationBar.bindings &&
					scene.navigationBar.bindings.length) {
					var binding = scene.navigationBar.bindings[0];
					binding.sourceKeyPath = 'title';
					scene.navigationBar.items[0].bindings = [binding];
					delete scene.navigationBar.bindings;
				}
				if (!scene.navigationBar.items[0].$id)
					scene.navigationBar.items[0].$id = this.createUID('UINavigationItem');
			}
return true; }, this);
		

		return projectData;};
	

appdoo.prototype.transformProjectData_83 = function appdoo__transformProjectData_83(projectData) {
		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			scene.supportedInterfaceOrientations = 2;return true; }, this);
		
		projectData.metadata.supportedInterfaceOrientations = 2;
		return projectData;};
	

appdoo.prototype.transformProjectData_84 = function appdoo__transformProjectData_84(projectData) {

		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {


			updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {
				if (subview.$type === 'Hyperlink') {
					subview.URLString = subview.URL;
					delete subview.URL;
					if (subview.bindings) {
						var json = JSON.stringify(subview.bindings);
						json = json.replace(/"URL"/g, '"URLString"');
						subview.bindings = JSON.parse(json);
					}
				}
			});return true; }, this);
		
		
		return projectData;
};
	

appdoo.prototype.transformProjectData_85 = function appdoo__transformProjectData_85(projectData) {

		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			
			scene.viewController.viewData.$id = this.createUID('UIView');return true; }, this);
		
		
		return projectData;
};
	

appdoo.prototype.transformProjectData_86 = function appdoo__transformProjectData_86(projectData) {
	
		projectData.fileReferences = [];

		if (Array.isArray(clone(projectData.objects))) clone(projectData.objects).every(function (obj) {
			if (obj.$type === 'ResourceReference' ||
				obj.$type === 'AudioResourceReference') {
				projectData.fileReferences.push(obj);
				projectData.objects.splice(projectData.objects.indexOf(obj), 1);
				
				if (obj.$type === 'AudioResourceReference') {
					obj.$type = 'ResourceReference';
					var soundPlayer = {
						$type: 'SimpleSoundPlayer',
						$domain: 'info.appdoo',
						$id: this.createUID('SimpleSoundPlayer'),
						soundFileReferenceID: obj.$id,
					};
					if (!projectData.objects) projectData.objects = [];
					projectData.objects.push(soundPlayer);
					
					if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
						updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {
							if (subview.actionInfo) {
								if (subview.actionInfo.objectID === obj.$id) {
									subview.actionInfo.objectID = soundPlayer.$id;
								}
							}
						});return true; }, this);
					
				}
			}return true; }, this);
		
		
		return projectData;
};
	

appdoo.prototype.transformProjectData_87 = function appdoo__transformProjectData_87(projectData) {
	
		projectData.metadata.lastObjectID = 10000;

		
		this.fixDuplicateIDsIssue(projectData);
		
		return projectData;
};
	
	
appdoo.prototype.transformProjectData_89 = function appdoo__transformProjectData_89(projectData) {
	
		projectData.metadata.simulatedSystemVersion = 7;
		return projectData;
	};
	

appdoo.prototype.transformProjectData_90 = function appdoo__transformProjectData_90(projectData) {
	
		projectData.metadata.launchImages = {};
		return projectData;
	};
	

appdoo.prototype.transformProjectData_91 = function appdoo__transformProjectData_91(projectData) {
	
		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {

			updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {
				if (!subview.autoresizingMask)
					subview.autoresizingMask = 36;
			});
			
			if (!scene.navigationBar || !scene.navigationBar.items) return true;

			if (scene.navigationBar.items[0].leftBarButtonItem) {
				scene.navigationBar.items[0].leftBarButtonItems = [scene.navigationBar.items[0].leftBarButtonItem];
			}
			if (scene.navigationBar.items[0].rightBarButtonItem) {
				scene.navigationBar.items[0].rightBarButtonItems = [scene.navigationBar.items[0].rightBarButtonItem];
			}return true; }, this);
		


		return projectData;
	};
	

appdoo.prototype.transformProjectData_92 = function appdoo__transformProjectData_92(projectData) {

		projectData.metadata.defaultLanguage = window.language;
		return projectData;
	};
	

appdoo.prototype.transformProjectData_93 = function appdoo__transformProjectData_93(projectData) {
	
		updateAllObjectsInProjectData(projectData, function worker(obj) {
			if (obj.actionInfo) {
				obj.actionInfo.$type = 'ActionInfo';
				obj.actionInfo.$domain = 'appdoo';
			}
			return true;
		});
		
		return projectData;
	};
	
	
appdoo.prototype.transformProjectData_94 = function appdoo__transformProjectData_94(projectData) {
	
		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			scene.hasCustomInterfaceOrientations = false;return true; }, this);
		

		return projectData;
	};
	

appdoo.prototype.transformProjectData_95 = function appdoo__transformProjectData_95(projectData) {
	
		updateAllObjectsInProjectData(projectData, function worker(obj) {
			if (obj.$type === 'SceneInputDataSource') {
			
				if (obj.indexPath)
					obj.indexPath = {
						$type: 'NSIndexPath',
						$domain: 'appdoo.iOS',
						section: obj.indexPath.section,
						item: obj.indexPath.item,
					};
				
			}
			return true;
		});
		
		return projectData;
	};
	

appdoo.prototype.transformProjectData_96 = function appdoo__transformProjectData_96(projectData) {

		var JSONString = JSON.stringify(projectData);
		JSONString = JSONString.replace(/net.appdrive/g, 'info.appdoo');
		projectData = JSON.parse(JSONString);

		return projectData;
};
	

appdoo.prototype.transformProjectData_97 = function appdoo__transformProjectData_97(projectData) {

		projectData.metadata.projectID = this.nativeProxy.sendMessage('generateClientUID');
		return projectData;
};
	
	
appdoo.prototype.fixDuplicateIDsIssue = function appdoo__fixDuplicateIDsIssue(projectData) {
		var allIDs = {};
		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {
				if (allIDs[subview.$id] || !subview.$id) {
					if (subview.$id) {
						console.warn('ID collision detected!', subview,'Generating new ID.');
					}
					subview.$id = this.createAppdooObjectID(subview.$type, projectData);
				}
				allIDs[subview.$id] = true;
			}.bind(this));return true; }, this);
		};
	

appdoo.prototype.transformProjectData_98 = function appdoo__transformProjectData_98(projectData) {

		
		this.fixDuplicateIDsIssue(projectData);

		return projectData;
};
	

appdoo.prototype.transformProjectData_99 = function appdoo__transformProjectData_99(projectData) {
	
		var JSONString = JSON.stringify(projectData);
		JSONString = JSONString.replace(/info.appdoo/g, 'info.appdoo-mac');
		projectData = JSON.parse(JSONString);
		
		return projectData;
};
	

appdoo.prototype.transformProjectData_100 = function appdoo__transformProjectData_100(projectData) {
	
		updateAllObjectsInProjectData(projectData, function worker(obj) {

			if (obj.$type === 'ButtonWithSubviews') {
				obj.$domain = 'info.appdoo-mac';
			}
			return true;
		});
		
		return projectData;
};
	

appdoo.prototype.transformProjectData_101 = function appdoo__transformProjectData_101(projectData) {
	
		updateAllObjectsInProjectData(projectData, function worker(obj) {

			if (obj.actionInfo && obj.actionType) {
				obj.actionInfo.actionType = obj.actionType;
			}
			return true;
		});
		
		return projectData;
};
	

appdoo.prototype.transformProjectData_102 = function appdoo__transformProjectData_102(projectData) {
	
		updateAllObjectsInProjectData(projectData, function worker(obj) {

			if (obj.$type === 'SimpleSoundPlayer') {
				obj.$type = 'SimpleAudioPlayer';

				if (obj.dataProvider) {
					obj.dataProvider.$type = 'SimpleAudioPlayerDataProvider';
				}
			}
			return true;
		});
		
		return projectData;
};
	

appdoo.prototype.transformProjectData_105 = function appdoo__transformProjectData_105(projectData) {
	
		
		if (!projectData.metadata.targetedDeviceFamily) {
			var isIPadProject = projectData.metadata.deviceProfile.indexOf('iPad') !== -1;
			projectData.metadata.targetedDeviceFamily = isIPadProject ? 'iPad' : 'iPhone';
		}
		
		return projectData;
};
	

	function updateAllObjectsInProjectData(projectData, worker) {
		if (!projectData) return;

		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {

			updateSubviewsWithCallback(scene.viewController.viewData, worker);
			if (scene.objects) scene.objects.every(worker);
			if (scene.navigationBar) {
				if (Array.isArray(scene.navigationBar.items)) scene.navigationBar.items.every(function (navigationItem) {
					if (Array.isArray(navigationItem.leftBarButtonItems)) navigationItem.leftBarButtonItems.every(function (barButtonItem) {
						worker(barButtonItem);return true; }, this);
					
					if (Array.isArray(navigationItem.rightBarButtonItems)) navigationItem.rightBarButtonItems.every(function (barButtonItem) {
						worker(barButtonItem);return true; }, this);
					return true; }, this);
				
			}
			return true; }, this);
		
		if (projectData.objects) projectData.objects.every(worker);
	}
	
	
	
	
	Object.defineProperty(appdoo.prototype, "fileExtensionsForImport", {
		value: ['jpg','json','txt']});
	
	
appdoo.prototype.setProjectName = function appdoo_setProjectName(name) {
		this.projectMetadataController.setValueForKeyPath(name,'title',this);};
	
	
appdoo.prototype.getProjectName = function appdoo_getProjectName() {
		return this.projectMetadataController.get('title');};
	
	
appdoo.prototype.getAllScenesInfo = function appdoo_getAllScenesInfo() {
		if (!this.projectContext || !this.projectContext.scenes || !this.projectContext.scenes.length)
			return [];
		var r = JSON.stringify(this.projectContext.scenes.map(function (scene) {
			return {
				name: scene.viewController.title,
				$id: scene.$id,
				isEdited: this.editor&&this.editor.editedScene===scene
			};
		}, this));

		return r;};
	
	
appdoo.prototype.getAllInsertableElementsInfoGrouped = function appdoo_getAllInsertableElementsInfoGrouped() {
		return JSON.stringify(this.elementGroups);};
	
	
appdoo.prototype.getAllInsertableElementsInfo = function appdoo_getAllInsertableElementsInfo() {
		var allElements = [];
		var enabled = this.editorIsVisible();
		allElements.push({ name: LocalizedString('Text'), UTI: 'appdoo.iOS.UILabel', enabled: enabled, isDefaultLabel: true });
		if (Array.isArray(this.elementGroups)) this.elementGroups.every(function (group) {
			if (group.$id === 'PlugInGroup') return true;

			if (Array.isArray(group.items)) group.items.every(function (element) {
				if (!element.UTI) return true;
				
				element.enabled = enabled && this.editor.validateInsertion(element.UTI);
				element.group = group.$id;
				allElements.push(element);return true; }, this);
			return true; }, this);
		
		
		return JSON.stringify(allElements);};
	
	
appdoo.prototype.editSceneWithID = function appdoo_editSceneWithID(sceneID) {
		this.showEditorWithOptions({itemId: sceneID});};
	
	
appdoo.prototype.insertElementFromMenu = function appdoo_insertElementFromMenu(uti) {
		document.body.focus();
		var obj = this.editor.insertFromBlueprint(uti, this.editor.editedSubview.node);
		if (obj && uti === 'appdoo.iOS.UILabel')
			obj.editDefault(this.editor);
		else if (obj)
			this.editor.animateInsertion(obj);};
	
	
appdoo.prototype.getOptimalWindowSize = function appdoo_getOptimalWindowSize() {
		if (!this.editor) return;
		return this.editor.getOptimalWindowSize();};
	
	
appdoo.prototype.setThemeName = function appdoo_setThemeName(themeName) {
		if (!this.overview) {
			return;
		}
		if(themeName == 'dark' || themeName == 'light') {
			document.body.className = themeName;
		}};
	
	
appdoo.prototype.createNewScene = function appdoo_createNewScene(doNotEdit) {




		
		if (!this.overview) {
			return;
		}
		var name = this.nativeProxy.sendMessage('nextNameForNewScene', JSON.stringify({
			title: LocalizedString('Name for the new screen:'),
			value: this.projectContext.nextNameForNewScene(),
		}));
		if(name !== undefined && name.length > 0) {
			var scene = this.overview.createScene(name);
			if (scene) {
				scene.e_title = name;
				this.overview.scenesView.updateSceneTitles();
			}
			if (scene && this.editorIsVisible() && !doNotEdit) {
				this.editSceneWithID(scene.$id);
			}
			return scene;
		}
		return;














		};
	
	
appdoo.prototype.multipleFilesInfoByDialog = function appdoo_multipleFilesInfoByDialog() {
		var fileInfoJSON = this.nativeProxy.sendMessage('chooseMultipleFilesForImport', JSON.stringify({
			title: LocalizedString('Choose Files'),
			prompt: LocalizedString("Insert"),
		}));
		
		if (!fileInfoJSON) return;
		var fileInfo = JSON.parse(fileInfoJSON);
		
		return fileInfo;};
	

appdoo.prototype.fileInfoByDialog = function appdoo_fileInfoByDialog() {
		var fileInfoJSON = this.nativeProxy.sendMessage('chooseFileForImport', JSON.stringify({
			title: LocalizedString('Choose File'),
			prompt: LocalizedString("Insert"),
		}));
		
		if (!fileInfoJSON) return;
		var fileInfo = JSON.parse(fileInfoJSON);
		
		return fileInfo;};
	

appdoo.prototype.insertElementFromFile = function appdoo_insertElementFromFile() {
		if (!this.editor || !this.editorIsVisible()) return;
		
		if (this.pasteboardDelegate.focusedElement &&
			this.pasteboardDelegate.focusedElement.loadFromFile) {
			this.pasteboardDelegate.focusedElement.loadFromFile();
			return;
		}
		
		var fileInfo = this.fileInfoByDialog();
		if (!fileInfo) return;
		
		this.editor.dropFilesAtItemWithEventCompletion([fileInfo], this.editor.editedSubview, null, null);};
	

appdoo.prototype.generateUUID = function appdoo_generateUUID(prefix = "") {
		
	    var d = new Date().getTime();
		
	    if (typeof performance !== 'undefined' && typeof performance.now === 'function'){
	        d += performance.now(); 
	    }
		
		var pattern = 'xxxxxxxxxxxx4xxxyxxxxxxxxxxxxxxx';
	    var uuid = pattern.replace(/[xy]/g, function (c) {
	        var r = (d + Math.random() * 16) % 16 | 0;
	        d = Math.floor(d / 16);
	        return (c === 'x' ? r : (r & 0x3 | 0x8)).toString(16);
	    });
		return prefix+uuid;};
	
	
appdoo.prototype.createAppdooObjectID = function appdoo_createAppdooObjectID(prefix, project) {
		
		if (!prefix) prefix = 'Object';
		
		
		
		return this.generateUUID(prefix);};
	

appdoo.prototype.arrangeScenesForOverview = function appdoo_arrangeScenesForOverview(projectData) {
	
		if (!this.projectContext) return;
	
		var margin = 320/4;
		if (this.projectContext.screenSizeInPoints.width > 320)
			margin *= 2;

		var marginX = margin;
		var marginY = margin;
		var y = margin;
		
		if (projectData.tabBarController && projectData.tabBarController.viewControllerIDs && projectData.tabBarController.viewControllerIDs.length < 5)
			marginX *= 1.5;
		
		function sizeForSzene(scene) {
			if (scene.previewSize) return scene.previewSize;
			return { width: 320, height: 568 };
		}
		
		function scenesWithSegueToScene(scene) {
			var r = [];
			if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (_scene) {
				var segueFound;

				if (Array.isArray(_scene.segues)) _scene.segues.every(function (segue) {
					if (segue.destinationSceneID === scene.$id) {
						segueFound = true;
						return false;
					}return true; }, this);
				
				if (segueFound) {
					r.push(_scene);
				}return true; }, this);
			
			return r;
		}
		
	
		
		var scenesInTabBar = [];
		if (Array.isArray(projectData.tabBarController.viewControllerIDs)) projectData.tabBarController.viewControllerIDs.every(function (vcID) {
			var s = sceneFromVCID(vcID, projectData.scenes);
			if (s) scenesInTabBar.push(s);return true; }, this);
		
		
		
		
		if (scenesInTabBar.length) {
			var x = 0;
			var maxH = 0;
			if (Array.isArray(scenesInTabBar)) scenesInTabBar.every(function (scene) {
				var size = sizeForSzene(scene);
				scene.positionOnOverview = { left: parseInt(x+size.width/2), top: parseInt(y) };
				x += size.width+marginX;
				maxH = Math.max(maxH, size.height);return true; }, this);
			
			x -= marginX;
			var delta = x/2;
			if (Array.isArray(scenesInTabBar)) scenesInTabBar.every(function (scene) {
				scene.positionOnOverview.left -= parseInt(delta);return true; }, this);
			
			y += maxH + marginY;

		}
		
		

		var scenesWithoutIncomingSegue = [];
		if (Array.isArray(projectData.scenes)) projectData.scenes.every(function (scene) {
			if (scenesInTabBar.indexOf(scene) !== -1) return true;
			
			var afferentScenes = scenesWithSegueToScene(scene);
			if (afferentScenes.length) {

				if (afferentScenes[0].positionOnOverview) {
					var p = afferentScenes[0].positionOnOverview,
						s = sizeForSzene(afferentScenes[0]);
					scene.positionOnOverview = {
						left: parseInt(p.left),
						top: parseInt(p.top+s.height+marginY*2)
					};
				}
			}
			else {
				scenesWithoutIncomingSegue.push(scene);
			}
			return true; }, this);
		

		var x = -(scenesWithoutIncomingSegue.length*(320+marginX)-marginX)/2+160;
		if (Array.isArray(scenesWithoutIncomingSegue)) scenesWithoutIncomingSegue.every(function (scene) {
			if (!scene.positionOnOverview) {
				scene.positionOnOverview = { left: parseInt(x), top: parseInt(y+(578+marginY)) };
				x += sizeForSzene(scene).width + marginX;
			}return true; }, this);
		
		
	};
	

appdoo.prototype.showGrabCursor = function appdoo_showGrabCursor() {
		this.nativeProxy.sendMessage('forceCursorUpdate', 'closedHandCursor');
		document.body.style.cursor = '-webkit-grabbing';
		window.addEventListener('mouseup', function windowMouseUp(e) {
			document.body.style.cursor = 'default';
			window.removeEventListener('mouseup', windowMouseUp);
		});};
	

	var editorResources = [
		'appdoo_Editor_Editor.js',
		'appdoo_Editor_ContentFrameController.js',
		'appdoo_Editor_SelectionController.js',
		'appdoo_Editor_NewItemList.js',
		'appdoo_Editor_Inspector.js',
		'appdoo_Editor_OutlineDataSource.js',
		'appdoo_Editor_OverviewButton.js',
		'appdoo_Editor_ComponentContainerView.js',
		'appdoo_Editor_OnScreenInfo.js',
		'appdoo_Editor_DynamicsControl.js',
		'appdoo_Editor_BoundPropertyButton.js',
		'appdoo_Editor_InspectorTextField.js',
		'appdoo_Editor_InspectorPopUpButton.js',
		'appdoo_Editor_InspectorSlider.js',
		'appdoo_Editor_InspectorCheckbox.js',
		'appdoo_Editor_InspectorSegmentedControl.js',
		'appdoo_Editor_InspectorButton.js',
		'appdoo_Editor_InspectorTableViewDataSource.js',
		'appdoo_Editor_InspectorLabel.js',
		'appdoo_Editor_InspectorBindingsView.js',
		'appdoo_Editor_InspectorHelpView.js',
		'appdoo_Editor_ObjectBindingController.js',
		'appdoo_Editor_DataContext.js',
	],
	
	overviewResources = [
		'appdoo_Overview_Overview.js',
		'appdoo_Overview_HeaderView.js',
		'appdoo_Overview_SceneView.js',
		'appdoo_Overview_ScenesView.js',
		'appdoo_Overview_OverviewTitleTextField.js',
		'appdoo_Overview_OverviewSegmentedViewController.js',
		'appdoo_Overview_SceneDispenserView.js',
		'appdoo_Overview_ProjectInfoEditor.js',
		'Resources/AppIconPlaceholder.png',
		'Resources/AppIconPlaceholder@2x.png',
		
	],
	
	iOSGeneratorResources = [
		'appdoo_iOSGenerator_AppleStoryboardTransformer.js',
		'appdoo_iOSGenerator_iOSAppGenerator.js',
		'appdoo_iOSGenerator_PbxFileGenerator.js',
		'appdoo_iOSGenerator_PluginCodeConfigurator.js'
	];
	

appdoo.prototype.addDataControllerToObject = function appdoo__addDataControllerToObject(object, undoDelegate) {
	
		if (object.dataController) return;
		
		var oc = createComponentFromDomain("ObjectController", "Core", this, {
			contents: object,
			canUndo: true,
			undoDelegate: undoDelegate || this})
		;
		oc.parentObject = object;
		oc.controllerKey = 'dataController';

		Object.defineProperty(object, oc.controllerKey, {
			value: oc,
			writable: true
		});
		
		

		if (!object.bindings) object.bindings = [];

		var bc = createComponentFromDomain("ArrayController", "Core", this, {
			contents: object.bindings,
			canUndo: true,
			undoDelegate: undoDelegate || this})
		;
		bc.parentObject = object;
		bc.controllerKey = 'bindingsController';

		Object.defineProperty(object, bc.controllerKey, {
			value: bc,
			writable: true
		});


		if (object instanceof getType('Core.UI.View')) {

			
	
			if (!object.layoutRelations) object.layoutRelations = [];
	
			var lc = createComponentFromDomain("ArrayController", "Core", this, {
				contents: object.layoutRelations,
				canUndo: true,
				undoDelegate: undoDelegate || this})
			;
			lc.parentObject = object;
			lc.controllerKey = 'layoutRelationsController';
	
			Object.defineProperty(object, lc.controllerKey, {
				value: lc,
				writable: true
			});
		
		}
		
		};
	
	
	function elementInfoForUTI(uti) {
		var proto = getPrototype(uti);
		return { UTI: uti, "name": proto.readableType, description: proto.readableDescription, "icon": proto.iconURL };
	}

	var _elementGroups;
	Object.defineProperty(appdoo.prototype, "elementGroups", {
		get: function () {
		
			if (_elementGroups) return _elementGroups;
			
			var groups = [
				{ name: LocalizedString("Labels and Buttons"), $id: "BasicElementsGroup", items: [
					
					{ useDataCell: true, isElement: true, dataType: 'view', name: '', "description": LocalizedString('Shows a text label'), value: {
						$type: 'UILabel',
						$domain: 'appdoo.iOS',
						fontSize: 17,
						fontName: '_DEFAULT_',
						fontFamily: 'System',
						text: LocalizedString('Label'),
						name: LocalizedString('Label'),
						"description": LocalizedString('Shows a text label'),
						layoutMode: 'autoFitHeight',
						size: { width: 170, height: 23 }
					} },













					
					{ useDataCell: true, isElement: true, dataType: 'view', name: '', description: LocalizedString('Shows a text button'), value: {
						$type: 'UIButton',
						$domain: 'appdoo.iOS',
						fontSize: 17,
						CSSTextColor: system7DefaultTint,
						fontName: '_DEFAULT_',
						fontFamily: 'System',
						text: LocalizedString('Text Button'),
						name: LocalizedString('Text Button'),
						description: LocalizedString('Shows a text button'),
						size: { width: LocalizedNumber('BUTTON_BLUEPRINT_ELEMENT_WIDTH')+2, height: 22 },
						actionType: 'objectAction',
					} },


					{ useDataCell: true, isElement: true, dataType: 'view', name: '', description: LocalizedString('Shows a text link (hyperlink)'), value: {
						$type: 'Hyperlink',
						$domain: 'info.appdoo-mac',
						fontSize: 16,
						fontName: '_DEFAULT_',
						fontFamily: 'System',
						text: LocalizedString('Hyperlink'),
						name: LocalizedString('Hyperlink'),
						description: LocalizedString('Shows a text link (hyperlink)'),
						URL: 'http://',
						size: { width: 170+20, height: 22 },
						
					} },

				]},

                { name: LocalizedString("Basic Shapes"), $id: "BasicShapes", items: [

                    { UTI: "info.appdoo-mac.DrawableRectangle", "name": LocalizedString("Rectangle"), "description": LocalizedString("Draws rectangles"), "icon":"Resources/BasicShapeRectangle48.png", "isView": true },
                    { UTI: "info.appdoo-mac.DrawableEllipse", "name": LocalizedString("Ellipse"), "description": LocalizedString("Draws circles and ellipses"), "icon":"Resources/BasicShapeEllipse48.png", "isView": true },
                    { UTI: "info.appdoo-mac.DrawableTriangle", "name": LocalizedString("Triangle"), "description": LocalizedString("Draws triangles"), "icon":"Resources/BasicShapeTriangle48.png", "isView": true },

                ]},

				{ name: LocalizedString("Containers"), $id: "ContainersGroup", items: [
				

					{ UTI: "appdoo.iOS.UITableView", "name": LocalizedString("List View"), "description": LocalizedString("Arranges items vertically"), "icon":"Resources/UITableView48.png", "isView": true },
						
					{ UTI: "appdoo.iOS.UICollectionView", "name": LocalizedString("Collection View"), "description": LocalizedString("Arranges items horizontally"), "icon":"Resources/UICollectionView48.png", "isView": true },

					{ UTI: "appdoo.iOS.UIImageViewWithURL", "name": LocalizedString("Image View"), "description":LocalizedString("Displays an image from a file or URL"), "icon":"Resources/UIImageView48.png", "isView": true },
					
					{ UTI: "info.appdoo-mac.FormattedTextContainer", "name": LocalizedString("WYSIWYG Editor"), "description": LocalizedString("A simple WYSIWYG-Editor"), "icon":"Resources/WYSIWYG48.png", "isView": true },

					{ UTI: "info.appdoo-mac.SimpleHTMLView", "name": LocalizedString("HTML Container"), "description": LocalizedString("Displays contents from HTML format"), "icon":"Resources/SimpleHTMLView48.png", "isView": true },
					
					{ UTI: "info.appdoo-mac.UIWebView", "name": LocalizedString("Web View"), "description":LocalizedString("Loads and displays a web page"), "icon":"Resources/UIWebView48.png", "isView": true },

					availablePlugins['info.appdoo-mac.DocumentViewer'],

					{ UTI: "info.appdoo-mac.MoviePlayerView", "name": LocalizedString("Media Player"), "description": LocalizedString("Plays video and audio from a file or stream"), "icon":"Resources/MoviePlayerView48.png", "isView": true },

					{ UTI: "info.appdoo-mac.SimpleMapView", "name": LocalizedString("Map View"), "description":LocalizedString("Shows an interactive map"), "icon":"Resources/SimpleMapView48.png", "isView": true },

					availablePlugins['info.appdoo-mac.PhotoZoom'],

				]},

				{ name: LocalizedString("Controls"), $id: "ControlsGroup", items: [

					{ UTI: "appdoo.iOS.UITextField", "name": LocalizedString("Text Input Field"), "description": LocalizedString("Allows the user to input text"), "icon":"Resources/UITextField48.png", "isView": true },

					{ UTI: "appdoo.iOS.UITextView", "name": LocalizedString("Multiline Text Field"), "description": LocalizedString("Allows the user to input multi-line text"), "icon":"Resources/UITextView48.png", "isView": true },

					{ UTI: "appdoo.iOS.UISwitch", "name": LocalizedString("Switch"), "description": LocalizedString("Allows the user to turn something on or off"), "icon":"Resources/UISwitch48.png", "isView": true },

					{ UTI: "appdoo.iOS.UISegmentedControl", "name": LocalizedString("Segmented Control"), "description": LocalizedString("Allows the user to pick one of several options"), "icon":"Resources/UISegmentedControl48.png", "isView": true },

					{ UTI: "appdoo.iOS.UISlider", "name": LocalizedString("Slider"), "description": LocalizedString("Allows the user to set a numeric value"), "icon":"Resources/UISlider48.png", "isView": true },

					{ UTI: "appdoo.iOS.UIPickerView", "name": LocalizedString("Picker View"), "description": LocalizedString("Allows the user to pick one of several options"), "icon":"Resources/UIPickerView48.png", "isView": true },
					
					elementInfoForUTI('appdoo.iOS.UIDatePicker'),

					{ UTI: "appdoo.iOS.UISearchBar", "name": getPrototype('appdoo.iOS.UISearchBar').readableType, "description": LocalizedString("Allows the user to enter a search term"), "icon":"Resources/UISearchBar48.png", "isView": true },

					elementInfoForUTI('appdoo.iOS.UIStepper'),

				]},
				
				{ name: LocalizedString("Data Sources"), $id: "DataSourcesGroup", items: [

					elementInfoForUTI('info.appdoo-mac.TextualListDataSource'),
					elementInfoForUTI('info.appdoo-mac.AtomDataSource'),
					elementInfoForUTI('info.appdoo-mac.RSS2DataSource'),
					elementInfoForUTI('info.appdoo-mac.JSONDataSource'),
					elementInfoForUTI('info.appdoo-mac.CSVDataSource'),
					elementInfoForUTI('info.appdoo-mac.JavaScriptContainer'),
					elementInfoForUTI('info.appdoo-mac.FilteredDataSource'),

				]},
				
				{ name: LocalizedString("Miscellaneous"), $id: "VariousGroup", items: [

					elementInfoForUTI('appdoo.iOS.ActionSet'),
					elementInfoForUTI('info.appdoo-mac.SimpleAnimation'),
					elementInfoForUTI('info.appdoo-mac.ConditionalAction'),
					
					{ UTI: "info.appdoo-mac.AlertViewGenerator", "name": getPrototype('info.appdoo-mac.AlertViewGenerator').readableType, "description": LocalizedString("Displays text in a dialog box"), "icon":"Resources/AlertViewGenerator48.png", "isView": false },

					{ UTI: "info.appdoo-mac.FormProcessor", "name": getPrototype('info.appdoo-mac.FormProcessor').readableType, "description": LocalizedString("Sends collected form data from a screen to a URL"), "icon":"Resources/FormProcessor48.png", "isView": false },

					elementInfoForUTI('info.appdoo-mac.ActivityViewGenerator'),
					elementInfoForUTI('info.appdoo-mac.SegmentedNavigationArrows'),
					elementInfoForUTI('info.appdoo-mac.SimpleAudioPlayer'),
					
					{ UTI: "info.appdoo-mac.Timer", "name": getPrototype('info.appdoo-mac.Timer').readableType, "description": LocalizedString("Triggers an action after a configurable time or interval"), "icon":"Resources/Timer48.png", "isView": false },

					{ UTI: "info.appdoo-mac.DataSensor", "name": getPrototype('info.appdoo-mac.DataSensor').readableType, "description": LocalizedString("Monitors a data value, performs an action"), "icon":"Resources/DataSensor48.png", "isView": false },

					
				
				]},

			];
			
			if (window.userPlugIns.length) {
				var userPlugInsGroup = { name: LocalizedString("Extensions"), $id: "PlugInGroup", items: [
						]
					};
				if (Array.isArray(window.userPlugIns)) window.userPlugIns.every(function (plugIn) {
					if (plugIn.localizedDescription) {
						plugIn.description = plugIn.localizedDescription[window.language] || plugIn.localizedDescription['en'];
					}
					if (plugIn.localizedName) {
						plugIn.name = plugIn.localizedName[window.language] || plugIn.localizedName['en'];
					}
					if (plugIn.properties) {
						plugIn.properties.pluginVersion = plugIn.pluginVersion;
						plugIn.properties.pluginIdentifier = plugIn.pluginIdentifier;
					}
					userPlugInsGroup.items.push(plugIn);return true; }, this);
				
				groups.push(userPlugInsGroup);
			}
			
			_elementGroups = groups;
			
			if (Array.isArray(_elementGroups)) _elementGroups.every(function (group) {
				if (Array.isArray(group.items)) group.items.every(function (item) {
					_context.identify(item);return true; }, this);
				return true; }, this);
			

			return _elementGroups;
		}});
	
	
appdoo.prototype.resetElementGroups = function appdoo_resetElementGroups() {
		_elementGroups = null;};
	

	
appdoo.prototype.colorInfoFromCSSColor = function appdoo_colorInfoFromCSSColor(color, key) {

		if (!color) {
			return {
					key: key,
					white: '0',
					alpha: '0',
					colorSpace: 'calibratedWhite'
				};
		}
		
		var components = color.split(',');
		if (components.length == 3) {
			components[0] = components[0].substr(4);
			components[2] = components[2].replace(/\)/, '').replace(/^\s+/,'');
			components[3] = '1';
		}
		else if (components.length == 4) {
			components[0] = components[0].substr(5);
			components[3] = components[3].replace(/\)/, '').replace(/^\s+/,'');
		}
	
		var data = {
			key: key,
			colorSpace: 'calibratedRGB',
			red:	(parseInt(components[0])/255).toFixed(6)*1,
			green:	(parseInt(components[1])/255).toFixed(6)*1,
			blue:	(parseInt(components[2])/255).toFixed(6)*1,
			alpha:	components[3]*1.0
		};
		
		return data;
	};
	

appdoo.prototype.setNewIDsInClone = function appdoo__setNewIDsInClone(clone, mapping) {

		if (!mapping) mapping = {};
	
		if (clone.$id) {
			var oldID = clone.$id;
			delete clone.$id;
			this.projectContext.identify(clone, clone.$type);
			mapping[oldID] = clone.$id;
		}
		if (clone.$type === 'ImageReference') {
			if (clone.imageID) {
				clone.temporaryFilePath = this.pathForImageWithID(clone.imageID);
				delete clone.imageID;
			}
		}
		
		for (var key in clone) {
			if (typeof clone[key] !== 'object' || clone[key] === null) continue;
			this.setNewIDsInClone(clone[key], mapping);
		}
		};
	

appdoo.prototype.getFileInfoFromAbsultePath = function appdoo_getFileInfoFromAbsultePath(path) {
	
		var info = createComponentFromDomain("FileInfo", "appdoo", this, {
			absolutePath: path,
			relativePath: this.nativeProxy.sendMessage('getRelativeFilePath', path),
			modificationTime: this.nativeProxy.sendMessage('getFileModificationTime', path),})
		;
		
		return info;
	};
	
	
appdoo.prototype.checkIfFilesWereUpdated = function appdoo_checkIfFilesWereUpdated() {

		var updatedFileRefs;

		if (Array.isArray(this.projectContext.project.fileReferences)) this.projectContext.project.fileReferences.every(function (ref) {

			if (!ref.shouldSync || !ref.originalFileInfo) return true;

			var newModifiedTime = this.nativeProxy.sendMessage('getFileModificationTime', ref.originalFileInfo.absolutePath, ref.originalFileInfo.relativePath);

			if (!newModifiedTime) return true;
			
			if (newModifiedTime != ref.originalFileInfo.modificationTime) {
				ref.originalFileInfo.modificationTime = newModifiedTime;

				ref.updateContentsByImportingFileFromPath(this.nativeProxy.sendMessage('getAbsolutePath', ref.originalFileInfo.absolutePath, ref.originalFileInfo.relativePath));
				if (!updatedFileRefs) updatedFileRefs = [];
				updatedFileRefs.push(ref);
				ref.originalFileInfo.modificationTime = newModifiedTime;
			}
			return true; }, this);
		
		
		if (updatedFileRefs) {
			this.fileReferencesDidUpdate(updatedFileRefs);
		}};
	
	
appdoo.prototype.fileReferencesDidUpdate = function appdoo_fileReferencesDidUpdate(updatedFileRefs) {
		if (this.editor)
			this.editor.fileReferencesDidUpdate(updatedFileRefs);
		if (this.overview)
			this.overview.fileReferencesDidUpdate(updatedFileRefs);};
	
	
appdoo.prototype.addResourceReference = function appdoo_addResourceReference(resourceID, name, contentType, index, originalFilePath) {

		var typeName;
		switch (contentType) {
			case 'text/x-h':
				typeName = 'ObjCHeaderResourceReference';
				break;
			default:
				typeName = 'ResourceReference';
				break;
		}

		var ref = createComponentFromDomain(typeName, "appdoo",
			this.projectContext,
			{ resourceID: resourceID, name: name, contentType: contentType, originalFileInfo: this.getFileInfoFromAbsultePath(originalFilePath), shouldSync: true, convertToPNG: true });
		ref.identify();

		return ref;
		};
	

appdoo.prototype.showIncompatibilityErrorForImageSize = function appdoo_showIncompatibilityErrorForImageSize(customMessage) {
		this.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
			message: LocalizedString('The image size of the file you selected is not supported at this location.'),
			details: customMessage||''
		}));};
	

appdoo.prototype.showIncompatibilityErrorForFile = function appdoo_showIncompatibilityErrorForFile(file, multiple, expectedContentTypes, customMessage) {
	
		if (expectedContentTypes) {

			var readableFileTypes = expectedContentTypes.map(function (ct) { return ct.split('/').pop().toUpperCase(); }).join(', ');

			if (expectedContentTypes.length === 1) {
				this.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
					message: LocalizedString1('The file format \"%1\" is required in this location.', readableFileTypes),
					details: customMessage||''
				}));
			}
			else {
			
			
				this.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
					message: LocalizedString('The file you selected is not supported at this location.'),
					details: LocalizedString1('The following formats are supported at this location: %1', readableFileTypes)
				}));
			}
			
			return;
		}
	
		if (file['type']) {
			this.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
				message: LocalizedString('Unsupported file type'),
				details: LocalizedString1('This file is of the type "%1" which can not be inserted into appdoo.', file['type'])
			}));
		}
		else {
			if (multiple)
				alert(LocalizedString('One or more files could not be imported.'));
			else
				alert(LocalizedString('Files of this type can not be imported.'));
		}
};
	
	
	var shouldSyncFileLastResult;
appdoo.prototype.shouldSyncFile = function appdoo_shouldSyncFile(fileName, path) {
		if (shouldSyncFileLastResult !== undefined && shouldSyncFileLastResult !== 2) {
			return shouldSyncFileLastResult;
		}
			
		shouldSyncFileLastResult = this.nativeProxy.sendMessage('confirmWithOptions', JSON.stringify({
			message: LocalizedString1('Do you want \"%1\" and future imports to be synchronized?', fileName),
			details: LocalizedString('appdoo will monitor the original files and import them automatically when changes have been made.'),
			button1: LocalizedString('Synchronize'),
			button2: LocalizedString('Import Only'),
			button3: LocalizedString('Cancel'),
			icon: path
		}));
		
		return shouldSyncFileLastResult;};
	

appdoo.prototype.registerInverseBindingForTransformer = function appdoo_registerInverseBindingForTransformer(transformer, result, data, key, destinationKeyPathPrefix, dataProviderID, dataProvider) {

		var valueBinding = getPrototype('Core.BasicObject').bindingForKey.call(data, key);

		if (valueBinding) {
			alertd('Notice: Binding found.');
			var destinationObject = _context.projectContext.connectableObjects[valueBinding.destination];
			if (!destinationObject || destinationObject.mutable) {
				valueBinding = _context.createReverseBinding(valueBinding);
				valueBinding.destinationKeyPath = (destinationKeyPathPrefix ? (destinationKeyPathPrefix+'.') : '')+key;
				valueBinding.destination = dataProviderID;
				var propertyType = propertyTypeInObject(valueBinding.sourceKeyPath, destinationObject);
				valueBinding.transformer = valueTransformerForPropertyType(propertyType);
				valueBinding.treatAsReverseBinding = true; 
				if (transformer.isXIBGenerator) {
					alertd('_bindings before:',dataProvider._bindings,'in',dataProvider);
					dataProvider._bindings = [valueBinding];
				}
				else {
					transformer.registerSpecialBinding(valueBinding);
				}
				alertd('Notice: Reverse binding successfully created.', key, 'in', data.$id, 'propertyType:', propertyType, 'destination:', destinationObject, 'valueBinding.sourceKeyPath:', valueBinding.sourceKeyPath, 'transformer:',valueBinding.transformer);
			}
			else {
				alertd('Error: destinationObject is not mutable:', destinationObject);
			}
		}
		else {
			alertd('Notice: Binding not found, no reverse binding created.', key, 'in', data.$id);
		}
	};
	

appdoo.prototype.transformImageURL = function appdoo_transformImageURL(info) {
		if (info && typeof info === 'object') {
			if (info.source) {
				switch (info.source) {
					case 'remote':
						return info.remoteImageURL || '';
					case 'local':
						if (!info.localImageObjectID) return '';
						var s = [];
						var a = info.localImageObjectID.split(',');
						if (Array.isArray(a)) a.every(function (id) {
							var ref = _context.projectContext.fileReferenceWithID(id);
							if (ref) {
								s.push('file:'+ref.name);
							}return true; }, this);
						
						return s.join("\n");
				}
			}
		}
		
		return '';};
	

appdoo.prototype.transformFileReference = function appdoo_transformFileReference(idString) {

		if (idString && typeof idString === 'string') {
			var s = [];
			var a = idString.split(',');
			if (Array.isArray(a)) a.every(function (id) {
				var ref = _context.projectContext.fileReferenceWithID(id);
				if (ref) {
					s.push('file:'+ref.name);
				}return true; }, this);
			
			return s.join("\n");
		}};
	

appdoo.prototype.imageReferenceIsValid = function appdoo_imageReferenceIsValid(imageRef) {
		return imageRef && imageRef.imageID;};
	

appdoo.prototype.finishPlugInUninstallment = function appdoo_finishPlugInUninstallment(pluginIdentifier) {
		this.userPlugInManager.finishPlugInUninstallment(pluginIdentifier);};
	
	
	
	
	
appdoo.prototype.makeButton = function appdoo_makeButton(title, width, left, action, suffix) {
	
		if (!suffix) suffix = '';
	
		var button = createComponentFromDomain("SmartScalingImage", "Core.UI", this, {
			size: { width: width, height: 28 },
			position: { top: 7, left: left },
			imageSrc: (suffix !== "Transparent" ? 'Resources/OverlayButton'+suffix+'.png' : ''),
			contentInset: [14,14,0,28]})
		;
		
		var buttonLabel = createComponentFromDomain("Label", "Core.UI", this, {
			position: { top: 4, left: 5 },
			size: { width: width-10 },
			text: title,
			style: { fontSize: (window.systemVersion.minor === 10) ? "13px" : "12px", color: "#444", textAlign: "center" }})
		;
		
		function release(button) {
			button.imageSrc = (suffix !== "Transparent" ? 'Resources/OverlayButton'+suffix+'.png' : '');
		}
		
		if (action) {
			button.DOMNode.onmousedown = function () {
				button.imageSrc = (suffix !== "Transparent" ? 'Resources/OverlayButton'+suffix+'Active.png' : '');
				var originalColor = buttonLabel.DOMNode.style.color;
				buttonLabel.DOMNode.style.color = "#ffffff";
				button.style.color = "#ffffff";
				window.onmouseup = function (e) {
					release(button);
					window.onmouseup = null;
					buttonLabel.DOMNode.style.color = originalColor;
				};
			};
			button.DOMNode.onclick = function () {
				setTimeout(function () {
					action();
					release(button);
				}, 100);
			};
		}
		
		button.addSubview(buttonLabel);
		
		return button;
		};
	

	
	
appdoo.prototype.makeBackButton = function appdoo_makeBackButton(title, width, left, action) {
	
		var button = createComponentFromDomain("SmartScalingImage", "Core.UI", this, {
			size: { width: width, height: 28 },
			position: { top: 7, left: left },
			imageSrc: 'Resources/BackButton.png',
			contentInset: [14,24,0,28]})
		;
		
		var buttonLabel = createComponentFromDomain("Label", "Core.UI", this, {
			position: { top: 4, left: 13+1 },
			text: title,
			style: { fontSize: (window.systemVersion.minor === 10) ? "13px" : "12px", color: "#444" }
		})
		;
		button.addSubview(buttonLabel);
		
		function release(button) {
			button.imageSrc = 'Resources/BackButton.png';
		}
		
		if (action) {
			button.DOMNode.onmousedown = function () {
				button.imageSrc = 'Resources/BackButtonActive.png';
				window.onmouseup = function (e) {
					release(button);
					window.onmouseup = null;
				};
			};
			button.DOMNode.onclick = function () {
				setTimeout(function () {
					action();
					release(button);
				}, 50);
			};
		}
		
		return button;};
	

	
	
appdoo.prototype.makeForwardButton = function appdoo_makeForwardButton(title, width, left, action) {
	
		var forwardButton = createComponentFromDomain("SmartScalingImage", "Core.UI", this, {
			size: { width: width, height: 28 },
			position: { top: 7, left: left },
			imageSrc: 'Resources/ForwardButton.png',
			contentInset: [14,24,0,28]})
		;
		
		var buttonLabel = createComponentFromDomain("Label", "Core.UI", this, {
			position: { top: 4, left: 13-2 },
			text: title,
			style: { fontSize: (window.systemVersion.minor === 10) ? "13px" : "12px", color: "#444" }})
		;
		
		forwardButton.addSubview(buttonLabel);
		
		if (action) {
			forwardButton.DOMNode.onmousedown = function () {
				forwardButton.imageSrc = 'Resources/ForwardButtonActive.png';
				window.onmouseup = function (e) {
					setTimeout(function () {
						forwardButton.imageSrc = 'Resources/ForwardButton.png';
					}, 10);
					window.onmouseup = null;
				};
			};
			forwardButton.DOMNode.onclick = function () {
				forwardButton.imageSrc = 'Resources/ForwardButton.png';
				setTimeout(action, 0);
			};
		}
		
		return forwardButton;};
	

	
	

	
	window.componentNameFromSourceURL = function componentNameFromSourceURL(sourceURL) {

		var segments = sourceURL.split('/'),
			filename = segments[segments.length-1];
			
		return filename.split('.js')[0];
		
	};
	
	
	window.valuesAreEqual = function valuesAreEqual(a) {
	
		if (a === undefined) return false;
	
		if (Array.isArray(a) === false) {
			 console.warn('Not an array:', a);
			 console.trace();
			return true;
		}
	
		var result = true,
			firstValue = a[0];
		
		
		a.every(function (_v) {
			if (_v !== firstValue) result = false;
			else return true;
		});
		
		return result;
	};
	
	window.isArrayWithValue = function isArrayWithValue(a, v) {
		return valuesAreEqual(a) && a[0] === v;
	};
	
	window.valuesAreEqualAndDefined = function valuesAreEqualAndDefined(a) {
		return valuesAreEqual(a) && a[0] !== undefined;
	};

	
	window.selectableTextElement = function selectableTextElement(text, height, whiteSpace, wordWrap, id) {
		if (!whiteSpace) whiteSpace = 'pre-wrap';
		if (!wordWrap) wordWrap = 'break-word';
		return '<textarea id="'+(id||'')+'" style="border:1px solid #ccc;margin-top:5px;height:'+height+'px;overflow:auto;background-color:transparent;white-space:'+whiteSpace+';word-wrap:'+wordWrap+';font:11px Menlo,Courier;width:100%;box-sizing:border-box" readonly>'+text+'</textarea>';
	};

	
	window.parseFloatLocal = function parseFloatLocal(str) {
		if (typeof str === 'string') return str.replace(',','.')*1;
		return (str*1)||0;
	};

	
	window.getPathExtension = function getPathExtension(path) {
		if (!path) return '';
		if (path.indexOf('.') === -1) return '';
		return path.split('.').pop();
	};

	
	window.updateSubviewsWithCallback = function updateSubviewsWithCallback(view, cb, excludeStaticUITableViews, excludePrototypeCells, isInDynamicContext) {
		if (!view) return;
	
		var r = cb(view, isInDynamicContext);
		if (r === false) return;
	
		if (view.subviews)
		if (Array.isArray(view.subviews)) view.subviews.every(function (subview) {
			updateSubviewsWithCallback(subview, cb, excludeStaticUITableViews, excludePrototypeCells, isInDynamicContext);return true; }, this);
		
	
		if (view.staticSections && !(excludeStaticUITableViews && view.$type === 'UITableView')) {
			if (Array.isArray(view.staticSections)) view.staticSections.every(function (staticSection) {
				if (Array.isArray(staticSection.staticCells)) staticSection.staticCells.every(function (staticCell) {
					updateSubviewsWithCallback(staticCell, cb, excludeStaticUITableViews, excludePrototypeCells, isInDynamicContext);return true; }, this);
				return true; }, this);
			
		}
	
		if (!excludePrototypeCells) {
			if (view.cellPrototype)		updateSubviewsWithCallback(view.cellPrototype, cb, excludeStaticUITableViews, excludePrototypeCells, true);
			if (view.listHeaderView)	updateSubviewsWithCallback(view.listHeaderView, cb, excludeStaticUITableViews, excludePrototypeCells, false);
			if (view.listFooterView)	updateSubviewsWithCallback(view.listFooterView, cb, excludeStaticUITableViews, excludePrototypeCells, false);
		}
	};

	
	window.bindingsInfoForView = function bindingsInfoForView(view, sender) {
		var dict = {};
		updateSubviewsWithCallback(view, function (subview) {
			collectBindingsForObject(subview, dict, sender);
		});
		return dict;
	};

	
	window.propertyTypeInObject = function propertyTypeInObject(key, obj, data) {
		if (!obj) {
			return '';
		}
		if (obj.expectedTypeForPropertyWithData)
			return obj.expectedTypeForPropertyWithData(key, data||obj);
		if (obj.expectedTypeForProperty)
			return obj.expectedTypeForProperty(key);
	};

	
	window.valueTransformerForPropertyType = function valueTransformerForPropertyType(propertyType, binding) {
		if (propertyType === 'String')
			return 'TO_STRING';
		if (propertyType === 'Number')
			return 'TO_NUMBER';
		if (propertyType === 'Boolean') {
			if (binding && binding.valueTransformerIsBooleanInverter)
				return 'TO_INVERTED_BOOLEAN';
			return 'TO_BOOLEAN';
		}
		if (propertyType === 'Data')
			return 'TO_DATA';
	};

	
	window.collectBindingsForObject = function collectBindingsForObject(obj, dict, sender) {
		if (!obj) return;
		
		if (utiFromData(obj) === 'info.appdoo-mac.SegmentedNavigationArrows') return;
	
		if (Array.isArray(obj.bindings)) obj.bindings.every(function (binding) {
	
			if (!sender.bindingIsValid(binding)) {
				 console.warn('Could not generate bindings code, the destination object was not found.', binding);
				return true;
			}
			
			if (binding.destinationKeyPath === '^NULL^') return true;
	
			var destination = binding.destination;
			if (binding.enumerableItemAccess) destination = '∈'+destination;
	
			if (!dict[destination])
				 dict[destination] = {};
			if (!dict[destination][binding.destinationKeyPath])
				 dict[destination][binding.destinationKeyPath] = [];
	
			if (binding.treatAsReverseBinding) {
				
				var b = {
					sourceObjectID: binding.source,
					sourceObjectKeyPath: binding.sourceKeyPath,
					transformer: binding.transformer
				};
				dict[destination][binding.destinationKeyPath].push(b);
				return true;
			}
	
			var proto = prototypeFromData(obj);
			var propertyType = propertyTypeInObject(binding.sourceKeyPath, proto, obj);
			
			if (propertyType === undefined) {
				 console.error('Error: Ignoring the binding. The property_type is undefined: ', binding.sourceKeyPath, 'in:', obj.$id);
				return true;
			}

			if (!obj.$id) {
				 console.warn('Could not generate bindings code, the object has no ID!', obj);
				return true;
			}
			
			var b = {
				sourceObjectID: obj.$id,
				sourceObjectKeyPath: binding.sourceKeyPath,
				transformer: valueTransformerForPropertyType(propertyType, binding)
			};

			dict[destination][binding.destinationKeyPath].push(b);
	
			if (bindingShouldBeBidirectional(binding, obj)) {
				
				var inverseB = {
					sourceObjectID: binding.destination,
					sourceObjectKeyPath: binding.destinationKeyPath
				};
				
				if (!dict[obj.$id])
					dict[obj.$id] = {};
				if (!dict[obj.$id][binding.sourceKeyPath])
					dict[obj.$id][binding.sourceKeyPath] = [];
	
				dict[obj.$id][binding.sourceKeyPath].push(inverseB);
				
			}return true; }, this);
		
	};

	
	window.generateBindingsDictionaryForScene = function generateBindingsDictionaryForScene(scene, allObjects, sender, transformer) {
	
		var dict = {};
	
		var excludeStaticUITableViews = !scene.isEmbedded;

		updateSubviewsWithCallback(scene.viewController.viewData, function (subview) {
			if (!subview.bindings) {
				return true;
			}
			if (!subview.bindings.length) {
				return true;
			}
			collectBindingsForObject(subview, dict, sender);
		}, excludeStaticUITableViews, false); 

		if (scene.navigationBar) {
			var navigationItem = scene.navigationBar.items[0];
			collectBindingsForObject(navigationItem, dict, sender);
			collectBindingsForObject(navigationItem.leftBarButtonItem, dict, sender);
			collectBindingsForObject(navigationItem.rightBarButtonItem, dict, sender);
			collectBindingsForObject(navigationItem.titleView, dict, sender);
		}
	
		if (Array.isArray(allObjects)) allObjects.every(function (obj) {
			if (!transformer.isPreviewTransformer && obj.UTI === 'info.appdoo-mac.ObjectProxy') {
				return true;
			}
			collectBindingsForObject(obj, dict, sender);return true; }, this);
		
		return dict;
			
	};

	
	window.bindingShouldBeBidirectional = function bindingShouldBeBidirectional(binding, sourceObject) {
		if (!binding) return;
	
		if (binding.destinationObject) {
			if (!isKindOfType(sourceObject || binding.sourceObject, getType('appdoo.BasicDataSource'))) {
				return false;
			}
			return binding.destinationObject.mutable;
		}
		
		if (!sourceObject) return;
		
		if (!binding.destinationIsMutable) return false;
		var proto = prototypeFromData(sourceObject);
	
		if (!proto.propertyIsObservable) return false;
		return proto.propertyIsObservable(binding.sourceKeyPath);
	};
	
	window.prototypeFromData = function prototypeFromData(data) {
		if (data && data.UTI) return data.__proto__;
		var t = typeFromData(data);
		if (t) return t.prototype;
	};

	window.typeFromData = function typeFromData(data) {
		var type = getTypeFromDomain(data.$type, (data.$domain || 'appdoo.iOS'));
		return type;
	};
	
	
	window.determineBarTintColor = function determineBarTintColor(cssColor, barStyle, isTranslucent) {

		if (!isTranslucent) {
			if (!cssColor) {
				if (barStyle === 1)
					return 'rgba(0,0,0,1)';
				return 'rgba(255,255,255,1)';
			}
			return cssColor;
		}
		
		var max = 0.6;
		if (!cssColor) {
			if (barStyle === 1)
				return 'rgba(0,0,0,'+max+')';
			return 'rgba(255,255,255,0.85)';
		}
			
		var pieces = parseRgbCSSColor(cssColor);
		if (pieces) {
			if (!pieces[3] || pieces[3] > max)
				pieces[3] = max;
			cssColor = 'rgba('+pieces[0]+','+pieces[1]+','+pieces[2]+','+pieces[3]+')';
		}
		
		return cssColor;
		
	};

	
	window.namesForFormElements = function namesForFormElements(formView) {
	
		var dict = {
		
		};
		
		updateSubviewsWithCallback(formView, function (view) {
			if (view.isFormElement) {
				if (view.name) {
					var value = view.value;
					
					switch (typeof value) {
						case 'boolean':
							dict[view.name] = value ? 1 : 0;
							break;
						case 'string':
						case 'number':
							dict[view.name] = value;
							break;
					}
				}
			}
		});
			
		return dict;
	
	};
	
	
	window.EditableObjectGetActionInfoProperty = function EditableObjectGetActionInfoProperty() {
	
		if (!this._actionInfo) {
			this.actionInfo = createComponentFromDomain('ActionInfo','appdoo',this.context, {});
		}
		return this._actionInfo;
	
	};

	
	window.EditableObjectSetActionInfoProperty = function EditableObjectSetActionInfoProperty(v) {
		if (v && !v.UTI) {
			v = this.context.decodeObjectTree(v);
		}
		this._actionInfo = v;
		if (v && v.UTI) {
			v.parentObject = this;
		}
	};

	
	window.zeroFill = function zeroFill(number, width) {
		width -= number.toString().length; if ( width > 0 ) { return new Array( width + (/\./.test( number ) ? 2 : 1) ).join( '0' ) + number; } return number + "";
	};

	
	
	window.utiFromData = function utiFromData(data) {
		if (!data) return;
		if (data.UTI) return data.UTI; 
		return data.$domain+'.'+data.$type; 
	};

	
	
	window.arrayHasUniqueValue = function arrayHasUniqueValue(a, v) {
		var isUnique = true;
		if (Array.isArray(a)) a.every(function (_v) {
			if (_v !== v) {
				isUnique = false;
				return false;
			}return true; }, this);
		
		return isUnique;
	};

	
	window.ucfirst = function ucfirst(str) {
		if (!str) return '';
		return str[0].toUpperCase() + str.substr(1);
	};

	
	window.lcfirst = function lcfirst(str) {
		if (!str) return '';
		return str[0].toLowerCase() + str.substr(1);
	};
	
appdoo.prototype.initPropertiesFromData = function appdoo_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("isDebugging")) this.isDebugging = data.isDebugging;
if (data.hasOwnProperty("isOffscreen")) this.isOffscreen = data.isOffscreen;
if (data.hasOwnProperty("disableInAppPreferences")) this.disableInAppPreferences = data.disableInAppPreferences;
if (data.hasOwnProperty("themeName")) this.themeName = data.themeName;
};

appdoo.prototype.decodeData = function appdoo_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

appdoo.prototype.encode = function appdoo_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

appdoo.prototype.encodeCloned = function appdoo_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

appdoo.prototype.expectedTypeForProperty = function appdoo_expectedTypeForProperty(key) {
	if (key === "isDebugging") return "";
	if (key === "isOffscreen") return "";
	if (key === "disableInAppPreferences") return "";
	if (key === "themeName") return "";
	if (key === "objectTreeDataType") return "";
	if (key === "objectBlueprintDataType") return "";
	if (key === "resourceReferenceDataType") return "";
	if (key === "promisedRealObjectsDataType") return "";
	if (key === "scenesDataType") return "";
	if (key === "supportedImageMimeTypes") return "";
	if (key === "supportedOfficeMimeTypes") return "";
	if (key === "projectDataDirectory") return "";
	if (key === "temporaryDataDirectory") return "";
	if (key === "isEditingNewProject") return "";
	if (key === "prototypeDevicesBar") return "";
	if (key === "fileExtensionsForImport") return "";
	if (key === "elementGroups") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return appdoo; }()));
registerType('appdoo', (function () { function UserPlugInManager() {} var __super = setSupertypeFromDomain(UserPlugInManager, 'BasicObject', 'Core');
		
UserPlugInManager.prototype.uninstallPlugIn = function UserPlugInManager_uninstallPlugIn(plugIn) {
		this.context.nativeProxy.sendMessage('uninstallPlugIn', plugIn.pluginIdentifier);};
	
	
UserPlugInManager.prototype.finishPlugInUninstallment = function UserPlugInManager_finishPlugInUninstallment(pluginIdentifier) {
	
		var plugIn = window.availablePlugins[pluginIdentifier];
	
		var i = window.userPlugIns.indexOf(plugIn);
		if (i === -1) return;
		window.userPlugIns.splice(i, 1);

		v = window.availablePlugins[plugIn.pluginIdentifier];
		if (v === plugIn) delete window.availablePlugins[plugIn.pluginIdentifier];
		
		this.context.resetElementGroups();
		this.dispatchEvent({type:'change',which:plugIn});};
	
	
UserPlugInManager.prototype.expectedTypeForProperty = function UserPlugInManager_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UserPlugInManager; }()));