
registerType('appdoo.iOSGenerator', (function () { function XIBGenerator() {} var __super = setSupertypeFromDomain(XIBGenerator, 'BasicObject', 'Core');

	Object.defineProperty(XIBGenerator.prototype, "isXIBGenerator", {
		value: true});
	

XIBGenerator.prototype.init = function XIBGenerator_init() {
		__super.prototype.init.call(this);
		this.prepare();
		return this;};
	

	Object.defineProperty(XIBGenerator.prototype, "template", {
		get: function () {
			var template = {"document": {
				"type": "com.apple.InterfaceBuilder3.CocoaTouch.XIB",
				"version": "3.0",
				"toolsVersion": "4488.2",
				"systemVersion": "13A558",
				"targetRuntime": "iOS.CocoaTouch",
				"propertyAccessControl": "none",
				"dependencies": {
					"development": {
						"defaultVersion": "1536",
						"identifier": "iOS"
					},
					"plugIn": {
						"identifier": "com.apple.InterfaceBuilder.IBCocoaTouchPlugin",
						"version": "3715.3"
					}
				},
				"objects": {
        			"placeholder IBFilesOwner": { "placeholderIdentifier": "IBFilesOwner", "id": "-1", "userLabel": "File's Owner" },
					"placeholder IBFirstResponder": { "placeholderIdentifier": "IBFirstResponder", "id": "-2", "customClass": "UIResponder" }
				},
			}};
				
			return template;
		}});
	
	
XIBGenerator.prototype.prepare = function XIBGenerator__prepare() {

		this.objectIDs = {};
		this._nextId = 1;
		this._viewControllerSceneIds = {};
		this._tabBarControllerDestinations = {};
		this._lastSceneY = undefined;
		this._sourceObjectsByID = {};
		this.currentViewControllerStack = [];
		this.currentOriginalSceneStack = [];
		this.sceneForViewControllerId = {};
		this.objectIDs = {};
		this.selectorNames = {};
		this.viewTags = {};
		this.nextViewTag = 100;
	};
	
	
	Object.defineProperty(XIBGenerator.prototype, "productGenerator", {
	outlet: true, get:function () { return this._productGenerator; }, set:function (v) {if (!Object.hasOwnProperty(this, "_productGenerator")) Object.defineProperty(this, "_productGenerator", { writable: true, configurable: true }); this._productGenerator = v; }});
	
	
XIBGenerator.prototype.transformDataWithPrototype = function XIBGenerator__transformDataWithPrototype(data, proto) {

		if (!proto) return {};
	
		if (proto.transformData)
			return proto.transformData(data, this);
};
	
	
XIBGenerator.prototype.generateXIBFromObjects = function XIBGenerator_generateXIBFromObjects(objects) {

		var result = this.template;

		var filesOwner = result.document.objects["placeholder IBFilesOwner"];
		
		filesOwner.customClass = "AppDelegate";
		filesOwner.connections = {};
		
		
		if (Array.isArray(objects)) objects.every(function (object) {
			handleObject.call(this, object);return true; }, this);
		

		if (Array.isArray(this.productGenerator.globalInlineObjects)) this.productGenerator.globalInlineObjects.every(function (object) {
			handleObject.call(this, object);return true; }, this);
		
		
		function handleObject(object) {
		
			if (utiFromData(object) === 'info.appdoo-mac.PerformSelectorInstruction') {
				return;
			}
			var proto = getPrototype(utiFromData(object));
			var data = this.transformDataWithPrototype(object, proto);
			
			if (!data) return;
				
			data.id = this.createStoryboardID();
			
			result.document.objects[(proto.storyboardTagName||'customObject')+' '+data.id] = data;
			
			var outletName = this.productGenerator.outletNameForProjectID[object.$id];
			if (!outletName) {
				outletName = this.productGenerator.reserveOutletName(object);
			}
			
			var connection = {
				'property': outletName,
				destination: data.id,
				id: this.createStoryboardID()
			};
			filesOwner.connections['outlet '+data.id] = connection;
			logConnection(connection, filesOwner);
			
		}
		
		var jsonString = JSON.stringify(result, true, '	');
		return jsonString;
		};
	
	

	
	
	Object.defineProperty(XIBGenerator.prototype, "currentOriginalScene", {
		get: function () { return this.currentOriginalSceneStack[this.currentOriginalSceneStack.length-1]; }});
	


XIBGenerator.prototype.transformCSSColor = function XIBGenerator_transformCSSColor(color, key) {

		return this.productGenerator.transformCSSColor(color, key);	};
	

XIBGenerator.prototype.transformToSize = function XIBGenerator_transformToSize(width, height, key) {

		return {
			key: key,
			width: (width || 0).toString(),
			height: (height || 0).toString()
		};	};
	

	var UIViewClass;

XIBGenerator.prototype.transformView = function XIBGenerator_transformView(data, useUIViewPrototype) {
	
		if (!data) {
			console.error('transformView() called with no data!');
			console.trace();
			return {};
		}

		if (UIViewClass === undefined)
			UIViewClass = getType('appdoo.iOS.UIView');

		var viewProto = (useUIViewPrototype || data.$type === 'UIView') ? UIViewClass.prototype : this.prototypeFromData(data);


		if (!viewProto) {
			console.warn('Missing prototype for view:', data);
			viewProto = UIViewClass.prototype;
		}

		return this._transformDataWithObjectType(data, viewProto);
	};
	
	
XIBGenerator.prototype.transformImageURL = function XIBGenerator_transformImageURL(info) {
		return _context.transformImageURL(info);};
	

XIBGenerator.prototype.configureInlineImage = function XIBGenerator_configureInlineImage(result, imageRef, contentMode) {
		result.image = imageRef.imageID;
		if (!result.image) return; 
		if (result.image.indexOf('.') === -1) result.image += '.png';
		this.registerImage(imageRef.imageID, contentMode||result.contentMode);};
	

XIBGenerator.prototype.configureReferencedImage = function XIBGenerator_configureReferencedImage(result, fileRefID, remoteImageURL, key, isUserDefinedRuntimeAttribute) {
		
		this.demandPlugin('info.appdoo-mac.UIImageView+URL');
		this.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');
		
		var url;
		if (fileRefID) {
			var ref = _context.projectContext.fileReferenceWithID(fileRefID);
			if (ref) {
				if (isUserDefinedRuntimeAttribute)
					url = 'file:'+ref.name;
				else url = ref.name;
				this.productGenerator.registerResourceUsage(ref, result);
			}
		}
		else if (remoteImageURL) {
			url = remoteImageURL;
		}

		if (url) {
			if (isUserDefinedRuntimeAttribute)
			result.userDefinedRuntimeAttributes = {
				userDefinedRuntimeAttribute: {
					type: "string",
					keyPath: key,
					value: url
				}
			};
			else
			result[key] = url;
		}};
	

	
XIBGenerator.prototype.transformFileReference = function XIBGenerator_transformFileReference(idString) {
		return _context.transformFileReference(idString);};
	
	
XIBGenerator.prototype.transformBoolean = function XIBGenerator_transformBoolean(b) {
		return (!!b) ? 'YES' : 'NO';};
	
	
XIBGenerator.prototype.transformFont = function XIBGenerator_transformFont(fontOrFontName, fontSize, fontFamily) {
	
		var fontName;
		if (typeof fontOrFontName === 'object') {
			fontName = fontOrFontName.fontName;
			fontSize = fontOrFontName.pointSize;
			fontFamily = fontOrFontName.fontFamily;
		}
		else fontName = fontOrFontName;

		var fontDescription = {
			key: 'fontDescription',
			pointSize: fontSize
		};

		if (!fontName || fontName[0] === '_') {
			if (fontName === '_DEFAULT_BOLD_')
				fontDescription.type = 'boldSystem';
			else if (fontName === '_DEFAULT_ITALIC_')
				fontDescription.type = 'italicSystem';
			else
				fontDescription.type = 'system';
		} else {
			fontDescription.family = fontFamily;
			fontDescription.name = fontName;
		}
		if (!fontDescription.family)
			fontDescription.family = fontDescription.name;

		return fontDescription;
		};
	
	
	
XIBGenerator.prototype.cocoaTypeForData = function XIBGenerator_cocoaTypeForData(data, proto) {
	
		if (!proto) proto = this.prototypeFromData(data);
		if (!proto) { console.warn('proto not found:', data); return 'NSObject'; }
		
		if (proto.cocoaTypeForData)
			return proto.cocoaTypeForData(data);
		
		return proto.cocoaType || proto.constructor.name;
};
	

XIBGenerator.prototype.cocoaCustomTypeForData = function XIBGenerator_cocoaCustomTypeForData(data, proto) {
		if (!proto) proto = this.prototypeFromData(data);
		if (!proto) { console.warn('proto not found:', data); return ''; }
		
		if (proto.cocoaCustomTypeForData)
			return proto.cocoaCustomTypeForData(data);
		
		return proto.cocoaCustomType;};
	

XIBGenerator.prototype.tagNameForView = function XIBGenerator_tagNameForView(view) {
	
		var cocoaType = this.cocoaTypeForData(view);
		if (!cocoaType) {
			console.warn('Missing "cocoaType" property:', view);
			return 'view';
		}
		
		var tagName = cocoaType;
		
		if (tagName.indexOf('UI') === 0 ||
			tagName.indexOf('MK') === 0 ||
			tagName.indexOf('NS') === 0) {

			tagName = cocoaType.substr(2);
			
			var	firstLetter = tagName[0].toLowerCase(),
				tagName = firstLetter + tagName.substr(1);
				
			return tagName;
			
		}
		
		return 'view';
	};
	

XIBGenerator.prototype.transformSubviews = function XIBGenerator_transformSubviews(subviews, subviewsContainer) {
	
		if (!subviews) return;
		
		var i = 1;
		subviews.every(function (subview) {
		
			var subviewProto = this.prototypeFromData(subview);
			if (!subviewProto || !subviewProto.transformData) {
				console.warn('No transformator for ', subviewProto);
				return true;
			}
			

			if (subviewProto.isPlugin) {
				this.productGenerator.registerPluginObject(subview, this.currentViewControllerData, this.currentCellData);
			}

			var data = this._transformDataWithObjectType(subview, subviewProto);
			if (!data) {
				console.error('Transfoming a subview failed:', subview);
				i++;
				return true;
			}
			
			if (!data.id) data.id = this.storyboardIDForComposeObject(subview);

			var tagName = data.subviews ? 'view' : this.tagNameForView(subview);
			if (data.$tagName) { tagName = data.$tagName; delete data.$tagName; }

			subviewsContainer[zeroFill(i,3)+'. '+tagName] = data;

			i++;
			return true;

		}.bind(this));
};
	
		
XIBGenerator.prototype.demandPlugin = function XIBGenerator_demandPlugin(pluginIdentifier) {
		this.demandPluginWithIdentifier(pluginIdentifier);};
	

XIBGenerator.prototype.demandPluginWithIdentifier = function XIBGenerator_demandPluginWithIdentifier(pluginIdentifier) {
		this.productGenerator.demandPluginWithIdentifier(pluginIdentifier, this.currentViewControllerData);};
	
	
XIBGenerator.prototype.registerClassWithoutHeader = function XIBGenerator_registerClassWithoutHeader(className) {
		this.productGenerator.registerClassWithoutHeader(className, this.currentViewControllerData);};
	
	

XIBGenerator.prototype.createStoryboardID = function XIBGenerator_createStoryboardID() {
		return (this._nextId++).toString();};
	

	
	window.CSymbolComformString = function CSymbolComformString(str) {
		str = str.replace(/\W/g, ' ');
		str = str.split(' ').map(function (component) { return ucfirst(component); }).join('');
		return str;
	}

XIBGenerator.prototype.addOutletForDataAndId = function XIBGenerator_addOutletForDataAndId(sourceData, destinationId, proposedOutletName, outletType) {

		
		if (this.currentCell && this.currentCell.$type === 'CollectionViewCellContentView' && !this.currentCell.isPrototype) return;
	
		var outletName = this.productGenerator.generateOutletName(sourceData, proposedOutletName);

		if (!this.currentViewController) return;
		
		if (this.currentViewController.connections === undefined)
			this.currentViewController.connections = {};
		
		var outletNameCopy = outletName, i = 1;
		
		
		if (!this.productGenerator.outletNameIsValid(outletName)) outletName = outletNameCopy+'1';
		
		while(this._currentViewControllerOrCellHasOutletNamed(outletName) || !this.productGenerator.outletNameIsValid(outletName)) {
			i += 1;
			outletName = outletNameCopy + i;
		}
		
		this.productGenerator.outletNameForProjectID[sourceData.$id] = outletName;
		
		var proto = this.prototypeFromData(sourceData),
			cocoaType = this.cocoaTypeForData(sourceData, proto),
			cocoaCustomType = this.cocoaCustomTypeForData(sourceData, proto);
		if (outletType) cocoaCustomType = outletType;
		
		if (this.currentCellClass !== undefined) {
		
			if (!this.currentCell.connections)
				this.currentCell.connections = {};

			var connection = {
				property: outletName,
				destination: destinationId,
				id: this.createStoryboardID()
			};
			this.currentCell.connections['outlet '+outletName] = connection;
			
			logConnection(connection, this.currentCell);
			
			this.productGenerator.registerOutlet(
				outletName, cocoaType, cocoaCustomType, sourceData.bindings, this.currentCellClass, sourceData);
		
		}
		else {
		
			var connection = {
				property: outletName,
				destination: destinationId,
				id: this.createStoryboardID()
			};
			this.currentViewController.connections['outlet '+outletName] = connection;
			
			logConnection(connection, this.currentViewController);
			
			this.productGenerator.registerOutlet(
				outletName, cocoaType, cocoaCustomType, sourceData.bindings, this.currentViewControllerClassId, sourceData);

		}
		};
	
	

XIBGenerator.prototype.willTransformCellWithIdentifier = function XIBGenerator_willTransformCellWithIdentifier(cell, cellIdentifier, parentViewData, originalData) {

	
		if (parentViewData.$type === 'UITableView' || parentViewData.$type === 'ASStaticTableView' || parentViewData.$type === 'ASFeedTableView') {
	
			
			this.currentCellClass =
				this.productGenerator.registerTableCellClass(cellIdentifier, parentViewData, originalData, this.currentViewController.customClass);
				
		}
		else if (parentViewData.$type === 'UICollectionView') {

			this.currentCellClass =
				this.productGenerator.registerCollectionCellClass(cellIdentifier, parentViewData, originalData, this.currentViewController.customClass);
		
		}
		
		this.currentCell = cell;
		this.currentCellData = originalData;

		this.isTransformingRootView = true;
		this.isTransformingCell = true;
		
		return this.currentCellClass;
};
	
	
XIBGenerator.prototype.codeIDForDataSource = function XIBGenerator_codeIDForDataSource(dataSource) {
		if (dataSource)
			return this.productGenerator.dataSourceCodeIDs[dataSource.$id];};
	

XIBGenerator.prototype.didTransformCell = function XIBGenerator_didTransformCell() {
	
		this.currentCellClass = undefined;
		this.currentCell = undefined;
		this.isTransformingRootView = false;
		this.currentCellData = undefined;
		this.isTransformingCell = false;
};
	
	
XIBGenerator.prototype.registerImage = function XIBGenerator_registerImage(imageName, contentMode) {
		this.productGenerator.registerImage(imageName, contentMode);};
	
	
	
	
	Object.defineProperty(XIBGenerator.prototype, "isTransformingRootView", {
	synthesized: true, get:function () { return this._isTransformingRootView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isTransformingRootView")) Object.defineProperty(this, "_isTransformingRootView", { writable: true, configurable: true }); this._isTransformingRootView = v; }});
	


XIBGenerator.prototype.typeFromData = function XIBGenerator__typeFromData(data) {
		console.trace();
		return this.productGenerator.typeFromData(data);};
	
	
XIBGenerator.prototype.prototypeFromData = function XIBGenerator__prototypeFromData(data) {
		return this.productGenerator.prototypeFromData(data);};
	

XIBGenerator.prototype._transformDataWithObjectType = function XIBGenerator___transformDataWithObjectType(data, proto) {
		if (!proto.transformData) {
			console.warn('The prototype does not implement transformData().', proto);
			return;
		}
		if (!data.$id) this.context.projectContext.identify(data, data.$type);
		var result = this.transformDataWithPrototype(data, proto);
		if (data.$id) this._sourceObjectsByID[data.$id] = data;
		return result;};
	
	
	Object.defineProperty(XIBGenerator.prototype, "currentViewController", {
		get: function () {
			var a = this.currentViewControllerStack[this.currentViewControllerStack.length-1];
			if (a) return a[0];
		}});
	

	Object.defineProperty(XIBGenerator.prototype, "currentViewControllerXID", {
		get: function () {
			var a = this.currentViewControllerStack[this.currentViewControllerStack.length-1];
			if (a) return a[0].id;
		}});
	

	Object.defineProperty(XIBGenerator.prototype, "currentViewControllerData", {
		get: function () {
			var a = this.currentViewControllerStack[this.currentViewControllerStack.length-1];
			if (a) return a[1];
		}});
	

	Object.defineProperty(XIBGenerator.prototype, "currentViewControllerId", {
		get: function () {
			if (this.productGenerator.isTransformingGlobalObjects) return 'AppDelegate';
			var a = this.currentViewControllerStack[this.currentViewControllerStack.length-1];
			if (a) return a[1].$id;
		}});
	

	Object.defineProperty(XIBGenerator.prototype, "currentViewControllerClassId", {
		get: function () {
			return this.currentViewControllerStack[this.currentViewControllerStack.length-1][0].customClass;
		}});
	
	
XIBGenerator.prototype.transformRootViewFromScene = function XIBGenerator__transformRootViewFromScene(scene) {

		this.isTransformingRootView = true;
		var encodedView = this.transformView(scene.viewController.viewData);
		
		
		var backgroundColor = encodedView['color backgroundColor'];
		if (backgroundColor) {
			backgroundColor.alpha = 1;
		}

		this.isTransformingRootView = false;
		
		var isScrollView = scene.viewController.viewData.v_scrollsVertically || scene.viewController.viewData.v_scrollsHorizontally;
		
		encodedView.customClass = isScrollView?'SimpleScrollView':undefined;
		
		if (isScrollView) {
			encodedView.userDefinedRuntimeAttributes = {};
			encodedView.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute canScrollVertically'] = {
				type: "boolean",
				keyPath: "canScrollVertically",
				value: scene.viewController.viewData.v_scrollsVertically
			};
			encodedView.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute canScrollHorizontally'] = {
				type: "boolean",
				keyPath: "canScrollHorizontally",
				value: scene.viewController.viewData.v_scrollsHorizontally
			};
		}

		this.addOutletForDataAndId(scene.viewController.viewData, encodedView.id, 'contentView');

		if (scene.e_separateStatusBar) {
		
			
			this.isTransformingRootView = true; 
			
			var sbbv = this.transformView(scene.statusBarBackgroundView);
			sbbv.userDefinedRuntimeAttributes = {};

			this.isTransformingRootView = false;

			var subviews = {};
			subviews[(isScrollView?'scrollView':'view')+' contentView'] = encodedView;
			subviews['view statusBarBackgroundView'] = sbbv;
			
			
			var containerView = {
				id: this.createStoryboardID(),
				rect: clone(encodedView.rect),
				subviews: subviews
			};
			
			if (scene.statusBarBackgroundView.translucent) {
			
			}
			else {
				containerView.rect.height += 21;
				encodedView.rect.y = 21;
			}
			
			return containerView;
		}
		
		return encodedView;};
	
	
XIBGenerator.prototype.sceneIsInTabBar = function XIBGenerator__sceneIsInTabBar(scene) {
	
		if (!scene || !scene.viewController) return;

		 return _context.projectContext.tabBarController &&
						_context.projectContext.tabBarController.numberOfItems &&
						_context.projectContext.tabBarController.viewControllerIDs.indexOf(scene.viewController.$id) !== -1;
	};
	


XIBGenerator.prototype._transformViewControllerInScene = function XIBGenerator___transformViewControllerInScene(sourceSceneData, scenesContainer) {
	
		var viewController = sourceSceneData.viewController;
	
		if (this.sceneForViewControllerId[viewController.$id])
			return this.sceneForViewControllerId[viewController.$id];

		var scene = this._createSceneObject(isInTabBar);
		this.sceneForViewControllerId[viewController.$id] = scene;

		var isInTabBar = this.sceneIsInTabBar(sourceSceneData);

		this.productGenerator.registerViewController(viewController, sourceSceneData);

		var transformedViewController = {
			id: this.storyboardIDForComposeObject(viewController),
			customClass: this.productGenerator.codeIDForViewControllerID(viewController.$id),
			sceneMemberID: 'viewController',
			title: viewController.title,
			storyboardIdentifier: sourceSceneData.$id,
			userLabel: sourceSceneData.viewController.title,
			automaticallyAdjustsScrollViewInsets: 'NO',
			hidesBottomBarWhenPushed: this.transformBoolean(!sourceSceneData.showsTabBar)
		};

		this.setStringProperty(transformedViewController, 'originalSceneID', sourceSceneData.$id);
		
		this.currentViewControllerStack.push([transformedViewController, viewController]);
		this.currentOriginalSceneStack.push(sourceSceneData);

		var encodedView = this.transformRootViewFromScene(sourceSceneData);
		encodedView.key = 'view';
		
		if (sourceSceneData.e_separateStatusBar || !(sourceSceneData.viewController.viewData.v_scrollsVertically || sourceSceneData.viewController.viewData.v_scrollsHorizontally)) {
			transformedViewController.view = encodedView;
		} else {
			transformedViewController.scrollView = encodedView;
		}
		
		
		encodedView.contentMode = 'scaleToFill';

		scene.objects.viewController = transformedViewController;
		this._viewControllerSceneIds[viewController.$id] =
			transformedViewController.id;
		
		scenesContainer['scene '+viewController.$id] = scene;
		
		if (isInTabBar === true) {
			this.addTabBarItemToTransformedVC(transformedViewController, viewController);
		}
		
		if (sourceSceneData.navigationBar) {
			this.handleInlineImage(sourceSceneData.navigationBar.v_backgroundImage);
			this.handleInlineImage(sourceSceneData.navigationBar.v_titleViewImage);

			if (sourceSceneData.navigationBar.items && sourceSceneData.navigationBar.items.length) {
				
				
				
				
				
				sourceSceneData.navigationBar.items[0].bindings = sourceSceneData.navigationBar.bindings;
				
				transformedViewController.navigationItem = 
					this.transformDataWithPrototype(sourceSceneData.navigationBar.items[0], getPrototype('appdoo.iOS.UINavigationItem'));
				if (!transformedViewController.navigationItem.title)
					transformedViewController.navigationItem.title = this.transformString(sourceSceneData.navigationBar.title);
			}
			else {
				transformedViewController.navigationItem = {
					key: 'navigationItem',
					title: this.transformString(sourceSceneData.navigationBar.title),
					id: this.createStoryboardID()
				};
			}

		}
		
		this.addAllObjectsToStoryboardScene(scene, sourceSceneData);

		if (sourceSceneData.landscape) {
			transformedViewController.simulatedOrientationMetrics = { key: 'simulatedOrientationMetrics', orientation: 'landscapeRight' };
		}
		
		transformedViewController.simulatedScreenMetrics = { key: 'simulatedDestinationMetrics', type: 'retina4' };

		this.currentOriginalSceneStack.pop();
		this.currentViewControllerStack.pop();
		return scene;
};
	
	
XIBGenerator.prototype.addAllObjectsToStoryboardScene = function XIBGenerator_addAllObjectsToStoryboardScene(scene, sourceSceneData) {
		
		this.allObjectsWorkerArray = clone(this.productGenerator.allObjectsForScene(sourceSceneData));
		
		while (this.allObjectsWorkerArray.length) {
		
			var liveObject = this.allObjectsWorkerArray.pop();

			if (!liveObject.encode) {
				console.warn('Object cannot be encoded:', liveObject);
				continue;
			}
			
			if (liveObject instanceof getType('appdoo.ResourceReference'))
				continue;

			if (liveObject instanceof getType('appdoo.iOS.iOSInstruction'))
				continue;

			var obj = liveObject.encode();
			if (!obj || !obj.$type) continue;

			if (liveObject.transformDataForObjectiveC) {
 				continue;
			}

			var objID = this.storyboardIDForObjectID(obj.$id);
			
			var shouldHaveOutlet = (function (o, proto) {
			
				if (proto.needsNoObjCOutlet) return false;
				if (proto.needsNoObjCOutletForInstance) return !proto.needsNoObjCOutletForInstance(o);
				return true;
				
			}(liveObject, liveObject));

			
			if (shouldHaveOutlet)
			 	this.addOutletForDataAndId(obj, objID);

			var objProto = this.prototypeFromData(obj);

			var objData;
			if (!objProto) {
				continue;
			}
			
			if (!objProto || !objProto.transformData) {
				console.warn('No transformator for ', objProto);
				objData = {
					customClass: obj.$type
				};
			}
			else {
				objData = this._transformDataWithObjectType(obj, objProto);
			}
			if (!objData) {
				console.error('Failed to transform the object:', obj);
				continue;
			}

			objData.id = objID;
			
			if (liveObject.cocoaType && (liveObject.cocoaType.indexOf('UI') === 0 || liveObject.cocoaType.indexOf('MK') === 0)) {
				scene.objects[this.tagNameForView(liveObject)+' '+objID] = objData;
			}
			else {
				scene.objects['customObject '+objID] = objData;
			}
			
			if (objProto.pluginIdentifier || objProto.isPlugin)
				this.demandPlugin(objProto.pluginIdentifier || (obj.$domain+'.'+obj.$type));

		}
		
		this.allObjectsWorkerArray = null;
		};
	
	
XIBGenerator.prototype.handleInlineImage = function XIBGenerator_handleInlineImage(imageRef) {
		return this.productGenerator.handleInlineImage(imageRef);};
	
	
XIBGenerator.prototype.addTabBarItemToTransformedVC = function XIBGenerator__addTabBarItemToTransformedVC(transformedViewController, viewController) {

		if (!viewController.tabBarItem) {
			
			transformedViewController.tabBarItem = {
				key: 'tabBarItem',
				title: viewController.title,
				id: this.createStoryboardID()
			};
			return;
		}
		
				
		transformedViewController.tabBarItem = {
			key: 'tabBarItem',
			title: viewController.tabBarItem.title || viewController.title,
			id: this.createStoryboardID()
		};
		
		if (viewController.tabBarItem.image) {
			transformedViewController.tabBarItem.image = this.handleInlineImage(viewController.tabBarItem.image);
		}
		
		var unselectedImageName = this.handleInlineImage(viewController.tabBarItem.unselectedImage);
		if (unselectedImageName) {
			
			transformedViewController.tabBarItem.userDefinedRuntimeAttributes = {};
			transformedViewController.tabBarItem.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute unselectedImageName'] = {
				type: "string",
				keyPath: "unselectedImageName",
				value: unselectedImageName
			};
			
			this.demandPlugin('info.appdoo-mac.UITabBarItemUnselectedImage');
		}
		};
	
	
	var modalTransitionStyleByString = { 'UIModalTransitionStyleCoverVertical': 'coverVertical', 'UIModalTransitionStyleFlipHorizontal': 'flipHorizontal', 'UIModalTransitionStyleCrossDissolve': 'crossDissolve' };

XIBGenerator.prototype.transformModalTransitionStyle = function XIBGenerator_transformModalTransitionStyle(str) {
		return modalTransitionStyleByString[str];};
	

XIBGenerator.prototype._addNavigationControllerForVC = function XIBGenerator___addNavigationControllerForVC(vcData, scenes) {
	
		var scene = this._createSceneObject(true);
		
		scene.objects.navigationController = {
			definesPresentationContext: 'YES',
			id: this.storyboardIDForObjectID(vcData.$id+'NavigationController'),
			sceneMemberID: 'viewController',
			navigationBar: {
				key: 'navigationBar',
				opaque: this.transformBoolean(false),
				clipsSubviews: this.transformBoolean(true),
				contentMode: 'scaleToFill',
				id: this.createStoryboardID(),
				translucent: this.transformBoolean(false)
			},
			connections: {}
		};
		
		this.addTabBarItemToTransformedVC(scene.objects.navigationController, vcData);


		scenes['scene NAV_'+vcData.$id] = scene;
		
		return scene;
		};
	
	

XIBGenerator.prototype._addTabBarControllerScene = function XIBGenerator___addTabBarControllerScene(tbcData, result) {

		var scenes = result.document.scenes;
	
		var data = this._createSceneObject(false);
		scenes['scene tabBarController'] = data;
		
		var id = this.createStoryboardID();
		result.document.initialViewController = id;
		
		var numberOfTabBarItems = tbcData.viewControllerIDs ? tbcData.viewControllerIDs.length : 0;
		
		data.point.x = "132";
		data.point.y =
			((this.context.projectContext.screenSizeInPoints.height+156) * ((numberOfTabBarItems-1)/2)).toString();
		
		var tabBar = this.transformDataWithPrototype(tbcData.tabBar, this.prototypeFromData(tbcData.tabBar));

		data.objects.tabBarController = {
			id: id,
			sceneMemberID: 'viewController',
			nil: { key: 'simulatedBottomBarMetrics' },
			simulatedScreenMetrics: { key: "simulatedDestinationMetrics", type: "retina4" },
			tabBar: tabBar,
			connections: {}
		};
		
		var i = 1;
		tbcData.viewControllerIDs.every(function (id) {
			var connection = {
				destination: this._tabBarControllerDestinations[id],
				kind: 'relationship',
				relationship: 'viewControllers',
				id: this.createStoryboardID()
			};
			data.objects.tabBarController.connections['segue '+(i++)] = connection;
			logConnection(connection, data.objects.tabBarController);
			return true;
		}.bind(this));
	};
	

XIBGenerator.prototype._createSceneObject = function XIBGenerator___createSceneObject(placeInNewRow) {
		return {
			sceneID: this.createStoryboardID(),
			objects: {
				placeholder: {
					placeholderIdentifier: "IBFirstResponder",
					id: this.createStoryboardID(),
					sceneMemberID: "firstResponder"
				}
			},
			point: this._getSceneLocation(this.context.projectContext.screenSizeInPoints.height, placeInNewRow)
			
		};};
	
	
XIBGenerator.prototype._getSceneLocation = function XIBGenerator___getSceneLocation(_sceneSize, changeRow) {
	
		var sceneSize = this.context.projectContext.screenSizeInPoints;
		
		if (this._lastSceneY === undefined) {
			this._lastSceneX = 653;
			this._lastSceneY = 0;
		}
		else if (changeRow === true) {
			this._lastSceneX = 653;
			this._lastSceneY += sceneSize.height + 156;
		}
		else {
			this._lastSceneX += sceneSize.width + 156;
		}
	
		return {
			key: "canvasLocation",
			x: this._lastSceneX.toString(),
			y: this._lastSceneY.toString()
		}
};
	

XIBGenerator.prototype._addImageReferences = function XIBGenerator___addImageReferences(sourceContainer, targetContainer) {
	
		if (!sourceContainer) return;

		var i = 1;
		sourceContainer.every(function (resource) {

			var size;
			if (resource.occupant !== undefined) {
				
				var occupant = this._sourceObjectsByID[resource.occupant];
				if (occupant !== undefined) size = occupant.size;
			}
			if (size === undefined) {
				size = resource.size;
			}
			
			targetContainer['image '+(i++)] = {
				name: resource.name,
				width: size.width,
				height: size.height
			};
			return true;
		}.bind(this));};
	
	
XIBGenerator.prototype._transformAllViewControllers = function XIBGenerator___transformAllViewControllers(originalScenes, result) {

		var scenes = result.document.scenes,
			isInTabBar = false,
			ids = [];

		originalScenes.every(function (originalScene) {
			var id = this._transformViewControllerWithID(originalScene.viewController.$id, scenes, isInTabBar);
			ids.push(id);
			var customInitialVC = (this.context.projectMetadataController.get("initialViewController") || "");
			if(customInitialVC && originalScene.viewController.$id == customInitialVC) {
				result.document.initialViewController = id;
			}
			return true;
		}.bind(this));

		if(!result.document.initialViewController) {
			result.document.initialViewController = ids[0];
		}
};
	

XIBGenerator.prototype.transformRemainingScenes = function XIBGenerator__transformRemainingScenes(originalScenes, result) {

		var storyboardScenes = result.document.scenes;
		var originalScenes = _context.projectContext.scenes;
		
		if (Array.isArray(originalScenes)) originalScenes.every(function (scene) {

			if (this.sceneForViewControllerId[scene.viewController.$id]) return true;
			
			var sceneShouldGetNavigationController = true;
			if (sceneShouldGetNavigationController) {
				var ncScene = this._addNavigationControllerForVC(scene.viewController, storyboardScenes);
			}

			var vcScene =
				this._transformViewControllerInScene(scene, storyboardScenes);

				var customInitialVC = (this.context.projectMetadataController.get("initialViewController") || "");
				if(customInitialVC && scene.viewController.$id == customInitialVC) {
					result.document.initialViewController = ncScene.objects.navigationController.id;
				}

			if (sceneShouldGetNavigationController) {
				var connection = {
					destination: vcScene.objects.viewController.id,
					kind: 'relationship',
					relationship: 'rootViewController',
					id: this.createStoryboardID()
				};
				ncScene.objects.navigationController.connections['segue 0'] = connection;
				
				logConnection(connection, ncScene.objects.navigationController);
				
				
				
				ncScene.objects.navigationController.storyboardIdentifier = vcScene.objects.viewController.storyboardIdentifier;
				delete vcScene.objects.viewController.storyboardIdentifier;
			}
return true; }, this);
		
};
	
	
XIBGenerator.prototype.sceneShouldGetNavigationController = function XIBGenerator__sceneShouldGetNavigationController(scene) {
	
		if (!scene) return false;
	
		if (scene.hasSegues()) return true;
		
		var tbcData = this.data.tabBarController;
		if (!(tbcData &&
			tbcData.viewControllerIDs &&
			tbcData.viewControllerIDs.length>=1)) return true;
		
		return (this.sceneIsInTabBar(scene) && scene.e_showsNavigationBar) ||
				(_context.projectContext.tabBarController.numberOfItems<1 && scene === _context.projectContext.scenes[0]);
		};
	
	
XIBGenerator.prototype._transformViewControllerWithID = function XIBGenerator___transformViewControllerWithID(viewControllerId, scenes, isInTabBar) {
	
		var vcData = this._getInstanceDataById(viewControllerId),
			vcScene;
		var sceneData = this.context.projectContext.sceneContainingViewController(viewControllerId);

		if (this.sceneShouldGetNavigationController(sceneData) === true) {

			var ncScene = this._addNavigationControllerForVC(vcData, scenes);

			this._tabBarControllerDestinations[viewControllerId] =
				ncScene.objects.navigationController.id;

			vcScene =
				this._transformViewControllerInScene(sceneData, scenes);

			var connection = {
				destination: vcScene.objects.viewController.id,
				kind: 'relationship',
				relationship: 'rootViewController',
				id: this.createStoryboardID()
			};
			ncScene.objects.navigationController.connections['segue 0'] = connection;
			logConnection(connection, ncScene.objects.navigationController);

				
				
				ncScene.objects.navigationController.storyboardIdentifier = vcScene.objects.viewController.storyboardIdentifier;
				delete vcScene.objects.viewController.storyboardIdentifier;
			
			return ncScene.objects.navigationController.id;

		}
		else {
		
			vcScene =
				this._transformViewControllerInScene(sceneData, scenes);
				
			this._tabBarControllerDestinations[viewControllerId] =
				vcScene.objects.viewController.id;

			return vcScene.objects.viewController.id;
		}
	};
	
	

XIBGenerator.prototype._transformRootTabBarController = function XIBGenerator___transformRootTabBarController(tbcData, result) {

		var scenes = result.document.scenes,
			isInTabBar = true;
		
		tbcData.viewControllerIDs.every(function (viewControllerId) {
			this._transformViewControllerWithID(viewControllerId, scenes, isInTabBar);
			return true;
		}.bind(this));
		
		this._addTabBarControllerScene(tbcData, result);
};
	

XIBGenerator.prototype._getInstanceDataById = function XIBGenerator___getInstanceDataById(id) {
	
		var result;
		this.data.scenes.every(function (instanceData) {
			if (instanceData.$id === id)
				result = instanceData;
			if (instanceData.viewController && instanceData.viewController.$id === id)
				result = instanceData.viewController;
			else return true;
		});
		
		return result;
};
	

XIBGenerator.prototype._currentViewControllerOrCellHasOutletNamed = function XIBGenerator___currentViewControllerOrCellHasOutletNamed(outletName) {

		
		if ('hash superclass class self zone isProxy retain release autorelease retainCount description debugDescription load initialize init new alloc dealloc finalize copy mutableCopy superclass class allowsWeakReference retainWeakReference '.indexOf(outletName+' ') !== -1) return true;
		
		
		if ('nextResponder canBecomeFirstResponder becomeFirstResponder canResignFirstResponder resignFirstResponder isFirstResponder '.indexOf(outletName+' ') !== -1) return true;

		
		if ('undoManager '.indexOf(outletName+' ') !== -1) return true;
		
		
		if (outletName === 'appearance') return true;
		
		
		if ('loadView viewWillUnload viewDidUnload viewDidLoad isViewLoaded viewWillLayoutSubviews viewDidLayoutSubviews didReceiveMemoryWarning isBeingPresented isBeingDismissed isMovingToParentViewController isMovingFromParentViewController disablesAutomaticKeyboardDismissal preferredStatusBarStyle prefersStatusBarHidden preferredStatusBarUpdateAnimation setNeedsStatusBarAppearanceUpdate attemptRotationToDeviceOrientation shouldAutorotate supportedInterfaceOrientations preferredInterfaceOrientationForPresentation rotatingHeaderView rotatingFooterView editButtonItem searchDisplayController removeFromParentViewController endAppearanceTransition childViewControllerForStatusBarStyle childViewControllerForStatusBarHidden automaticallyForwardAppearanceAndRotationMethodsToChildViewControllers shouldAutomaticallyForwardRotationMethods shouldAutomaticallyForwardAppearanceMethods applicationFinishedRestoringState updateViewConstraints '.indexOf(outletName+' ') !== -1) return true;

		
		if ('view nibName nibBundle storyboard title parentViewController modalViewController presentedViewController presentingViewController definesPresentationContext providesPresentationContextTransitionStyle modalTransitionStyle modalPresentationStyle modalPresentationCapturesStatusBarAppearance wantsFullScreenLayout edgesForExtendedLayout extendedLayoutIncludesOpaqueBars automaticallyAdjustsScrollViewInsets preferredContentSize interfaceOrientation editing searchDisplayController childViewControllers restorationIdentifier restorationClass transitioningDelegate topLayoutGuide bottomLayoutGuide '.indexOf(outletName+' ') !== -1) return true;

		
		if ('accessoryView backgroundColor backgroundView editingAccessoryView imageView selectedBackgroundView '.indexOf(outletName+' ') !== -1) return true;


		var connections;
		if (this.currentCell && !this.currentCellIsStatic)
			connections = this.currentCell.connections;
		else
			connections = this.currentViewController.connections;
	
		if (connections === undefined)
			return false;

		for (key in connections) {
			if (key.substr(0,6) !== "outlet") continue;
			if (connections[key].property === outletName) return true;
		}
		
		
		return false;};
	

	
XIBGenerator.prototype.storyboardIDForObjectID = function XIBGenerator_storyboardIDForObjectID(originalObjectID) {
		if (originalObjectID === '$CurrentCell') return this.currentCell.id;
		if (!this.objectIDs[originalObjectID]) {
			this.objectIDs[originalObjectID] = this.createStoryboardID();
		}
		return this.objectIDs[originalObjectID];};
	

XIBGenerator.prototype.storyboardIDForComposeObject = function XIBGenerator_storyboardIDForComposeObject(obj) {
		if (!obj || !obj.$id) {
			console.warn('storyboardIDForComposeObject: Object has no id!');
			console.trace();
			 alertd('storyboardIDForComposeObject: Object has no id!', obj);
		}
		return this.storyboardIDForObjectID(obj.$id);};
	 


XIBGenerator.prototype.selectorNameForProcedureID = function XIBGenerator_selectorNameForProcedureID(originalObjectID) {
	
		if (!this.selectorNames[originalObjectID]) {
			this.selectorNames[originalObjectID] = lcfirst(originalObjectID)+':';
		}
		
		return this.selectorNames[originalObjectID];
		};
	
	
XIBGenerator.prototype.registerInlineObject = function XIBGenerator_registerInlineObject(obj) {

		if (this.isTransformingCell && this.currentCellData) {
			this.productGenerator.registerInlineObjectForCellViewCID(obj, this.currentCellData.id);
		}
		else {
			this.productGenerator.registerInlineObject(obj, this.currentOriginalScene);
		}
		
		if (this.allObjectsWorkerArray) this.allObjectsWorkerArray.push(obj);
		
		return obj.identify();};
	
	
	Object.defineProperty(XIBGenerator.prototype, "systemVersion", {
		get: function () { return this.context.projectContext.simulatedSystemVersion; }});
	
	
	
XIBGenerator.prototype.getInputDataSourceForCurrentScene = function XIBGenerator_getInputDataSourceForCurrentScene() {

		var result;
		if (Array.isArray(this.currentOriginalScene.objects)) this.currentOriginalScene.objects.every(function (obj) {
			if (utiFromData(obj) === 'appdoo.SceneInputDataSource') {
				result = obj;
				return false;
			}return true; }, this);
		
		return result;};
	
	
	
	
	
XIBGenerator.prototype.addConnectionFrom__to__type__info__ = function XIBGenerator_addConnectionFrom__to__type__info__(sourceCID, destinationCID, connectionType, connectionInfo, result) {
	
		if (!sourceCID || !destinationCID) return;
	
		var forceCodeConnection = ['outlet','outletCollection','action'].indexOf(connectionType) === -1;
	
		if (forceCodeConnection || !this.objectWithCIDIsInCurrentContext(destinationCID)) {

			
			this.productGenerator.addCodeConnectionInVC_from__to__type__info__(this.currentViewControllerId, sourceCID, destinationCID, connectionType, connectionInfo);
			return;
		}
		
		if (!result.connections) result.connections = {};
		var key, i = 1;
		do {
			key = i+'. '+connectionType;
			i++;
		} while (result.connections[key] !== undefined);
		
		logConnection(connectionInfo, result);

		result.connections[key] = connectionInfo;
		};
	

XIBGenerator.prototype.connectOutletNamed__in__to__result__ = function XIBGenerator_connectOutletNamed__in__to__result__(propertyName, sourceCID, destinationCID, result) {
		this.addConnectionFrom__to__type__info__(sourceCID, destinationCID, 'outlet', {
			property: propertyName,
    		destination: this.storyboardIDForObjectID(destinationCID),
    		id: this.createStoryboardID()
		}, result);};
	

XIBGenerator.prototype.objectWithCIDIsInCurrentContext = function XIBGenerator_objectWithCIDIsInCurrentContext(cid) {
		if (cid === true) return true;
	
		var result = false;
		
		if (!this.currentOriginalScene || !this.currentOriginalScene.viewController) return;
		
		if (this.currentOriginalScene.viewController.$id === cid) return true;
		
		if (this.isTransformingCell && cid === '$CurrentCell') return true;
		
		updateSubviewsWithCallback(this.currentOriginalScene.viewController.viewData, function (subview, isInDynamicContext) {
			if (subview.$id === cid) {
				if (!isInDynamicContext && !(subview.$type === 'UITableView' && !subview.usesDataSource)) result = true;
				return false;
			}
		}, true);
		
		if (!result) {
			if (Array.isArray(this.currentOriginalScene.objects)) this.currentOriginalScene.objects.every(function (obj) {
				if (obj.$id === cid) {
					result = true;
					return false;
				}return true; }, this);
			
		}

		if (!result) {
			if (this.currentOriginalScene.navigationBar) {
				if (this.currentOriginalScene.navigationBar.$id === cid) return true;
				if (Array.isArray(this.currentOriginalScene.navigationBar.items)) this.currentOriginalScene.navigationBar.items.every(function (obj) {
					if (obj.$id === cid) {
						result = true;
						return false;
					}return true; }, this);
				
			}
		}
	
		if (!result) {
			var inlineObjects = this.productGenerator.inlineObjectsForOriginalSceneID[this.currentOriginalScene.$id];
			if (Array.isArray(inlineObjects)) inlineObjects.every(function (obj) {
				if (obj.$id === cid) {
					result = true;
					return false;
				}return true; }, this);
			
		}

		return result;
};
	
	
XIBGenerator.prototype.tagForViewWithCID = function XIBGenerator_tagForViewWithCID(cid) {
		if (!this.viewTags[cid]) this.viewTags[cid] = this.nextViewTag++;
		return this.viewTags[cid];};
	

XIBGenerator.prototype.createProcedureFromData = function XIBGenerator_createProcedureFromData(PARAMETER_NOT_USED, actionInfo) {
		return this.productGenerator.createProcedureFromData(actionInfo ? actionInfo.actionType:null, actionInfo);};
	
	
XIBGenerator.prototype.transformAndAddActionToObject = function XIBGenerator_transformAndAddActionToObject(PARAMETER_NOT_USED, actionInfo, result, originalID, eventType) {
		if (!actionInfo) return;
		var actionType = actionInfo.actionType;

		if (!eventType) eventType = 'touchUpInside';
		var connectionType = (['touchUpInside'].indexOf(eventType) !== -1) ? 'action' : 'customAction';
		
		
		if (actionType) {
		
			if (actionType === 'performObjCSelector') {
			
				this.addConectionToObject__type__info__(
					result,
					connectionType, {
						selector: actionInfo.targetSelector,
						destination: this.storyboardIDForObjectID(actionInfo.targetObjectID),
						eventType: eventType,
					});
			
			}
			else if (this.generateSpecialAction(null, actionInfo, result, originalID, eventType)) {
			}
			else {
			
				var procedure = this.createProcedureFromData(null, actionInfo);

				if (!procedure) {
					console.warn('Could not create a procedure for the actionType', actionType, 'actionInfo:', actionInfo);
				}
				else {
					var actionID = this.registerInlineObject(procedure);
					
					var destinationID;
					if (this.isTransformingCell && this.currentCellData)
						destinationID = this.currentCell.id;
					else
						destinationID = this.currentViewControllerXID;
					
					this.addConnectionFrom__to__type__info__(originalID, this.currentViewControllerId, connectionType, {
							selector: this.selectorNameForProcedureID(actionID),
							destination: destinationID,
							eventType: eventType,
							id: this.createStoryboardID()
					}, result);
				}
			
			}
		
		}
		};
	
	
XIBGenerator.prototype.generateSpecialAction = function XIBGenerator__generateSpecialAction(PARAMETER_NOT_USED, actionInfo, result, originalID, eventType) {
	
		var actionType = actionInfo.actionType;
	
		if (actionType === 'objectAction' && (actionInfo.objectActionID === 'seekBackward' || actionInfo.objectActionID === 'seekForward')) {
	
			var actionInfo1 = clone(actionInfo);
			actionInfo1.objectActionID = (actionInfo.objectActionID === 'seekForward') ? 'beginSeekingForward' : 'beginSeekingBackward';
			var seekProcedure = this.createProcedureFromData(actionType, actionInfo1);
			var actionInfo2 = clone(actionInfo);
			actionInfo2.objectActionID = 'endSeeking';
			var stopSeekingProcedure = this.createProcedureFromData(actionType, actionInfo2);
			
			var actionID1 = this.registerInlineObject(seekProcedure);
			var actionID2 = this.registerInlineObject(stopSeekingProcedure);
			
			this.addConnectionFrom__to__type__info__(originalID, this.currentViewControllerData.$id, 'action', {
					selector: this.selectorNameForProcedureID(actionID1),
					destination: this.currentViewController.id,
					eventType: 'touchDown',
					id: this.createStoryboardID()
			}, result);
			this.addConnectionFrom__to__type__info__(originalID, this.currentViewControllerData.$id, 'action', {
					selector: this.selectorNameForProcedureID(actionID2),
					destination: this.currentViewController.id,
					eventType: 'touchUpInside',
					id: this.createStoryboardID()
			}, result);
			this.addConnectionFrom__to__type__info__(originalID, this.currentViewControllerData.$id, 'action', {
					selector: this.selectorNameForProcedureID(actionID2),
					destination: this.currentViewController.id,
					eventType: 'touchUpOutside',
					id: this.createStoryboardID()
			}, result);
		
			return true;
		}
		
		return false;};
	
	
XIBGenerator.prototype.object__addUserDefinedRuntimeAttribute__ = function XIBGenerator_object__addUserDefinedRuntimeAttribute__(result, attr) {
		if (!attr || (attr.type === 'string' && attr.value === undefined)) return;
		if (!result.userDefinedRuntimeAttributes) result.userDefinedRuntimeAttributes = {};
		result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute '+attr.keyPath] = attr;};
	


XIBGenerator.prototype.object__addOutlet__from__to__ = function XIBGenerator_object__addOutlet__from__to__(result, propertyName, sourceCID, destinationCID) {

		this.addConnectionFrom__to__type__info__(sourceCID, destinationCID, 'outlet', {
			property: propertyName,
    		destination: this.storyboardIDForObjectID(destinationCID),
    		id: this.createStoryboardID()
		}, result);
	};
	

	
XIBGenerator.prototype.firstObjectInCurrentSceneWithUTI = function XIBGenerator_firstObjectInCurrentSceneWithUTI(uti) {
		var allObjects = this.currentOriginalScene ? this.productGenerator.allObjectsForScene(this.currentOriginalScene) : this.productGenerator.allGlobalObjects();
		var result;
		if (Array.isArray(allObjects)) allObjects.every(function (obj) {
			if (utiFromData(obj) === uti) {
				result = obj;
				return false;
			}return true; }, this);
		
		return result;};
	
	
XIBGenerator.prototype.addDeallocMethod = function XIBGenerator_addDeallocMethod(cid, methodName) {
		this.productGenerator.addDeallocMethod(cid, methodName);};
	
	
XIBGenerator.prototype.createObject = function XIBGenerator_createObject(data) {
		var result = { customClass: data.$type };
		if (data.name) result.userLabel = data.name;
		return result;};
	
	
XIBGenerator.prototype.transformString = function XIBGenerator_transformString(value) {
		if (typeof value === 'string') return value;
		return value+'';};
	

XIBGenerator.prototype.setStringProperty = function XIBGenerator_setStringProperty(result, key, value, setAsProperty) {

		if (setAsProperty)
			result[key] = value;

		else
			this.object__addUserDefinedRuntimeAttribute__(result, {
				type: 'string',
				keyPath: key,
				value: value
			});
	};
	

XIBGenerator.prototype.setFloatProperty = function XIBGenerator_setFloatProperty(result, key, value, setAsProperty) {
	
		if (setAsProperty)
			result[key] = value;

		else
			this.object__addUserDefinedRuntimeAttribute__(result, {
				type: 'number',
				keyPath: key,
				real: { key: 'value', value: parseFloatLocal(value) }
			});
};
	

XIBGenerator.prototype.setIntegerProperty = function XIBGenerator_setIntegerProperty(result, key, value, setAsProperty) {
	
		if (setAsProperty)
			result[key] = value;

		else
			this.object__addUserDefinedRuntimeAttribute__(result, {
				type: 'number',
				keyPath: key,
				integer: { key: 'value', value: value }
			});
};
	

XIBGenerator.prototype.setBooleanProperty = function XIBGenerator_setBooleanProperty(result, key, value, setAsProperty) {

		if (setAsProperty)
			result[key] = this.transformBoolean(value);

		else
			this.object__addUserDefinedRuntimeAttribute__(result, {
				type: 'boolean',
				keyPath: key,
				value: this.transformBoolean(value)
			});
};
	

XIBGenerator.prototype.setReferenceProperty = function XIBGenerator_setReferenceProperty(result, key, sourceCID, destinationCID) {
		this.connectOutletNamed__in__to__result__(key, sourceCID, destinationCID, result);};
	

XIBGenerator.prototype.setFontProperty = function XIBGenerator_setFontProperty(result, fontOrFontName, fontSize, fontFamily, useCustomProperty) {
		var fontName = (typeof fontOrFontName === 'object') ? fontOrFontName.fontName : fontOrFontName;
		fontSize = (typeof fontOrFontName === 'object') ? fontOrFontName.pointSize : fontSize;
		
		result.fontDescription = this.transformFont(fontOrFontName, fontSize, fontFamily);
		
		if (!useCustomProperty) return;
		if (Array.isArray(this.context.projectContext.fileReferences)) this.context.projectContext.fileReferences.every(function (ref) {
			if (!ref.isFont) return true;
			if (ref.fontInfo && ref.fontInfo.name === fontName) {
				this.setStringProperty(result, 'fontNameAndSize', fontName+'\n'+fontSize);
				return false;
			}return true; }, this);
		
		};
	

XIBGenerator.prototype.setColorProperty = function XIBGenerator_setColorProperty(result, key, value, setAsProperty) {
		if (!value) return;

		if (setAsProperty)
			result['color '+key] = this.transformCSSColor(value, key);
		else {
		
			this.object__addUserDefinedRuntimeAttribute__(result, {
				type: 'color',
				keyPath: key,
				color: this.transformCSSColor(value, 'value')
			});

			
		}};
	

XIBGenerator.prototype.setType = function XIBGenerator_setType(result, typeName) {
		result.customClass = typeName;};
	
	
XIBGenerator.prototype.registerInverseBinding = function XIBGenerator_registerInverseBinding(result, data, key, destinationKeyPathPrefix, dataProviderID, dataProvider) {
		return _context.registerInverseBindingForTransformer(this, result, data, key, destinationKeyPathPrefix, dataProviderID, dataProvider);};
	
	
XIBGenerator.prototype.addDataProviderToObject = function XIBGenerator_addDataProviderToObject(result, data) {
		if (!data.dataProvider) return;
		var dataProvider = _context.projectContext.decodeObjectTree(data.dataProvider);
		this.registerInlineObject(dataProvider);
		this.connectOutletNamed__in__to__result__('dataProvider', data.$id, dataProvider.$id, result);
		return dataProvider;};
	
	
XIBGenerator.prototype.forEachSubview = function XIBGenerator_forEachSubview(result, callback) {

		for (var key in result.subviews) {
			var subview = result.subviews[key];
			callback(subview);
		}};
	

XIBGenerator.prototype.registerAppDelegateCode = function XIBGenerator_registerAppDelegateCode(signature, code) {
		this.productGenerator.registerAppDelegateCode(signature, code);};
	
	
XIBGenerator.prototype.registerObjectProxy = function XIBGenerator_registerObjectProxy(data) {

		this.demandPlugin('info.appdoo-mac.ObjectProxy');
		
		var obj = _context.projectContext.connectableObjects[data.originalObjectID];
		if (!obj) return;
		
		var cocoaType = this.cocoaTypeForData(obj, obj),
			cocoaCustomType = this.cocoaCustomTypeForData(obj, obj);
			
		this.demandPlugin(obj.pluginIdentifier || obj.UTI);

		this.productGenerator.addOtherProperty(data, cocoaCustomType||cocoaType||'id');
		};
	

	function logConnection(connection, source) {
		
	}

XIBGenerator.prototype.initPropertiesFromData = function XIBGenerator_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("productGenerator")) this.productGenerator = data.productGenerator;
};

XIBGenerator.prototype.decodeData = function XIBGenerator_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

XIBGenerator.prototype.encode = function XIBGenerator_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

XIBGenerator.prototype.encodeCloned = function XIBGenerator_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

XIBGenerator.prototype.expectedTypeForProperty = function XIBGenerator_expectedTypeForProperty(key) {
	if (key === "isXIBGenerator") return "";
	if (key === "template") return "";
	if (key === "productGenerator") return "";
	if (key === "currentOriginalScene") return "";
	if (key === "isTransformingRootView") return "Boolean";
	if (key === "currentViewController") return "";
	if (key === "currentViewControllerXID") return "";
	if (key === "currentViewControllerData") return "";
	if (key === "currentViewControllerId") return "";
	if (key === "currentViewControllerClassId") return "";
	if (key === "systemVersion") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return XIBGenerator; }()));
registerType('appdoo.iOSGenerator', (function () { function AppleStoryboardTransformer() {} var __super = setSupertypeFromDomain(AppleStoryboardTransformer, 'XIBGenerator', 'appdoo.iOSGenerator');

	

	Object.defineProperty(AppleStoryboardTransformer.prototype, "storyboardTemplate", {
		get: function () {
		
			var template = {"document": {
				"type": "com.apple.InterfaceBuilder3.CocoaTouch.Storyboard.XIB",
				"version": "3.0",
				"toolsVersion": "4488.2",
				"systemVersion": "13A558",
				"targetRuntime": "iOS.CocoaTouch",
				"propertyAccessControl": "none",
				"dependencies": {
					"development": {
						"version": "5000",
						"defaultVersion": "4200",
						"identifier": "xcode"
					},
					"plugIn": {
						"identifier": "com.apple.InterfaceBuilder.IBCocoaTouchPlugin",
						"version": "3715.3"
					}
				},
				"scenes": {},
				"resources": {},
				"simulatedMetricsContainer": {
					"simulatedStatusBarMetrics": {"key": "statusBar"},
					"simulatedOrientationMetrics": {"key": "orientation"},
					"simulatedScreenMetrics": {"key": "destination"}
				}
			}};
			
			if (this.systemVersion < 7)
				template.document.variant = "6xAndEarlier";

				
			return template;
		}});
	

AppleStoryboardTransformer.prototype.transformData = function AppleStoryboardTransformer_transformData(data) {
	
		this.prepare();
		this.data = data;
	
		var result = this.storyboardTemplate;
		
		if (this.productGenerator.targetDeviceIsIPad) {
			result.document.targetRuntime = 'iOS.CocoaTouch.iPad';
		}

		if (data.metadata.globalTintColor) {
			result.document.color = this.transformCSSColor(data.metadata.globalTintColor, 'tintColor')
		}

		
		this.currentResult = result;

		this._scenesContainer = result.document.scenes;

		var tbcData = data.tabBarController;
		
		if (tbcData &&
			tbcData.viewControllerIDs &&
			tbcData.viewControllerIDs.length>=1) {
			this._transformRootTabBarController(tbcData, result);
			this.transformRemainingScenes(data.scenes, result);
		}
		else {
			this._transformAllViewControllers(data.scenes, result);
		}
		
		var imageResources = [];
		var done = {};
		if (Array.isArray(this.productGenerator.images)) this.productGenerator.images.every(function (imageName) {
			var name = imageName.replace('@2x','');
			if (done[name]) return true;
			done[name] = true;
			imageResources.push({
				name: name,
				contentType: 'image/'+(getPathExtension(imageName) || 'png'),
				
				size: { width: 40, height: 40 }
			});return true; }, this);
		
		
		this._addImageReferences(imageResources, result.document.resources);

		this.currentViewController = null;

		var jsonString = JSON.stringify(result, true, '	');
		return jsonString;
};
	


AppleStoryboardTransformer.prototype.expectedTypeForProperty = function AppleStoryboardTransformer_expectedTypeForProperty(key) {
	if (key === "storyboardTemplate") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return AppleStoryboardTransformer; }()));