
function escapeQuotes(str) {
	return str.replace(/\"/g, "\\\"");}
registerType('appdoo.iOSGenerator', (function () { function PbxFileGenerator() {} var __super = setSupertypeFromDomain(PbxFileGenerator, 'BasicObject', 'Core');

PbxFileGenerator.prototype.generateFromData = function PbxFileGenerator_generateFromData(data, originalData, productGenerator) {
		
		var result = data.template;
		
		this.payload = productGenerator.payload;
				
		result = result.replace(/__PROJECT_NAME__/g,				data.projectName);
		result = result.replace(/__PBXBuildFile_ITEMS__/,			this._generatePbxBuildFileItems(data));
		result = result.replace(/__PBXFileReference_ITEMS__/,		this._generatePbxFileReferenceItems(data));

		result = result.replace(/__PBXGroup_PROJECT_ITEMS__/,		this._generatePbxProjectGroupItems(data));
		result = result.replace(/__PBXGroup_SUPPORTING_FILES__/,	this._generatePbxSupportingFilesGroupItems(data));
		result = result.replace(/__PBXGroup_FRAMEWORK_ITEMS__/,		this._generatePbxFrameworksGroupItems(data));
		result = result.replace(/__PBXGroup_OTHER_GROUPS/,			this._generatePbxOtherGroups(data));
		result = result.replace(/__PBXGroup_LIST_OF_OTHERS_IN_ROOT/,this._generatePbxOtherGroupsInRootList(data));

		result = result.replace(/__PBXSourcesBuildPhase_ITEMS_/,	this._generatePbxSourcesBuildPhaseItems(data));
		result = result.replace(/__PBXResourcesBuildPhase_ITEMS_/,	this._generatePbxResourcesBuildPhaseItems(data));
		result = result.replace(/__PBXVariantGroup_ITEMS__/,		this._generatePbxVariantGroupItems(data));
		result = result.replace(/__PBXFrameworksBuildPhase_ITEMS__/,this._generatePbxFrameworksBuildPhaseItems(data));
		
		if(this.context.isDebugging) {
			result = result.replace(/GCC_WARN_ABOUT_DEPRECATED_FUNCTIONS = NO/g, 'GCC_WARN_ABOUT_DEPRECATED_FUNCTIONS = YES');
		}
		
		result = result.replace(/__LIBRARY_SEARCH_PATHS__/g,		this._generateLibrarySearchPaths(data));
		result = result.replace(/__TARGETED_DEVICE_FAMILY__\n/g,	this._generateTargetedDeviceFamilyData(productGenerator));
		result = result.replace(/__IPHONEOS_DEPLOYMENT_TARGET__/g,	'9.0'); 

		result = result.replace(/__CODE_SIGN_IDENTITY_DEBUG__/, escapeQuotes(originalData.metadata.appleCodeSigningIdentityDebug || 'iPhone Developer'));
		result = result.replace(/__CODE_SIGN_IDENTITY_RELEASE__/, escapeQuotes(originalData.metadata.appleCodeSigningIdentityRelease || 'iPhone Developer'));

		return result;};
	


	
	
	var PBXTYPE_FILE_REFERENCE = 0,
		PBXTYPE_BUILD_FILE = 1,
		PBXTYPE_HEADER_FILE = 2,
		PBXTYPE_IMPLEMENTATION_FILE = 3,
		PBXTYPE_VARIANT_GROUP_CHILD = 4,
		PBXTYPE_GROUP = 5;

	function filenameForPath(path) {
		if (typeof path !== 'string') return '';
		var s = path.split('/');
		return s[s.length-1];
	}
	
	function suffixFromFile(filename) {
		var s = filename.split('.');
		return s[s.length-1];
	}
	
	function parentPath(path) {
		var s = path.split('/');
		s.pop();
		return s.join('/');
	}

PbxFileGenerator.prototype._generatePbxBuildFileItems = function PbxFileGenerator___generatePbxBuildFileItems(data) {

		var result = "/* _generatePbxBuildFileItems */\n";

		data.implementationFiles.every(function (path) {
			var filename = filenameForPath(path);
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, path),
				generatedID = this._getPbxID(PBXTYPE_BUILD_FILE, path);
			result += "		"+generatedID+" /* "+filename+" in Sources */ = {isa = PBXBuildFile; fileRef = "+fileRefID+" /* "+filename+" */; };\n";
			this.payload.buildFileItems[generatedID] = { isa: 'PBXBuildFile', fileRef: fileRefID };
			return true;
		}.bind(this));

		data.resources.every(function (item) {
			var path = item.path || item.name,
				filename = filenameForPath(path),
				fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, path),
				generatedID = this._getPbxID(PBXTYPE_BUILD_FILE, path);
			if (!filename) return true;
			result += "		"+generatedID+" /* "+filename+" in Resources */ = {isa = PBXBuildFile; fileRef = "+fileRefID+" /* "+filename+" */; };\n";
			this.payload.buildFileItems[generatedID] = { isa: 'PBXBuildFile', fileRef: fileRefID, };
			return true;
		}.bind(this));
		
		for (var frameworkName in data.systemFrameworks) {
			var frameworkNameWithSuffix = frameworkName+'.framework';
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, frameworkNameWithSuffix);
			var generatedID = this._getPbxID(PBXTYPE_BUILD_FILE, frameworkNameWithSuffix);
			result += "		"+generatedID+" /* "+frameworkNameWithSuffix+" in Frameworks */ = {isa = PBXBuildFile; fileRef = "+fileRefID+" /* "+frameworkNameWithSuffix+" */; };\n";
			this.payload.buildFileItems[generatedID] = { isa: 'PBXBuildFile', fileRef: fileRefID };
		}

		for (var libraryName in data.systemLibraries) {
			var libraryNameWithSuffix = libraryName+'.dylib';
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, libraryNameWithSuffix);
			var generatedID = this._getPbxID(PBXTYPE_BUILD_FILE, libraryNameWithSuffix);
			result += "		"+generatedID+" /* "+libraryNameWithSuffix+" in Frameworks */ = {isa = PBXBuildFile; fileRef = "+fileRefID+" /* "+libraryNameWithSuffix+" */; };\n";
			this.payload.buildFileItems[generatedID] = { isa: 'PBXBuildFile', fileRef: fileRefID };
		}

		for (var filename in data.localizedStringFiles) {
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, filename);
			var generatedID = this._getPbxID(PBXTYPE_BUILD_FILE, filename);
			result += "		"+generatedID+" /* "+filename+" in Resources */ = {isa = PBXBuildFile; fileRef = "+fileRefID+" /* "+filename+" */; };\n";
			this.payload.buildFileItems[generatedID] = { isa: 'PBXBuildFile', fileRef: fileRefID };
		}

		return result;
};
	

	function sourceTreeFromPath(path) {
		if (path && path[0] === '/' && path[1] === 'U' && path.substr(0,'/Users/'.length) === '/Users/') return '<absolute>';
		return '<group>';
	}

PbxFileGenerator.prototype._generatePbxFileReferenceItems = function PbxFileGenerator___generatePbxFileReferenceItems(data) {
	
		var result = "/* _generatePbxFileReferenceItems */\n";
		

		data.headerFiles.every(function (path) {
			var filename = filenameForPath(path);
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, path);
			result += "		"+fileRefID+" /* " + filename
				   + " */ = {isa = PBXFileReference; lastKnownFileType = sourcecode.c.h; path = \""
				   + path + "\";";

			var ref = { isa: 'PBXFileReference', path: path, lastKnownFileType: 'sourcecode.c.h', sourceTree: sourceTreeFromPath(path) };
			if (path != filename) {
				result += " name = \""+filename+"\";";
				ref.name = filename;
			}
			result += " sourceTree = \""+sourceTreeFromPath(path)+"\"; };\n";

			this.payload.fileReferenceItems[fileRefID] = ref;
			return true;
		}.bind(this));

		data.implementationFiles.every(function (path) {
			var filename = filenameForPath(path);
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, path);
			result += "		"+fileRefID+" /* " + filename
				   + " */ = {isa = PBXFileReference; lastKnownFileType = sourcecode.c.m; path = \""
				   + path + "\";";
			var ref = { isa: 'PBXFileReference', path: path, lastKnownFileType: 'sourcecode.c.m', sourceTree: sourceTreeFromPath(path) };
			if (path != filename) {
				result += " name = \""+filename+"\";";
				ref.name = filename;
			}
			result += " sourceTree = \"<group>\"; };\n";
			this.payload.fileReferenceItems[fileRefID] = ref;
			return true;
		}.bind(this));

		data.resources.every(function (item) {
			var path = item.path || item.name,
				filename = filenameForPath(path),
				fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, path),
				fileType = this.ibxFileTypeForContentType(item.contentType);
			if (!filename) return true;

			result += "		"+fileRefID+" /* " + filename
				   + " */ = {isa = PBXFileReference; lastKnownFileType = "+fileType+"; path = \""
				   + path + "\"; name = \""+filename+"\"; sourceTree = \"<group>\"; };\n";

			this.payload.fileReferenceItems[fileRefID] = { isa: 'PBXFileReference', lastKnownFileType: fileType, path: path, sourceTree: '<group>' };
			return true;
		}.bind(this));

		for (var frameworkName in data.systemFrameworks) {
			var frameworkNameWithSuffix = frameworkName+'.framework';
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, frameworkNameWithSuffix);
			var path = 'System/Library/Frameworks/'+frameworkNameWithSuffix;

			result += "		"+fileRefID+" /* " + frameworkNameWithSuffix
				   + " */ = {isa = PBXFileReference; lastKnownFileType = wrapper.framework; name = "+frameworkNameWithSuffix+"; path = \""
				   + path + "\"; sourceTree = SDKROOT; };\n";

			this.payload.fileReferenceItems[fileRefID] = { isa: 'PBXFileReference', lastKnownFileType: 'wrapper.framework', name: frameworkNameWithSuffix, path: path, sourceTree: 'SDKROOT' };
		}
		
		for (var libraryName in data.systemLibraries) {
			var libraryNameWithSuffix = libraryName+'.dylib';
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, libraryNameWithSuffix);
			var path = 'usr/lib/'+libraryNameWithSuffix;

			result += "		"+fileRefID+" /* " + libraryNameWithSuffix
				   + " */ = {isa = PBXFileReference; lastKnownFileType = compiled.mach-o.dylib; name = "+libraryNameWithSuffix+"; path = \""
				   + path + "\"; sourceTree = SDKROOT; };\n";

			this.payload.fileReferenceItems[fileRefID] = { isa: 'PBXFileReference', lastKnownFileType: 'compiled.mach-o.dylib', name: libraryNameWithSuffix, path: path, sourceTree: 'SDKROOT' };
		}

		for (var filename in data.localizedStringFiles) {
			var languageCodes = data.localizedStringFiles[filename].languageCodes;
			if (Array.isArray(languageCodes)) languageCodes.every(function (code) {

				var variantID = this._getPbxID(PBXTYPE_VARIANT_GROUP_CHILD, code+'/'+filename);
				var path = code+'.lproj/'+filename;
	
				result += "		"+variantID+" /* " + code
					   + " */ = {isa = PBXFileReference; lastKnownFileType = text.plist.strings; name = "+code+"; path = \""
					   + path + "\"; sourceTree = \"<group>\"; };\n";
			
				this.payload.fileReferenceItems[variantID] = { isa: 'PBXFileReference', lastKnownFileType: 'text.plist.strings', name: code, path: path, sourceTree: '<group>' };return true; }, this);
			
			
		}

		return result;
	};
	
	
PbxFileGenerator.prototype.ibxFileTypeForContentType = function PbxFileGenerator__ibxFileTypeForContentType(contentType) {

		if (contentType === 'image/png')
			return 'image.png';

		if (contentType === 'image/jpeg')
			return 'image.jpeg';

		if (contentType === 'image/gif')
			return 'image.gif';

		if (contentType === 'image/tiff')
			return 'image.gif';

		if (contentType === 'application/apple-storyboard')
			return 'file.storyboard';

		if (contentType === 'application/apple-bundle')
			return 'wrapper.plug-in';

		return 'file';
};
	

	function getSuffix(str) {
		if (typeof str !== 'string') return '';
		var lastDot = str.lastIndexOf('.');
		if (lastDot === -1) return '';
		return str.substr(lastDot+1);
	}
	
	

PbxFileGenerator.prototype._helper_generatePbxItems = function PbxFileGenerator___helper_generatePbxItems(files, firstRow, payloadID) {

		var processFunc = function (path) {
			var filename = filenameForPath(path);
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, path);
			result += "				"+fileRefID+" /* "+filename+" */,\n";
			this.payload[payloadID].push(fileRefID);
			return true;
		}

		var result = firstRow;
		files.every(processFunc.bind(this));
		return result;
	};
	
		
PbxFileGenerator.prototype._generatePbxProjectGroupItems = function PbxFileGenerator___generatePbxProjectGroupItems(data) {
		return this._helper_generatePbxItems(data.projectFiles, "/* _generatePbxProjectGroupItems */\n", 'projectGroupItems');};
	

PbxFileGenerator.prototype._generatePbxSupportingFilesGroupItems = function PbxFileGenerator___generatePbxSupportingFilesGroupItems(data) {
		return this._helper_generatePbxItems(data.supportingFiles, "/* _generatePbxSupportingFiles */\n", 'supportingFilesGroupItems');};
	

PbxFileGenerator.prototype._generatePbxOtherGroupsInRootList = function PbxFileGenerator___generatePbxOtherGroupsInRootList(data) {
		var groupID = this._getPbxID(PBXTYPE_GROUP, 'Plug-ins');
		var result = "				"+groupID+" /* Plug-ins */,\n";
		this.payload.otherGroupsInRootList.push(groupID);
		return result;};
	

PbxFileGenerator.prototype._generatePbxOtherGroups = function PbxFileGenerator___generatePbxOtherGroups(data) {
	
		var result = "";
		var plugInGroups = [];
		
		for (var plugInIdentifier in data.pluginFiles) {
			var groupID = this._getPbxID(PBXTYPE_GROUP, plugInIdentifier);
			result += ["		"+groupID+" /* "+plugInIdentifier+" */ = {",
			 "			isa = PBXGroup;",
			 "			children = (",
			 data.pluginFiles[plugInIdentifier].map(function (name) {
			 	var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, name);
				return "				"+fileRefID+" /* "+name+" */,";
			 }.bind(this)).join("\n"),
			 "			);",
			 "			name = \""+plugInIdentifier+"\";",
			 "			sourceTree = \"<group>\";",
			 "		};"].join("\n");
			 plugInGroups.push({ id: groupID, name: plugInIdentifier });
			this.payload.pluginGroups[groupID] = { isa: 'PBXGroup', children: data.pluginFiles[plugInIdentifier].map(function (name) { return this._getPbxID(PBXTYPE_FILE_REFERENCE, name); }.bind(this)), name: plugInIdentifier, sourceTree: '<group>' };

 		}
		
		var groupID = this._getPbxID(PBXTYPE_GROUP, 'Plug-ins');
		result += ["		"+groupID+" /* Plug-ins */ = {",
 "			isa = PBXGroup;",
 "			children = (",
 plugInGroups.map(function (info) {
 	return "				"+info.id+" /* "+info.name+" */,";
 }).join("\n"),

 "			);",
 "			name = Plug-ins;",
 "			path = \""+data.projectName+"\";",
 "			sourceTree = \"<group>\";",
 "		};"].join("\n");
		this.payload.otherGroups[groupID] = { isa: 'PBXGroup', children: plugInGroups.map(function (info) { return info.id; }), name: 'Plug-ins', path: data.projectName, sourceTree: '<group>' };

		return result;
};
	

PbxFileGenerator.prototype._generatePbxFrameworksGroupItems = function PbxFileGenerator___generatePbxFrameworksGroupItems(data) {

		var result = "/* _generatePbxFrameworksGroupItems */\n";

		for (var frameworkName in data.systemFrameworks) {
			var frameworkNameWithSuffix = frameworkName+'.framework';
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, frameworkNameWithSuffix);
			result += "				"+fileRefID+" /* "+frameworkNameWithSuffix+" */,\n";
			this.payload.frameworksGroupItems.push(fileRefID);
		}
		
		for (var libraryName in data.systemLibraries) {
			var libraryNameWithSuffix = libraryName+'.dylib';
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, libraryNameWithSuffix);
			result += "				"+fileRefID+" /* "+libraryNameWithSuffix+" */,\n";
			this.payload.frameworksGroupItems.push(fileRefID);
		}

		return result;
	};
	

PbxFileGenerator.prototype._generatePbxSourcesBuildPhaseItems = function PbxFileGenerator___generatePbxSourcesBuildPhaseItems(data) {

		var result = "/* _generatePbxSourcesBuildPhaseItems */\n";

		data.implementationFiles.every(function (path) {
			var filename = filenameForPath(path);

			var suffix = suffixFromFile(filename);
			
			
			if (suffix === 'a') return true;

			var fileRefID = this._getPbxID(PBXTYPE_BUILD_FILE, path);
			result += "				"+fileRefID+" /* "+filename+" in Sources */,\n";
			
			this.payload.sourcesBuildPhaseItems.push(fileRefID);
			
			return true;
		}.bind(this));

		return result;
};
	

PbxFileGenerator.prototype._generatePbxResourcesBuildPhaseItems = function PbxFileGenerator___generatePbxResourcesBuildPhaseItems(data) {

		var result = "/* _generatePbxResourcesBuildPhaseItems */\n";

		data.resources.every(function (item) {
			var path = item.path || item.name,
				filename = filenameForPath(path),
				fileRefID = this._getPbxID(PBXTYPE_BUILD_FILE, path);
			if (!filename) return true;
			result += "				"+fileRefID+" /* "+filename+" in Resources */,\n";
			this.payload.resourcesBuildPhaseItems.push(fileRefID);
			return true;
		}.bind(this));

		for (var filename in data.localizedStringFiles) {
			var fileRefID = this._getPbxID(PBXTYPE_BUILD_FILE, filename);
			result += "				"+fileRefID+" /* "+filename+" in Resources */,\n";
			this.payload.resourcesBuildPhaseItems.push(fileRefID);
		}

		return result;
	};
	
	
PbxFileGenerator.prototype._generatePbxFrameworksBuildPhaseItems = function PbxFileGenerator___generatePbxFrameworksBuildPhaseItems(data) {

		var result = "/* _generatePbxPBXFrameworksBuildPhaseItems */\n";

		data.implementationFiles.every(function (path) {
			var filename = filenameForPath(path);
			var suffix = suffixFromFile(filename);
			
			if (suffix === 'a') {
				var fileRefID = this._getPbxID(PBXTYPE_BUILD_FILE, path);
				result += "				"+fileRefID+" /* "+filename+" */,\n";
				this.payload.frameworksBuildPhaseItems.push(fileRefID);
			}
			
			return true;
		}.bind(this));

		for (var frameworkName in data.systemFrameworks) {
			var frameworkNameWithSuffix = frameworkName+'.framework';
			var fileRefID = this._getPbxID(PBXTYPE_BUILD_FILE, frameworkNameWithSuffix);
			result += "				"+fileRefID+" /* "+frameworkNameWithSuffix+" */,\n";
			this.payload.frameworksBuildPhaseItems.push(fileRefID);
		}

		for (var libraryName in data.systemLibraries) {
			var libraryNameWithSuffix = libraryName+'.dylib';
			var fileRefID = this._getPbxID(PBXTYPE_BUILD_FILE, libraryNameWithSuffix);
			result += "				"+fileRefID+" /* "+libraryNameWithSuffix+" */,\n";
			this.payload.frameworksBuildPhaseItems.push(fileRefID);
		}
		
		return result;
	};
	
	
PbxFileGenerator.prototype._generatePbxVariantGroupItems = function PbxFileGenerator___generatePbxVariantGroupItems(data) {

		var result = "/* _generatePbxVariantGroupItems */\n";

		for (var filename in data.localizedStringFiles) {
			var fileRefID = this._getPbxID(PBXTYPE_FILE_REFERENCE, filename);
			result +=
				["		"+fileRefID+" /* "+filename+" */ = {",
				 "			isa = PBXVariantGroup;",
				 "			children = (\n"].join("\n");
				 
			var languageCodes = data.localizedStringFiles[filename].languageCodes;
			if (Array.isArray(languageCodes)) languageCodes.every(function (code) {
				var variantID = this._getPbxID(PBXTYPE_VARIANT_GROUP_CHILD, code+'/'+filename);
				result += "				"+variantID+" /* "+code+" */,\n";return true; }, this);
			
			
			result += 
				["			);",
				 "			name = "+filename+";",
				 "			path = \""+(data.localizedStringFiles[filename].directoryPath||'')+"\";",
				 "			sourceTree = \"<group>\";",
				 "		};\n"].join("\n");

			this.payload.variantGroupItems[fileRefID] = {
				isa: 'PBXVariantGroup',
				children: languageCodes.map(function (code) { return this._getPbxID(PBXTYPE_VARIANT_GROUP_CHILD, code+'/'+filename); }.bind(this)),
				name: filename,
				path: (data.localizedStringFiles[filename].directoryPath||''),
				sourceTree: '<group>'
			};
		}
		
		return result;
	};
	


PbxFileGenerator.prototype._generateLibrarySearchPaths = function PbxFileGenerator___generateLibrarySearchPaths(data) {

		var result = "/* _generateLibrarySearchPaths */\n";

		data.implementationFiles.every(function (path) {
			var filename = filenameForPath(path);
			var suffix = suffixFromFile(filename);
			
			if (suffix === 'a') {
				var dirname = parentPath(path);
				var path = '$(SRCROOT)/'+data.projectName+'/'+dirname;
				result += '"\\"'+path+'\\"",';
				this.payload.librarySearchPaths.push('"'+path+'"');
			}
			
			return true;
		}.bind(this));
		
		return result;
	};
	
	

	var pbxIDLookupTable;

PbxFileGenerator.prototype._getPbxID = function PbxFileGenerator___getPbxID(fileType, filename) {

		if (pbxIDLookupTable === undefined) {
			pbxIDLookupTable = {
				0: {},
				1: {},
				2: {},
				3: {},
				4: {},
				5: {}
			};
		}
		var pbxID = pbxIDLookupTable[fileType][filename];
		if (!pbxID) {
			pbxID = this._generatePbxID();
			pbxIDLookupTable[fileType][filename] = pbxID;
		}
		
		return pbxID;};
	
	
	var pbxIDCounter = 0x80;

PbxFileGenerator.prototype._generatePbxID = function PbxFileGenerator___generatePbxID() {
		var generatedID = 'ABE615'+pbxIDCounter.toString(16).toUpperCase()+'15E534DA0062F537';
		pbxIDCounter++;
		return generatedID;};
	
	
PbxFileGenerator.prototype._generateTargetedDeviceFamilyData = function PbxFileGenerator___generateTargetedDeviceFamilyData(productGenerator) {
		var key;
		if (productGenerator.targetIsIOSUniversal)		key = '"1,2"';
		else if (productGenerator.targetDeviceIsIPad)	key = '2';
		else											key = '1';
		return '				TARGETED_DEVICE_FAMILY = '+key+';\n';};
	

PbxFileGenerator.prototype.expectedTypeForProperty = function PbxFileGenerator_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return PbxFileGenerator; }()));