
registerType('appdoo.iOS', (function () { function Scene() {} var __super = setSupertypeFromDomain(Scene, 'BasicObject', 'Core');

Scene.prototype.init = function Scene_init() {
		__super.prototype.init.call(this);
		if (!this.objects) this.objects = [];
		else {
			
			if (Array.isArray(clone(this.objects))) clone(this.objects).every(function (object) {
				if (!object)
					this.objects.splice(this.objects.indexOf(object), 1);return true; }, this);
			
		}
		return this;};
	
		

	
	
	Object.defineProperty(Scene.prototype, "objects", {
	outlet: true, 
	enumerable: true, get:function () { return this._objects; }, set:function (v) {if (!Object.hasOwnProperty(this, "_objects")) Object.defineProperty(this, "_objects", { writable: true, configurable: true }); this._objects = v; }});
	


	
	
	Object.defineProperty(Scene.prototype, "viewController", {
	outlet: true, 
	enumerable: true, get:function () { return this._viewController; }, set:function (v) {if (!Object.hasOwnProperty(this, "_viewController")) Object.defineProperty(this, "_viewController", { writable: true, configurable: true }); this._viewController = v; }});
	

	Object.defineProperty(Scene.prototype, "widthIsEditable", {
		value: false});
	

	Object.defineProperty(Scene.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(Scene.prototype, "xIsEditable", {
		value: false});
	

	Object.defineProperty(Scene.prototype, "yIsEditable", {
		value: false});
	

	Object.defineProperty(Scene.prototype, "positionIsEditable", {
		value: false});
	

	Object.defineProperty(Scene.prototype, "sizeIsEditable", {
		value: false});
	

	Object.defineProperty(Scene.prototype, "e_title", {
		set: function (v) {
			var titleBefore = this.viewController.title;
			this.viewController.title = v;
			if (this.navigationBar && this.navigationBar.title === titleBefore)
				this.navigationBar.e_title = v;
			if (this.viewController.tabBarItem && this.viewController.tabBarItem.title === titleBefore)
				this.viewController.tabBarItem.e_title = v;
		}, 
		get: function ( ) { return this.viewController.title; }});
	

	
	Object.defineProperty(Scene.prototype, "simulatedInterfaceOrientation", {
	outlet: true, 
	enumerable: true, get:function () { return this._simulatedInterfaceOrientation; }, set:function (v) {if (!Object.hasOwnProperty(this, "_simulatedInterfaceOrientation")) Object.defineProperty(this, "_simulatedInterfaceOrientation", { writable: true, configurable: true }); this._simulatedInterfaceOrientation = v; }});
	

	Object.defineProperty(Scene.prototype, "e_simulatedInterfaceOrientation", {
		set: function (v) {
			this.simulatedInterfaceOrientation = v;
			_context.editor.contentFrameController.interfaceOrientationDidChangeForScene(this);
			_context.sceneDidChangeSize(this);
		}, 
		get: function ( ) { return this.simulatedInterfaceOrientation; }});
	
	
	Object.defineProperty(Scene.prototype, "simulatedWindowSize", {
		get: function ( ) {
			var size = this.context.windowSizeInPoints;
			if (this.simulatedInterfaceOrientation === 'landscape') {
				return { width: Math.max(size.width,size.height), height: Math.min(size.width,size.height) };
			}
			else {
				return { width: Math.min(size.width,size.height), height: Math.max(size.width,size.height) };
			}
		}});
	
	
	Object.defineProperty(Scene.prototype, "previewSize", {
	enumerable: true, 
		get: function () { return this.simulatedWindowSize; }});
	


	

	Object.defineProperty(Scene.prototype, "navigationBar", {
	outlet: true, 
	enumerable: true, get:function () { return this._navigationBar; }, set:function (v) {if (!Object.hasOwnProperty(this, "_navigationBar")) Object.defineProperty(this, "_navigationBar", { writable: true, configurable: true }); this._navigationBar = v; }});
	
	
	Object.defineProperty(Scene.prototype, "e_showsNavigationBar", {
		set: function (v) {

			if (v) {
				this.e_separateStatusBar = false;
				if (!this.navigationBar) this.navigationBar = this.createDefaultNavigationBar();
				
				if (!_context.editorIsVisible()) return;
				if (_context.editor.editedScene !== this) return;
				
				_context.editor.registerItem(this.navigationBar);
				_context.editor.contentFrameController.showNavigationBar();
			}
			else {
				this.navigationBar.hidden = true;
				if (!_context.editorIsVisible()) return;
				if (_context.editor.editedScene !== this) return;
				_context.editor.contentFrameController.hideNavigationBar();
				_context.editor.contentFrameController.updateStatusBar();
			}
			
			this.checkSpecialNodes();
			_context.editor.refreshInspector();
		}, 
		get: function () {
			if (!this.navigationBar) return false;
			if (this.navigationBar.hidden) return false;
			return true;
		}});
	
	
Scene.prototype.createDefaultNavigationBar = function Scene_createDefaultNavigationBar() {
		try {
			var ni = createComponentFromDomain('UINavigationItem',"appdoo.iOS",this.context,{});
			ni.identify();
			
			var nb = createComponentFromDomain('UINavigationBar',
			'appdoo.iOS', this.context, {
				size: { width: 320 },
				items: [ni],
				barStyle: UIBarStyleDefault,
				title: this.viewController.title,
				translucent: false
			});
			
			this.navigationBar = nb;
		} catch (err) {
			console.warn(err);
		}

		return nb;};
	
	
	
	
	
Scene.prototype.createDefaultTabBarItem = function Scene_createDefaultTabBarItem() {
		var tbi = this.context.decodeObjectTree({
			$type: 'UITabBarItem',
			$domain: 'appdoo.iOS',
			title: this.viewController.title,
		});
		return tbi;};
	
	
	Object.defineProperty(Scene.prototype, "tabBarController", {
		get: function () { return this.context.tabBarController; }});
	
	
	Object.defineProperty(Scene.prototype, "e_showsTabBar", {
		get: function ( ) { return this.showsTabBar; }, 
		set: function (v) {
			if (!v) {
				this.dataController.setValueForKey(false, 'e_showsInTabBar');
				_context.editor.contentFrameController.hideTabBar();
			}
			else {
				_context.editor.contentFrameController.showTabBar();
				_context.editor.contentFrameController.updateTabBar();
			}
			this.showsTabBar = v;
			this.checkSpecialNodes();
			_context.editor.refreshInspector();
		}});
	

	Object.defineProperty(Scene.prototype, "showsTabBar", {
	outlet: true, 
	enumerable: true, get:function () { return this._showsTabBar; }, set:function (v) {if (!Object.hasOwnProperty(this, "_showsTabBar")) Object.defineProperty(this, "_showsTabBar", { writable: true, configurable: true }); this._showsTabBar = v; }});
	
	
	
	
	Object.defineProperty(Scene.prototype, "v_statusBarIsBright", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_v_statusBarIsBright")) Object.defineProperty(this, "_v_statusBarIsBright", { writable: true, configurable: true });
			this._v_statusBarIsBright = v;
			this.performWithEditor(function () {
				_context.editor.contentFrameController.updateElement('statusBar');
			}.bind(this));
		}, get:function () { return this._v_statusBarIsBright; }});
	
	
	Object.defineProperty(Scene.prototype, "statusBarIsVisible", {
	outlet: true, 
	enumerable: true, get:function () { return this._statusBarIsVisible; }, set:function (v) {if (!Object.hasOwnProperty(this, "_statusBarIsVisible")) Object.defineProperty(this, "_statusBarIsVisible", { writable: true, configurable: true }); this._statusBarIsVisible = v; }});
	
	
	Object.defineProperty(Scene.prototype, "e_statusBarIsVisible", {
		set: function (v) { this.statusBarIsVisible = v; _context.editor.contentFrameController.statusBar.hidden = !v; }, 
		get: function ( ) { return this.statusBarIsVisible !== false; }});
	

	Object.defineProperty(Scene.prototype, "statusBarBackgroundView", {
	outlet: true, 
	enumerable: true, get:function () { return this._statusBarBackgroundView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_statusBarBackgroundView")) Object.defineProperty(this, "_statusBarBackgroundView", { writable: true, configurable: true }); this._statusBarBackgroundView = v; }});
	
	
	Object.defineProperty(Scene.prototype, "shouldHaveBrightStatusBar", {
		get: function () {
			if (this.e_showsNavigationBar) return this.navigationBar.barStyle === UIBarStyleBlack;
			return this.v_statusBarIsBright;
		}});
	


	Object.defineProperty(Scene.prototype, "v_separateStatusBar", {
	outlet: true, 
	enumerable: true, get:function () { return this._v_separateStatusBar; }, set:function (v) {if (!Object.hasOwnProperty(this, "_v_separateStatusBar")) Object.defineProperty(this, "_v_separateStatusBar", { writable: true, configurable: true }); this._v_separateStatusBar = v; }});
	


	Object.defineProperty(Scene.prototype, "e_separateStatusBar", {
		get: function ( ) { return this.v_separateStatusBar && this.statusBarBackgroundView!==undefined; }, 
		set: function (v) {
			this.v_separateStatusBar = v;

			if (v) {
				if (!this.statusBarBackgroundView) {
					this.createDefaultStatusBarBackgroundView();
					this.checkSpecialNodes();
					_context.editor.registerItem(this.statusBarBackgroundView);
				}
			}
			else {
				if (this.statusBarBackgroundView) {
					_context.editor.deleteItem(this.statusBarBackgroundView);
					this.statusBarBackgroundView = null;
				}
			}

			if (window._context && _context.editor && _context.editor.contentFrameController) {
				_context.editor.contentFrameController.needsWindowLayout();
				_context.editor.refreshInspector();
			}
			
		}});
	

Scene.prototype.createDefaultStatusBarBackgroundView = function Scene__createDefaultStatusBarBackgroundView() {
		this.statusBarBackgroundView = createComponentFromDomain("StatusBarBackgroundView", "appdoo", this.context, {
			size: { width: this.viewController.view.size.width, height: 21 },
			autoresizingMask: 2,
			backgroundColor: this.v_statusBarIsBright ?
				(this.viewController.view.backgroundColor || 'rgb(0, 0, 0)' ):
				(this.viewController.view.backgroundColor || 'rgb(255, 255, 255)')})
		;};
	
	

	
	
	function addInspectorGroupFromChild(groups, keyPath, obj) {

		var p = obj.inspectorProperties;
		if (Array.isArray(p[0].items)) p[0].items.every(function (item) {
			item.keyPath = keyPath+'.'+item.keyPath;return true; }, this);
		
		p[0].id += 'InScene';
		groups.push(p[0]);
	
	}
	
	Object.defineProperty(Scene.prototype, "inspectorProperties", {
		get: function () {
		
			if (!this.viewController.view) return false;

			statusBarIsEditable = !this.e_showsNavigationBar, disabledText = '';
			
			var groups = [
				{
					type: 'group',
					title: LocalizedString('Screen'),
					id: 'Scene',
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_title', placeholder: 'Name', undefinedValue:'' },
						{ name: LocalizedString('visible'), type: 'boolean', keyPath: 'e_statusBarIsVisible', disabled: !statusBarIsEditable, toolTip: disabledText,positionLeft:false,label:'     '+LocalizedString('Status Bar'),hidden:!statusBarIsEditable },
						{ name: LocalizedString('separated'), type: 'boolean', keyPath: 'e_separateStatusBar',  positionLeft:false, disabled: !statusBarIsEditable, toolTip: disabledText,hidden:!statusBarIsEditable },
						{ name: LocalizedString('light'), type: 'boolean', keyPath: 'v_statusBarIsBright', label: '', positionLeft:false, disabled: !statusBarIsEditable, toolTip: disabledText,hidden:!statusBarIsEditable },
						{ type: 'space', hidden: !statusBarIsEditable },
					]
				},
			];
			
			
		
			var p = this.viewController.view.inspectorProperties;

			if (Array.isArray(p[0].items)) p[0].items.every(function (item) {
				item.keyPath = 'viewController.view.'+item.keyPath;
				groups[0].items.push(item);return true; }, this);
			
			
			groups[0].items.splice(groups[0].items.length-1, 0, {
				name: LocalizedString('Global Tint Color'),
				type: 'color',
				keyPath: 'windowTintColor',
				undefinedValue: this.context.defaultOrSystemTintColor
			});
			
			if (!this.e_showsTabBar && _context.projectContext.simulatedDeviceType==='iPhone') {
				groups[0].items.splice(groups[0].items.length-1, 0, 
					{ 
						type:'space' 
					},{ 
						type: 'boolean', 
						name: LocalizedString('Modal Interface Orientations'), 
						positionLeft: true, 
						keyPath: 'hasCustomInterfaceOrientations' 
					},{ 
						type:'space' 
					},{ 
						hidden: !this.hasCustomInterfaceOrientations, 
						name: '', 
						type: 'custom', 
						UTI: 'appdoo.InterfaceOrientationControl',
						properties: {
							targetedDeviceFamily: _context.projectContext.metadata.targetedDeviceFamily,
							size: { 
								width: 182, height: 50 
							},
							position: { 
								left: 25 
							},
							bindings: [{
								sourceKeyPath: 'value',
								destination: "selection",
								destinationKeyPath: 'supportedInterfaceOrientations', 
								destinationObject: this.selection,
								bidirectional: true,
								valueTransformer: function (a) {
									if (Array.isArray(a)) return a[0];
									return a;
								}
							}]
						},
					}
				);
			}

			
			if (this.viewController.tabBarItem) {
				var g = []; 
				addInspectorGroupFromChild(g, 'viewController.tabBarItem', this.viewController.tabBarItem);
				var navigationGroup = g[0];
				navigationGroup.title = LocalizedString('Navigation');
				navigationGroup.id = 'SceneNavigation';
				navigationGroup.items.unshift(
					{
						name: LocalizedString('Use Navigation Bar'),
						type: 'boolean', 
						keyPath: 'e_showsNavigationBar', 
						positionLeft: true 
					},{ 
						name: LocalizedString('Show Tab Bar'), 
						type: 'boolean', 
						keyPath: 'e_showsTabBar', 
						positionLeft: true 
					}
				);
				groups.push(navigationGroup);
			}

			return groups;
		}});
	
	
	Object.defineProperty(Scene.prototype, "windowTintColor", {
		get: function () { return _context.projectMetadataController.get('globalTintColor'); }, 
		set: function (v) {
			_context.projectMetadataController.contents.globalTintColor = v;
			_context.editor.contentFrameController.simulatedWindow.tintColor = v || this.context.defaultOrSystemTintColor;
			var change = {
				type: 'change',
				object: _context.editor.editedScene,
			};
			
			
		}});
	


	
	Object.defineProperty(Scene.prototype, "readableValue", {
		get: function () { return this.get('viewController.title'); }});
	


	
	Object.defineProperty(Scene.prototype, "size", {
		get: function () {
			return this.get('viewController.view.size');
		}});
	

	Object.defineProperty(Scene.prototype, "position", {
		value: { left: 0, top: 0 }});
	

	Object.defineProperty(Scene.prototype, "positionOnOverview", {
	outlet: true, 
	enumerable: true, get:function () { return this._positionOnOverview; }, set:function (v) {if (!Object.hasOwnProperty(this, "_positionOnOverview")) Object.defineProperty(this, "_positionOnOverview", { writable: true, configurable: true }); this._positionOnOverview = v; }});
		
	
	Object.defineProperty(Scene.prototype, "landscape", {
	outlet: true, 
	enumerable: true, get:function () { return this._landscape; }, set:function (v) {if (!Object.hasOwnProperty(this, "_landscape")) Object.defineProperty(this, "_landscape", { writable: true, configurable: true }); this._landscape = v; }});
	
	

	

	Object.defineProperty(Scene.prototype, "localContextData", {
	outlet: true, 
	enumerable: true, get:function () { return this._localContextData; }, set:function (v) {if (!Object.hasOwnProperty(this, "_localContextData")) Object.defineProperty(this, "_localContextData", { writable: true, configurable: true }); this._localContextData = v; }});
	

	Object.defineProperty(Scene.prototype, "contentCanScrollVertically", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_contentCanScrollVertically")) Object.defineProperty(this, "_contentCanScrollVertically", { writable: true, configurable: true });
			this._contentCanScrollVertically = v;

			if (this.editorReference)
			this.editorReference.contentFrameController.contentCanScrollVertically = v;
		}, get:function () { return this._contentCanScrollVertically; }});
	

	Object.defineProperty(Scene.prototype, "temporaryPreviewImagePath", {
	synthesized: true, 
		get: function () {
			if (this._temporaryPreviewImagePath) return this._temporaryPreviewImagePath;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_temporaryPreviewImagePath")) Object.defineProperty(this, "_temporaryPreviewImagePath", { writable: true, configurable: true }); this._temporaryPreviewImagePath = v; }});
	

	Object.defineProperty(Scene.prototype, "clipContent", {
		set: function (v) {
			this.contentCanScrollVertically = !v;
		}, 
		get: function () {
			return !this.contentCanScrollVertically;
		}});
	

	Object.defineProperty(Scene.prototype, "dataContext", {
	synthesized: true, get:function () { return this._dataContext; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataContext")) Object.defineProperty(this, "_dataContext", { writable: true, configurable: true }); this._dataContext = v; }});
	

	
Scene.prototype.setNewIDsInClone = function Scene__setNewIDsInClone(clone, mapping) {
		_context.setNewIDsInClone(clone, mapping);};
	
	
Scene.prototype.updateConnectionsInClone = function Scene__updateConnectionsInClone(clone, mapping, keyPath) {

		

		for (var key in clone) {
			if (typeof clone[key] === 'string' && mapping[clone[key]] !== undefined) {
				clone[key] = mapping[clone[key]];
			}
			if (typeof clone[key] !== 'object' || clone[key] === null) continue;
			this.updateConnectionsInClone(clone[key], mapping, keyPath ? keyPath+'.'+key : key);
		}};
	

Scene.prototype.encodeCloned = function Scene_encodeCloned() {
		var data = __super.prototype.encodeCloned.call(this);
		delete data.v_showsInTabBar;
		var mapping = {};
		this.setNewIDsInClone(data, mapping);
		this.updateConnectionsInClone(data, mapping);
		return data;};
	


	
	
Scene.prototype.prepareForEditor = function Scene_prepareForEditor(editor) {
	
		var scene = this;
		var viewController = this.viewController;

		scene.viewController.loadView();
		if (!scene.viewController.view) {
			alert(LocalizedString('We are sorry. The content of this scene has been lost. If you have a backup of this project, please restore it.'));
			var size = this.context.windowSizeInPoints;
			scene.viewController.viewData = {
					$type: 'SceneRootView',
					$domain: 'appdoo.iOS',
					size: size,
					backgroundColor: 'rgb(255, 255, 255)'
				};
			scene.viewController.loadView();
		}
		
		if (scene.navigationBar) scene.navigationBar.prepareForNavigation();
		(function () {
	
			
			
			this.registerItem(viewController, null);
			if (scene.navigationBar) {
				this.registerItem(scene.navigationBar);
				this.observeObject(scene.navigationBar.dataController);
			}
			if (viewController.tabBarItem) {
				this.registerItem(viewController.tabBarItem);
				this.observeObject(viewController.tabBarItem.dataController);
			}
			this.observeObject(scene.dataController);
			
			Object.defineProperty(viewController, 'treeController', { value: this.treeController });
	
			scene.objectsNode = createComponentFromDomain('SceneObjectsTreeNode', 'appdoo', this.context, {
				scene: scene,
				controller: this.treeController,
				representedObject: {
					readableValue: LocalizedString('Objects'),
					outlineIconURL: 'Resources/SceneObjects.png',
					get: function (keyPath) { return this[keyPath]; },
					isExpandedInEditorOutline: this.editedScene.sceneObjectsNodeIsExpandedInEditorOutline !== false,
					context: _context.projectContext,
					acceptsMemberWithUTI: function (uti, obj) {
						return _context.editor.objectsGroupAcceptsMemberWithUTI(uti, null, obj);
					}.bind(_context.editor),
					encodeCloned: function () { return {}; },
					UTI: ''
				}
			});
			scene.objectsNode.representedObject.node = scene.objectsNode;
			
	
			
			if (Array.isArray(scene.objects)) scene.objects.every(function (obj) {
				var node = this.objectsNode.addChildNodeWithRepresentedObject(obj);
	
				this.registerItem(obj, node);
				if (obj.addObserver)
					obj.addObserver(this);return true; }, this);
			
			
			if (_context.projectContext.usesNavigationOutlineNode) {
				var sceneNavigation = createComponentFromDomain('SceneNavigation', 'appdoo', this.context.projectContext, {
					isExpandedInEditorOutline: this.editedScene.navigationObjectsNodeIsExpandedInEditorOutline,
					scene: scene
				});
				this.registerItem(sceneNavigation);
				scene.navigationGroup = sceneNavigation;
		
				
				var navigationObjectsNode = createComponentFromDomain('NavigationObjectsTreeNode', 'appdoo', this.context, {
					scene: scene,
					controller: this.treeController,
					representedObject: sceneNavigation
				});
				scene.navigationObjectsNode = navigationObjectsNode;
			} else {
				scene.navigationObjectsNode = scene.node;
			}
			
		}).call(editor);
		
};
	
	
Scene.prototype.editDefault = function Scene_editDefault(editor) {
		if (this.e_showsNavigationBar)
			return this.navigationBar.editDefault(editor);};
	
	
	Object.defineProperty(Scene.prototype, "navigationGroup", {
	synthesized: true, get:function () { return this._navigationGroup; }, set:function (v) {if (!Object.hasOwnProperty(this, "_navigationGroup")) Object.defineProperty(this, "_navigationGroup", { writable: true, configurable: true }); this._navigationGroup = v; }});
	
	
Scene.prototype.unprepareForEditor = function Scene_unprepareForEditor(editor) {
		
		if (Array.isArray(this.viewController.view.subviews)) this.viewController.view.subviews.every(function (subview) {
			editor.unregisterItem(subview, editor, true);return true; }, this);
		

		if (Array.isArray(this.objects)) this.objects.every(function (obj) {
			if (obj.removeObserver) obj.removeObserver(this);
			editor.unregisterItem(obj);return true; }, this);
		
		

		this.viewController.unloadView();
	};
	
	
Scene.prototype.prepareTreeControllerForScene = function Scene__prepareTreeControllerForScene() {
	
		var scene = this;

		(function () {
		
			var rootNode = this.treeController.rootNode;
			rootNode.representedObject = scene;
	
			var viewController = scene.viewController;

			if (viewController.navigationItem)
				rootNode.addChildNodeWithRepresentedObject(viewController.navigationItem);
	
			this.viewNode = rootNode.insertChildNodeWithRepresentedObjectAtIndex(viewController.view, 0);
	
			if (scene.objects) {
				if (Array.isArray(scene.objects)) scene.objects.every(function (obj) {
					Object.defineProperty(obj, 'node', { value: obj.node, configurable: true });return true; }, this);
				
			}
	
			scene.registerChildObjectsForEditor(this);
	
			this.checkSpecialNodes();

		}).call(_context.editor);
};
	


Scene.prototype.registerObjectBindings = function Scene_registerObjectBindings() {
		this.performWithNonViewObjects(function (obj) {
			obj.registerBindings();
		});};
	

Scene.prototype.unregisterObjectBindings = function Scene_unregisterObjectBindings() {
		this.performWithNonViewObjects(function (obj) {
			obj.unregisterBindings();
		});};
	
	
Scene.prototype.performWithNonViewObjects = function Scene_performWithNonViewObjects(callback) {
		if (this.navigationBar && this.navigationBar.topItem) {
			if (Array.isArray(this.navigationBar.topItem.barButtonItems)) this.navigationBar.topItem.barButtonItems.every(function (barButtonItem) {
				callback(barButtonItem);return true; }, this);
			
		}
		if (Array.isArray(this.objects)) this.objects.every(function (object) {
			callback(object);return true; }, this);
		};
	

Scene.prototype.hasSegues = function Scene_hasSegues() {
		return (this.segues && this.segues.length);};
	

	
	
	Object.defineProperty(Scene.prototype, "v_showsInTabBar", {
	outlet: true, 
	enumerable: true, get:function () { return this._v_showsInTabBar; }, set:function (v) {if (!Object.hasOwnProperty(this, "_v_showsInTabBar")) Object.defineProperty(this, "_v_showsInTabBar", { writable: true, configurable: true }); this._v_showsInTabBar = v; }});
	

	Object.defineProperty(Scene.prototype, "e_showsInTabBar", {
		get: function ( ) { return this.v_showsInTabBar; }, 
		set: function (v) {
			if (v && !this.e_showsTabBar) {
				this.dataController.setValueForKey(true, 'e_showsTabBar');
			}
			if (v)	{
				this.addToTabBar();
				this.v_showsInTabBar = true;
			} else {
				this.removeFromTabBar();
				this.v_showsInTabBar = false;
			}
			_context.editor.refreshInspector();
			this.context.nativeProxy.sendMessage('updateAllPreviewImages');
		}});
	
	
Scene.prototype.addToTabBar = function Scene__addToTabBar() {
		if (!this.viewController.tabBarItem) {
			this.viewController.tabBarItem = this.createDefaultTabBarItem();
			this.checkSpecialNodes();
			_context.editor.registerItem(this.viewController.tabBarItem);
		}
		this.context.tabBarController.addScene(this);
		this.context.tabBarController.updateTabBar();
		_context.updateAllSceneViews();};
	

Scene.prototype.removeFromTabBar = function Scene__removeFromTabBar() {
		this.context.tabBarController.removeScene(this);
		if (this.e_showsTabBar) {
			this.context.tabBarController.updateTabBar();
		}
		_context.updateAllSceneViews();};
	
	
	Object.defineProperty(Scene.prototype, "navigationObjectsNodeIsExpandedInEditorOutline", {
	outlet: true, 
	enumerable: true, get:function () { return this._navigationObjectsNodeIsExpandedInEditorOutline; }, set:function (v) {if (!Object.hasOwnProperty(this, "_navigationObjectsNodeIsExpandedInEditorOutline")) Object.defineProperty(this, "_navigationObjectsNodeIsExpandedInEditorOutline", { writable: true, configurable: true }); this._navigationObjectsNodeIsExpandedInEditorOutline = v; }});
	

	Object.defineProperty(Scene.prototype, "sceneObjectsNodeIsExpandedInEditorOutline", {
	outlet: true, 
	enumerable: true, get:function () { return this._sceneObjectsNodeIsExpandedInEditorOutline; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sceneObjectsNodeIsExpandedInEditorOutline")) Object.defineProperty(this, "_sceneObjectsNodeIsExpandedInEditorOutline", { writable: true, configurable: true }); this._sceneObjectsNodeIsExpandedInEditorOutline = v; }});
	

	Object.defineProperty(Scene.prototype, "selectedObjectIDs", {
	outlet: true, 
	enumerable: true, get:function () { return this._selectedObjectIDs; }, set:function (v) {if (!Object.hasOwnProperty(this, "_selectedObjectIDs")) Object.defineProperty(this, "_selectedObjectIDs", { writable: true, configurable: true }); this._selectedObjectIDs = v; }});
	
	
	
	
	
	Object.defineProperty(Scene.prototype, "objectsNode", {
	synthesized: true, get:function () { return this._objectsNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_objectsNode")) Object.defineProperty(this, "_objectsNode", { writable: true, configurable: true }); this._objectsNode = v; }});
	

	Object.defineProperty(Scene.prototype, "navigationObjectsNode", {
	synthesized: true, get:function () { return this._navigationObjectsNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_navigationObjectsNode")) Object.defineProperty(this, "_navigationObjectsNode", { writable: true, configurable: true }); this._navigationObjectsNode = v; }});
	
	
Scene.prototype.addObject = function Scene_addObject(obj) {
	
		if (!this.objects) this.objects = [];
		this.objects.push(obj);
		
		
		this.context.connectableObjects[obj.identify()] = obj;

		this.checkSpecialNodes();
		};
	
	
	Object.defineProperty(Scene.prototype, "viewGroupSeparator", {
	synthesized: true, get:function () { return this._viewGroupSeparator; }, set:function (v) {if (!Object.hasOwnProperty(this, "_viewGroupSeparator")) Object.defineProperty(this, "_viewGroupSeparator", { writable: true, configurable: true }); this._viewGroupSeparator = v; }});
	

	Object.defineProperty(Scene.prototype, "viewGroupSeparatorNode", {
	synthesized: true, get:function () { return this._viewGroupSeparatorNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_viewGroupSeparatorNode")) Object.defineProperty(this, "_viewGroupSeparatorNode", { writable: true, configurable: true }); this._viewGroupSeparatorNode = v; }});
	

	Object.defineProperty(Scene.prototype, "objectGroupSeparator", {
	synthesized: true, get:function () { return this._objectGroupSeparator; }, set:function (v) {if (!Object.hasOwnProperty(this, "_objectGroupSeparator")) Object.defineProperty(this, "_objectGroupSeparator", { writable: true, configurable: true }); this._objectGroupSeparator = v; }});
	

	Object.defineProperty(Scene.prototype, "objectGroupSeparatorNode", {
	synthesized: true, get:function () { return this._objectGroupSeparatorNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_objectGroupSeparatorNode")) Object.defineProperty(this, "_objectGroupSeparatorNode", { writable: true, configurable: true }); this._objectGroupSeparatorNode = v; }});
	

	Object.defineProperty(Scene.prototype, "appObjectGroupSeparator", {
	synthesized: true, get:function () { return this._appObjectGroupSeparator; }, set:function (v) {if (!Object.hasOwnProperty(this, "_appObjectGroupSeparator")) Object.defineProperty(this, "_appObjectGroupSeparator", { writable: true, configurable: true }); this._appObjectGroupSeparator = v; }});
	

	Object.defineProperty(Scene.prototype, "appObjectGroupSeparatorNode", {
	synthesized: true, get:function () { return this._appObjectGroupSeparatorNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_appObjectGroupSeparatorNode")) Object.defineProperty(this, "_appObjectGroupSeparatorNode", { writable: true, configurable: true }); this._appObjectGroupSeparatorNode = v; }});
	
	
Scene.prototype.checkForSeparatorBeneathViewGroup = function Scene__checkForSeparatorBeneathViewGroup() {

		if (!this.viewGroupSeparator) this.viewGroupSeparator = { separator: true };

		if (!this.node.nodeForRepresentedObject(this.viewGroupSeparator)) {
			var viewNodeIndex = this.node.childNodes.indexOf(_context.editor.viewNode);
			this.viewGroupSeparatorNode = this.node.insertChildNodeWithRepresentedObjectAtIndex(this.viewGroupSeparator, viewNodeIndex+1);
		}};
	
	
Scene.prototype.checkForSeparatorBeneathObjectGroup = function Scene__checkForSeparatorBeneathObjectGroup() {
		if (!this.objectGroupSeparator) this.objectGroupSeparator = { separator: true };

		if (!this.node.nodeForRepresentedObject(this.objectGroupSeparator)) {
			var nodeIndex = this.node.childNodes.indexOf(_context.editor.appObjectsNode);
			if (nodeIndex === -1)
				nodeIndex = this.node.childNodes.indexOf(this.objectsNode);

			if (nodeIndex !== -1)
			this.objectGroupSeparatorNode = this.node.insertChildNodeWithRepresentedObjectAtIndex(this.objectGroupSeparator, nodeIndex+1);
		}};
	
	
Scene.prototype.checkForSeparatorBeneathGlobalObjectGroup = function Scene__checkForSeparatorBeneathGlobalObjectGroup() {
		if (!this.appObjectGroupSeparator) this.appObjectGroupSeparator = { separator: true };

		if (!this.node.nodeForRepresentedObject(this.appObjectGroupSeparator)) {
			var nodeIndex = this.node.childNodes.indexOf(_context.editor.appObjectsNode);
			if (nodeIndex !== -1)
			this.appObjectGroupSeparatorNode = this.node.insertChildNodeWithRepresentedObjectAtIndex(this.appObjectGroupSeparator, nodeIndex+1);
		}};
	
	
Scene.prototype.checkSpecialNodes = function Scene__checkSpecialNodes() {
		if (!this.navigationObjectsNode) return;
		
		this.checkForSeparatorBeneathViewGroup();


		if (!this.navigationObjectsNode.parentNode) {
			this.node.addChildNode(this.navigationObjectsNode);
		}

		if (this.e_showsNavigationBar) {
			if (this.navigationObjectsNode &&
				!this.navigationObjectsNode.nodeForRepresentedObject(this.navigationBar)) {
				var viewNodeIndex = this.node.childNodes.indexOf(this.viewGroupSeparatorNode);
				var node = this.navigationObjectsNode.insertChildNodeWithRepresentedObjectAtIndex(this.navigationBar, viewNodeIndex+1);
				Object.defineProperty(this.navigationBar, 'node', {value:node, configurable:true});
				this.navigationBar.checkChildNodes();
			}
		}
		else {
			if (this.navigationObjectsNode &&
				this.navigationObjectsNode.nodeForRepresentedObject(this.navigationBar)) {
				this.navigationObjectsNode.removeChildNodeWithRepresentedObject(this.navigationBar);
			}
		}

		
		if (this.e_showsTabBar) {
			if (this.navigationObjectsNode &&
				!this.navigationObjectsNode.nodeForRepresentedObject(this.context.tabBarController.tabBar)) {
				
				var viewNodeIndex = this.node.childNodes.indexOf(this.viewGroupSeparatorNode);
				this.navigationObjectsNode.insertChildNodeWithRepresentedObjectAtIndex(this.context.tabBarController.tabBar, viewNodeIndex+1);
				
			}
		}
		else {
			if (this.navigationObjectsNode &&
				this.navigationObjectsNode.nodeForRepresentedObject(this.context.tabBarController.tabBar)) {
				this.navigationObjectsNode.removeChildNodeWithRepresentedObject(this.context.tabBarController.tabBar);
			}
		}

		
		if (this.statusBarBackgroundView) {
			if (!this.node.nodeForRepresentedObject(this.statusBarBackgroundView)) {
				var viewNodeIndex = this.node.childNodes.indexOf(this.viewGroupSeparatorNode);
				this.node.insertChildNodeWithRepresentedObjectAtIndex(this.statusBarBackgroundView, viewNodeIndex+1);
			}
		}

		
		
		var showObjectGroups = this.context.objects.length || (this.objects && this.objects.length);
		
		if (showObjectGroups) {
			if (!_context.editor.appObjectsNode.parentNode) {
				var viewNodeIndex = this.node.childNodes.indexOf(this.viewGroupSeparatorNode);
				this.node.insertChildNodeAtIndex(_context.editor.appObjectsNode, viewNodeIndex+1);
			}
		}

		
		if (showObjectGroups) {
			if (!this.objectsNode.parentNode) {
				var viewNodeIndex = this.node.childNodes.indexOf(this.viewGroupSeparatorNode);
				this.node.insertChildNodeAtIndex(this.objectsNode, viewNodeIndex+1);
			}
		}

		
		if (this.context.fileReferences.length) {
			if (!_context.editor.fileReferencesNode.parentNode) {
				this.node.addChildNode(_context.editor.fileReferencesNode);
			}
		}
};
	
	
	
	

	Object.defineProperty(Scene.prototype, "inputDataSource", {
		get: function () {
			var r;
			if (Array.isArray(this.objects)) this.objects.every(function (obj) {
				if (obj.UTI === 'appdoo.SceneInputDataSource') {
					r = obj; return false;
				}return true; }, this);
			
			return r;
		}	});
	
	
Scene.prototype.loadInputData = function Scene_loadInputData(inputData, dataSource, indexPath) {
	
		var inputDataSource = this.getOrCreateInputDataSource();
		inputDataSource.contents = inputData;
		inputDataSource.originalDataSource = dataSource;
		inputDataSource.indexPath = indexPath;
		inputDataSource.notifyObservers();
};
	
	
Scene.prototype.getOrCreateInputDataSource = function Scene__getOrCreateInputDataSource() {
		
		if (!this.inputDataSource) {
		
			var inputDataSource = this.context.decodeObjectTree({
				$type: 'SceneInputDataSource',
				$domain: 'appdoo',
				$id: this.$id+'InputData',
				location: 'local',
			});

			this.addObject(inputDataSource);
			
			return inputDataSource;
		}
		
		return this.inputDataSource;
		};
	
	
	
	
	Object.defineProperty(Scene.prototype, "segues", {
	outlet: true, 
	enumerable: true, get:function () { return this._segues; }, set:function (v) {if (!Object.hasOwnProperty(this, "_segues")) Object.defineProperty(this, "_segues", { writable: true, configurable: true }); this._segues = v; }});
	
	
Scene.prototype.segueForView = function Scene_segueForView(view) {
		var r;
		if (Array.isArray(this.segues)) this.segues.every(function (segue) {
			if (segue.viewID === view.$id) {
				r = segue;
				return false;
			}return true; }, this);
		
		return r;};
	
	
Scene.prototype.addSegue = function Scene_addSegue(segue) {
		if (!this.segues) this.segues = [];
		this.segues.push(segue);};
	

Scene.prototype.removeSegue = function Scene_removeSegue(segue) {
		this.segues.splice(this.segues.indexOf(segue), 1);};
	


Scene.prototype.performWithEditor = function Scene__performWithEditor(f) {
		if (!window._context) return;
		if (!window._context.editor) return;
		f();};
	
	
Scene.prototype.registerChildObjectsForEditor = function Scene_registerChildObjectsForEditor(editor) {
		if (this.statusBarBackgroundView)
			editor.registerItem(this.statusBarBackgroundView);

		if (this.tabBarController.tabBar)
			editor.registerItem(this.tabBarController.tabBar);};
	


	var UIStatusBarStyleDefault = 0,
		UIStatusBarStyleLightContent = 1;
		
Scene.prototype.encodeForAppdooPreview = function Scene_encodeForAppdooPreview(deviceInfo) {
		var transformer = createComponentFromDomain('appdooPreviewTransformer', 'appdoo', _context, {
			deviceInfo: deviceInfo
		});

		var objects = [];
		transformer.currentObjects = objects;

		var encodedViewController = this.viewController.encode();
		var result = {
			$type: this.constructor.name,
			$domain: this.__domain,
			$id: this.$id,
			viewController: this.viewController.transformData(encodedViewController, transformer),
			objects: objects,
		};

		result.viewController.bindingsInfo = generateBindingsDictionaryForScene(this, this.objects, this, transformer),

		result.viewController.layoutRelationsInfos = getType('appdoo.Editor.LayoutResolver').prototype.layoutRelationsInViewForAppdooPreview(this.viewController.viewData, transformer);
		result.viewController.prefersStatusBarHidden = transformer.transformBoolean(!this.e_statusBarIsVisible);
		result.viewController.preferredStatusBarStyle = this.v_statusBarIsBright ? UIStatusBarStyleLightContent : (UIStatusBarStyleDefault);

		if (this.e_showsNavigationBar) {
			result.viewController.navigationBarInfo = this.navigationBar.transformData(this.navigationBar.encode(), transformer);
			
			
			
			
			if (this.navigationBar.items) {
				var navigationItem = this.navigationBar.items[0];
				var proto = getPrototype(utiFromData(navigationItem));

				result.viewController.navigationItem = proto.transformData(navigationItem.encode(), transformer);
		
				result.viewController.navigationItem.title = transformer.transformString(this.navigationBar.title);

				if (_context.imageReferenceIsValid(this.navigationBar.v_titleViewImage)) {
					result.viewController.navigationItem.titleView = {
						$type: 'UIImageView',
						$domain: 'com.apple',
						$initializer: { name: 'initWithImage:', arguments: [
							transformer.transformReferencedImage(this.navigationBar.v_titleViewImage)
						] }
					};
				}

			}
			
		}
		
		if (Array.isArray(this.objects)) this.objects.every(function (obj) {
			if (!transformer.checkCompatibility(obj, obj)) return true;
			if (obj.transformData)
				result.objects.push(obj.transformData(obj.encode(), transformer));return true; }, this);
		
		
		if (this.inputDataSource) {
			result.viewController.$connections.push({
				key: 'inputDataSource',
				destination: this.inputDataSource.$id
			});
		}

		result.viewController.hidesBottomBarWhenPushed = !this.e_showsTabBar;

		collectBindingsForObject(transformer.specialBindingsObject, result.viewController.bindingsInfo, this);

		if (this.supportedInterfaceOrientations)
			result.viewController.supportedModalInterfaceOrientations = this.supportedInterfaceOrientations;
			
			
		if (this.e_separateStatusBar) {
			var contentView = result.viewController.$viewData;
			var statusBarView = getPrototype('appdoo.iOS.UIView').transformData(this.statusBarBackgroundView.encode(), transformer);
			var frame;
			try {
				frame = clone(contentView.$initializer.arguments[0]);
			} catch (err) {}
			console.log('frame:',frame, 'result.viewController.$viewData',result.viewController.$viewData);
			result.viewController.$viewData = getPrototype('appdoo.iOS.UIView').transformData({
				$type: 'UIView',
				$domain: 'com.apple',
				frame: frame
			}, transformer);
			result.viewController.$viewData.$extra.subviews = [contentView, statusBarView];

			if (this.statusBarBackgroundView.translucent) {
			
			}
			else {
				try {
					if (result.viewController.$viewData.frame)
						result.viewController.$viewData.frame.size.height += 21;
					else if (result.viewController.$viewData.$initializer.arguments)
						result.viewController.$viewData.$initializer.arguments[0].size.height += 21;
					
					if (contentView.frame)
						contentView.frame.origin.y = 21;
					else if (contentView.$initializer.arguments)
						contentView.$initializer.arguments[0].origin.y = 21;

				} catch (err) {}
				contentView.autoresizingMask = 18;
			}

		}
		
		return result;};
	
	
Scene.prototype.bindingIsValid = function Scene_bindingIsValid() {
		return true;};
	
	
Scene.prototype.transformChangeForAppdooPreview = function Scene_transformChangeForAppdooPreview(change, transformer, result) {

		switch (change.keyPath) {

			case 'viewController.view.e_backgroundColor':
				result.keyPath = 'backgroundColor';
				result.value = transformer.transformCSSColor(change.valueNow);
				result.objectID = this.viewController.view.$id;
				return true;
				break;
			case 'windowTintColor':
				result.keyPath = 'tintColor';
				result.value = transformer.transformCSSColor(change.valueNow);
				result.objectID = '$ApplicationKeyWindow';
				delete result.sceneID;
				return true;
				break;

		}
		
	};
	
	
	Object.defineProperty(Scene.prototype, "supportedInterfaceOrientations", {
	outlet: true, 
	enumerable: true, get:function () { return this._supportedInterfaceOrientations; }, set:function (v) {if (!Object.hasOwnProperty(this, "_supportedInterfaceOrientations")) Object.defineProperty(this, "_supportedInterfaceOrientations", { writable: true, configurable: true }); this._supportedInterfaceOrientations = v; }});
	
	
	Object.defineProperty(Scene.prototype, "hasCustomInterfaceOrientations", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_hasCustomInterfaceOrientations")) Object.defineProperty(this, "_hasCustomInterfaceOrientations", { writable: true, configurable: true });
			if (this._hasCustomInterfaceOrientations === undefined)
				this._hasCustomInterfaceOrientations = v;
			else {
				this._hasCustomInterfaceOrientations = v;
				_context.editor.refreshInspector();
			}
		}, get:function () { return this._hasCustomInterfaceOrientations; }});
	

Scene.prototype.initPropertiesFromData = function Scene_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("objects")) this.objects = data.objects;
if (data.hasOwnProperty("viewController")) this.viewController = data.viewController;
if (data.hasOwnProperty("simulatedInterfaceOrientation")) this.simulatedInterfaceOrientation = data.simulatedInterfaceOrientation;
if (data.hasOwnProperty("navigationBar")) this.navigationBar = data.navigationBar;
if (data.hasOwnProperty("showsTabBar")) this.showsTabBar = data.showsTabBar;
if (data.hasOwnProperty("v_statusBarIsBright")) this.v_statusBarIsBright = data.v_statusBarIsBright;
if (data.hasOwnProperty("statusBarIsVisible")) this.statusBarIsVisible = data.statusBarIsVisible;
if (data.hasOwnProperty("statusBarBackgroundView")) this.statusBarBackgroundView = data.statusBarBackgroundView;
if (data.hasOwnProperty("v_separateStatusBar")) this.v_separateStatusBar = data.v_separateStatusBar;
if (data.hasOwnProperty("positionOnOverview")) this.positionOnOverview = data.positionOnOverview;
if (data.hasOwnProperty("landscape")) this.landscape = data.landscape;
if (data.hasOwnProperty("localContextData")) this.localContextData = data.localContextData;
if (data.hasOwnProperty("contentCanScrollVertically")) this.contentCanScrollVertically = data.contentCanScrollVertically;
if (data.hasOwnProperty("v_showsInTabBar")) this.v_showsInTabBar = data.v_showsInTabBar;
if (data.hasOwnProperty("navigationObjectsNodeIsExpandedInEditorOutline")) this.navigationObjectsNodeIsExpandedInEditorOutline = data.navigationObjectsNodeIsExpandedInEditorOutline;
if (data.hasOwnProperty("sceneObjectsNodeIsExpandedInEditorOutline")) this.sceneObjectsNodeIsExpandedInEditorOutline = data.sceneObjectsNodeIsExpandedInEditorOutline;
if (data.hasOwnProperty("selectedObjectIDs")) this.selectedObjectIDs = data.selectedObjectIDs;
if (data.hasOwnProperty("segues")) this.segues = data.segues;
if (data.hasOwnProperty("supportedInterfaceOrientations")) this.supportedInterfaceOrientations = data.supportedInterfaceOrientations;
if (data.hasOwnProperty("hasCustomInterfaceOrientations")) this.hasCustomInterfaceOrientations = data.hasCustomInterfaceOrientations;
};

Scene.prototype.decodeData = function Scene_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("objects")) decoded.objects = []; if (Array.isArray(data.objects)) { data.objects.forEach(function (o) { decoded.objects.push(this.context.decodeObjectTree(o)); }.bind(this)); }
if (data.hasOwnProperty("viewController")) decoded.viewController = this.context.decodeObjectTree(data.viewController);
if (data.hasOwnProperty("navigationBar")) decoded.navigationBar = this.context.decodeObjectTree(data.navigationBar);
if (data.hasOwnProperty("statusBarBackgroundView")) decoded.statusBarBackgroundView = this.context.decodeObjectTree(data.statusBarBackgroundView);
if (data.hasOwnProperty("segues")) decoded.segues = []; if (Array.isArray(data.segues)) { data.segues.forEach(function (o) { decoded.segues.push(this.context.decodeObjectTree(o)); }.bind(this)); }
return decoded; };

Scene.prototype.encode = function Scene_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._objects && this._objects.encode) {encoded.objects = []; this._objects.forEach(function (o) { encoded.objects.push(o.encode()); });
}if (this._viewController && this._viewController.encode) {encoded.viewController = this.viewController.encode();
}if (this._navigationBar && this._navigationBar.encode) {encoded.navigationBar = this.navigationBar.encode();
}if (this._statusBarBackgroundView && this._statusBarBackgroundView.encode) {encoded.statusBarBackgroundView = this.statusBarBackgroundView.encode();
}if (this._segues && this._segues.encode) {encoded.segues = []; this._segues.forEach(function (o) { encoded.segues.push(o.encode()); });
}return encoded; };

Scene.prototype.expectedTypeForProperty = function Scene_expectedTypeForProperty(key) {
	if (key === "objects") return "BasicObject[]";
	if (key === "viewController") return "appdoo.iOS.UIViewController";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "e_title") return "String";
	if (key === "simulatedInterfaceOrientation") return "String";
	if (key === "e_simulatedInterfaceOrientation") return "String";
	if (key === "simulatedWindowSize") return "";
	if (key === "previewSize") return "";
	if (key === "navigationBar") return "appdoo.iOS.UINavigationBar";
	if (key === "e_showsNavigationBar") return "";
	if (key === "tabBarController") return "";
	if (key === "e_showsTabBar") return "";
	if (key === "showsTabBar") return "Boolean";
	if (key === "v_statusBarIsBright") return "";
	if (key === "statusBarIsVisible") return "Boolean";
	if (key === "e_statusBarIsVisible") return "Boolean";
	if (key === "statusBarBackgroundView") return "StatusBarBackgroundView";
	if (key === "shouldHaveBrightStatusBar") return "";
	if (key === "v_separateStatusBar") return "";
	if (key === "e_separateStatusBar") return "";
	if (key === "inspectorProperties") return "";
	if (key === "windowTintColor") return "";
	if (key === "readableValue") return "";
	if (key === "size") return "";
	if (key === "position") return "";
	if (key === "positionOnOverview") return "";
	if (key === "landscape") return "";
	if (key === "localContextData") return "Object";
	if (key === "contentCanScrollVertically") return "Boolean";
	if (key === "temporaryPreviewImagePath") return "String";
	if (key === "clipContent") return "Boolean";
	if (key === "dataContext") return "Object";
	if (key === "navigationGroup") return "";
	if (key === "v_showsInTabBar") return "";
	if (key === "e_showsInTabBar") return "";
	if (key === "navigationObjectsNodeIsExpandedInEditorOutline") return "Boolean";
	if (key === "sceneObjectsNodeIsExpandedInEditorOutline") return "Boolean";
	if (key === "selectedObjectIDs") return "Array";
	if (key === "objectsNode") return "";
	if (key === "navigationObjectsNode") return "";
	if (key === "viewGroupSeparator") return "";
	if (key === "viewGroupSeparatorNode") return "";
	if (key === "objectGroupSeparator") return "";
	if (key === "objectGroupSeparatorNode") return "";
	if (key === "appObjectGroupSeparator") return "";
	if (key === "appObjectGroupSeparatorNode") return "";
	if (key === "inputDataSource") return "BasicDataSource";
	if (key === "segues") return "Segue[]";
	if (key === "supportedInterfaceOrientations") return "Number";
	if (key === "hasCustomInterfaceOrientations") return "Boolean";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Scene; }()));
registerType('appdoo.iOS', (function () { function SceneRootView() {} var __super = setSupertypeFromDomain(SceneRootView, 'ViewGroup', 'appdoo.iOS');

	Object.defineProperty(SceneRootView.prototype, "defaultBackgroundColor", {
		value: 'rgba(255,255,255,1.00)'});
	

	Object.defineProperty(SceneRootView.prototype, "nameIsEditable", {
		value: false});
	

	Object.defineProperty(SceneRootView.prototype, "viewMayScroll", {
		value: true});
	

	Object.defineProperty(SceneRootView.prototype, "widthIsEditable", {
		value: false});
	

	Object.defineProperty(SceneRootView.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(SceneRootView.prototype, "xIsEditable", {
		value: false});
	

	Object.defineProperty(SceneRootView.prototype, "yIsEditable", {
		value: false});
	

	Object.defineProperty(SceneRootView.prototype, "positionIsEditable", {
		value: false});
	

	Object.defineProperty(SceneRootView.prototype, "sizeIsEditable", {
		value: false});
	
	
	Object.defineProperty(SceneRootView.prototype, "autoresizingMaskIsEditable", {
		value: false});
	

	Object.defineProperty(SceneRootView.prototype, "canHaveLayoutRelations", {
		value: false});
	

	Object.defineProperty(SceneRootView.prototype, "readableType", {
		get: function () { return LocalizedString('View'); }});
	

	Object.defineProperty(SceneRootView.prototype, "readableValue", {
		get: function () { return this.readableType; }});
	
	
	Object.defineProperty(SceneRootView.prototype, "e_backgroundColor", {
		set: function (v) {
			if (_context.editor.editedScene.statusBarBackgroundView &&
				_context.editor.editedScene.statusBarBackgroundView.backgroundColor === this.backgroundColor) {
				_context.editor.editedScene.statusBarBackgroundView.backgroundColor = v;
			}
			this.backgroundColor = v;
		}, 
		get: function ( ) { return this.backgroundColor; }});
	

SceneRootView.prototype.expectedTypeForProperty = function SceneRootView_expectedTypeForProperty(key) {
	if (key === "defaultBackgroundColor") return "";
	if (key === "nameIsEditable") return "";
	if (key === "viewMayScroll") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "autoresizingMaskIsEditable") return "";
	if (key === "canHaveLayoutRelations") return "";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "e_backgroundColor") return "String";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SceneRootView; }()));
registerType('appdoo', (function () { function StatusBarBackgroundView() {} var __super = setSupertypeFromDomain(StatusBarBackgroundView, 'ViewGroup', 'appdoo.iOS');

	Object.defineProperty(StatusBarBackgroundView.prototype, "outlineIconURL", {
		value: 'Resources/StatusBarBackgroundView.png'});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "readableType", {
		get: function () { return LocalizedString('Status Bar Background View'); }});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "readableValue", {
		get: function () { return this.readableType; }});
	
	
StatusBarBackgroundView.prototype.prepareForEditor = function StatusBarBackgroundView_prepareForEditor(editor) {};
	

StatusBarBackgroundView.prototype.deleteForEditor = function StatusBarBackgroundView_deleteForEditor(editor) {
		editor.editedScene.statusBarBackgroundView = null;
		editor.editedScene.e_separateStatusBar = false;};
	
	
	Object.defineProperty(StatusBarBackgroundView.prototype, "backgroundColor", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_backgroundColor")) Object.defineProperty(this, "_backgroundColor", { writable: true, configurable: true });
			this._backgroundColor = v;
			this.style({ backgroundColor: v });
			var split = parseRgbCSSColor(v);
			this.translucent = split[3] !== undefined && split[3] < 1;
		}, get:function () { return this._backgroundColor; }});
	
	
	Object.defineProperty(StatusBarBackgroundView.prototype, "translucent", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_translucent")) Object.defineProperty(this, "_translucent", { writable: true, configurable: true });
			if (this._translucent === v) return;
			this._translucent = v;
			if (_context && _context.editor)
				_context.editor.contentFrameController.layoutWindow();
		}, get:function () { return this._translucent; }});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "nameIsEditable", {
		value: false});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "viewMayScroll", {
		value: false});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "widthIsEditable", {
		value: false});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "xIsEditable", {
		value: false});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "yIsEditable", {
		value: false});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "positionIsEditable", {
		value: false});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "sizeIsEditable", {
		value: false});
	
	
	Object.defineProperty(StatusBarBackgroundView.prototype, "autoresizingMaskIsEditable", {
		value: false});
	

	Object.defineProperty(StatusBarBackgroundView.prototype, "canHaveLayoutRelations", {
		value: false});
	

StatusBarBackgroundView.prototype.selectForEditor = function StatusBarBackgroundView_selectForEditor(editor) {
		editor.showFocusRing(this);};
	

StatusBarBackgroundView.prototype.unselectForEditor = function StatusBarBackgroundView_unselectForEditor(editor) {
		editor.hideFocusRing(this);};
	
	
StatusBarBackgroundView.prototype.prepareForEditor = function StatusBarBackgroundView_prepareForEditor(editor) {
		this.DOMNode.onclick = function () {
			editor.treeController.beginSelectionChange();
			editor.treeController.unselectAll();
			editor.treeController.selectValue(this);
			editor.treeController.commitSelectionChange();
		}.bind(this);};
	
	
	Object.defineProperty(StatusBarBackgroundView.prototype, "encodesSubviews", {
		value: false});
	

StatusBarBackgroundView.prototype.initPropertiesFromData = function StatusBarBackgroundView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("backgroundColor")) this.backgroundColor = data.backgroundColor;
if (data.hasOwnProperty("translucent")) this.translucent = data.translucent;
};

StatusBarBackgroundView.prototype.decodeData = function StatusBarBackgroundView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

StatusBarBackgroundView.prototype.encode = function StatusBarBackgroundView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

StatusBarBackgroundView.prototype.encodeCloned = function StatusBarBackgroundView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

StatusBarBackgroundView.prototype.expectedTypeForProperty = function StatusBarBackgroundView_expectedTypeForProperty(key) {
	if (key === "outlineIconURL") return "";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "backgroundColor") return "";
	if (key === "translucent") return "";
	if (key === "nameIsEditable") return "";
	if (key === "viewMayScroll") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "autoresizingMaskIsEditable") return "";
	if (key === "canHaveLayoutRelations") return "";
	if (key === "encodesSubviews") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return StatusBarBackgroundView; }()));
registerType('appdoo.iOS', (function () { function NSIndexPath() {} var __super = setSupertypeFromDomain(NSIndexPath, 'BasicObject', 'Core');

NSIndexPath.prototype.toString = function NSIndexPath_toString() {
		return '';};
	

	Object.defineProperty(NSIndexPath.prototype, "item", {
	outlet: true, 
	enumerable: true, get:function () { return this._item; }, set:function (v) {if (!Object.hasOwnProperty(this, "_item")) Object.defineProperty(this, "_item", { writable: true, configurable: true }); this._item = v; }});
	

	Object.defineProperty(NSIndexPath.prototype, "section", {
	outlet: true, 
	enumerable: true, get:function () { return this._section; }, set:function (v) {if (!Object.hasOwnProperty(this, "_section")) Object.defineProperty(this, "_section", { writable: true, configurable: true }); this._section = v; }});
	
	
	Object.defineProperty(NSIndexPath.prototype, "readableType", {
		get: function () {
			return LocalizedString('Index Path');
		}});
	

	Object.defineProperty(NSIndexPath.prototype, "readableValue", {
		get: function () {
			return this.readableType+' '+this.section+', '+this.item;
		}});
	


NSIndexPath.prototype.initPropertiesFromData = function NSIndexPath_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("item")) this.item = data.item;
if (data.hasOwnProperty("section")) this.section = data.section;
};

NSIndexPath.prototype.decodeData = function NSIndexPath_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

NSIndexPath.prototype.encode = function NSIndexPath_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

NSIndexPath.prototype.encodeCloned = function NSIndexPath_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

NSIndexPath.prototype.expectedTypeForProperty = function NSIndexPath_expectedTypeForProperty(key) {
	if (key === "item") return "Number";
	if (key === "section") return "Number";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return NSIndexPath; }()));
registerType('appdoo.iOS', (function () { function Segue() {} var __super = setSupertypeFromDomain(Segue, 'BasicObject', 'Core');

	Object.defineProperty(Segue.prototype, "type", {
	outlet: true, 
	enumerable: true, get:function () { return this._type; }, set:function (v) {if (!Object.hasOwnProperty(this, "_type")) Object.defineProperty(this, "_type", { writable: true, configurable: true }); this._type = v; }});
	

	Object.defineProperty(Segue.prototype, "viewID", {
	outlet: true, 
	enumerable: true, get:function () { return this._viewID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_viewID")) Object.defineProperty(this, "_viewID", { writable: true, configurable: true }); this._viewID = v; }});
	

	Object.defineProperty(Segue.prototype, "destinationSceneID", {
	outlet: true, 
	enumerable: true, get:function () { return this._destinationSceneID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_destinationSceneID")) Object.defineProperty(this, "_destinationSceneID", { writable: true, configurable: true }); this._destinationSceneID = v; }});
	

Segue.prototype.initPropertiesFromData = function Segue_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("type")) this.type = data.type;
if (data.hasOwnProperty("viewID")) this.viewID = data.viewID;
if (data.hasOwnProperty("destinationSceneID")) this.destinationSceneID = data.destinationSceneID;
};

Segue.prototype.decodeData = function Segue_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

Segue.prototype.encode = function Segue_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

Segue.prototype.encodeCloned = function Segue_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

Segue.prototype.expectedTypeForProperty = function Segue_expectedTypeForProperty(key) {
	if (key === "type") return "String";
	if (key === "viewID") return "String";
	if (key === "destinationSceneID") return "String";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Segue; }()));
registerType('appdoo', (function () { function SceneNavigation() {} var __super = setSupertypeFromDomain(SceneNavigation, 'BasicObject', 'Core');

	Object.defineProperty(SceneNavigation.prototype, "scene", {
	outlet: true, get:function () { return this._scene; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scene")) Object.defineProperty(this, "_scene", { writable: true, configurable: true }); this._scene = v; }});
	

	Object.defineProperty(SceneNavigation.prototype, "readableType", {
		get: function () { return LocalizedString('Navigation'); }});
	
	
	Object.defineProperty(SceneNavigation.prototype, "outlineIconURL", {
		value: 'Resources/NavigationOutline.png'});
	

	Object.defineProperty(SceneNavigation.prototype, "widthIsEditable", {
		value: false});
	

	Object.defineProperty(SceneNavigation.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(SceneNavigation.prototype, "xIsEditable", {
		value: false});
	

	Object.defineProperty(SceneNavigation.prototype, "yIsEditable", {
		value: false});
	

	Object.defineProperty(SceneNavigation.prototype, "positionIsEditable", {
		value: false});
	

	Object.defineProperty(SceneNavigation.prototype, "sizeIsEditable", {
		value: false});
	
	
	Object.defineProperty(SceneNavigation.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'SceneNavigation',
					items: [
						
						{ name: LocalizedString('Use Navigation Bar'), type: 'boolean', keyPath: 'scene.e_showsNavigationBar', positionLeft: true },
						{ name: LocalizedString('Show Tab Bar'), label: '', type: 'boolean', keyPath: 'scene.e_showsTabBar', positionLeft: true },

					]
				},
			];
			
			
		}});
	

SceneNavigation.prototype.initPropertiesFromData = function SceneNavigation_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("scene")) this.scene = data.scene;
};

SceneNavigation.prototype.decodeData = function SceneNavigation_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SceneNavigation.prototype.encode = function SceneNavigation_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SceneNavigation.prototype.encodeCloned = function SceneNavigation_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SceneNavigation.prototype.expectedTypeForProperty = function SceneNavigation_expectedTypeForProperty(key) {
	if (key === "scene") return "";
	if (key === "readableType") return "";
	if (key === "outlineIconURL") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "inspectorProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SceneNavigation; }()));
registerType('appdoo', (function () { function InterfaceOrientationControl() {} var __super = setSupertypeFromDomain(InterfaceOrientationControl, 'View', 'Core.UI');

	var UIInterfaceOrientationMaskPortrait = 1 << 1,
		UIInterfaceOrientationMaskPortraitUpsideDown = 1 << 2,
		UIInterfaceOrientationMaskLandscapeLeft = 1 << 3,
		UIInterfaceOrientationMaskLandscapeRight = 1 << 4,
		UIInterfaceOrientationMaskLandscape = (UIInterfaceOrientationMaskLandscapeLeft | UIInterfaceOrientationMaskLandscapeRight),
		UIInterfaceOrientationMaskAll = (UIInterfaceOrientationMaskPortrait | UIInterfaceOrientationMaskLandscapeLeft | UIInterfaceOrientationMaskLandscapeRight | UIInterfaceOrientationMaskPortraitUpsideDown),
		UIInterfaceOrientationMaskAllButUpsideDown = (UIInterfaceOrientationMaskPortrait | UIInterfaceOrientationMaskLandscapeLeft | UIInterfaceOrientationMaskLandscapeRight);

	Object.defineProperty(InterfaceOrientationControl.prototype, "portraitIsEnabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._portraitIsEnabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_portraitIsEnabled")) Object.defineProperty(this, "_portraitIsEnabled", { writable: true, configurable: true }); this._portraitIsEnabled = v; }});
	

	Object.defineProperty(InterfaceOrientationControl.prototype, "portraitUpsideDownIsEnabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._portraitUpsideDownIsEnabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_portraitUpsideDownIsEnabled")) Object.defineProperty(this, "_portraitUpsideDownIsEnabled", { writable: true, configurable: true }); this._portraitUpsideDownIsEnabled = v; }});
	

	Object.defineProperty(InterfaceOrientationControl.prototype, "lanscapeRightIsEnabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._lanscapeRightIsEnabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_lanscapeRightIsEnabled")) Object.defineProperty(this, "_lanscapeRightIsEnabled", { writable: true, configurable: true }); this._lanscapeRightIsEnabled = v; }});
	

	Object.defineProperty(InterfaceOrientationControl.prototype, "lanscapeLeftIsEnabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._lanscapeLeftIsEnabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_lanscapeLeftIsEnabled")) Object.defineProperty(this, "_lanscapeLeftIsEnabled", { writable: true, configurable: true }); this._lanscapeLeftIsEnabled = v; }});
	

	Object.defineProperty(InterfaceOrientationControl.prototype, "targetedDeviceFamily", {
	outlet: true, 
	enumerable: true, get:function () { return this._targetedDeviceFamily; }, set:function (v) {if (!Object.hasOwnProperty(this, "_targetedDeviceFamily")) Object.defineProperty(this, "_targetedDeviceFamily", { writable: true, configurable: true }); this._targetedDeviceFamily = v; }});
	
	
	Object.defineProperty(InterfaceOrientationControl.prototype, "widthIsEditable", {
		value: false});
	

	Object.defineProperty(InterfaceOrientationControl.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(InterfaceOrientationControl.prototype, "xIsEditable", {
		value: false});
	

	Object.defineProperty(InterfaceOrientationControl.prototype, "yIsEditable", {
		value: false});
	

	Object.defineProperty(InterfaceOrientationControl.prototype, "positionIsEditable", {
		value: false});
	

	Object.defineProperty(InterfaceOrientationControl.prototype, "sizeIsEditable", {
		value: false});
	
	
	Object.defineProperty(InterfaceOrientationControl.prototype, "value", {
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_value")) Object.defineProperty(this, "_value", { writable: true, configurable: true });

			if (v === undefined) {
				v = 0;
			}

			this.disabled = false;
		
			this._value = v;
			this.updateButtons();
		}, get:function () { return this._value; }});
	
	
InterfaceOrientationControl.prototype.init = function InterfaceOrientationControl_init() {
		__super.prototype.init.call(this);
		if (this._value === undefined) this.disabled = true;
		this.createSubviews();
		this.updateButtons();
		return this;};
	
	
InterfaceOrientationControl.prototype.createSubviews = function InterfaceOrientationControl__createSubviews() {
		var spacing = 5;
		var buttonSizeNumber = ((this.size.width-(4-1)*spacing)/4)|0;
		var buttonSize = { width: buttonSizeNumber, height: buttonSizeNumber };
		var buttons = [];
		
		var imageSrcs, onStateImageSrcs, tags;

		var toolTips = {};
		toolTips[UIInterfaceOrientationMaskPortrait] = 'Portrait';
		toolTips[UIInterfaceOrientationMaskPortraitUpsideDown] = 'Upside Down';
		toolTips[UIInterfaceOrientationMaskLandscapeRight] = 'Landscape, Home Button on the Left';
		toolTips[UIInterfaceOrientationMaskLandscapeLeft] = 'Landscape, Home Button on the Right';

		if (this.targetedDeviceFamily === 'iPhone' || this.targetedDeviceFamily == 'iOS-Universal') {
			imageSrcs = [
				'Resources/iPhonePortrait.png',
				'Resources/iPhonePortraitUpsideDown.png',
				'Resources/iPhoneLandscapeLeft.png',
				'Resources/iPhoneLandscapeRight.png'
			];
			onStateImageSrcs = [
				'Resources/iPhonePortraitOn.png',
				'Resources/iPhonePortraitUpsideDownOn.png',
				'Resources/iPhoneLandscapeLeftOn.png',
				'Resources/iPhoneLandscapeRightOn.png'
			];
			tags = [
				UIInterfaceOrientationMaskPortrait,
				UIInterfaceOrientationMaskPortraitUpsideDown,
				UIInterfaceOrientationMaskLandscapeRight,
				UIInterfaceOrientationMaskLandscapeLeft
			];
		}
		if (this.targetedDeviceFamily === 'iPad') {
			imageSrcs = [
				'Resources/iPadPortrait.png',
				'Resources/iPadPortraitUpsideDown.png',
				'Resources/iPadLandscapeLeft.png',
				'Resources/iPadLandscapeRight.png'
			];
			onStateImageSrcs = [
				'Resources/iPadPortraitOn.png',
				'Resources/iPadPortraitUpsideDownOn.png',
				'Resources/iPadLandscapeLeftOn.png',
				'Resources/iPadLandscapeRightOn.png'
			];
			tags = [
				UIInterfaceOrientationMaskPortrait,
				UIInterfaceOrientationMaskPortraitUpsideDown,
				UIInterfaceOrientationMaskLandscapeRight,
				UIInterfaceOrientationMaskLandscapeLeft
			];
		}
		
		if (!tags) return;
		
		this.buttons = [];
		for (var i = 0, c = tags.length; i < c; i++) {
			var button = createComponentFromDomain("Button", "Core.UI", this.context, {
				text: '',
				imageSrc: imageSrcs[i],
				onStateImageSrc: onStateImageSrcs[i],
				state: this.buttonHasStateAtIndex(i),
				buttonStyle: 'roundedFlat',
				buttonBorderRadius: 4,
				buttonType: 'onOff',
				size: buttonSize,
				position: { left: this.subviews.length*(buttonSizeNumber+spacing), top: 5 },
				toolTip: LocalizedString(toolTips[tags[i]]),
				tag: tags[i],
				target: this,
				targetMethod: 'didClickButton'})
			;
			this.buttons[i] = button;
			if (this.targetedDeviceFamily == 'iPhone' && i === 1) continue;
			this.addSubview(button);
		}
};
	
	
InterfaceOrientationControl.prototype.didClickButton = function InterfaceOrientationControl_didClickButton(button) {
		this._value ^= button.tag;
		this.context.broadcastValueChangeForKeyPathInObject('value', this, this);};
	
	
InterfaceOrientationControl.prototype.buttonHasStateAtIndex = function InterfaceOrientationControl__buttonHasStateAtIndex(i) {
		if (i === 0) return this.portraitIsEnabled;
		if (i === 1) return this.portraitUpsideDownIsEnabled;
		if (i === 2) return this.lanscapeRightIsEnabled;
		if (i === 2) return this.lanscapeLeftIsEnabled;};
	
	
	function isBitSet(num, mask) {
		return (num & mask) !== 0;
	}
	
InterfaceOrientationControl.prototype.updateButtons = function InterfaceOrientationControl__updateButtons() {
		if (!this.subviews.length) return;
	
		this.buttons[0].state = isBitSet(this._value, UIInterfaceOrientationMaskPortrait);
		this.buttons[1].state = isBitSet(this._value, UIInterfaceOrientationMaskPortraitUpsideDown);
		this.buttons[2].state = isBitSet(this._value, UIInterfaceOrientationMaskLandscapeRight);
		this.buttons[3].state = isBitSet(this._value, UIInterfaceOrientationMaskLandscapeLeft);};
	
	
InterfaceOrientationControl.prototype.initPropertiesFromData = function InterfaceOrientationControl_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("portraitIsEnabled")) this.portraitIsEnabled = data.portraitIsEnabled;
if (data.hasOwnProperty("portraitUpsideDownIsEnabled")) this.portraitUpsideDownIsEnabled = data.portraitUpsideDownIsEnabled;
if (data.hasOwnProperty("lanscapeRightIsEnabled")) this.lanscapeRightIsEnabled = data.lanscapeRightIsEnabled;
if (data.hasOwnProperty("lanscapeLeftIsEnabled")) this.lanscapeLeftIsEnabled = data.lanscapeLeftIsEnabled;
if (data.hasOwnProperty("targetedDeviceFamily")) this.targetedDeviceFamily = data.targetedDeviceFamily;
if (data.hasOwnProperty("value")) this.value = data.value;
};

InterfaceOrientationControl.prototype.decodeData = function InterfaceOrientationControl_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

InterfaceOrientationControl.prototype.encode = function InterfaceOrientationControl_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

InterfaceOrientationControl.prototype.encodeCloned = function InterfaceOrientationControl_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

InterfaceOrientationControl.prototype.expectedTypeForProperty = function InterfaceOrientationControl_expectedTypeForProperty(key) {
	if (key === "portraitIsEnabled") return "Boolean";
	if (key === "portraitUpsideDownIsEnabled") return "Boolean";
	if (key === "lanscapeRightIsEnabled") return "Boolean";
	if (key === "lanscapeLeftIsEnabled") return "Boolean";
	if (key === "targetedDeviceFamily") return "String";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "value") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return InterfaceOrientationControl; }()));