
registerType('appdoo', (function () { function SceneInputDataSource() {} var __super = setSupertypeFromDomain(SceneInputDataSource, 'BasicDataSource', 'appdoo');

	Object.defineProperty(SceneInputDataSource.prototype, "indexPath", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_indexPath")) Object.defineProperty(this, "_indexPath", { writable: true, configurable: true });
			if (!v) return;
			if (!v.UTI) v = createComponentFromDomain("NSIndexPath", "appdoo.iOS", this.context, {
				item: v.item,
				section: v.section})
			;
			this._indexPath = v;
		}, get:function () { return this._indexPath; }});
	

	Object.defineProperty(SceneInputDataSource.prototype, "originalDataSource", {
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_originalDataSource")) Object.defineProperty(this, "_originalDataSource", { writable: true, configurable: true });
			if (!v) return;
			this._originalDataSource = v;
			this.originalDataSourceID = this.originalDataSource.$id;
		}, get:function () { return this._originalDataSource; }});
	

	Object.defineProperty(SceneInputDataSource.prototype, "originalDataSourceID", {
	outlet: true, 
	enumerable: true, get:function () { return this._originalDataSourceID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_originalDataSourceID")) Object.defineProperty(this, "_originalDataSourceID", { writable: true, configurable: true }); this._originalDataSourceID = v; }});
	

	
	Object.defineProperty(SceneInputDataSource.prototype, "readableType", {
		get: function () {
			if (this.originalDataSource && this.originalDataSource.singleItemName) {
				return this.originalDataSource.singleItemName;
			}
			return LocalizedString('Context-sensitive data'); 
		}});
	

	Object.defineProperty(SceneInputDataSource.prototype, "readableValue", {
		get: function () { return this.name || this.readableType; }});
	

	Object.defineProperty(SceneInputDataSource.prototype, "providesRootData", {
		value: true});
	

	Object.defineProperty(SceneInputDataSource.prototype, "outlineIconURL", {
		get: function () {
			return this.context.pathForResource('SceneInputDataSource.png');
		}});
	
	
	Object.defineProperty(SceneInputDataSource.prototype, "inspectorProperties", {
		get: function () {}});
	
	

	Object.defineProperty(SceneInputDataSource.prototype, "canNavigateUp", {
		get: function () { return this.originalDataSource && this.indexPath && this.indexPath.item > 0; }});
	

	Object.defineProperty(SceneInputDataSource.prototype, "canNavigateDown", {
		get: function () {
			return this.originalDataSource && this.indexPath && this.originalDataSource.numberOfItemsInSection(this.indexPath.section) > this.indexPath.item+1; }});
	
	
SceneInputDataSource.prototype.navigateUp = function SceneInputDataSource_navigateUp() {
		if (!this.canNavigateUp) return;
		
		this.indexPath.item--;
		this.contents = this.originalDataSource.dataForIndexPath(this.indexPath);
		this.context.undoManager.disableRegistration();
		this.notifyObservers();
		this.context.undoManager.enableRegistration();};
	

SceneInputDataSource.prototype.navigateDown = function SceneInputDataSource_navigateDown() {
		if (!this.canNavigateDown) return;
		
		this.indexPath.item++;
		this.contents = this.originalDataSource.dataForIndexPath(this.indexPath);
		this.context.undoManager.disableRegistration();
		this.notifyObservers();
		this.context.undoManager.enableRegistration();
		};
	
	
SceneInputDataSource.prototype.encode = function SceneInputDataSource_encode() {
		var encoded = __super.prototype.encode.call(this);
		try {
			encoded.contents = JSON.parse(JSON.stringify(this.contents));
		} catch(err) { }
		return encoded;};
	
	
SceneInputDataSource.prototype.init = function SceneInputDataSource_init() {
		__super.prototype.init.call(this);
		if (!this.originalDataSource) {
			setTimeout(function () {
				this.originalDataSource = this.context.connectableObjects[this.originalDataSourceID];
				if (!this.originalDataSource) return;
				if (!this.indexPath) {
					this.indexPath = { item: 0, section: 0 };
				}
				var contents = this.originalDataSource.dataForIndexPath(this.indexPath);
				if (!contents) return;
				this.didLoad = true;
				this.notifyObservers();
				this.readableValueDidChange();
				if(_context && _context.editor) _context.editor.refreshInspector();
			}.bind(this), 1000);
		}
		else {
			if (this.contents) {
				this.didLoad = true;
				this.notifyObservers();
			}
		}
		return this;};
	

SceneInputDataSource.prototype.nameForKeyPath = function SceneInputDataSource_nameForKeyPath(keyPath) {

		if (keyPath === 'indexPath') return LocalizedString('Index Path');
		if (keyPath === 'contents') return LocalizedString('Value');

		if (this.originalDataSource &&
			this.originalDataSource.nameForKeyPath) {
			if (keyPath.indexOf('contents.') === 0) keyPath = keyPath.substr('contents.'.length);
			var name = this.originalDataSource.nameForKeyPath(keyPath);
			if (name) return name;
		}
		
		if (keyPath.indexOf('contents.') === 0) return keyPath.substr('contents.'.length);
};
	
	
SceneInputDataSource.prototype.readableNameForProperty = function SceneInputDataSource_readableNameForProperty(p) {

		if (this.originalDataSource) {
			if (this.indexPath && this.originalDataSource.nameForKeyPath)
				return this.originalDataSource.nameForKeyPath(p);
			else
				return this.originalDataSource.readableNameForProperty(p);
		}
		return __super.prototype.readableNameForProperty.call(this, p);};
	
	
	Object.defineProperty(SceneInputDataSource.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(SceneInputDataSource.prototype, "pluginIdentifier", {
		value: 'info.appdoo-mac.SceneInputDataSource'});
	
	
SceneInputDataSource.prototype.transformData = function SceneInputDataSource_transformData(data, transformer) {

		transformer.demandPlugin('info.appdoo-mac.DataSourceBase');
		transformer.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');

		var result = transformer.createObject(data);

		if (transformer.isXIBGenerator) {
			
			transformer.setStringProperty(result, 'identifier', data.$id);
			
			if (transformer.productGenerator) {
				transformer.productGenerator.addViewControllerImplementationCode(
					transformer.currentViewControllerId,
					'viewWillAppear:',
					['\t[self.'+transformer.productGenerator.outletNameForProjectID[data.$id]+' updateContents];'],
					0);
			}
		}

		return result;		};
	
	
	Object.defineProperty(SceneInputDataSource.prototype, "bindableProperties", {
		value: null});
	

	Object.defineProperty(SceneInputDataSource.prototype, "rootDataKeyPath", {
		value: ''});
	

	Object.defineProperty(SceneInputDataSource.prototype, "rootData", {
		get: function () {
			if (typeof this.contents === 'number' || typeof this.contents === 'string' || typeof this.contents === 'boolean') return { 'contents': this.contents };
			var data = {};
			
			for (var key in this.contents) {
				data['contents.'+key] = this.contents[key];
			}
			
			data.indexPath = this.indexPath;
			
			return data;
		}});
	
	
SceneInputDataSource.prototype.suggestedDataTypeForKeyPath = function SceneInputDataSource_suggestedDataTypeForKeyPath(keyPath, value) {
		if (this.originalDataSource && this.originalDataSource.suggestedDataTypeForKeyPath) {
			if (keyPath.indexOf('contents.') === 0) keyPath = keyPath.substr('contents.'.length);
			return this.originalDataSource.suggestedDataTypeForKeyPath(keyPath, value);
		}};
	
	
SceneInputDataSource.prototype.initPropertiesFromData = function SceneInputDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("indexPath")) this.indexPath = data.indexPath;
if (data.hasOwnProperty("originalDataSource")) this.originalDataSource = data.originalDataSource;
if (data.hasOwnProperty("originalDataSourceID")) this.originalDataSourceID = data.originalDataSourceID;
};

SceneInputDataSource.prototype.decodeData = function SceneInputDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("indexPath")) decoded.indexPath = this.context.decodeObjectTree(data.indexPath);
return decoded; };

SceneInputDataSource.prototype.encodeCloned = function SceneInputDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._indexPath && this._indexPath.encode) {encoded.indexPath = this.indexPath.encodeCloned();
}return encoded; };

SceneInputDataSource.prototype.expectedTypeForProperty = function SceneInputDataSource_expectedTypeForProperty(key) {
	if (key === "indexPath") return "NSIndexPath";
	if (key === "originalDataSource") return "Object";
	if (key === "originalDataSourceID") return "String";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "providesRootData") return "";
	if (key === "outlineIconURL") return "";
	if (key === "inspectorProperties") return "";
	if (key === "canNavigateUp") return "";
	if (key === "canNavigateDown") return "";
	if (key === "isPlugin") return "";
	if (key === "pluginIdentifier") return "";
	if (key === "bindableProperties") return "";
	if (key === "rootDataKeyPath") return "";
	if (key === "rootData") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SceneInputDataSource; }()));