
registerType('appdoo.iOS', (function () { function StyleDecorator() {} var __super = null;

StyleDecorator.prototype.styleBar = function StyleDecorator__styleBar(bar) {
		var systemVersion = bar.context.simulatedSystemVersion;
		if (systemVersion <= 6) {
			this.styleBarSystem6(bar);
		}
		else {
			this.styleBarSystem7(bar);
		}};
	
	
	
StyleDecorator.prototype.styleBarSystem7 = function StyleDecorator__styleBarSystem7(bar) {

		var backgroundColor,
			borderColor,
			textColor;

		var alpha;
	

		var c = determineBarTintColor(bar.barTintColor, bar.barStyle, bar.translucent);
		backgroundColor = borderColor = c;
		
		if (!bar.barTintColor && !bar.translucent) {

			if (bar.barStyle === UIBarStyleBlack) {
				alpha = bar.translucent ? 0.96 : 1.0;
				backgroundColor = 'hsla(0,0%,0%,'+alpha+')';
				borderColor = 'hsl(0,0%,10%)';
				textColor = 'white';
			}
			else {
				alpha = bar.translucent ? 0.85 : 1.0;
				backgroundColor = 'hsla(0,0%,100%,'+alpha+')';
				borderColor = 'hsl(0,0%,70%)';
				textColor = 'black';
			}
		
		}

		bar.style({
			backgroundImage: '-webkit-linear-gradient('+backgroundColor+' 0%, '+backgroundColor+' 99%, '+borderColor+' 99%, '+borderColor+' 100%)',
			color: textColor
		});
	};
	

StyleDecorator.prototype.styleBarSystem6 = function StyleDecorator__styleBarSystem6(bar) {

		var colors;
			

		if (bar.translucent) {
			colors = [
				'rgba(157,157,157,.7)',
				'rgba(124,124,124,.7)',
				'rgba(55,55,55,.7)',
				'rgba(0,0,0,.7)',
				'rgba(0,0,0,.7)',
				'rgba(29,29,29,.7)',
			];

			bar.style({
				backgroundImage: '-webkit-linear-gradient('+colors[1]+' 0%, '+colors[2]+' 49%, '+colors[3]+' 50%, '+colors[4]+' 98%, '+colors[5]+' 100%)',
			});
			
			return;
		}
		else if (bar.tintColor) {
			bar.style({ backgroundImage: this.system6GradientForColor(bar.tintColor) });
			return;
		}
		else {
			colors = [
	
				
				'rgb(235,239,245)',
	
				
				'rgb(190,204,221)',
				
				
				'rgb(136,156,184)',

				
				'rgb(90,116,152)',
	
				
				'rgb(68,97,133)'
			];
		}

		bar.style({
			backgroundImage: '-webkit-linear-gradient('+colors[0]+' 0%, '+colors[1]+' 2%, '+colors[2]+' 57%, '+colors[3]+' 98%, '+colors[4]+' 100%)',
		});
		
		if (bar.UTI === 'appdoo.iOS.UIToolbar') {
			bar.style({
				borderTop: '1px solid '+colors[3],
				height: bar.size.height-1+'px'
			});
		}
	};
	
	
StyleDecorator.prototype.system6GradientForColor = function StyleDecorator__system6GradientForColor(v) {

			var hsv = cssRgbToHsv(v),
				hue = hsv[0], saturation = hsv[1], brightness = hsv[2];
			
	
			colors = [
	
				
				rgbToCss(hsvToRgb(hue, changeSaturation(saturation, 0.18, brightness), changeLightness(brightness, 0.73))),
	
				
				rgbToCss(hsvToRgb(hue, changeSaturation(saturation, 0.33, brightness), changeLightness(brightness, 0.43))),
	
				
				rgbToCss(hsvToRgb(hue, changeSaturation(saturation, 0.66, brightness), changeLightness(brightness, 0.21))),
				
				
				rgbToCss(hsvToRgb(hue, saturation, brightness)),

				
				rgbToCss(hsvToRgb(hue, saturation, changeLightness(brightness, -0.22, true)))
			];

		return '-webkit-linear-gradient('+colors[0]+' 0%, '+colors[1]+' 2%, '+colors[2]+' 57%, '+colors[3]+' 98%, '+colors[4]+' 100%)';
	};
	




StyleDecorator.prototype.drawIconInContextWithTintColor = function StyleDecorator_drawIconInContextWithTintColor(img, ctx, tintColor) {

		var helperCanvas = document.createElement('canvas');
		helperCanvas.width = img.width;
		helperCanvas.height = img.height;
		var helperCanvasCtx = helperCanvas.getContext('2d');
		helperCanvasCtx.fillStyle = tintColor;
		helperCanvasCtx.fillRect(0,0,img.width,img.height);
		ctx.drawImage(toRgbaFromAlphaMask(helperCanvas, img), 0, 0);
};
	


	window.toRgbaFromAlphaMask = function (rgbImage, alphaMask) {
		var width = rgbImage.width, height = rgbImage.height;

		
		if (!alphaMask) return;
		if (!alphaMask.inverseAlphaMask)
		alphaMask.inverseAlphaMask = renderToCanvas(width, height, function (ctx) {
			ctx.drawImage(alphaMask, 0, 0);
			var imageData;
			try { 
				imageData = ctx.getImageData(0, 0, width, height);
			} catch (err) { return; }
			var data = imageData.data;
			for (var i = 0; i < data.length; i += 4) {
				data[i + 0] = 255;
				data[i + 1] = 255;
				data[i + 2] = 255;
				data[i + 3] = Math.max(255-data[i + 3], 0);
			}
			ctx.putImageData(imageData, 0, 0);
		});
		return toRgbaFromInverseAlphaMask(rgbImage, alphaMask.inverseAlphaMask);
	};
	window.renderToCanvas = function (width, height, renderFunction) {
		var buffer = document.createElement('canvas');
		buffer.width = width;
		buffer.height = height;
		renderFunction(buffer.getContext('2d'));
		return buffer;
	};
	window.toRgbaFromInverseAlphaMask = function (rgbImage, inverseAlphaMask) {
		var width = rgbImage.width, height = rgbImage.height;
		return renderToCanvas(width, height, function (ctx) {
			ctx.drawImage(rgbImage, 0, 0);
			ctx.globalCompositeOperation = 'destination-out';
			ctx.drawImage(inverseAlphaMask, 0, 0);
		});
	};

StyleDecorator.prototype.expectedTypeForProperty = function StyleDecorator_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return StyleDecorator; }()));