
registerType('appdoo.iOS', (function () { function UIBarButtonItem() {} var __super = setSupertypeFromDomain(UIBarButtonItem, 'BasicObject', 'Core');

	Object.defineProperty(UIBarButtonItem.prototype, "readableType", {
		get: function () {
			return LocalizedString('Bar Button');
		}});
	

	Object.defineProperty(UIBarButtonItem.prototype, "readableValue", {
		get: function () {
			if (this.itemType === 'text') return this.title;
			if (this.itemType === 'systemItem') {
				var itemData = this.systemItemData[this.systemItem];
				if (itemData) return itemData.title || itemData.name;
			};
			if (this.itemType === 'simulatedBackButton') {
				return LocalizedString('Back');
			};
			return this.readableType;
		}});
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "cocoaType", {
		value: 'UIBarButtonItem'});
	

	Object.defineProperty(UIBarButtonItem.prototype, "outlineIconURL", {
		get: function () {
			if (this.itemType === 'icon') {
				if (this.iconImage && this.iconImage.imageID)
					return this.context.pathForImageWithID(this.iconImage.imageID);
			}
			else if (this.itemType === 'systemItem') {
				if (this.systemItemData[this.systemItem] &&
					this.systemItemData[this.systemItem].imageName)
					return this.context.pathForOptimizedImage('Resources/'+this.systemItemData[this.systemItem].imageName+'.png');
			}
			return 'Resources/UIButton.png';
		}});
	

	Object.defineProperty(UIBarButtonItem.prototype, "systemItem", {
	outlet: true, 
	enumerable: true, get:function () { return this._systemItem; }, set:function (v) {if (!Object.hasOwnProperty(this, "_systemItem")) Object.defineProperty(this, "_systemItem", { writable: true, configurable: true }); this._systemItem = v; }});
	

	Object.defineProperty(UIBarButtonItem.prototype, "title", {
	outlet: true, 
	enumerable: true, get:function () { return this._title; }, set:function (v) {if (!Object.hasOwnProperty(this, "_title")) Object.defineProperty(this, "_title", { writable: true, configurable: true }); this._title = v; }});
	

	Object.defineProperty(UIBarButtonItem.prototype, "actionType", {
	outlet: true, 
	enumerable: true, get:function () { return this._actionType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_actionType")) Object.defineProperty(this, "_actionType", { writable: true, configurable: true }); this._actionType = v; }});
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "actionInfo", {
	outlet: true, 
	enumerable: true, 
		get: function () { return EditableObjectGetActionInfoProperty.call(this); }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_actionInfo")) Object.defineProperty(this, "_actionInfo", { writable: true, configurable: true }); EditableObjectSetActionInfoProperty.call(this, v); }});
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "defaultPadding", {
		get: function () {
			var isLandscape = this.context.metadata.simulatedInterfaceOrientation === 'landscape';
			if (this.itemType === 'text') {
				return isLandscape ? 17 : 8;
			}
			if (this.itemType === 'systemItem') {
				if (!this.systemItemData[this.systemItem] || !this.systemItemData[this.systemItem].imageName) return isLandscape ? 17 : 8;
				return isLandscape ? 4 : 8;
			}
			if (this.itemType === 'simulatedBackButton') {
				return isLandscape ? 0 : 0;
			}
			return isLandscape ? 15 : 15;
		}});
	
	
UIBarButtonItem.prototype.init = function UIBarButtonItem_init() {
		__super.prototype.init.call(this);
		return this;};
	

UIBarButtonItem.prototype.createForContext = function UIBarButtonItem_createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
				itemType: 'text',
				title: LocalizedString('Text Button'),
				systemItem: 'add',
				actionType: 'objectAction'
			}
		);
		};
	
	
	var defaultFontFamily = 'System',
		defaultFontName = '_DEFAULT_',
		defaultPointSize = 17;

UIBarButtonItem.prototype.prepareForEditor = function UIBarButtonItem_prepareForEditor(editor) {
		if (this.font === undefined) this.font = createComponentFromDomain("UIFont", "appdoo.iOS", this.context, {
			fontFamily: defaultFontFamily,
			fontName: defaultFontName,
			pointSize: defaultPointSize})
		;
		this.observeObject(this.font);
		this.view.prepareForEditor(editor);};
	
	
UIBarButtonItem.prototype.unprepareForEditor = function UIBarButtonItem_unprepareForEditor(editor) {
		this.unobserveObject(this.font);};
	

	Object.defineProperty(UIBarButtonItem.prototype, "e_actionObjectID", {
		get: function ( ) { return this.actionInfo.objectID; }, 
		set: function (v) { this.actionInfo.objectID = v; _context.editor.refreshInspector(); }});
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "itemType", {
	outlet: true, 
	enumerable: true, get:function () { return this._itemType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_itemType")) Object.defineProperty(this, "_itemType", { writable: true, configurable: true }); this._itemType = v; }});
	

UIBarButtonItem.prototype.outlineIconURLDidChange = function UIBarButtonItem__outlineIconURLDidChange() {
		this.context.broadcastValueChangeForKeyPathInObject('outlineIconURL', this, this);};
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "e_itemType", {
		get: function ( ) { return this.itemType; }, 
		set: function (v) { this.itemType = v; this.updateView(); this.readableValueDidChange(); this.outlineIconURLDidChange(); }});
	

	Object.defineProperty(UIBarButtonItem.prototype, "e_systemItem", {
		get: function ( ) { return this.systemItem; }, 
		set: function (v) { this.systemItem = v; this.updateView(); this.readableValueDidChange(); this.outlineIconURLDidChange(); }});
	

	Object.defineProperty(UIBarButtonItem.prototype, "e_title", {
		get: function ( ) { return this.title; }, 
		set: function (v) { this.title = v; this.updateView(); this.readableValueDidChange(); _context.editor.refreshInspector(); }});
	
	
UIBarButtonItem.prototype.generateSystemItemOptions = function UIBarButtonItem__generateSystemItemOptions() {


		var options = [];
		
		for (var key in this.systemItemData) {
			if (key === 'back') continue;
			var itemData = this.systemItemData[key];
			
			var icon = null;
			if (itemData.imageName) {
				icon = this.context.pathForOptimizedImage('Resources/'+itemData.imageName+'.png');
			}
			
			options.push([key, itemData.title||itemData.name, 0,0,icon]);
		}
		
		return options;
};
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "iconImage", {
	outlet: true, 
	enumerable: true, get:function () { return this._iconImage; }, set:function (v) {if (!Object.hasOwnProperty(this, "_iconImage")) Object.defineProperty(this, "_iconImage", { writable: true, configurable: true }); this._iconImage = v; }});
	

	Object.defineProperty(UIBarButtonItem.prototype, "e_iconImage", {
		set: function (v) {
			this.iconImage = v;
			this.updateView();
		}, 
		get: function () { return this.iconImage; }});
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "inspectorProperties", {
		get: function () {

			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'view',
					items: [
					
						{ name: LocalizedString('Type'), type:'select', keyPath: 'e_itemType', options:[
							['text',LocalizedString('Text'), [
								{ name: LocalizedString('Text'), keyPath: 'e_title', marginTop:-4 },
							]],
							['icon',LocalizedString('Icon'), [ { name: '', keyPath: 'e_iconImage', type: 'image', size: 48, fileTypesForImport:['image/png'], incompatibilityWarning: LocalizedString1('Icons at this location should be saved in PNG format with transparency and a size of about %1.', '44x44'), wantsRetinaImage: true } ]],
							['systemItem',LocalizedString('System Item'), [
								{ keyPath: 'e_systemItem', labelOnTop: true, name: '', type: 'select', numberOfVisibleItems: 4.5, options: this.generateSystemItemOptions(), showsIcons: true, squareIcons: true
								}, { type: 'space' }
							]],
							['simulatedBackButton', LocalizedString('Simulated Back Button')]
						]},
					
						{ type: 'space' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Action'),
					id: this.constructor.name+'Action',
					condition: function () { return this.itemType != 'simulatedBackButton'; }.bind(this),
					items: [
						{ type: 'action', keyPath: 'actionInfo', currentActionType: this.actionType, currentActionObjectID: this.e_actionObjectID }
					]
				},
				{
					type: 'group',
					title: LocalizedString('Font'),
					id: this.constructor.name+'Font',
					items: [
						{ type: 'boolean', name: LocalizedString('Change Default Font'), positionLeft: true, keyPath: 'usesCustomFont' },
						{ type: 'space', hidden: !this.usesCustomFont },
						{ type: 'font', hidden: !this.usesCustomFont },
						{ type: 'space', hidden: !this.usesCustomFont },
						{ type: 'fontSize', keyPath: 'fontSize', hidden: !this.usesCustomFont },
					]
				},
			];
		}});
	

UIBarButtonItem.prototype.selectForEditor = function UIBarButtonItem_selectForEditor(editor) {
		this.view.style({ backgroundColor: 'hsla(209,70%,60%,.15)', borderRadius:'10px' });};
	

UIBarButtonItem.prototype.unselectForEditor = function UIBarButtonItem_unselectForEditor(editor) {
		this.view.style({ backgroundColor: '', borderRadius:'' });};
	
	
UIBarButtonItem.prototype.styleDefault = function UIBarButtonItem_styleDefault() {};
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "view", {
	synthesized: true, 
		get: function () {
			if (!this._view) this.createView();
			return this._view;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_view")) Object.defineProperty(this, "_view", { writable: true, configurable: true }); this._view = v; }});
	
	
UIBarButtonItem.prototype.createView = function UIBarButtonItem__createView() {
		if (this._view) return;
		this.view = createComponentFromDomain("UIBarButtonItemView", "appdoo.iOS", this.context, {
			barButtonItem: this})
		;};
	
	
UIBarButtonItem.prototype.updateView = function UIBarButtonItem__updateView() {
		this.view.updateContents();
		_context.editor.updateFocusRing(this.view);};
	

UIBarButtonItem.prototype.action = function UIBarButtonItem_action(noBezel) {
		if (this.itemType === 'simulatedBackButton') {
			_context.editor.goBack();
		}
		_context.editor.simulateAction(this.actionType, this.actionInfo, noBezel);};
	
	

	var UIBarButtonItemStylePlain = 0,
   UIBarButtonItemStyleBordered = 1,
   UIBarButtonItemStyleDone = 2;

	var UIBarButtonSystemItemDone = 0,
   UIBarButtonSystemItemCancel = 1,
   UIBarButtonSystemItemEdit = 2,
   UIBarButtonSystemItemSave = 3,
   UIBarButtonSystemItemAdd = 4,
   UIBarButtonSystemItemFlexibleSpace = 5,
   UIBarButtonSystemItemFixedSpace = 6,
   UIBarButtonSystemItemCompose = 7,
   UIBarButtonSystemItemReply = 8,
   UIBarButtonSystemItemAction = 9,
   UIBarButtonSystemItemOrganize = 10,
   UIBarButtonSystemItemBookmarks = 11,
   UIBarButtonSystemItemSearch = 12,
   UIBarButtonSystemItemRefresh = 13,
   UIBarButtonSystemItemStop = 14,
   UIBarButtonSystemItemCamera = 15,
   UIBarButtonSystemItemTrash = 16,
   UIBarButtonSystemItemPlay = 17,
   UIBarButtonSystemItemPause = 18,
   UIBarButtonSystemItemRewind = 19,
   UIBarButtonSystemItemFastForward = 20,
   UIBarButtonSystemItemUndo = 21,        
   UIBarButtonSystemItemRedo = 22,        
   UIBarButtonSystemItemPageCurl = 23;
   
	
	Object.defineProperty(UIBarButtonItem.prototype, "systemItemData", {
		get: function () {
		
			return {
			
			'back': { name: LocalizedString('Back'), imageName: 'UIBackButton', imageNameLandscape: '', width: 33, value: -1 },
			
			'add': { name: LocalizedString('Add'), imageName: 'UIButtonBarNew', imageNameLandscape: 'UIButtonBarNewLandscape', width: 33, value: UIBarButtonSystemItemAdd },
			'edit': { title: LocalizedString('Edit'), value: UIBarButtonSystemItemEdit },
			'done': { title: LocalizedString('Done'), value: UIBarButtonSystemItemDone, isBold: true },
			'cancel': { title: LocalizedString('Cancel'), value: UIBarButtonSystemItemCancel },
			'save': { title: LocalizedString('Save'), value: UIBarButtonSystemItemSave, isBold: true },
			'undo': { title: LocalizedString('Undo'), value: UIBarButtonSystemItemUndo },
			'redo': { title: LocalizedString('Redo'), value: UIBarButtonSystemItemRedo },
			
			'compose': { name: LocalizedString('Compose'), imageName: 'UIButtonBarCompose', imageNameLandscape: 'UIButtonBarComposeLandscape', width: 33, value: UIBarButtonSystemItemCompose },
			'reply': { name: LocalizedString('Reply'), imageName: 'UIButtonBarReply', imageNameLandscape: 'UIButtonBarReplyLandscape', width: 45, value: UIBarButtonSystemItemReply },
			'action': { name: LocalizedString('Action'), imageName: 'UIButtonBarAction', imageNameLandscape: 'UIButtonBarActionSmall', width: 38, offsetY: -0, value: UIBarButtonSystemItemAction },
			'organize': { name: LocalizedString('Organize'), imageName: 'UIButtonBarOrganize', imageNameLandscape: 'UIButtonBarOrganizeLandscape', width: 38, value: UIBarButtonSystemItemOrganize },
			'trash': { name: LocalizedString('Trash'), imageName: 'UIButtonBarTrash', imageNameLandscape: 'UIButtonBarTrashLandscape', width: 36, offsetY: 0, value: UIBarButtonSystemItemTrash },
			
			'bookmarks': { name: LocalizedString('Bookmarks'), imageName: 'UIButtonBarBookmarks', imageNameLandscape: 'UIButtonBarBookmarksLandscape', width: 46, value: UIBarButtonSystemItemBookmarks },
			'search': { name: LocalizedString('Search'), imageName: 'UIButtonBarSearch', imageNameLandscape: 'UIButtonBarSearchLandscape', width: 40, value: UIBarButtonSystemItemSearch },
			'refresh': { name: LocalizedString('Refresh'), imageName: 'UIButtonBarRefresh', imageNameLandscape: 'UIButtonBarRefreshLandscape', width: 34, offsetY: 1, value: UIBarButtonSystemItemRefresh },
			'stop': { name: LocalizedString('stop'), imageName: 'UIButtonBarStop', imageNameLandscape: 'UIButtonBarStopLandscape', width: 32, value: UIBarButtonSystemItemStop }, 
			
			'camera': { name: LocalizedString('Camera'), imageName: 'UIButtonBarCamera', imageNameLandscape: 'UIButtonBarCameraSmall', width: 40, offsetY: 0, value: UIBarButtonSystemItemCamera },
			
			'play': { name: LocalizedString('play'), imageName: 'UIButtonBarPlay', width: 32, value: UIBarButtonSystemItemPlay }, 
			'pause': { name: LocalizedString('pause'), imageName: 'UIButtonBarPause', width: 33, value: UIBarButtonSystemItemPause }, 
			'rewind': { name: LocalizedString('rewind'), imageName: 'UIButtonBarRewind', width: 33, value: UIBarButtonSystemItemRewind }, 
			'fastForward': { name: LocalizedString('fast-forward'), imageName: 'UIButtonBarFastForward', width: 33, value: UIBarButtonSystemItemFastForward }, 
			};
		}
});
	

UIBarButtonItem.prototype.transformData = function UIBarButtonItem_transformData(data, transformer) {
		if (data.itemType === 'simulatedBackButton') return;
	
		if (!transformer.isXIBGenerator) {
			var result = {
				$type: this.constructor.name,
				$domain: 'com.apple',
				$id: data.$id,
				$initialMethodCalls: []
			};
	
			if (data.itemType === 'text')
				result.$initializer = {
				  name: 'initWithTitle:style:target:action:',
				  arguments: [
					data.title||'',UIBarButtonItemStylePlain,
					transformer.generateActionObject(null, data.actionInfo),
					{ $type: 'SEL', name: 'action:' }
				  ]
				};
			else if (data.itemType === 'icon')
				result.$initializer = {
				  name: 'initWithImage:style:target:action:',
				  arguments: [
					transformer.transformReferencedImage(data.iconImage),
					UIBarButtonItemStylePlain,
					transformer.generateActionObject(null, data.actionInfo),
					{ $type: 'SEL', name: 'action:' }
				  ]
				};
			else if (data.itemType === 'systemItem' && this.systemItemData[data.systemItem])
				result.$initializer = {
				  name: 'initWithBarButtonSystemItem:target:action:',
				  arguments: [
					this.systemItemData[data.systemItem].value,
					transformer.generateActionObject(null, data.actionInfo),
					{ $type: 'SEL', name: 'action:' }
				  ]
				};
	
			return result;
		}
		else {
			var result = {
				id: transformer.createStoryboardID(),
				tag: data.tag
			};
	
			if (data.itemType === 'text')
				result.title = data.title;
			else if (data.itemType === 'systemItem')
				result.systemItem = data.systemItem;
			else if (data.itemType === 'icon') {
				
				if (data.iconImage) {
					if (data.iconImage.fileReferenceID) {
						var ref = _context.projectContext.fileReferenceWithID(data.iconImage.fileReferenceID);
						if (ref) {
							result.image = ref.name;
						}
					}
					else if (data.iconImage.imageID) {
						result.image = data.iconImage.imageID;
						transformer.registerImage(data.iconImage.imageID, 'center');
					}
				}
			}
	
			transformer.transformAndAddActionToObject(null, data.actionInfo, result, data.$id);
			
			return result;	
		}
		};
	
	   	

UIBarButtonItem.prototype.editDefault = function UIBarButtonItem_editDefault(editor) {
		if (this.view)
			return this.view.editDefault(editor);};
	

UIBarButtonItem.prototype.fileReferenceDidUpdate = function UIBarButtonItem_fileReferenceDidUpdate(ref) {
		if (this.iconImage && this.iconImage.fileReferenceID === ref.$id) {
			this.iconImage.imageID = ref.resourceID;
			this.updateView();
			this.outlineIconURLDidChange();
		}};
	


	Object.defineProperty(UIBarButtonItem.prototype, "bindableProperties", {
		get: function () {
			var result = [];
			result.unshift(
				['enabled', this.readableNameForProperty('enabled')]
			);
			return result;
		}});
	

UIBarButtonItem.prototype.readableNameForProperty = function UIBarButtonItem__readableNameForProperty(propertyName) {
		switch (propertyName) {
			case 'enabled': return LocalizedString('Enabled');
		}
		return __super.prototype.readableNameForProperty.call(this, propertyName);};
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "enabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._enabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_enabled")) Object.defineProperty(this, "_enabled", { writable: true, configurable: true }); this._enabled = v; }});
	
	

	Object.defineProperty(UIBarButtonItem.prototype, "font", {
		get: function () {
			return this.context.project ? this.context.project.barButtonItemFont : null;
		}, 
		set: function (v) {
			this.context.project.barButtonItemFont = v;
		}});
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "usesCustomFont", {
		get: function () {
			return this.context && this.context.project && this.context.project.usesCustomBarButtonItemFont;
		}, 
		set: function (v) {
			this.context.project.usesCustomBarButtonItemFont = v;
			this.view.updateContents();
			_context.editor.refreshInspector();
		}});
	
	
	Object.defineProperty(UIBarButtonItem.prototype, "fontName", {
		set: function (v) { this.font.fontName = v; }, 
		get: function ( ) { return this.font.fontName; }});
	
	Object.defineProperty(UIBarButtonItem.prototype, "fontFamily", {
		set: function (v) { this.font.fontFamily = v; }, 
		get: function ( ) { return this.font.fontFamily; }});
	
	Object.defineProperty(UIBarButtonItem.prototype, "fontSize", {
		set: function (v) { this.font.pointSize = v; }, 
		get: function ( ) { return this.font.pointSize; }});
	

UIBarButtonItem.prototype.observedObjectValueDidChangeForKeyPath = function UIBarButtonItem_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {
		if (obj === this.font) {
			this.view.updateContents();
		}};
	

UIBarButtonItem.prototype.initPropertiesFromData = function UIBarButtonItem_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("systemItem")) this.systemItem = data.systemItem;
if (data.hasOwnProperty("title")) this.title = data.title;
if (data.hasOwnProperty("actionType")) this.actionType = data.actionType;
if (data.hasOwnProperty("actionInfo")) this.actionInfo = data.actionInfo;
if (data.hasOwnProperty("itemType")) this.itemType = data.itemType;
if (data.hasOwnProperty("iconImage")) this.iconImage = data.iconImage;
if (data.hasOwnProperty("enabled")) this.enabled = data.enabled;
};

UIBarButtonItem.prototype.decodeData = function UIBarButtonItem_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("actionInfo")) decoded.actionInfo = this.context.decodeObjectTree(data.actionInfo);
if (data.hasOwnProperty("iconImage")) decoded.iconImage = this.context.decodeObjectTree(data.iconImage);
return decoded; };

UIBarButtonItem.prototype.encode = function UIBarButtonItem_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._actionInfo && this._actionInfo.encode) {encoded.actionInfo = this.actionInfo.encode();
}if (this._iconImage && this._iconImage.encode) {encoded.iconImage = this.iconImage.encode();
}return encoded; };

UIBarButtonItem.prototype.encodeCloned = function UIBarButtonItem_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._actionInfo && this._actionInfo.encode) {encoded.actionInfo = this.actionInfo.encodeCloned();
}if (this._iconImage && this._iconImage.encode) {encoded.iconImage = this.iconImage.encodeCloned();
}return encoded; };

UIBarButtonItem.prototype.expectedTypeForProperty = function UIBarButtonItem_expectedTypeForProperty(key) {
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "cocoaType") return "";
	if (key === "outlineIconURL") return "";
	if (key === "systemItem") return "String";
	if (key === "title") return "String";
	if (key === "actionType") return "";
	if (key === "actionInfo") return "ActionInfo";
	if (key === "defaultPadding") return "";
	if (key === "e_actionObjectID") return "";
	if (key === "itemType") return "String";
	if (key === "e_itemType") return "";
	if (key === "e_systemItem") return "";
	if (key === "e_title") return "";
	if (key === "iconImage") return "ImageReference";
	if (key === "e_iconImage") return "ImageReference";
	if (key === "inspectorProperties") return "";
	if (key === "view") return "";
	if (key === "systemItemData") return "";
	if (key === "bindableProperties") return "";
	if (key === "enabled") return "Boolean";
	if (key === "font") return "UIFont";
	if (key === "usesCustomFont") return "Boolean";
	if (key === "fontName") return "String";
	if (key === "fontFamily") return "String";
	if (key === "fontSize") return "Number";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIBarButtonItem; }()));
registerType('appdoo.iOS', (function () { function UIBarButtonItemView() {} var __super = setSupertypeFromDomain(UIBarButtonItemView, 'UIView', 'appdoo.iOS');

UIBarButtonItemView.prototype.encode = function UIBarButtonItemView_encode() {
		var data = __super.prototype.encode.call(this);
		data.barButtonItem = this.barButtonItem.encode();
		return data;};
	

UIBarButtonItemView.prototype.init = function UIBarButtonItemView_init() {
	
		__super.prototype.init.call(this);

		this.DOMNode.className = 'canClickInActionMode';

		var isSystem7 = this.context.simulatedSystemVersion >= 7;
		this.size.height = isSystem7 ? 44 : 31;
		
		this.updateContents();
		
		var isActionClick = false;
		this.DOMNode.addEventListener("mousedown", function (e) {
			if (_context.editor.isActionClick(e)) {
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				this.barButtonItem.action(true);
				isActionClick = true;
				return;
			}
			isActionClick = false;
			return;
			this.isActive = true;
			this.drawBackground();
			e.preventDefault();
			e.stopPropagation();
			window.addEventListener('mouseup', function onMouseUp(e) {
				this.isActive = false;
				this.drawBackground();
				e.preventDefault();
				e.stopPropagation();
				window.removeEventListener('mouseup', onMouseUp);
			}.bind(this));
		}.bind(this));

		this.DOMNode.addEventListener('click', function onMouseUp(e) {
			if (isActionClick) return;
			_context.editor.selectSingleObject(this.barButtonItem);
			e.preventDefault();
			e.stopPropagation();
		}.bind(this));
		
		
		return this;};
	
	
	Object.defineProperty(UIBarButtonItemView.prototype, "barButtonItem", {
	outlet: true, get:function () { return this._barButtonItem; }, set:function (v) {if (!Object.hasOwnProperty(this, "_barButtonItem")) Object.defineProperty(this, "_barButtonItem", { writable: true, configurable: true }); this._barButtonItem = v; }});
	
	
	
UIBarButtonItemView.prototype.styleDefaultSystem6 = function UIBarButtonItemView_styleDefaultSystem6() {

		this.button.fontName = '_DEFAULT_BOLD_';
		this.button.fontSize = 12;
		this.button.CSSTextColor = '#fff';

		this.button.label.style({
			textShadow: '0 -1px 0 rgba(0,0,0,.4)',
			color: '#fff'
		});
		
		this.updateImage();
		
		if (this._backgroundCanvas) {
			this._backgroundCanvas.style.display = '';
		} else {
			this.drawBackground();
		}
	};
	

UIBarButtonItemView.prototype.styleDefaultSystem7 = function UIBarButtonItemView_styleDefaultSystem7() {
		if (!this.button) return;
		
		var font = (this.barButtonItem && this.barButtonItem.usesCustomFont && this.barButtonItem.font) ? this.barButtonItem.font : null,
			fontSize = font ? font.pointSize : 17,
			fontFamily = font ? font.fontName : '_DEFAULT_';

		this.button.label.style({
			textShadow: '',
			color: this.superview?this.superview.e_tintColor:this.context.defaultOrSystemTintColor,
			fontSize: fontSize+'px',
			fontFamily: realIOSFont(fontFamily)
		});

		if (this._backgroundCanvas) {
			this._backgroundCanvas.style.display = 'none';
		}
	};
	
	
	
	
UIBarButtonItemView.prototype.superviewDidChangeTintColor = function UIBarButtonItemView_superviewDidChangeTintColor() {
		this.updateImage();
		this.styleDefault();};
	

	Object.defineProperty(UIBarButtonItemView.prototype, "encodesSubviews", {
		value: false});
	
	
UIBarButtonItemView.prototype.updateContents = function UIBarButtonItemView_updateContents() {
	
		if (this.button) this.button.removeFromSuperview();

		this.button = createComponentFromDomain("UIButton", "appdoo.iOS", this.context, {
			size: { width: (this.size.width||30), height: this.size.height-1 },
			position: { left: 0, top: 1 },
			autoresizingMask: 18,
			buttonStyle: 'custom',})
		;
		this.button.fontName = '_DEFAULT_';
		this.button.fontSize = 17;
		this.addSubview(this.button);
		
		if (!this.barButtonItem) return;

		if (this.barButtonItem.itemType === 'text') {
			this.setContentsByTitle(this.barButtonItem.title);
		}
		else if (this.barButtonItem.itemType === 'icon') {
			this.setContentsByIcon(this.barButtonItem.iconImage);
		}
		else if (this.barButtonItem.itemType === 'systemItem') {
			this.setContentsBySystemItem(this.barButtonItem.systemItem);
		}
		else if (this.barButtonItem.itemType === 'simulatedBackButton') {
			this.setContentsBySystemItem('back');
		}
		
		this.styleDefault();

		if (this.superview)
			this.superview.layoutSubviews();
	};
	
	
UIBarButtonItemView.prototype.setContentsByTitle = function UIBarButtonItemView__setContentsByTitle(v, bold) {

		this.removeIcon();
		

		if (v) {
			var fontFamily = this.barButtonItem.usesCustomFont ? realIOSFont(this.barButtonItem.font.fontName) : (!bold?'HelveticaNeue':'HelveticaNeue-Medium'),
				fontSize = this.barButtonItem.usesCustomFont ? this.barButtonItem.font.pointSize+'px' : '';
			
			this.button.text = v;
			this.button.label.style({ fontFamily: fontFamily, fontSize: fontSize });
			this.button.label.fontSize = this.barButtonItem.usesCustomFont ? this.barButtonItem.font.pointSize : 17;
			this.size.width = this.button.label.widthToFit;
			this.button.size.width = this.size.width;
			this.button.label.size.width = this.size.width;
		}
		else {
			this.button.text = '';
			this.size.width = 20;
		}
		this.drawBackground();
			};
	

UIBarButtonItemView.prototype.setContentsByIcon = function UIBarButtonItemView__setContentsByIcon(imageRef) {

		this.removeIcon();
		
		if (!imageRef || !imageRef.imageID) return;
		
		var imageSrc = this.context.pathForImageWithID(imageRef.imageID);
			
		this.context.whenImageIsReady(imageSrc, function (img) {
			this.size.width = img.width/2;
			if (this.superview) this.superview.layoutSubviews();
			_context.editor.updateFocusRing(this);
			this.drawIconWithSrc(imageSrc, 0, 0);
		}.bind(this));
};
	
	
	Object.defineProperty(UIBarButtonItemView.prototype, "systemItemData", {
		get: function () {
			return getPrototype('appdoo.iOS.UIBarButtonItem').systemItemData;
		}});
	


	Object.defineProperty(UIBarButtonItemView.prototype, "currentSystemItem", {
	synthesized: true, get:function () { return this._currentSystemItem; }, set:function (v) {if (!Object.hasOwnProperty(this, "_currentSystemItem")) Object.defineProperty(this, "_currentSystemItem", { writable: true, configurable: true }); this._currentSystemItem = v; }});
	

UIBarButtonItemView.prototype.setContentsBySystemItem = function UIBarButtonItemView__setContentsBySystemItem(v) {

		if (this.effectedImageCanvas && this.currentSystemItem === v)
			return;

		this.removeIcon();

		if (!this.systemItemData[v]) {
			return;
		}
		
		
		if (this.systemItemData[v].imageName) {
			if (this.title) this.title = '';
			this.size.width = this.systemItemData[v].width;
			this.updateImage();
		}
		else {
			this.setContentsByTitle(this.systemItemData[v].title, this.systemItemData[v].isBold);
			if (v === 'done') {
				this.button.fontName = '_DEFAULT_BOLD_';
			}
		}
};
	
	
UIBarButtonItemView.prototype.updateImage = function UIBarButtonItemView__updateImage() {

		if (this.barButtonItem.itemType === 'systemItem')
			this.updateImageForSystemItem(this.barButtonItem.systemItem);
		else if (this.barButtonItem.itemType === 'icon')
			this.updateImageForIcon(this.barButtonItem.iconImage);
		else if (this.barButtonItem.itemType === 'simulatedBackButton')
			this.updateImageForSystemItem('back');
	};
	

	
UIBarButtonItemView.prototype.updateImageForSystemItem = function UIBarButtonItemView__updateImageForSystemItem(systemItem) {
	
		var siData = this.systemItemData[systemItem];
		if (siData && siData.imageName) {
			if (!window._context) return;
			
			var imageName = siData.imageName;

			if (!_context.editor.editedScene) return;
			if (_context.editor.editedScene.e_simulatedInterfaceOrientation === 'landscape' && this.context.simulatedDeviceIsIPhone) {
				if (siData.imageNameLandscape)
					imageName = siData.imageNameLandscape;
			}

			this.drawIconWithSrc(
				this.context.pathForOptimizedImage('Resources/'+imageName+'.png'),
				siData.offsetX,
				siData.offsetY);
					
		}
};
	
	
UIBarButtonItemView.prototype.updateImageForIcon = function UIBarButtonItemView__updateImageForIcon(iconImage) {

		if (iconImage && iconImage.imageID) {
		
			this.drawIconWithSrc(
				this.context.pathForImageWithID(iconImage.imageID),
				0,
				0);
					
		}
};
	

	
	Object.defineProperty(UIBarButtonItemView.prototype, "buttonStyle", {
	synthesized: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_buttonStyle")) Object.defineProperty(this, "_buttonStyle", { writable: true, configurable: true });
			this._buttonStyle = v;
		}, get:function () { return this._buttonStyle; }});
	
	
	Object.defineProperty(UIBarButtonItemView.prototype, "imageView", {
	synthesized: true, 
		get: function () {
			if (this._imageView) return this._imageView;
			this.size.width = 33;
			this.imageView = createComponentFromDomain('ImageView', 'Core.UI', this.context, { imageSrc: 'Resources/UIBarItemAdd.png', size: {width:13, height:13}, position: {top: 8, left:Math.round(this.size.width/2)-7} });
			this.addSubview(this._imageView);
			return this._imageView;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_imageView")) Object.defineProperty(this, "_imageView", { writable: true, configurable: true }); this._imageView = v; }});
	
	
	Object.defineProperty(UIBarButtonItemView.prototype, "effectedImageCanvas", {
	synthesized: true, get:function () { return this._effectedImageCanvas; }, set:function (v) {if (!Object.hasOwnProperty(this, "_effectedImageCanvas")) Object.defineProperty(this, "_effectedImageCanvas", { writable: true, configurable: true }); this._effectedImageCanvas = v; }});
	
	
UIBarButtonItemView.prototype.removeIcon = function UIBarButtonItemView__removeIcon() {
		if (this.effectedImageCanvas) {
			this.effectedImageCanvas.parentNode.removeChild(this.effectedImageCanvas);
			delete this._effectedImageCanvas;
		}};
	
	
	
UIBarButtonItemView.prototype.drawIconWithSrc = function UIBarButtonItemView__drawIconWithSrc(imageSrc, offsetX, offsetY) {
	
		this.removeIcon();

		if (imageSrc)
		this.context.whenImageIsReady(imageSrc, function (img) {
			var isSystem7 = this.context.simulatedSystemVersion >= 7;
			var scale = this.context.highResolutionEnabled ? 2 : 1;
			var canvas = document.createElement('canvas');
			var width = Math.ceil(img.width/scale+2);
			var height = Math.ceil(img.height/scale+2);
			canvas.width = width*scale;
			canvas.height = height*scale;
			canvas.style.width = width+'px';
			canvas.style.height = height+'px';
			canvas.style.position = 'absolute';
			canvas.style.left = Math.ceil(this.size.width/2-width/2)+(offsetX||0)+'px';
			canvas.style.top = Math.round(this.size.height/2-height/2)+(offsetY||0)+'px';

			var ctx = canvas.getContext('2d');
			ctx.save();
			
			if (!isSystem7) {
				ctx.scale(scale, scale);
				ctx.translate(1,1);
				ctx.shadowOffsetY = -scale;
				ctx.shadowColor = 'rgba(0,0,0,.5)';
				ctx.drawImage(img, 0, 0, img.width/2, img.height/2);
			} else {
				ctx.translate(1,1);
				getType('appdoo.iOS.StyleDecorator').prototype.drawIconInContextWithTintColor(img, ctx,
						this.superview&&this.superview.tintColor||this.context.defaultOrSystemTintColor);
			}

			ctx.restore();

			this.DOMNode.appendChild(canvas);

			if (this.effectedImageCanvas)
				this.effectedImageCanvas.parentNode.removeChild(this.effectedImageCanvas);
			this.effectedImageCanvas = canvas;

		}.bind(this));
	};
	
	


	

UIBarButtonItemView.prototype.drawBackground = function UIBarButtonItemView__drawBackground() {
	
		if (this.context.simulatedSystemVersion >= 7) return;
	
		if (!this.superview) return;
	
		this.context.whenImageIsReady('Resources/UIBarButtonItem@2x.png', function (staticBarButtonImages) {


			var width = this.size.width+2;
			if (width < 20) width = 20;
			var height = 31;
			var scale = this.context.highResolutionEnabled ? 2 : 1;
			
			if (!this._backgroundCanvas) {
				var canvas = document.createElement('canvas');

				canvas.width = width*scale;
				canvas.height = height*scale;
				canvas.style.position = 'absolute';
				canvas.style.left = '-1px';
				canvas.style.top = '1px';
				canvas.style.width = width+'px';
				canvas.style.height = height+'px';
				this.DOMNode.insertBefore(canvas, this.DOMNode.firstChild);
				Object.defineProperty(this, "_backgroundCanvas", {
					enumerable: false, 
					value: canvas});
				
			}
				
			else {
				this._backgroundCanvas.width = (width)*scale;
			}
			
			var ctx = this._backgroundCanvas.getContext('2d');

			var maxY = this.smallSize ? 23 : 29,
				leftX = 1,
				maxX = width-1;
			
			ctx.save();
			ctx.scale(scale, scale);
		
			ctx.beginPath();
    		ctx.moveTo(leftX+10, 0);
    		ctx.arcTo(maxX, 0, maxX, 10, 5);
    		ctx.arcTo(maxX, maxY, maxX-10, maxY, 5);
    		ctx.arcTo(leftX, maxY, leftX, maxY-10, 5);
    		ctx.arcTo(leftX, 0, leftX+10, 0, 5);
			
			if (this.superview.translucent) {
				var lineargradient = ctx.createLinearGradient(0,0,0,29);
				lineargradient.addColorStop(0,'hsl(0,0%,60%)');
				lineargradient.addColorStop(0.49,'hsl(0,0%,22%)');
				lineargradient.addColorStop(0.5,'hsl(0,0%,0%)');
				lineargradient.addColorStop(1,'hsl(0,0%,0%)');
				ctx.fillStyle = lineargradient;
			} else {
				
				var tintColor,
					color1, color2;
					
				if (!this.superview.tintColor)
					tintColor = 'rgb(126,149,181)';
				else tintColor = this.superview.tintColor
				
				var hsv = cssRgbToHsv(tintColor),
					hue = hsv[0], saturation = hsv[1], brightness = hsv[2];
					
				if (this.superview.v_hasCustomStyle) {
					if (hue >= 0.2) hue += 0.02;
					else hue -= 0.02;
				}
				hue = Math.max(hue, 0);
				hue = Math.min(hue, 1);
		
				color1 = rgbToCss(hsvToRgb(hue, changeSaturation(saturation, this.superview.hasDefaultColor ? 0.5 : 0.2, brightness), changeLightness(brightness, 0.43)));
				color2 = rgbToCss(hsvToRgb(hue, changeSaturation(saturation, this.superview.hasDefaultColor ? 1.8 : 1.5, brightness), changeLightness(brightness, -0.35, false)));
		
				var lineargradient = ctx.createLinearGradient(0,0,0,29);
				lineargradient.addColorStop(0,color1);
				lineargradient.addColorStop(1,color2);
				ctx.fillStyle = lineargradient;
			}
		
			ctx.fill();

			var offsetY = this.isActive ? 30 : 0;
			
			if (this.isBackButton) {
				
				ctx.drawImage(staticBarButtonImages, 9,offsetY,	14,30,	0,0,	14,30);
				
				ctx.drawImage(staticBarButtonImages, 4,offsetY,	1,30,	14,0,	width-18,30);
				
				ctx.drawImage(staticBarButtonImages, 5,offsetY,	4,30,	width-4,0,	4,30);
			}
			else {
				
				ctx.drawImage(staticBarButtonImages, 0,0,	20,62,	0,0,	10,31);
				
				ctx.drawImage(staticBarButtonImages, 20,0,	2,62,	10,0,	width-20,31);
				
				ctx.drawImage(staticBarButtonImages, 28,0,	20,62,	width-10,0,	10,31);
			}
			
			ctx.restore();

		}.bind(this));

		};
	


	

	Object.defineProperty(UIBarButtonItemView.prototype, "button", {
	synthesized: true, get:function () { return this._button; }, set:function (v) {if (!Object.hasOwnProperty(this, "_button")) Object.defineProperty(this, "_button", { writable: true, configurable: true }); this._button = v; }});
	

UIBarButtonItemView.prototype.prepareForEditor = function UIBarButtonItemView_prepareForEditor(editor) {
		this.DOMNode.ondblclick = function (e) {
			if (editor.isActionClick(e)) return;
			if (this.barButtonItem.itemType !== 'text') {
				return;
			}
			if (editor.editedSubview === editor.editedView) {
				this.editDefault(editor);
			}
		}.bind(this);
		
		this.DOMNode.draggable = true;
		this.DOMNode.onmousedown = function (e) {
			if (editor.isActionClick(e)) return;
			e.stopPropagation();
		};
		this.DOMNode.ondragstart = function (e) {
		
			var dragItem = createComponentFromDomain("DragItem", "Core.UI", this.context, {
				sourceView: this,
				dragContext: _context.projectContext,
				onFinish: function () {
				}.bind(this)})
			;

			var _e = dragItem.dragWithEvent(e);
			_e.dataTransfer.setData(_context.promisedRealObjectsDataType, this.barButtonItem.identify());
			_e.dataTransfer.setData('promised-objects', this.barButtonItem.node.identify());
			

		}.bind(this);};
	
	
UIBarButtonItemView.prototype.editDefault = function UIBarButtonItemView_editDefault(editor) {
		return this.button.label.editDefault(editor, this.barButtonItem.dataController, 'e_title');};
	
	
UIBarButtonItemView.prototype.layoutSubviews = function UIBarButtonItemView_layoutSubviews() {
		__super.prototype.layoutSubviews.call(this);
		this.updateImage();
		this.styleDefaultSystem7();
		var scale = this.context.highResolutionEnabled ? 2 : 1;
		if (this.effectedImageCanvas)
			this.effectedImageCanvas.style.top = Math.round(this.size.height/2-this.effectedImageCanvas.height/2/scale)+'px';};
	

UIBarButtonItemView.prototype.initPropertiesFromData = function UIBarButtonItemView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("barButtonItem")) this.barButtonItem = data.barButtonItem;
};

UIBarButtonItemView.prototype.decodeData = function UIBarButtonItemView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

UIBarButtonItemView.prototype.encodeCloned = function UIBarButtonItemView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

UIBarButtonItemView.prototype.expectedTypeForProperty = function UIBarButtonItemView_expectedTypeForProperty(key) {
	if (key === "barButtonItem") return "";
	if (key === "encodesSubviews") return "";
	if (key === "systemItemData") return "";
	if (key === "currentSystemItem") return "String";
	if (key === "buttonStyle") return "";
	if (key === "imageView") return "";
	if (key === "effectedImageCanvas") return "";
	if (key === "button") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIBarButtonItemView; }()));