
registerType('appdoo.iOS', (function () { function UIButton() {} var __super = setSupertypeFromDomain(UIButton, 'UIControl', 'appdoo.iOS');

	Object.defineProperty(UIButton.prototype, "actionType", {
	outlet: true, 
	enumerable: true, get:function () { return this._actionType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_actionType")) Object.defineProperty(this, "_actionType", { writable: true, configurable: true }); this._actionType = v; }});
	
	
	Object.defineProperty(UIButton.prototype, "actionInfo", {
	outlet: true, 
	enumerable: true, 
		get: function () { return EditableObjectGetActionInfoProperty.call(this); }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_actionInfo")) Object.defineProperty(this, "_actionInfo", { writable: true, configurable: true }); EditableObjectSetActionInfoProperty.call(this, v); }});
	

	Object.defineProperty(UIButton.prototype, "e_actionObjectID", {
		get: function ( ) { return this.actionInfo.objectID; }, 
		set: function (v) { this.actionInfo.objectID = v; _context.editor.refreshInspector(); }});
	

	Object.defineProperty(UIButton.prototype, "buttonStyle", {
	outlet: true, 
	enumerable: true, get:function () { return this._buttonStyle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_buttonStyle")) Object.defineProperty(this, "_buttonStyle", { writable: true, configurable: true }); this._buttonStyle = v; }});
	
	
	Object.defineProperty(UIButton.prototype, "defaultTextColor", {
		get: function () {
			return this.context.defaultOrSystemTintColor;
		}});
	
	
	
	

UIButton.prototype.init = function UIButton_init() {
	
		var self = __super.prototype.init.call(this);
		if (!self) return;

		if (this.enabled === undefined) this.enabled = true;
		this.label = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			size: this.size,
			text: this.text,
			style: {
				position: '',
				display: 'table-cell',
				verticalAlign: 'middle',
				textAlign: this.textAlignment||'center',
				color: this.CSSTextColor||this.defaultTextColor
			},
			autoresizingMask: 18})
		;
		this.label.readableValueDidChange = function () {
			this.readableValueDidChange();
		}.bind(this);

		this.addSubview(this.label);
		this.text = this.text;
		this.fontSize = this.fontSize || 17;
		this.fontFamily = this.fontFamily || 'System';
		this.fontName = this.fontName || '_DEFAULT_';

		this.DOMNode.onmousedown = this._onMouseDown.bind(this);
		
		this.styleDefault();

		return this;};
	
	
UIButton.prototype.styleDefaultSystem6 = function UIButton__styleDefaultSystem6() {

		switch (this.buttonType) {
			case 'roundedRect':
			case 'system': {
			
				this.style({
					border: '1px solid rgb(175,175,175)',
					borderRadius: '10px',
					backgroundColor: 'white',
					backgroundImage: 'none',
					boxShadow: '0 1px 0 rgba(255,255,255,.6)',
					fontSize: '15px',
					fontWeight: 'bold',
					color: this.CSSTextColor || this.defaultTextColor
				});
				
				if (this.label)
					this.label.hidden = false;
			
				break;
			}
			case 'infoDark':
			case 'infoLight': {
			
				var imageName = this.buttonType === 'infoLight' ? 'UIButtonInfoLight@2x' : 'UIButtonInfoDark@2x';
			
				this.style({
					backgroundImage: 'url(Resources/'+imageName+'.png)',
					backgroundSize: '18px 19px'
				});

				this.label.hidden = true;
				break;

			}
		}
};
	
	

UIButton.prototype.styleDefaultSystem7 = function UIButton__styleDefaultSystem7() {};
	


UIButton.prototype.changeButtonType = function UIButton__changeButtonType() {
		if (this.buttonType === 'roundedRect' ||
			this.buttonType === 'system') {
			this.style({
				color: this.defaultTextColor
			});
		}

		if (!this.DOMNode) return;

		switch (this.buttonType) {
			case 'roundedRect':
			case 'system': {
			
				this.style({
					border: '1px solid rgb(175,175,175)',
					borderRadius: '10px',
					backgroundColor: 'white',
					backgroundImage: 'none',
					boxShadow: '0 1px 0 rgba(255,255,255,.6)',
					fontSize: '15px',
					fontWeight: 'bold',
					color: this.CSSTextColor || this.defaultTextColor
				});
				
				if (this.label)
					this.label.hidden = false;
			
				break;
			}
			case 'infoDark':
			case 'infoLight': {
			
				var imageName = this.buttonType === 'infoLight' ? 'UIButtonInfoLight@2x' : 'UIButtonInfoDark@2x';
			
				this.style({
					backgroundImage: 'url(Resources/'+imageName+'.png)',
					backgroundSize: '18px 19px'
				});

				this.label.hidden = true;
				break;

			}
		}
	};
	
	
	Object.defineProperty(UIButton.prototype, "text", {
	enumerable: true, 
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_text")) Object.defineProperty(this, "_text", { writable: true, configurable: true });
			this._text = v;
			if (this.label) this.label.text = v;
		}, get:function () { return this._text; }});
	
	
	Object.defineProperty(UIButton.prototype, "label", {
	synthesized: true, get:function () { return this._label; }, set:function (v) {if (!Object.hasOwnProperty(this, "_label")) Object.defineProperty(this, "_label", { writable: true, configurable: true }); this._label = v; }});
	
	
	Object.defineProperty(UIButton.prototype, "encodesSubviews", {
		value: false});
	


	

UIButton.prototype._onMouseDown = function UIButton___onMouseDown(e) {};
	
		
	Object.defineProperty(UIButton.prototype, "CSSTextColor", {
	enumerable: true, 
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_CSSTextColor")) Object.defineProperty(this, "_CSSTextColor", { writable: true, configurable: true });
			this._CSSTextColor = v;
			if (this.label) this.label.style({ color: v||this.context.defaultOrSystemTintColor });
		}, get:function () { return this._CSSTextColor; }});
	

	Object.defineProperty(UIButton.prototype, "fontFamily", {
	enumerable: true, 
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_fontFamily")) Object.defineProperty(this, "_fontFamily", { writable: true, configurable: true });
			this._fontFamily = v;
			if (this.label) this.label.fontFamily = v;
		}, get:function () { return this._fontFamily; }});
	

	Object.defineProperty(UIButton.prototype, "fontName", {
	enumerable: true, 
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_fontName")) Object.defineProperty(this, "_fontName", { writable: true, configurable: true });
			this._fontName = v;
			if (this.label) this.label.fontName = v;
		}, get:function () { return this._fontName; }});
	

	Object.defineProperty(UIButton.prototype, "fontSize", {
	enumerable: true, 
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_fontSize")) Object.defineProperty(this, "_fontSize", { writable: true, configurable: true });
			this._fontSize = v;
			if (this.label) this.label.fontSize = v;
		}, get:function () { return this._fontSize; }});
	
	
	Object.defineProperty(UIButton.prototype, "textAlignment", {
	enumerable: true, 
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_textAlignment")) Object.defineProperty(this, "_textAlignment", { writable: true, configurable: true });
			this._textAlignment = v;
			if (this.label) this.label.DOMNode.style.textAlign = v;
		}, get:function () { return this._textAlignment; }});
	



	
	
UIButton.prototype.prepareForEditor = function UIButton_prepareForEditor(editor) {
		Object.defineProperty(this.label, 'dataController', {
			value: this.dataController
		});

		this.label.prepareForEditor(editor);

		if (this.DOMNode) {
		
			this.DOMNode.ondblclick = function (e) {
				if (editor.isActionClick(e)) return;
				if (this.locked) return;
			
				if (editor.editedSubview === this.superview) {
					this.editDefault(editor);
				}
						
			}.bind(this);
			
			this.DOMNode.onmousedown = function (e) {
				if (editor.isActionClick(e)) {
					this.action();
					e.preventDefault();
					e.stopPropagation();
				}
			}.bind(this);
			
		}
		
		var node = this.node;

		if (!node) {
			console.error('Node not found:', this);
			console.trace();
			return;
		}
		node.isLeaf = false;

		if (Array.isArray(this.listeners)) this.listeners.every(function (listener) {
			var childNode = node.addChildNodeWithRepresentedObject(listener, editor);
			editor.registerItem(listener, childNode);return true; }, this);
		
		
		this.DOMNode.className += ' canClickInActionMode';
};
	

UIButton.prototype.createForSuperview = function UIButton_createForSuperview(superview) {
		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			superview.context,
			{
				text: this.readableType,
				fontSize: 17,
				"fontName" : "_DEFAULT_",
				size: { width: 120, height: 24 },
				autoresizingMask: 36,
				numberOfLines: 1,
				textAlignment: 'center',
				buttonType: 'roundedRect',
			}
		);};
	

	
	Object.defineProperty(UIButton.prototype, "listeners", {
	outlet: true, 
	enumerable: true, get:function () { return this._listeners; }, set:function (v) {if (!Object.hasOwnProperty(this, "_listeners")) Object.defineProperty(this, "_listeners", { writable: true, configurable: true }); this._listeners = v; }});
	

	Object.defineProperty(UIButton.prototype, "enabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._enabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_enabled")) Object.defineProperty(this, "_enabled", { writable: true, configurable: true }); this._enabled = v; }});
	

UIButton.prototype.editDefault = function UIButton_editDefault(editor) {
		return this.label.editDefault(editor);};
	

	Object.defineProperty(UIButton.prototype, "inspectorProperties", {
		get: function () {

			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'button',
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', placeholder: 'Name', undefinedValue:'', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: 'Text', keyPath: 'text' },
						{
							type: 'boolean',
							keyPath: 'enabled',
							name: this.readableNameForProperty('enabled'),
							positionLeft: true
						},
					]
				},
				{
					type: 'group',
					title: LocalizedString('Behavior'),
					id: this.constructor.name+'Behaviour',
					items: [
						
						{ type: 'action', keyPath:'actionInfo', currentActionType: this.actionType, currentActionObjectID: this.e_actionObjectID },
						{ type: 'space' },
					]
				},
					{
						type: 'group',
						title: LocalizedString('Format'),
						id: this.constructor.name+'Format',
						items: [
							{ 
								name: LocalizedString('Color'), 
								keyPath: 'CSSTextColor', 
								type: 'color',
								undefinedValue: this.tintColor||this.context.defaultOrSystemTintColor
							},
							{
								name: LocalizedString('Background Color'),
								type: 'color',
								keyPath: 'backgroundColor', 
								undefinedValue: 'rgba(255,255,255, 1.00)'
							},
							{ 
								type: 'textAlignment', 
								undefinedValue:'center' 
							}]
					},

					{ type: 'formatGroup' },
				
					{
						type: 'group',
						title: LocalizedString('Advanced'),
						id: this.constructor.name+'Advanced',
						items: [
							{
								type: 'boolean', 
								keyPath: 'hidden', 
								name: this.readableNameForProperty('hidden'), 
								positionLeft: true 
							},
						]
					},
				
			];
		}});
	

	Object.defineProperty(UIButton.prototype, "actionID", {
	outlet: true, 
	enumerable: true, get:function () { return this._actionID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_actionID")) Object.defineProperty(this, "_actionID", { writable: true, configurable: true }); this._actionID = v; }});
	
	
UIButton.prototype.action = function UIButton_action(sender) {
		_context.editor.simulateAction(this.actionType, this.actionInfo, true);};
	

	Object.defineProperty(UIButton.prototype, "readableType", {
		get: function () {
			if (this.buttonType === 'infoLight' || this.buttonType === 'isChanging') return LocalizedString('Info Button');
			return LocalizedString('Text Button');
		}});
	
	

	Object.defineProperty(UIButton.prototype, "nameIsEditable", {
	value: true});


UIButton.prototype.readableNameForProperty = function UIButton__readableNameForProperty(propertyName) {
		switch (propertyName) {
			case 'text': return 'Text';
			case 'enabled': return LocalizedString('Enabled');
			case 'backgroundColor': return LocalizedString('Background Color');
		}
		return __super.prototype.readableNameForProperty.call(this, propertyName);};
	

	Object.defineProperty(UIButton.prototype, "outlineIconURL", {
		value: 'Resources/UIButton.png'});
	
	
	Object.defineProperty(UIButton.prototype, "buttonType", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_buttonType")) Object.defineProperty(this, "_buttonType", { writable: true, configurable: true });
			var isChanging = !!this._buttonType;
			this._buttonType = v;
			switch (v) {
				case 'infoLight':
				case 'infoDark': {
					if (isChanging) {
						this.dataController.set({size: { width: 18, height: 19 }});
					}
					break;
				}
				default: {
					break;
				}
			}
			this.styleDefault();
		}, get:function () { return this._buttonType; }});
	
	
	var UIButtonTypeCustom = 0,
		UIButtonTypeSystem = 1,
		UIButtonTypeDetailDisclosure = 2,
		UIButtonTypeInfoLight = 3,
		UIButtonTypeInfoDark = 4,
		UIButtonTypeContactAdd = 5,
		UIButtonTypeRoundedRect = 6;

UIButton.prototype.transformData = function UIButton_transformData(data, transformer) {
		if (transformer.isXIBGenerator) {
			return this.button_transformDataForXIB(data, transformer);
		}
		transformer.setBooleanProperty(data, 'enabled', data.enabled, true);
		return this.button_transformDataForPreview(data, transformer);};
	

UIButton.prototype.button_transformDataForXIB = function UIButton_button_transformDataForXIB(data, transformer) {

		var result = __super.prototype.transformData.call(this, data, transformer);
		result.buttonType = data.buttonType || "roundedRect";

		if (result.buttonType.indexOf('info') === 0) {
			result.showsTouchWhenHighlighted = 'YES';
		}
		
		result['state normal'] = {
			key: 'normal',
			title: data.text,
			
		};
		if (data.CSSTextColor)
			result['state normal'].color = transformer.transformCSSColor(data.CSSTextColor, 'titleColor');

		result['state highlighted'] = {
			key: 'highlighted'
		};

		transformer.setFontProperty(result, data.fontName, data.fontSize, data.fontFamily, true)

		result.contentHorizontalAlignment = data.textAlignment || 'center';
		
		transformer.setBooleanProperty(result, 'enabled', data.enabled, true);
		transformer.transformAndAddActionToObject(null, data.actionInfo, result, data.$id);
		
		if (this.bindingForKey.call(data, 'text')) {
			transformer.demandPlugin('info.appdoo-mac.UIButton+Text');
		}
		
		return result;
};
	
	
UIButton.prototype.button_transformDataForPreview = function UIButton_button_transformDataForPreview(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer, { useDefaultInitializer: true });
		result.$type = 'UIButton';
		result.$constructor = { name: 'buttonWithType:', arguments: [UIButtonTypeSystem] };
		
		result.$initialMethodCalls = [
			{ name: 'setTitle:forState:', arguments: [transformer.transformString(data.text), 0] },
		];

		if (data.CSSTextColor) {
			var color = transformer.transformCSSColor(data.CSSTextColor);

			if (color) result.$initialMethodCalls.push({ name: 'setTitleColor:forState:', arguments: [color, 0] });
		}
		
		result['titleLabel.font'] = transformer.transformFont(data.fontName, data.fontSize);

		result.contentHorizontalAlignment = transformer.transformContentHorizontalAlignment(data.textAlignment);

		transformer.addActionFromDataToResult(data, result);

		return result;};
	



UIButton.prototype.superviewDidChangeTintColor = function UIButton__superviewDidChangeTintColor(color) {
		if (this.label) this.label.style({ color: color||this.context.defaultOrSystemTintColor });};
	


	Object.defineProperty(UIButton.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['text', this.readableNameForProperty('text')],
				['enabled', this.readableNameForProperty('enabled')]
			);
			return result;
		}});
	

	Object.defineProperty(UIButton.prototype, "readableValue", {
		get: function () {
			return this.name||this.text||this.readableType;
		}});
	

UIButton.prototype.transformChangeForAppdooPreview = function UIButton_transformChangeForAppdooPreview(change, transformer, result) {

		switch (change.keyPath) {
		
			case 'CSSTextColor':
				result.keyPath = 'titleLabel.textColor';
				result.value = transformer.transformCSSColor(change.valueNow);
				return true;
				break;
			case 'text':
				result.keyPath = 'titleLabel.text';
				result.value = transformer.transformString(change.valueNow);
				return true;
				break;
			case 'textAlignment':
				result.keyPath = 'contentHorizontalAlignment';
				result.value = transformer.transformContentHorizontalAlignment(change.valueNow);
				alertd(result.value);
				return true;
				break;
			case 'fontName':
				result.keyPath = 'titleLabel.font';
				result.value = transformer.transformFont(change.valueNow, this.fontSize);
				return true;
			case 'fontSize':
				result.keyPath = 'titleLabel.font';
				result.value = transformer.transformFont(this.fontName, change.valueNow);
				return true;
			case 'fontFamily':
				result.keyPath = 'titleLabel.font';
				result.value = transformer.transformFont(this.fontName, this.fontSize);
				return true;
		}
		
		return __super.prototype.transformChangeForAppdooPreview.call(this, change, transformer, result);};
	

UIButton.prototype.initPropertiesFromData = function UIButton_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("actionType")) this.actionType = data.actionType;
if (data.hasOwnProperty("actionInfo")) this.actionInfo = data.actionInfo;
if (data.hasOwnProperty("buttonStyle")) this.buttonStyle = data.buttonStyle;
if (data.hasOwnProperty("text")) this.text = data.text;
if (data.hasOwnProperty("CSSTextColor")) this.CSSTextColor = data.CSSTextColor;
if (data.hasOwnProperty("fontFamily")) this.fontFamily = data.fontFamily;
if (data.hasOwnProperty("fontName")) this.fontName = data.fontName;
if (data.hasOwnProperty("fontSize")) this.fontSize = data.fontSize;
if (data.hasOwnProperty("textAlignment")) this.textAlignment = data.textAlignment;
if (data.hasOwnProperty("listeners")) this.listeners = data.listeners;
if (data.hasOwnProperty("enabled")) this.enabled = data.enabled;
if (data.hasOwnProperty("actionID")) this.actionID = data.actionID;
if (data.hasOwnProperty("buttonType")) this.buttonType = data.buttonType;
};

UIButton.prototype.decodeData = function UIButton_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("actionInfo")) decoded.actionInfo = this.context.decodeObjectTree(data.actionInfo);
if (data.hasOwnProperty("listeners")) decoded.listeners = []; if (Array.isArray(data.listeners)) { data.listeners.forEach(function (o) { decoded.listeners.push(this.context.decodeObjectTree(o)); }.bind(this)); }
return decoded; };

UIButton.prototype.encode = function UIButton_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._actionInfo && this._actionInfo.encode) {encoded.actionInfo = this.actionInfo.encode();
}if (this._listeners && this._listeners.encode) {encoded.listeners = []; this._listeners.forEach(function (o) { encoded.listeners.push(o.encode()); });
}return encoded; };

UIButton.prototype.encodeCloned = function UIButton_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._actionInfo && this._actionInfo.encode) {encoded.actionInfo = this.actionInfo.encodeCloned();
}if (this._listeners && this._listeners.encode) {encoded.listeners = []; this._listeners.forEach(function (o) { encoded.listeners.push(o.encodeCloned()); });
}return encoded; };

UIButton.prototype.expectedTypeForProperty = function UIButton_expectedTypeForProperty(key) {
	if (key === "actionType") return "String";
	if (key === "actionInfo") return "ActionInfo";
	if (key === "e_actionObjectID") return "";
	if (key === "buttonStyle") return "";
	if (key === "defaultTextColor") return "";
	if (key === "text") return "String";
	if (key === "label") return "";
	if (key === "encodesSubviews") return "";
	if (key === "CSSTextColor") return "";
	if (key === "fontFamily") return "";
	if (key === "fontName") return "";
	if (key === "fontSize") return "";
	if (key === "textAlignment") return "";
	if (key === "listeners") return "iOSInstruction[]";
	if (key === "enabled") return "Boolean";
	if (key === "inspectorProperties") return "";
	if (key === "actionID") return "String";
	if (key === "readableType") return "";
	if (key === "nameIsEditable") return "";
	if (key === "outlineIconURL") return "";
	if (key === "buttonType") return "";
	if (key === "bindableProperties") return "";
	if (key === "readableValue") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIButton; }()));
registerType('appdoo', (function () { function ActionInfo() {} var __super = setSupertypeFromDomain(ActionInfo, 'BasicObject', 'Core');

ActionInfo.prototype.init = function ActionInfo_init() {
		__super.prototype.init.call(this);
		if (this.actionType === undefined) this.actionType = 'objectAction';
		if (this.modalTransitionStyle === undefined) this.modalTransitionStyle = '-1';
		if (this.objectActionID === undefined) this.objectActionID = '';
		return this;};
	
	
ActionInfo.prototype.encode = function ActionInfo_encode() {
		var data = __super.prototype.encode.call(this);
		
		
		if (data.actionType) data.type = data.actionType; 
		
		return data;};
	

	Object.defineProperty(ActionInfo.prototype, "actionType", {
	outlet: true, 
	enumerable: true, get:function () { return this._actionType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_actionType")) Object.defineProperty(this, "_actionType", { writable: true, configurable: true }); this._actionType = v; }});
	


	Object.defineProperty(ActionInfo.prototype, "arguments", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			if (!this._arguments) this.arguments = {};
			return this._arguments;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_arguments")) Object.defineProperty(this, "_arguments", { writable: true, configurable: true }); this._arguments = v; }});
	

	Object.defineProperty(ActionInfo.prototype, "objectID", {
	outlet: true, 
	enumerable: true, get:function () { return this._objectID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_objectID")) Object.defineProperty(this, "_objectID", { writable: true, configurable: true }); this._objectID = v; }});
	

	Object.defineProperty(ActionInfo.prototype, "e_objectID", {
		get: function ( ) { return this.objectID; }, 
		set: function (v) {
			this.objectID = v;
			var object = _context.projectContext.connectableObjects[v];
			if (object) {
				try {
					var actions = object.performableActions;
					var firstActionID = Object.keys(actions)[0];
					this.objectActionID = firstActionID;
				} catch (err) {}
			}
			_context.editor.refreshInspector();
		}});
	

	Object.defineProperty(ActionInfo.prototype, "destinationSceneID", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_destinationSceneID")) Object.defineProperty(this, "_destinationSceneID", { writable: true, configurable: true });
			this._destinationSceneID = v;
			this.updateSegue();
		}, get:function () { return this._destinationSceneID; }});
	

	Object.defineProperty(ActionInfo.prototype, "objectActionID", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_objectActionID")) Object.defineProperty(this, "_objectActionID", { writable: true, configurable: true });
			var isUpdating = this.objectActionID !== undefined;
			this._objectActionID = v;
			if (isUpdating) {
				this._arguments = undefined;
				var object = _context.projectContext.connectableObjects[this.objectID];
				try {
					var action = object.performableActions[v];
					if (Array.isArray(action.parameters)) action.parameters.every(function (p) {
						this.arguments[p.key] = '';return true; }, this);
					
				} catch (err) {}
				_context.editor.refreshInspector();
			}
		}, get:function () { return this._objectActionID; }});
	

	Object.defineProperty(ActionInfo.prototype, "modalTransitionStyle", {
	outlet: true, 
	enumerable: true, get:function () { return this._modalTransitionStyle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_modalTransitionStyle")) Object.defineProperty(this, "_modalTransitionStyle", { writable: true, configurable: true }); this._modalTransitionStyle = v; }});
	

	Object.defineProperty(ActionInfo.prototype, "transfersDataAsInput", {
	outlet: true, 
	enumerable: true, get:function () { return this._transfersDataAsInput; }, set:function (v) {if (!Object.hasOwnProperty(this, "_transfersDataAsInput")) Object.defineProperty(this, "_transfersDataAsInput", { writable: true, configurable: true }); this._transfersDataAsInput = v; }});
	

	Object.defineProperty(ActionInfo.prototype, "transferDataSourceID", {
	outlet: true, 
	enumerable: true, get:function () { return this._transferDataSourceID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_transferDataSourceID")) Object.defineProperty(this, "_transferDataSourceID", { writable: true, configurable: true }); this._transferDataSourceID = v; }});
	

	Object.defineProperty(ActionInfo.prototype, "parentObject", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_parentObject")) Object.defineProperty(this, "_parentObject", { writable: true, configurable: true });
			this._parentObject = v;
			this.updateSegue();
		}, get:function () { return this._parentObject; }});
	
	
ActionInfo.prototype.updateSegue = function ActionInfo__updateSegue() {
		if (!this.parentObject) return;
		if (window._context && window._context.editor) _context.editor.updateSegueForView__type__destination__(this.parentObject, 'push', this.destinationSceneID);};
	
	
	Object.defineProperty(ActionInfo.prototype, "readableValue", {
		get: function () {
		
			if (this.actionType === 'objectAction') {
				var obj = _context.projectContext.connectableObjects[this.objectID] || _context.projectContext.globals[this.objectID];
				if (!obj) return;
				var objectActions = obj.performableActions||{};
				var action = objectActions[this.objectActionID];
				if (!action) return;
				return action.name;
			}

			if (this.actionType === 'showScene') {
				return LocalizedString('Show Screen');
			}

			if (this.actionType === 'navigateBack') {
				return LocalizedString('Go Back');
			}

		}});
	
	
ActionInfo.prototype.initPropertiesFromData = function ActionInfo_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("actionType")) this.actionType = data.actionType;
if (data.hasOwnProperty("arguments")) this.arguments = data.arguments;
if (data.hasOwnProperty("objectID")) this.objectID = data.objectID;
if (data.hasOwnProperty("destinationSceneID")) this.destinationSceneID = data.destinationSceneID;
if (data.hasOwnProperty("objectActionID")) this.objectActionID = data.objectActionID;
if (data.hasOwnProperty("modalTransitionStyle")) this.modalTransitionStyle = data.modalTransitionStyle;
if (data.hasOwnProperty("transfersDataAsInput")) this.transfersDataAsInput = data.transfersDataAsInput;
if (data.hasOwnProperty("transferDataSourceID")) this.transferDataSourceID = data.transferDataSourceID;
};

ActionInfo.prototype.decodeData = function ActionInfo_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ActionInfo.prototype.encodeCloned = function ActionInfo_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ActionInfo.prototype.expectedTypeForProperty = function ActionInfo_expectedTypeForProperty(key) {
	if (key === "actionType") return "String";
	if (key === "arguments") return "Object";
	if (key === "objectID") return "String";
	if (key === "e_objectID") return "";
	if (key === "destinationSceneID") return "String";
	if (key === "objectActionID") return "String";
	if (key === "modalTransitionStyle") return "String";
	if (key === "transfersDataAsInput") return "Boolean";
	if (key === "transferDataSourceID") return "String";
	if (key === "parentObject") return "BasicObject";
	if (key === "readableValue") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ActionInfo; }()));