
registerType('appdoo.iOS', (function () { function UIImageView() {} var __super = setSupertypeFromDomain(UIImageView, 'ImageView', 'Core.UI');

	Object.defineProperty(UIImageView.prototype, "usesHighResolutionByDefault", {
		get: function () {
			if (this.isReferenced) {
				var ref = _context.projectContext.fileReferenceWithID(this.imageURLInfo.localImageObjectID);
				if (ref) return ref.name.indexOf('@2x') !== -1;
				return false;
			}
			else {
				return true;
			}
		}});
	
	
	Object.defineProperty(UIImageView.prototype, "frame", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_frame")) Object.defineProperty(this, "_frame", { writable: true, configurable: true });
			if (!v) return;
			if (v.size)
			this.size = v.size;
			if (v.position)
			this.position = {
				left: v.origin.x,
				top: v.origin.y
			};
		}, 
		get: function () {
			return {
				origin: { x: this.position.left, y: this.position.top },
				size: { width: this.size.width, height: this.size.height }
			};
		}});
	

UIImageView.prototype.decodeData = function UIImageView_decodeData(data) {

		data = __super.prototype.decodeData.call(this, data);
		
		
		['imageRef'].every(function (key) {
		
			if (data[key])
				data[key] = this.context.decodeObjectTree(data[key]);
return true; }, this);
		

		return data;};
	
	
UIImageView.prototype.initFromData = function UIImageView_initFromData(data, holdBindings) {


		var frame = data.frame;
		if (frame) {
			if (frame.origin)
				data.position = { left: frame.origin.x, top: frame.origin.y };
			data.size = frame.size;
			delete data.frame;
		}
		
		if (!__super.prototype.initFromData.call(this, data, true))
			return null;

		if (data.imageRef) {
			this.imageRef = data.imageRef;
		}

		if (typeof data.opacity === 'number') {
			this.opacity = data.opacity;
		}
		
		if (data.resourceContext !== undefined) this.resourceContext = data.resourceContext;
		if (data.imageURLString !== undefined) this.imageURLString = data.imageURLString;

		
		if (this.sourceType !== 'local') {
			if (this.imageURLString && isLocalURL(this.imageURLString)) {
				this.sourceType = 'local';
				this.isReferenced = true;
				var imageName = fileNameInLocalURL(this.imageURLString);

				var imageObject;
				if (this.context.resourceNamed)
					imageObject = this.context.resourceNamed(imageName);

				if (imageObject) this.localImageObjectID = imageObject.identify();
			}
		}

		if (!this.sourceType) this.sourceType = 'remote';
		

		if (!holdBindings)
			this.applyBindings(true);

		if (this.isReferenced) this.loadReferencedImage();
		
		return this;};
	
	
UIImageView.prototype.loadReferencedImage = function UIImageView_loadReferencedImage() {
		if (!this.imageURLInfo) return;
		if (this.bindingForKey('imageURLString')) return;
		if (this.imageURLInfo.source === 'remote'
			&& !isLocalURL(this.e_imageURLString)
			)
			this.setImageSrc(this.e_imageURLString);
		else if (this.imageURLInfo.source === 'local') {
			var ref = _context.projectContext.fileReferenceWithID(this.localImageObjectID);
			if (!ref) return;
			var url = _context.projectContext.urlForResourceWithID(ref.resourceID);
			this.setImageSrc(url);
		}
			};
	
	
	Object.defineProperty(UIImageView.prototype, "imageRef", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_imageRef")) Object.defineProperty(this, "_imageRef", { writable: true, configurable: true });

			this._imageRef = v;
			
			if (v)
				this.setImageSrc(this.context.pathForImageWithID(v.imageID));

		}, get:function () { return this._imageRef; }});
	

	Object.defineProperty(UIImageView.prototype, "name", {
	synthesized: true, 
	enumerable: true, get:function () { return this._name; }, set:function (v) {if (!Object.hasOwnProperty(this, "_name")) Object.defineProperty(this, "_name", { writable: true, configurable: true }); this._name = v; }});
	

	Object.defineProperty(UIImageView.prototype, "e_name", {
		set: function (v) {
			this.name = v;
			this.readableValueDidChange(v);
		}, 
		get: function ( ) { return this.name; }});
	
	
	Object.defineProperty(UIImageView.prototype, "opacity", {
		set: function (v) {
			this.alpha100 = v;
		}, 
		get: function () {
			return this.alpha100;
		}});
	
	
UIImageView.prototype.clone = function UIImageView_clone() {
		return this.context.decodeObjectTree(this.encodeCloned());};
	

	Object.defineProperty(UIImageView.prototype, "encodesStyles", {
		value: false});
	
	
UIImageView.prototype.encodeCloned = function UIImageView_encodeCloned() {
		var data = __super.prototype.encodeCloned.call(this);
		delete data.imageSrc;
		if (this.imageRef) {
			data.imageRef = this.imageRef.encodeCloned();
		}
		return data;};
	
	
UIImageView.prototype.encode = function UIImageView_encode() {
		var data = __super.prototype.encode.call(this);
		if (this.imageRef && !this.isReferenced) {
			if (this.imageRef.encode)
				data.imageRef = this.imageRef.encode();
			else {
				console.warn('Invalid imageRef:', this.imageRef, this);
			}
		}
		delete data.imageSrc;
		if (this.bindingForKey('imageURLString') !== undefined) {
			delete data.imageURLString;
		}
		else {
			if (data.imageURLInfo) data.imageURLString = data.imageURLInfo.remoteImageURL;
		}
		return data;};
	



	
	
UIImageView.prototype.transformData = function UIImageView_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.iv_transformDataForXIB(data, transformer);
		else return this.iv_transformDataForPreview(data, transformer);};
	

UIImageView.prototype.iv_transformDataForXIB = function UIImageView_iv_transformDataForXIB(data, transformer) {

		var result = transformer.transformView(data, true);

		result.contentMode = data.contentMode || 'center';
		result.clipsSubviews = 'YES';
		

		if (data.imageRef) {
			if (data.imageRef.fileReferenceID)
				transformer.configureReferencedImage(result, data.imageRef.fileReferenceID, 0, 'imageURLString', true);
			else
				transformer.configureInlineImage(result, data.imageRef);
			
		}
		else if (data.imageURLInfo && this.bindingForKey.call(data, 'imageURLString') === undefined) {
			var fileRefID;
			if (!data.isReferenced || data.imageURLInfo.source === 'local') fileRefID = data.imageURLInfo.localImageObjectID;
			if (fileRefID) {
				var ref = _context.projectContext.fileReferenceWithID(fileRefID);
				if (ref) {
					result.image = ref.name.replace('@2x','');
					transformer.productGenerator.registerResourceUsage(ref, result);
				}
			}
			else {
				transformer.configureReferencedImage(result, fileRefID, data.imageURLInfo.remoteImageURL, 'imageURLString', true);
			}
		}
		
		if (data.useHighlightedImage && data.highlightedImageURLInfo) {
			var fileRefID = null;
			if (!data.isReferenced || data.highlightedImageURLInfo.source === 'local') fileRefID = data.highlightedImageURLInfo.localImageObjectID;
			if (fileRefID) {
				var ref = _context.projectContext.fileReferenceWithID(fileRefID);
				if (ref) {
					result.highlightedImage = ref.name.replace('@2x','');
					transformer.productGenerator.registerResourceUsage(ref, result);
				}
			}
			else {
				transformer.configureReferencedImage(result, fileRefID, data.highlightedImageURLInfo.remoteImageURL, 'highlightedImageURLString', true);
			}
		}
		
		if (this.bindingForKey.call(data, 'imageURLString')) {
			transformer.demandPlugin('info.appdoo-mac.UIImageView+URL');
			transformer.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');
		}
		
		result.userInteractionEnabled = 'NO';
		
		if (typeof data.alpha === 'number') result.alpha = data.alpha;
		
		if (!result.userDefinedRuntimeAttributes)
			result.userDefinedRuntimeAttributes = {};
		if (typeof data.cornerRadius === 'number' && data.cornerRadius > 0) {
			result.alpha = data.alpha;
			result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute cornerRadius'] = {
				type: "number",
				keyPath: "layer.cornerRadius",
				integer: {key: 'value', value: data.cornerRadius|0 }
			};
			result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute masksToBounds'] = {
				type: "boolean",
				keyPath: "layer.masksToBounds",
				value: true
			};
		}

		return result;};
	

UIImageView.prototype.iv_transformDataForPreview = function UIImageView_iv_transformDataForPreview(data, transformer) {
		var result = getPrototype('appdoo.iOS.UIView').transformData(data, transformer, false);
		result.$type = 'UIImageView';
		result.$categories.push('URL');
		result.clipsSubviews = true;

		if (!isNaN(data.alpha)) result.alpha = data.alpha;

		if (transformer.context.imageReferenceIsValid(data.imageRef)) {
			var resourceID = data.imageRef.imageID;
			result.imageURLString = 'resource:'+resourceID;
		}
		else if (data.imageURLInfo && this.bindingForKey.call(data, 'imageURLString') === undefined) {
			var url;
			if (data.imageURLInfo.source === 'local') {
				var ref = _context.projectContext.fileReferenceWithID(data.imageURLInfo.localImageObjectID);
				if (ref) url = 'resource:'+ref.resourceID;
			}
			else {
				url = data.imageURLInfo.remoteImageURL;
			}
			if (url) result.imageURLString = url;
		}
		
		return result;	};
	
	
	
	
	
// role EditorItem (appdoo.Editor) 
	
UIImageView.prototype.createForSuperview = function UIImageView_createForSuperview(superview) {
		
		var iv =  createComponentFromDomain(
			'UIImageView',
			this.__domain,
			superview.context,
			{
				imageURLString: '',
				size: { width: 150, height: 150 },
				contentMode: "center",
				resourceContext: superview.context,
				isReferenced: true,
				autoresizingMask: 36
			}
		);
		iv.sourceType = 'local';	
		return iv;
					};
		
		
UIImageView.prototype.deleteForEditor = function UIImageView_deleteForEditor(editor) {
			if (this.imageRef) this.imageRef.deleteForEditor(editor);};
		
		
UIImageView.prototype.prepareForEditor = function UIImageView_prepareForEditor(editor) {

			if (editor.isOpening !== true) {
				if (this.imageRef) {
					editor.context.projectContext.registerImageWithID(this.imageRef.imageID);
				}
			}
			
			
			editor.observeObject(this.dataController);

			this.showPlaceholder();};
		
		
		Object.defineProperty(UIImageView.prototype, "nameIsEditable", {
			get: function () {
				return true;
			}});
		

		
		Object.defineProperty(UIImageView.prototype, "inspectorProperties", {
			get: function () {
			
				if (this.isReferenced) return this.referencedImageInspectorProperties;
				
				var hasFileReference = this.imageRef&&this.imageRef.fileReferenceID;
				var isEmpty = !this.imageRef||!this.imageRef.imageID;
				
				return [
					{
						type: 'group',
						title: LocalizedString('Image'),
						id: 'image',
						items: [

							{ name: '', type: 'image', keyPath: 'imageRef' },

							{ name: LocalizedString('Scaling'), keyPath: 'contentMode',
								type: 'select',
								options: [
									["center", LocalizedString('center')],
									["scaleToFill", LocalizedString('scale to fill')],
									["scaleAspectFit", LocalizedString('scale to aspect fit')],
									["scaleAspectFill", LocalizedString('scale to aspect fill')],
								],
								undefinedValue: "center" },
							
							{ type : 'space' },
							
							{ name: LocalizedString('Opacity'), type: 'range', range:[0,100], keyPath: 'opacity', undefinedValue: 100 },

							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), },

							{ type : 'space' },
							{ type : 'space', hidden:hasFileReference||isEmpty },


							{ type: 'button', caption: LocalizedString('Create Reference'), buttonWidth:LocalizedNumber('MAKE_IMAGE_GLOBAL_BUTTON_WIDTH')+10, buttonStyle: 'flat', actionKeyPath: 'createReferencingGlobalObject', hidden:hasFileReference||isEmpty },

							{ type: 'info', html: LocalizedString('Referenced images can be used on multiple screens.'), height: 50, style:{color:'#666',marginTop:'-8px'}, hidden:hasFileReference||isEmpty },


							{ type: 'button', caption: LocalizedString('Create Button'), buttonWidth:LocalizedNumber('CREATE_BUTTON_BUTTON_WIDTH')+10, buttonStyle: 'flat', positionLeft: true, actionKeyPath: 'convertToButton', align:'', positionLeft:true, hidden: _context.editor.viewIsInsideButton(this) },
						]
					}
				];
			}});
		
		
	Object.defineProperty(UIImageView.prototype, "sourceType", {
		set: function (v) {
			if (!this.imageURLInfo) this.imageURLInfo = {};
			this.imageURLInfo.source = v;
			if (v === 'local') {
				this.e_localImageObjectID = this.e_localImageObjectID;
			}
			if (v === 'remote') {
				this.imageURLString = this.imageURLString;
			}
		}, 
		get: function () {
			if (this.imageURLInfo) return this.imageURLInfo.source;
		}});
	

	Object.defineProperty(UIImageView.prototype, "localImageObjectID", {
		set: function (v) {
			if (!this.imageURLInfo) this.imageURLInfo = { 					source: 'local',
			};
			this.imageURLInfo.localImageObjectID = v;
		}, 
		get: function () {
			if (this.imageURLInfo) return this.imageURLInfo.localImageObjectID;
		}});
	
	
	Object.defineProperty(UIImageView.prototype, "e_localImageObjectID", {
		get: function ( ) { return this.localImageObjectID; }, 
		set: function (v) {
			this.localImageObjectID = v;
			this.loadReferencedImage();
			this.outlineIconURLDidChange();
		}});
	

	Object.defineProperty(UIImageView.prototype, "imageURLInfo", {
	outlet: true, 
	enumerable: true, get:function () { return this._imageURLInfo; }, set:function (v) {if (!Object.hasOwnProperty(this, "_imageURLInfo")) Object.defineProperty(this, "_imageURLInfo", { writable: true, configurable: true }); this._imageURLInfo = v; }});
	
		
	Object.defineProperty(UIImageView.prototype, "highlightedImageURLInfo", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			if (this._highlightedImageURLInfo === undefined) { this.highlightedImageURLInfo = { source: 'local' }; };
			return this._highlightedImageURLInfo;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_highlightedImageURLInfo")) Object.defineProperty(this, "_highlightedImageURLInfo", { writable: true, configurable: true }); this._highlightedImageURLInfo = v; }});
	
	
	Object.defineProperty(UIImageView.prototype, "useHighlightedImage", {
	outlet: true, 
	enumerable: true, get:function () { return this._useHighlightedImage; }, set:function (v) {if (!Object.hasOwnProperty(this, "_useHighlightedImage")) Object.defineProperty(this, "_useHighlightedImage", { writable: true, configurable: true }); this._useHighlightedImage = v; }});
	
	
	Object.defineProperty(UIImageView.prototype, "cornerRadius", {
	outlet: true, 
	enumerable: true, 
		set: function (n) {if (!Object.hasOwnProperty(this, "_cornerRadius")) Object.defineProperty(this, "_cornerRadius", { writable: true, configurable: true });
			this._cornerRadius = Math.min(n,this.size.height/2);
			if (this._cornerRadius != n) {
				_context.editor.refreshInspector();
			}
			this.style({borderRadius:this._cornerRadius+'px'});
		}, get:function () { return this._cornerRadius; }});
	
	
	Object.defineProperty(UIImageView.prototype, "referencedImageInspectorProperties", {
		get: function () {
			var properties = [];

			properties.unshift(
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ keyPath: 'imageURLInfo', type: 'imageURL', fileReferenceIDKeyPath: 'e_localImageObjectID', imageURLKeyPath: 'imageURLString', sourceKeyPath: 'sourceType', dataKeyPath: 'imageURLString', includePDFs: false, dataName:LocalizedString('URL') },
					

						{ name: LocalizedString('Scaling'), keyPath: 'contentMode',
							type: 'select',
							options: [
								["center", LocalizedString('center')],
								["scaleToFill", LocalizedString('scale to fill')],
								["scaleAspectFit", LocalizedString('scale to aspect fit')],
								["scaleAspectFill", LocalizedString('scale to aspect fill')],
							],
							undefinedValue: "center",
							marginTop: 5 },
						{ type: 'space' },
						{ type: 'boolean', name: LocalizedString('Use Image for Highlighted State'), positionLeft: true, keyPath: 'useHighlightedImage', conditionalProperties: [{ type: 'space' },
						{ keyPath: 'highlightedImageURLInfo', type: 'imageURL', includePDFs: false, dataName:LocalizedString('URL'), }] },
						{ type: 'space' },
					]
				},
				
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: 'UIImageViewAdvanced',
					items: [

						{ type: 'number', keyPath: 'cornerRadius', name: LocalizedString('Corner Radius'),labelOnTop:true },
						{ type: 'space' },

						{ name: LocalizedString('Opacity'), type: 'range', range:[0,100], keyPath: 'opacity', undefinedValue: 100, marginTop: 6 },

						{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft:0 },
	
						{ type: 'space' },
						{ type: 'button', caption: LocalizedString('Create Button'), buttonWidth:LocalizedNumber('CREATE_BUTTON_BUTTON_WIDTH')+10, buttonStyle: 'flat', positionLeft: true, actionKeyPath: 'convertToButton', positionLeft:true, hidden: _context.editor.viewIsInsideButton(this) },

						{ name: LocalizedString('Background Color'), keyPath: 'backgroundColor', type: 'color', undefinedValue: 'rgba(255,255,255, 0)', marginTop: 3 },
					]
				});
			
			return properties;
		}});
	
	


UIImageView.prototype.undoNameForKeyPaths = function UIImageView_undoNameForKeyPaths(keyPaths) {

			var name = __super.prototype.undoNameForKeyPaths.call(this, keyPaths);
			if (name) return name;
			
			if (keyPaths.indexOf('imageID') !== -1)
				return LocalizedString('Change Image');
			
			var propertyNames = {
				'contentMode': 'Scaling',
			};
			
			for (keyPath in propertyNames) {
				if (keyPaths.indexOf(keyPath) !== -1)
					return LocalizedString1('Change %1', LocalizedString(propertyNames[keyPath]));
			}
			
			if (keyPaths.indexOf('name') !== -1)
				return LocalizedString('Umbenennen');


};
		
		
	

	Object.defineProperty(UIImageView.prototype, "outlineIconURL", {
		get: function () {
			if (this.imageRef) return this.context.pathForImageWithID(this.imageRef.imageID);
			if (!this.imageSrc) return 'Resources/UIImageView.png';
			return this.imageSrc;
		}});
	

	Object.defineProperty(UIImageView.prototype, "readableValue", {
		get: function () {

			if (this.name) return this.name;

			if (this.isReferenced) {

				var s = this.e_imageURLString;
				if (typeof s !== 'string') return;

				if (isLocalURL(s))
					return this.readableType;
				
				if (s[s.length-1] === '/') s = s.substr(0,s.length-1);
				s = s.substr(s.lastIndexOf('/')+1);
				if (s) {
					return s;
				}
				
				return LocalizedString('Image View');
			}


			return LocalizedString('Untitled Image');
		}});
	

	Object.defineProperty(UIImageView.prototype, "readableType", {
		get: function () {
			if (this.isReferenced) return LocalizedString('Image View');
			return LocalizedString('Image');
		}});
	

	Object.defineProperty(UIImageView.prototype, "cocoaType", {
	configurable: true, 
		value: 'UIImageView'});
	

	Object.defineProperty(UIImageView.prototype, "canHaveLayoutRelations", {
		value: true});
	

	Object.defineProperty(UIImageView.prototype, "backgroundColor", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_backgroundColor")) Object.defineProperty(this, "_backgroundColor", { writable: true, configurable: true });
			this._backgroundColor = v;
			this.style({ backgroundColor: v||'' });
		}, get:function () { return this._backgroundColor; }});
	

	Object.defineProperty(UIImageView.prototype, "positionIsEditable", {
	configurable: true, 
		value: true});
	

	Object.defineProperty(UIImageView.prototype, "sizeIsEditable", {
	configurable: true, 
		value: true});
	

	Object.defineProperty(UIImageView.prototype, "xIsEditable", {
		get: function () { return this.positionIsEditable; }});
	

	Object.defineProperty(UIImageView.prototype, "yIsEditable", {
		get: function () { return this.positionIsEditable; }});
	

	Object.defineProperty(UIImageView.prototype, "widthIsEditable", {
		get: function () { return this.sizeIsEditable; }});
	

	Object.defineProperty(UIImageView.prototype, "heightIsEditable", {
		get: function () { return this.sizeIsEditable; }});
	
	
	Object.defineProperty(UIImageView.prototype, "contentType", {
		get: function () {
			function getSuffix(str) {
				var lastDot = str.lastIndexOf('.');
				if (lastDot === -1) return '';
				return str.substr(lastDot+1);
			}
			var suffix = getSuffix(this.imageSrc).toLowerCase();
			if (suffix === 'png') return 'image/png';
			if (suffix === 'jpg' || suffix === 'jpeg') return 'image/jpeg';
			if (suffix === 'gif') return 'image/gif';
			if (suffix === 'tiff' || suffix === 'tif') return 'image/tiff';
			if (suffix === 'psd') return 'application/x-photoshop';
			return '';
		}});
	

UIImageView.prototype.createReferencingGlobalObject = function UIImageView_createReferencingGlobalObject() {

		this.dataController.setValueForKeyPath(true,'isReferenced');
		_context.editor.refreshInspector(this);
		};
	
	
	Object.defineProperty(UIImageView.prototype, "isReferenced", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_isReferenced")) Object.defineProperty(this, "_isReferenced", { writable: true, configurable: true });
			this._isReferenced = v;
			if (v) {
				if (!this.imageRef) return;
				var imageIDWithSuffix = this.imageRef.imageID;
				if (imageIDWithSuffix.indexOf('.') === -1) imageIDWithSuffix += '.png'; 

				var ref = _context.editor.addResourceReference(imageIDWithSuffix, this.name, this.imageRef.contentType||this.contentType);
				_context.editor.addUndoStepForInsertOperation(ref);
				ref.originalFileInfo = this.imageRef.originalFileInfo;
				if (!ref.name) {
					var prefix = LocalizedString('Image'), i = 1, suffix = '.'+(ref.contentType||'image/png').split('/').pop();
					var name;
					do { name = prefix+i+suffix; i++; } while (_context.projectContext.resourceNamed(name));
					ref.name = name;
				}
				this.imageRef = null;
				if (ref) this.localImageObjectID = ref.identify();
				this.sourceType = 'local';
			}
			else {
				console.warn('undoing addResourceReference() is not implemented yet!');
			}
			this.readableValueDidChange();
		}, get:function () { return this._isReferenced; }});
	
	
	Object.defineProperty(UIImageView.prototype, "resourceContext", {
	synthesized: true, get:function () { return this._resourceContext; }, set:function (v) {if (!Object.hasOwnProperty(this, "_resourceContext")) Object.defineProperty(this, "_resourceContext", { writable: true, configurable: true }); this._resourceContext = v; }});
	

	Object.defineProperty(UIImageView.prototype, "imageURLString", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_imageURLString")) Object.defineProperty(this, "_imageURLString", { writable: true, configurable: true });
			if (!this.isReferenced) return;

			
			if (value && isLocalURL(value)) {
				var resourceContext = this.resourceContext || this.context;

				if (!resourceContext) return;
				var imageSrc = resourceContext.pathForResourceNamed(fileNameInLocalURL(value));

				this.setImageSrc(imageSrc);
			}
			else {
				this.setImageSrc(value);
			}
			
			if (this.isReferenced) {
				if (!this.imageURLInfo) this.imageURLInfo = {};
				this.imageURLInfo.remoteImageURL = value;
			}
			
			this._imageURLString = value;
			this.readableValueDidChange();
			this.outlineIconURLDidChange();
		}, get:function () { return this._imageURLString; }});
	
	
UIImageView.prototype.setImageSrc = function UIImageView__setImageSrc(src) {
		__super.prototype.setImageSrc.call(this, src);};
	

UIImageView.prototype.outlineIconURLDidChange = function UIImageView__outlineIconURLDidChange() {
		this.context.broadcastValueChangeForKeyPathInObject('outlineIconURL', this, this);};
	
	
	Object.defineProperty(UIImageView.prototype, "e_imageURLString", {
		get: function ( ) { return this.imageURLString||''; }, 
		set: function (v) { this.imageURLString = v; }});
	

	Object.defineProperty(UIImageView.prototype, "bindableProperties", {
		get: function () {
			var result = Object.getOwnPropertyDescriptor(__super.prototype, "bindableProperties").get.call(this);
			if (this.isReferenced) {
				result.unshift(
					['imageURLString', this.readableNameForProperty('imageURLString')],
					['imageData', this.readableNameForProperty('imageData')],
					['highlighted', this.readableNameForProperty('highlighted')]
				);
			}
			return result;
		}});
	


	Object.defineProperty(UIImageView.prototype, "highlighted", {
	outlet: true, 
	enumerable: true, get:function () { return this._highlighted; }, set:function (v) {if (!Object.hasOwnProperty(this, "_highlighted")) Object.defineProperty(this, "_highlighted", { writable: true, configurable: true }); this._highlighted = v; }});
	


UIImageView.prototype.readableNameForProperty = function UIImageView__readableNameForProperty(propertyName) {
		switch (propertyName) {
			case 'imageURLString': return LocalizedString('Image URL');
			case 'imageData': return LocalizedString('Image Data');
			case 'highlighted': return LocalizedString('highlighted');
		}
		return __super.prototype.readableNameForProperty.call(this, propertyName);};
	

UIImageView.prototype.convertToButton = function UIImageView_convertToButton() {
		_context.editor.convertItemsToButton([this]);};
	

	Object.defineProperty(UIImageView.prototype, "placeholderLabel", {
	synthesized: true, get:function () { return this._placeholderLabel; }, set:function (v) {if (!Object.hasOwnProperty(this, "_placeholderLabel")) Object.defineProperty(this, "_placeholderLabel", { writable: true, configurable: true }); this._placeholderLabel = v; }});
	
	
UIImageView.prototype.showPlaceholder = function UIImageView__showPlaceholder() {
		if (this.placeholderLabel) return;
		
		
		if (this.imageRatio) return;
		
		this.placeholderLabel = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			text: this.readableType,
			style: { textAlign: 'center', color: 'rgb(148,163,196)', textShadow: 'rgba(255,255,255,.3)', backgroundColor: '#d9e1f0' },
			size: { width: this.size.width, height: this.size.height },
			position: { left: 0, top: 0 },
			autoresizingMask: 18})
		;
		this.addSubview(this.placeholderLabel);};
	
	
UIImageView.prototype.hidePlaceholder = function UIImageView__hidePlaceholder() {
		if (!this.placeholderLabel) return;
		this.placeholderLabel.removeFromSuperview();
		this.placeholderLabel = null;};
	
	
UIImageView.prototype.imageDidLoad = function UIImageView__imageDidLoad(img) {
		__super.prototype.imageDidLoad.call(this, img);
		this.hidePlaceholder();};
	
	
UIImageView.prototype.specialDataToCopyWithEditor = function UIImageView_specialDataToCopyWithEditor(editor) {
		var data = {};

		if (this.imageSrc && this.imageSrc[0] === '/')
			data['public.file-url'] = 'file://'+this.imageSrc;
		if (this.imageSrc && this.imageSrc.indexOf('file://') === 0)
			data['public.file-url'] = this.imageSrc;
		if (this.imageSrc && this.imageSrc.indexOf('http') === 0)
			data['public.url'] = this.imageSrc;

		return data;};
	
	
UIImageView.prototype.fileReferenceDidUpdate = function UIImageView_fileReferenceDidUpdate(fileReference) {
		if (this.localImageObjectID === fileReference.$id) {
			this.loadReferencedImage();
			this.outlineIconURLDidChange();
		}
		else if (this.imageRef && this.imageRef.fileReferenceID === fileReference.$id) {
			this.imageRef.fileReferenceID = fileReference.$id;
			this.imageRef.imageID = fileReference.resourceID;
			this.imageRef = this.imageRef;
			this.outlineIconURLDidChange();
		}};
	

UIImageView.prototype.transformChangeForAppdooPreview = function UIImageView_transformChangeForAppdooPreview(change, transformer, result) {
		return getPrototype('appdoo.iOS.UIView').transformChangeForAppdooPreview.call(this, change, transformer, result);};
	
	
	
	Object.defineProperty(UIImageView.prototype, "transform", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_transform")) Object.defineProperty(this, "_transform", { writable: true, configurable: true }); if (!v) v = ''; this._transform = v; if (this.DOMNode) this.DOMNode.style.webkitTransform = v; }, get:function () { return this._transform; }});
	
	
	
	Object.defineProperty(UIImageView.prototype, "alpha", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_alpha")) Object.defineProperty(this, "_alpha", { writable: true, configurable: true }); if (isNaN(v)) v = 1; this._alpha = v; if (this.DOMNode) this.DOMNode.style.opacity = v; }, get:function () { return this._alpha; }});
	

	
	Object.defineProperty(UIImageView.prototype, "alpha100", {
		set: function (v) { this.alpha = v/100||0; }, 
		get: function () { if (isNaN(this.alpha)) return 100; return this.alpha*100; }});
	

	Object.defineProperty(UIImageView.prototype, "imageData", {
	synthesized: true, get:function () { return this._imageData; }, set:function (v) {if (!Object.hasOwnProperty(this, "_imageData")) Object.defineProperty(this, "_imageData", { writable: true, configurable: true }); this._imageData = v; }});
	

	function fileNameInLocalURL(url) {
		if (typeof url !== 'string') return '';
		if (url.indexOf('file:') === 0) return url.substr(5);
		return url;
	}

	function isLocalURL(url) {
		if (typeof url !== 'string') return false;
		return url.indexOf('file:') === 0 || url.indexOf(':') === -1;
	}
	
UIImageView.prototype.initPropertiesFromData = function UIImageView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("frame")) this.frame = data.frame;
if (data.hasOwnProperty("imageURLInfo")) this.imageURLInfo = data.imageURLInfo;
if (data.hasOwnProperty("highlightedImageURLInfo")) this.highlightedImageURLInfo = data.highlightedImageURLInfo;
if (data.hasOwnProperty("useHighlightedImage")) this.useHighlightedImage = data.useHighlightedImage;
if (data.hasOwnProperty("cornerRadius")) this.cornerRadius = data.cornerRadius;
if (data.hasOwnProperty("backgroundColor")) this.backgroundColor = data.backgroundColor;
if (data.hasOwnProperty("isReferenced")) this.isReferenced = data.isReferenced;
if (data.hasOwnProperty("highlighted")) this.highlighted = data.highlighted;
if (data.hasOwnProperty("transform")) this.transform = data.transform;
if (data.hasOwnProperty("alpha")) this.alpha = data.alpha;
};

UIImageView.prototype.expectedTypeForProperty = function UIImageView_expectedTypeForProperty(key) {
	if (key === "usesHighResolutionByDefault") return "";
	if (key === "frame") return "";
	if (key === "imageRef") return "";
	if (key === "name") return "";
	if (key === "e_name") return "String";
	if (key === "opacity") return "";
	if (key === "encodesStyles") return "";
	if (key === "nameIsEditable") return "";
	if (key === "inspectorProperties") return "";
	if (key === "sourceType") return "String";
	if (key === "localImageObjectID") return "String";
	if (key === "e_localImageObjectID") return "";
	if (key === "imageURLInfo") return "Object";
	if (key === "highlightedImageURLInfo") return "Object";
	if (key === "useHighlightedImage") return "Boolean";
	if (key === "cornerRadius") return "";
	if (key === "referencedImageInspectorProperties") return "";
	if (key === "outlineIconURL") return "";
	if (key === "readableValue") return "";
	if (key === "readableType") return "";
	if (key === "cocoaType") return "";
	if (key === "canHaveLayoutRelations") return "";
	if (key === "backgroundColor") return "String";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "contentType") return "";
	if (key === "isReferenced") return "Boolean";
	if (key === "resourceContext") return "";
	if (key === "imageURLString") return "String";
	if (key === "e_imageURLString") return "";
	if (key === "bindableProperties") return "";
	if (key === "highlighted") return "Boolean";
	if (key === "placeholderLabel") return "";
	if (key === "transform") return "String";
	if (key === "alpha") return "Number";
	if (key === "alpha100") return "Number";
	if (key === "imageData") return "Data";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIImageView; }()));
registerType('appdoo.iOS', (function () { function UIImageViewWithURL() {} var __super = setSupertypeFromDomain(UIImageViewWithURL, 'UIImageView', 'appdoo.iOS');
	
UIImageViewWithURL.prototype.createForEditor = function UIImageViewWithURL_createForEditor(editor) {
		return this.createForSuperview(editor.editedSubview);};
	
	
UIImageViewWithURL.prototype.createForSuperview = function UIImageViewWithURL_createForSuperview(superview) {
		return __super.prototype.createForSuperview.call(this, superview);};
	

UIImageViewWithURL.prototype.expectedTypeForProperty = function UIImageViewWithURL_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIImageViewWithURL; }()));