
registerType('appdoo.iOS', (function () { function UILabel() {} var __super = setSupertypeFromDomain(UILabel, 'UIView', 'appdoo.iOS');


UILabel.prototype.initFromData = function UILabel_initFromData(data) {
	
		if (!__super.prototype.initFromData.call(this, data, null, true))
			return;

		
		
		
		Object.defineProperty(this, '_containerNode', {
			value:  document.createElement('div')
		});

		this.style.call({ DOMNode: this._containerNode }, {
			display: 'table-cell',
			verticalAlign: 'middle',
			width: this.size.width+'px',
			height: this.size.height+'px'
		});
		
		Object.defineProperty(this, '_contentNode', {
			value:  document.createElement('div')
		});
		
		this.style.call({ DOMNode: this._contentNode }, {
			width: this.size.width+'px',
			overflow: 'hidden',
			textOverflow: 'ellipsis',
			whiteSpace: 'nowrap',
			wordWrap: 'break-word'
		});
		
		this._containerNode.appendChild(this._contentNode);
		this.DOMNode.appendChild(this._containerNode);


		[ 'text',
		  'shadowColor',
		  'shadowOffsetX',
		  'shadowOffsetY',
		  'fontSize',
		  'textIndent',
		  'numberOfLines',
		  'fontFamily',
		  'fontName',
		  'font',
		  'layoutMode',
		  'textColor',
		  'highlightedTextColor',
		  'textAlignment',
		].every(function (option) {
			if (data[option] !== undefined)
				this[option] = data[option];
			return true;
		}.bind(this));

		if (data.fontSize === undefined)
			this.fontSize = 17;
		this.autoFitWidth = data.autoFitWidth||false;

		this.updateShadow();
		
		this.applyBindings(true);
		
		return this;};
	


	

UILabel.prototype.layoutSubviews = function UILabel_layoutSubviews() {
		this.style.call({ DOMNode: this._containerNode }, {
			width: this.size.width+'px',
			height: this.size.height+'px'
		});
		this.style.call({ DOMNode: this._contentNode }, {
			width: this.size.width+'px',
		});};
	


	

UILabel.prototype.transformData = function UILabel_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.label_transformDataForXIB(data, transformer);
		else return this.label_transformDataForPreview(data, transformer);};
	

UILabel.prototype.label_transformDataForXIB = function UILabel_label_transformDataForXIB(data, transformer) {
	
		var result = transformer.transformView(data, true);

		result.text = data.text;
		
		result.adjustsFontSizeToFit = "NO";

		transformer.setFontProperty(result, data.fontName, data.fontSize, data.fontFamily, true)

		result.textAlignment = data.textAlignment;

		if (data.textColor) {
			result['color textColor'] = transformer.transformCSSColor(
				data.textColor, 'textColor'
			);
        } else {
            result['color textColor'] = transformer.transformCSSColor(
                'rgba(0,0,0,1.00)', 'textColor'
            );
        }
		
		if (data.highlightedTextColor) {
			result['color highlightedColor'] = transformer.transformCSSColor(
				data.highlightedTextColor, 'highlightedColor'
			);
        } else {
            result['color highlightedColor'] = result['color textColor'];
		}
		
		if (data.shadowOffsetX || data.shadowOffsetY) {
			result['color shadowColor'] = transformer.transformCSSColor(
				data.shadowColor || 'rgba(0,0,0,0)', 'shadowColor');
			result['size shadowOffset'] = transformer.transformToSize(
				data.shadowOffsetX, data.shadowOffsetY, 'shadowOffset');
		}
		
		result.numberOfLines = data.numberOfLines;
		
		return result;
	};
	

UILabel.prototype.label_transformDataForPreview = function UILabel_label_transformDataForPreview(data, transformer) {
	
		var result = __super.prototype.transformData.call(this, data, transformer);
		result.$type = this.constructor.name;

		var autoFitHeight = data.layoutMode === 'autoFitHeight',
			autoFitWidth = (data.layoutMode === 'singleLine' && data.autoFitWidth);
			
		if (autoFitHeight || autoFitWidth) {
			result.$type = 'AutoSizeLabel';
			result.$domain = 'info.appdoo-mac';
			transformer.setBooleanProperty(result, 'autoFitHeight', autoFitHeight);
			transformer.setBooleanProperty(result, 'autoFitWidth', autoFitWidth);
		}

		var hasTextBinding = this.bindingForKey.call(data, 'text');
		result.text = hasTextBinding ? '' : transformer.transformString(data.text);

		result.font = transformer.transformFont(data.fontName, data.fontSize);
        if (data.textColor) {
            result.textColor = transformer.transformCSSColor(data.textColor);
        } else {
            result.textColor = transformer.transformCSSColor('rgba(0,0,0,1.00)');
        }
        if (data.highlightedTextColor) {
            result.highlightedTextColor = transformer.transformCSSColor(data.highlightedTextColor);
        } else {
            result.highlightedTextColor = result.textColor;
        }




        
		result.shadowColor = transformer.transformCSSColor(data.shadowColor||'');
		result.shadowOffset = transformer.transformCGSize(data.shadowOffsetX, data.shadowOffsetY);
		result.numberOfLines = data.numberOfLines;
		result.textAlignment = transformer.transformTextAlignment(data.textAlignment);
		
		



        
		return result;};
	
	
UILabel.prototype.transformChangeForAppdooPreview = function UILabel_transformChangeForAppdooPreview(change, transformer, result) {

		switch (change.keyPath) {
		
			case 'CSSTextColor':
				result.keyPath = 'textColor';
				result.value = transformer.transformCSSColor(change.valueNow);
				return true;
				break;
			case 'text':
				result.keyPath = change.keyPath;
				result.value = transformer.transformString(change.valueNow);
				return true;
				break;
			case 'textAlignment':
				result.keyPath = change.keyPath;
				result.value = transformer.transformTextAlignment(change.valueNow);
				return true;
				break;
			case 'fontName':
				result.keyPath = 'font';
				result.value = transformer.transformFont(change.valueNow, this.fontSize);
				return true;
			case 'fontSize':
				result.keyPath = 'font';
				result.value = transformer.transformFont(this.fontName, change.valueNow);
				return true;
			case 'shadowOffsetX':
				result.keyPath = 'shadowOffset';
				result.value = transformer.transformCGSize(change.valueNow, this.shadowOffsetY);
				return true;
			case 'shadowOffsetY':
				result.keyPath = 'shadowOffset';
				result.value = transformer.transformCGSize(this.shadowOffsetX, change.valueNow);
				return true;
			case 'shadowColor':
				result.keyPath = change.keyPath;
				result.value = transformer.transformCSSColor(change.valueNow);
				return true;
				break;
			case 'fontFamily':
				result.keyPath = 'font';
				result.value = transformer.transformFont(this.fontName, this.fontSize);
				return true;
		}
		
		return __super.prototype.transformChangeForAppdooPreview.call(this, change, transformer, result);};
	
	
UILabel.prototype.generateLayoutCodeFromData = function UILabel_generateLayoutCodeFromData(data, propertyKeyPath, appGenerator) {
		
		if (data.layoutMode === 'autoFitHeight') {
			appGenerator.demandPluginWithIdentifier('info.appdoo-mac.UILabelAutoSize');
			return '\t['+propertyKeyPath+' sizeToFitWidth];\n'
		}
		else if (data.layoutMode === 'singleLine' && data.autoFitWidth) {
			appGenerator.demandPluginWithIdentifier('info.appdoo-mac.UILabelAutoSize');
			return '\t['+propertyKeyPath+' sizeToFitHeight];\n'
		}
		};
	


	

UILabel.prototype.updateShadow = function UILabel__updateShadow() {

		var shadowColor = this.shadowColor || 'rgba(0,0,0,0)',
			shadowOffsetX = this.shadowOffsetX || 0,
			shadowOffsetY = this.shadowOffsetY || 0;

		if (shadowOffsetX === 0 &&
			shadowOffsetY === 0) {
			this._contentNode.style.textShadow = '';
			return;
		}

		this._contentNode.style.textShadow =
			shadowOffsetX + 'px ' +
			shadowOffsetY + 'px ' +
			0 + 'px ' +
			shadowColor;
};
	


	

	Object.defineProperty(UILabel.prototype, "text", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_text")) Object.defineProperty(this, "_text", { writable: true, configurable: true });

			var isUpdatingValue = (this._text !== undefined);
			
			if (value === undefined) value = '';
			if (typeof value === 'object') value = '';
			if (typeof value === 'boolean') value = value ? '1' : '0';

			this._text = value;
			
			if (!value && isNaN(value)) value = ' ';
			else if (value[0] === ' ') value[0] = ' ';

			this._contentNode.textContent = value;


			if (isUpdatingValue) {
				this.readableValueDidChange();
			}
			
			this.applyLayoutMode();

		}, get:function () { return this._text; }});
	

	Object.defineProperty(UILabel.prototype, "fontSize", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_fontSize")) Object.defineProperty(this, "_fontSize", { writable: true, configurable: true });
			this._fontSize = value;
			this.DOMNode.style.fontSize = value + 'px';
			this.applyFontChange();
			if (this.floatingTextField) this.floatingTextField.textField.inputNode.style.fontSize = value+'px';
		}, get:function () { return this._fontSize; }});
	

	Object.defineProperty(UILabel.prototype, "fontFamily", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_fontFamily")) Object.defineProperty(this, "_fontFamily", { writable: true, configurable: true });
			if (this._fontFamily && (window._context && !_context.undoManager.isUndoing)) {
			
				var firstChoice = firstChoiceForFontFamily(v, this._fontName);

				this._fontFamily = v;

				if (this.dataController) {
					this.dataController.setValueForKeyPath(firstChoice, 'fontName', this);
				}
				else this.fontName = firstChoice;
				
			}
			else this._fontFamily = v;

			if (window._context && _context.undoManager.isUndoing) {
				_context.editor.refreshInspector();
			}
		}, get:function () { return this._fontFamily; }});
	

	Object.defineProperty(UILabel.prototype, "fontName", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_fontName")) Object.defineProperty(this, "_fontName", { writable: true, configurable: true });
			if (this._fontName === value) return;
			this._fontName = value;
			
			this.DOMNode.style.fontFamily = realIOSFont(value);
			this.applyFontChange();
		}, get:function () { return this._fontName; }});
	
	
	
	Object.defineProperty(UILabel.prototype, "textColor", {
	synthesized: true, 
	enumerable: true, 
		get: function () {
			return this._textColor;
		}, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_textColor")) Object.defineProperty(this, "_textColor", { writable: true, configurable: true });
			this._textColor = value;
			if (this.DOMNode) this.DOMNode.style.color = value||'';
		}});
	
	
	Object.defineProperty(UILabel.prototype, "textAlignment", {
	synthesized: true, 
	enumerable: true, 
		get: function () {
			if (!this.DOMNode) return;
			return this.DOMNode.style.textAlign;
		}, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_textAlignment")) Object.defineProperty(this, "_textAlignment", { writable: true, configurable: true });
			this._textAlignment = value;
			this.DOMNode.style.textAlign = value;
			if (this.floatingTextField) this.floatingTextField.textField.inputNode.style.textAlign = value;
		}});
	

	Object.defineProperty(UILabel.prototype, "CSSTextColor", {
		get: function () {
			return this.textColor;
		}, 
		set: function (value) {
			this.textColor = value;
		}});
	
	
	Object.defineProperty(UILabel.prototype, "shadowColor", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_shadowColor")) Object.defineProperty(this, "_shadowColor", { writable: true, configurable: true });
			this._shadowColor = value;
			this.updateShadow();
		}, get:function () { return this._shadowColor; }});
	

	Object.defineProperty(UILabel.prototype, "shadowOffsetX", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_shadowOffsetX")) Object.defineProperty(this, "_shadowOffsetX", { writable: true, configurable: true });
			this._shadowOffsetX = value;
			this.updateShadow();
		}, get:function () { return this._shadowOffsetX; }});
	

	Object.defineProperty(UILabel.prototype, "shadowOffsetY", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_shadowOffsetY")) Object.defineProperty(this, "_shadowOffsetY", { writable: true, configurable: true });
			this._shadowOffsetY = value;
			this.updateShadow();
		}, get:function () { return this._shadowOffsetY; }});
	
	
	Object.defineProperty(UILabel.prototype, "textIndent", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_textIndent")) Object.defineProperty(this, "_textIndent", { writable: true, configurable: true });
			this._textIndent = value;
			this.DOMNode.style.textIndent = value + 'px';
		}, get:function () { return this._textIndent; }});
	

	Object.defineProperty(UILabel.prototype, "numberOfLines", {
	enumerable: true, 
	synthesized: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_numberOfLines")) Object.defineProperty(this, "_numberOfLines", { writable: true, configurable: true });

			this._numberOfLines = value;

			if (value === 1) {
				this.style.call({ DOMNode: this._contentNode }, {
					whiteSpace: 'nowrap'
				});
			}
			else {
				this.style.call({ DOMNode: this._contentNode }, {
					whiteSpace: 'pre-wrap'
				});
				this.style({
					overflowY: 'hidden'
				});
			}
		}, get:function () { return this._numberOfLines; }});
	

	Object.defineProperty(UILabel.prototype, "layoutMode", {
	enumerable: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_layoutMode")) Object.defineProperty(this, "_layoutMode", { writable: true, configurable: true });
			this.heightIsEditable = (v !== 'autoFitHeight');
			this.numberOfLines = (v !== 'singleLine') ? 0 : 1;
			if (this._layoutMode === undefined)
				this._layoutMode = v;
			else {
				this._layoutMode = v;
				this.applyLayoutMode();
				if (this.autoFitWidth && this.numberOfLines !== 1)
					this.autoFitWidth = false;
				if (!this.heightIsEditable && this.autoresizingMask & 16) {
					if (this.dataController)
						this.dataController.setValueForKeyPath(this.autoresizingMask^16, 'autoresizingMask');
				}
			}
		}, get:function () { return this._layoutMode; }});
	
	
	Object.defineProperty(UILabel.prototype, "multiLine", {
		get: function () {
			return this.numberOfLines === 0 || this.numberOfLines > 1;
		}, 
		set: function (v) {
			this.numberOfLines = v ? 0 : 1;
		}});
	
	
	Object.defineProperty(UILabel.prototype, "shortedText", {
		get: function () {
			if (typeof this.text === 'number') return this.text+'';
			if (typeof this.text !== 'string') return '';
			if (this.text.length < 60) return this.text; return this.text.substr(0,50)+'…'; }});
	
	
	Object.defineProperty(UILabel.prototype, "readableValue", {
		get: function () {
			return this.name || this.shortedText || this.readableType;
		}});
	
	
	Object.defineProperty(UILabel.prototype, "readableType", {
		get: function () { return LocalizedString('Label'); }});
	

	Object.defineProperty(UILabel.prototype, "outlineIconURL", {
		get: function () {
			return this.context.pathForResource('UILabel.png')
		}});
	

	Object.defineProperty(UILabel.prototype, "autoFitWidth", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_autoFitWidth")) Object.defineProperty(this, "_autoFitWidth", { writable: true, configurable: true });
			this.widthIsEditable = !v;
			if (this._autoFitWidth === undefined) {
				this._autoFitWidth = v;
			}
			else {
				this._autoFitWidth = v;
				this.applyLayoutMode();
			}
		}, get:function () { return this._autoFitWidth; }});
	


	

// role EditableItem (appdoo.Editor) 
	
		Object.defineProperty(UILabel.prototype, "inspectorProperties", {
			get: function () {
	
				return [
			
					{
						type: 'group',
						title: LocalizedString('Label'),
						id: 'UILabelLayout',
						items: [
							{ name: LocalizedString('Name'), keyPath: 'e_name', placeholder: 'Name', undefinedValue:'', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
							{ type: 'color',
								keyPath: 'CSSTextColor', 
								undefinedValue: 'rgba(0, 0, 0, 1.00)',
								name: LocalizedString('Color'),
								forceLeftLabel: true
								},
						
							{ type: 'textAlignment' },
	
							{ name: LocalizedString('Text Height'), keyPath: 'layoutMode',
								type: 'select',
								options: [
									['autoFitHeight',LocalizedString('auto')],
									['multiLine',LocalizedString('multiline')],
									['singleLine',LocalizedString('single-line'),[
										{ type: 'boolean', keyPath: 'autoFitWidth', name: LocalizedString('Auto Width'), marginTop: -3 }
									]],
								],
								undefinedValue: 'multiLine',
							},
			
						]
					},

					{
						type: 'group',
						title: LocalizedString('Font'),
						id: 'UILabelFont',
						items: [
							{ type: 'font' },
							{ type: 'space' },
							{ type: 'fontSize' },
						]
					},

					{
						type: 'group',
						title: LocalizedString('Shadow'),
						id: 'UILabelShadow',
						items: [
			
							{ name: LocalizedString('Color'), keyPath: 'shadowColor', type: 'color',
								undefinedValue: 'rgba(0, 0, 0, 0)',
								forceLeftLabel: true },
							{ name: 'X', keyPath: 'shadowOffsetX', type: 'range',
								range: [-2,+2],
								undefinedValue: 0, marginTop: 2 },
							{ name: 'Y', keyPath: 'shadowOffsetY', type: 'range',
								range: [-2,+2],
								undefinedValue: 0 }
							
						]
					},
					
	
					{
						type: 'group',
						title: LocalizedString('Advanced'),
						id: 'UILabelAdvanced',
						items: [
			
							{ name: LocalizedString('Background Color'), keyPath: 'backgroundColor', type: 'color', undefinedValue: 'rgba(255,255,255, 0.00)' },
							{ name: LocalizedString('Highlighted Color'), keyPath: 'highlightedTextColor', type: 'color' },
						
							{ type: 'space' },
							{ name: LocalizedString('Opacity'), type: 'range', range:[0,100], keyPath: 'alpha100', undefinedValue: 100 },
						
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },

							{ type: 'space' },
							{ type: 'button', caption: LocalizedString('Create Button'), buttonWidth:LocalizedNumber('CREATE_BUTTON_BUTTON_WIDTH')+10, buttonStyle: 'flat', positionLeft: true, actionKeyPath: 'convertToButton', align:'left',positionLeft:true, hidden: _context.editor.viewIsInsideButton(this) },

			
						]
					},
					
			
				];
	
			}});
		

		Object.defineProperty(UILabel.prototype, "highlightedTextColor", {
		synthesized: true, 
		enumerable: true, get:function () { return this._highlightedTextColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_highlightedTextColor")) Object.defineProperty(this, "_highlightedTextColor", { writable: true, configurable: true }); this._highlightedTextColor = v; }});
		
	
		Object.defineProperty(UILabel.prototype, "bindableProperties", {
			get: function () {
				var result = clone(__super.prototype.bindableProperties);
				['text'].every(function (key) {
					result.unshift([key, this.readableNameForProperty(key)]);
					return true;
				}, this);
				return result;
			}});
		
	
UILabel.prototype.readableNameForProperty = function UILabel__readableNameForProperty(propertyName) {

			switch (propertyName) {
				case 'text': return LocalizedString('Text');
				case 'CSSTextColor': return LocalizedString('Text Color');
				case 'backgroundColor': return LocalizedString('Background Color');
				case 'fontSize': return LocalizedString('Font Size');
			}
		
			return __super.prototype.readableNameForProperty.call(this, propertyName);
		};
		
			
UILabel.prototype.prepareForEditor = function UILabel_prepareForEditor(editor) {
	
		__super.prototype.prepareForEditor.call(this, editor);
	
		if (this.DOMNode)
		this.DOMNode.ondblclick = function () {
		
			if (editor.editedSubview === this.superview) {
				this.editDefault(editor);
			}
					
		}.bind(this);
};
	
			
UILabel.prototype.editDefault = function UILabel_editDefault(editor, dataController, keyPath) {
		
		if (this.hasBindingForKey('text')) {
			this.context.beep();
			return true;
		}

		var obj = this,
			containerView = editor.contentFrameController.containerView,
			textFieldStyle = this.encode().style || {},
			textFieldPosition = {
				left: -this.getRelativeX(0, containerView),
				top: -this.getRelativeY(0, containerView)
					  + this._contentNode.offsetTop
			};

		if (this.layoutMode === 'multiLine' || this.layoutMode === 'autoFitHeight') textFieldPosition.left -= 1;

		textFieldStyle.fontSize = this.fontSize+'px';
		textFieldStyle.fontFamily = realIOSFont(this.fontName || '_DEFAULT_');
		textFieldStyle.zIndex = 100;
		textFieldStyle.textAlign = this.textAlignment||'left';
		textFieldStyle.lineHeight = this.DOMNode.style.lineHeight;
		textFieldStyle.webkitTransform = this.DOMNode.style.webkitTransform;
		delete textFieldStyle.color;
		delete textFieldStyle.textShadow;
		delete textFieldStyle.backgroundColor;
		
		if (textFieldStyle.textAlign === 'center') textFieldPosition.left -= 1;
		if (textFieldStyle.textAlign === 'right') textFieldPosition.left -= 2;
		if (textFieldStyle.textAlign === 'center' && !this.multiLine)
			textFieldPosition.left += Math.ceil(this.size.width/2)+1;

		var ftf = createComponentFromDomain('FloatingTextField', 'Core.UI', editor.context, {
			style: textFieldStyle,
			position: textFieldPosition,
			text: (dataController || this.dataController).get(keyPath||'text'),
			maximumWidth: this.size.width,
			multiLine: this.multiLine,
			size: this.size,
			delegate: {
				textFieldDidBeginEditing: function (textField) {
					this._contentNode.style.visibility = 'hidden';
					editor.hideManipulator();
				}.bind(this),
				textFieldDidEndEditing: function (textField) {
					var v = textField.value;
					(dataController || this.dataController).setValueForKeyPath(v, keyPath||'text');
					this._contentNode.style.visibility = '';
					editor.showManipulator();
					this.floatingTextField = null;
				}.bind(this)
			}
		});

		containerView.addSubview(ftf);
		this.floatingTextField = ftf;
		
		return true;};
	
		
	Object.defineProperty(UILabel.prototype, "floatingTextField", {
	synthesized: true, get:function () { return this._floatingTextField; }, set:function (v) {if (!Object.hasOwnProperty(this, "_floatingTextField")) Object.defineProperty(this, "_floatingTextField", { writable: true, configurable: true }); this._floatingTextField = v; }});
	
			
UILabel.prototype.createForSuperview = function UILabel_createForSuperview(superview) {
		var size = { width: 180, height: 22 };
		if (superview.size.width < size.width)
			size.width = Math.max(superview.size.width-30, 20);
		
		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			superview.context,
			{
				text: 'Text',
				fontSize: 17,
				fontFamily: "System",
				fontName : "_DEFAULT_",
				size: size,
				autoresizingMask: 36,
				layoutMode: 'multiLine'
			}
		);};
	
		
UILabel.prototype.undoNameForKeyPaths = function UILabel_undoNameForKeyPaths(keyPaths) {

		var name = __super.prototype.undoNameForKeyPaths.call(this, keyPaths);
		if (name) return name;
		
		var propertyNames = {
			'text': 'Text',
			'CSSTextColor': 'Color',
			'DOMNode.style.textAlign': 'Alignment',
			'fontFamily': 'Font',
			'fontSize': 'Font Size',
			'shadowColor': 'Shadow Color',
			'shadowOffsetX': 'Shadow X-Offset',
			'shadowOffsetY': 'Shadow Y-Offset',
			'layoutMode': 'Text Height'
		};
		
		for (keyPath in propertyNames) {
			if (keyPaths.indexOf(keyPath) !== -1)
				return LocalizedString1('Change %1', LocalizedString(propertyNames[keyPath]));
		}
};
	
	
	

	Object.defineProperty(UILabel.prototype, "widthIsEditable", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_widthIsEditable")) Object.defineProperty(this, "_widthIsEditable", { writable: true, configurable: true });
			if (this.widthIsEditable === v) return;
			this._widthIsEditable = v;
			if (this.dataController) {
				this.dataController.setValueForKeyPath(v, 'widthIsEditable', null, false);
			}
		}, get:function () { return this._widthIsEditable; }});
	
	
UILabel.prototype.applyFontChange = function UILabel__applyFontChange() {
		var change = {
			type: 'change',
			object: this,
		};
		
		
		this.DOMNode.style.lineHeight = this.lineHeightForFontAndSize(realIOSFont(this._fontName), this._fontSize);
		this.applyLayoutMode();
	};
	


UILabel.prototype.applyLayoutMode = function UILabel__applyLayoutMode() {
	
		if (this.layoutMode === 'autoFitHeight') {	
			
			var h = this.heightForTextWithAttributes(this.text, {
				fontFamily: this.DOMNode.style.fontFamily,
				fontSize: this.fontSize,
				width: this.size.width
			});
			
			this.setValueWithoutUndoSupport(h, 'size.height');
			
		}
		else if (this.layoutMode === 'singleLine') {
		
			if (this.autoFitWidth) {

				var w = this.widthForTextWithAttributes(this.text, {
					fontFamily: this.DOMNode.style.fontFamily,
					fontSize: this.fontSize,
					width: this.size.width
				});

				this.setValueWithoutUndoSupport(w+1, 'size.width');
			
			}
			
		}
		};
	
	
UILabel.prototype.setValueWithoutUndoSupport = function UILabel__setValueWithoutUndoSupport(value, keyPath) {
		if (window._context)
			window._context.editor.setValueWithoutUndoSupport(this, value, keyPath);
	};
	
	
UILabel.prototype.viewDidResize = function UILabel_viewDidResize() {
	
		var widthDidChange = (this._lastStableContentSize.width !== this._size.width);

		__super.prototype.viewDidResize.call(this);
		
		if (widthDidChange)
			this.applyLayoutMode();
		};
	
	
UILabel.prototype.heightForTextWithAttributes = function UILabel_heightForTextWithAttributes(text, attributes) {
		var node = document.createElement('div');
		node.style.fontFamily = attributes.fontFamily||realIOSFont('_DEFAULT_');
		node.style.fontSize = attributes.fontSize+'px';
		node.style.width = attributes.width+'px';
		node.style.whiteSpace = this._contentNode.style.whiteSpace;
		node.style.wordWrap = this._contentNode.style.wordWrap;
		node.style.lineHeight = this.lineHeightForFontAndSize(attributes.fontFamily, attributes.fontSize);
		node.textContent = text;
		document.body.appendChild(node);

		
		var h = node.offsetHeight; 
		
		document.body.removeChild(node);
		return h;};
	
	
UILabel.prototype.widthForTextWithAttributes = function UILabel_widthForTextWithAttributes(text, attributes) {
		if (!attributes.fontFamily) attributes.fontFamily = realIOSFont('_DEFAULT_');
		if (typeof attributes.fontSize === 'number') attributes.fontSize += 'px';
		if (!attributes.lineHeight && attributes.fontFamily && attributes.fontSize)
			attributes.lineHeight = this.lineHeightForFontAndSize(attributes.fontFamily, attributes.fontSize);
		return widthForTextWithAttributes(text, attributes);};
	
		
UILabel.prototype.lineHeightForFontAndSize = function UILabel_lineHeightForFontAndSize(name, size) {
		var n = this.context.nativeProxy.sendMessage('iOSLineHeightForFont', name, size);
		if (!n) return '';
		return parseInt(n)+'px';};
	
	
	Object.defineProperty(UILabel.prototype, "widthToFit", {
		get: function () {
			return this.widthForTextWithAttributes(this.text, {
				fontFamily: this.DOMNode.style.fontFamily,
				fontSize: this.fontSize,
				whiteSpace: this._contentNode.style.whiteSpace,
			});
		}});
	

UILabel.prototype.heightToFitWidth = function UILabel__heightToFitWidth(width) {
		return this.heightForTextWithAttributes(this.text, {
			width: width,
			fontFamily: this.DOMNode.style.fontFamily,
			fontSize: this.fontSize,
			whiteSpace: this._contentNode.style.whiteSpace,
			wordWrap: this._contentNode.style.wordWrap,
		});};
	
	
	
	
	
	Object.defineProperty(UILabel.prototype, "font", {
		get: function () {
			var font = createComponentFromDomain("UIFont", "appdoo.iOS", this.context, {})
			;
			font.fontFamily = this.fontFamily;
			font.fontName = this.fontName;
			font.pointSize = this.fontSize;
			return font;
		}, 
		set: function (v) {
			this.fontFamily = v.fontFamily;
			this.fontName = v.fontName;
			this.pointSize = v.pointSize;
		}});
	

	Object.defineProperty(UILabel.prototype, "fontStyle", {
		get: function () { return this.fontName.substr(this.fontName.indexOf('-')+1); }});
	

UILabel.prototype.convertToButton = function UILabel_convertToButton() {
		return _context.editor.convertItemsToButton([this]);};
	

UILabel.prototype.readableValueDidChange = function UILabel__readableValueDidChange() {
		__super.prototype.readableValueDidChange.call(this);
		if (this.superview && this.superview.UTI === 'info.appdoo-mac.ButtonWithSubviews')
			this.superview.readableValueDidChange();};
	

	Object.defineProperty(UILabel.prototype, "nameIsEditable", {
		get: function () {
			return true;
		}});
	

UILabel.prototype.specialDataToCopyWithEditor = function UILabel_specialDataToCopyWithEditor(editor) {
		return {'public.utf8-plain-text': this.text};};
	

UILabel.prototype.initPropertiesFromData = function UILabel_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("autoFitWidth")) this.autoFitWidth = data.autoFitWidth;
};

UILabel.prototype.decodeData = function UILabel_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

UILabel.prototype.encode = function UILabel_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

UILabel.prototype.encodeCloned = function UILabel_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

UILabel.prototype.expectedTypeForProperty = function UILabel_expectedTypeForProperty(key) {
	if (key === "text") return "String";
	if (key === "fontSize") return "Number";
	if (key === "fontFamily") return "String";
	if (key === "fontName") return "String";
	if (key === "textColor") return "String";
	if (key === "textAlignment") return "String";
	if (key === "CSSTextColor") return "String";
	if (key === "shadowColor") return "String";
	if (key === "shadowOffsetX") return "Number";
	if (key === "shadowOffsetY") return "Number";
	if (key === "textIndent") return "Number";
	if (key === "numberOfLines") return "Number";
	if (key === "layoutMode") return "String";
	if (key === "multiLine") return "Boolean";
	if (key === "shortedText") return "String";
	if (key === "readableValue") return "String";
	if (key === "readableType") return "String";
	if (key === "outlineIconURL") return "String";
	if (key === "autoFitWidth") return "Boolean";
	if (key === "inspectorProperties") return "";
	if (key === "highlightedTextColor") return "String";
	if (key === "bindableProperties") return "";
	if (key === "floatingTextField") return "";
	if (key === "widthIsEditable") return "";
	if (key === "widthToFit") return "";
	if (key === "font") return "";
	if (key === "fontStyle") return "";
	if (key === "nameIsEditable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UILabel; }()));