
registerType('appdoo.iOS', (function () { function UIBar() {} var __super = setSupertypeFromDomain(UIBar, 'UIView', 'appdoo.iOS');

	
	Object.defineProperty(UIBar.prototype, "barStyle", {
	outlet: true, 
	enumerable: true, get:function () { return this._barStyle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_barStyle")) Object.defineProperty(this, "_barStyle", { writable: true, configurable: true }); this._barStyle = v; }});
	

	Object.defineProperty(UIBar.prototype, "translucent", {
	outlet: true, 
	enumerable: true, get:function () { return this._translucent; }, set:function (v) {if (!Object.hasOwnProperty(this, "_translucent")) Object.defineProperty(this, "_translucent", { writable: true, configurable: true }); this._translucent = v; }});
	

	Object.defineProperty(UIBar.prototype, "tintColor", {
	outlet: true, 
	enumerable: true, get:function () { return this._tintColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_tintColor")) Object.defineProperty(this, "_tintColor", { writable: true, configurable: true }); this._tintColor = v; }});
	
	
	Object.defineProperty(UIBar.prototype, "barTintColor", {
	outlet: true, 
	enumerable: true, get:function () { return this._barTintColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_barTintColor")) Object.defineProperty(this, "_barTintColor", { writable: true, configurable: true }); this._barTintColor = v; }});
	

	Object.defineProperty(UIBar.prototype, "e_barStyle", {
		get: function ( ) { return this.barStyle; }, 
		set: function (v) { this.barStyle = v; this.styleDefault(); _context.editor.contentFrameController.updateStatusBar(); }});
	

	Object.defineProperty(UIBar.prototype, "e_translucent", {
		get: function ( ) { return this.translucent; }, 
		set: function (v) { this.translucent = v; this.styleDefault(); _context.editor.contentFrameController.needsWindowLayout(); }});
	

	Object.defineProperty(UIBar.prototype, "e_tintColor", {
		get: function ( ) { return this.tintColor || this.context.defaultOrSystemTintColor; }, 
		set: function (v) { this.tintColor = v; this.styleDefault();
			this.updateSubviewsForTintColor();
		}});
	
	
	Object.defineProperty(UIBar.prototype, "e_barTintColor", {
		get: function ( ) { return this.barTintColor; }, 
		set: function (v) { this.barTintColor = v; this.styleDefault(); }});
	

	Object.defineProperty(UIBar.prototype, "e_backgroundImage", {
		get: function ( ) { return this.v_backgroundImage; }, 
		set: function (v) { this.v_backgroundImage = v; this.styleDefault();  }});
	


	Object.defineProperty(UIBar.prototype, "e_barStyleIsBlack", {
		get: function () { return this.barStyle === UIBarStyleBlack; }, 
		set: function (v) { this.e_barStyle = v ? UIBarStyleBlack : UIBarStyleDefault; }});
	

UIBar.prototype.initPropertiesFromData = function UIBar_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("barStyle")) this.barStyle = data.barStyle;
if (data.hasOwnProperty("translucent")) this.translucent = data.translucent;
if (data.hasOwnProperty("tintColor")) this.tintColor = data.tintColor;
if (data.hasOwnProperty("barTintColor")) this.barTintColor = data.barTintColor;
};

UIBar.prototype.decodeData = function UIBar_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

UIBar.prototype.encode = function UIBar_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

UIBar.prototype.encodeCloned = function UIBar_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

UIBar.prototype.expectedTypeForProperty = function UIBar_expectedTypeForProperty(key) {
	if (key === "barStyle") return "Number";
	if (key === "translucent") return "Boolean";
	if (key === "tintColor") return "String";
	if (key === "barTintColor") return "String";
	if (key === "e_barStyle") return "Boolean";
	if (key === "e_translucent") return "Boolean";
	if (key === "e_tintColor") return "Boolean";
	if (key === "e_barTintColor") return "Boolean";
	if (key === "e_backgroundImage") return "Boolean";
	if (key === "e_barStyleIsBlack") return "Boolean";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIBar; }()));
registerType('appdoo.iOS', (function () { function UINavigationBar() {} var __super = setSupertypeFromDomain(UINavigationBar, 'UIBar', 'appdoo.iOS');

	Object.defineProperty(UINavigationBar.prototype, "title", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_title")) Object.defineProperty(this, "_title", { writable: true, configurable: true });
			this._title = v; if (this.titleLabel) this.titleLabel.text = v;
		}, get:function () { return this._title; }});
	

	Object.defineProperty(UINavigationBar.prototype, "nameIsEditable", {
		value: false});
	

	Object.defineProperty(UINavigationBar.prototype, "items", {
	outlet: true, 
	enumerable: true, get:function () { return this._items; }, set:function (v) {if (!Object.hasOwnProperty(this, "_items")) Object.defineProperty(this, "_items", { writable: true, configurable: true }); this._items = v; }});
	

	Object.defineProperty(UINavigationBar.prototype, "v_backgroundImage", {
	outlet: true, 
	enumerable: true, get:function () { return this._v_backgroundImage; }, set:function (v) {if (!Object.hasOwnProperty(this, "_v_backgroundImage")) Object.defineProperty(this, "_v_backgroundImage", { writable: true, configurable: true }); this._v_backgroundImage = v; }});
	

	Object.defineProperty(UINavigationBar.prototype, "v_titleViewImage", {
	outlet: true, 
	enumerable: true, get:function () { return this._v_titleViewImage; }, set:function (v) {if (!Object.hasOwnProperty(this, "_v_titleViewImage")) Object.defineProperty(this, "_v_titleViewImage", { writable: true, configurable: true }); this._v_titleViewImage = v; }});
	
	
	
	

	Object.defineProperty(UINavigationBar.prototype, "e_title", {
		get: function ( ) { if (this.title === _context.editor.editedViewController.title) return ''; return this.title; }, 
		set: function (v) {
			this.title = v || _context.editor.editedViewController.title;
		}});
	

	Object.defineProperty(UINavigationBar.prototype, "e_titleViewImage", {
		get: function ( ) { return this.v_titleViewImage; }, 
		set: function (v) {
			this.v_titleViewImage = v;
			this.styleDefault();
		}});
	


	Object.defineProperty(UINavigationBar.prototype, "topItem", {
		get: function () {
			
			if (this.items) return this.items[0]; 
		}});
	
	
	Object.defineProperty(UINavigationBar.prototype, "defaultBarHeight", {
		get: function () {
			return this.context.simulatedSystemVersion < 7 ? 44 : 64;
		}});
	

	var defaultFontFamily = 'System',
		defaultFontName = '_DEFAULT_BOLD_',
		defaultPointSize = 17;

UINavigationBar.prototype.init = function UINavigationBar_init() {
	
		__super.prototype.init.call(this);

		this.size = {
			width: this.size.width || 320,
			height: this.defaultBarHeight
		};

		if (this.topItem) this.topItem.navigationBar = this;

		this.mergeBindings();
		
		return this;
};
	
	
UINavigationBar.prototype.prepareForNavigation = function UINavigationBar_prepareForNavigation() {
		this.prepareFromTopItem();};
	


	
	
	
UINavigationBar.prototype.mergeBindings = function UINavigationBar__mergeBindings() {
		if (!this.topItem) return;
		var titleBinding = this.topItem.bindingForKey('title');
		if (!titleBinding) return;
		this.addBinding(titleBinding);};
	
	
	
	
UINavigationBar.prototype.splitBindingsInData = function UINavigationBar__splitBindingsInData(data) {

		var titleBinding = this.bindingForKey.call(data, 'title');

		if (titleBinding) {

			data.bindings.splice(data.bindings.indexOf(titleBinding), 1);

			
			
			var navItemTitleBinding = this.bindingForKey.call(data.items[0], 'title');
			if (navItemTitleBinding) {
				data.items[0].bindings.splice(data.items[0].bindings.indexOf(navItemTitleBinding), 1);
			}

			if (!data.items[0].bindings) {
				data.items[0].bindings = [];
			}
			
			data.items[0].bindings.push(titleBinding);

		}
		else {
			var navItemTitleBinding = this.bindingForKey.call(data.items[0], 'title');
			if (navItemTitleBinding) {
				data.items[0].bindings.splice(data.items[0].bindings.indexOf(navItemTitleBinding), 1);
			}
		}};
	
	
UINavigationBar.prototype.createTitleLabel = function UINavigationBar__createTitleLabel() {

		
		
		Object.defineProperty(this, "titleLabel", {
			value: createComponentFromDomain(
				'Label', "Core.UI", this.context,
				this.getTitleLabelProperties(this.size))});
		
		
		this.addSubview(this.titleLabel);
		if (this.title) this.titleLabel.text = this.title;
};
	

UINavigationBar.prototype.getTitleLabelProperties = function UINavigationBar__getTitleLabelProperties(size, isSmall) {
		if (this.context.simulatedSystemVersion <= 6)
			return this.getTitleLabelPropertiesSystem6(size, isSmall);
		else
			return this.getTitleLabelPropertiesSystem7(size, isSmall);};
	

UINavigationBar.prototype.getTitleLabelPropertiesSystem6 = function UINavigationBar__getTitleLabelPropertiesSystem6(size, isSmall) {
		var fontSize = isSmall ? 16 : 20,
			height = Math.max(size.height-17, 22);

		return {
			position: { left: 15, top: parseInt(size.height/2 - height/2)+1 },
			size: { width: size.width-30, height: height },
			fontSize: fontSize,
			style: {
				color: '#fff',
				fontFamily: 'HelveticaNeue-Bold',
				textShadow: '0 -1px 0 rgba(0,0,0,.4)',
				textAlign: 'center',
			},
			numberOfLines: 1
		};};
	

UINavigationBar.prototype.getTitleLabelPropertiesSystem7 = function UINavigationBar__getTitleLabelPropertiesSystem7(size, isSmall) {

		var fontSize = this.usesCustomFont ? this.font.pointSize : defaultPointSize,
			color = this.usesCustomFont && this.labelColor ? this.labelColor : (this.barStyle === UIBarStyleBlack ? '#fff' : '#000'),
			height = 22;

		return {
			position: { left: 15, top: parseInt(size.height/2 - height/2)+10-(isSmall?1:0) },
			size: { width: size.width-30, height: height },
			fontSize: fontSize,
			style: {
				color: color,
				fontFamily: this.usesCustomFont ? realIOSFont(this.font.fontName) : realIOSFont(defaultFontName),
				fontSize: fontSize+'px',
				textShadow: '',
				textAlign: 'center',
				overflow: 'hidden',
				textOverflow: 'ellipsis',
				whiteSpace: 'nowrap'
			},
			numberOfLines: 1
		};};
	
	
UINavigationBar.prototype.prepareFromTopItem = function UINavigationBar__prepareFromTopItem() {
		if (!this.topItem) return;

		this.addBarButtonsFromTopItem();

		if (this.topItem.v_titleViewImage) {
			this.v_titleViewImage = this.topItem.v_titleViewImage;
		}};
	
	
UINavigationBar.prototype.addBarButtonsFromTopItem = function UINavigationBar__addBarButtonsFromTopItem() {
		function helper(navigationItem, key, bar) {
			var items = navigationItem[key];
			if (Array.isArray(items)) items.every(function (item) {
				bar.addSubview(item.view);
				item.updateView();return true; }, this);
			
		}
		
		helper(this.topItem, 'leftBarButtonItems', this);
		helper(this.topItem, 'rightBarButtonItems', this);};
	
	
	

UINavigationBar.prototype.update = function UINavigationBar__update() {
		this.prepareFromTopItem();};
	


	

UINavigationBar.prototype.encode = function UINavigationBar_encode() {
		var data = __super.prototype.encode.call(this);
		this.splitBindingsInData(data);
		return data;};
	;
	
	Object.defineProperty(UINavigationBar.prototype, "encodesSubviews", {
		value: false});
	


	
	
	Object.defineProperty(UINavigationBar.prototype, "titleImageView", {
	synthesized: true, 
		get: function () {
			if (!this._titleImageView) {
				var iv = createComponentFromDomain("UIImageView", "appdoo.iOS", this.context, {
					size: { width: this.size.width, height: this.size.height - 20},
					style: { pointerEvents: 'none' }})
				;
				this.addSubview(iv);
				this.titleImageView = iv;
			}
			return this._titleImageView;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_titleImageView")) Object.defineProperty(this, "_titleImageView", { writable: true, configurable: true }); this._titleImageView = v; }});
	
	
	Object.defineProperty(UINavigationBar.prototype, "hasTitleImage", {
		get: function () { return this.v_titleViewImage && this.v_titleViewImage.imageID; }});
	
	
UINavigationBar.prototype.styleDefault = function UINavigationBar_styleDefault() {
	
		getType('appdoo.iOS.StyleDecorator').prototype.styleBar(this, this.context.simulatedSystemVersion);
		this.styleTitleLabel();

		var hasTitleViewImage = this.hasTitleImage;

		this.titleLabel.hidden = hasTitleViewImage;
		this.titleImageView.hidden = !hasTitleViewImage;
		this.titleImageView.imageRef = this.v_titleViewImage;
		
		function helper(key) {
			var items = this.topItem[key];
			if (Array.isArray(items)) items.every(function (item) {
				item.styleDefault();return true; }, this);
			
		}
		
		helper.call(this, 'leftBarButtonItems');
		helper.call(this, 'rightBarButtonItems');

		this.layoutSubviews();};
	
	
UINavigationBar.prototype.styleTitleLabel = function UINavigationBar__styleTitleLabel() {
		var titleLabelProperties = this.getTitleLabelProperties(this.size);
		for (var key in titleLabelProperties) {
			if (key === 'style') this.titleLabel.style(titleLabelProperties[key]);
			else this.titleLabel[key] = titleLabelProperties[key];
		}};
	
	
UINavigationBar.prototype.renderBackground = function UINavigationBar__renderBackground() {

		if (!this.v_backgroundImage) {
			if (this.backgroundImageCanvas) {
				this.DOMNode.removeChild(this.backgroundImageCanvas);
				this.backgroundImageCanvas = null;
			}
			return;
		}

		var width = this.size.width || 320;

		if (!this.backgroundImageCanvas) {
			Object.defineProperty(this, "backgroundImageCanvas", {
			writable: true, 
				value: document.createElement('canvas')});
			
			this.DOMNode.appendChild(this.backgroundImageCanvas);
		}
		this.backgroundImageCanvas.height = this.defaultBarHeight*2;
		this.backgroundImageCanvas.style.height = this.size.height+'px';
		this.backgroundImageCanvas.width = width*2;
		this.backgroundImageCanvas.style.width = width+'px';
		
		var ctx = this.backgroundImageCanvas.getContext('2d');
		var imagePath = this.context.nativeProxy.sendMessage('pathForImageWithID', this.v_backgroundImage.imageID);

		this.context.whenImageIsReady(imagePath, function (img) {

			var height = this.defaultBarHeight;

			
			
			if (img.height == 88) {
				ctx.clearRect(0,0,width*2,height*2);
				var offsetY = this.context.simulatedSystemVersion < 7 ? 0 : 40;
				ctx.drawImage(img,0,offsetY,width*2,88);
			}
			
			
			
			else {
				ctx.drawImage(img,0,0,width*2,img.height);
				
				var destinationRect = [0,0,width*2,2],
					sourceRect = [0,img.height-2,img.width,2];

				for (var i = img.height, c = height*2; i < c; i += 2) {
					
					destinationRect[1] = i;
					
					ctx.drawImage(img,

						sourceRect[0], 
						sourceRect[1], 
						sourceRect[2], 
						sourceRect[3], 
						
						destinationRect[0], 
						destinationRect[1], 
						destinationRect[2], 
						destinationRect[3] 

					);
				}
			}
		}.bind(this));};
	


	
	

UINavigationBar.prototype.editDefault = function UINavigationBar_editDefault(editor) {
	
		if (this.hasBindingForKey('title')) return false;

		var textFieldStyle = this.titleLabel.encode().style;
		if (!textFieldStyle.fontFamily)
			textFieldStyle.fontFamily = realIOSFont('_DEFAULT_');
		textFieldStyle.zIndex = 100;
		delete textFieldStyle.color;
		delete textFieldStyle.textShadow;
		delete textFieldStyle.overflowX;
		delete textFieldStyle.overflowY;
		textFieldStyle.cursor = 'text';
		textFieldStyle.pointerEvents = 'all';

		var ftf = createComponentFromDomain('FloatingTextField', 'Core.UI', editor.context, {
			style: textFieldStyle,
			position: {
				left: this.size.width/2,
				top: this.titleLabel.position.top
			},
			text: this.titleLabel.text,
			delegate: {
				textFieldDidBeginEditing: function (textField) {
					this.titleLabel.hidden = true;
				}.bind(this),
				textFieldDidEndEditing: function (textField) {
					var v = textField.value;
					if (v !== this.title) {
						if (_context.editor.editedViewController.title === this.title) {
							_context.editor.editedScene.dataController.setValueForKey(v, 'e_title', _context.editor.editedScene.dataController);
						}
						else this.dataController.set({ e_title: v });
					}
					this.titleLabel.hidden = false;
				}.bind(this)
			}
		});

		editor.contentFrameController.containerView.addSubview(ftf);
		
		return true; 
};
	
	
UINavigationBar.prototype.setBarButtonItem = function UINavigationBar__setBarButtonItem(keyPath, item) {
		
		if (this['_'+keyPath] && this['_'+keyPath].superview) this['_'+keyPath].removeFromSuperview(true);
		this['_'+keyPath] = item;
		
		if (!item || !item.view) return;

		this.addSubview(item.view);
		
		this.layoutSubviews();
		
		item.navigationBar = this;
		};
	
	
	Object.defineProperty(UINavigationBar.prototype, "shouldDisplaySlim", {
		get: function () {
			if (!window._context || !_context.editor || !_context.editor.editedScene) return;
			return this.context.simulatedDeviceIsIPhone && _context.editor.editedScene.simulatedInterfaceOrientation === 'landscape';
		}});
	
	
UINavigationBar.prototype.layoutSubviews = function UINavigationBar_layoutSubviews() {

		__super.prototype.layoutSubviews.call(this);
		
		var isSystem7 = this.context.simulatedSystemVersion >= 7;
		var statusBarInset = isSystem7 ? 21 : 0;
		var maxButtonWidth = 0;

		var height = this.defaultBarHeight;
		var shouldBeSlim = this.shouldDisplaySlim;
		if (shouldBeSlim) {
			height -= 12;
		}
		if (this.size.height !== height) {
			this.size.height = height;
		}
		

		var x = 0;
		if (Array.isArray(this.topItem.leftBarButtonItems)) this.topItem.leftBarButtonItems.every(function (barButtonItem) {
			
			if (barButtonItem.view) {
				x += barButtonItem.defaultPadding;
	
				barButtonItem.view.size.height = this.heightForBarButtonItems;
				barButtonItem.view.layoutSubviews();
				barButtonItem.view.position = {
					left: x,
					top: (this.size.height-statusBarInset)/2 - barButtonItem.view.size.height/2 + statusBarInset
				};
				maxButtonWidth = Math.max(maxButtonWidth, barButtonItem.view.size.width);
				
				x += barButtonItem.view.size.width + barButtonItem.defaultPadding;
			}
			else {
				console.warn('The left-sided navigation item has no view:', barButtonItem);
			}return true; }, this);
		

		var x = this.size.width;

		if (Array.isArray(this.topItem.rightBarButtonItems)) this.topItem.rightBarButtonItems.every(function (barButtonItem) {

			if (barButtonItem.view) {
				x -= barButtonItem.defaultPadding + barButtonItem.view.size.width;

				barButtonItem.view.size.height = this.heightForBarButtonItems;
				barButtonItem.view.layoutSubviews();
				barButtonItem.view.position = {
					left: x,
					top: (this.size.height-statusBarInset)/2 - barButtonItem.view.size.height/2 + statusBarInset
				};
				maxButtonWidth = Math.max(maxButtonWidth, barButtonItem.view.size.width);

				x -= barButtonItem.defaultPadding;
			}
			else {
				console.warn('The right-sided navigation item has no view:', barButtonItem);
			}return true; }, this);
		
		
		if (this.hasTitleImage) {
			var top = Math.round((this.size.height-(statusBarInset))/2 - this.titleImageView.size.height/2);
			if (statusBarInset) top += statusBarInset-1;
			this.titleImageView.position.top = top;
		}
		this.titleImageView.size.width = this.size.width;
		
		if (this.titleLabel) {
			var p = this.getTitleLabelProperties(this.sizeCopy, shouldBeSlim);
			this.titleLabel.size = {
				height: p.size.height,
				width: Math.max(p.size.width-maxButtonWidth*2+20,0)
			}
			this.titleLabel.position = {
				top: p.position.top,
				left: this.size.width/2-this.titleLabel.size.width/2
			};
			this.titleLabel.fontSize = p.fontSize;
		}
		
		this.renderBackground();};
	
	
UINavigationBar.prototype.updateTitleLabel = function UINavigationBar__updateTitleLabel() {
		this.titleLabel.size.width = this.size.width-98*2;
		this.titleLabel.position.left = 98;};
	
	

	Object.defineProperty(UINavigationBar.prototype, "readableValue", {
		get: function () { return LocalizedString('Navigation Bar') }});
	
	
	Object.defineProperty(UINavigationBar.prototype, "e_isVisible", {
		get: function ( ) { return !this.hidden; }, 
		set: function (v) { _context.editor.editedScene.e_showsNavigationBar = v; }});
	
	
	
	Object.defineProperty(UINavigationBar.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: LocalizedString('Navigation Bar'),
					id: 'UINavigationBar',
					items: [

						{ name: 'Title', keyPath: 'e_title', type: 'text', placeholder: LocalizedString('use Screen Title') },
						{ name: LocalizedString('Title Image'), type: 'image', keyPath: 'e_titleViewImage', height: 48-8-8, wantsRetinaImage: true },
						{ type: 'space' },
						{ name: LocalizedString('Translucent'), keyPath: 'e_translucent', type: 'boolean',alignLabel:true },
						{ name: LocalizedString('Dark style'), keyPath: 'e_barStyleIsBlack', type: 'boolean',alignLabel:true, hidden: false },

						{ type: 'space' },
						{ name: LocalizedString('Tint Color'), keyPath: 'e_tintColor', type: 'color' },
						{ name: LocalizedString('Background Color'), keyPath: 'e_barTintColor', type: 'color', undefinedValue: '', hidden: false },

						{ type: 'space' },
						{ name: LocalizedString('Background Image'), type: 'image', keyPath: 'e_backgroundImage', height: 64 },

					]
				},
				{
					type: 'group',
					title: LocalizedString('Font'),
					id: this.constructor.name+'Font',
					items: [
						{ type: 'boolean', name: LocalizedString('Change Default Font'), positionLeft: true, keyPath: 'usesCustomFont' },
						{ type: 'space', hidden: !this.usesCustomFont },
						{ type: 'font', hidden: !this.usesCustomFont },
						{ type: 'space', hidden: !this.usesCustomFont },
						{ type: 'fontSize', keyPath: 'fontSize', hidden: !this.usesCustomFont },
						{ type: 'color', name: LocalizedString('Color'), keyPath: 'labelColor', hidden: !this.usesCustomFont }
					]
				},
			];
		}});
	
	
	
	Object.defineProperty(UINavigationBar.prototype, "widthIsEditable", {
		value: false});
	

	Object.defineProperty(UINavigationBar.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(UINavigationBar.prototype, "xIsEditable", {
		value: false});
	

	Object.defineProperty(UINavigationBar.prototype, "yIsEditable", {
		value: false});
	

	Object.defineProperty(UINavigationBar.prototype, "positionIsEditable", {
		value: false});
	

	Object.defineProperty(UINavigationBar.prototype, "sizeIsEditable", {
		value: false});
	
	
	Object.defineProperty(UINavigationBar.prototype, "autoresizingMaskIsEditable", {
		value: false});
	

	Object.defineProperty(UINavigationBar.prototype, "canHaveLayoutRelations", {
		value: false});
	
	
	
	

	Object.defineProperty(UINavigationBar.prototype, "navigationBarTitle", {
	synthesized: true, 
	observable: true, get:function () { return this._navigationBarTitle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_navigationBarTitle")) Object.defineProperty(this, "_navigationBarTitle", { writable: true, configurable: true }); this._navigationBarTitle = v; this.context.broadcastValueChangeForKeyPathInObject("navigationBarTitle", this, this);}});
	

UINavigationBar.prototype.setNavigationBarType = function UINavigationBar__setNavigationBarType(type, tintColor, backgroundImage) {
	
		if (type === 'translucent') {
			this.navigationBar.hasDefaultColor = false;
			this.navigationBar.backgroundImage = null;
		}
		else if (type === 'default') {
			this.navigationBar.hasDefaultColor = true;
			this.navigationBar.backgroundImage = null;
		}
		else {
			this.navigationBar.hasDefaultColor = false;
			this.navigationBar.tintColor = tintColor;
			this.navigationBar.backgroundImage = backgroundImage;
		}

};
	

UINavigationBar.prototype.propertyIsShared = function UINavigationBar__propertyIsShared(key) {
		return globalSettings[key] === this[key];};
	

	

	var defaultNavigationBarTint = 'rgb(27,91,175)',
		globalSettings = { navigationBarType: 'default', navigationBarTintColor: defaultNavigationBarTint };

UINavigationBar.prototype.setGlobalSettingsWithContext = function UINavigationBar_setGlobalSettingsWithContext(v, context) {
		for (key in v) {
			if (typeof v[key] === 'object') {
				globalSettings[key] = context.decodeObjectTree(v[key]);
			}
			else
				globalSettings[key] = v[key];
		}};
	

UINavigationBar.prototype.getGlobalSettingsWithContext = function UINavigationBar_getGlobalSettingsWithContext(context) {
		var data = {};
		for (var key in globalSettings) {
			if (typeof globalSettings[key] === 'object')	data[key] = context.encodeObject(globalSettings[key]);
			else data[key] = globalSettings[key];
		}
		return data;};
	

UINavigationBar.prototype.setAppearanceProperty = function UINavigationBar__setAppearanceProperty(name, v) {
		var isAChange = !!this.editorReference;
		if (isAChange && this.usesGlobalNavigationBarAppearance)
			globalSettings[name] = v;
		else
			this['_'+name] = v;
		
		if (isAChange && name === 'navigationBarType') {
			
			
			this.editorReference.contentFrameController.updateNavigationBar();
		}
		if (isAChange && name === 'navigationBarTintColor') {
			
			if (this.navigationBar)
				this.navigationBar.tintColor = v;
		}
		else this.update();};
	

UINavigationBar.prototype.getAppearanceProperty = function UINavigationBar__getAppearanceProperty(name) {
		if (this.usesGlobalNavigationBarAppearance)
			return globalSettings[name];
		return this['_'+name];};
	
	
UINavigationBar.prototype.updateNavigationBarFont = function UINavigationBar__updateNavigationBarFont() {
		if (!this.navigationBar) return;
		
		var fontName = this.navigationBarTitleLabelFontName || '_DEFAULT_BOLD_',
			fontSize = this.navigationBarTitleLabelFontSize || 20,
			offset = this.navigationBarTitleLabelOffset || 0;
		
		this.navigationBar.titleLabel.style({
			fontFamily: realIOSFont(fontName),
			fontSize: fontSize+'px',
			marginTop: offset+'px'
		});
			};
	


UINavigationBar.prototype.selectForEditor = function UINavigationBar_selectForEditor(editor) {
		editor.showFocusRing(this);};
	

UINavigationBar.prototype.unselectForEditor = function UINavigationBar_unselectForEditor(editor) {
		editor.hideFocusRing(this);};
	
	
UINavigationBar.prototype.deleteForEditor = function UINavigationBar_deleteForEditor(editor) {
		if (editor.editedScene)
			editor.editedScene.dataController.setValueForKeyPath(false, 'e_showsNavigationBar', editor.editedScene.dataController);
		return false;};
	

	Object.defineProperty(UINavigationBar.prototype, "outlineIconURL", {
		get: function () {
			return this.context.pathForResource('UINavigationBar.png')
		}});
	

UINavigationBar.prototype.readableNameForProperty = function UINavigationBar__readableNameForProperty(propertyName) {
		switch (propertyName) {
			case 'title': return LocalizedString('Title');
		}
		return __super.prototype.readableNameForProperty.call(this, propertyName);};
	

	Object.defineProperty(UINavigationBar.prototype, "bindableProperties", {
		get: function () {
			return [
				['title', this.readableNameForProperty('title')]
			];
		}});
	
	
	
	
UINavigationBar.prototype.checkChildNodes = function UINavigationBar__checkChildNodes() {

		var node = this.node;
		var editor = _context.editor;

		if (!node) {
			return;
		}
		node.isLeaf = false;
		node.removeAllChildNodes();
		
		var leftItemsNode = node.addChildNodeWithRepresentedObject(createComponentFromDomain('NavigationBarButtonItemsGroup', 'appdoo.iOS', this.context, {
			side: 'left',
			itemsKey: 'leftBarButtonItems',
			navigationBar: this
		}));
		leftItemsNode.representedObject.node = leftItemsNode;
		leftItemsNode.isLeaf = false;
		
		var rightItemsNode = node.addChildNodeWithRepresentedObject(createComponentFromDomain('NavigationBarButtonItemsGroup', 'appdoo.iOS', this.context, {
			side: 'right',
			itemsKey: 'rightBarButtonItems',
			navigationBar: this
		}));
		rightItemsNode.representedObject.node = rightItemsNode;
		rightItemsNode.isLeaf = false;
		
		
		Object.defineProperty(this, "_leftItemsNode", {
		configurable: true, 
			value: leftItemsNode});
		

		Object.defineProperty(this, "_rightItemsNode", {
		configurable: true, 
			value: rightItemsNode});
		
		

		['leftBarButtonItems', 'rightBarButtonItems'].every(function (key) {
			var itemsNode = key === 'leftBarButtonItems' ? leftItemsNode : rightItemsNode;
			
			if (Array.isArray(this.topItem[key])) this.topItem[key].every(function (barButtonItem) {
				if (barButtonItem.node) {
					itemsNode.addChildNode(barButtonItem.node, editor);
				}
				else {
					var childNode = itemsNode.addChildNodeWithRepresentedObject(barButtonItem, editor);
					editor.registerItem(barButtonItem, childNode);
				}return true; }, this);
			return true; }, this);
		
	};
	

	var insertIndicator;
	var positionInfos;

UINavigationBar.prototype.showInsertIndicator = function UINavigationBar__showInsertIndicator() {
		if (!insertIndicator) {
			var y = 20-2, x = -1000;
			insertIndicator = createComponentFromDomain(
				'ImageView', 'Core.UI', _context, {
				imageSrc: 'Resources/TabBarInsertIndicator.png',
				size: { width: 10, height: 47 },
				position: { top: y, left: x },
				style: { zIndex: 1, pointerEvents: 'none', opacity: 1 }
			});
		}
		this.superview.addSubview(insertIndicator);

		positionInfos = [];
		positionInfos.push({ left:true, x:7, itemBefore:null, itemAfter:this.topItem.leftBarButtonItems[0] });
		
		if (Array.isArray(this.topItem.leftBarButtonItems)) this.topItem.leftBarButtonItems.every(function (barButtonItem) {
			var itemX = -barButtonItem.view.getRelativeX(0, this);
			positionInfos.push({ left:true, x:itemX+barButtonItem.view.size.width+barButtonItem.defaultPadding, itemBefore:barButtonItem });
			if (positionInfos.length > 1)
				positionInfos[positionInfos.length-2].itemAfter = barButtonItem;return true; }, this);
		

		var i = 0, cMinusOne = this.topItem.rightBarButtonItems.length-1;
		if (Array.isArray(this.topItem.rightBarButtonItems)) this.topItem.rightBarButtonItems.every(function (barButtonItem) {
			var itemX = -barButtonItem.view.getRelativeX(0, this);
			
			if (i === cMinusOne) {
				positionInfos.push({ right:true, x:itemX-barButtonItem.defaultPadding, itemBefore: null, itemAfter: barButtonItem });
			}
			
			positionInfos.push({ right:true, x:itemX+barButtonItem.view.size.width+(i===0?0:barButtonItem.defaultPadding), itemBefore:barButtonItem, itemAfter: this.topItem.rightBarButtonItems[i-1] });
			
			i++;
return true; }, this);
		
		if (!this.topItem.rightBarButtonItems.length)
			positionInfos.push({ right:true, x:this.size.width-7, itemBefore: null, itemAfter: null });};
	

UINavigationBar.prototype.moveInsertIndicator = function UINavigationBar__moveInsertIndicator(x) {
		insertIndicator.position.left = x;};
	
	
UINavigationBar.prototype.hideInsertIndicator = function UINavigationBar__hideInsertIndicator() {
		if (!insertIndicator) return;
		insertIndicator.removeFromSuperview(true);};
	
	
UINavigationBar.prototype.determineBestPosition = function UINavigationBar__determineBestPosition(e) {

		var relativeX = this.getRelativeX(e.x)/_context.editor.contentFrameController.contentScale;
		
		var deltaMin = 1000, bestIndex = -1, i = 0;
		if (Array.isArray(positionInfos)) positionInfos.every(function (info) {
			if (Math.abs(info.x-relativeX) <= deltaMin) { 
				deltaMin = Math.abs(info.x-relativeX);
				bestIndex = i;
			}
			i++;return true; }, this);
		
		
		return positionInfos[bestIndex];
		};
	

UINavigationBar.prototype.determineIndicatorPosition = function UINavigationBar__determineIndicatorPosition(e) {
	
		var infoForBestPosition = this.determineBestPosition(e);
		if (!infoForBestPosition) return -10000;
		
		return infoForBestPosition.x;
	};
	


UINavigationBar.prototype.prepareForEditor = function UINavigationBar_prepareForEditor(editor) {

		if (this.font === undefined) this.font = createComponentFromDomain("UIFont", "appdoo.iOS", this.context, {
			fontFamily: defaultFontFamily,
			fontName: defaultFontName,
			pointSize: defaultPointSize})
		;

		if (!this.titleLabel) this.createTitleLabel();


	
		this.observeObject(this.font);
	
		if (this.isPrepared) return;

		Object.defineProperty(this, "editorReference", {
		writable: true, 
			value: editor});
		
		
		Object.defineProperty(this, "isPrepared", {
			value: true});
		
		
		this.titleLabel.DOMNode.ondblclick = this.editDefault.bind(this, editor);
		
		this.DOMNode.onclick = function (e) { if (editor.isActionClick(e)) return; editor.selectSingleObject(this); }.bind(this);

		this.checkChildNodes();
		
		if (this.topItem) this.topItem.prepareForEditor(editor);

		var draggedBarButton;
		var isDraggingBlueprint;
		var isDraggingUIButton;
		var blueprintData;

		this.dropHandler = {
	
			didDropWithEvent: function (e) {

				this.hideInsertIndicator();
				
				if (e.altKey && draggedBarButton)
					draggedBarButton = _context.editor.duplicateItems([draggedBarButton])[0];
				
				var bestPositionInfo = this.determineBestPosition(e);
				if (!bestPositionInfo) return;

				var destinationItemsGroup, index;
				
				if (bestPositionInfo.itemBefore) {
					destinationItemsGroup = bestPositionInfo.itemBefore.node.parentNode.representedObject;
					index = bestPositionInfo.itemBefore.node.index;
					
					if (destinationItemsGroup.itemsKey === 'leftBarButtonItems') {
						index++;
					}
				}
				else if (bestPositionInfo.itemAfter) {
					destinationItemsGroup = bestPositionInfo.itemAfter.node.parentNode.representedObject;
					index = bestPositionInfo.itemAfter.node.index;
					if (destinationItemsGroup.itemsKey !== 'leftBarButtonItems') {
						index++;
					}
				}
				else {
					index = 0;
					if (bestPositionInfo.left)
						destinationItemsGroup = this.node.childNodes[0].representedObject;
					else if (bestPositionInfo.right)
						destinationItemsGroup = this.node.childNodes[1].representedObject;
					else return;
				}
				
				if (isDraggingBlueprint || draggedBarButton.UTI === 'appdoo.iOS.UIButton') {
					var barButtonItem;
					
					if (blueprintData)
						barButtonItem = getPrototype(blueprintData.UTI).createForContext(this.context);
					else {
						barButtonItem = getPrototype('appdoo.iOS.UIBarButtonItem').createForContext(this.context);
						barButtonItem.title = draggedBarButton.text;
					}

					_context.editor.registerInsertedItem(barButtonItem, true, destinationItemsGroup.node, index);
					_context.editor.addUndoStepForInsertOperation(barButtonItem);
					
					return;
				}

				var sourceButtonItemsGroup = draggedBarButton.node.parentNode.representedObject;
				
				if (sourceButtonItemsGroup === destinationItemsGroup) {
					var from = draggedBarButton.node.index,
						to = index;
					
					if (from < to) to--;
					
					sourceButtonItemsGroup.node.moveChildNodeFromIndexToIndex(from, to);
				
				}
				else {
					draggedBarButton.node.controller.moveNodeToNodeAtIndex(draggedBarButton.node, destinationItemsGroup.node, index);
				}

				var b = draggedBarButton;
				_context.editor.selectSingleObject(b);
				draggedBarButton = null;
				
			}.bind(this),
	
			dropEffectForEvent: function (e) {

				if (!draggedBarButton && !isDraggingBlueprint)
					return 'none';

				var infoForBestPosition = this.determineBestPosition(e);
				if (!infoForBestPosition || (draggedBarButton && !e.altKey && (infoForBestPosition.itemBefore === draggedBarButton || infoForBestPosition.itemAfter === draggedBarButton))) {
					this.moveInsertIndicator(-1000);
					return 'none';
				}
				else {
					this.moveInsertIndicator(infoForBestPosition.x-4);
					if (e.altKey && draggedBarButton)
						return 'copy';
					if (isDraggingBlueprint || isDraggingUIButton)
						return 'copy';
					return 'move';
				}
			}.bind(this),
	
			didLeaveWithEvent: function (e) {
				this.hideInsertIndicator();
				draggedBarButton = null;
			}.bind(this),
			
			didEnterWithEvent: function (e) {
				isDraggingBlueprint = false;
				isDraggingUIButton = false;
				blueprintData = e.dataTransfer.getData(_context.objectBlueprintDataType);

				if (blueprintData) {
					blueprintData = JSON.parse(blueprintData);

					var dropIsValid = blueprintData.UTI === 'appdoo.iOS.UIBarButtonItem' || (getPrototype(blueprintData.UTI) instanceof getType('appdoo.iOS.UIBarButtonItem'));

					if (!dropIsValid)
						return;
					isDraggingBlueprint = true;
				}
				if (!isDraggingBlueprint) {
			
					draggedBarButton = this.context.globals[e.dataTransfer.getData(_context.promisedRealObjectsDataType)];
					if (!draggedBarButton) return;
					if (!(draggedBarButton instanceof getType('appdoo.iOS.UIBarButtonItem'))) {
						if (draggedBarButton.UTI === 'appdoo.iOS.UIButton') {
							isDraggingUIButton = true;
						}
						else {
							draggedBarButton = null;
							return;
						}
					}
				}
				this.showInsertIndicator();
			}.bind(this)
	
		};
};
	
	
UINavigationBar.prototype.unprepareForEditor = function UINavigationBar_unprepareForEditor(editor) {
		this.unobserveObject(this.font);};
	
	
	var UIBarMetricsDefault = 0;

UINavigationBar.prototype.transformData = function UINavigationBar_transformData(data, transformer) {
	
		if (transformer.isXIBGenerator) {
			return __super.prototype.transformData.call(this, data, transformer);
		}
		else {
			var result = __super.prototype.transformData.call(this, data, transformer);
			result.$type = this.constructor.name;
			result.translucent = transformer.transformBoolean(data.translucent);
			result.barStyle = transformer.transformInteger(data.barStyle);
			result.barTintColor = transformer.transformCSSColor(data.barTintColor);
			result.tintColor = transformer.transformCSSColor(data.tintColor);
			
			if (transformer.context.imageReferenceIsValid(data.v_backgroundImage)) {
				result.$initialMethodCalls = [{
					name: 'setBackgroundImage:forBarMetrics:',
					arguments: [transformer.transformReferencedImage(data.v_backgroundImage), UIBarMetricsDefault]
				}];
			}
	
	
			return result;
		}};
	
	
	Object.defineProperty(UINavigationBar.prototype, "heightForBarButtonItems", {
		get: function () {
			return this.shouldDisplaySlim ? 32 : 44;
		}});
	

UINavigationBar.prototype.transformChangeForAppdooPreview = function UINavigationBar_transformChangeForAppdooPreview(change, transformer, result) {

		switch (change.keyPath) {
		
			case 'e_barTintColor':
				result.keyPath = 'barTintColor';
				result.value = transformer.transformCSSColor(change.valueNow);
				return true;
				break;

		}
	
		return __super.prototype.transformChangeForAppdooPreview.call(this, change, transformer, result);};
	

UINavigationBar.prototype.fileReferenceDidUpdate = function UINavigationBar_fileReferenceDidUpdate(ref) {
		['e_backgroundImage','e_titleViewImage'].every(function (key) {
			if (!this[key]) return true;
			if (this[key] && this[key].fileReferenceID === ref.$id) {
				var newImageRef = this.context.decodeObjectTree(this[key].encode());
				newImageRef.imageID = ref.resourceID;
				this[key] = newImageRef;
			}return true; }, this);
		
		if (this.topItem) this.topItem.fileReferenceDidUpdate(ref);};
	

	Object.defineProperty(UINavigationBar.prototype, "font", {
		get: function () {
			return this.context.project.navigationBarFont;
		}, 
		set: function (v) {
			this.context.project.navigationBarFont = v;
		}});
	
	
	Object.defineProperty(UINavigationBar.prototype, "labelColor", {
		get: function () {
			return this.context.project.navigationBarLabelColor;
		}, 
		set: function (v) {
			this.context.project.navigationBarLabelColor = v;
			this.styleDefault();
		}});
	
	
	Object.defineProperty(UINavigationBar.prototype, "usesCustomFont", {
		get: function () {
			return this.context.project.usesCustomNavigationBarFont;
		}, 
		set: function (v) {
			this.context.project.usesCustomNavigationBarFont = v;
			this.styleDefault();
			_context.editor.refreshInspector();
		}});
	
	
	Object.defineProperty(UINavigationBar.prototype, "fontName", {
		set: function (v) { this.font.fontName = v; }, 
		get: function ( ) { return this.font.fontName; }});
	
	Object.defineProperty(UINavigationBar.prototype, "fontFamily", {
		set: function (v) { this.font.fontFamily = v; }, 
		get: function ( ) { return this.font.fontFamily; }});
	
	Object.defineProperty(UINavigationBar.prototype, "fontSize", {
		set: function (v) { this.font.pointSize = v; }, 
		get: function ( ) { return this.font.pointSize; }});
	

UINavigationBar.prototype.observedObjectValueDidChangeForKeyPath = function UINavigationBar_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {
		if (obj === this.font) {
			this.styleDefault();
		}};
	
	
UINavigationBar.prototype.addBackButtonIfEmpty = function UINavigationBar_addBackButtonIfEmpty() {
		













		
	};
	

UINavigationBar.prototype.initPropertiesFromData = function UINavigationBar_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("title")) this.title = data.title;
if (data.hasOwnProperty("items")) this.items = data.items;
if (data.hasOwnProperty("v_backgroundImage")) this.v_backgroundImage = data.v_backgroundImage;
if (data.hasOwnProperty("v_titleViewImage")) this.v_titleViewImage = data.v_titleViewImage;
};

UINavigationBar.prototype.decodeData = function UINavigationBar_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("items")) decoded.items = []; if (Array.isArray(data.items)) { data.items.forEach(function (o) { decoded.items.push(this.context.decodeObjectTree(o)); }.bind(this)); }
if (data.hasOwnProperty("v_backgroundImage")) decoded.v_backgroundImage = this.context.decodeObjectTree(data.v_backgroundImage);
if (data.hasOwnProperty("v_titleViewImage")) decoded.v_titleViewImage = this.context.decodeObjectTree(data.v_titleViewImage);
return decoded; };

UINavigationBar.prototype.encodeCloned = function UINavigationBar_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._items && this._items.encode) {encoded.items = []; this._items.forEach(function (o) { encoded.items.push(o.encodeCloned()); });
}if (this._v_backgroundImage && this._v_backgroundImage.encode) {encoded.v_backgroundImage = this.v_backgroundImage.encodeCloned();
}if (this._v_titleViewImage && this._v_titleViewImage.encode) {encoded.v_titleViewImage = this.v_titleViewImage.encodeCloned();
}return encoded; };

UINavigationBar.prototype.expectedTypeForProperty = function UINavigationBar_expectedTypeForProperty(key) {
	if (key === "title") return "";
	if (key === "nameIsEditable") return "";
	if (key === "items") return "UINavigationItem[]";
	if (key === "v_backgroundImage") return "ImageReference";
	if (key === "v_titleViewImage") return "ImageReference";
	if (key === "e_title") return "String";
	if (key === "e_titleViewImage") return "ImageReference";
	if (key === "topItem") return "";
	if (key === "defaultBarHeight") return "";
	if (key === "titleLabel") return "";
	if (key === "encodesSubviews") return "";
	if (key === "titleImageView") return "";
	if (key === "hasTitleImage") return "";
	if (key === "backgroundImageCanvas") return "";
	if (key === "shouldDisplaySlim") return "";
	if (key === "readableValue") return "";
	if (key === "e_isVisible") return "";
	if (key === "inspectorProperties") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "autoresizingMaskIsEditable") return "";
	if (key === "canHaveLayoutRelations") return "";
	if (key === "navigationBarTitle") return "";
	if (key === "outlineIconURL") return "";
	if (key === "bindableProperties") return "";
	if (key === "editorReference") return "";
	if (key === "isPrepared") return "";
	if (key === "heightForBarButtonItems") return "";
	if (key === "font") return "UIFont";
	if (key === "labelColor") return "String";
	if (key === "usesCustomFont") return "Boolean";
	if (key === "fontName") return "String";
	if (key === "fontFamily") return "String";
	if (key === "fontSize") return "Number";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UINavigationBar; }()));
registerType('appdoo.iOS', (function () { function NavigationBarButtonItemsGroup() {} var __super = setSupertypeFromDomain(NavigationBarButtonItemsGroup, 'BasicEditableObject', 'appdoo');

	Object.defineProperty(NavigationBarButtonItemsGroup.prototype, "nameIsEditable", {
		value: false});
	

	Object.defineProperty(NavigationBarButtonItemsGroup.prototype, "itemsKey", {
	outlet: true, get:function () { return this._itemsKey; }, set:function (v) {if (!Object.hasOwnProperty(this, "_itemsKey")) Object.defineProperty(this, "_itemsKey", { writable: true, configurable: true }); this._itemsKey = v; }});
	

	Object.defineProperty(NavigationBarButtonItemsGroup.prototype, "navigationBar", {
	outlet: true, get:function () { return this._navigationBar; }, set:function (v) {if (!Object.hasOwnProperty(this, "_navigationBar")) Object.defineProperty(this, "_navigationBar", { writable: true, configurable: true }); this._navigationBar = v; }});
	

	Object.defineProperty(NavigationBarButtonItemsGroup.prototype, "readableValue", {
		get: function () {
			if (this.itemsKey === 'leftBarButtonItems') {
				return LocalizedString('Left Side');
			}
			return LocalizedString('Right Side');
		}});
	
	
	Object.defineProperty(NavigationBarButtonItemsGroup.prototype, "isExpandedInEditorOutline", {
		value: true});
	

	Object.defineProperty(NavigationBarButtonItemsGroup.prototype, "outlineIconURL", {
		value: 'Resources/ViewGroup.png'});
	
	
NavigationBarButtonItemsGroup.prototype.acceptsMemberWithUTI = function NavigationBarButtonItemsGroup_acceptsMemberWithUTI(uti) {
		return uti === 'appdoo.iOS.UIBarButtonItem'
			|| getPrototype(uti) instanceof getType('appdoo.iOS.UIBarButtonItem')
			|| uti === 'appdoo.iOS.UIButton'
			;};
		

NavigationBarButtonItemsGroup.prototype.needsCopyOfMemberWithUTI = function NavigationBarButtonItemsGroup_needsCopyOfMemberWithUTI(uti) {
		return uti === 'appdoo.iOS.UIButton';};
	
	
NavigationBarButtonItemsGroup.prototype.addMember = function NavigationBarButtonItemsGroup_addMember(member, index) {

		if (member.UTI === 'appdoo.iOS.UIButton') {
			var barButtonItem = getPrototype('appdoo.iOS.UIBarButtonItem').createForContext(this.context);
			barButtonItem.title = member.text;
			barButtonItem.actionType = member.actionType;
			barButtonItem.actionInfo = member.actionInfo;

			_context.undoManager.disableRegistration();
			_context.editor.deleteItem(member);
			_context.undoManager.enableRegistration();
			_context.editor.registerInsertedItem(barButtonItem, true, this.node, index);
			_context.editor.addUndoStepForInsertOperation(barButtonItem);
			return;
		}

		this.navigationBar.topItem[this.itemsKey].splice(index, 0, member);
		
		this.navigationBar.addSubview(member.view);
		member.updateView();
		this.navigationBar.layoutSubviews();
		
		return true;
		};
	

NavigationBarButtonItemsGroup.prototype.removeMember = function NavigationBarButtonItemsGroup_removeMember(member) {
		this.navigationBar.topItem[this.itemsKey].splice(this.navigationBar.topItem[this.itemsKey].indexOf(member), 1);
		if (member.view) member.view.removeFromSuperview(true);
		this.navigationBar.layoutSubviews();};
	
	
NavigationBarButtonItemsGroup.prototype.moveMember = function NavigationBarButtonItemsGroup_moveMember(member, oldKey, newKey) {
		this.navigationBar.topItem[this.itemsKey].splice(oldKey, 1);
		this.navigationBar.topItem[this.itemsKey].splice(newKey, 0, member);
		this.navigationBar.layoutSubviews();};
	


NavigationBarButtonItemsGroup.prototype.initPropertiesFromData = function NavigationBarButtonItemsGroup_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("itemsKey")) this.itemsKey = data.itemsKey;
if (data.hasOwnProperty("navigationBar")) this.navigationBar = data.navigationBar;
};

NavigationBarButtonItemsGroup.prototype.decodeData = function NavigationBarButtonItemsGroup_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("navigationBar")) decoded.navigationBar = this.context.decodeObjectTree(data.navigationBar);
return decoded; };

NavigationBarButtonItemsGroup.prototype.encode = function NavigationBarButtonItemsGroup_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

NavigationBarButtonItemsGroup.prototype.encodeCloned = function NavigationBarButtonItemsGroup_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

NavigationBarButtonItemsGroup.prototype.expectedTypeForProperty = function NavigationBarButtonItemsGroup_expectedTypeForProperty(key) {
	if (key === "nameIsEditable") return "";
	if (key === "itemsKey") return "String";
	if (key === "navigationBar") return "UINavigationBar";
	if (key === "readableValue") return "";
	if (key === "isExpandedInEditorOutline") return "";
	if (key === "outlineIconURL") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return NavigationBarButtonItemsGroup; }()));