
registerType('appdoo.iOS', (function () { function UINavigationItem() {} var __super = setSupertypeFromDomain(UINavigationItem, 'BasicObject', 'Core');

	Object.defineProperty(UINavigationItem.prototype, "leftBarButtonItems", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			if (this._leftBarButtonItems === undefined) this.leftBarButtonItems = [];
			return this._leftBarButtonItems;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_leftBarButtonItems")) Object.defineProperty(this, "_leftBarButtonItems", { writable: true, configurable: true }); this._leftBarButtonItems = v; }});
	

	Object.defineProperty(UINavigationItem.prototype, "rightBarButtonItems", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			if (this._rightBarButtonItems === undefined) this.rightBarButtonItems = [];
			return this._rightBarButtonItems;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_rightBarButtonItems")) Object.defineProperty(this, "_rightBarButtonItems", { writable: true, configurable: true }); this._rightBarButtonItems = v; }});
	
	
	Object.defineProperty(UINavigationItem.prototype, "barButtonItems", {
		get: function () {
			return this.leftBarButtonItems.concat(this.rightBarButtonItems);
		}});
	

	Object.defineProperty(UINavigationItem.prototype, "titleView", {
	outlet: true, 
	enumerable: true, get:function () { return this._titleView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_titleView")) Object.defineProperty(this, "_titleView", { writable: true, configurable: true }); this._titleView = v; }});
	

	Object.defineProperty(UINavigationItem.prototype, "navigationBar", {
	synthesized: true, get:function () { return this._navigationBar; }, set:function (v) {if (!Object.hasOwnProperty(this, "_navigationBar")) Object.defineProperty(this, "_navigationBar", { writable: true, configurable: true }); this._navigationBar = v; }});
	

	Object.defineProperty(UINavigationItem.prototype, "v_titleViewImage", {
	outlet: true, get:function () { return this._v_titleViewImage; }, set:function (v) {if (!Object.hasOwnProperty(this, "_v_titleViewImage")) Object.defineProperty(this, "_v_titleViewImage", { writable: true, configurable: true }); this._v_titleViewImage = v; }});
	

	Object.defineProperty(UINavigationItem.prototype, "title", {
		get: function () {
		}, 
		set: function (v) {
			this.navigationBar.title = v;
		}});
	

UINavigationItem.prototype.prepareForEditor = function UINavigationItem_prepareForEditor(editor) {

		['leftBarButtonItems','rightBarButtonItems'].every(function (key) {
			if (Array.isArray(this[key])) this[key].every(function (barButtonItem) {
				barButtonItem.prepareForEditor(editor);return true; }, this);
			return true; }, this);
		
};
	
	
UINavigationItem.prototype.getBarButtonItemUTI = function UINavigationItem__getBarButtonItemUTI(keyPath) {
		if (this[keyPath]) return this[keyPath].UTI;};
	
	

UINavigationItem.prototype.transformData = function UINavigationItem_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.navigationItem_transformDataForXIB(data, transformer);
		else return this.navigationItem_transformDataForPreview(data, transformer);};
	
	
UINavigationItem.prototype.navigationItem_transformDataForXIB = function UINavigationItem_navigationItem_transformDataForXIB(data, transformer) {

		var result = {
					key: 'navigationItem',
					id: transformer.createStoryboardID()
				};
		
		var i = 0;
		['leftBarButtonItems','rightBarButtonItems'].every(function (key) {
			if (Array.isArray(data[key])) data[key].every(function (barButtonItem) {
				if (barButtonItem.itemType === 'simulatedBackButton')
					return true;
			
				barButtonItem.tag = i;
				
				transformer.registerInlineObject(barButtonItem);

				transformer.addConnectionFrom__to__type__info__(data.$id, barButtonItem.$id, 'outletCollection', {
					property: key+'OrderedByTag',
					destination: transformer.storyboardIDForObjectID(barButtonItem.$id),
					id: transformer.createStoryboardID()
				}, result);

				i++;return true; }, this);
			return true; }, this);
		
		if (i > 0) {
			transformer.demandPluginWithIdentifier('info.appdoo-mac.OutletCollectionExtensions');
		}

		return result;	};
	
	
UINavigationItem.prototype.navigationItem_transformDataForPreview = function UINavigationItem_navigationItem_transformDataForPreview(data, transformer) {

		var result = {
			$type: this.constructor.name,
			$domain: 'com.apple',
			$id: data.$id,
		};
		
		['leftBarButtonItems','rightBarButtonItems'].every(function (key) {
			var items = [];
			if (Array.isArray(data[key])) data[key].every(function (barButtonItem) {
				if (barButtonItem.itemType === 'simulatedBackButton')
					return true;
				items.push(getPrototype(utiFromData(barButtonItem)).transformData(barButtonItem, transformer));return true; }, this);
			
			result[key] = transformer.transformObjectArray(items);return true; }, this);
		

		
		return result;
		};
	

UINavigationItem.prototype.fileReferenceDidUpdate = function UINavigationItem_fileReferenceDidUpdate(ref) {

		['leftBarButtonItems','rightBarButtonItems'].every(function (key) {
			if (Array.isArray(this[key])) this[key].every(function (barButtonItem) {
				barButtonItem.fileReferenceDidUpdate(ref);return true; }, this);
			return true; }, this);
		
	};
	
	
UINavigationItem.prototype.initPropertiesFromData = function UINavigationItem_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("leftBarButtonItems")) this.leftBarButtonItems = data.leftBarButtonItems;
if (data.hasOwnProperty("rightBarButtonItems")) this.rightBarButtonItems = data.rightBarButtonItems;
if (data.hasOwnProperty("titleView")) this.titleView = data.titleView;
if (data.hasOwnProperty("v_titleViewImage")) this.v_titleViewImage = data.v_titleViewImage;
};

UINavigationItem.prototype.decodeData = function UINavigationItem_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("leftBarButtonItems")) decoded.leftBarButtonItems = []; if (Array.isArray(data.leftBarButtonItems)) { data.leftBarButtonItems.forEach(function (o) { decoded.leftBarButtonItems.push(this.context.decodeObjectTree(o)); }.bind(this)); }
if (data.hasOwnProperty("rightBarButtonItems")) decoded.rightBarButtonItems = []; if (Array.isArray(data.rightBarButtonItems)) { data.rightBarButtonItems.forEach(function (o) { decoded.rightBarButtonItems.push(this.context.decodeObjectTree(o)); }.bind(this)); }
if (data.hasOwnProperty("titleView")) decoded.titleView = this.context.decodeObjectTree(data.titleView);
if (data.hasOwnProperty("v_titleViewImage")) decoded.v_titleViewImage = this.context.decodeObjectTree(data.v_titleViewImage);
return decoded; };

UINavigationItem.prototype.encode = function UINavigationItem_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._leftBarButtonItems && this._leftBarButtonItems.encode) {encoded.leftBarButtonItems = []; this._leftBarButtonItems.forEach(function (o) { encoded.leftBarButtonItems.push(o.encode()); });
}if (this._rightBarButtonItems && this._rightBarButtonItems.encode) {encoded.rightBarButtonItems = []; this._rightBarButtonItems.forEach(function (o) { encoded.rightBarButtonItems.push(o.encode()); });
}if (this._titleView && this._titleView.encode) {encoded.titleView = this.titleView.encode();
}return encoded; };

UINavigationItem.prototype.encodeCloned = function UINavigationItem_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._leftBarButtonItems && this._leftBarButtonItems.encode) {encoded.leftBarButtonItems = []; this._leftBarButtonItems.forEach(function (o) { encoded.leftBarButtonItems.push(o.encodeCloned()); });
}if (this._rightBarButtonItems && this._rightBarButtonItems.encode) {encoded.rightBarButtonItems = []; this._rightBarButtonItems.forEach(function (o) { encoded.rightBarButtonItems.push(o.encodeCloned()); });
}if (this._titleView && this._titleView.encode) {encoded.titleView = this.titleView.encodeCloned();
}return encoded; };

UINavigationItem.prototype.expectedTypeForProperty = function UINavigationItem_expectedTypeForProperty(key) {
	if (key === "leftBarButtonItems") return "UIBarButtonItem[]";
	if (key === "rightBarButtonItems") return "UIBarButtonItem[]";
	if (key === "barButtonItems") return "";
	if (key === "titleView") return "UIView";
	if (key === "navigationBar") return "UINavigationBar";
	if (key === "v_titleViewImage") return "ImageReference";
	if (key === "title") return "String";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UINavigationItem; }()));