
registerType('appdoo.iOS', (function () { function UIPickerView() {} var __super = setSupertypeFromDomain(UIPickerView, 'UIView', 'appdoo.iOS');
	
	var UIPICKERVIEW_HEIGHT = 162;


	Object.defineProperty(UIPickerView.prototype, "rowTitles", {
	outlet: true, 
	enumerable: true, 
		get: function () { return this._rowTitles || []; }, set:function (v) {if (!Object.hasOwnProperty(this, "_rowTitles")) Object.defineProperty(this, "_rowTitles", { writable: true, configurable: true }); this._rowTitles = v; }});
	
	
	Object.defineProperty(UIPickerView.prototype, "didSetIndex", {
	synthesized: true, get:function () { return this._didSetIndex; }, set:function (v) {if (!Object.hasOwnProperty(this, "_didSetIndex")) Object.defineProperty(this, "_didSetIndex", { writable: true, configurable: true }); this._didSetIndex = v; }});
	

	Object.defineProperty(UIPickerView.prototype, "selectedRow", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_selectedRow")) Object.defineProperty(this, "_selectedRow", { writable: true, configurable: true });
			if (!this.didSetIndex) {
				this._selectedRow = v;
				this.didSetIndex = true;
			}
			else {
				if (typeof v !== 'number' || isNaN(v)) v = parseInt(v)||0;
				if (v < 0) v = 0;
				if (this._selectedRow === v) return;
				this._selectedRow = v;
				this.scrollToIndexAnimated(v, false);
				this.dataProvider.notifyObservers();
			}
		}, get:function () { return this._selectedRow; }});
	

	Object.defineProperty(UIPickerView.prototype, "selectedRow1", {
		get: function () { return this.selectedRow+1; }, 
		set: function (i) {
			this.setSelectedRowAnimated(i-1, false);
		}});
	
	
	Object.defineProperty(UIPickerView.prototype, "textForSelectedRow", {
		set: function (v) { this.rowTitles[this.selectedRow] = v; this.rowTitlesDidChange(); _context.editor.refreshInspector(); }, 
		get: function () { return this.rowTitles[this.selectedRow]; }});
	

	Object.defineProperty(UIPickerView.prototype, "selectedRowText", {
		get: function () { return this.textForSelectedRow; }});
	
	
UIPickerView.prototype.rowTitlesDidChange = function UIPickerView__rowTitlesDidChange() {
		this.context.broadcastValueChangeForKeyPathInObject('rowTitles', this.dataController, this.dataController);
		this.createSubviews();
		this.viewDidLoad();};
	

UIPickerView.prototype.createForSuperview = function UIPickerView_createForSuperview(superview) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: superview.size.width, height: UIPICKERVIEW_HEIGHT },
			position: { left: 0, top: 0 },
			autoresizingMask: 2,
			
			backgroundColor: 'rgb(255,255,255)',
			rowTitles: ['Alpha','Beta','Gamma','Delta','Epsilon'],
			selectedRow: 0,
			name: superview.context.nameForNewFormControl(this),
		});
	};
	

	Object.defineProperty(UIPickerView.prototype, "readableType", {
		get: function () { return LocalizedString('Picker View'); }});
	
	
	Object.defineProperty(UIPickerView.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(UIPickerView.prototype, "titleStrings", {
		set: function (v) {
			this.rowTitles = Array.isArray(v) ? v : v.split("\n");
			if (this.scrollingBackgroundView) this.rowTitlesDidChange();
		}, 
		get: function () {
			return this.rowTitles.join("\n");
		}});
	
	
	Object.defineProperty(UIPickerView.prototype, "pickerLabels", {
	synthesized: true, get:function () { return this._pickerLabels; }, set:function (v) {if (!Object.hasOwnProperty(this, "_pickerLabels")) Object.defineProperty(this, "_pickerLabels", { writable: true, configurable: true }); this._pickerLabels = v; }});
	

	Object.defineProperty(UIPickerView.prototype, "scrollingBackgroundView", {
	synthesized: true, get:function () { return this._scrollingBackgroundView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scrollingBackgroundView")) Object.defineProperty(this, "_scrollingBackgroundView", { writable: true, configurable: true }); this._scrollingBackgroundView = v; }});
	

	Object.defineProperty(UIPickerView.prototype, "scrollingSelectionView", {
	synthesized: true, get:function () { return this._scrollingSelectionView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scrollingSelectionView")) Object.defineProperty(this, "_scrollingSelectionView", { writable: true, configurable: true }); this._scrollingSelectionView = v; }});
	

	Object.defineProperty(UIPickerView.prototype, "bordersView", {
	synthesized: true, get:function () { return this._bordersView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_bordersView")) Object.defineProperty(this, "_bordersView", { writable: true, configurable: true }); this._bordersView = v; }});
	
	
	Object.defineProperty(UIPickerView.prototype, "isScrolling", {
	synthesized: true, get:function () { return this._isScrolling; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isScrolling")) Object.defineProperty(this, "_isScrolling", { writable: true, configurable: true }); this._isScrolling = v; }});
	
	
		var spacingBetween = 28+4;
	
UIPickerView.prototype.createSubviews = function UIPickerView__createSubviews() {
		this.removeAllSubviews();
		this.pickerLabels = [];
		
		this.scrollingBackgroundView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: this.sizeCopy,
			autoresizingMask: 2,
			style: {
				overflowX: 'hidden',
				overflowY: 'auto',
				webkitTransformStyle: 'preserve-3d',
				webkitPerspective: '200px',
			}})
		;
		this.addSubview(this.scrollingBackgroundView);
		
		var scrollTimer;
		var didEndScroll = function () {
			this.isScrolling = false;
			if (!this.scrollingBackgroundView || !this.scrollingBackgroundView.DOMNode) return;
			var scrollTop = this.scrollingBackgroundView.DOMNode.scrollTop;
			var selectedIndex = Math.round(scrollTop/spacingBetween);
			
			if (this.hasBindingForKey('selectedRow1')) {
				this.setSelectedRowAnimated(this.selectedRow, true);
				return;
			}
			
			this.setSelectedRowAnimated(selectedIndex, true);
		}.bind(this);

		this.scrollingBackgroundView.DOMNode.onscroll = function () {
			if (!this.scrollingBackgroundView.DOMNode) return;

			this.applyTransformations();
			
			this.scrollingSelectionView.DOMNode.scrollTop = this.scrollingBackgroundView.DOMNode.scrollTop;
			if (!this.isPerformingAnimation) {
				this.isScrolling = true;
				if (scrollTimer) clearTimeout(scrollTimer);
				scrollTimer = setTimeout(didEndScroll, 250);
			}
		}.bind(this);
		
		var spacing = this.size.height/2-10;
		var y = spacing;
		var i = 0;
		
		if (Array.isArray(this.rowTitles)) this.rowTitles.every(function (title) {
			var label = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
				text: title,
				position: { top: y-3 },
				size: { width: this.size.width, height: 20 },
				autoresizingMask: 2,
				textAlignment: 'center',
				textColor: 'rgba(0,0,0,0.4)',
				fontSize: 20,
				tag: i})
			;
			this.scrollingBackgroundView.addSubview(label);
			this.pickerLabels.push(label);
			label.DOMNode.onclick = function (e) {
				if (_context.editor.isActionClick(e)) {
					if (this.hasBindingForKey('selectedRow1')) {
						this.context.beep();
						return;
					}
					this.setSelectedRowAnimated(label.tag, true);
				}
			}.bind(this);
			label.DOMNode.ondblclick = function (e) {
				if (_context.editor.isActionClick(e)) return;
				if (_context.editor.editedSubview !== this.superview) return;
				if (this.hasBindingForKey('titleStrings')) {
					this.context.beep();
					return;
				}
				this.setSelectedRowAnimated(label.tag, false);
				this.text = label.text;
				setTimeout(function () {
					this.scrollingSelectionView.subviews[label.tag].editDefault(_context.editor, this.dataController, 'textForSelectedRow');
				}.bind(this), 10);
			}.bind(this);
			
			y += spacingBetween;
			i++;return true; }, this);
		
		
		var bottomView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width: this.size.width, height:1 },
			position: { top: y+spacing-8-1-4 }})
		;
		this.scrollingBackgroundView.addSubview(bottomView);
		
		this.applyTransformations();

		this.scrollingSelectionView = createComponentFromDomain("View", "Core.UI", this.context, {
				position: { top: 70-14+10 },
				size: { width: this.size.width, height: 28 },
				autoresizingMask: 2,
				style: {
					borderColor: '#ddd',  pointerEvents:'none',overflow:'hidden' }})
			;
		this.addSubview(this.scrollingSelectionView);

		y = 0;
		if (Array.isArray(this.rowTitles)) this.rowTitles.every(function (title) {
			var label = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
				text: title,
				position: { top: y },
				size: { width: this.size.width, height: 28 },
				autoresizingMask: 2,
				textAlignment: 'center',
				textColor: 'rgba(0,0,0,0.75)',
				fontSize: 23,
				style: { paddingBottom: '20px', webkitTransform: 'translateY(0.5px)' }})
			;
			this.scrollingSelectionView.addSubview(label);
			
			y += spacingBetween;return true; }, this);
		
		
		var self = this;
		
		var borders = createComponentFromDomain("CanvasView", "Core.UI", this.context, {
			size: this.scrollingSelectionView.sizeCopy,
			position: this.scrollingSelectionView.positionCopy,
			autoresizingMask: 2,
				style: { pointerEvents:'none' }})
		;
		this.insertSubviewAtIndex(borders,1);
		borders.draw = function (width, height) {
			var borderWidth = this.contentScale < 2 ? 1 : 0.5;
			var ctx = this.DOMNode.getContext('2d');
			ctx.strokeStyle = 'rgba(0,0,0,.19)';
			ctx.fillStyle = self.backgroundColor || '#fff';

			ctx.save();
			ctx.scale(this.contentScale,this.contentScale);
			ctx.clearRect(0,0,width,height);
			ctx.rect(-1,0,width+2,height);
			ctx.fill();
			ctx.stroke();
			ctx.restore();
		};
		borders.layoutSubviews();
		this.bordersView = borders;
		};
	

	Object.defineProperty(UIPickerView.prototype, "e_backgroundColor", {
		set: function (v) { this.backgroundColor = v; if(this.bordersView) this.bordersView.draw(); }, 
		get: function ( ) { return this.backgroundColor; }});
	
	
UIPickerView.prototype.applyTransformations = function UIPickerView__applyTransformations() {
		var labelHeightHalf = 10;
		var pickerHeightHalf = this.size.height/2;
		var pickerHeightHalfR = pickerHeightHalf + 40;
		var numberOfLabels 
		if (Array.isArray(this.pickerLabels)) this.pickerLabels.every(function (label) {

			var distanceFromMiddle = (label.position.top+labelHeightHalf)-pickerHeightHalf-this.scrollingBackgroundView.DOMNode.scrollTop;
			
			if (Math.abs(distanceFromMiddle) > pickerHeightHalf+20) {
				label.hidden = true;
				label.style.webkitTransform = '';
			}
			else {
				label.hidden = false;
				var factor = Math.max(Math.abs(distanceFromMiddle),0)/pickerHeightHalfR;
				var roundFactor = 1-Math.cos(factor*(Math.PI/2));
				var roundFactor2 = roundFactor;
				var posOrNeg = (distanceFromMiddle > 0 ? -1 : 1);
				var deg = ((roundFactor*0.8*90)|0)*posOrNeg;
				var offsetY = (roundFactor2*1.6)*28*posOrNeg;
				var scale = 1-(roundFactor/10)
				
				label.DOMNode.style.webkitTransform = 'scale('+scale+') translateY('+offsetY+'px) rotateX('+deg+'deg)';
				label.DOMNode.style.opacity = (1-roundFactor*1.6);
			}
return true; }, this);
		};
	
	
UIPickerView.prototype.init = function UIPickerView_init() {
		__super.prototype.init.call(this);
		this.DOMNode.style.overflow = 'hidden';
		this.createSubviews();
		this.scrollingBackgroundView.hidden = true;
		this.scrollingSelectionView.hidden = true;
		this.bordersView.hidden = true;
		return this;};
	
	
UIPickerView.prototype.viewDidLoad = function UIPickerView_viewDidLoad() {
		__super.prototype.viewDidLoad.call(this);
		this.scrollingBackgroundView.hidden = false;
		this.bordersView.hidden = false;
		this.scrollingSelectionView.hidden = false;

		if (this.selectedRow && this.scrollingBackgroundView && this.scrollingBackgroundView.DOMNode.scrollHeight) {
		
			
			this.scrollingBackgroundView.hidden = true;
			this.scrollingSelectionView.hidden = true;
			this.bordersView.hidden = true;
			this.isPerformingAnimation = false;
			this.scrollToIndexAnimated(this.selectedRow, false);
			setTimeout(function () {
				this.scrollingBackgroundView.hidden = false;
				this.scrollingSelectionView.hidden = false;
				this.bordersView.hidden = false;
				this.scrollingSelectionView.style({opacity:0.99999});
			}.bind(this), 10);
		}
		};
	
	
	Object.defineProperty(UIPickerView.prototype, "isPerformingAnimation", {
	synthesized: true, get:function () { return this._isPerformingAnimation; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isPerformingAnimation")) Object.defineProperty(this, "_isPerformingAnimation", { writable: true, configurable: true }); this._isPerformingAnimation = v; }});
	

UIPickerView.prototype.setSelectedRowAnimated = function UIPickerView_setSelectedRowAnimated(index, animated) {
		this.scrollToIndexAnimated(index, animated);

		if (this.dataController) {
			this.dataController.setValueForKey(index, 'selectedRow');
		}
		else {
			this.selectedRow = index;
		}
};
	
	
UIPickerView.prototype.scrollToIndexAnimated = function UIPickerView__scrollToIndexAnimated(index, animated) {
		if (!this.viewIsLoaded) return;
		if (this.isPerformingAnimation) return;
		if (!this.scrollingBackgroundView) return;
		var scrollingNode = this.scrollingBackgroundView.DOMNode;
		var scrollTop = scrollingNode.scrollTop;
		var targetScrollTop = index*spacingBetween;
		
		var self = this;
		
		if (!animated || Math.abs(scrollTop-targetScrollTop) < 2) {
			this.isPerformingAnimation = true;
			if (!animated) scrollingNode.scrollTop = targetScrollTop;
				setTimeout(function () {
					self.isPerformingAnimation = false;
					self = null;
				}, 10);
			return;
		}
		
		scrollingNode.style.pointerEvents = 'none';
		this.isPerformingAnimation = true;
		
		var steps = 20;
		var pixelsPerStep = (targetScrollTop-scrollTop)/steps;
		var interval = setInterval(function () {
			scrollTop += pixelsPerStep;
			scrollingNode.scrollTop = scrollTop;
			if (!steps--) {
				clearInterval(interval);
				scrollingNode.style.pointerEvents = '';
				scrollingNode.scrollTop = targetScrollTop;
				setTimeout(function () {
					self.isPerformingAnimation = false;
					self = null;
				}, 10);
			}
		}, 10);
	};
	

	Object.defineProperty(UIPickerView.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: this.readableNameForProperty('titleStrings'), keyPath: 'titleStrings', type: 'textarea', positionLeft: true, acceptsReturn:true, textFieldHeight: 200 },
						{ name: '   '+this.readableNameForProperty('selectedRow1'), keyPath: 'selectedRow1', type: 'number', labelOnTop:true, range: [0,1000], positionLeft:true },
					]
				},
		
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
						{ name: this.readableNameForProperty('backgroundColor'), keyPath: 'e_backgroundColor', dataKeyPath: 'backgroundColor', type: 'color' },
						{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true, offsetX: 44 },
					]
				},
			];

		}});
	

	Object.defineProperty(UIPickerView.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['titleStrings', this.readableNameForProperty('titleStrings')],
				['selectedRow1', this.readableNameForProperty('selectedRow1')],
				['selectedRow', this.readableNameForProperty('selectedRow')]
			);
			return result;
		}});
	
	
UIPickerView.prototype.readableNameForProperty = function UIPickerView_readableNameForProperty(theProperty) {
		switch (theProperty) {
			case 'titleStrings': return LocalizedString('Labels');
			case 'selectedRow1': return LocalizedString('Selected #');
			case 'selectedRow': return LocalizedString('Selected # (0-index)');
			case 'selectedRowText': return LocalizedString('Text');
		}
		return __super.prototype.readableNameForProperty.call(this, theProperty);};
	

UIPickerView.prototype.prepareForEditor = function UIPickerView_prepareForEditor(editor) {
		__super.prototype.prepareForEditor.call(this, editor);

		this.DOMNode.className += ' canClickInActionMode';
		
		this.DOMNode.onmousemove = function () {
			return;
			var shouldReactToScrolling = (editor.editedSubview === this.superview);
			if (this.scrollingBackgroundView) this.scrollingBackgroundView.style({pointerEvents:shouldReactToScrolling?'':'none'});
		}.bind(this);
		
		this.addFixLayoutTimer();
		
		getPrototype('info.appdoo-mac.PickerViewDataProvider').addDataProviderToObject(this);};
	

	Object.defineProperty(UIPickerView.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	

UIPickerView.prototype.deleteForEditor = function UIPickerView_deleteForEditor(editor) {
		__super.prototype.deleteForEditor.call(this, editor);
		this.removeFixLayoutTimer();};
	
	
UIPickerView.prototype.destroy = function UIPickerView_destroy() {
		__super.prototype.destroy.call(this);
		this.removeFixLayoutTimer();};
	
	
	Object.defineProperty(UIPickerView.prototype, "fixLayoutInterval", {
	synthesized: true, get:function () { return this._fixLayoutInterval; }, set:function (v) {if (!Object.hasOwnProperty(this, "_fixLayoutInterval")) Object.defineProperty(this, "_fixLayoutInterval", { writable: true, configurable: true }); this._fixLayoutInterval = v; }});
	
	
UIPickerView.prototype.addFixLayoutTimer = function UIPickerView__addFixLayoutTimer() {
		if (this.fixLayoutInterval) this.removeTimer();
		this.fixLayoutInterval = setInterval(function () {
			if (this.scrollingBackgroundView.DOMNode.scrollTop === 0 &&
				this.selectedRow !== 0 && !this.isPerformingAnimation && !this.isScrolling)
				this.fixLayout();
		}.bind(this), 50);};
	

UIPickerView.prototype.removeFixLayoutTimer = function UIPickerView__removeFixLayoutTimer() {
		if (!this.fixLayoutInterval) return;
		clearInterval(this.fixLayoutInterval);};
	
	
UIPickerView.prototype.fixLayout = function UIPickerView__fixLayout() {
		this.setSelectedRowAnimated(this.selectedRow, false);};
	
	
	Object.defineProperty(UIPickerView.prototype, "isFormElement", {
		value: true});
	

	Object.defineProperty(UIPickerView.prototype, "value", {
		get: function () { return this.selectedRow; }});
	

	Object.defineProperty(UIPickerView.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/UIPickerView.png';
		}});
	

UIPickerView.prototype.transformData = function UIPickerView_transformData(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		
		if (transformer.isXIBGenerator) {
			result.connections = {};
		
			transformer.demandPluginWithIdentifier('info.appdoo-mac.PickerViewDataSource');
	
			var dataSource = createComponentFromDomain('PickerViewDataSource', 'info.appdoo-mac', _context.projectContext, {
				valuesString: data.rowTitles ? data.rowTitles.join('\n') : '',
				selectedRow: data.selectedRow
			});
	
			transformer.registerInlineObject(dataSource);
	
			result.connections['outlet dataSource'] = {
					property: "dataSource",
					destination: transformer.storyboardIDForComposeObject(dataSource),
					id: transformer.createStoryboardID()
				};
			result.connections['outlet delegate'] = {
					property: "delegate",
					destination: transformer.storyboardIDForComposeObject(dataSource),
					id: transformer.createStoryboardID()
				};
	
		}
		else {
			result.$type = 'UIPickerView';
	
	
			var dataSource = createComponentFromDomain('PickerViewDataSource', 'info.appdoo-mac', _context.projectContext, {
				valuesString: data.rowTitles ? data.rowTitles.join('\n') : '',
				selectedRow: data.selectedRow
			});
	
			result.delegate = { $type: '$Reference', destination: dataSource.identify() };
			result.dataSource = dataSource.transformData(dataSource.encode(), transformer);
			transformer.setBooleanProperty(result, 'showsSelectionIndicator', true);
	
		}
		if (data.dataProvider) {
			var dataProvider = transformer.addDataProviderToObject(result, data);
			transformer.registerInverseBinding(result, data, 'selectedRow1', 'picker', data.dataProvider.$id, dataProvider);
			transformer.registerInverseBinding(result, data, 'selectedRow', 'picker', data.dataProvider.$id, dataProvider);
		}

		return result;};
	


UIPickerView.prototype.initPropertiesFromData = function UIPickerView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("rowTitles")) this.rowTitles = data.rowTitles;
if (data.hasOwnProperty("selectedRow")) this.selectedRow = data.selectedRow;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
};

UIPickerView.prototype.decodeData = function UIPickerView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

UIPickerView.prototype.encode = function UIPickerView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

UIPickerView.prototype.encodeCloned = function UIPickerView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

UIPickerView.prototype.expectedTypeForProperty = function UIPickerView_expectedTypeForProperty(key) {
	if (key === "rowTitles") return "Array";
	if (key === "didSetIndex") return "";
	if (key === "selectedRow") return "Number";
	if (key === "selectedRow1") return "";
	if (key === "textForSelectedRow") return "";
	if (key === "selectedRowText") return "String";
	if (key === "readableType") return "";
	if (key === "heightIsEditable") return "";
	if (key === "titleStrings") return "StringOrArray";
	if (key === "pickerLabels") return "Array";
	if (key === "scrollingBackgroundView") return "View";
	if (key === "scrollingSelectionView") return "View";
	if (key === "bordersView") return "View";
	if (key === "isScrolling") return "Boolean";
	if (key === "e_backgroundColor") return "String";
	if (key === "isPerformingAnimation") return "";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "dataProvider") return "PickerViewDataProvider";
	if (key === "fixLayoutInterval") return "";
	if (key === "isFormElement") return "";
	if (key === "value") return "";
	if (key === "outlineIconURL") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIPickerView; }()));
registerType('info.appdoo-mac', (function () { function PickerViewDataSource() {} var __super = setSupertypeFromDomain(PickerViewDataSource, 'BasicEditableObject', 'appdoo');

	Object.defineProperty(PickerViewDataSource.prototype, "valuesString", {
	outlet: true, 
	enumerable: true, get:function () { return this._valuesString; }, set:function (v) {if (!Object.hasOwnProperty(this, "_valuesString")) Object.defineProperty(this, "_valuesString", { writable: true, configurable: true }); this._valuesString = v; }});
	

	Object.defineProperty(PickerViewDataSource.prototype, "selectedRow", {
	outlet: true, 
	enumerable: true, get:function () { return this._selectedRow; }, set:function (v) {if (!Object.hasOwnProperty(this, "_selectedRow")) Object.defineProperty(this, "_selectedRow", { writable: true, configurable: true }); this._selectedRow = v; }});
	

	Object.defineProperty(PickerViewDataSource.prototype, "needsNoObjCOutlet", {
		value: true});
	
	
PickerViewDataSource.prototype.pvds_transformDataForXIB = function PickerViewDataSource_pvds_transformDataForXIB(data, transformer) {
		var result = {
			customClass: 'PickerViewDataSource',
			userDefinedRuntimeAttributes: {}
		};
		
		transformer.object__addUserDefinedRuntimeAttribute__(result, {
			keyPath: 'valuesString',
			type: 'string',
			value: data.valuesString
		});

		transformer.object__addUserDefinedRuntimeAttribute__(result, {
			keyPath: 'selectedRow',
			type: 'number',
			integer: { key: 'value', value: data.selectedRow }
		});
		
		return result;};
	
	
PickerViewDataSource.prototype.pvds_transformDataForPreview = function PickerViewDataSource_pvds_transformDataForPreview(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		result.valuesString = transformer.transformString(data.valuesString);
		result.selectedRow = transformer.transformInteger(data.selectedRow);
		return result;};
	
	
PickerViewDataSource.prototype.transformData = function PickerViewDataSource_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.pvds_transformDataForXIB(data, transformer);
		return this.pvds_transformDataForPreview(data, transformer);};
	

PickerViewDataSource.prototype.initPropertiesFromData = function PickerViewDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("valuesString")) this.valuesString = data.valuesString;
if (data.hasOwnProperty("selectedRow")) this.selectedRow = data.selectedRow;
};

PickerViewDataSource.prototype.decodeData = function PickerViewDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

PickerViewDataSource.prototype.encode = function PickerViewDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

PickerViewDataSource.prototype.encodeCloned = function PickerViewDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

PickerViewDataSource.prototype.expectedTypeForProperty = function PickerViewDataSource_expectedTypeForProperty(key) {
	if (key === "valuesString") return "String";
	if (key === "selectedRow") return "Number";
	if (key === "needsNoObjCOutlet") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return PickerViewDataSource; }()));
registerType('info.appdoo-mac', (function () { function PickerViewDataProvider() {} var __super = setSupertypeFromDomain(PickerViewDataProvider, 'DataProvider', 'info.appdoo-mac');

	Object.defineProperty(PickerViewDataProvider.prototype, "propertiesForBindings", {
		value: ['selectedRow', 'selectedRow1', 'selectedRowText']});
	
	
PickerViewDataProvider.prototype.transformData = function PickerViewDataProvider_transformData(data, transformer) {

		var result = __super.prototype.transformData.call(this, data, transformer);
		transformer.setReferenceProperty(result, 'picker', data.$id, data.objectID);

		return result;};
	

PickerViewDataProvider.prototype.expectedTypeForProperty = function PickerViewDataProvider_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return PickerViewDataProvider; }()));
registerType('appdoo.iOS', (function () { function UIDatePicker() {} var __super = setSupertypeFromDomain(UIDatePicker, 'UIView', 'appdoo.iOS');

	var UIDATEPICKER_HEIGHT = 216;

	Object.defineProperty(UIDatePicker.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(UIDatePicker.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/UIDatePicker.png';
		}});
	

	Object.defineProperty(UIDatePicker.prototype, "iconURL", {
		get: function () {
			return 'Resources/UIDatePicker48.png';
		}});
	
	
	Object.defineProperty(UIDatePicker.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Allows the user to select a date/time value');
		}});
	

UIDatePicker.prototype.createForSuperview = function UIDatePicker_createForSuperview(superview) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: superview.size.width, height: UIDATEPICKER_HEIGHT },
			position: { left: 0, top: 0 },
			autoresizingMask: 2,
			
			backgroundColor: 'rgb(255,255,255)',
			name: superview.context.nameForNewFormControl(this),
			countDownDuration: 60*10,
			datePickerMode: 'dateAndTime'
		});
	};
	

	Object.defineProperty(UIDatePicker.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	
	
UIDatePicker.prototype.prepareForEditor = function UIDatePicker_prepareForEditor(editor) {
		this.showPlaceholder();
		getPrototype('info.appdoo-mac.DatePickerDataProvider').addDataProviderToObject(this);};
	

	Object.defineProperty(UIDatePicker.prototype, "datePickerMode", {
	outlet: true, 
	enumerable: true, get:function () { return this._datePickerMode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_datePickerMode")) Object.defineProperty(this, "_datePickerMode", { writable: true, configurable: true }); this._datePickerMode = v; }});
	


	Object.defineProperty(UIDatePicker.prototype, "countDownDuration", {
	outlet: true, 
	enumerable: true, get:function () { return this._countDownDuration; }, set:function (v) {if (!Object.hasOwnProperty(this, "_countDownDuration")) Object.defineProperty(this, "_countDownDuration", { writable: true, configurable: true }); this._countDownDuration = v; }});
	
	
	Object.defineProperty(UIDatePicker.prototype, "countDownDurationInMinutes", {
		get: function () { return this.countDownDuration/60||0; }, 
		set: function (v) { this.countDownDuration = v*60||0; }});
	


	Object.defineProperty(UIDatePicker.prototype, "unixTime", {
	outlet: true, 
	enumerable: true, 
		get: function () { return 0; }, set:function (v) {if (!Object.hasOwnProperty(this, "_unixTime")) Object.defineProperty(this, "_unixTime", { writable: true, configurable: true }); this._unixTime = v; }});
	

	Object.defineProperty(UIDatePicker.prototype, "formattedDate", {
	outlet: true, 
	enumerable: true, 
		get: function () { return '…'; }, set:function (v) {if (!Object.hasOwnProperty(this, "_formattedDate")) Object.defineProperty(this, "_formattedDate", { writable: true, configurable: true }); this._formattedDate = v; }});
	

	var UIDatePickerMode,
		UIDatePickerModeTime = 0,
		UIDatePickerModeDate = 1,
		UIDatePickerModeDateAndTime = 2,
		UIDatePickerModeCountDownTimer = 3;
	var UIDatePickerModeByString = {
		'time': UIDatePickerModeTime,
		'date': UIDatePickerModeDate,
		'dateAndTime': UIDatePickerModeDateAndTime,
		'countDownTimer': UIDatePickerModeCountDownTimer
	};

	Object.defineProperty(UIDatePicker.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ type: 'select', keyPath: 'datePickerMode', name: this.readableNameForProperty('datePickerMode'), options: [
							['time',LocalizedString('Time')],
							['date',LocalizedString('Date')],
							['dateAndTime',LocalizedString('Date and Time')],
							['countDownTimer',LocalizedString('Countdown Timer')],
						] },
					]
				},
		
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
						{ name: this.readableNameForProperty('backgroundColor'), keyPath: 'e_backgroundColor', dataKeyPath: 'backgroundColor', type: 'color', undefinedValue: 'rgba(255,255,255, 1)' },
						{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true, offsetX: 44 },
		
					]
				},
			];

		}});
	

	Object.defineProperty(UIDatePicker.prototype, "isFormElement", {
		value: true});
	

	Object.defineProperty(UIDatePicker.prototype, "value", {
		get: function () {
			if (this.datePickerMode === 'countDownTimer')
				return this.countDownDurationInMinutes;
			if (this.datePickerMode === 'time')
				return zeroFill(new Date().getHours(),2)+':'+zeroFill(new Date().getMinutes(),2);
			if (this.datePickerMode === 'date')
				return (new Date().getFullYear())+'-'+zeroFill(new Date().getMonth()+1,2)+'-'+zeroFill(new Date().getDate(), 2);
			if (this.datePickerMode === 'dateAndTime')
				return (new Date().getTime()/1000)|0;
		}});
	

	Object.defineProperty(UIDatePicker.prototype, "readableType", {
		get: function () { return LocalizedString('Date Picker'); }});
	

UIDatePicker.prototype.readableNameForProperty = function UIDatePicker_readableNameForProperty(theProperty) {
		switch (theProperty) {
			case 'datePickerMode': return LocalizedString('Kind');
			case 'countDownDuration': return LocalizedString('Countdown (sec)');
			case 'countDownDurationInMinutes': return LocalizedString('Minutes');
			case 'unixTime': return LocalizedString('Unix Time');
			case 'formattedDate': return LocalizedString('Formatted Date');
		}
		return __super.prototype.readableNameForProperty.call(this, theProperty);};
	
	
UIDatePicker.prototype.transformData = function UIDatePicker_transformData(data, transformer) {

		if (transformer.isXIBGenerator) {
			transformer.demandPluginWithIdentifier('info.appdoo-mac.DatePickerDataProvider');
		}
		var result = __super.prototype.transformData.call(this, data, transformer);
		transformer.setIntegerProperty(result, 'countDownDuration', data.countDownDuration);
		transformer.setIntegerProperty(result, 'datePickerMode', UIDatePickerModeByString[data.datePickerMode]);
		transformer.setColorProperty(result, 'backgroundColor', (data.backgroundColor || 'rgba(255,255,255, 1)'));

		if (!transformer.isXIBGenerator) {
			result.$propertyPriorities['countDownDuration'] = -1000;
		}

		if (data.dataProvider) {
			var dataProvider = transformer.addDataProviderToObject(result, data);
			transformer.registerInverseBinding(result, data, 'unixTime', 'control', data.dataProvider.$id, dataProvider);
			transformer.registerInverseBinding(result, data, 'formattedDate', 'control', data.dataProvider.$id, dataProvider);
			transformer.registerInverseBinding(result, data, 'countDownDuration', 'control', data.dataProvider.$id, dataProvider);
		}

		return result;};
	

UIDatePicker.prototype.transformChangeForAppdooPreview = function UIDatePicker_transformChangeForAppdooPreview(change, transformer, result) {

		switch (change.keyPath) {
		
			case 'countDownDuration':
				result.keyPath = change.keyPath;
				result.value = transformer.transformInteger(change.valueNow);
				return true;
			case 'countDownDurationInMinutes':
				result.keyPath = 'countDownDuration';
				result.value = transformer.transformInteger(change.valueNow*60);
				return true;
		}
		
		return __super.prototype.transformChangeForAppdooPreview.call(this, change, transformer, result);};
	
	
	Object.defineProperty(UIDatePicker.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['unixTime', this.readableNameForProperty('unixTime')],
				['formattedDate', this.readableNameForProperty('formattedDate')],
				['countDownDuration', this.readableNameForProperty('countDownDuration')]
			);
			return result;
		}});
	


UIDatePicker.prototype.initPropertiesFromData = function UIDatePicker_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
if (data.hasOwnProperty("datePickerMode")) this.datePickerMode = data.datePickerMode;
if (data.hasOwnProperty("countDownDuration")) this.countDownDuration = data.countDownDuration;
if (data.hasOwnProperty("unixTime")) this.unixTime = data.unixTime;
if (data.hasOwnProperty("formattedDate")) this.formattedDate = data.formattedDate;
};

UIDatePicker.prototype.decodeData = function UIDatePicker_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

UIDatePicker.prototype.encode = function UIDatePicker_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

UIDatePicker.prototype.encodeCloned = function UIDatePicker_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

UIDatePicker.prototype.expectedTypeForProperty = function UIDatePicker_expectedTypeForProperty(key) {
	if (key === "heightIsEditable") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "readableDescription") return "";
	if (key === "dataProvider") return "DatePickerDataProvider";
	if (key === "datePickerMode") return "String";
	if (key === "countDownDuration") return "Number";
	if (key === "countDownDurationInMinutes") return "Number";
	if (key === "unixTime") return "Number";
	if (key === "formattedDate") return "String";
	if (key === "inspectorProperties") return "";
	if (key === "isFormElement") return "";
	if (key === "value") return "";
	if (key === "readableType") return "";
	if (key === "bindableProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIDatePicker; }()));
registerType('info.appdoo-mac', (function () { function DatePickerDataProvider() {} var __super = setSupertypeFromDomain(DatePickerDataProvider, 'DataProvider', 'info.appdoo-mac');

	Object.defineProperty(DatePickerDataProvider.prototype, "propertiesForBindings", {
		value: ['unixTime','formattedDate','countDownDuration']});
	
	
DatePickerDataProvider.prototype.transformData = function DatePickerDataProvider_transformData(data, transformer) {

		var result = __super.prototype.transformData.call(this, data, transformer);
		transformer.setReferenceProperty(result, 'control', data.$id, data.objectID);

		return result;};
	

DatePickerDataProvider.prototype.expectedTypeForProperty = function DatePickerDataProvider_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DatePickerDataProvider; }()));