
registerType('appdoo.iOS', (function () { function UISearchBar() {} var __super = setSupertypeFromDomain(UISearchBar, 'UIBar', 'appdoo.iOS');

	Object.defineProperty(UISearchBar.prototype, "actionType", {
	outlet: true, 
	enumerable: true, get:function () { return this._actionType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_actionType")) Object.defineProperty(this, "_actionType", { writable: true, configurable: true }); this._actionType = v; }});
	

	Object.defineProperty(UISearchBar.prototype, "actionInfo", {
	outlet: true, 
	enumerable: true, 
		get: function () { return EditableObjectGetActionInfoProperty.call(this); }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_actionInfo")) Object.defineProperty(this, "_actionInfo", { writable: true, configurable: true }); EditableObjectSetActionInfoProperty.call(this, v); }});
	

	Object.defineProperty(UISearchBar.prototype, "e_actionObjectID", {
		get: function ( ) { return this.actionInfo.objectID; }, 
		set: function (v) { this.actionInfo.objectID = v; _context.editor.refreshInspector(); }});
	


UISearchBar.prototype.init = function UISearchBar_init() {
		__super.prototype.init.call(this);

		var isSystem7 = this.context.simulatedSystemVersion >= 7;
		this.size.height = isSystem7 ? 40 : 44;
		if (!this.size.width) this.size.width = 320;
		
		this.createBackgroundView();
		this.createSearchField();
		this.createClearButton();
		this.styleDefault();
		
		return this;};
	

	Object.defineProperty(UISearchBar.prototype, "encodesSubviews", {
		value: false});
	

	Object.defineProperty(UISearchBar.prototype, "backgroundView", {
	synthesized: true, get:function () { return this._backgroundView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_backgroundView")) Object.defineProperty(this, "_backgroundView", { writable: true, configurable: true }); this._backgroundView = v; }});
	

	Object.defineProperty(UISearchBar.prototype, "searchFieldView", {
	synthesized: true, get:function () { return this._searchFieldView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_searchFieldView")) Object.defineProperty(this, "_searchFieldView", { writable: true, configurable: true }); this._searchFieldView = v; }});
	

	Object.defineProperty(UISearchBar.prototype, "searchField", {
	synthesized: true, get:function () { return this._searchField; }, set:function (v) {if (!Object.hasOwnProperty(this, "_searchField")) Object.defineProperty(this, "_searchField", { writable: true, configurable: true }); this._searchField = v; }});
	
	
UISearchBar.prototype.createBackgroundView = function UISearchBar__createBackgroundView() {
		this.backgroundView = createComponentFromDomain("UIView", "appdoo.iOS", this.context, {
			size: { width: this.size.width, height: 40 },
			position: { top: 0 },
			autoresizingMask: 2})
		;
		this.addSubview(this.backgroundView);};
	
	
UISearchBar.prototype.createSearchField = function UISearchBar__createSearchField() {
	
		var isSystem7 = this.context.simulatedSystemVersion >= 7;


		this.searchFieldView = this.context.decodeObjectTree({
			$type: 'UIView',
			$domain: 'appdoo.iOS',
			size: { width: this.size.width-10, height: 43-13 },
			position: { left: 5, top: 7 },
			autoresizingMask: 2,
			clipsSubviews: true,
			subviews: [
				{
					$type: 'ImageView',
					$domain: 'Core.UI',
					size: { width: 16, height: 16 },
					position: { left: 9, top: 7 }
				}
			]
		});
			
		var searchFieldSize = { width: this.size.width-10-2, height: 43-13-2 };
		
		this.searchField = this.context.decodeObjectTree({
			$type: 'UIView',
			$domain: 'appdoo.iOS',
			size: searchFieldSize,
			position: { left: 1, top: 1 },
			autoresizingMask: 2,
			subviews: [{
				$type: 'UILabel',
				$domain: 'appdoo.iOS',
				text: '',
				position: { left: 30, top: 6 },
				size: { width: searchFieldSize.width-30, height: 18 },
				autoresizingMask: 2,
				fontSize: 14,
				textAlignment: isSystem7 ? 'center' : 'left',
			}]
		});

		this.searchFieldView.insertSubviewAtIndex(this.searchField, 0);
		this.addSubview(this.searchFieldView);
		this.updateTextField();};
	
	
	Object.defineProperty(UISearchBar.prototype, "clearButton", {
	synthesized: true, get:function () { return this._clearButton; }, set:function (v) {if (!Object.hasOwnProperty(this, "_clearButton")) Object.defineProperty(this, "_clearButton", { writable: true, configurable: true }); this._clearButton = v; }});
	
	
UISearchBar.prototype.createClearButton = function UISearchBar__createClearButton() {
		this.clearButton = createComponentFromDomain("SpriteButton", "Core.UI", this.context, {
			size: { width: 14, height: 14 },
			position: { left: this.size.width-30+2-5+1, top: 13-5 },
			autoresizingMask: 1,
			style: { cursor: 'default', opacity: .8 },
			sprite: _context.pathForResource('UISearchBarClearButton.png'),
			action: function (e) {
				this.dataController.setValueForKey('', 'text', this.dataController);
			}.bind(this),
			hidden: !!!this.text})
		;
		this.searchFieldView.addSubview(this.clearButton);};
	
	
	Object.defineProperty(UISearchBar.prototype, "readableType", {
		get: function () {
			return LocalizedString('Search Bar');
		}});
	
	
UISearchBar.prototype.styleDefaultSystem6 = function UISearchBar_styleDefaultSystem6() {
	return;
		this.backgroundView.style({
				borderTop: '1px solid rgb(175,187,196)',
				borderBottom: '1px solid rgb(147,163,175)',
				backgroundImage: '-webkit-linear-gradient(rgb(232,237,241) 0%, rgb(222,228,232) 5%, rgb(192,202,208) 100%)'
			});
	
		this.searchFieldView.style({
				backgroundImage: '-webkit-linear-gradient(rgb(141,159,178), rgb(177,189,198))',
				borderRadius: '20px'
			});
			
		this.searchField.style({
				backgroundColor: '#fff',
				borderRadius: '20px',
				boxShadow: 'inset 0 1px 3px rgba(0,0,0,.5)'
			});

		var suffix = '_Original';
		this.searchFieldView.subviews[1].imageSrc = 'Resources/UISearchFieldIcon'+suffix+'.png';
};
	

UISearchBar.prototype.styleDefaultSystem7 = function UISearchBar_styleDefaultSystem7() {
	
		var isBlack = (this.barStyle === UIBarStyleBlack);
	
		var bgColor = isBlack ? 'hsl(0,0%,22%)' : 'hsl(0,0%,82%)',
			searchBgColor = isBlack ? 'hsl(0,0%,15%)' : 'hsl(0,0%,100%)';
	

		this.backgroundView.style({
				backgroundColor: bgColor
			});

		this.searchField.style({
				backgroundColor: searchBgColor,
				borderRadius: '5px'
			});
		this.searchFieldView.position.top = 5;
			
		var suffix = '_New';
		if (this.barStyle === UIBarStyleBlack) suffix += 'Bright';
		this.searchFieldView.subviews[1].imageSrc = 'Resources/UISearchFieldIcon'+suffix+'.png';

		this.textLabel.textColor = this.text ? this.textColor : this.placeholderTextColor;
	};
	
	
	
UISearchBar.prototype.createForSuperview = function UISearchBar_createForSuperview(superview) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: 320, height: 44 },
			position: { left: 0, top: 0 },
			autoresizingMask: 34,
			
			placeholder: LocalizedString('Search'),
			text: '',
			name: superview.context.nameForNewFormControl(this),
			triggersActionOnInput: true,
		});
	};
	
	
	Object.defineProperty(UISearchBar.prototype, "triggersActionOnInput", {
	outlet: true, 
	enumerable: true, get:function () { return this._triggersActionOnInput; }, set:function (v) {if (!Object.hasOwnProperty(this, "_triggersActionOnInput")) Object.defineProperty(this, "_triggersActionOnInput", { writable: true, configurable: true }); this._triggersActionOnInput = v; }});
	

	Object.defineProperty(UISearchBar.prototype, "inspectorProperties", {
		get: function () {

			var isSystem7 = this.context.simulatedSystemVersion >= 7;

			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'button',
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						
						{ name: LocalizedString('Text'), type: 'textarea', keyPath: 'text', textFieldHeight: 26 },
						
						{ name: LocalizedString('Placeholder'), type: 'textarea', keyPath: 'placeholder',labelOnTop:true,textFieldHeight: 26 },

						{ name: LocalizedString('Dark style'), keyPath: 'e_barStyleIsBlack', type: 'boolean', positionLeft:true, hidden: !isSystem7 },

						{ name: LocalizedString('Trigger Action While Typing'), keyPath:'triggersActionOnInput', type: 'boolean', positionLeft:true, },

						{type:'space'},

						{ type: 'action', currentActionType: this.actionType, currentActionObjectID: this.e_actionObjectID },
					]
				},

				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				},
				
			];
		}});
	
	
UISearchBar.prototype.transformData = function UISearchBar_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.searchBar_transformDataForXIB(data, transformer);
		return this.searchBar_transformDataForPreview(data, transformer);};
	
	
UISearchBar.prototype.searchBar_transformDataForXIB = function UISearchBar_searchBar_transformDataForXIB(data, transformer) {

		var result = __super.prototype.transformData.call(this, data, transformer);

		result.text = data.text;
		result.placeholder = data.placeholder;
		if (data.barStyle === UIBarStyleBlack)
			result.barStyle = "black";
		
		var dataProvider = createComponentFromDomain('SearchBarDataProvider', 'info.appdoo-mac', _context.projectContext, {
			searchBar: data,
			actionType: data.actionInfo.actionType,
			actionInfo: data.actionInfo,
			triggersActionOnInput: data.triggersActionOnInput
		});
		dataProvider.$id = data.$id+'DataProvider';

		var valueBinding = this.bindingForKey.call(data, 'text');
		if (valueBinding) {
			var destinationObject = _context.projectContext.connectableObjects[valueBinding.destination];
			if (destinationObject && destinationObject.mutable) {
				valueBinding = _context.createReverseBinding(valueBinding);
				valueBinding.destinationKeyPath = 'contents.text';
				valueBinding.destination = dataProvider.$id;
				valueBinding.transformer = 'TO_STRING';
				valueBinding.treatAsReverseBinding = true; 
				dataProvider._bindings = [valueBinding];
			}
		}

		transformer.registerInlineObject(dataProvider);
		
		transformer.connectOutletNamed__in__to__result__('delegate', data.$id, dataProvider.$id, result);

		return result;
};
	

UISearchBar.prototype.searchBar_transformDataForPreview = function UISearchBar_searchBar_transformDataForPreview(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		
		transformer.setStringProperty(result, 'text', data.text, true);
		transformer.setStringProperty(result, 'placeholder', data.placeholder, true);

		if (!transformer.isXIBGenerator)
			result.barStyle = transformer.transformInteger(data.barStyle);
		
		
		var dataProvider = createComponentFromDomain('SearchBarDataProvider', 'info.appdoo-mac', _context.projectContext, {
			searchBar: data,
			actionType: data.actionInfo.actionType,
			actionInfo: data.actionInfo,
			triggersActionOnInput: data.triggersActionOnInput
		});
		dataProvider.$id = data.$id+'DataProvider';
		
		result.delegate = dataProvider.transformData(dataProvider.encode(), transformer);

		return result;};
	

	
	Object.defineProperty(UISearchBar.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(UISearchBar.prototype, "bindableProperties", {
		get: function () {
			return [
				['text', this.readableNameForProperty('text')],
				['placeholder', this.readableNameForProperty('placeholder')],
				['hidden', this.readableNameForProperty('hidden')],
			];
		}});
	
	
	Object.defineProperty(UISearchBar.prototype, "text", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_text")) Object.defineProperty(this, "_text", { writable: true, configurable: true });
			if (typeof v !== 'string') v = '';
			if (this._text === v) return;
			var isUpdating = this._text !== undefined;
			this._text = v;
			if (isUpdating) { this.updateTextField(); this.dataProvider.notifyObservers(); }
		}, get:function () { return this._text; }});
	

	Object.defineProperty(UISearchBar.prototype, "placeholder", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_placeholder")) Object.defineProperty(this, "_placeholder", { writable: true, configurable: true });
			if (typeof v !== 'string') v = '';
			var isUpdating = this._placeholder !== undefined;
			this._placeholder = v;
			if (isUpdating) { this.updateTextField(); }
		}, get:function () { return this._placeholder; }});
	
	
	Object.defineProperty(UISearchBar.prototype, "placeholderTextColor", {
		get: function ( ) {
			var isSystem7 = this.context.simulatedSystemVersion >= 7;
			if (isSystem7) {
				var isBlack = (this.barStyle === UIBarStyleBlack);
				if (isBlack)
					return 'hsl(0,0%,55%)';
				else
					return 'hsl(0,0%,64%)';
			}
			return 'hsl(0,0%,75%)';
		}});
	
	
	Object.defineProperty(UISearchBar.prototype, "textColor", {
		get: function ( ) {
			var isSystem7 = this.context.simulatedSystemVersion >= 7;
			if (isSystem7) {
				var isBlack = (this.barStyle === UIBarStyleBlack);
				if (isBlack)
					return this.placeholderTextColor;
				else
					return 'black';
			}
			return 'black';
		}});
	

	
	Object.defineProperty(UISearchBar.prototype, "textLabel", {
		get: function () {
			return this.searchField.subviews[0];
		}});
	

UISearchBar.prototype.updateTextField = function UISearchBar__updateTextField() {
		if (!this.searchField) return;

		var label = this.textLabel;
		label.text = (this.text || this.placeholder);
		label.textColor = this.text ? this.textColor : this.placeholderTextColor;
		
		
		var isSystem7 = this.context.simulatedSystemVersion >= 7;
		if (!isSystem7) return;

		var magnifier = this.searchFieldView.subviews[1];
		var placeholderIsVisible = !this.text;
		if (this.clearButton) this.clearButton.hidden = placeholderIsVisible;

		if (placeholderIsVisible) {

			var width = label.widthForTextWithAttributes(label.text, {
				fontFamily: label.DOMNode.style.fontFamily,
				fontSize: label.fontSize,
				height: label.height,
				whiteSpace: 'nowrap',
			});

			magnifier.position.left = (magnifier.superview.size.width/2 - width/2-8-(label.text ? 6 : 0));
			magnifier.autoresizingMask = 45;
			label.textAlignment = 'center';
			label.position.left = 10+8;
			label.size.width = label.superview.size.width-24;
		}
		else {
			magnifier.position.left = 9;
			magnifier.autoresizingMask = 0;
			label.textAlignment = 'left';
			label.position.left = 30;
			label.size.width = label.superview.size.width-35;
		}
};
	


	Object.defineProperty(UISearchBar.prototype, "isFormElement", {
		value: true});
	
	
	Object.defineProperty(UISearchBar.prototype, "value", {
		get: function () { return this.text; }});
	
	
	Object.defineProperty(UISearchBar.prototype, "dataProvider", {
	synthesized: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	
	
UISearchBar.prototype.prepareForEditor = function UISearchBar_prepareForEditor(editor) {
	
		__super.prototype.prepareForEditor.call(this, editor);
	
		if (this.DOMNode)
		this.DOMNode.ondblclick = function () {
		
			if (editor.editedSubview === this.superview) {
				this.editDefault(editor);
			}
					
		}.bind(this);

		this.DOMNode.onclick = function (e) {
			if (editor.isActionClick(e)) this.action();
		}.bind(this);
		
		this.DOMNode.className += ' canClickInActionMode';
		
		getPrototype('info.appdoo-mac.SearchBarDataProvider').addDataProviderToObject(this);
};
	
	
UISearchBar.prototype.editDefault = function UISearchBar_editDefault(editor) {
	
		
		if (this.hasBindingForKey('text')) {
			this.context.beep();
			return true;
		}
		
		return this.textLabel.editDefault(editor, this.dataController);
};
	
	
UISearchBar.prototype.action = function UISearchBar_action() {
		this.editDefault(_context.editor);};
	

UISearchBar.prototype.destroy = function UISearchBar_destroy() {
		__super.prototype.destroy.call(this);
		if (this.dataProvider) this.dataProvider.destroy();};
	


UISearchBar.prototype.readableNameForProperty = function UISearchBar_readableNameForProperty(name) {
		switch (name) {
			case 'text': return LocalizedString('Text');
			case 'placeholder': return LocalizedString('Placeholder Text');
		}
		return __super.prototype.readableNameForProperty.call(this, name);};
	

	Object.defineProperty(UISearchBar.prototype, "outlineIconURL", {
		value: 'Resources/UISearchBar.png'});
	

UISearchBar.prototype.initPropertiesFromData = function UISearchBar_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("actionType")) this.actionType = data.actionType;
if (data.hasOwnProperty("actionInfo")) this.actionInfo = data.actionInfo;
if (data.hasOwnProperty("triggersActionOnInput")) this.triggersActionOnInput = data.triggersActionOnInput;
if (data.hasOwnProperty("text")) this.text = data.text;
if (data.hasOwnProperty("placeholder")) this.placeholder = data.placeholder;
};

UISearchBar.prototype.decodeData = function UISearchBar_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("actionInfo")) decoded.actionInfo = this.context.decodeObjectTree(data.actionInfo);
return decoded; };

UISearchBar.prototype.encode = function UISearchBar_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._actionInfo && this._actionInfo.encode) {encoded.actionInfo = this.actionInfo.encode();
}return encoded; };

UISearchBar.prototype.encodeCloned = function UISearchBar_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._actionInfo && this._actionInfo.encode) {encoded.actionInfo = this.actionInfo.encodeCloned();
}return encoded; };

UISearchBar.prototype.expectedTypeForProperty = function UISearchBar_expectedTypeForProperty(key) {
	if (key === "actionType") return "String";
	if (key === "actionInfo") return "ActionInfo";
	if (key === "e_actionObjectID") return "";
	if (key === "encodesSubviews") return "";
	if (key === "backgroundView") return "";
	if (key === "searchFieldView") return "";
	if (key === "searchField") return "";
	if (key === "clearButton") return "";
	if (key === "readableType") return "";
	if (key === "triggersActionOnInput") return "Boolean";
	if (key === "inspectorProperties") return "";
	if (key === "heightIsEditable") return "";
	if (key === "bindableProperties") return "";
	if (key === "text") return "String";
	if (key === "placeholder") return "String";
	if (key === "placeholderTextColor") return "";
	if (key === "textColor") return "";
	if (key === "textLabel") return "";
	if (key === "isFormElement") return "";
	if (key === "value") return "";
	if (key === "dataProvider") return "SearchBarDataProvider";
	if (key === "outlineIconURL") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UISearchBar; }()));