
registerType('appdoo.iOS', (function () { function UISegmentedControl() {} var __super = setSupertypeFromDomain(UISegmentedControl, 'UIView', 'appdoo.iOS');

	
	Object.defineProperty(UISegmentedControl.prototype, "segments", {
	outlet: true, 
	enumerable: true, 
		get: function () { return this._segments || []; }, set:function (v) {if (!Object.hasOwnProperty(this, "_segments")) Object.defineProperty(this, "_segments", { writable: true, configurable: true }); this._segments = v; }});
	
	
	Object.defineProperty(UISegmentedControl.prototype, "didSetSelectedSegmentIndex", {
	synthesized: true, get:function () { return this._didSetSelectedSegmentIndex; }, set:function (v) {if (!Object.hasOwnProperty(this, "_didSetSelectedSegmentIndex")) Object.defineProperty(this, "_didSetSelectedSegmentIndex", { writable: true, configurable: true }); this._didSetSelectedSegmentIndex = v; }});
	

	Object.defineProperty(UISegmentedControl.prototype, "selectedSegmentIndex", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_selectedSegmentIndex")) Object.defineProperty(this, "_selectedSegmentIndex", { writable: true, configurable: true });
			if (!this.didSetSelectedSegmentIndex) {
				this.didSetSelectedSegmentIndex = true;
				this._selectedSegmentIndex = v;
			}
			else {
				if (typeof v !== 'number' || isNaN(v)) v = parseInt(v)||0;
				if (v < 0) v = 0;
				if (this._selectedSegmentIndex === v) return;
				this._selectedSegmentIndex = v;
				this.segmentedControl.selectedIndex = v;
				this.drawBackground();
				this.dataProvider.notifyObservers();
			}
		}, get:function () { return this._selectedSegmentIndex; }});
	
	
	Object.defineProperty(UISegmentedControl.prototype, "selectedSegmentIndex1", {
		get: function () { return this.selectedSegmentIndex+1; }, 
		set: function (i) { this.selectedSegmentIndex = i-1; }});
	

	Object.defineProperty(UISegmentedControl.prototype, "selectedSegmentText", {
		get: function () { var segment = this.segments[this.selectedSegmentIndex]; if (segment !== undefined) return segment; }});
	

	Object.defineProperty(UISegmentedControl.prototype, "readableType", {
		get: function () { return LocalizedString('Segmented Control'); }});
	

	Object.defineProperty(UISegmentedControl.prototype, "heightIsEditable", {
		value: true});
	

UISegmentedControl.prototype.createForSuperview = function UISegmentedControl_createForSuperview(superview, options) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: 123, height: 29 },
			position: { left: 0, top: 0 },
			autoresizingMask: 36,
			segments: options&&options.segments ?options.segments: ['1', '2'],
			selectedSegmentIndex: 0,
			name: superview.context.nameForNewFormControl(this),
			fontFamily: 'System',
			fontName: '_DEFAULT_',
			fontSize: 13
		});
	};
	

UISegmentedControl.prototype.superviewDidChangeTintColor = function UISegmentedControl_superviewDidChangeTintColor(v) {
		if (this.tintColor) return;
		this.drawBackground();
		this.segmentedControl.labelColor = v;};
	
	
UISegmentedControl.prototype.init = function UISegmentedControl_init() {
		__super.prototype.init.call(this);
		this.createBackgroundCanvas();
		this.createSegmentedControlView();
		this.layoutSubviews();
		return this;};
	
	
	Object.defineProperty(UISegmentedControl.prototype, "backgroundCanvas", {
	synthesized: true, get:function () { return this._backgroundCanvas; }, set:function (v) {if (!Object.hasOwnProperty(this, "_backgroundCanvas")) Object.defineProperty(this, "_backgroundCanvas", { writable: true, configurable: true }); this._backgroundCanvas = v; }});
	
	
UISegmentedControl.prototype.createBackgroundCanvas = function UISegmentedControl__createBackgroundCanvas() {
		this.backgroundCanvas = document.createElement('canvas');
		this.DOMNode.appendChild(this.backgroundCanvas);};
	

	Object.defineProperty(UISegmentedControl.prototype, "segmentedControl", {
	synthesized: true, get:function () { return this._segmentedControl; }, set:function (v) {if (!Object.hasOwnProperty(this, "_segmentedControl")) Object.defineProperty(this, "_segmentedControl", { writable: true, configurable: true }); this._segmentedControl = v; }});
	
	
UISegmentedControl.prototype.encodesSubviews = function UISegmentedControl__encodesSubviews() {
		value: false};
	
	
UISegmentedControl.prototype.createSegmentedControlView = function UISegmentedControl__createSegmentedControlView() {
	
		if (this.segmentedControl) {
			this.segmentedControl.removeFromSuperview();
		}
		
		var sc = createComponentFromDomain("SegmentedControl", "Core.UI", this.context, {
			position: {left:0,top:1},
			selectedIndex: this.selectedSegmentIndex,
			size:this.sizeCopy,
			autoresizingMask: 18,
			drawsBackground: false,
			segments: this.segments.map(function (str) {
				return { label: str };
			}),
			fontSize: this.fontSize||13,
			fontFamily: realIOSFont(this.fontName||'_DEFAULT_'),
			labelColor: this.tintColor || this.context.defaultOrSystemTintColor,
			labelColorSelected: '#fff'})
		;
		
		sc.style({
			pointerEvents: 'none',
			webkitTransform: 'translateY(-0.5px)',
			overflow: 'hidden'
		});

		if (Array.isArray(sc.subviews)) sc.subviews.every(function (subview) {
			subview.DOMNode.style.pointerEvents = 'none';return true; }, this);
		

		this.addSubview(sc);
		this.segmentedControl = sc;};
	
	
UISegmentedControl.prototype.layoutSubviews = function UISegmentedControl_layoutSubviews() {
		__super.prototype.layoutSubviews.call(this);
		this.drawBackground();};
	
	
	
UISegmentedControl.prototype.drawBackground = function UISegmentedControl__drawBackground() {

		var width = this.size.width,
			height = this.size.height,
			scale = this.context.highResolutionEnabled ? 2 : 1,
			color = this.tintColor || this.context.defaultOrSystemTintColor,
			segmentWidth;

		this.backgroundCanvas.width = width*scale;
		this.backgroundCanvas.height = height*scale;
		this.backgroundCanvas.style.width = width+'px';
		this.backgroundCanvas.style.height = height+'px';
		
		var ctx = this.backgroundCanvas.getContext('2d');
		ctx.save();
		ctx.scale(scale, scale);
		
		
		ctx.strokeStyle = color;
		ctx.lineWidth = 1;
		ctx.roundRect(0.5,0.5,width-1,height-1,4);
		ctx.stroke();
		
		var segmentWidth = width/this.segments.length;
		
		
		for (var i = 1, c = this.segments.length; i < c; i++) {
			ctx.beginPath();
			var x = ((segmentWidth*i)|0)+1;
			ctx.moveTo(x,0);
			ctx.lineTo(x,height);
			ctx.stroke();
		}
		
		
		if (this.selectedSegmentIndex >= 0 && this.selectedSegmentIndex < this.segments.length) {
			ctx.fillStyle = color;
			
			
			var dx = this.selectedSegmentIndex*segmentWidth;
					
			if (this.selectedSegmentIndex === 0) {
				ctx.roundRect(0.5+0.5,0.5+0.5,8-1,height-1-1,3.5);
				ctx.fill();
				ctx.clearRect(0.5+4,0.5+0.5,4,height-1-1);
				dx += 4; segmentWidth -= 4;
			}
			else if (this.selectedSegmentIndex === this.segments.length-1) {
				ctx.roundRect(0.5+dx+segmentWidth-8-1,0.5+0.5,8-1+0.5,height-1-1,4);
				ctx.fill();
				ctx.clearRect(0.5+dx+segmentWidth-8-1,0.5+0.5,4+1,height-1-1);
				segmentWidth -= 4;
			}

			ctx.clearRect(0.5+dx,0.5+0.5,segmentWidth,height-1-1);
			ctx.fillRect(0.5+dx,0.5+0.5,segmentWidth,height-1-1);

		}
		
		ctx.restore();};
	
	
	Object.defineProperty(UISegmentedControl.prototype, "displaysNoOutlineOnSelection", {
		value: true});
	
	
UISegmentedControl.prototype.selectForEditor = function UISegmentedControl_selectForEditor() {};
	

UISegmentedControl.prototype.unselectForEditor = function UISegmentedControl_unselectForEditor() {};
	


	Object.defineProperty(UISegmentedControl.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: this.readableNameForProperty('titleStrings'), keyPath: 'titleStrings', type: 'textarea', positionLeft: true, acceptsReturn:true, textFieldHeight: 100 },
						{ name: '   '+this.readableNameForProperty('selectedSegmentIndex1'), keyPath: 'selectedSegmentIndex1', dataKeyPath: 'selectedSegmentIndex', type: 'number', range: [0,1000], labelOnTop:true, positionLeft:true },
						{ name: '   '+this.readableNameForProperty('tintColor'), keyPath: 'e_tintColor', dataKeyPath: 'tintColor', type: 'color' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Font'),
					id: this.constructor.name+'Font',
					items: [
						{ type: 'font' },
						{type: 'space'},
						{ type: 'fontSize', keyPath: 'fontSize' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				},
		
			];

		}});
	

	Object.defineProperty(UISegmentedControl.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['titleStrings', this.readableNameForProperty('titleStrings')],
				['selectedSegmentIndex1', this.readableNameForProperty('selectedSegmentIndex1')],
				['selectedSegmentIndex', this.readableNameForProperty('selectedSegmentIndex')]
			);
			return result;
		}});
	
	
UISegmentedControl.prototype.readableNameForProperty = function UISegmentedControl_readableNameForProperty(theProperty) {
		switch (theProperty) {
			case 'titleStrings': return LocalizedString('Labels');
			case 'selectedSegmentIndex1': return LocalizedString('Selected #');
			case 'selectedSegmentIndex': return LocalizedString('Selected # (0-index)');
			case 'selectedSegmentText': return LocalizedString('Text');
			case 'tintColor': return LocalizedString('Color');
		}
		return __super.prototype.readableNameForProperty.call(this, theProperty);};
	
	
	Object.defineProperty(UISegmentedControl.prototype, "titleStrings", {
		set: function (v) {
			this.segments = Array.isArray(v) ? v : v.split("\n");
			this.createSegmentedControlView();
			this.drawBackground();
		}, 
		get: function () {
			var str = '';
			if (Array.isArray(this.segments)) this.segments.every(function (item) {
				if (str !== '') str += "\n";
				str += item;return true; }, this);
			
			return str;
		}});
	

UISegmentedControl.prototype.getClickedOnSegment = function UISegmentedControl__getClickedOnSegment(e) {
				var x = e.offsetX;
				var segmentWidth = this.size.width/this.segments.length;
				var clickedOnSegment = (x/segmentWidth)|0;
			return clickedOnSegment;};
		

UISegmentedControl.prototype.prepareForEditor = function UISegmentedControl_prepareForEditor(editor) {
		__super.prototype.prepareForEditor.call(this, editor);
		this.DOMNode.onclick = function (e) {
			if (editor.isActionClick(e)) {
				if (this.hasReadonlyBindingForKey('selectedSegmentIndex1')) {
					this.context.beep();
					return;
				}
				var clickedOnSegment = this.getClickedOnSegment(e);
				this.dataController.setValueForKey(clickedOnSegment+1, 
					'selectedSegmentIndex1',this.dataController);
				this.performBidirectionalBindingForKey('selectedSegmentIndex');
			}
		}.bind(this);
		
		this.DOMNode.ondblclick = function (e) {
			if (editor.isActionClick(e)) return;
			if (this.locked) return;
			if (editor.editedSubview !== this.superview) {
				return;
			}
			if (this.hasBindingForKey('titleStrings')) {
				this.context.beep();
				return;
			}
			var clickedOnSegment = this.getClickedOnSegment(e);
			
		
			var isSystem7 = this.context.simulatedSystemVersion >= 7;

			var textFieldStyle = {
				fontFamily :  realIOSFont(this.fontName)||'"Helvetica Neue"',
				fontSize   :  (this.fontSize||11)+'px',
				textAlign  :  'center',
			};
			
			var originalLabel = this.segmentedControl.subviews[clickedOnSegment].label;

			var text = originalLabel.text;

			var containerView = editor.contentFrameController.containerView,
				textFieldStyle = textFieldStyle,
				textFieldPosition = {
					left: -originalLabel.getRelativeX(0, containerView),
					top: -originalLabel.getRelativeY(0, containerView)
						  + originalLabel._contentNode.offsetTop
				};
			
			delete textFieldStyle.color;
			textFieldStyle.textAlign = 'center';

			var segmentWidth = this.size.width/this.segments.length;
			textFieldPosition.left += segmentWidth/2;
			
			var ftf = createComponentFromDomain('FloatingTextField', 'Core.UI', editor.context, {
				position: textFieldPosition,
				size: originalLabel.sizeCopy,
				text: text,
				style: textFieldStyle,
				delegate: {
					textFieldDidBeginEditing: function (textField) {
						originalLabel.hidden = true;
					},
					textFieldDidEndEditing: function (textField) {
					
						if (textField.value !== text) {
							var s = clone(this.segments);
							s[clickedOnSegment] = textField.value;
							this.dataController.setValueForKeyPath(s.join("\n"), 'titleStrings', this.dataController);
						}
						originalLabel.hidden = false;
					}.bind(this)
				}
			});
	
			editor.contentFrameController.containerView.addSubview(ftf);
			
		}.bind(this);
		this.DOMNode.className += ' canClickInActionMode';

		getPrototype('info.appdoo-mac.SegmentedControlDataProvider').addDataProviderToControl(this);
};
	
	
	Object.defineProperty(UISegmentedControl.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	
	
	Object.defineProperty(UISegmentedControl.prototype, "tintColor", {
	outlet: true, 
	enumerable: true, get:function () { return this._tintColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_tintColor")) Object.defineProperty(this, "_tintColor", { writable: true, configurable: true }); this._tintColor = v; }});
	
	
	Object.defineProperty(UISegmentedControl.prototype, "e_tintColor", {
		set: function (v) {
			this.tintColor = v;
			this.drawBackground();
			this.segmentedControl.labelColor = v;
		}, 
		get: function () {
			return this.tintColor;
		}});
	
	
	Object.defineProperty(UISegmentedControl.prototype, "isFormElement", {
		value: true});
	

	Object.defineProperty(UISegmentedControl.prototype, "value", {
		get: function () { return this.segments[this.selectedSegmentIndex]; }});
	

	Object.defineProperty(UISegmentedControl.prototype, "outlineIconURL", {
		value: 'Resources/UISegmentedControl.png'});
	

	Object.defineProperty(UISegmentedControl.prototype, "fontFamily", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_fontFamily")) Object.defineProperty(this, "_fontFamily", { writable: true, configurable: true });
			if (this._fontFamily) {
				var firstChoice = firstChoiceForFontFamily(v, this._fontName);
				this._fontFamily = v;
				this.dataController.setValueForKeyPath(firstChoice, 'fontName', this);
			}
			else this._fontFamily = v;
		}, get:function () { return this._fontFamily; }});
	

	Object.defineProperty(UISegmentedControl.prototype, "fontName", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_fontName")) Object.defineProperty(this, "_fontName", { writable: true, configurable: true });
			this._fontName = value;
			if (this.segmentedControl) this.createSegmentedControlView();
		}, get:function () { return this._fontName; }});
	

	Object.defineProperty(UISegmentedControl.prototype, "fontSize", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_fontSize")) Object.defineProperty(this, "_fontSize", { writable: true, configurable: true });
			this._fontSize = value;
			if (this.segmentedControl) this.createSegmentedControlView();
		}, get:function () { return this._fontSize; }});
	

	var UIControlStateNormal = 0;

UISegmentedControl.prototype.transformData = function UISegmentedControl_transformData(data, transformer) {
	
		transformer.demandPlugin('info.appdoo-mac.SegmentedControlDataLinks');

		var result = __super.prototype.transformData.call(this, data, transformer, {useDefaultInitializer:true});
		if (transformer.isXIBGenerator) delete result['color backgroundColor'];
		
		transformer.setType(result, 'UISegmentedControl');
		transformer.setIntegerProperty(result, 'selectedSegmentIndex', data.selectedSegmentIndex, true);
		transformer.setColorProperty(result, 'tintColor', data.tintColor, true);

		if (transformer.isXIBGenerator) {
			result.segments = {};
			var i = 0;
			if (Array.isArray(data.segments)) data.segments.every(function (str) {
				result.segments['segment '+i] = { title: str };
				i++;return true; }, this);
			
			transformer.setStringProperty(result, 'segmentControlStyle', 'bar', true);
		}
		else {
			var itemArray = {
				$type: 'NSMutableArray',
				$domain: 'com.apple',
				$initialMethodCalls: []
			};
			if (Array.isArray(data.segments)) data.segments.every(function (str) {
				itemArray.$initialMethodCalls.push({
					name: 'addObject:', arguments: [transformer.transformString(str)]
				});return true; }, this);
			
			result.$initialMethodCalls = [
				{ name: 'initWithItems:', arguments: [itemArray] }
			];
			transformer.setIntegerProperty(result, 'segmentedControlStyle', 2, true);
		}
		
		if (data.fontName && !(data.fontName === '_DEFAULT_' && data.fontSize === 13)) {
			if (transformer.isXIBGenerator) {
				transformer.demandPlugin('info.appdoo-mac.UISegmentedControl+TitleTextAttributesString');
				transformer.setStringProperty(result, 'titleTextAttributesString', JSON.stringify({
					fontName: data.fontName,
					fontSize: data.fontSize
				}));
			}
			else {
				var font = transformer.transformFont(data.fontName, data.fontSize);
				var attributes = {
					$type: 'NSDictionary',
					$domain: 'com.apple',
					$constructor: {
						name: 'dictionaryWithObject:forKey:',
						arguments: [font, "NSFont"]
					}
				};
				result.$initialMethodCalls.push({
					name: 'setTitleTextAttributes:forState:',
					arguments: [
						attributes,
						UIControlStateNormal
					]
				});
			}
		}

		if (data.dataProvider) {
			var dataProvider = transformer.addDataProviderToObject(result, data);
			transformer.registerInverseBinding(result, data, 'selectedSegmentIndex', 'control', data.dataProvider.$id, dataProvider);
			transformer.registerInverseBinding(result, data, 'selectedSegmentIndex1', 'control', data.dataProvider.$id, dataProvider);
		}
		
		return result;
		};
	

UISegmentedControl.prototype.initPropertiesFromData = function UISegmentedControl_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("segments")) this.segments = data.segments;
if (data.hasOwnProperty("selectedSegmentIndex")) this.selectedSegmentIndex = data.selectedSegmentIndex;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
if (data.hasOwnProperty("tintColor")) this.tintColor = data.tintColor;
if (data.hasOwnProperty("fontFamily")) this.fontFamily = data.fontFamily;
if (data.hasOwnProperty("fontName")) this.fontName = data.fontName;
if (data.hasOwnProperty("fontSize")) this.fontSize = data.fontSize;
};

UISegmentedControl.prototype.decodeData = function UISegmentedControl_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

UISegmentedControl.prototype.encode = function UISegmentedControl_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

UISegmentedControl.prototype.encodeCloned = function UISegmentedControl_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

UISegmentedControl.prototype.expectedTypeForProperty = function UISegmentedControl_expectedTypeForProperty(key) {
	if (key === "segments") return "Array";
	if (key === "didSetSelectedSegmentIndex") return "Boolean";
	if (key === "selectedSegmentIndex") return "Number";
	if (key === "selectedSegmentIndex1") return "Number";
	if (key === "selectedSegmentText") return "String";
	if (key === "readableType") return "";
	if (key === "heightIsEditable") return "";
	if (key === "backgroundCanvas") return "Canvas";
	if (key === "segmentedControl") return "Core.UI.SegmentedControl";
	if (key === "displaysNoOutlineOnSelection") return "";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "titleStrings") return "StringOrArray";
	if (key === "dataProvider") return "SegmentedControlDataProvider";
	if (key === "tintColor") return "String";
	if (key === "e_tintColor") return "String";
	if (key === "isFormElement") return "";
	if (key === "value") return "";
	if (key === "outlineIconURL") return "";
	if (key === "fontFamily") return "String";
	if (key === "fontName") return "String";
	if (key === "fontSize") return "Number";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UISegmentedControl; }()));
registerType('info.appdoo-mac', (function () { function SegmentedControlDataProvider() {} var __super = setSupertypeFromDomain(SegmentedControlDataProvider, 'ControlDataProvider', 'info.appdoo-mac');

	Object.defineProperty(SegmentedControlDataProvider.prototype, "propertiesForBindings", {
		value: ['selectedSegmentIndex', 'selectedSegmentIndex1', 'selectedSegmentText']});
	
	
	Object.defineProperty(SegmentedControlDataProvider.prototype, "isPlugin", {
		value: true});
	

SegmentedControlDataProvider.prototype.expectedTypeForProperty = function SegmentedControlDataProvider_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (key === "isPlugin") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SegmentedControlDataProvider; }()));