
registerType('appdoo.iOS', (function () { function UISlider() {} var __super = setSupertypeFromDomain(UISlider, 'UIView', 'appdoo.iOS');

	var UISLIDER_HEIGHT = 34;

	Object.defineProperty(UISlider.prototype, "readableType", {
		get: function () { return LocalizedString("Slider"); }});
	

UISlider.prototype.createForSuperview = function UISlider_createForSuperview(superview) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: 118, height: UISLIDER_HEIGHT },
			position: { left: 0, top: 0 },
			autoresizingMask: 36,

			minimumValue: 0,
			maximumValue: 100,
			value: 50,
			name: superview.context.nameForNewFormControl(this),
		});
	};
	

UISlider.prototype.superviewDidChangeTintColor = function UISlider_superviewDidChangeTintColor(v) {
		if (this.tintColor) return;
		this.canvas.layoutSubviews();};
	
	
	Object.defineProperty(UISlider.prototype, "heightIsEditable", {
		value: false});
	
	
	Object.defineProperty(UISlider.prototype, "canvas", {
	synthesized: true, get:function () { return this._canvas; }, set:function (v) {if (!Object.hasOwnProperty(this, "_canvas")) Object.defineProperty(this, "_canvas", { writable: true, configurable: true }); this._canvas = v; }});
	

UISlider.prototype.init = function UISlider_init() {
		__super.prototype.init.call(this);
		this.canvas = createComponentFromDomain("CanvasView", "Core.UI", this.context, {
			size: { width: this.size.width+4, height: 35 },
			position: { left: -2, top: 0 },
			autoresizingMask: 2})
		;
		this.canvas.draw = this.drawCanvas.bind(this);
		this.addSubview(this.canvas);
		this.canvas.draw(this.canvas.size.width, this.canvas.size.height);
		if (Array.isArray(this.bindings)) this.bindings.every(function (binding) {
			if (binding.sourceKeyPath === 'value') binding.sourceKeyPath = 'valueRespectingTouch';return true; }, this);
		
		return this;};
	
	
	Object.defineProperty(UISlider.prototype, "minimumValue", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_minimumValue")) Object.defineProperty(this, "_minimumValue", { writable: true, configurable: true }); this._minimumValue = v; this.valuesDidChange(); }, get:function () { return this._minimumValue; }});
	

	Object.defineProperty(UISlider.prototype, "maximumValue", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_maximumValue")) Object.defineProperty(this, "_maximumValue", { writable: true, configurable: true }); this._maximumValue = v; this.valuesDidChange(); }, get:function () { return this._maximumValue; }});
	
	
	Object.defineProperty(UISlider.prototype, "value", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_value")) Object.defineProperty(this, "_value", { writable: true, configurable: true });
			if (typeof v !== 'number' || isNaN(v)) v = 0;
			if (v > this.maximumValue) v = this.maximumValue;

			if (this._value === undefined)
				this._value = v;
			else {
				if (this._value === v) return;
				this._value = v;
				this.valuesDidChange();
				if (this.dataProvider) this.dataProvider.notifyObservers();
			}

		}, get:function () { return this._value; }});
	

	Object.defineProperty(UISlider.prototype, "valueRespectingTouch", {
		get: function () { return this.value; }, 
		set: function (v) { this.value = v; }});
	
	
UISlider.prototype.valuesDidChange = function UISlider__valuesDidChange() {
		if (!this.viewIsLoaded) return;
		this.canvas.layoutSubviews(); };
	
	
	Object.defineProperty(UISlider.prototype, "relativeValue", {
		get: function () {
			var v = (this.value-this.minimumValue)/(this.maximumValue-this.minimumValue);
			if (v < 0) return 0;
			if (v > 1) return 1;
			return v;
		}});
	
	
UISlider.prototype.drawCanvas = function UISlider_drawCanvas(width, height) {
		this.context.whenImageIsReady(this.context.pathForOptimizedImage('Resources/UISliderButton.png'), function (img) {
			var scale = this.canvas.contentScale;
			var borderWidth = scale < 2 ? 1 : 0.5;
			var ctx = this.canvas.DOMNode.getContext('2d');
	
			ctx.save();
			ctx.scale(scale,scale);
			
			var padding = 3;
			var x = padding;
			var paddedWidth = width-padding*2;
			var relativeValue = this.relativeValue;
			var middle = paddedWidth*relativeValue;
			var y = UISLIDER_HEIGHT/2-1;
	
			
			if (middle > 1) {
				ctx.fillStyle = this.tintColor || this.context.defaultOrSystemTintColor;
				ctx.roundRect(padding-1,y,2,2,2);
				ctx.fill();
				ctx.fillRect(x,y, middle, 2);
			}
			else {
				ctx.fillStyle = '#ddd';
				ctx.roundRect(padding-1,y,2,2,2);
				ctx.fill();
			}
	
			x = middle+padding;
			
			var w = width-x-padding;
			if (w > 1) {
				ctx.fillStyle = this.maximumTrackTintColor||'rgb(195,195,195)';
				ctx.fillRect(x,y,w, 2);
				ctx.roundRect(width-2-padding+1,y,2,2,2);
				ctx.fill();
			}
			else {
				ctx.roundRect(width-2-padding+1,y,2,2,2);
				ctx.fill();
			}
			

		
			var p = 15.5;
			var sliderPosition = (width-p*2)*relativeValue+p;

			ctx.drawImage(img,sliderPosition-17,0,35,35);
			ctx.restore();
		}.bind(this));
};
	

	Object.defineProperty(UISlider.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: this.readableNameForProperty('value'), keyPath: 'value', type: 'number', dataKeyPath: 'valueRespectingTouch' },
						{ name: this.readableNameForProperty('minimumValue'), keyPath: 'minimumValue', type: 'number' },
						{ name: this.readableNameForProperty('maximumValue'), keyPath: 'maximumValue', type: 'number' },

						{ name: '   '+this.readableNameForProperty('tintColor'), keyPath: 'e_tintColor', dataKeyPath: 'tintColor', type: 'color' },
					]
				},
		
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				},
			];

		}});
	

	Object.defineProperty(UISlider.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['valueRespectingTouch', this.readableNameForProperty('valueRespectingTouch')],
				['minimumValue', this.readableNameForProperty('minimumValue')],
				['maximumValue', this.readableNameForProperty('maximumValue')]
			);
			return result;
		}});
	
	
UISlider.prototype.readableNameForProperty = function UISlider_readableNameForProperty(theProperty) {
		switch (theProperty) {
			case 'minimumValue': return LocalizedString('Minimum');
			case 'maximumValue': return LocalizedString('Maximum');
			case 'value': return LocalizedString('Value');
			case 'valueRespectingTouch': return LocalizedString('Value');
		}
		return __super.prototype.readableNameForProperty.call(this, theProperty);};
	

	Object.defineProperty(UISlider.prototype, "e_tintColor", {
		set: function (v) {
			this.tintColor = v;
			this.canvas.layoutSubviews();
		}, 
		get: function () {
			return this.tintColor;
		}});
	

	Object.defineProperty(UISlider.prototype, "displaysNoOutlineOnSelection", {
		value: true});
	
	
	Object.defineProperty(UISlider.prototype, "isFormElement", {
		value:true});
	

	Object.defineProperty(UISlider.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/UISlider.png';
		}});
	
	
UISlider.prototype.transformData = function UISlider_transformData(data, transformer) {
	
		var result = __super.prototype.transformData.call(this, data, transformer);
		if (transformer.isXIBGenerator) delete result['color backgroundColor'];

		transformer.setFloatProperty(result, 'value', data.value, true);
		transformer.setFloatProperty(result, transformer.isXIBGenerator?'minValue':'minimumValue', data.minimumValue, true);
		transformer.setFloatProperty(result, transformer.isXIBGenerator?'maxValue':'maximumValue', data.maximumValue, true);
		
		if (data.dataProvider) {
			if (transformer.isXIBGenerator) {
				var dataProvider = _context.projectContext.decodeObjectTree(data.dataProvider);
				transformer.registerInlineObject(dataProvider);
				transformer.connectOutletNamed__in__to__result__('dataProvider', data.$id, dataProvider.$id, result);
			}
			else {
				result.dataProvider = getPrototype(utiFromData(data.dataProvider)).transformData(data.dataProvider, transformer);
				result.$propertyPriorities['dataProvider'] = -1;
			}
			var valueBinding = this.bindingForKey.call(data, 'valueRespectingTouch');
			if (valueBinding) {
				var destinationObject = _context.projectContext.connectableObjects[valueBinding.destination];
					alertd('valueBinding', valueBinding, 'destinationObject', destinationObject, valueBinding.destination);
				if (!destinationObject || destinationObject.mutable) {
					alertd('ok');
					valueBinding = _context.createReverseBinding(valueBinding);
					valueBinding.destinationKeyPath = 'control.valueRespectingTouch';
					valueBinding.destination = data.dataProvider.$id;
					valueBinding.transformer = 'TO_NUMBER';
					valueBinding.treatAsReverseBinding = true;
					if (transformer.isXIBGenerator) {
						dataProvider._bindings = [valueBinding];
					}
					else {
						transformer.registerSpecialBinding(valueBinding);
					}
				}
			}
		}
		
		return result;
};
	
	
UISlider.prototype.prepareForEditor = function UISlider_prepareForEditor(editor) {
		getPrototype('info.appdoo-mac.SliderDataProvider').addDataProviderToControl(this);};
	

	Object.defineProperty(UISlider.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	

UISlider.prototype.initPropertiesFromData = function UISlider_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("minimumValue")) this.minimumValue = data.minimumValue;
if (data.hasOwnProperty("maximumValue")) this.maximumValue = data.maximumValue;
if (data.hasOwnProperty("value")) this.value = data.value;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
};

UISlider.prototype.decodeData = function UISlider_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

UISlider.prototype.encode = function UISlider_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

UISlider.prototype.encodeCloned = function UISlider_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

UISlider.prototype.expectedTypeForProperty = function UISlider_expectedTypeForProperty(key) {
	if (key === "readableType") return "";
	if (key === "heightIsEditable") return "";
	if (key === "canvas") return "HTMLCanvasElement";
	if (key === "minimumValue") return "Number";
	if (key === "maximumValue") return "Number";
	if (key === "value") return "Number";
	if (key === "valueRespectingTouch") return "Number";
	if (key === "relativeValue") return "Number";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "e_tintColor") return "String";
	if (key === "displaysNoOutlineOnSelection") return "";
	if (key === "isFormElement") return "";
	if (key === "outlineIconURL") return "";
	if (key === "dataProvider") return "SliderDataProvider";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UISlider; }()));
registerType('info.appdoo-mac', (function () { function SliderDataProvider() {} var __super = setSupertypeFromDomain(SliderDataProvider, 'ControlDataProvider', 'info.appdoo-mac');

	Object.defineProperty(SliderDataProvider.prototype, "propertiesForBindings", {
		value: ['value', 'minimumValue', 'maximumValue']});
	
	
	Object.defineProperty(SliderDataProvider.prototype, "isPlugin", {
		value: true});
	

SliderDataProvider.prototype.expectedTypeForProperty = function SliderDataProvider_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (key === "isPlugin") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SliderDataProvider; }()));