
registerType('appdoo.iOS', (function () { function UIStatusBar() {} var __super = setSupertypeFromDomain(UIStatusBar, 'UIView', 'appdoo.iOS');

	Object.defineProperty(UIStatusBar.prototype, "brightContent", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_brightContent")) Object.defineProperty(this, "_brightContent", { writable: true, configurable: true });
			this._brightContent = v;
			if (this.DOMNode && this.clockLabel) {
				this.styleDefault();
			}
		}, get:function () { return this._brightContent; }});
	

UIStatusBar.prototype.init = function UIStatusBar_init() {
	
		__super.prototype.init.call(this);
		
		var width = this.size.width;
		
		this.style({ pointerEvents: 'none' });
		
		
		this.clockLabel = this.context.decodeObjectTree({
					$type: 'UILabel',
					$domain: 'appdoo.iOS',
					position: { left: 100-20, top: -1 },
					size: { width: width-200+40, height: 20 },
					autoresizingMask: 5,
					text: '16:37',
					hidden: this.context.isOffscreen
				});
		this.addSubview(this.clockLabel);
		
		
		this.batteryIcon = this.context.decodeObjectTree({
					$type: 'ImageView',
					$domain: 'Core.UI',
					imageSrc: 'Resources/BatterySystem7.png',
					size: { width: 21, height: 11 },
					position: { left: width-24, top: 4 },
					autoresizingMask: 1
				});
		this.addSubview(this.batteryIcon);



		this.styleDefault();
		this.updateClock();

		
		setTimeout(function () {
			this.updateClock();
		}.bind(this), (60-(new Date().getSeconds()))*1000)
		
		return this;};
	


UIStatusBar.prototype.updateClock = function UIStatusBar__updateClock() {

		var timeString = _context.nativeProxy.sendMessage('getLocalizedTimeString');

		if (!this.subviews || !this.subviews[0]) return;
		this.clockLabel.text = timeString;
	
		if (this.updateTimer !== undefined)
			clearTimeout(this.updateTimer);

		this.updateTimer = setTimeout(function () {
			delete this.updateTimer;
			this.updateClock();
		}.bind(this), 1000*60);
		};
	
	
UIStatusBar.prototype.styleDefaultSystem6 = function UIStatusBar__styleDefaultSystem6() {

		this.style({
				background: '-webkit-linear-gradient(rgb(232,239,242), rgb(189,197,201))',
				height: '19px',
				borderBottom: '1px solid rgb(92,99,104)'
			});
			
		this.clockLabel.style({
						color: 'rgb(0,0,0)',
						fontSize: '13px',
						fontWeight: 'bold',
						textShadow: '0 1px 0 rgba(255,255,255,.8)',
						textAlign: 'center'
					});
	};
	

UIStatusBar.prototype.styleDefaultSystem7 = function UIStatusBar__styleDefaultSystem7() {

		var brightContent = this.brightContent;
		var width = this.size.width;
	
		this.clockLabel.style({
						color: brightContent ? 'white': 'black',
						fontSize: '12px',
						fontWeight: '500',
						textAlign: 'center',
						textRendering: 'optimizeLegibility',
						webkitTransform: 'translateY(.5px)'
					});
		
		this.batteryIcon.imageSrc = brightContent ? 'Resources/BatterySystem7White.png' : 'Resources/BatterySystem7.png';
		this.batteryIcon.size = { width: 25, height: 10 };
		this.batteryIcon.position.left = width-24-6;
		this.batteryIcon.position.top = 5;
};
	
	
UIStatusBar.prototype.initPropertiesFromData = function UIStatusBar_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("brightContent")) this.brightContent = data.brightContent;
};

UIStatusBar.prototype.decodeData = function UIStatusBar_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

UIStatusBar.prototype.encode = function UIStatusBar_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

UIStatusBar.prototype.encodeCloned = function UIStatusBar_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

UIStatusBar.prototype.expectedTypeForProperty = function UIStatusBar_expectedTypeForProperty(key) {
	if (key === "brightContent") return "Boolean";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIStatusBar; }()));