
registerType('appdoo.iOS', (function () { function UIStepper() {} var __super = setSupertypeFromDomain(UIStepper, 'UIView', 'appdoo.iOS');

UIStepper.prototype.init = function UIStepper_init() {
		__super.prototype.init.call(this);
		this.createSubviews();
		return this;};
	

UIStepper.prototype.createForSuperview = function UIStepper_createForSuperview(superview) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: 94, height: 29 },
			position: { left: 0, top: 0 },
			autoresizingMask: 36,
			name: superview.context.nameForNewFormControl(this),
			value: 0,
			maximumValue: 1000,
			minimumValue: 0,
			stepValue: 1
		});
	};
	
	
UIStepper.prototype.createSubviews = function UIStepper_createSubviews() {
	
		this.style({overflow:'hidden'});
		
		this.bordersView = createComponentFromDomain("CanvasView", "Core.UI", this.context, {
			size: this.sizeCopy,
			autoresizingMask: 18,})
		;
		this.insertSubviewAtIndex(this.bordersView, 0);
		this.bordersView.draw = function (width, height) {
			var borderWidth = this.contentScale*1;
			var ctx = this.DOMNode.getContext('2d');
			ctx.strokeStyle = this.superview.tintColorOrDefault;

			ctx.save();
			ctx.scale(this.contentScale,this.contentScale);
			ctx.clearRect(0,0,width,height);
			ctx.roundRect(0.5,0.5,width-1,height-1, 3.5);
			ctx.stroke();
			
			ctx.fillStyle = this.superview.tintColorOrDefault;
			ctx.fillRect(width/2-0.5, 0, 1, height);
			
			ctx.restore();
		};
		this.bordersView.layoutSubviews();
		
		
		this.minusIcon = createComponentFromDomain("CanvasView", "Core.UI", this.context, {
			size: { width: 16, height: 16 },
			style: { pointerEvents:'none' }})
		;
		this.insertSubviewAtIndex(this.minusIcon, 0);
		this.minusIcon.draw = function (width, height) {
			var ctx = this.DOMNode.getContext('2d');
			ctx.fillStyle = this.superview.tintColorOrDefault;
			ctx.save();
			ctx.scale(this.contentScale,this.contentScale);

			ctx.clearRect(0,0,width,height);
			ctx.fillRect(0,8,15.5,1.5);
			
			ctx.restore();
		};
		this.minusIcon.layoutSubviews();
		
		
		this.plusIcon = createComponentFromDomain("CanvasView", "Core.UI", this.context, {
			size: { width: 16, height: 16 },
			style: { pointerEvents:'none' }})
		;
		this.insertSubviewAtIndex(this.plusIcon, 0);
		this.plusIcon.draw = function (width, height) {
			var ctx = this.DOMNode.getContext('2d');
			ctx.fillStyle = this.superview.tintColorOrDefault;
			ctx.save();
			ctx.scale(this.contentScale,this.contentScale);

			ctx.clearRect(0,0,width,height);
			ctx.fillRect(0.5,7.5,15.5,1.5);
			ctx.fillRect(7.5,0.5,1.5,15.5);
			
			ctx.restore();
		};
		this.plusIcon.layoutSubviews();
		
		this.layoutSubviews();
		this.validateButtons();};
	

	Object.defineProperty(UIStepper.prototype, "heightIsEditable", {
		value: false});
	
	
UIStepper.prototype.superviewDidChangeTintColor = function UIStepper_superviewDidChangeTintColor(color) {
		if (!this.bordersView) return;
		this.bordersView.layoutSubviews();
		this.minusIcon.layoutSubviews();
		this.plusIcon.layoutSubviews();};
	
	
UIStepper.prototype.layoutSubviews = function UIStepper_layoutSubviews() {
		this.bordersView.size = this.sizeCopy;
		this.minusIcon.position = { top: (this.size.height/2)-8.5, left: (this.size.width/4)-7.5 };
		this.plusIcon.position = { top: (this.size.height/2)-8.5, left: this.size.width-(this.size.width/4)-8.5 };};
	
	
UIStepper.prototype.transformData = function UIStepper_transformData(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		transformer.setIntegerProperty(result, 'minimumValue', data.minimumValue);
		transformer.setIntegerProperty(result, 'maximumValue', data.maximumValue);
		transformer.setIntegerProperty(result, 'value', data.value);
		transformer.setIntegerProperty(result, 'stepValue', data.stepValue||1);
		transformer.setBooleanProperty(result, 'autorepeat', data.autorepeat);
		transformer.setBooleanProperty(result, 'continuous', data.continuous);

		if (data.dataProvider) {
			var dataProvider = transformer.addDataProviderToObject(result, data);
			transformer.registerInverseBinding(result, data, 'value', 'control', data.dataProvider.$id, dataProvider);
		}

		return result;};
	
	
	Object.defineProperty(UIStepper.prototype, "minimumValue", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_minimumValue")) Object.defineProperty(this, "_minimumValue", { writable: true, configurable: true }); this._minimumValue = v; this.validateButtons(); }, get:function () { return this._minimumValue; }});
	
	Object.defineProperty(UIStepper.prototype, "maximumValue", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_maximumValue")) Object.defineProperty(this, "_maximumValue", { writable: true, configurable: true }); this._maximumValue = v; this.validateButtons(); }, get:function () { return this._maximumValue; }});
	
	Object.defineProperty(UIStepper.prototype, "value", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_value")) Object.defineProperty(this, "_value", { writable: true, configurable: true }); this._value = v; this.validateButtons(); if (this.bordersView) this.dataProvider.notifyObservers(); }, get:function () { return this._value; }});
	
	Object.defineProperty(UIStepper.prototype, "stepValue", {
	outlet: true, 
	enumerable: true, get:function () { return this._stepValue; }, set:function (v) {if (!Object.hasOwnProperty(this, "_stepValue")) Object.defineProperty(this, "_stepValue", { writable: true, configurable: true }); this._stepValue = v; }});
	
	Object.defineProperty(UIStepper.prototype, "autorepeat", {
	outlet: true, 
	enumerable: true, get:function () { return this._autorepeat; }, set:function (v) {if (!Object.hasOwnProperty(this, "_autorepeat")) Object.defineProperty(this, "_autorepeat", { writable: true, configurable: true }); this._autorepeat = v; }});
	
	Object.defineProperty(UIStepper.prototype, "continuous", {
	outlet: true, 
	enumerable: true, get:function () { return this._continuous; }, set:function (v) {if (!Object.hasOwnProperty(this, "_continuous")) Object.defineProperty(this, "_continuous", { writable: true, configurable: true }); this._continuous = v; }});
	

UIStepper.prototype.validateButtons = function UIStepper_validateButtons() {
		if (!this.bordersView) return;
		this.minusIcon.disabled = (this.value <= this.minimumValue);
		this.plusIcon.disabled = (this.value >= this.maximumValue);};
	

UIStepper.prototype.readableNameForProperty = function UIStepper_readableNameForProperty(theProperty) {
	
		switch (theProperty) {
			case 'minimumValue': return LocalizedString('Minimum');
			case 'maximumValue': return LocalizedString('Maximum');
			case 'value': return LocalizedString('Value');
			case 'stepValue': return LocalizedString('Step');
			case 'autorepeat': return LocalizedString('Autorepeat');
			case 'continuous': return LocalizedString('Continuous');
		}
		
		return __super.prototype.readableNameForProperty.call(this, theProperty);
		};
		
	Object.defineProperty(UIStepper.prototype, "readableType", {
		get: function () { return LocalizedString('Stepper'); }});
	

	Object.defineProperty(UIStepper.prototype, "inspectorProperties", {
		get: function () {
			return [

				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
							{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
							{ type: 'number', keyPath: 'value', name: this.readableNameForProperty('value') },
							{ type: 'number', keyPath: 'stepValue', name: this.readableNameForProperty('stepValue') },
							{ type: 'number', keyPath: 'minimumValue', name: this.readableNameForProperty('minimumValue') },
							{ type: 'number', keyPath: 'maximumValue', name: this.readableNameForProperty('maximumValue') },
							{ type: 'boolean', keyPath: 'autorepeat', name: this.readableNameForProperty('autorepeat') },
							{ type: 'boolean', keyPath: 'continuous', name: this.readableNameForProperty('continuous') },
							{ type: 'space' },
							{ type: 'color', keyPath: 'tintColor', name: this.readableNameForProperty('tintColor') },
		
					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
					
					{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
					
					]
				},

			];

		}});
	

UIStepper.prototype.prepareForEditor = function UIStepper_prepareForEditor(editor) {
		this.DOMNode.className += ' canClickInActionMode';
		this.DOMNode.onclick = function (e) {
			if (!editor.isActionClick(e)) return;			
			var segment = this.size.width/2 < e.offsetX ? 1 : 0;
			if (segment === 0) {
				if (this.minusIcon.disabled) return;
				this.value-=this.stepValue;
			}
			else {
				if (this.plusIcon.disabled) return;
				this.value+=this.stepValue;
			}
			editor.refreshInspector();
		}.bind(this);
		getPrototype('info.appdoo-mac.StepperDataProvider').addDataProviderToControl(this);};
	

	Object.defineProperty(UIStepper.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	

	Object.defineProperty(UIStepper.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['value', this.readableNameForProperty('value')],
				['minimumValue', this.readableNameForProperty('minimumValue')],
				['maximumValue', this.readableNameForProperty('maximumValue')],
				['stepValue', this.readableNameForProperty('stepValue')]
			);
			return result;
		}});
	

	Object.defineProperty(UIStepper.prototype, "outlineIconURL", {
		value: 'Resources/UIStepper.png'});
	

	Object.defineProperty(UIStepper.prototype, "iconURL", {
		value: 'Resources/UIStepper48.png'});
	
	
	Object.defineProperty(UIStepper.prototype, "readableDescription", {
		get: function () { return LocalizedString('A control for incrementing or decrementing a value'); }});
	

UIStepper.prototype.initPropertiesFromData = function UIStepper_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("minimumValue")) this.minimumValue = data.minimumValue;
if (data.hasOwnProperty("maximumValue")) this.maximumValue = data.maximumValue;
if (data.hasOwnProperty("value")) this.value = data.value;
if (data.hasOwnProperty("stepValue")) this.stepValue = data.stepValue;
if (data.hasOwnProperty("autorepeat")) this.autorepeat = data.autorepeat;
if (data.hasOwnProperty("continuous")) this.continuous = data.continuous;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
};

UIStepper.prototype.decodeData = function UIStepper_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

UIStepper.prototype.encode = function UIStepper_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

UIStepper.prototype.encodeCloned = function UIStepper_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

UIStepper.prototype.expectedTypeForProperty = function UIStepper_expectedTypeForProperty(key) {
	if (key === "heightIsEditable") return "";
	if (key === "minimumValue") return "Number";
	if (key === "maximumValue") return "Number";
	if (key === "value") return "Number";
	if (key === "stepValue") return "Number";
	if (key === "autorepeat") return "Boolean";
	if (key === "continuous") return "Boolean";
	if (key === "readableType") return "";
	if (key === "inspectorProperties") return "";
	if (key === "dataProvider") return "StepperDataProvider";
	if (key === "bindableProperties") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "readableDescription") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIStepper; }()));
registerType('info.appdoo-mac', (function () { function StepperDataProvider() {} var __super = setSupertypeFromDomain(StepperDataProvider, 'ControlDataProvider', 'info.appdoo-mac');

	Object.defineProperty(StepperDataProvider.prototype, "propertiesForBindings", {
		value: ['value']});
	
	
	Object.defineProperty(StepperDataProvider.prototype, "isPlugin", {
		value: true});
	

StepperDataProvider.prototype.expectedTypeForProperty = function StepperDataProvider_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (key === "isPlugin") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return StepperDataProvider; }()));