
registerType('appdoo.iOS', (function () { function UISwitch() {} var __super = setSupertypeFromDomain(UISwitch, 'UIView', 'appdoo.iOS');

	var UISWITCH_WIDTH = 51,
		UISWITCH_HEIGHT = 31;

UISwitch.prototype.init = function UISwitch_init() {
		__super.prototype.init.call(this);
		this.styleDefault();
		return this;};
	
	
	Object.defineProperty(UISwitch.prototype, "sizeIsEditable", {
		value: false});
	
	
	Object.defineProperty(UISwitch.prototype, "on", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_on")) Object.defineProperty(this, "_on", { writable: true, configurable: true });
			var didChange = this._on !== undefined;
			this._on = v;
			if (didChange) {
				this.styleDefault();
				this.outlineIconURLDidChange();
				if (this.dataProvider) this.dataProvider.notifyObservers();
			}
		}, get:function () { return this._on; }});
	

	Object.defineProperty(UISwitch.prototype, "notOn", {
		set: function (v) { this.on = !v; }, 
		get: function () { return !this.on; }});
	
	
	Object.defineProperty(UISwitch.prototype, "onTintColor", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_onTintColor")) Object.defineProperty(this, "_onTintColor", { writable: true, configurable: true }); this._onTintColor = v; if(this.canvasView) this.canvasView.layoutSubviews(); }, get:function () { return this._onTintColor; }});
	

UISwitch.prototype.outlineIconURLDidChange = function UISwitch__outlineIconURLDidChange() {
		this.context.broadcastValueChangeForKeyPathInObject('outlineIconURL', this, this);};
	
	
	Object.defineProperty(UISwitch.prototype, "readableType", {
		get: function () { return LocalizedString('Switch'); }});
	
	
	Object.defineProperty(UISwitch.prototype, "canvasView", {
	synthesized: true, get:function () { return this._canvasView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_canvasView")) Object.defineProperty(this, "_canvasView", { writable: true, configurable: true }); this._canvasView = v; }});
	
	

UISwitch.prototype.styleDefaultSystem7 = function UISwitch_styleDefaultSystem7() {

		if (!this.canvasView) {

			this.canvasView = createComponentFromDomain("CanvasView", "Core.UI", this.context, {
				size: { width: this.size.width+2, height: this.size.width+2 },
				position: { left: -1, top:-11 }})
			;
			var self = this;
			this.canvasView.draw = function (width, height) {
				var canvasView = this;
				this.context.whenImageIsReady(this.context.pathForOptimizedImage('Resources/UISliderButton.png'), function (img) {
					if (!canvasView.DOMNode) return;
					var scale = canvasView.contentScale;
					var ctx = canvasView.DOMNode.getContext('2d');
					var y = 11;
					ctx.save();
					ctx.scale(scale,scale);
					ctx.clearRect(0,0,width,height);
					if (self.on) {
						ctx.roundRect(1,y-.5,UISWITCH_WIDTH,UISWITCH_HEIGHT+0.5,UISWITCH_HEIGHT/2);
						ctx.fillStyle = self.onTintColor||'rgb(73,211,98)';
						ctx.fill();
					}
					else {
						ctx.roundRect(2.25-0.5,y+.25,UISWITCH_WIDTH-2+0.5,UISWITCH_HEIGHT-1,UISWITCH_HEIGHT/2);
						ctx.strokeStyle = 'rgb(235,235,235)';
						ctx.lineWidth = 1.5;
						ctx.stroke();
					}
	
					var x = self.on ? UISWITCH_WIDTH-35+2.5+0.25 : -0.5-0.25;
					ctx.drawImage(img,x,y-0.25,35,35);
					ctx.restore();
					
					self.outlineIconURLDidChange();
				}.bind(this));

			};
			this.addSubview(this.canvasView);
			this.canvasView.layoutSubviews();
		}
		else this.canvasView.layoutSubviews();
		};
	

UISwitch.prototype.styleDefaultSystem6 = function UISwitch_styleDefaultSystem6() {};
	
	
UISwitch.prototype.createForSuperview = function UISwitch_createForSuperview(superview) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: UISWITCH_WIDTH, height: UISWITCH_HEIGHT },
			position: { left: 0, top: 0 },
			autoresizingMask: 36,
			on: false,
			name: superview.context.nameForNewFormControl(this),
		});
	};
	

	Object.defineProperty(UISwitch.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: this.readableNameForProperty('onTintColor'), keyPath: 'onTintColor', type: 'color', positionLeft: true },
						{ name: this.readableNameForProperty('on'), keyPath: 'on', type: 'boolean', positionLeft: true, offsetX: 44 },
					]
				},
		
		
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				},
			];

		}});
	
	
	Object.defineProperty(UISwitch.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['on', this.readableNameForProperty('on')]
			);
			return result;
		}});
	
	
UISwitch.prototype.readableNameForProperty = function UISwitch_readableNameForProperty(theProperty) {
		switch (theProperty) {
			case 'on': return LocalizedString('On');
			case 'onTintColor': return LocalizedString('Color');
			case 'notOn': return LocalizedString('Off');
		}
		return __super.prototype.readableNameForProperty.call(this, theProperty);};
	
	
	Object.defineProperty(UISwitch.prototype, "outlineIconURL", {
		get: function () {
			if (this.canvasView) { return this.canvasView.DOMNode.toDataURL(); }
			if (this.on) return 'Resources/UISwitchOn.png';
			return 'Resources/UISwitch.png';
		}});
	

UISwitch.prototype.action = function UISwitch_action() {
		if (this.hasBindingForKey('on')) {
			this.context.beep();
			return;
		}
		this.dataController.setValueForKey(!this.on, 'on', this.dataController);};
	
	
UISwitch.prototype.prepareForEditor = function UISwitch_prepareForEditor(editor) {
		__super.prototype.prepareForEditor.call(this, editor);
		this.DOMNode.onclick = function (e) {
			if (editor.isActionClick(e)) this.action();
		}.bind(this);
		this.DOMNode.className += ' canClickInActionMode';
		getPrototype('info.appdoo-mac.SwitchDataProvider').addDataProviderToControl(this);
		this.styleDefault();};
	

	Object.defineProperty(UISwitch.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	

	Object.defineProperty(UISwitch.prototype, "isFormElement", {
		value: true});
	

	Object.defineProperty(UISwitch.prototype, "value", {
		get: function () { return this.on ? true : false; }});
	

UISwitch.prototype.transformData = function UISwitch_transformData(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		if (transformer.isXIBGenerator) delete result['color backgroundColor'];
		
		transformer.setColorProperty(result, 'onTintColor', data.onTintColor, true);
		transformer.setBooleanProperty(result, 'on', data.on, true);
		
		if (data.dataProvider) {
			var dataProvider = transformer.addDataProviderToObject(result, data);
			transformer.registerInverseBinding(result, data, 'on', 'control', data.dataProvider.$id, dataProvider);
			transformer.registerInverseBinding(result, data, 'notOn', 'control', data.dataProvider.$id, dataProvider);
		}
		
		return result;};
	

UISwitch.prototype.initPropertiesFromData = function UISwitch_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("on")) this.on = data.on;
if (data.hasOwnProperty("onTintColor")) this.onTintColor = data.onTintColor;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
};

UISwitch.prototype.decodeData = function UISwitch_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

UISwitch.prototype.encode = function UISwitch_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

UISwitch.prototype.encodeCloned = function UISwitch_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

UISwitch.prototype.expectedTypeForProperty = function UISwitch_expectedTypeForProperty(key) {
	if (key === "sizeIsEditable") return "";
	if (key === "on") return "Boolean";
	if (key === "notOn") return "";
	if (key === "onTintColor") return "String";
	if (key === "readableType") return "";
	if (key === "canvasView") return "";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "outlineIconURL") return "";
	if (key === "dataProvider") return "SwitchDataProvider";
	if (key === "isFormElement") return "";
	if (key === "value") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UISwitch; }()));
registerType('info.appdoo-mac', (function () { function SwitchDataProvider() {} var __super = setSupertypeFromDomain(SwitchDataProvider, 'ControlDataProvider', 'info.appdoo-mac');

	Object.defineProperty(SwitchDataProvider.prototype, "propertiesForBindings", {
		value: ['on','notOn']});
	
	
	Object.defineProperty(SwitchDataProvider.prototype, "isPlugin", {
		value: true});
	

SwitchDataProvider.prototype.expectedTypeForProperty = function SwitchDataProvider_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (key === "isPlugin") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SwitchDataProvider; }()));