
registerType('appdoo.iOS', (function () { function UITabBar() {} var __super = setSupertypeFromDomain(UITabBar, 'UIView', 'appdoo.iOS');


	Object.defineProperty(UITabBar.prototype, "translucent", {
	outlet: true, 
	enumerable: true, get:function () { return this._translucent; }, set:function (v) {if (!Object.hasOwnProperty(this, "_translucent")) Object.defineProperty(this, "_translucent", { writable: true, configurable: true }); this._translucent = v; }});
	
	
	Object.defineProperty(UITabBar.prototype, "barStyle", {
	outlet: true, 
	enumerable: true, get:function () { return this._barStyle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_barStyle")) Object.defineProperty(this, "_barStyle", { writable: true, configurable: true }); this._barStyle = v; }});
	

	Object.defineProperty(UITabBar.prototype, "tintColor", {
	outlet: true, 
	enumerable: true, get:function () { return this._tintColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_tintColor")) Object.defineProperty(this, "_tintColor", { writable: true, configurable: true }); this._tintColor = v; }});
	

	Object.defineProperty(UITabBar.prototype, "barTintColor", {
	outlet: true, 
	enumerable: true, get:function () { return this._barTintColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_barTintColor")) Object.defineProperty(this, "_barTintColor", { writable: true, configurable: true }); this._barTintColor = v; }});
	

	Object.defineProperty(UITabBar.prototype, "tintColorSystem6", {
	outlet: true, 
	enumerable: true, get:function () { return this._tintColorSystem6; }, set:function (v) {if (!Object.hasOwnProperty(this, "_tintColorSystem6")) Object.defineProperty(this, "_tintColorSystem6", { writable: true, configurable: true }); this._tintColorSystem6 = v; }});
	

	Object.defineProperty(UITabBar.prototype, "items", {
	synthesized: true, 
		set: function (a) {if (!Object.hasOwnProperty(this, "_items")) Object.defineProperty(this, "_items", { writable: true, configurable: true });
		
			if (this._selectedIndex !== undefined)
				this._selectedIndex = undefined;
			this._items = a;
			
			if (this.subviews) this.createSubviews();
			
		}, get:function () { return this._items; }});
	
	
	Object.defineProperty(UITabBar.prototype, "selectedItem", {
		set: function (v) { this.selectedIndex = this.items.indexOf(v); }, 
		get: function () { return this.items[this.selectedIndex]; }});
	
	
	Object.defineProperty(UITabBar.prototype, "encodesSubviews", {
		value: false});
	
	
	
	

	Object.defineProperty(UITabBar.prototype, "e_barStyle", {
		get: function ( ) { return this.barStyle; }, 
		set: function (v) { this.barStyle = v; this.styleDefault(); }});
	

	Object.defineProperty(UITabBar.prototype, "e_tintColor", {
		set: function (v) {
			this.tintColor = v;
			this.styleDefault();
		}, 
		get: function () {
			return this.tintColor || this.context.defaultOrSystemTintColor;
		}});
	

	Object.defineProperty(UITabBar.prototype, "e_barTintColor", {
		get: function ( ) { return this.barTintColor; }, 
		set: function (v) { this.barTintColor = v; this.tintColorSystem6 = v; this.styleDefault(); }});
	

	Object.defineProperty(UITabBar.prototype, "e_tintColorSystem6", {
		get: function ( ) { return this.tintColorSystem6 || 'rgba(0,0,0,1.00)'; }, 
		set: function (v) { this.tintColorSystem6 = v; this.barTintColor = v; this.styleDefault(); }});
	

	Object.defineProperty(UITabBar.prototype, "e_translucent", {
		get: function ( ) { return this.translucent; }, 
		set: function (v) { this.translucent = v; this.styleDefault(); _context.editor.contentFrameController.needsWindowLayout(); }});
	

	Object.defineProperty(UITabBar.prototype, "e_barStyleIsBlack", {
		get: function () { return this.barStyle === UIBarStyleBlack; }, 
		set: function (v) { this.e_barStyle = v ? UIBarStyleBlack : UIBarStyleDefault; }});
	


	

UITabBar.prototype.init = function UITabBar_init() {

		__super.prototype.init.call(this);
		
		this.styleDefault();

		this.size = { height: this.context.simulatedDeviceIsIPhone ? 49 : 56, width: this._size.width };
	};
	
	
	
	
UITabBar.prototype.styleDefaultSystem6 = function UITabBar__styleDefaultSystem6() {
		var gradient;
		
		if (this.tintColorSystem6 && this.tintColorSystem6 !== 'rgba(0,0,0,1.00)') {
			gradient = '-webkit-linear-gradient(rgb(0,0,0) 0%, '+this.tintColorSystem6+' 2%)';
		}
		else {
			gradient = '-webkit-linear-gradient(rgb(0,0,0) 0%, rgb(66,66,66) 2%, rgb(45,45,45) 4%, rgb(20,20,20) 49%, rgb(0,0,0) 49%)';
		}
		
		this.style({
			bottom: "0px",
			position: "absolute",
			cursor: 'default',
			backgroundImage: gradient,
			textAlign: 'center'
		});};
	

UITabBar.prototype.styleDefaultSystem7 = function UITabBar__styleDefaultSystem7() {

		var backgroundImage;
		var alpha = this.translucent ? 0.96 : 1.0;
		
		if (this.barTintColor || this.translucent) {
			var c = determineBarTintColor(this.barTintColor, this.barStyle, this.translucent);
			backgroundImage = '-webkit-linear-gradient(' + c + ',' + c + ' 1%)';
		}
		else {
			if (this.barStyle == UIBarStyleBlack) {
				var brightness = this.translucent ? 10 : 0;
				backgroundImage = '-webkit-linear-gradient(hsl(0,0%,30%) 0%, hsla(0,0%,'+brightness+'%,'+alpha+') 1%, hsla(0,0%,'+brightness+'%,'+alpha+') 1%)';
			}
			else {
				backgroundImage = '-webkit-linear-gradient(hsl(0,0%,70%) 0%, hsla(0,0%,70%,'+alpha+') 1%, hsla(0,0%,100%,'+alpha+') 1%)';
			}
		}
	
		this.style({
			bottom: "0px",
			position: "absolute",
			cursor: 'default',
			backgroundImage: backgroundImage,
			textAlign: 'center'
		});
		
		if (this.subviews[this.selectedIndex]) {
			this.subviews[this._selectedIndex].styleSelected();
		}};
	


	
	
	Object.defineProperty(UITabBar.prototype, "delegate", {
	outlet: true, get:function () { return this._delegate; }, set:function (v) {if (!Object.hasOwnProperty(this, "_delegate")) Object.defineProperty(this, "_delegate", { writable: true, configurable: true }); this._delegate = v; }});
	

	Object.defineProperty(UITabBar.prototype, "selectedIndex", {
	synthesized: true, 
		set: function (index) {if (!Object.hasOwnProperty(this, "_selectedIndex")) Object.defineProperty(this, "_selectedIndex", { writable: true, configurable: true });
		
			var oldValue = this._selectedIndex,
				isUpdatingValue = (this._selectedIndex !== undefined);
			
			if (oldValue === index) return;

			this._selectedIndex = index;

			if (isUpdatingValue === true) {
				var selectedTab = this.subviews[oldValue];
				if (selectedTab) {
					this.subviews[oldValue].selected = false;
				}
				this.callDelegate('tabBarValueDidChange', [this]);
			}
			

			if (index >= 0 && this.subviews && this.subviews[index]) {
				this.subviews[index].selected = true;
			} else if( index < 0 ) {
				
			} else {
				console.warn('Invalid index:', index);
			}
		

		}, get:function () { return this._selectedIndex; }});
	
	
UITabBar.prototype.updateSelectedIndexFromMouseEvent = function UITabBar_updateSelectedIndexFromMouseEvent(i, e) {
		if (this.selectedIndex === i) {
			_context.editor.selectSingleObject(this);
		}
		this.selectedIndex = i;
		this.callDelegate('tabBarDidGetInput', [this, e]);
		this.didGetInput(e);};
	
	
UITabBar.prototype.didGetInput = function UITabBar__didGetInput() {};
	

	Object.defineProperty(UITabBar.prototype, "highResolutionEnabled", {
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_highResolutionEnabled")) Object.defineProperty(this, "_highResolutionEnabled", { writable: true, configurable: true });
			this._highResolutionEnabled = v;
			if (this.subviews)
			if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
				subview.highResolutionEnabled = v;return true; }, this);
			
		}, get:function () { return this._highResolutionEnabled; }});
	
	


	
UITabBar.prototype.resetSelectedIndex = function UITabBar_resetSelectedIndex(index) {

		if (!this.subviews) return;

		if (this._selectedIndex !== undefined) {
			var selectedTab = this.subviews[this._selectedIndex];
			if (selectedTab) {
				this.subviews[this._selectedIndex].selected = false;
				delete this._selectedIndex;
			}
		}

		this.selectedIndex = index;
};
	

UITabBar.prototype.createSubviews = function UITabBar__createSubviews() {

		if (!this._size) return;
		
		
		var oldItemViews = {};

		if (this.subviews) {
			if (Array.isArray(clone(this.subviews))) clone(this.subviews).every(function (tabBarItemView) {
				if (!tabBarItemView.originalItem) return true;
				if (this.items.indexOf(tabBarItemView.originalItem) !== -1) {
					oldItemViews[tabBarItemView.originalItem.identify()] = tabBarItemView;
					tabBarItemView.removeFromSuperview(true);
				}return true; }, this);
			
			this.removeAllSubviews();
		}
		
		var tabWidth = this.calculateTabWidth(),
			oddPadding = this.calculatePadding(tabWidth),
			i = 0;
		
		if (Array.isArray(this.items)) this.items.every(function (item) {
		
			var tabBarItemView = oldItemViews[item.identify()];
			
			if (!tabBarItemView) {
				tabBarItemView = this.createItemView(item, tabWidth);
				tabBarItemView.prepareForEditor(_context.editor);
			} else {
				tabBarItemView.selected = false;
				tabBarItemView.styleDefault();
			}
			item.view = tabBarItemView;
			
			this.addSubview(tabBarItemView);
			i++;
return true; }, this);
		
		
		this.layoutSubviews();};
	
	
UITabBar.prototype.createItemView = function UITabBar__createItemView(tabBarItem, width) {
	
		var tabBarItemView = createComponentFromDomain(
					"UITabBarItemView", "appdoo.iOS",
					this.context, {
						title: tabBarItem.title,
						size: { width: width },
						image: tabBarItem.image,
						originalItem: tabBarItem
					});
		return tabBarItemView;
		};
	
	
	Object.defineProperty(UITabBar.prototype, "itemWidth", {
	outlet: true, 
	enumerable: true, get:function () { return this._itemWidth; }, set:function (v) {if (!Object.hasOwnProperty(this, "_itemWidth")) Object.defineProperty(this, "_itemWidth", { writable: true, configurable: true }); this._itemWidth = v; }});
	
	
UITabBar.prototype.calculateTabWidth = function UITabBar__calculateTabWidth() {

		if (!this.items) return 0;
		
		if (!this.context.simulatedDeviceIsIPhone)
			return this.itemWidth || 76;
		
		return Math.floor(this.size.width/this.items.length)-1;
	};
	
	
UITabBar.prototype.calculatePadding = function UITabBar__calculatePadding(tabWidth) {

		var oddPadding = (this.size.width-tabWidth*this.items.length)-((this.items.length-1)*2);

		oddPadding %= 4;
		
		return oddPadding;
	};
	
	
	
	
UITabBar.prototype.layoutSubviews = function UITabBar_layoutSubviews() {
		
		if (addSceneButton) { addSceneButton.removeFromSuperview(true); }
	
		var isPhone = this.context.simulatedDeviceIsIPhone;
		var tabWidth = this.calculateTabWidth()-1;
		var itemSpacing = isPhone ? 0 : this.itemSpacing || 34;

		if (Array.isArray(this.items)) this.items.every(function (tabBarItem) {
			tabBarItem.view.size.width = tabWidth;
			if (tabBarItem !== this.items[this.items.length-1])
				tabBarItem.view.style({ marginRight: itemSpacing+'px' });return true; }, this);
		};
	


	
	
	var dataTransferIndexKey = 'tab-bar-item-index';
	
	var addSceneButton;
UITabBar.prototype.prepareForEditor = function UITabBar_prepareForEditor(editor) {
	
		if (this._isPrepared) return;
		Object.defineProperty(this, "_isPrepared", {
			value: true});
		
	
		var editorContext = editor.context,
			self = this,
			insertIndicator,
			contentScale,
			tabWidth;

		function showInsertIndicator(targetIndex) {
			
			var left;
			
			if (targetIndex === 0) left = self.items[0].view.DOMNode.offsetLeft-4;
			else {
				left = parseInt(self.subviews[targetIndex-1].DOMNode.offsetLeft + getTabWidth());
			}
			left -= 4;
	
			if (insertIndicator === undefined) {
	
				insertIndicator = createComponentFromDomain(
					'ImageView', 'Core.UI', editorContext, {
					imageSrc: 'Resources/TabBarInsertIndicator.png',
					size: { width: 10, height: 47 },
					position: { bottom: 2, left: left },
					style: { zIndex: 1, pointerEvents: 'none', opacity: 1 }
				});
				self.superview.addSubview(insertIndicator);
	
			}
			else {
				insertIndicator.hidden = false;
				insertIndicator.position.left = left;
			}
		
		}
		
		function hideInsertIndicator() {
			if (insertIndicator !== undefined)
				insertIndicator.hidden = true;
		}
	
		function getTabWidth() {
			if (!self.items || !self.items.length) return 100;

			var firstItemNode = self.items[0].view.DOMNode;
			var lastItemNode = self.items[self.items.length-1].view.DOMNode;
			
			return (lastItemNode.offsetLeft+lastItemNode.offsetWidth-firstItemNode.offsetLeft)/self.items.length;
			
			return self.items[0].view.size.width;
		}
		
		function getTargetIndex(eventX) {
			var offsetX = self.items[0].view.DOMNode.offsetLeft;
			
			var x = (self.getRelativeX(eventX)) / contentScale;
			x -= offsetX;
			
			var targetIndex = parseInt((x+tabWidth/2) / tabWidth);
			
			return Math.min(self.items.length, Math.max(0, targetIndex));
		}
	
		self.dropHandler = {
	
			didDropWithEvent: function (e) {
			
			
				hideInsertIndicator();
				
		
				var sourceIndex = parseInt(e.dataTransfer.getData(dataTransferIndexKey)),
					targetIndex = getTargetIndex(e.x);


				if (targetIndex > sourceIndex+1) {
					targetIndex -= 1;
				}
				else if ((targetIndex <= sourceIndex) === false) {
					return;
				}
		
				_context.projectContext.tabBarController.moveViewControllerAtIndex_toIndex_(sourceIndex, targetIndex);
				
			},
	
			dropEffectForEvent: function (e) {
			
				if (!e.dataTransfer.types) return 'none';
	
				if (e.dataTransfer.types.indexOf(dataTransferIndexKey) === -1) {
					hideInsertIndicator();
					return 'none';
				}
		
				var sourceIndex = parseInt(e.dataTransfer.getData(dataTransferIndexKey)),
					targetIndex = getTargetIndex(e.x);
				
				if (targetIndex === sourceIndex || targetIndex === sourceIndex+1) {
					hideInsertIndicator();
					return 'none';
				}
				
				
				
				if (e.altKey) {
					hideInsertIndicator();
					return 'none';
				}
				
				showInsertIndicator(targetIndex);
				return 'move';
			},
	
			didLeaveWithEvent: function (e) {
			
				hideInsertIndicator();

			},
			
			didEnterWithEvent: function (e) {
			
				contentScale = editor.contentFrameController.contentScale;
				tabWidth = getTabWidth();

			}
	
		};
		
		
		
		function createAddSceneButton() {
			addSceneButton = createComponentFromDomain("SpriteButton", "Core.UI", this.context, {
				size: { width: 50, height: 50 },
				sprite: 'Resources/AddTabButton.png',
				hidden: true,
				action: function () {
					var scene = _context.createNewScene(true);
					if (scene) {
						scene.e_showsNavigationBar = true;
						scene.showsTabBar = true;
						scene.e_showsInTabBar = true;
						_context.editSceneWithID(scene.$id);
						showAddSceneButton();
					}
				}})
			;
		}

		function showAddSceneButton() {
			if (!addSceneButton || !addSceneButton.DOMNode)
				createAddSceneButton.call(self);
			self.addSubview(addSceneButton);
			addSceneButton.position.left = self.size.width;
			addSceneButton.position.top = 0;
			addSceneButton.hidden = false;
		}

		function hideAddSceneButton() {
			if (addSceneButton) addSceneButton.hidden = true;
		}
		
		this.DOMNode.onmouseover = function (e) {
			if (e.which) return;
			showAddSceneButton();
		};
		
		this.DOMNode.onmouseout = function (e) {
			if (e.which) return;
			hideAddSceneButton();
		};

		
		this.didGetInput = function(e) {
			showAddSceneButton();
		};
		
		if (this.font === undefined) {
			var isIPhone = this.context.simulatedDeviceIsIPhone
			var fontSize = isIPhone ? 10 : 14;
			this.font = createComponentFromDomain("UIFont", "appdoo.iOS", this.context, {
				fontFamily: defaultFontFamily,
				fontName: defaultFontName,
				pointSize: fontSize})
			;
		}

		this.observeObject(this.font);
	};
	
	var defaultFontFamily = 'System',
		defaultFontName = '_DEFAULT_';

UITabBar.prototype.unprepareForEditor = function UITabBar_unprepareForEditor(editor) {
		this.unobserveObject(this.font);
		if (addSceneButton) addSceneButton.removeFromSuperview();};
	

	
UITabBar.prototype.observedObjectValueDidChangeForKeyPath = function UITabBar_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {
		if (obj === this.font) {
			if (Array.isArray(this.subviews)) this.subviews.every(function (tabBarItemView) {
				tabBarItemView.styleDefault();
				if (tabBarItemView.selected) tabBarItemView.selected = true;return true; }, this);
			
		}};
	

	Object.defineProperty(UITabBar.prototype, "readableType", {
		get: function () { return LocalizedString('Tab Bar'); }});
	


	Object.defineProperty(UITabBar.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [

						{ name: LocalizedString('Global Tint Color'), keyPath: 'e_tintColor', type: 'color',  hidden:false },
						{ name: LocalizedString('Background Color'), keyPath: 'e_barTintColor', type: 'color', undefinedValue: '', hidden:false },
						{ name: LocalizedString('Background Color'), keyPath: 'e_tintColorSystem6', type: 'color', undefinedValue: '', hidden:true },

						{ type: 'space' },
						{ name: LocalizedString('Translucent'), keyPath: 'e_translucent', type: 'boolean',alignLabel:true },
						{ name: LocalizedString('Dark style'), keyPath: 'e_barStyleIsBlack', type: 'boolean',alignLabel:true  },

					]
				},
				{
					type: 'group',
					title: LocalizedString('Font'),
					id: this.constructor.name+'Font',
					items: [
						{ type: 'boolean', name: LocalizedString('Change Default Font'), positionLeft: true, keyPath: 'usesCustomFont' },
						{ type: 'space', hidden: !this.usesCustomFont },
						{ type: 'font', hidden: !this.usesCustomFont },
						{ type: 'space', hidden: !this.usesCustomFont },
						{ type: 'fontSize', keyPath: 'fontSize', hidden: !this.usesCustomFont },
					]
				},
			];
		}});
	

	Object.defineProperty(UITabBar.prototype, "widthIsEditable", {
		value: false});
	

	Object.defineProperty(UITabBar.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(UITabBar.prototype, "xIsEditable", {
		value: false});
	

	Object.defineProperty(UITabBar.prototype, "yIsEditable", {
		value: false});
	

	Object.defineProperty(UITabBar.prototype, "positionIsEditable", {
		value: false});
	

	Object.defineProperty(UITabBar.prototype, "sizeIsEditable", {
		value: false});
	
	
	Object.defineProperty(UITabBar.prototype, "autoresizingMaskIsEditable", {
		value: false});
	

	Object.defineProperty(UITabBar.prototype, "canHaveLayoutRelations", {
		value: false});
	

UITabBar.prototype.selectForEditor = function UITabBar_selectForEditor(editor) {
		editor.showFocusRing(this);};
	

UITabBar.prototype.unselectForEditor = function UITabBar_unselectForEditor(editor) {
		editor.hideFocusRing(this);};
	

	Object.defineProperty(UITabBar.prototype, "outlineIconURL", {
		get: function () {
			return this.context.pathForResource('UITabBar.png')
		}});
	
	
	
UITabBar.prototype.tabBar_transformDataForXIB = function UITabBar_tabBar_transformDataForXIB(data, transformer) {
		
		var height = 49;
	
		var result = {
				key: 'tabBar',
				contentMode: 'scaleToFill',
				translucent: data.translucent ? 'YES' : 'NO',
				id: transformer.createStoryboardID(),
				rect: {
					key: 'frame',
					x: '0',
					y: (transformer.context.projectContext.screenSizeInPoints.height-height).toString(),
					width: transformer.context.projectContext.screenSizeInPoints.width.toString(),
					height: height.toString()
				},
				autoresizingMask: {
					key: 'autoresizingMask',
					widthSizable: 'YES',
					flexibleMinY: 'YES'
				},
				'color backgroundColor': {
					key: 'backgroundColor',
					white: '0',
					alpha: '0',
					colorSpace: 'calibratedWhite'
				},
				barStyle: data.barStyle === 1 ? 'black' : 'default'
			};
		
		if (data.tintColor) result['color tintColor'] = transformer.transformCSSColor(data.tintColor, 'tintColor');
		if (data.barTintColor) result['color barTintColor'] = transformer.transformCSSColor(data.barTintColor, 'barTintColor');

		return result;
	};
	
	
UITabBar.prototype.tabBar_transformDataForPreview = function UITabBar_tabBar_transformDataForPreview(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		result.$type = this.constructor.name;
		result.translucent = transformer.transformBoolean(data.translucent);
		result.barStyle = transformer.transformInteger(data.barStyle);
		result.barTintColor = transformer.transformCSSColor(data.barTintColor);
		result.tintColor = transformer.transformCSSColor(data.tintColor);
		return result;};
	
	
UITabBar.prototype.transformData = function UITabBar_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.tabBar_transformDataForXIB(data, transformer);
		return this.tabBar_transformDataForPreview(data, transformer);};
	

UITabBar.prototype.deleteForEditor = function UITabBar_deleteForEditor(editor) {
		if (editor.editedScene)
			editor.editedScene.dataController.setValueForKeyPath(false, 'e_showsTabBar', editor.editedScene.dataController);
		return false;};
	
	
	
UITabBar.prototype.fileReferenceDidUpdate = function UITabBar_fileReferenceDidUpdate(ref) {
		if (Array.isArray(this.items)) this.items.every(function (item) {
			item.fileReferenceDidUpdate(ref);return true; }, this);
		};
	

	Object.defineProperty(UITabBar.prototype, "font", {
		get: function () {
			return this.context.project.tabBarItemFont;
		}, 
		set: function (v) {
			this.context.project.tabBarItemFont = v;
		}});
	
	
	Object.defineProperty(UITabBar.prototype, "usesCustomFont", {
		get: function () {
			return this.context.project.usesCustomTabBarItemFont;
		}, 
		set: function (v) {
			this.context.project.usesCustomTabBarItemFont = v;
			_context.editor.refreshInspector();
			this.observedObjectValueDidChangeForKeyPath(this.font, 'fontName', null);
		}});
	
	
	Object.defineProperty(UITabBar.prototype, "fontName", {
		set: function (v) { this.font.fontName = v; }, 
		get: function ( ) { return this.font.fontName; }});
	
	Object.defineProperty(UITabBar.prototype, "fontFamily", {
		set: function (v) { this.font.fontFamily = v; }, 
		get: function ( ) { return this.font.fontFamily; }});
	
	Object.defineProperty(UITabBar.prototype, "fontSize", {
		set: function (v) { this.font.pointSize = v; }, 
		get: function ( ) { return this.font.pointSize; }});
	


UITabBar.prototype.initPropertiesFromData = function UITabBar_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("translucent")) this.translucent = data.translucent;
if (data.hasOwnProperty("barStyle")) this.barStyle = data.barStyle;
if (data.hasOwnProperty("tintColor")) this.tintColor = data.tintColor;
if (data.hasOwnProperty("barTintColor")) this.barTintColor = data.barTintColor;
if (data.hasOwnProperty("tintColorSystem6")) this.tintColorSystem6 = data.tintColorSystem6;
if (data.hasOwnProperty("delegate")) this.delegate = data.delegate;
if (data.hasOwnProperty("highResolutionEnabled")) this.highResolutionEnabled = data.highResolutionEnabled;
if (data.hasOwnProperty("itemWidth")) this.itemWidth = data.itemWidth;
};

UITabBar.prototype.decodeData = function UITabBar_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

UITabBar.prototype.encode = function UITabBar_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

UITabBar.prototype.encodeCloned = function UITabBar_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

UITabBar.prototype.expectedTypeForProperty = function UITabBar_expectedTypeForProperty(key) {
	if (key === "translucent") return "Boolean";
	if (key === "barStyle") return "Number";
	if (key === "tintColor") return "String";
	if (key === "barTintColor") return "String";
	if (key === "tintColorSystem6") return "String";
	if (key === "items") return "UITabBarItem[]";
	if (key === "selectedItem") return "UITabBarItem";
	if (key === "encodesSubviews") return "";
	if (key === "e_barStyle") return "Number";
	if (key === "e_tintColor") return "String";
	if (key === "e_barTintColor") return "String";
	if (key === "e_tintColorSystem6") return "String";
	if (key === "e_translucent") return "Boolean";
	if (key === "e_barStyleIsBlack") return "Boolean";
	if (key === "delegate") return "";
	if (key === "selectedIndex") return "";
	if (key === "highResolutionEnabled") return "";
	if (key === "itemWidth") return "Number";
	if (key === "readableType") return "";
	if (key === "inspectorProperties") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "autoresizingMaskIsEditable") return "";
	if (key === "canHaveLayoutRelations") return "";
	if (key === "outlineIconURL") return "";
	if (key === "font") return "UIFont";
	if (key === "usesCustomFont") return "Boolean";
	if (key === "fontName") return "String";
	if (key === "fontFamily") return "String";
	if (key === "fontSize") return "Number";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UITabBar; }()));