
registerType('appdoo.iOS', (function () { function UITabBarController() {} var __super = setSupertypeFromDomain(UITabBarController, 'UIViewController', 'appdoo.iOS');

	Object.defineProperty(UITabBarController.prototype, "tabBar", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			return this._tabBar || this.createTabBar();
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_tabBar")) Object.defineProperty(this, "_tabBar", { writable: true, configurable: true }); this._tabBar = v; }});
	

	Object.defineProperty(UITabBarController.prototype, "viewControllerIDs", {
	outlet: true, 
	enumerable: true, get:function () { return this._viewControllerIDs; }, set:function (v) {if (!Object.hasOwnProperty(this, "_viewControllerIDs")) Object.defineProperty(this, "_viewControllerIDs", { writable: true, configurable: true }); this._viewControllerIDs = v; }});
	

	Object.defineProperty(UITabBarController.prototype, "numberOfItems", {
		get: function () { return this.viewControllerIDs ? this.viewControllerIDs.length : 0; }});
	
	
UITabBarController.prototype.addScene = function UITabBarController_addScene(scene) {
		if (!this.viewControllerIDs) this.viewControllerIDs = [];
		var i = this.viewControllerIDs.indexOf(scene.viewController.$id);
		if (i === -1) {
			this.viewControllerIDs.push(scene.viewController.$id);
		}};
	

UITabBarController.prototype.removeScene = function UITabBarController_removeScene(scene) {
		if (!this.viewControllerIDs) return;
		var i = this.viewControllerIDs.indexOf(scene.viewController.$id);
		if (i !== -1) {
			this.viewControllerIDs.splice(i, 1);
		}};
	
	
UITabBarController.prototype.moveViewControllerAtIndex_toIndex_ = function UITabBarController_moveViewControllerAtIndex_toIndex_(sourceIndex, targetIndex) {
		var id = this.viewControllerIDs[sourceIndex];
		this.viewControllerIDs.splice(sourceIndex, 1);
		this.viewControllerIDs.splice(targetIndex, 0, id);
		this.updateTabBar();};
	
	
UITabBarController.prototype.updateTabBar = function UITabBarController_updateTabBar() {

		var tabBarItems = [];
		
		if (Array.isArray(clone(this.viewControllerIDs))) clone(this.viewControllerIDs).every(function (id) {
			var viewControllerData = this.context.viewControllerWithID(id);
			if (!viewControllerData) {
				this.viewControllerIDs.splice(this.viewControllerIDs.indexOf(id),1);
			}
			else if (viewControllerData.tabBarItem) {
				tabBarItems.push(viewControllerData.tabBarItem);
			}return true; }, this);
		
		this.tabBar.items = tabBarItems;
		
		if (!tabBarItems.length) {
			_context.editor.contentFrameController.hideTabBar();
			return false;
		}

		_context.editor.contentFrameController.showTabBar();
		this.tabBar.selectedItem = _context.editor.editedViewController.tabBarItem;
		return true;
	};
	


	

UITabBarController.prototype.createTabBar = function UITabBarController__createTabBar() {
	
		var tabBar = createComponentFromDomain("UITabBar", "appdoo.iOS", this.context, {
				tabBarController: this,
				delegate: this,
				size: { width: 320 }
			});

		Object.defineProperty(this, '_tabBar', {
			value: tabBar,
			configurable: true
		});
		
		return tabBar;
};
	


	

UITabBarController.prototype.tabBarDidGetInput = function UITabBarController_tabBarDidGetInput(tabBar) {
		this.selectedIndex = tabBar.selectedIndex;};
	


	

	Object.defineProperty(UITabBarController.prototype, "selectedIndex", {

		get: function () { return this._selectedIndex; }, 

		set: function (v) {

			if (this.viewControllers[v] === undefined) return;
			
			this.currentViewController = this.viewControllers[v];
			this.tabBar.selectedIndex = v;
			var previousSelectedIndex = this._selectedIndex;

			Object.defineProperty(this, '_selectedIndex', { value: v,
				writable: true });

			if (this._delegate !== undefined) {
				this._delegate.tabBarControllerDidShowViewController(this, this.viewControllers[this.selectedIndex]);
			}
		}
});
	

	Object.defineProperty(UITabBarController.prototype, "currentViewController", {
		set: function (value) {
		
			if (this._currentViewController !== undefined) {
				this.viewContainer.removeSubview(this.currentViewController.view, true);
			}
			
			Object.defineProperty(this, '_currentViewController', {
				value: value, writable: true });

			this._currentViewController.loadView();
			
			if (this._currentViewController.view === undefined) {
				console.warn('_currentViewController has no view!', this._currentViewController);
				return;
			}
			
			
			this._currentViewController.view.style({
				width: this.viewContainer.DOMNode.style.width,
				height: this.viewContainer.DOMNode.style.height
			});
			
			this.viewContainer.addSubview(this._currentViewController.view);

		}, 

		get: function () { return this._currentViewController; }});
	
	
	Object.defineProperty(UITabBarController.prototype, "viewControllers", {
		set: function (a) {
		
			Object.defineProperty(this, "_viewControllers", {
				value: a, writable: true });

			a.every(function (vc) {
				vc.parentController = this;
				return true;
			}.bind(this));
			
			this.tabBar.viewControllers = this.viewControllers;

		}, 
		get: function () {
			return this._viewControllers;
		}});
	
	
UITabBarController.prototype.transformData = function UITabBarController_transformData(data, transformer) {

		if (!transformer.isXIBGenerator) {
			var result = {
				$type: this.constructor.name,
				$domain: this.__domain,
				$id: data.$id,
			};
			
			result.$viewControllerIDs = data.viewControllerIDs;
			result.tabBar = getPrototype('appdoo.iOS.UITabBar').transformData(data.tabBar, transformer);
			
			return result;
		}
};
	

UITabBarController.prototype.initPropertiesFromData = function UITabBarController_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("tabBar")) this.tabBar = data.tabBar;
if (data.hasOwnProperty("viewControllerIDs")) this.viewControllerIDs = data.viewControllerIDs;
};

UITabBarController.prototype.decodeData = function UITabBarController_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("tabBar")) decoded.tabBar = this.context.decodeObjectTree(data.tabBar);
return decoded; };

UITabBarController.prototype.encode = function UITabBarController_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._tabBar && this._tabBar.encode) {encoded.tabBar = this.tabBar.encode();
}return encoded; };

UITabBarController.prototype.encodeCloned = function UITabBarController_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._tabBar && this._tabBar.encode) {encoded.tabBar = this.tabBar.encodeCloned();
}return encoded; };

UITabBarController.prototype.expectedTypeForProperty = function UITabBarController_expectedTypeForProperty(key) {
	if (key === "tabBar") return "UITabBar";
	if (key === "viewControllerIDs") return "Array";
	if (key === "numberOfItems") return "Array";
	if (key === "selectedIndex") return "";
	if (key === "currentViewController") return "";
	if (key === "viewControllers") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UITabBarController; }()));