
registerType('appdoo.iOS', (function () { function UITabBarItem() {} var __super = setSupertypeFromDomain(UITabBarItem, 'BasicObject', 'Core');


	Object.defineProperty(UITabBarItem.prototype, "title", {
	outlet: true, 
	enumerable: true, get:function () { return this._title; }, set:function (v) {if (!Object.hasOwnProperty(this, "_title")) Object.defineProperty(this, "_title", { writable: true, configurable: true }); this._title = v; }});
	

	Object.defineProperty(UITabBarItem.prototype, "image", {
	outlet: true, 
	enumerable: true, get:function () { return this._image; }, set:function (v) {if (!Object.hasOwnProperty(this, "_image")) Object.defineProperty(this, "_image", { writable: true, configurable: true }); this._image = v; }});
	

	Object.defineProperty(UITabBarItem.prototype, "unselectedImage", {
	outlet: true, 
	enumerable: true, get:function () { return this._unselectedImage; }, set:function (v) {if (!Object.hasOwnProperty(this, "_unselectedImage")) Object.defineProperty(this, "_unselectedImage", { writable: true, configurable: true }); this._unselectedImage = v; }});
	
	
	Object.defineProperty(UITabBarItem.prototype, "hasUnselectedImage", {
		get: function () { return this.unselectedImage && this.unselectedImage.imageID; }});
	

	Object.defineProperty(UITabBarItem.prototype, "e_title", {
		get: function ( ) { if (this.title === _context.editor.editedViewController.title) return ''; return this.title; }, 
		set: function (v) { this.title = v || _context.editor.editedViewController.title; if (this.view) this.view.title = this.title; }});
	

	Object.defineProperty(UITabBarItem.prototype, "e_image", {
		get: function ( ) { return this.image; }, 
		set: function (v) {
			this.image = v;
			if (this.view) {
				this.view.updateImage();
			}
		}});
	

	Object.defineProperty(UITabBarItem.prototype, "e_unselectedImage", {
		get: function ( ) { return this.unselectedImage; }, 
		set: function (v) { this.unselectedImage = v; if (this.view) { this.view.updateImage();} }});
	



	Object.defineProperty(UITabBarItem.prototype, "readableValue", {
		get: function () { return LocalizedString('Tab Bar Item') }});
	

	Object.defineProperty(UITabBarItem.prototype, "outlineIconURL", {
		get: function () {
			return this.context.pathForResource('UITabBarItem.png')
		}});
	

	Object.defineProperty(UITabBarItem.prototype, "editedScene", {
		get: function () { return _context.editor.editedScene; }});
	

	Object.defineProperty(UITabBarItem.prototype, "view", {
	outlet: true, get:function () { return this._view; }, set:function (v) {if (!Object.hasOwnProperty(this, "_view")) Object.defineProperty(this, "_view", { writable: true, configurable: true }); this._view = v; }});
	

	Object.defineProperty(UITabBarItem.prototype, "inspectorProperties", {
		get: function () {
			var incompatibilityWarning = LocalizedString('Tab bar icons have to be PNG images with a maximum size of 60 × 60 pixels.');
			return [
				{
					type: 'group',
					title: this.readableValue,
					id: this.constructor.name,
					items: [
						{ 
							type: 'boolean', 
							name: LocalizedString('Show Screen in Tab Bar'), 
							positionLeft:true,
							offsetX: 20,
							keyPath: 'editedScene.e_showsInTabBar',
							disabled:!this.editedScene.showsTabBar
						},{ 
							type: 'space' 
						},{ 
							name: LocalizedString('Icon'), 
							keyPath: 'e_image', 
							type: 'image', 
							size: 48, 
							fileTypesForImport:['image/png'], 
							incompatibilityWarning: incompatibilityWarning, 
							wantsRetinaImage: true, 
							imageType: 'com.apple.TabBarItemIcon',
							maxImageSize: { 
								width: 60, height: 60
							}
						},{ 
							name: LocalizedString('Icon if not selected'), 
							keyPath: 'e_unselectedImage', 
							type: 'image', 
							size: 48, 
							fileTypesForImport:['image/png'], 
							incompatibilityWarning: incompatibilityWarning, 
							wantsRetinaImage: true, 
							imageType: 'com.apple.TabBarItemIconUnselected',
							maxImageSize: { 
								width: 60, height: 60
							}
						},{ 
							type: 'info', 
							html:'<div style="margin-left:54px;margin-top:-33px;color:#888">'+LocalizedString('Optional')+'</div>', 
							height:-10
						},{ 
							name: LocalizedString('Title'), 
							keyPath: 'e_title', 
							type: 'text', 
							placeholder: LocalizedString('use Screen Title')
						},
					]
				}
			];
		}});
	
	
UITabBarItem.prototype.transformData = function UITabBarItem_transformData(data, transformer) {
		
		if (transformer.isXIBGenerator) {
			console.warn('Missing implementation');
			return null;
		}
		
		var result = {
			$type: this.constructor.name,
			$domain: 'com.apple',
			$id: data.$id,
		};
		
		var title = transformer.transformString(data.title);
		
		if (transformer.context.imageReferenceIsValid(data.image) && transformer.context.imageReferenceIsValid(data.unselectedImage)) {
			result.$initializer = {
				name: 'initWithTitle:unselectedImage:selectedImage:',
				arguments: [title, transformer.transformReferencedImage(data.unselectedImage), transformer.transformReferencedImage(data.image)]
			};
		}		
		else if (transformer.context.imageReferenceIsValid(data.image) && !transformer.context.imageReferenceIsValid(data.unselectedImage)) {
			result.$initializer = {
				name: 'initWithTitle:image:tag:',
				arguments: [title, transformer.transformReferencedImage(data.image), 0]
			};
		}		
		else if (!transformer.context.imageReferenceIsValid(data.image) && transformer.context.imageReferenceIsValid(data.unselectedImage)) {
			result.$initializer = {
				name: 'initWithTitle:image:tag:',
				arguments: [title, transformer.transformReferencedImage(data.unselectedImage), 0]
			};
		}
		else  {
			result.title = title;
		}

		return result;
	};
	

UITabBarItem.prototype.fileReferenceDidUpdate = function UITabBarItem_fileReferenceDidUpdate(ref) {
		if (!this.image && !this.unselectedImage) return;
		['image','unselectedImage'].every(function (key) {
			if (!this[key]) return true;
			if (this[key] && this[key].fileReferenceID === ref.$id) {
				this[key].imageID = ref.resourceID;
			}return true; }, this);
		
		this.view.loadIcon();};
	

	Object.defineProperty(UITabBarItem.prototype, "font", {
		get: function () {
			return this.context.project.tabBarItemFont;
		}, 
		set: function (v) {
			this.context.project.tabBarItemFont = v;
		}});
	
	
	Object.defineProperty(UITabBarItem.prototype, "usesCustomFont", {
		get: function () {
			return this.context.project.usesCustomTabBarItemFont;
		}, 
		set: function (v) {
			this.context.project.usesCustomTabBarItemFont = v;
		}});
	
	
	Object.defineProperty(UITabBarItem.prototype, "fontName", {
		set: function (v) { this.font.fontName = v; }, 
		get: function ( ) { return this.font.fontName; }});
	
	Object.defineProperty(UITabBarItem.prototype, "fontFamily", {
		set: function (v) { this.font.fontFamily = v; }, 
		get: function ( ) { return this.font.fontFamily; }});
	
	Object.defineProperty(UITabBarItem.prototype, "fontSize", {
		set: function (v) { this.font.pointSize = v; }, 
		get: function ( ) { return this.font.pointSize; }});
	

	

UITabBarItem.prototype.initPropertiesFromData = function UITabBarItem_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("title")) this.title = data.title;
if (data.hasOwnProperty("image")) this.image = data.image;
if (data.hasOwnProperty("unselectedImage")) this.unselectedImage = data.unselectedImage;
if (data.hasOwnProperty("view")) this.view = data.view;
};

UITabBarItem.prototype.decodeData = function UITabBarItem_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("image")) decoded.image = this.context.decodeObjectTree(data.image);
if (data.hasOwnProperty("unselectedImage")) decoded.unselectedImage = this.context.decodeObjectTree(data.unselectedImage);
if (data.hasOwnProperty("view")) decoded.view = this.context.decodeObjectTree(data.view);
return decoded; };

UITabBarItem.prototype.encode = function UITabBarItem_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._image && this._image.encode) {encoded.image = this.image.encode();
}if (this._unselectedImage && this._unselectedImage.encode) {encoded.unselectedImage = this.unselectedImage.encode();
}return encoded; };

UITabBarItem.prototype.encodeCloned = function UITabBarItem_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._image && this._image.encode) {encoded.image = this.image.encodeCloned();
}if (this._unselectedImage && this._unselectedImage.encode) {encoded.unselectedImage = this.unselectedImage.encodeCloned();
}return encoded; };

UITabBarItem.prototype.expectedTypeForProperty = function UITabBarItem_expectedTypeForProperty(key) {
	if (key === "title") return "String";
	if (key === "image") return "ImageReference";
	if (key === "unselectedImage") return "ImageReference";
	if (key === "hasUnselectedImage") return "";
	if (key === "e_title") return "String";
	if (key === "e_image") return "ImageReference";
	if (key === "e_unselectedImage") return "ImageReference";
	if (key === "readableValue") return "";
	if (key === "outlineIconURL") return "";
	if (key === "editedScene") return "";
	if (key === "view") return "UITabBarItemView";
	if (key === "inspectorProperties") return "";
	if (key === "font") return "UIFont";
	if (key === "usesCustomFont") return "Boolean";
	if (key === "fontName") return "String";
	if (key === "fontFamily") return "String";
	if (key === "fontSize") return "Number";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UITabBarItem; }()));
registerType('appdoo.iOS', (function () { function UITabBarItemView() {} var __super = setSupertypeFromDomain(UITabBarItemView, 'UIView', 'appdoo.iOS');

	Object.defineProperty(UITabBarItemView.prototype, "title", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_title")) Object.defineProperty(this, "_title", { writable: true, configurable: true });
			this._title = v;
			if (this.v_label) this.v_label.text = v;
		}, get:function () { return this._title; }});
	

	Object.defineProperty(UITabBarItemView.prototype, "image", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_image")) Object.defineProperty(this, "_image", { writable: true, configurable: true });
			if (this._image === v) return;
			this._image = v;
			this.loadIcon();
		}, get:function () { return this._image; }});
	
	
UITabBarItemView.prototype.updateImage = function UITabBarItemView_updateImage() {
		if (!this.originalItem) return;
		if (this.selected || this.context.simulatedSystemVersion < 7)
			this.image = this.originalItem.image;
		else
			this.image = this.originalItem.hasUnselectedImage ? this.originalItem.unselectedImage : this.originalItem.image;};
	

	Object.defineProperty(UITabBarItemView.prototype, "v_type", {
		get: function () { return 'default'; }});
	

	Object.defineProperty(UITabBarItemView.prototype, "v_selected", {
	synthesized: true, get:function () { return this._v_selected; }, set:function (v) {if (!Object.hasOwnProperty(this, "_v_selected")) Object.defineProperty(this, "_v_selected", { writable: true, configurable: true }); this._v_selected = v; }});
	

	Object.defineProperty(UITabBarItemView.prototype, "index", {
		get: function () {
			if (this.superview)
				return this.superview.subviews.indexOf(this);
		}});
	

	Object.defineProperty(UITabBarItemView.prototype, "v_label", {
	synthesized: true, get:function () { return this._v_label; }, set:function (v) {if (!Object.hasOwnProperty(this, "_v_label")) Object.defineProperty(this, "_v_label", { writable: true, configurable: true }); this._v_label = v; }});
	

	Object.defineProperty(UITabBarItemView.prototype, "originalItem", {
	outlet: true, get:function () { return this._originalItem; }, set:function (v) {if (!Object.hasOwnProperty(this, "_originalItem")) Object.defineProperty(this, "_originalItem", { writable: true, configurable: true }); this._originalItem = v; }});
	


	var gradientColors = ["rgb(155,155,155)", "rgb(75,75,75)"],
		selectedTabBackgroundColor = 'rgba(255,255,255,.15)';

	

UITabBarItemView.prototype.init = function UITabBarItemView_init() {
		__super.prototype.init.call(this);
	
		this.highResolutionEnabled = true;
		
		this.size = {
			width: 100,
			height: 44
		};
		var width = this.size.width;
	
		this.loadIcon();

		
		this.v_label = createComponentFromDomain("Label", "Core.UI", this.context, {
			text: this.title,
			size: { width: width, height: 13 },
			autoresizingMask: 2,
			numberOfLines: 1})
		;

		this.styleDefault();

		this.addSubview(this.v_label);

		this.DOMNode.onmousedown = this.onMouseDown.bind(this);

		return this;
};
	
	
UITabBarItemView.prototype.styleDefault = function UITabBarItemView__styleDefault() {
		this.styleDefaultSystem7();};
	
	
UITabBarItemView.prototype.styleSelected = function UITabBarItemView__styleSelected() {
		this.styleSelectedSystem7();};
	
	
	

UITabBarItemView.prototype.styleDefaultSystem7 = function UITabBarItemView__styleDefaultSystem7() {
		this.updateImage();
		this.renderIcon();

		var width = this.size.width;
		var isIPhone = this.context.simulatedDeviceIsIPhone
		var font = (this.originalItem && this.originalItem.usesCustomFont) ? this.originalItem.font : null,
			fontSize = font ? font.pointSize : (isIPhone ? 10 : 14),
			fontFamily = font ? realIOSFont(font.fontName) : '';

		this.style({
				position: '',
				display: 'inline-block',
				width: width + 'px',
				marginLeft: '1px',
				marginRight: '1px',
				borderRadius: '3px',
				color: this.normalTint,
				marginTop: '3px',
				textAlign: 'center'
			});
		
		var marginTop = isIPhone ? -6 : -5;
		
		this.v_label.style({
				fontSize: fontSize+'px',
				fontWeight: '',
				textAlign: 'center',
				marginTop: marginTop+'px',
				position: '',
				pointerEvents: 'none',
				fontFamily: fontFamily
			});

	};
	
	
UITabBarItemView.prototype.styleSelectedSystem7 = function UITabBarItemView__styleSelectedSystem7() {
		this.updateImage();
		this.renderIcon();
		this.style({ color: this.selectionTint,
					 backgroundColor: ''
					});};
	


	

UITabBarItemView.prototype.styleDefaultSystem6 = function UITabBarItemView__styleDefaultSystem6() {
		this.updateImage();
		this.renderIcon();

		var width = this.size.width;

		this.style({
				position: '',
				display: 'inline-block',
				width: width + 'px',
				marginLeft: '1px',
				marginRight: '1px',
				borderRadius: '3px',
				color: 'rgba(255,255,255,.58)',
				marginTop: '3px',
				textAlign: 'center',
				backgroundColor: ''
			});
		
		this.v_label.style({
				fontSize: '10px',
				fontWeight: 'bold',
				textAlign: 'center',
				marginTop: '-7px',
				position: '',
				pointerEvents: 'none'
			});
};
	
	
UITabBarItemView.prototype.styleSelectedSystem6 = function UITabBarItemView__styleSelectedSystem6() {
		this.renderIcon();
		this.style({ color: '#fff',
					 backgroundColor: selectedTabBackgroundColor
					});};
	

		
UITabBarItemView.prototype.onMouseDown = function UITabBarItemView__onMouseDown(e) {
		this.superview.updateSelectedIndexFromMouseEvent(this.superview.subviews.indexOf(this));
			};
	


	
	
UITabBarItemView.prototype.loadIcon = function UITabBarItemView__loadIcon() {
	
		if (this.highResolutionEnabled === undefined) return;
	
		var imageID = this.image ? this.image.imageID : '';
		
		
		if (this.didLoadIcon === imageID) return;
		this.didLoadIcon = imageID;

		if (this.iconNode) {
			var ctx = this.iconNode.getContext('2d');
			ctx.fillRect(0,0,30,30);
			this.iconNode.parentNode.removeChild(this.iconNode);
			this.iconNode = null;
		}
	
		
		var icon = document.createElement("canvas");
		icon.width = canvasWidth;
		icon.height = canvasHeight;

		var isIPhone = this.context.simulatedDeviceIsIPhone;
		var marginTop = isIPhone ? -1 : +2;

		icon.style.pointerEvents = 'none';

		if (isRetina) {
			icon.style.width = canvasWidth/2+'px';
			icon.style.height = canvasHeight/2+'px';
			marginTop += 1;
			if (isIPhone) icon.style.marginBottom = '2px';
		}

		icon.style.marginTop = marginTop+'px';

		Object.defineProperty(this, "iconNode", {
		writable: true, 
			value: icon});
		

		if (this.DOMNode.childNodes.length === 0)
			this.DOMNode.appendChild(icon);
		else
			this.DOMNode.insertBefore(icon, this.DOMNode.firstChild);

		if (this.image) {
			var id = this.image.imageID;
			this.context.whenImageIsReady(this.context.pathForImageWithID(id),
				function (img) {
					
					if (!this.image || this.image.imageID !== id) return; 

					var maskCanvas = document.createElement('canvas');
					maskCanvas.width = iconWidth;
					maskCanvas.height = iconHeight;
					
					var ctx = maskCanvas.getContext('2d');
					
					ctx.drawImage(img, Math.floor(iconWidth/2 - img.width/2), Math.floor(iconHeight/2 - img.height/2));

					this.iconNode.maskCanvas = maskCanvas;
					this.renderIcon();
				}.bind(this));
		}
};
	

UITabBarItemView.prototype.renderIcon = function UITabBarItemView__renderIcon() {
		var isSystem7 = this.context.simulatedSystemVersion >= 7;

		if (!isSystem7) {
			this.renderIconSystem6();
		}
		else {
			this.renderIconSystem7();
		}};
	


UITabBarItemView.prototype.renderIconSystem6 = function UITabBarItemView__renderIconSystem6() {



















































































































		};
	
	
UITabBarItemView.prototype.renderIconSystem7 = function UITabBarItemView__renderIconSystem7() {

		if (!this.DOMNode) return;

		var canvas = this.DOMNode.getElementsByTagName('canvas')[0];
		if (!canvas) return;

		var maskCanvas = canvas.maskCanvas;
		if (!maskCanvas) return;

		var selected = this._selected;

		var ctx = canvas.getContext("2d");
		ctx.clearRect(0,0,canvasWidth,canvasHeight);

		var backgroundNormalCanvas = document.createElement('canvas');
		backgroundNormalCanvas.width = iconWidth;
		backgroundNormalCanvas.height = iconHeight;
		var _ctx = backgroundNormalCanvas.getContext('2d');
		_ctx.fillStyle = selected ? this.selectionTint : this.normalTint;
		_ctx.fillRect(0,0,iconWidth,iconHeight);
		ctx.drawImage(toRgbaFromAlphaMask(backgroundNormalCanvas, maskCanvas), 0, 1);};
	


	
	
	var iOS7NormalColor = 'hsl(0,0%,57%)',
		iOS7NormalColorBright = 'hsl(0,0%,62%)';

	Object.defineProperty(UITabBarItemView.prototype, "normalTint", {
		get: function () {
			if (this.superview) {
				if (this.superview.barStyle === 'black') return iOS7NormalColorBright;
			}
			return iOS7NormalColor;
		}});
	

	Object.defineProperty(UITabBarItemView.prototype, "selectionTint", {
		get: function () {
			if (this.superview) return this.superview.e_tintColor;
			return system7DefaultTint;
		}});
	

	Object.defineProperty(UITabBarItemView.prototype, "highResolutionEnabled", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_highResolutionEnabled")) Object.defineProperty(this, "_highResolutionEnabled", { writable: true, configurable: true });
		
			this._highResolutionEnabled = v;

			iconWidth = isRetina ? 40*2 : 40,
			iconHeight = isRetina ? 30*2 : 30,
			canvasWidth = iconWidth,
			canvasHeight = iconHeight+6;
			backgroundNormalCanvas = undefined;
			backgroundSelectedCanvas = undefined;
			selectedOutlineCanvas = undefined;

		}, get:function () { return this._highResolutionEnabled; }});
	

	Object.defineProperty(UITabBarItemView.prototype, "selected", {

		get: function () { return this._selected; }, 

		set: function (value) {
			
			var tab = this.DOMNode;

			this._selected = value;

			if (value) {
				this.styleSelected();
				tab.selected = true;
			}
			else {
				this.styleDefault();
				this.renderIcon();
			}
			
		
		}
});
	
	

	
	
UITabBarItemView.prototype.encode = function UITabBarItemView_encode() {
		var data = __super.prototype.encode.call(this);
		delete data.subviews;
		delete data.style;
		delete data.position;
		delete data.size;
		return data;};
	


	
	
UITabBarItemView.prototype.prepareForEditor = function UITabBarItemView_prepareForEditor(editor) {
	
	
		
		
		var handler = this.DOMNode.onmousedown;
		this.DOMNode.onmousedown = null;
		this.DOMNode.onclick = handler;
		handler = null;
	
	
		

		this.DOMNode.onmousedown = function (e) {
			e.stopPropagation();
		}

		this.DOMNode.draggable = true;
		this.DOMNode.ondragstart = function (e) {
			
			var contentFrameController = editor.contentFrameController,
				contentScale = contentFrameController.contentScale,
				containerView = contentFrameController.containerView,
				contentWrapper = contentFrameController.contentWrapper;

			var containerStyle;
			
			if (this.context.simulatedSystemVersion < 7) {
				containerStyle = {
					backgroundImage: '-webkit-linear-gradient(rgba(255,255,255,.3), rgba(255,255,255,.0))',
					backgroundColor: 'black',
					opacity: .6,
					webkitFontSmoothing: 'antialiased',
					font: '12px "Helvetica Neue"',
					borderRadius: '3px',
					webkitTransformOrigin: '0 0',
					webkitTransform: 'scale('+contentScale+')',
				};
			} else {
				containerStyle = {
					backgroundImage: '',
					backgroundColor: 'white',
					opacity: .5,
					webkitFontSmoothing: 'antialiased',
					font: '12px "Helvetica Neue"',
					borderRadius: '',
					webkitTransformOrigin: '0 0',
					webkitTransform: 'scale('+contentScale+')',
				};
			}
			
			var dragItem = createComponentFromDomain("DragItem", "Core.UI", this.context, {
				sourceView: this,
				position: {
					left: - containerView.getRelativeX(0) + (this.DOMNode.offsetLeft-1) * contentScale,
					top: - containerView.getRelativeY(0)
						+ contentWrapper.size.height - 46 * contentScale
				},
				highResolutionEnabled: this.highResolutionEnabled,
				containerStyle: containerStyle,
				style: {
					marginTop: '0px'
				},
				dataTransferData: {
					'tab-bar-item-index': this.index
				},
				onBegin: function (e) {
					
					
					if (Array.isArray(this.superview.subviews)) this.superview.subviews.every(function (item) {
						item.style({ pointerEvents: 'none' });return true; }, this);
					
				}.bind(this),
				onFinish: function (e) {
					
					
					if (!this.superview) return;

					
					if (Array.isArray(this.superview.subviews)) this.superview.subviews.every(function (item) {
						item.style({ pointerEvents: 'all' });return true; }, this);
					
					var change = {
						type: 'move',
						object: _context.editor.editedScene,
					};
					
					_context.prototypeDevicesBar.publishChange(change);

				}.bind(this)})
			;
			
			dragItem.dragView.subviews[0].autoresizingMask = 2;
			dragItem.dragView.size.width = this.size.width;
				
			dragItem.dragWithEvent(e);

		}.bind(this);


		

		this.DOMNode.ondblclick = function (e) {
		
			var isSystem7 = this.context.simulatedSystemVersion >= 7;

			var textFieldStyle = {
				fontFamily :  '"Helvetica Neue"',
				fontSize   :  '10px',
				textAlign  :  'center',
				fontWeight :  isSystem7?'':'600',
				webkitTransform: isSystem7 ? 'translateY(0.5px) translateX(0)' : ''
			};
			
			var itemView = this,
				item = this.originalItem,
				text = item.title;
				
	
			
			var ftf = createComponentFromDomain('FloatingTextField', 'Core.UI', editor.context, {
				position: {
					left: this.DOMNode.offsetLeft + this.DOMNode.offsetWidth/2,
					top: editor.contentFrameController.containerView.size.height - 15
				},
				text: text,
				style: textFieldStyle,
				delegate: {
					textFieldDidBeginEditing: function (textField) {
						itemView.v_label.hidden = true;
					},
					textFieldDidEndEditing: function (textField) {
					
						if (textField.value !== text) {
							
							itemView.v_label.text = textField.value || ' ';
							_context.editor.editedScene.dataController.setValueForKeyPath(textField.value, 'viewController.tabBarItem.e_title', this);
							_context.editor.refreshInspector();
						}
						
						itemView.v_label.hidden = false;
					}
				}
			});
	
			editor.contentFrameController.containerView.addSubview(ftf);
	
		}.bind(this);
	};
	


	

	var backgroundNormalCanvas,
		backgroundSelectedCanvas,
		selectedOutlineCanvas;

	var isRetina = true,
		iconWidth,
		iconHeight,
		canvasWidth,
		canvasHeight;

	
UITabBarItemView.prototype.superviewDidChangeTintColor = function UITabBarItemView__superviewDidChangeTintColor(color) {
		if (!this.selected) return;
		this.styleSelected();};
	

UITabBarItemView.prototype.initPropertiesFromData = function UITabBarItemView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("title")) this.title = data.title;
if (data.hasOwnProperty("image")) this.image = data.image;
if (data.hasOwnProperty("originalItem")) this.originalItem = data.originalItem;
};

UITabBarItemView.prototype.decodeData = function UITabBarItemView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("image")) decoded.image = this.context.decodeObjectTree(data.image);
return decoded; };

UITabBarItemView.prototype.encodeCloned = function UITabBarItemView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._image && this._image.encode) {encoded.image = this.image.encodeCloned();
}return encoded; };

UITabBarItemView.prototype.expectedTypeForProperty = function UITabBarItemView_expectedTypeForProperty(key) {
	if (key === "title") return "String";
	if (key === "image") return "ImageReference";
	if (key === "v_type") return "";
	if (key === "v_selected") return "";
	if (key === "index") return "";
	if (key === "v_label") return "";
	if (key === "originalItem") return "";
	if (key === "iconNode") return "";
	if (key === "normalTint") return "";
	if (key === "selectionTint") return "";
	if (key === "highResolutionEnabled") return "";
	if (key === "selected") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UITabBarItemView; }()));