
registerType('appdoo.iOS', (function () { function UITableView() {} var __super = setSupertypeFromDomain(UITableView, 'ListView', 'Core.UI');
	
UITableView.prototype.init = function UITableView_init() {
		this.isPreparing = true;
		__super.prototype.init.call(this);
		this.styleDefault();
		this.updateSegue();
		if (this.allowsSelection === undefined) this.allowsSelection = true;
		return this;};
	

UITableView.prototype.superviewDidChangeTintColor = function UITableView__superviewDidChangeTintColor(color) {
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			if (subview.superviewDidChangeTintColor)
				subview.superviewDidChangeTintColor(color);return true; }, this);
		};
	

	Object.defineProperty(UITableView.prototype, "backgroundColor", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_backgroundColor")) Object.defineProperty(this, "_backgroundColor", { writable: true, configurable: true });
			this._backgroundColor = v;
			this.style({ backgroundColor: v||'' });
		}, get:function () { return this._backgroundColor; }});
	

	Object.defineProperty(UITableView.prototype, "nameIsEditable", {
		get: function () {
			return true;
		}});
	

UITableView.prototype.reloadDataLazy = function UITableView__reloadDataLazy() {
		__super.prototype.reloadDataLazy.call(this);
		this.addEditorButtonsToCells(this.subviews);
		if (_context.editor.manipulator)
			_context.editor.manipulator.updateSizeModifierButtons();};
	
	
UITableView.prototype.insertData = function UITableView__insertData() {

		if (this._style === UITableViewStyleGrouped)
			return this.insertGroupedData();
		

		if (this.usesDataSource)
			__super.prototype.insertData.call(this);
		else
			this.insertStaticContent();

		if (Array.isArray(this.subviews)) this.subviews.every(function (cell) {
			this.convertLayoutRelationsInDynamicCell(cell.contentView);
			_context.editor.resolveLayoutInView(cell.contentView);

			if (cell.contentView) {
				cell.contentView.autoresizingMask = 2;
				if (cell.contentView.backgroundColor) {
					cell.backgroundColor = cell.contentView.backgroundColor;
				}
			}return true; }, this);
		

		
		if (this.DOMNode) this.DOMNode.appendChild(this._backgroundCanvas);
		
		this.arrangeSubviews();};
	
	
UITableView.prototype.insertStaticContent = function UITableView__insertStaticContent() {
		
		if (this.listHeaderView)
			this.insertStaticCell(this.listHeaderView);

		var i = 0, max = this.numberOfStaticSections;
		if (Array.isArray(this.staticSections)) this.staticSections.every(function (section) {
			if (++i > max) return false;
			this.insertStaticCell(section.view);return true; }, this);
		

		if (this.listFooterView)
			this.insertStaticCell(this.listFooterView);
		
		
};
	

UITableView.prototype.createRow = function UITableView__createRow() {
		var rowView = createComponentFromDomain(this.rowType.$type, this.rowType.$domain, this.context, {
				size: {
					width: this.size.width,
					height: 44
				},
				autoresizingMask: 2,
			});
		return rowView;};
	
	
UITableView.prototype.insertGroupedData = function UITableView__insertGroupedData() {
	
		var numberOfSections = this._dataSource.numberOfSections();
		
		for (var i = 0; i < numberOfSections; i++) {
		
			var sectionHeader = this._dataSource.titleForHeaderInSection(i);
			var sectionFooter = this._dataSource.titleForFooterInSection(i);
			
			var rowViews = [];
			var numberOfItems = this._dataSource.numberOfItemsInSection(i);
			numberOfItems = Math.min(numberOfItems, 100);
			
			for (var itemIndex = 0; itemIndex < numberOfItems; itemIndex++) {
			

				var rowContentView;
				if (this._dataSource.cellForRowAtIndexPath) {
					rowContentView = this._dataSource.cellForRowAtIndexPath({ item: itemIndex, section: i });
				}

				var rowView = this.createRow();

				rowView.addSubview(rowContentView);

				var b = createThinBorderCanvas();
				rowView.DOMNode.appendChild(b);
				rowView.thinBorderLine = b;

				rowViews.push(rowView);

			}

			var sectionView = this.createSection(sectionHeader, sectionFooter, rowViews);
			

			this.addSubview(sectionView);
		
		}
		
		this.arrangeSubviews();
	};
	
	
	Object.defineProperty(UITableView.prototype, "allCells", {
		get: function () {
			var cells = clone(this.subviews);
			if (this.listHeaderEnabled && cells.indexOf(this.listHeaderView) === -1) cells.unshift(this.listHeaderView);
			if (this.listFooterEnabled && cells.indexOf(this.listFooterView) === -1) cells.push(this.listFooterView);
			return cells;
		}});
	
	
UITableView.prototype.arrangeSubviews = function UITableView__arrangeSubviews() {

		var y = (this.e_insetTop||0);

		if (this._style === UITableViewStyleGrouped) y += 15;

		if (Array.isArray(this.allCells)) this.allCells.every(function (subview) {
			subview.position.top = y;
			if (subview.isSectionView) subview.section.arrangeSubviews();
			y += subview.size.height;return true; }, this);
		
	};
	

UITableView.prototype.createSection = function UITableView__createSection(header, footer, rowViews) {
		var section = createComponentFromDomain("UITableViewSection", "appdoo.iOS", this.context, {
			header: header,
			footer: footer,
			size: { width: this.size.width, height: 200 },
			autoresizingMask: 2,
			rowViews: rowViews})
		;

		return section;};
	

UITableView.prototype.drawBackground = function UITableView__drawBackground() {
	
		this.sizeBackgroundCanvas();

		if (this._style === UITableViewStyleGrouped)	this.drawGroupedStyleBackground();
		else											this.drawPlainStyleBackground();
};
	
	
UITableView.prototype.drawGroupedStyleBackground = function UITableView__drawGroupedStyleBackground() {};
	

UITableView.prototype.drawPlainStyleBackground = function UITableView__drawPlainStyleBackground() {

		var contextInfo = {
			ctx: this._backgroundCanvas.getContext('2d'),
			offsetX: this.e_separatorInsetLeft,
			offsetMaxX: this.e_separatorInsetRight,
			offsetY: -0.5+(this.e_insetTop||0),
			width: this.size.width
		};
		
		var scale = this.context.highResolutionEnabled ? 2 : 1;
		contextInfo.ctx.strokeStyle = this.separatorColor ? this.separatorColor : this.defaultSeparatorColor;
		contextInfo.ctx.lineWidth = 1/scale;
		contextInfo.ctx.save();
		contextInfo.ctx.scale(scale, scale);
		
		this.drawSeparatorLinesForView__context__(this, contextInfo);
		
		
		if (!this.listFooterView) {
			var defaultRowHeight = this.cellPrototypeView ? this.cellPrototypeView.size.height : 44;
			if (isNaN(defaultRowHeight)) defaultRowHeight = 44;
			
			while (contextInfo.offsetY < this.totalHeight) {
	
				contextInfo.ctx.beginPath();
				contextInfo.ctx.moveTo(contextInfo.offsetX, contextInfo.offsetY);
				contextInfo.ctx.lineTo(contextInfo.width-contextInfo.offsetMaxX, contextInfo.offsetY);
				contextInfo.ctx.stroke();
	
					contextInfo.offsetY += defaultRowHeight;
			}
		}
		
		contextInfo.ctx.restore();};
	

UITableView.prototype.drawSeparatorLinesForView__context__ = function UITableView__drawSeparatorLinesForView__context__(view, contextInfo) {
	
		var allCells = view.allCells;
		if (!allCells) return;
		
		for (var cellIndex = 0, cellCount = allCells.length;
			 cellIndex < cellCount;
			 cellIndex++) {

			if (allCells[cellIndex].isSectionView) {
			 	allCells[cellIndex].section.identify();

			 	this.drawSeparatorLinesForView__context__(allCells[cellIndex], contextInfo);
			 	continue;
			}

			
			if (cellIndex !== 0 && allCells[cellIndex-1] !== this.listHeaderView) { 

				contextInfo.ctx.beginPath();
				contextInfo.ctx.moveTo(contextInfo.offsetX, contextInfo.offsetY);
				contextInfo.ctx.lineTo(contextInfo.width-contextInfo.offsetMaxX, contextInfo.offsetY);
				contextInfo.ctx.stroke();
			}
			
			contextInfo.offsetY += allCells[cellIndex].size.height;

		}};
	

	Object.defineProperty(UITableView.prototype, "_style", {
	outlet: true, 
	enumerable: true, get:function () { return this.__style; }, set:function (v) {if (!Object.hasOwnProperty(this, "__style")) Object.defineProperty(this, "__style", { writable: true, configurable: true }); this.__style = v; }});
	

	Object.defineProperty(UITableView.prototype, "defaultBackgroundImage", {
		get: function () {
			if (this._style === UITableViewStyleGrouped)
				return 'url(Resources/TableViewGroupedBackground.png)'
		}});
	

UITableView.prototype.styleDefault = function UITableView_styleDefault() {

		if (this.context.simulatedSystemVersion < 7) {
			this.styleDefaultSystem6();
		} else {
			this.styleDefaultSystem7();
		}
	};
	
	
UITableView.prototype.styleDefaultSystem7 = function UITableView_styleDefaultSystem7() {
		if (this._style === UITableViewStyleGrouped) {
			this.style({ backgroundColor: 'rgb(241,241,246)', });
		}};
	

UITableView.prototype.styleDefaultSystem6 = function UITableView_styleDefaultSystem6() {

		if (this._style === UITableViewStyleGrouped) {
			this.style({
				backgroundImage: this.defaultBackgroundImage,
				backgroundSize: '8px 100%',
				backgroundPosition: '-4px 0'
			});
		}
	};
	

	Object.defineProperty(UITableView.prototype, "sections", {
	synthesized: true, get:function () { return this._sections; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sections")) Object.defineProperty(this, "_sections", { writable: true, configurable: true }); this._sections = v; }});
	

	Object.defineProperty(UITableView.prototype, "selectable", {
		value: false});
	
	
	Object.defineProperty(UITableView.prototype, "usesAlternatingRowBackgroundColors", {
		value: false});
	
	
	Object.defineProperty(UITableView.prototype, "encodesStyles", {
		value: false});
	

UITableView.prototype.encodeCloned = function UITableView_encodeCloned() {
		var data = __super.prototype.encodeCloned.call(this);
		delete data.cellPrototype;
		data.cellPrototype = this.cellPrototypeView.encodeCloned();
		return data;};
	


	

UITableView.prototype.prepareRow = function UITableView__prepareRow(rowView, context, addEventListeners) {

		__super.prototype.prepareRow.call(this, rowView, context, addEventListeners);

		rowView.colorScheme = this._colorScheme;

		if (this.detailSceneID)
			rowView.accessoryType = "disclosureIndicator";
		
		this.prepareCellContentView(rowView.contentView);};
	
	
UITableView.prototype.prepareCellContentView = function UITableView_prepareCellContentView(cell) {
	
		cell.DOMNode.addEventListener('mousedown', function (e) {
			if (_context.editor.isActionClick(e))
				this.selectRow(cell.superview);
		}.bind(this));

		if (this.detailSceneID||cell.detailSceneID)
			cell.DOMNode.className = 'canClickInActionMode';
};
	

UITableView.prototype.selectRow = function UITableView_selectRow(row) {
	
		var cell = row.contentView;

		if (this.detailSceneID||cell.detailSceneID) {
			var indexPath = cell.indexPath;
			var itemsView = this;
			var inputData = itemsView.usesDataSource ? itemsView.dataSource.dataForIndexPath(indexPath) : null;
			var detailSceneID = cell.detailSceneID || itemsView.detailSceneID;
			
			_context.editor.navigateToSceneWithID(detailSceneID, inputData, itemsView.dataSource, indexPath);
		}};
	


	

	Object.defineProperty(UITableView.prototype, "defaultCellPrototype", {
		get: function () {
			return this.createDefaultCellPrototypeForContextWithSize(this.context, this.size);
		}});
	
	
	Object.defineProperty(UITableView.prototype, "staticCellPrototype", {
		get: function () {
			return this.createDefaultCellPrototypeForContextWithSize(this.context, this.size, true);
		}});
	
	
UITableView.prototype.createDefaultCellPrototypeForContextWithSize = function UITableView__createDefaultCellPrototypeForContextWithSize(context, size, noLabel) {

		var cellData = {
			$type: "TableViewCellContentView",
			$domain: "appdoo.iOS",
			size: { width: size.width, height: 44 },
			isExpandedInEditorOutline: true,
			subviews: [],
			style: {
				backgroundColor: "rgba(255,255,255,0)"
			},
		};
		
		if (!noLabel)
			cellData.subviews.push({
				$type: "UILabel",
				$domain: "appdoo.iOS",
				autoresizingMask: 2,
				text: "",
				size: {
					width: size.width-30,
					height: 25
				},
				position: {
					"left": 15,
					"top": 10
				},
				fontFamily: "System",
				fontName: "_DEFAULT_BOLD_",
				fontSize: 17
			});

		return cellData;	};
	

	Object.defineProperty(UITableView.prototype, "defaultSectionHeaderTemplate", {
		value: {
			$type: "View",
			$domain: "Core.UI",
			style: {
				backgroundImage: '-webkit-linear-gradient(rgb(160,176,186) 0%, rgb(139,160,171) 7%, rgb(181,192,200) 100%)',
				borderTop: '1px solid rgb(109,125,134)',
				borderBottom: '1px solid rgb(150,158,165)',
				height: '21px'
			},
			size: {
				width: 320,
				height: 23
			},
			subviews: [{
				$type: "Label",
				$domain: "Core.UI",
				style: {
					fontSize: '18px',
					fontWeight: 'bold',
					color: '#fff',
					textShadow: '0 1px 0 rgba(0,0,0,.4)',
				},
				position: { left: 11, top: -1 }
			}]
		}});
	

	Object.defineProperty(UITableView.prototype, "rowType", {
		value: { $type: 'UITableViewCell', $domain: "appdoo.iOS" }});
	
	
	
	

	var reuseIdentifierCtr = 1;
UITableView.prototype.tableView_transformDataForXIB = function UITableView_tableView_transformDataForXIB(data, transformer) {
	
		var parentViewController = transformer.currentViewController;
		var parentOriginalViewController = transformer.currentViewControllerData;
		var parentOriginalScene = transformer.currentOriginalScene;

		if (!data.usesDataSource) {
			var tableViewControllerID = transformer.createStoryboardID();
			var tableViewController = {
					id: tableViewControllerID,
					sceneMemberID: 'viewController',
					tableView: result,
				};
			var originalVCData = { viewData: data, title:'Embedded', $id:data.$id+'Controller', $type: 'UITableViewController' };
			var sourceSceneData = { $id: data.$id+'Controller', objects: [], viewController:originalVCData, isEmbedded: true };
			transformer.currentViewControllerStack.push([tableViewController, sourceSceneData]);
			var tvcScene = {
				sceneID: transformer.createStoryboardID(),
				objects: {
					tableViewController: tableViewController,
					placeholder: {
						placeholderIdentifier: "IBFirstResponder",
						id: transformer.createStoryboardID(),
						userLabel: "First Responder",
						sceneMemberID: "firstResponder"
					}
				}
			};
			Object.defineProperty(tvcScene, 'viewController', {
				enumerable: false,
				value: tableViewController
			});
			transformer.currentOriginalSceneStack.push(sourceSceneData);
			
			var codeID = transformer.productGenerator.registerViewController(originalVCData, sourceSceneData);
			tableViewController.customClass = codeID;

			transformer.productGenerator.parentViewControllerClassForEmbeddedScene[sourceSceneData.$id] = parentViewController.customClass;
			transformer.productGenerator.parentViewControllerCIDForEmbeddedScene[sourceSceneData.$id] = parentOriginalScene.viewController.$id;

			if (!transformer.productGenerator.embeddedViewControllersInViewControllerCID[parentOriginalViewController.$id])
				 transformer.productGenerator.embeddedViewControllersInViewControllerCID[parentOriginalViewController.$id] = [];
			transformer.productGenerator.embeddedViewControllersInViewControllerCID[parentOriginalViewController.$id].push(codeID);
			transformer.objectIDs[sourceSceneData.$id] = tableViewController.id;

		}

		var result = transformer.transformView(data, true);

		if (this.cocoaCustomType)
			result.customClass = this.cocoaCustomType;

		result.connections = {};

		if (data.allowsSelection === false)
			result.allowsSelection = 'NO';
		
		
		
		
		result.clipsSubviews = 'YES';
		result.style = 'plain';
		result.rowHeight = data.cellPrototype.frame ? data.cellPrototype.frame.size.height : data.cellPrototype.size.height;

		if (!data.usesDataSource) {
			result.rowHeight = -1;
			var sectionCtr = 0;
			var staticCellHeights = "";
			
			
			
			if (Array.isArray(data.staticSections)) data.staticSections.every(function (sectionData) {
				sectionCtr++; if (sectionCtr > data.numberOfStaticSections) return false;
				var cellCtr = 0;
				if (Array.isArray(sectionData.staticCells)) sectionData.staticCells.every(function (cellViewData) {
					cellCtr++; if (cellCtr > sectionData.numberOfStaticCells) return false;
					var staticCellHeight = cellViewData.frame.size.height;
					staticCellHeights = staticCellHeights+","+cellViewData.frame.size.height;return true; }, this);
				return true; }, this);
			
			if(staticCellHeights.length > 0) {
				staticCellHeights = staticCellHeights.slice(1);
				transformer.object__addUserDefinedRuntimeAttribute__(result, {
					type: 'string',
					keyPath: 'staticCellHeights',
					value: staticCellHeights
				});
			}
		}
		result.sectionHeaderHeight = "22";
		result.sectionFooterHeight = "22";
		if (data.separatorColor)
			result['color separatorColor'] = transformer.transformCSSColor(data.separatorColor, 'separatorColor');
		
		if (!data.usesDefaultSeparatorInsets) {
			result.inset = { key: 'separatorInset', minX: data.separatorInsetLeft||0, minY: 0, maxX: data.separatorInsetRight||0, maxY: 0 };
		}

		if (!result.userDefinedRuntimeAttributes)
			result.userDefinedRuntimeAttributes = {};

		if (data.pullToRefresh) {
			
			transformer.demandPluginWithIdentifier('info.appdoo-mac.UITableViewPullToRefresh');
		
			result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute canPullToRefresh'] = {
				type: "boolean",
				keyPath: "canPullToRefresh",
				value: true
			};
		}

		
		
		
		if (data.usesDataSource && data.dataSourceId) {

			transformer.object__addOutlet__from__to__(result, 'dataSource', data.$id, data.dataSourceId);
			
		}
		
		
		
		
		transformer.isTransformingTableViewCell = true;
		if (data.usesDataSource) {
			this.transformPrototypeCells(data, result, transformer);
		}
		else {
			this.transformStaticContent(data, result, transformer);
		}
		transformer.isTransformingTableViewCell = false;


		
		
		if (data.listHeaderView !== undefined) {
			var listHeaderView = transformer.transformView(data.listHeaderView);
			listHeaderView.key = 'tableHeaderView';
			listHeaderView.clipsSubviews = 'YES';
			result['view tableHeaderView'] = listHeaderView;
		}

		if (data.listFooterView !== undefined) {
			var listFooterView = transformer.transformView(data.listFooterView);
			listFooterView.key = 'tableFooterView';
			listFooterView.clipsSubviews = 'YES';
			result['view tableFooterView'] = listFooterView;
		}
		
		
		
		if (data.insetTop || data.insetBottom) {
			result.inset = { key:"contentInset", minX:0, minY:data.insetTop||0, maxX:0, maxY:data.insetBottom||0 };
		}
		
		

		transformer.demandPlugin('info.appdoo-mac.CPSUITableView');
		
		
		
		if (data.bindings && data.bindings.length) {
		
			
			
			data.bindings.filter(function (el) { return el.treatAsReverseBinding == true; }).forEach(function (el) {
				data.bindings.splice(data.bindings.indexOf(el), 1);
			});
			if (this.bindingForKey.call(data, 'selectedItemIndex')) {
				var res = {};
				transformer.registerInverseBinding(result, data, 'selectedItemIndex', '', data.$id, res);
				if (res._bindings) { data.bindings.push(res._bindings[0]); }
			}
		}

		if (data.usesDataSource)
			return result;
		
		
		
		

		result.key = 'view';
		result.connections = {
			'outlet dataSource': { property: 'dataSource', destination: tableViewControllerID, id: transformer.createStoryboardID() },
			'outlet delegate': { property: 'delegate', destination: tableViewControllerID, id: transformer.createStoryboardID() },
		};
		result.opaque = 'NO';
		tableViewController.tableView = result;

		transformer.registerClassWithoutHeader(parentViewController.customClass);
		transformer.productGenerator.addIncludeHeaderForThingWithOriginalID(parentViewController.customClass+'.h', originalVCData.$id+'Implementation');
		transformer.addAllObjectsToStoryboardScene(tvcScene, sourceSceneData);
		transformer.currentViewControllerStack.pop();
		transformer.currentOriginalSceneStack.pop();
		transformer.registerClassWithoutHeader(codeID);

		var key = transformer.currentOriginalScene.viewController.$id+'Implementation';
		transformer.productGenerator.addIncludeHeaderForThingWithOriginalID(codeID+'.h', key);

		transformer.currentResult.document.scenes['scene '+tvcScene.sceneID] = tvcScene;
		
		var containerView = {
			$tagName: 'containerView',
			contentMode: "scaleToFill",
			id: transformer.createStoryboardID(),
			rect: result.rect,
			autoresizingMask: result.autoresizingMask,
			'color backgroundColor': result['color backgroundColor'],
			connections: {
				segue: { destination: tableViewControllerID, kind: 'embed', id: transformer.createStoryboardID(), }
			}
		};
		
		return containerView;
	};
	
	
UITableView.prototype.transformPrototypeCells = function UITableView__transformPrototypeCells(data, result, transformer) {

		var cellClass = transformer.context.createUID('Cell');

		var tableViewCell = {
			accessoryType: data.detailSceneID ? 'disclosureIndicator' : '',
			contentMode: 'scaleToFill',
			clipsSubviews: 'YES',
			id: transformer.createStoryboardID(),
			reuseIdentifier: 'Cell',
			customClass: cellClass,
			connections: {}
		};

		transformer.willTransformCellWithIdentifier(tableViewCell, cellClass, data, data.cellPrototype);

		
		
		transformer.productGenerator.addIncludeHeaderForThing(transformer.currentViewControllerClassId+'.h', data.cellPrototype);
		transformer.addOutletForDataAndId(transformer.currentViewControllerData, transformer.storyboardIDForObjectID(transformer.currentViewControllerId), 'viewController', transformer.currentViewControllerClassId);

		var cellView = getPrototype(utiFromData(data.cellPrototype)).transformData(data.cellPrototype, transformer);

		transformer.didTransformCell();
		
		if (!cellView) return result;

		tableViewCell['color backgroundColor'] = cellView['color backgroundColor'];
		delete cellView['color backgroundColor'];
		
		cellView.key = 'contentView';
		cellView.tagName = undefined;
		
		
		cellView.id = undefined;
		
		tableViewCell.view = cellView;
		tableViewCell.rect = clone(cellView.rect);
		tableViewCell.rect.width = result.rect.width;
		
		result.dataMode = 'prototypes';
		result.prototypes = { tableViewCell: tableViewCell };
		
		
		
		if (data.detailSceneID) {
		
			var detailScene = _context.projectContext.sceneWithID(data.detailSceneID);
			if (detailScene) {
				var destinationID = transformer.storyboardIDForComposeObject(detailScene.viewController);
				var modalTransitionStyle = transformer.transformModalTransitionStyle(data.modalTransitionStyle);
				var segueKind = modalTransitionStyle ? 'modal' : 'push';
				
				tableViewCell.connections['segue'] = {
					destination: destinationID,
					kind: segueKind,
					modalTransitionStyle: modalTransitionStyle,
					id: transformer.createStoryboardID()
				};
			}
		
		}
	};
	
	
UITableView.prototype.transformStaticContent = function UITableView__transformStaticContent(data, result, transformer) {

		result.dataMode = "static";
		result.sections = {};
		
		var sectionCtr = 0;
		if (Array.isArray(data.staticSections)) data.staticSections.every(function (sectionData) {
			sectionCtr++; if (sectionCtr > data.numberOfStaticSections) return false;

			var section = {
				id: transformer.createStoryboardID(),
				cells: {}
			};
			
			var cellCtr = 0;
			if (Array.isArray(sectionData.staticCells)) sectionData.staticCells.every(function (cellViewData) {
				cellCtr++; if (cellCtr > sectionData.numberOfStaticCells) return false;

				var cellID = transformer.createStoryboardID();

				transformer.willTransformCellWithIdentifier(cellViewData, null, {}, null);
				transformer.currentCellIsStatic = true;
				var cellView = transformer.transformView(cellViewData);
				transformer.didTransformCell();
				delete transformer.currentCellIsStatic;
				cellView.key = 'contentView';

				var cell = {
					id: cellID,
					contentMode: 'scaleToFill',
					selectionStyle: 'blue',
					rowHeight: cellViewData.frame.size.height,
					rect: { key: 'frame', x: 0, y: 0, width: cellViewData.frame.size.width, height: cellViewData.frame.size.height },
					tableViewCellContentView: cellView,
					opaque: 'NO',
				};

				cell['color backgroundColor'] = transformer.transformCSSColor('rgba(255,255,255,0)', 'backgroundColor');
				
				if (cellViewData.navigatesToDetailScene) {
					cell.accessoryType = "disclosureIndicator";
					var detailScene = _context.projectContext.sceneWithID(cellViewData.detailSceneID);
					if (detailScene) {
						var destinationID = transformer.storyboardIDForComposeObject(detailScene.viewController);
						cell.connections = {};
						cell.connections['segue'] = {
							destination: destinationID,
							kind: 'push',
							id: transformer.createStoryboardID()
						};
					}
				} else {
					cell.selectionStyle = 'none';
				}

				section.cells['tableViewCell '+padDigits(cellCtr, 3)] = cell;return true; }, this);
			
			
			result.sections['tableViewSection '+padDigits(sectionCtr, 3)] = section;return true; }, this);
		
		
		
};
	

	function padDigits(number, digits) {
		return Array(Math.max(digits - String(number).length + 1, 0)).join(0) + number;
	}


	
	
	function cellAtPoint(obj, editor, x, y) {

		var cell,
			contentWrapper = editor.contentFrameController.contentWrapper,
			contentFrame = editor.contentFrameController.view,
			contentScale = editor.contentFrameController.contentScale,
			innerOffsetY = obj.getRelativeY((y - contentWrapper.position.top + contentFrame.DOMNode.scrollTop) / contentScale, contentWrapper);

		if (Array.isArray(obj.subviews)) obj.subviews.every(function (subview) {

			if (innerOffsetY > (subview.position.top * 1) &&
				innerOffsetY <= ((subview.position.top + subview.size.height)
								* 1)) {
				cell = subview;
				return false;
			}return true; }, this);
		
		
		return cell;
	}
	
	
UITableView.prototype.createForSuperview = function UITableView_createForSuperview(superview) {
	
		var makeFullSize = (superview.subviews.length === 0);
	
		var size = makeFullSize ? superview.sizeCopy :
			{ width: Math.min(320, superview.size.width), height: 160 };
			
		var tableView = superview.context.decodeObjectTree({
				$type: this.constructor.name,
				$domain: this.__domain,
				size: size,
				position: { left: 0, top: 0 },
				autoresizingMask: makeFullSize ? 18 : 36,
				backgroundColor: 'rgb(255,255,255)',
				colorScheme: 'default',
				isExpandedInEditorOutline: true,
				separatorInsetLeft: 15,
				cellPrototype: this.createDefaultCellPrototypeForContextWithSize(superview.context, size),
				usesDataSource: false,
				usesDefaultSeparatorInsets: true,
				insetTop: makeFullSize ? _context.editor.contentFrameController.defaultTopScrollInset : 0,
				insetBottom: makeFullSize ? _context.editor.contentFrameController.defaultBottomScrollInset : 0,
			});
		
		tableView.e_numberOfStaticSections = 1;
		var firstCell = tableView.staticSections[0].staticCells[0];
		var label = getPrototype('appdoo.iOS.UILabel').createForSuperview(firstCell);
		label.position = { left: 15, top: 11 };
		label.size.width = 290;
		label.text = LocalizedString("Row");
		label.fontName = '_DEFAULT_BOLD_';
		firstCell.addSubview(label);
		return tableView;
	};
	
	
UITableView.prototype.deleteForEditor = function UITableView_deleteForEditor(editor) {
	
		if (editor) {
			var snb = editor.contentFrameController.navigationBar;
			if (snb) {
				snb.dropsShadow = true;
			}
		}
		
		if (this.cellPrototype)
			if (Array.isArray(this.cellPrototype.subviews)) this.cellPrototype.subviews.every(function (subview) {
				if (subview.deleteForEditor)
					subview.deleteForEditor(editor);return true; }, this);
			

		if (this.listHeaderView)
			if (Array.isArray(this.listHeaderView.subviews)) this.listHeaderView.subviews.every(function (subview) {
				if (subview.deleteForEditor)
					subview.deleteForEditor(editor);return true; }, this);
			

		if (this.listFooterView)
			if (Array.isArray(this.listFooterView.subviews)) this.listFooterView.subviews.every(function (subview) {
				if (subview.deleteForEditor)
					subview.deleteForEditor(editor);return true; }, this);
			
		
		};
	
	
UITableView.prototype.undoChange = function UITableView_undoChange(change, undoManager) {
	
		if (change.type === 'removeDetailViewController') {
			return this.undoRemoveDetailViewController(change, undoManager);
		}
		
		return __super.prototype.undoChange.call(this, change, undoManager);
		};
	
	
UITableView.prototype.readableUndoName = function UITableView_readableUndoName(change) {
	
		if (change.type === 'removeDetailViewController')
			return LocalizedString('Remove Detail Screen');
		
		return __super.prototype.readableUndoName.call(this, change);
};
	
	
UITableView.prototype.undoRemoveDetailViewController = function UITableView__undoRemoveDetailViewController(change, undoManager) {
	
		if (change.redo === true) {
			this.hasDetailViewController = false;
			return true;
		}
		
		this.detailSceneID = change.viewControllerID;
		this.reloadData();
		
		undoManager.registerChange(this, {
    		type: 'removeDetailViewController',
    		redo: true
    	});
    	
    	return true;
};
	
	

	Object.defineProperty(UITableView.prototype, "modalTransitionStyle", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			return '-1';
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_modalTransitionStyle")) Object.defineProperty(this, "_modalTransitionStyle", { writable: true, configurable: true }); this._modalTransitionStyle = v; }});
	

	Object.defineProperty(UITableView.prototype, "inspectorProperties", {
		get: function () {
			return [
				  {
					type: 'group',
					title: LocalizedString('List View'),
					id: 'UITableViewAppearance',
					items: [
						{ name: this.readableNameForProperty('name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: LocalizedString('Rows'), keyPath: 'staticSections.0.e_numberOfStaticCells', type: 'number', onlyPositive: true, disabled: this.e_usesDataSource },

						{  name: LocalizedString('Use Data Source'), keyPath: 'e_usesDataSource', type: 'boolean', positionLeft: true },

						{ name: '', keyPath: 'e_dataSourceID', type: 'object', labelOnTop: true, objectType:'dataSource', placeholder:LocalizedString('There are no data sources available in this screen.'), numberOfVisibleItems:3.5, hidden: !this.e_usesDataSource, showsSelectButton:true },
						
						{ type: 'button', caption: LocalizedString('New Data Source'), actionKeyPath: 'showNewDataSourcePanel', buttonWidth: 105, align: 'left', hidden: !this.e_usesDataSource, buttonStyle: 'flat', marginTop: -3, positionLeft:true },

						{ name: LocalizedString("Use a Navigation Target"), type: "boolean", keyPath: "e_navigatesToDetailScene", "positionLeft": true, hidden: !this.e_usesDataSource },

						{ name: '', keyPath: 'e_detailSceneID', type: 'scene', labelOnTop: true, allowsEmptySelection:false, numberOfVisibleItems:1, hidden: !this.e_usesDataSource||!this.e_navigatesToDetailScene },

						{ type: 'space' },

						{ name: LocalizedString('Pull To Refresh'), keyPath: 'e_pullToRefresh', type: 'boolean', positionLeft: true, hidden: !this.e_usesDataSource },
						
						
						{ type: 'space', hidden: !this.e_usesDataSource },

						{ name: LocalizedString('Header Row'), keyPath: 'listHeaderEnabled', type: 'boolean', positionLeft: true },
						{ name: LocalizedString('Footer Row'), keyPath: 'listFooterEnabled', type: 'boolean', positionLeft: true, offsetX:100, moveUp: true },
						{ type: 'space' },

						{ name: LocalizedString('Background Color'), keyPath: 'backgroundColor', type: 'color', undefinedValue: 'rgba(255,255,255, 1)', forceLeftLabel:false },
						{ name: LocalizedString('Separator Color'), keyPath: 'separatorColor', type: 'color', undefinedValue: 'rgba(224,224,224, 1)', forceLeftLabel:false },

						{ type: 'space' },
						{ type: 'boolean', keyPath: 'allowsSelection', positionLeft: true, name: LocalizedString('Allow Selection') },

						{ type: 'space' },

					]
				},
				{
					type: 'group',
					title: LocalizedString('Separator Insets'),
					id: 'UITableViewSeparatorInsets',
					items: [
						{ name: LocalizedString('Default'), keyPath: 'e_usesDefaultSeparatorInsets', type: 'boolean', positionLeft: false, offsetY: 0 },
						{ type: 'space' },
						{ name: LocalizedString('Left'), keyPath: 'e_separatorInsetLeft', type: 'number', disabled: this.usesDefaultSeparatorInsets },
						{ name: LocalizedString('Right'), keyPath: 'e_separatorInsetRight', type: 'number', disabled: this.usesDefaultSeparatorInsets },
					]
				},
				  this.scrollViewInsetsInspectorProperties,
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
						{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				},
			];
		}});
	


	Object.defineProperty(UITableView.prototype, "allowsSelection", {
	outlet: true, 
	enumerable: true, get:function () { return this._allowsSelection; }, set:function (v) {if (!Object.hasOwnProperty(this, "_allowsSelection")) Object.defineProperty(this, "_allowsSelection", { writable: true, configurable: true }); this._allowsSelection = v; }});
	

	Object.defineProperty(UITableView.prototype, "separatorInsetLeft", {
	outlet: true, 
	enumerable: true, get:function () { return this._separatorInsetLeft; }, set:function (v) {if (!Object.hasOwnProperty(this, "_separatorInsetLeft")) Object.defineProperty(this, "_separatorInsetLeft", { writable: true, configurable: true }); this._separatorInsetLeft = v; }});
	

	Object.defineProperty(UITableView.prototype, "separatorInsetRight", {
	outlet: true, 
	enumerable: true, get:function () { return this._separatorInsetRight; }, set:function (v) {if (!Object.hasOwnProperty(this, "_separatorInsetRight")) Object.defineProperty(this, "_separatorInsetRight", { writable: true, configurable: true }); this._separatorInsetRight = v; }});
	

	Object.defineProperty(UITableView.prototype, "usesDefaultSeparatorInsets", {
	outlet: true, 
	enumerable: true, get:function () { return this._usesDefaultSeparatorInsets; }, set:function (v) {if (!Object.hasOwnProperty(this, "_usesDefaultSeparatorInsets")) Object.defineProperty(this, "_usesDefaultSeparatorInsets", { writable: true, configurable: true }); this._usesDefaultSeparatorInsets = v; }});
	

	Object.defineProperty(UITableView.prototype, "e_separatorInsetLeft", {
		set: function (v) { this.separatorInsetLeft = v; this.drawBackground(); }, 
		get: function () {
			if (this.usesDefaultSeparatorInsets || this.separatorInsetLeft === undefined) {
				return 15;
			}
			return this.separatorInsetLeft;
		}});
	

	Object.defineProperty(UITableView.prototype, "e_separatorInsetRight", {
		set: function (v) { this.separatorInsetRight = v; this.drawBackground(); }, 
		get: function () { if (this.usesDefaultSeparatorInsets) return 0; return this.separatorInsetRight || 0; }});
	

	Object.defineProperty(UITableView.prototype, "e_usesDefaultSeparatorInsets", {
		set: function (v) { this.usesDefaultSeparatorInsets = v; this.drawBackground(); _context.editor.refreshInspector(); }, 
		get: function ( ) { return this.usesDefaultSeparatorInsets; }});
	

UITableView.prototype.editCellAtIndexPathWithEditor = function UITableView_editCellAtIndexPathWithEditor(indexPath, editor) {
		return this.editRowAtIndexPathWithEditor(indexPath, editor);};
	
	
UITableView.prototype.editRowAtIndexPathWithEditor = function UITableView_editRowAtIndexPathWithEditor(indexPath, editor) {

		var row = this.cellForIndexPath(indexPath);
		if (!row) {
			console.warn('Failed getting cell for index path:', JSON.stringify(indexPath));
			return;
		}
		
		this.editCellWithEditor(row, editor);
	};
	
	
UITableView.prototype.editorWillEditPrototypeCell = function UITableView_editorWillEditPrototypeCell(editor, subview) {

		if (subview == this.cellPrototypeView) {
		
			if (!subview.indexPath) {
				subview.indexPath = { section: 0, item: 0 };
				subview.position.top = this.e_insetTop;
			}

			this.prepareCellWithDataForIndexPath(subview, subview.indexPath, true);

			
			var row = this.rowForIndexPath(subview.indexPath);
			if (row) subview.size.width = row.contentView.size.width;
			
			editor.pushDataContextForDataSourceItem(this.dataSource, subview.indexPath);
		}};
	

UITableView.prototype.editorDidEditPrototypeCell = function UITableView_editorDidEditPrototypeCell(editor, subview) {

		if (subview == this.cellPrototypeView) {

			subview.superview = this;
			
			this.changeCellPrototypeForEditor('cellPrototype', subview.encode(), editor);
			this.updateNodes();

			editor.popDataContextForDataSourceItem(this.dataSource, subview.indexPath);
			
		}};
	
	
	Object.defineProperty(UITableView.prototype, "cellPrototypeView", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_cellPrototypeView")) Object.defineProperty(this, "_cellPrototypeView", { writable: true, configurable: true });
			this._cellPrototypeView = v;
			this._cellPrototypeView.isPrototype = true;
			
			
			
			v.superview = this;
			
			
			
			if (!v.position || !v.position.top) {
				var firstRow = this.rowForIndexPath({ item: 0 });
				if (firstRow) v.position = { top: firstRow.position.top };
			}
		}, get:function () { return this._cellPrototypeView; }});
	
	
UITableView.prototype.changeCellPrototypeForEditor = function UITableView_changeCellPrototypeForEditor(key, newPrototype, editor, keepView) {
		_context.editor.changeCellPrototypeForItemsView(key, newPrototype, this, keepView);
		if (newPrototype.frame) {
			this.rowHeight = newPrototype.frame.size.height;
		}};
	

UITableView.prototype.layoutSubviews = function UITableView_layoutSubviews() {
		__super.prototype.layoutSubviews.call(this);};
	
	
UITableView.prototype.isDynamicCell = function UITableView_isDynamicCell(view) {
		if (!this.usesDataSource) return false;
		return view !== this.listHeaderView &&
			   view !== this.listFooterView;};
	
	
	Object.defineProperty(UITableView.prototype, "iconURL", {
		get: function () {
			return _context.pathForResource('UITableView48.png')
		}});
	

	Object.defineProperty(UITableView.prototype, "outlineIconURL", {
	configurable: true, 
		get: function () {
			return this.context.pathForResource('UITableView.png');
		}});
	
	

	Object.defineProperty(UITableView.prototype, "readableValue", {
		get: function () {
			if (this.name) return this.name;
			if (this.dataSource && this.dataSource.readableValue) return this.dataSource.readableValue+' ('+LocalizedString('List View')+')';
			return LocalizedString('List View');
		}});
	
	
UITableView.prototype.viewDidLoad = function UITableView_viewDidLoad() {
		if (this.viewIsLoaded) return;
		this.viewIsLoaded = true;
		__super.prototype.viewDidLoad.call(this);
		if (this.usesDataSource) this.loadDataSource();
		else this.reloadData();};
	
	
UITableView.prototype.loadDataSource = function UITableView__loadDataSource() {
	
		if (this.dataSource) {
			if (this.dataSource.$id === this._dataSourceId) {
				this.reloadData();
				return;
			}
		}

		this.setDataSource(this.context.getLivingDataSourceWithId(this._dataSourceId));

		this.reloadData();
		this.readableValueDidChange();};
	
	
UITableView.prototype.initDataSource = function UITableView__initDataSource(data) {
		this.dataSourceId = data.dataSourceId;};
	

	Object.defineProperty(UITableView.prototype, "rotationInDegrees", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_rotationInDegrees")) Object.defineProperty(this, "_rotationInDegrees", { writable: true, configurable: true });
			this._rotationInDegrees = v;
			this.style({ '-webkit-transform':v ? 'rotate(' + v + 'deg)':'' });
		}, get:function () { return this._rotationInDegrees; }});
	
	
	Object.defineProperty(UITableView.prototype, "hasSearchFeature", {
	outlet: true, 
	enumerable: true, get:function () { return this._hasSearchFeature; }, set:function (v) {if (!Object.hasOwnProperty(this, "_hasSearchFeature")) Object.defineProperty(this, "_hasSearchFeature", { writable: true, configurable: true }); this._hasSearchFeature = v; }});
	
	
	Object.defineProperty(UITableView.prototype, "positionIsEditable", {
	configurable: true, 
		value: true});
	

	Object.defineProperty(UITableView.prototype, "sizeIsEditable", {
	configurable: true, 
		value: true});
	

	Object.defineProperty(UITableView.prototype, "canHaveLayoutRelations", {
		value: true});
	
	
	window.createThinBorderCanvas = function() {
		var canvas = document.createElement('canvas');
		canvas.width = 320;
		canvas.height = 2;
		canvas.style.position = 'absolute';
		canvas.style.top = '0px';
		canvas.style.height = '1px';
		canvas.style.width = '100%';
		var ctx = canvas.getContext('2d');
		ctx.fillStyle = 'rgb(200,199,204)';
		ctx.fillRect(0,0,320,1);
		return canvas;
	}
	
	Object.defineProperty(UITableView.prototype, "notAvailableInDynamicCells", {
		value: true});
	

UITableView.prototype.createStaticSection = function UITableView__createStaticSection() {
		var section = createComponentFromDomain("UITableViewSection", "appdoo.iOS", this.context, {
			itemsView: this,
			isExpandedInEditorOutline: true,
			numberOfStaticCells: 0})
		;
		return section;};
	

UITableView.prototype.acceptsMemberWithUTI = function UITableView_acceptsMemberWithUTI(UTI) {
		if (this.usesDataSource) return false;
		if (!this.hasSectionNodes && UTI === 'appdoo.iOS.TableViewCellContentView') return true;
		return false;};
	

	var UITableViewCellAccessoryNone = 0,                   
	    UITableViewCellAccessoryDisclosureIndicator = 1,    
	    UITableViewCellAccessoryDetailDisclosureButton = 2, 
	    UITableViewCellAccessoryCheckmark = 3,              
	    UITableViewCellAccessoryDetailButton = 4; 

UITableView.prototype.transformData = function UITableView_transformData(data, transformer) {
		if (transformer.isXIBGenerator) {
			return this.tableView_transformDataForXIB(data, transformer);
		}
		else return this.tableView_transformDataForPreview(data, transformer);};
	

UITableView.prototype.tableView_transformDataForPreview = function UITableView_tableView_transformDataForPreview(data, transformer) {
		if (!data.frame) data.frame = { size: data.size, origin: {x:data.position.left,y:data.position.top}};
		
		var result = getPrototype('appdoo.iOS.UIView').transformData(data, transformer);
		result.$type = 'UITableView';

		if (data.allowsSelection === false)
			result.allowsSelection = false;
		
		if (!data.usesDefaultSeparatorInsets) {
			result.separatorInset = transformer.transformEdgeInsets(0, data.separatorInsetLeft, 0, data.separatorInsetRight);
		}
		result.separatorColor = transformer.transformCSSColor(data.separatorColor);

		if (data.pullToRefresh) {
			result.canPullToRefresh = true;
		}
		
		result.contentInset = transformer.transformEdgeInsets(data.insetTop||0,0,data.insetBottom||0,0);

		if (data.usesDataSource) {
		
			transformer.isTransformingCell = true;
			transformer.isTransformingTableViewCell = true;

			result.$connections.push({ key: "dataSource", destination: data.dataSourceId });
		
			var cellPrototype = getPrototype('appdoo.iOS.CellContentView').transformData(data.cellPrototype, transformer);
			
			
			cellPrototype.$prototype = true; 

			var cellPrototypeView = _context.decodeObjectTree(data.cellPrototype);
			
			result.$connections.push({ key: "cellGenerator", destinationObject: {
				$type: 'PrototypeCellGenerator',
				$domain: 'appdoo',
				$needsContextReference: true,
				contentViewPrototypeInfo: cellPrototype,
				cellInfo: {
					$type: 'SimpleTableViewCell',
					$domain: 'info.appdoo-mac',
					$prototype: true,
					accessoryType: data.detailSceneID ? UITableViewCellAccessoryDisclosureIndicator : undefined,
					layoutRelationsInfos: getType('appdoo.Editor.LayoutResolver').prototype.layoutRelationsInViewForAppdooPreview(cellPrototypeView, transformer)
				},
				bindingsInfo: bindingsInfoForView(data.cellPrototype, this),
			} });

			cellPrototypeView.destroy();
			
			result.rowHeight = data.cellPrototype.frame.size.height;

			var delegate = {
				$type: 'SimpleTableViewDelegate',
				$domain: 'appdoo',
				$id: data.$id+'Delegate',
				$needsViewControllerReference: true,
				detailSceneID: transformer.transformString(data.detailSceneID),
			};
			if (transformer.previewAppVersion >= 2) {
				delegate.modalTransitionStyle = transformer.transformModalTransitionStyle(data.modalTransitionStyle);
			}
			transformer.currentObjects.push(delegate);
			result.$connections.push({ key: "delegate", destination: delegate.$id });

			transformer.isTransformingCell = false;
			transformer.isTransformingTableViewCell = false;

		}
		else {

			transformer.isTransformingTableViewCell = true;

			result.dataSource = getPrototype('appdoo.iOS.StaticCellsDataSource').transformData({
					$type: 'StaticCellsDataSource',
					$domain: 'appdoo.iOS',
					$id: data.$id+'DataSource',
					headerView: data.listHeaderView,
					footerView: data.listFooterView,
					staticSections: data.staticSections,
					rowHeight: -1
				}, transformer);
				
			result.delegate = { $type: '$Reference', destination: data.$id+'DataSource' };
			transformer.isTransformingTableViewCell = false;


		}

		if (data.listHeaderView)
			result.tableHeaderView = getPrototype('appdoo.iOS.ViewGroup').transformData(data.listHeaderView, transformer);
		if (data.listFooterView)
			result.tableFooterView = getPrototype(utiFromData(data.listFooterView)).transformData(data.listFooterView, transformer);
		
		return result;	};
	

UITableView.prototype.transformChangeForAppdooPreview = function UITableView_transformChangeForAppdooPreview(change, transformer, result) {
		return getPrototype('appdoo.iOS.UIView').transformChangeForAppdooPreview.call(this, change, transformer, result);};
	

	
	
	Object.defineProperty(UITableView.prototype, "transform", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_transform")) Object.defineProperty(this, "_transform", { writable: true, configurable: true }); if (!v) v = ''; this._transform = v; if (this.DOMNode) this.DOMNode.style.webkitTransform = v; }, get:function () { return this._transform; }});
	
	
	
	Object.defineProperty(UITableView.prototype, "alpha", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_alpha")) Object.defineProperty(this, "_alpha", { writable: true, configurable: true }); if (isNaN(v)) v = 1; this._alpha = v; if (this.DOMNode) this.DOMNode.style.opacity = v; }, get:function () { return this._alpha; }});
	

	Object.defineProperty(UITableView.prototype, "alpha100", {
		set: function (v) { this.alpha = v/100||0; }, 
		get: function () { return this.alpha*100; }});
	
	
	Object.defineProperty(UITableView.prototype, "mutable", {
		
		value: true });
	
	
	Object.defineProperty(UITableView.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.splice(1, 0,
				['selectedItemIndex', this.readableNameForProperty('selectedItemIndex')]
			);
			return result;
		}});
	
	
UITableView.prototype.readableNameForProperty = function UITableView__readableNameForProperty(propertyName) {
		switch (propertyName) {
			case 'selectedItemIndex': return LocalizedString('Selected Cell')+' (0-index)';
			case 'name': return LocalizedString('Name');
		}
		return __super.prototype.readableNameForProperty.call(this, propertyName);};
	
	
UITableView.prototype.nameForKeyPath = function UITableView_nameForKeyPath(keyPath) {
		return this.readableNameForProperty(keyPath);};
	
	
	Object.defineProperty(UITableView.prototype, "selectedItemIndex", {
	outlet: true, 
		get: function () {
			
			return 0; 
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_selectedItemIndex")) Object.defineProperty(this, "_selectedItemIndex", { writable: true, configurable: true }); this._selectedItemIndex = v; }});
	
	
	Object.defineProperty(UITableView.prototype, "cocoaCustomType", {
		value: 'CPSUITableView'});
	
	
	Object.defineProperty(UITableView.prototype, "providesRootData", {
		value: true});
	
	
	Object.defineProperty(UITableView.prototype, "rootData", {
		get: function () { return { selectedItemIndex: 0 }; }});
	
	
UITableView.prototype.implementationHasObservable = function UITableView_implementationHasObservable(obj) {
		return true;};
	
	
	Object.defineProperty(UITableView.prototype, "shouldNotPreviewInEditor", {
		value: true});
	
	
	Object.defineProperty(UITableView.prototype, "observers", {
	synthesized: true, get:function () { return this._observers; }, set:function (v) {if (!Object.hasOwnProperty(this, "_observers")) Object.defineProperty(this, "_observers", { writable: true, configurable: true }); this._observers = v; }});
	
	
UITableView.prototype.addObserver = function UITableView_addObserver(obs) {
		if (!this.observers) this.observers = [];
		var i = this.observers.indexOf(obs);
		if (i==-1) this.observers.push(obs);
		else return;
		obs.dataSourceDidLoad(this);};
	
	
UITableView.prototype.removeObserver = function UITableView_removeObserver(obs) {
		var i = this.observers.indexOf(obs);
		if (i>=0) this.observers.splice(i, 1);};
	

UITableView.prototype.initPropertiesFromData = function UITableView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("backgroundColor")) this.backgroundColor = data.backgroundColor;
if (data.hasOwnProperty("_style")) this._style = data._style;
if (data.hasOwnProperty("modalTransitionStyle")) this.modalTransitionStyle = data.modalTransitionStyle;
if (data.hasOwnProperty("allowsSelection")) this.allowsSelection = data.allowsSelection;
if (data.hasOwnProperty("separatorInsetLeft")) this.separatorInsetLeft = data.separatorInsetLeft;
if (data.hasOwnProperty("separatorInsetRight")) this.separatorInsetRight = data.separatorInsetRight;
if (data.hasOwnProperty("usesDefaultSeparatorInsets")) this.usesDefaultSeparatorInsets = data.usesDefaultSeparatorInsets;
if (data.hasOwnProperty("rotationInDegrees")) this.rotationInDegrees = data.rotationInDegrees;
if (data.hasOwnProperty("hasSearchFeature")) this.hasSearchFeature = data.hasSearchFeature;
if (data.hasOwnProperty("transform")) this.transform = data.transform;
if (data.hasOwnProperty("alpha")) this.alpha = data.alpha;
if (data.hasOwnProperty("selectedItemIndex")) this.selectedItemIndex = data.selectedItemIndex;
};

UITableView.prototype.decodeData = function UITableView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

UITableView.prototype.encode = function UITableView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

UITableView.prototype.expectedTypeForProperty = function UITableView_expectedTypeForProperty(key) {
	if (key === "backgroundColor") return "String";
	if (key === "nameIsEditable") return "";
	if (key === "allCells") return "";
	if (key === "defaultBackgroundImage") return "";
	if (key === "sections") return "UITableViewSection[]";
	if (key === "selectable") return "";
	if (key === "usesAlternatingRowBackgroundColors") return "";
	if (key === "encodesStyles") return "";
	if (key === "defaultCellPrototype") return "";
	if (key === "staticCellPrototype") return "";
	if (key === "defaultSectionHeaderTemplate") return "";
	if (key === "rowType") return "";
	if (key === "modalTransitionStyle") return "String";
	if (key === "inspectorProperties") return "";
	if (key === "allowsSelection") return "Boolean";
	if (key === "separatorInsetLeft") return "Number";
	if (key === "separatorInsetRight") return "Number";
	if (key === "usesDefaultSeparatorInsets") return "Boolean";
	if (key === "e_separatorInsetLeft") return "Number";
	if (key === "e_separatorInsetRight") return "Number";
	if (key === "e_usesDefaultSeparatorInsets") return "Boolean";
	if (key === "cellPrototypeView") return "";
	if (key === "iconURL") return "";
	if (key === "outlineIconURL") return "";
	if (key === "readableValue") return "";
	if (key === "rotationInDegrees") return "Number";
	if (key === "hasSearchFeature") return "Boolean";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "canHaveLayoutRelations") return "";
	if (key === "notAvailableInDynamicCells") return "";
	if (key === "transform") return "String";
	if (key === "alpha") return "Number";
	if (key === "alpha100") return "Number";
	if (key === "mutable") return "";
	if (key === "bindableProperties") return "";
	if (key === "selectedItemIndex") return "Number";
	if (key === "cocoaCustomType") return "";
	if (key === "providesRootData") return "";
	if (key === "rootData") return "";
	if (key === "shouldNotPreviewInEditor") return "";
	if (key === "observers") return "BasicObject[]";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UITableView; }()));
registerType('appdoo.iOS', (function () { function UITableViewSection() {} var __super = setSupertypeFromDomain(UITableViewSection, 'UIItemsViewSection', 'appdoo.iOS');

	Object.defineProperty(UITableViewSection.prototype, "header", {
	outlet: true, get:function () { return this._header; }, set:function (v) {if (!Object.hasOwnProperty(this, "_header")) Object.defineProperty(this, "_header", { writable: true, configurable: true }); this._header = v; }});
	

	Object.defineProperty(UITableViewSection.prototype, "footer", {
	outlet: true, get:function () { return this._footer; }, set:function (v) {if (!Object.hasOwnProperty(this, "_footer")) Object.defineProperty(this, "_footer", { writable: true, configurable: true }); this._footer = v; }});
	
		
	Object.defineProperty(UITableViewSection.prototype, "listView", {
		get: function () { return this.itemsView; }});
	

UITableViewSection.prototype.init = function UITableViewSection_init() {
		__super.prototype.init.call(this);
		return this;};
	

UITableViewSection.prototype.populateView = function UITableViewSection__populateView() {
	
		this.view.removeAllSubviews(true);

		var i = 0, max = this.numberOfStaticCells;
		var rowView;
		if (Array.isArray(this.staticCells)) this.staticCells.every(function (cell) {
			if (++i > max) return false;
			rowView = this.listView.createRow();
			rowView.addSubview(cell);
			rowView.contentView = cell;
			cell.cellView = rowView;
			cell.autoresizingMask = 2;
			cell.section = this;
			this.view.addSubview(rowView);
			rowView.indexPath = { section: 0, item: i-1 };
			rowView.size.height = cell.size.height;
			this.listView.prepareCellContentView(cell);

			if (cell.navigatesToDetailScene)
				rowView.accessoryType = "disclosureIndicator";
			else
				rowView.accessoryType = null;

			if (cell.backgroundColor)
				rowView.backgroundColor = cell.backgroundColor;return true; }, this);
		
		
		
		this.arrangeSubviews();
	};
	
	
UITableViewSection.prototype.arrangeSubviews = function UITableViewSection__arrangeSubviews() {

		var y = 0;
		if (Array.isArray(this.staticCells)) this.staticCells.every(function (cell) {
			if (cell === _context.editor.editedSubview) {
				y += cell.size.height;
				return true;
			}
			cell.position.top = 0;
			cell.superview.position.top = y;
			cell.superview.size.width = this.view.size.width;
			y += cell.superview.size.height;return true; }, this);
		
		
		this.setHeightToFit();
	};
	

UITableViewSection.prototype.setHeightToFit = function UITableViewSection__setHeightToFit() {

		var lastSubview = this.staticCells[this.numberOfStaticCells-1];
		this.view.size.height = lastSubview ? lastSubview.superview.position.bottom : 0;
		this.view.size.width = this.itemsView.size.width;
	};
	
	

UITableViewSection.prototype.acceptsMemberWithUTI = function UITableViewSection_acceptsMemberWithUTI(uti) {
		if (uti === 'appdoo.iOS.TableViewCellContentView') return true;
		return false;};
	

UITableViewSection.prototype.initPropertiesFromData = function UITableViewSection_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("header")) this.header = data.header;
if (data.hasOwnProperty("footer")) this.footer = data.footer;
};

UITableViewSection.prototype.decodeData = function UITableViewSection_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

UITableViewSection.prototype.encode = function UITableViewSection_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

UITableViewSection.prototype.encodeCloned = function UITableViewSection_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

UITableViewSection.prototype.expectedTypeForProperty = function UITableViewSection_expectedTypeForProperty(key) {
	if (key === "header") return "String";
	if (key === "footer") return "String";
	if (key === "listView") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UITableViewSection; }()));
registerType('appdoo.iOS', (function () { function UITableViewGroupedSectionView() {} var __super = setSupertypeFromDomain(UITableViewGroupedSectionView, 'UIView', 'appdoo.iOS');

UITableViewGroupedSectionView.prototype.createSubviews = function UITableViewGroupedSectionView__createSubviews() {
		this.createHeaderLabel();
		this.createCells();
		this.createFooterLabel();
		this.createBorder();
		this.layoutSubviews();};
	
	
UITableViewGroupedSectionView.prototype.createBorder = function UITableViewGroupedSectionView__createBorder() {
	
		if (this.context.simulatedSystemVersion < 7) return;
		
		var bc = createThinBorderCanvas();
		this.DOMNode.appendChild(bc);
		this.lastSectionLine = bc;
};
	
	
UITableViewGroupedSectionView.prototype.createHeaderLabel = function UITableViewGroupedSectionView__createHeaderLabel() {
		if (!this.header) return;
		if (this.context.simulatedSystemVersion < 7) {
			this.createHeaderLabelSystem6();
		} else {
			this.createHeaderLabelSystem7();
		}};
	

UITableViewGroupedSectionView.prototype.createHeaderLabelSystem6 = function UITableViewGroupedSectionView__createHeaderLabelSystem6() {
		this.headerLabel = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			text: this.header,
			style: this.headerLabelStyle,
			fontFamily: 'System',
			fontName: '_DEFAULT_BOLD_',
			fontSize: 16,
			position: { left: 20, top: 0 },
			size: { width: this.size.width-40, height: 20 },
			autoresizingMask: 2})
		;
		this.addSubview(this.headerLabel);};
	

UITableViewGroupedSectionView.prototype.createHeaderLabelSystem7 = function UITableViewGroupedSectionView__createHeaderLabelSystem7() {
		this.headerLabel = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			text: this.header,
			style: {
				textTransform: 'uppercase',
				color: 'rgb(123,123,128)'
			},
			fontFamily: 'System',
			fontName: '_DEFAULT_',
			fontSize: 14,
			position: { left: 15, top: 0 },
			size: { width: this.size.width-40, height: 14 },
			autoresizingMask: 2})
		;
		this.addSubview(this.headerLabel);};
	

UITableViewGroupedSectionView.prototype.createFooterLabel = function UITableViewGroupedSectionView__createFooterLabel() {
		if (!this.footer) return;

		if (this.context.simulatedSystemVersion < 7) {
			this.createFooterLabelSystem6();
		} else {
			this.createFooterLabelSystem7();
		}};
	

UITableViewGroupedSectionView.prototype.createFooterLabelSystem6 = function UITableViewGroupedSectionView__createFooterLabelSystem6() {
		this.footerLabel = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			text: this.footer,
			fontSize: 15,
			style: this.footerLabelStyle,
			numberOfLines: 0,
			fontFamily: 'System',
			fontName: '_DEFAULT_',
			position: { left: 10 },
			size: { width: this.size.width-20 },
			autoresizingMask: 2,
			layoutMode: 'autoFitHeight'})
		;
		this.addSubview(this.footerLabel);};
	

UITableViewGroupedSectionView.prototype.createFooterLabelSystem7 = function UITableViewGroupedSectionView__createFooterLabelSystem7() {
		this.footerLabel = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			text: this.footer,
			fontSize: 14,
			style: { color: 'rgb(123,123,128)' },
			numberOfLines: 0,
			fontFamily: 'System',
			fontName: '_DEFAULT_',
			position: { left: 14 },
			size: { width: this.size.width-30 },
			autoresizingMask: 2,
			layoutMode: 'autoFitHeight'})
		;
		this.addSubview(this.footerLabel);};
	
	
UITableViewGroupedSectionView.prototype.createCells = function UITableViewGroupedSectionView__createCells() {
		if (Array.isArray(this.staticCells)) this.staticCells.every(function (rowView) {
			this.addSubview(rowView);return true; }, this);
		

		this.styleCells();};
	
	
UITableViewGroupedSectionView.prototype.arrangeSubviews = function UITableViewGroupedSectionView_arrangeSubviews() {
		
		var y = 0, i = 0; var lastSubview;
		if (Array.isArray(this.staticCells)) this.staticCells.every(function (subview) {
;
			if (i > 0 && subview.thinBorderLine && lastSubview !== this.headerLabel) {
				subview.thinBorderLine.style.left = '15px';
			}
			if (subview === this.footerLabel) y += 8;
			subview.position.top = y;
			y += subview.size.height;
			if (subview === this.headerLabel) {
				y += 10;
			}
			
			i++;
			lastSubview = subview;return true; }, this);
		
		this.size.height = y+25;
		
		if (this.footerLabel) y-= (this.footerLabel.size.height+8);
		this.lastSectionLine.style.top = (y)+'px';
};
	

UITableViewGroupedSectionView.prototype.layoutSubviews = function UITableViewGroupedSectionView_layoutSubviews() {
		
		
		if (this.isLayoutingSubviews) return;
		
		this.isLayoutingSubviews = true;
		__super.prototype.layoutSubviews.call(this);
		this.isLayoutingSubviews = false;};
	
	
	var defaultHeaderColor = 'rgb(94,105,128)',
		defaultHeaderTextShadow = '0 1px 0 rgba(255,255,255,.9)'
	
	Object.defineProperty(UITableViewGroupedSectionView.prototype, "headerLabelStyle", {
		value: {
				color: defaultHeaderColor,
				textShadow: defaultHeaderTextShadow
			}});
	

	Object.defineProperty(UITableViewGroupedSectionView.prototype, "footerLabelStyle", {
		value: {
				color: defaultHeaderColor,
				textShadow: defaultHeaderTextShadow,
				textAlign: 'center'
			}});
	
	
	
	var borderRadius = '8px';
	var borderColorBetween = 'rgb(212,212,212)';
	var borderColorOutside = 'rgb(184,184,184)';
	var cellBackgroundColor = 'hsl(0,0%,98%)';
	
UITableViewGroupedSectionView.prototype.styleCells = function UITableViewGroupedSectionView__styleCells() {
		
		if (this.context.simulatedSystemVersion < 7) {
			this.styleCellsSystem6();
		} else {
			this.styleCellsSystem7();
		}
		};
	

UITableViewGroupedSectionView.prototype.styleCellsSystem7 = function UITableViewGroupedSectionView__styleCellsSystem7() {};
	

UITableViewGroupedSectionView.prototype.styleCellsSystem6 = function UITableViewGroupedSectionView__styleCellsSystem6() {
	
		
		
		var blur = '0px';

		var cells = clone(this.subviews);
		if (this.headerLabel) cells.splice(this.subviews.indexOf(this.headerLabel), 1);
		if (this.footerLabel) cells.splice(this.subviews.indexOf(this.footerLabel), 1);
	
		var i = 0, n = cells.length;
		if (Array.isArray(cells)) cells.every(function (cell) {
			cell.style({
				border: '1px solid '+borderColorOutside,
				backgroundColor: cellBackgroundColor
			});
			if (i === 0 && i === n-1) {
				cell.style({
					borderTopLeftRadius: borderRadius,
					borderTopRightRadius: borderRadius,
					borderBottomLeftRadius: borderRadius,
					borderBottomRightRadius: borderRadius,
					borderTopWidth: '1px',
					boxShadow: '0 1px '+blur+' rgba(255,255,255,.6), inset 0 1px '+blur+' rgba(0,0,0,.1)',
				});
			}
			else if (i === 0) {
				cell.style({
					borderTopLeftRadius: borderRadius,
					borderTopRightRadius: borderRadius,
					borderBottomLeftRadius: '',
					borderBottomRightRadius: '',
					borderTopWidth: '1px',
					boxShadow: 'inset 0 1px '+blur+' rgba(0,0,0,.1)',
				});
			}
			else if (i === n-1) {
				cell.style({
					borderTopLeftRadius: '',
					borderTopRightRadius: '',
					borderBottomLeftRadius: borderRadius,
					borderBottomRightRadius: borderRadius,
					boxShadow: '0 1px '+blur+' rgba(255,255,255,.6)',
					borderTopColor: borderColorBetween
				});
			}
			else {
				cell.style({
					borderTopLeftRadius: '',
					borderTopRightRadius: '',
					borderBottomLeftRadius: '',
					borderBottomRightRadius: '',
					boxShadow: '',
					borderTopColor: borderColorBetween
				});
			}
			i++;return true; }, this);
		};
	

UITableViewGroupedSectionView.prototype.expectedTypeForProperty = function UITableViewGroupedSectionView_expectedTypeForProperty(key) {
	if (key === "headerLabelStyle") return "";
	if (key === "footerLabelStyle") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UITableViewGroupedSectionView; }()));
registerType('appdoo.iOS', (function () { function StaticCellsDataSource() {} var __super = setSupertypeFromDomain(StaticCellsDataSource, 'BasicEditableObject', 'appdoo');

StaticCellsDataSource.prototype.transformData = function StaticCellsDataSource_transformData(data, transformer) {
	
		var result = __super.prototype.transformData.call(this, data, transformer);

		if (!transformer.isXIBGenerator) {
			result.$needsContextReference = true;
			result.$needsViewControllerReference = true;
	
			result.staticSectionsInfo = [];
			for (var i = 0, c = data.staticSections.length; i < c; i++) {
				var sectionInfo = { staticCells: [] };
				for (var j = 0, cj = data.staticSections[i].staticCells.length; j < cj; j++) {
					var originalData = data.staticSections[i].staticCells[j];
					var cellInfo = getPrototype(utiFromData(originalData)).transformData(originalData, transformer);
					sectionInfo.staticCells.push(cellInfo);
				}
				result.staticSectionsInfo.push(sectionInfo);
			}
		}
		
		return result;
};
	


StaticCellsDataSource.prototype.expectedTypeForProperty = function StaticCellsDataSource_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return StaticCellsDataSource; }()));