
registerType('appdoo.iOS', (function () { function UITableViewCell() {} var __super = setSupertypeFromDomain(UITableViewCell, 'UIView', 'appdoo.iOS');

UITableViewCell.prototype.destroy = function UITableViewCell_destroy() {
		__super.prototype.destroy.call(this);
		this.accessoryView = null;};
	
	
	Object.defineProperty(UITableViewCell.prototype, "contentView", {
	synthesized: true, get:function () { return this._contentView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentView")) Object.defineProperty(this, "_contentView", { writable: true, configurable: true }); this._contentView = v; }});
	
	
	Object.defineProperty(UITableViewCell.prototype, "accessoryType", {
		set: function (v) {
		
			if (this._accessoryType === v) return;
			
			Object.defineProperty(this, "_accessoryType", {
			writable: true, 
				value: v});
			
			
			if (!v) {
				if (this.accessoryView) {
					this.accessoryView.removeFromSuperview(true);
					this.contentView.size.width = this.size.width;
				}
				return;
			}

			if (this.accessoryView === undefined) {
				this.accessoryView = createComponentFromDomain('View', 'Core.UI',
					this.context, {
						size: { width: 40, height: this.size.height },
						position: { right: 0 }
					});
			}
			else this.accessoryView.removeAllSubviews();
			
			
			var isSystem7 = this.context.simulatedSystemVersion >= 7;
			
			if (v === "disclosureIndicator") {
				this.accessoryView.addSubview(createComponentFromDomain(
					'UIImageView',
					'appdoo.iOS',
					this.context,
					{
						size: { width: 24, height: 24 },
						position: { left: 8, top: parseInt(this.size.height/2)-12 },
						imageSrc: this.colorScheme === 'dark' ? this.context.pathForResource('DisclosureIndicatorWhite.png') : this.context.pathForResource(this.context.simulatedSystemVersion < 7 ? 'DisclosureIndicator.png' : 'DisclosureIndicatorSystem7.png'),
						contentMode: 'scaleAspectFit'
					}
				));
			}
			else if (v === "checkmark") {
				var imageName = isSystem7 ? 'CheckmarkSystem7.png' : 'Checkmark.png',
					left = isSystem7 ? 11 : 14;
				this.accessoryView.addSubview(createComponentFromDomain(
					'UIImageView',
					'appdoo.iOS',
					this.context,
					{
						size: { width: 20, height: 20 },
						position: { left: left, top: parseInt(this.size.height/2)-12 },
						imageSrc: this.context.pathForResource(imageName),
						contentMode: 'scaleAspectFit'
					}
				));
			}
			
			this.addSubview(this.accessoryView);

			if (this.contentView) {
				this.contentView.size.width = this.size.width - (isSystem7 ? 33 : 20);
			}
			
		}, 
		get: function () {
			return this._accessoryType;
		}});
	

	Object.defineProperty(UITableViewCell.prototype, "detailSceneID", {
		get: function () {
			if (this.contentView.navigatesToDetailScene) {
				return this.contentView.detailSceneID;
			}
		}});
	

UITableViewCell.prototype.editorDidEditSubview = function UITableViewCell_editorDidEditSubview(editor, subview) {
		if (subview.isStaticCell && this.superview && this.superview.superview && this.superview.superview.UTI === 'appdoo.iOS.UITableView') {
			this.superview.superview.arrangeSubviews();
			this.superview.superview.drawBackground();
		}};
	

UITableViewCell.prototype.expectedTypeForProperty = function UITableViewCell_expectedTypeForProperty(key) {
	if (key === "contentView") return "";
	if (key === "accessoryType") return "";
	if (key === "detailSceneID") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UITableViewCell; }()));
registerType('appdoo.iOS', (function () { function TableViewCellContentView() {} var __super = setSupertypeFromDomain(TableViewCellContentView, 'CellContentView', 'appdoo.iOS');

	Object.defineProperty(TableViewCellContentView.prototype, "outlineIconURL", {
	configurable: true, 
		get: function () {
			return this.context.pathForResource('UITableViewCell.png');
		}});
	
	
	Object.defineProperty(TableViewCellContentView.prototype, "readableType", {
	configurable: true, 
		get: function () {
			if (this.isPrototype) return LocalizedString('Row Prototype');
			return LocalizedString('Row');
		}});
	

	Object.defineProperty(TableViewCellContentView.prototype, "nameIsEditable", {
	configurable: true, 
		get: function () {
			if (this.isPrototype) return false;
			return true;
		}});
	

	Object.defineProperty(TableViewCellContentView.prototype, "viewMayScroll", {
		value: false});
	

	Object.defineProperty(TableViewCellContentView.prototype, "heightIsEditable", {
		value: true});
	
	
	Object.defineProperty(TableViewCellContentView.prototype, "isPrototype", {
	outlet: true, 
	enumerable: true, get:function () { return this._isPrototype; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isPrototype")) Object.defineProperty(this, "_isPrototype", { writable: true, configurable: true }); this._isPrototype = v; }});
	

	Object.defineProperty(TableViewCellContentView.prototype, "isStaticCell", {
		get: function () {
			return !this.isPrototype;
		}});
	

	Object.defineProperty(TableViewCellContentView.prototype, "section", {
	synthesized: true, get:function () { return this._section; }, set:function (v) {if (!Object.hasOwnProperty(this, "_section")) Object.defineProperty(this, "_section", { writable: true, configurable: true }); this._section = v; }});
	
	
TableViewCellContentView.prototype.deleteForEditor = function TableViewCellContentView__deleteForEditor(editor) {
		var r = __super.prototype.deleteForEditor.call(this, editor);
		if (r === false) return false;

		if (this.isStaticCell) {
			if (this.section) this.section.removeCell(this);
		}
	};
	

	Object.defineProperty(TableViewCellContentView.prototype, "cellView", {
	synthesized: true, get:function () { return this._cellView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_cellView")) Object.defineProperty(this, "_cellView", { writable: true, configurable: true }); this._cellView = v; }});
	

	Object.defineProperty(TableViewCellContentView.prototype, "e_backgroundColor", {
		set: function (v) {
			this.backgroundColor = v;
			
		 }, 
		get: function ( ) {
			return this.backgroundColor;
		}});
	
	

TableViewCellContentView.prototype.initPropertiesFromData = function TableViewCellContentView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("isPrototype")) this.isPrototype = data.isPrototype;
};

TableViewCellContentView.prototype.decodeData = function TableViewCellContentView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

TableViewCellContentView.prototype.encode = function TableViewCellContentView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

TableViewCellContentView.prototype.encodeCloned = function TableViewCellContentView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

TableViewCellContentView.prototype.expectedTypeForProperty = function TableViewCellContentView_expectedTypeForProperty(key) {
	if (key === "outlineIconURL") return "";
	if (key === "readableType") return "";
	if (key === "nameIsEditable") return "";
	if (key === "viewMayScroll") return "";
	if (key === "heightIsEditable") return "";
	if (key === "isPrototype") return "Boolean";
	if (key === "isStaticCell") return "";
	if (key === "section") return "";
	if (key === "cellView") return "UITableViewCell";
	if (key === "e_backgroundColor") return "String";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TableViewCellContentView; }()));
registerType('appdoo.iOS', (function () { function TableViewHeaderView() {} var __super = setSupertypeFromDomain(TableViewHeaderView, 'ViewGroup', 'appdoo.iOS');

	Object.defineProperty(TableViewHeaderView.prototype, "outlineIconURL", {
	configurable: true, 
		get: function () {
			return this.context.pathForResource('TableViewHeaderView.png');
		}});
	
	
	Object.defineProperty(TableViewHeaderView.prototype, "readableType", {
	configurable: true, 
		get: function () { return LocalizedString('Header Row'); }});
	
	
	Object.defineProperty(TableViewHeaderView.prototype, "nameIsEditable", {
		value: false});
	

	Object.defineProperty(TableViewHeaderView.prototype, "viewMayScroll", {
		value: false});
	

	Object.defineProperty(TableViewHeaderView.prototype, "positionIsEditable", {
		value: false});
	

	Object.defineProperty(TableViewHeaderView.prototype, "sizeIsEditable", {
		value: true});
	

	Object.defineProperty(TableViewHeaderView.prototype, "widthIsEditable", {
		value: false});
	

	Object.defineProperty(TableViewHeaderView.prototype, "heightIsEditable", {
		value: true});
	
	
	Object.defineProperty(TableViewHeaderView.prototype, "autoresizingMaskIsEditable", {
		value: false});
	

	Object.defineProperty(TableViewHeaderView.prototype, "canHaveLayoutRelations", {
		value: false});
	

	Object.defineProperty(TableViewHeaderView.prototype, "isStaticCell", {
		value: true});
	
	
TableViewHeaderView.prototype.deleteForEditor = function TableViewHeaderView_deleteForEditor(editor) {
		if (this.superview)
			this.superview.dataController.setValueForKeyPath(false, 'listHeaderEnabled', this.superview.dataController);
		return false;};
	

TableViewHeaderView.prototype.expectedTypeForProperty = function TableViewHeaderView_expectedTypeForProperty(key) {
	if (key === "outlineIconURL") return "";
	if (key === "readableType") return "";
	if (key === "nameIsEditable") return "";
	if (key === "viewMayScroll") return "";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "autoresizingMaskIsEditable") return "";
	if (key === "canHaveLayoutRelations") return "";
	if (key === "isStaticCell") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TableViewHeaderView; }()));
registerType('appdoo.iOS', (function () { function TableViewFooterView() {} var __super = setSupertypeFromDomain(TableViewFooterView, 'ViewGroup', 'appdoo.iOS');

	Object.defineProperty(TableViewFooterView.prototype, "outlineIconURL", {
	configurable: true, 
		get: function () {
			return this.context.pathForResource('TableViewFooterView.png');
		}});
	

	Object.defineProperty(TableViewFooterView.prototype, "readableType", {
	configurable: true, 
		get: function () { return LocalizedString('Footer Row'); }});
	

	Object.defineProperty(TableViewFooterView.prototype, "nameIsEditable", {
		value: false});
	

	Object.defineProperty(TableViewFooterView.prototype, "viewMayScroll", {
		value: false});
	

	Object.defineProperty(TableViewFooterView.prototype, "widthIsEditable", {
		value: false});
	

	Object.defineProperty(TableViewFooterView.prototype, "heightIsEditable", {
		value: true});
	

	Object.defineProperty(TableViewFooterView.prototype, "xIsEditable", {
		value: false});
	

	Object.defineProperty(TableViewFooterView.prototype, "yIsEditable", {
		value: false});
	

	Object.defineProperty(TableViewFooterView.prototype, "positionIsEditable", {
		value: false});
	

	Object.defineProperty(TableViewFooterView.prototype, "sizeIsEditable", {
		value: true});
	
	
	Object.defineProperty(TableViewFooterView.prototype, "autoresizingMaskIsEditable", {
		value: false});
	

	Object.defineProperty(TableViewFooterView.prototype, "canHaveLayoutRelations", {
		value: false});
	

	Object.defineProperty(TableViewFooterView.prototype, "isStaticCell", {
		value: true});
	

TableViewFooterView.prototype.deleteForEditor = function TableViewFooterView_deleteForEditor(editor) {
		if (this.superview)
			this.superview.dataController.setValueForKeyPath(false, 'listFooterEnabled', this.superview.dataController);
		return false;};
	
	
	

TableViewFooterView.prototype.expectedTypeForProperty = function TableViewFooterView_expectedTypeForProperty(key) {
	if (key === "outlineIconURL") return "";
	if (key === "readableType") return "";
	if (key === "nameIsEditable") return "";
	if (key === "viewMayScroll") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "autoresizingMaskIsEditable") return "";
	if (key === "canHaveLayoutRelations") return "";
	if (key === "isStaticCell") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TableViewFooterView; }()));