
registerType('appdoo.iOS', (function () { function UITextField() {} var __super = setSupertypeFromDomain(UITextField, 'UIControl', 'appdoo.iOS');

UITextField.prototype.init = function UITextField_init() {
		__super.prototype.init.call(this);
		if (this.enabled === undefined) this.enabled = true;
		if (this.borderStyle === undefined) this.borderStyle = UITextBorderStyleRoundedRect;
		if (this.font === undefined) this.font = createComponentFromDomain("UIFont", "appdoo.iOS", this.context, {
			fontFamily: 'System',
			fontName: '_DEFAULT_',
			pointSize: 14})
		;

		this.styleDefault();
		this.updateInputView();
		return this;};
	
	
	Object.defineProperty(UITextField.prototype, "text", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_text")) Object.defineProperty(this, "_text", { writable: true, configurable: true });
			if ((this._text !== undefined && v !== this._text) && bindingShouldBeBidirectional(this.bindingForKey('text'))) {
			
				
				var binding = this.bindingForKey('text');
				binding.destinationObject.setValueForKeyPath(v, binding.destinationKeyPath);
				
			}
			this._text = v;
			if (this.viewIsLoaded) this.updateInputView();
			if (this.dataProvider) this.dataProvider.notifyObservers();
		}, get:function () { return this._text; }});
	

	Object.defineProperty(UITextField.prototype, "placeholder", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_placeholder")) Object.defineProperty(this, "_placeholder", { writable: true, configurable: true });
			this._placeholder = v;
			if (this.viewIsLoaded) this.updateInputView();
		}, get:function () { return this._placeholder; }});
	
	
	Object.defineProperty(UITextField.prototype, "secureTextEntry", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_secureTextEntry")) Object.defineProperty(this, "_secureTextEntry", { writable: true, configurable: true }); this._secureTextEntry =v;if (this.viewIsLoaded) this.updateInputView()}, get:function () { return this._secureTextEntry; }});
	
	
	Object.defineProperty(UITextField.prototype, "enabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._enabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_enabled")) Object.defineProperty(this, "_enabled", { writable: true, configurable: true }); this._enabled = v; }});
	
	
	Object.defineProperty(UITextField.prototype, "font", {
	outlet: true, 
	enumerable: true, get:function () { return this._font; }, set:function (v) {if (!Object.hasOwnProperty(this, "_font")) Object.defineProperty(this, "_font", { writable: true, configurable: true }); this._font = v; }});
	
	
	Object.defineProperty(UITextField.prototype, "fontName", {
		set: function (v) { this.font.fontName = v; }, 
		get: function ( ) { return this.font.fontName; }});
	
	Object.defineProperty(UITextField.prototype, "fontFamily", {
		set: function (v) { this.font.fontFamily = v; }, 
		get: function ( ) { return this.font.fontFamily; }});
	
	Object.defineProperty(UITextField.prototype, "fontSize", {
		set: function (v) { this.font.pointSize = v; }, 
		get: function ( ) { return this.font.pointSize; }});
	

UITextField.prototype.observedObjectValueDidChangeForKeyPath = function UITextField_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {
		this.styleDefault();};
	
	
	
UITextField.prototype.updateInputView = function UITextField__updateInputView() {
		if (this.text || this.text === 0) {
			if (this.secureTextEntry)
				this.inputView.text = this.text.split('').map(function () {return '●';}).join('');
			else
				this.inputView.text = this.text;
			this.inputView.CSSTextColor = '#000';
		}
		else if (this.placeholder || this.placeholder === 0) { this.inputView.text = this.placeholder; this.inputView.CSSTextColor = '#ccc'; }
		else this.inputView.text = ' ';};
	
	
UITextField.prototype.createInputView = function UITextField__createInputView() {
		this.inputView = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			size: { width: this.size.width-7, height: this.size.height },
			autoresizingMask: 2,
			text: '',
			position: { top: 0, left: 7 },
			style: { webkitTransform: 'translateY(0.5px)'},
			fontName: '_DEFAULT_'})
		;
		this.addSubview(this.inputView);};
	

	Object.defineProperty(UITextField.prototype, "inputView", {
	synthesized: true, 
		get: function () {
			if (!this._inputView) this.createInputView();
			return this._inputView;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_inputView")) Object.defineProperty(this, "_inputView", { writable: true, configurable: true }); this._inputView = v; }});
	

	Object.defineProperty(UITextField.prototype, "readableType", {
		get: function () { return LocalizedString('Text Input Field'); }});
	

	Object.defineProperty(UITextField.prototype, "readableValue", {
		get: function () {
			if (this.name) return this.name
			return this.readableType;
		}});
	
		
	Object.defineProperty(UITextField.prototype, "backgroundImage", {
	synthesized: true, get:function () { return this._backgroundImage; }, set:function (v) {if (!Object.hasOwnProperty(this, "_backgroundImage")) Object.defineProperty(this, "_backgroundImage", { writable: true, configurable: true }); this._backgroundImage = v; }});
	
	
	Object.defineProperty(UITextField.prototype, "encodesSubviews", {
		value: false});
	
	
UITextField.prototype.styleDefaultSystem7 = function UITextField_styleDefaultSystem7() {

		if (!this.backgroundImage) {
			this.backgroundImage = createComponentFromDomain("SmartScalingImage", "Core.UI", this.context, {
				size: this.sizeCopy,
				autoresizingMask: 2,
				imageSrc: 'Resources/UITextFieldBackground.png',
				contentInset: [10,10,10,20],})
			;
			this.insertSubviewAtIndex(this.backgroundImage, 0);
		}
		
		this.backgroundImage.hidden = !this.hasBorderStyle;
		this.inputView.position.left = this.hasBorderStyle ? 7 : 0;
		this.inputView.fontSize = this.font.pointSize;
		this.inputView.fontName = this.font.fontName;
		};
	


	
UITextField.prototype.createForSuperview = function UITextField_createForSuperview(superview) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: 97, height: 30 },
			position: { left: 0, top: 0 },
			autoresizingMask: 36,
			text: '',
			placeholder: '',
			name: superview.context.nameForNewFormControl(this),
			borderStyle: UITextBorderStyleRoundedRect
		});
	};
	

	Object.defineProperty(UITextField.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
					{ name: this.readableNameForProperty('name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: this.readableNameForProperty('text'), keyPath: 'text', type: 'text', positionLeft: true },
						{ name: this.readableNameForProperty('placeholder'), keyPath: 'placeholder', type: 'text', positionLeft: true },
						{ name: this.readableNameForProperty('secureTextEntry'), keyPath: 'secureTextEntry', type: 'boolean', positionLeft: true },
						{ name: this.readableNameForProperty('enabled'), keyPath: 'enabled', type: 'boolean', positionLeft: true },
						{ name: this.readableNameForProperty('hasBorderStyle'), keyPath: 'hasBorderStyle', type: 'boolean', positionLeft: true },

						{ type: 'space' },
						{ name: this.readableNameForProperty('autocapitalizationType'), keyPath: 'autocapitalizationTypeAsString', type: 'select', options:[
							['', LocalizedString('Don\'t')],
							['words', LocalizedString('All Words')],
							['sentences', LocalizedString('All Sentences')],
							['allCharacters', LocalizedString('All Characters')],
						] },
						{ name: this.readableNameForProperty('clearButtonMode'), keyPath: 'clearButtonModeAsString', type: 'select', options:[
							['', LocalizedString('Don\'t Show')],
							['whileEditing', LocalizedString('Show While Editing')],
							['unlessEditing', LocalizedString('Show Unless Editing')],
							['always', LocalizedString('Show Always')],
						], marginTop:-3 },
						{ name: this.readableNameForProperty('keyboardType'), keyPath: 'keyboardTypeAsString', type: 'select', options:[

							['',LocalizedString('Default')],
							['alphabet',LocalizedString('ASCII')],
							['numbersAndPunctuation',LocalizedString('Numbers and Punctuation')],
							['URL',LocalizedString('URL')],
							['numberPad',LocalizedString('Number Pad')],
							['phonePad',LocalizedString('Phone Pad')],
							['namePhonePad',LocalizedString('Name or Phone Number')],
							['emailAddress',LocalizedString('Email Address')],
							['decimalPad',LocalizedString('Decimal Pad')],
							['twitter',LocalizedString('Twitter')],
							['webSearch',LocalizedString('Web Search')],
						], marginTop:-3 },

						{ name: this.readableNameForProperty('keyboardAppearance'), keyPath: 'keyboardAppearanceAsString', type: 'select', options:[
							['', LocalizedString('Default Style')],
							['alert', LocalizedString('dark')],
							['light', LocalizedString('light')],
						], numberOfVisibleItems:1, showsIcons: false, marginTop:-3 },
						
						



						
					]
				},
				{
					type: 'group',
					title: LocalizedString('Font'),
					id: this.constructor.name+'Font',
					items: [
						{ type: 'font' },
						{ type: 'space' },
						{ type: 'fontSize', keyPath: 'fontSize' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				},
		
			];

		}});
	
	
	
	var UITextAutocapitalizationTypeNone = 0,
		UITextAutocapitalizationTypeWords = 1,
		UITextAutocapitalizationTypeSentences = 2,
		UITextAutocapitalizationTypeAllCharacters = 3;

	var storyboardNameForAutocapitalizationType = [
		undefined,
		'words',
		'sentences',
		'allCharacters'
	];
	
	Object.defineProperty(UITextField.prototype, "autocapitalizationType", {
	outlet: true, 
	enumerable: true, get:function () { return this._autocapitalizationType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_autocapitalizationType")) Object.defineProperty(this, "_autocapitalizationType", { writable: true, configurable: true }); this._autocapitalizationType = v; }});
	
	
	Object.defineProperty(UITextField.prototype, "autocapitalizationTypeAsString", {
		set: function (v) {
			this.autocapitalizationType = storyboardNameForAutocapitalizationType.indexOf(v);
			if (this.autocapitalizationType === -1) this.autocapitalizationType = undefined;
		}, 
		get: function () {
			if (!this.autocapitalizationType) return '';
			return storyboardNameForAutocapitalizationType[this.autocapitalizationType];
		}});
	

	
	var UITextFieldViewModeNever = 0,
		UITextFieldViewModeWhileEditing = 1,
		UITextFieldViewModeUnlessEditing = 2,
		UITextFieldViewModeAlways = 3;

	var storyboardNameForViewMode = [
		undefined,
		'whileEditing',
		'unlessEditing',
		'always'
	];
	
	Object.defineProperty(UITextField.prototype, "clearButtonMode", {
	outlet: true, 
	enumerable: true, get:function () { return this._clearButtonMode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_clearButtonMode")) Object.defineProperty(this, "_clearButtonMode", { writable: true, configurable: true }); this._clearButtonMode = v; }});
	
	
	Object.defineProperty(UITextField.prototype, "clearButtonModeAsString", {
		set: function (v) {
			this.clearButtonMode = storyboardNameForViewMode.indexOf(v);
			if (this.clearButtonMode === -1) this.clearButtonMode = undefined;
		}, 
		get: function () {
			if (!this.clearButtonMode) return '';
			return storyboardNameForViewMode[this.clearButtonMode];
		}});
	

	
	var UIKeyboardTypeDefault = 0,
		UIKeyboardTypeASCIICapable = 1,
		UIKeyboardTypeNumbersAndPunctuation = 2,
		UIKeyboardTypeURL = 3,
		UIKeyboardTypeNumberPad = 4,
		UIKeyboardTypePhonePad = 5,
		UIKeyboardTypeNamePhonePad = 6,
		UIKeyboardTypeEmailAddress = 7,
		UIKeyboardTypeDecimalPad = 8,
		UIKeyboardTypeTwitter = 9,
		UIKeyboardTypeWebSearch = 10,
		UIKeyboardTypeAlphabet = UIKeyboardTypeASCIICapable;

	var storyboardNameForKeyboardType = [
		undefined,
		'alphabet',
		'numbersAndPunctuation',
		'URL',
		'numberPad',
		'phonePad',
		'namePhonePad',
		'emailAddress',
		'decimalPad',
		'twitter',
		'webSearch',
	];
	
	Object.defineProperty(UITextField.prototype, "keyboardType", {
	outlet: true, 
	enumerable: true, get:function () { return this._keyboardType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_keyboardType")) Object.defineProperty(this, "_keyboardType", { writable: true, configurable: true }); this._keyboardType = v; }});
	
	
	Object.defineProperty(UITextField.prototype, "keyboardTypeAsString", {
		set: function (v) {
			this.keyboardType = storyboardNameForKeyboardType.indexOf(v);
			if (this.keyboardType === -1) this.keyboardType = undefined;
		}, 
		get: function () {
			if (!this.keyboardType) return '';
			return storyboardNameForKeyboardType[this.keyboardType];
		}});
	
	
	
	var UIKeyboardAppearanceDefault = 0,
		UIKeyboardAppearanceDark = 1,
		UIKeyboardAppearanceLight = 2;

	var storyboardNameForKeyboardAppearance = [
		undefined,
		'alert',
		'light',
	];
	
	Object.defineProperty(UITextField.prototype, "keyboardAppearance", {
	outlet: true, 
	enumerable: true, get:function () { return this._keyboardAppearance; }, set:function (v) {if (!Object.hasOwnProperty(this, "_keyboardAppearance")) Object.defineProperty(this, "_keyboardAppearance", { writable: true, configurable: true }); this._keyboardAppearance = v; }});
	
	
	Object.defineProperty(UITextField.prototype, "keyboardAppearanceAsString", {
		set: function (v) {
			this.keyboardAppearance = storyboardNameForKeyboardAppearance.indexOf(v);
			if (this.keyboardAppearance === -1) this.keyboardAppearance = undefined;
		}, 
		get: function () {
			if (!this.keyboardAppearance) return '';
			return storyboardNameForKeyboardAppearance[this.keyboardAppearance];
		}});
	


	Object.defineProperty(UITextField.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['text', this.readableNameForProperty('text')],
				['placeholder', this.readableNameForProperty('placeholder')],
				['enabled', this.readableNameForProperty('enabled')]
			);
			return result;
		}});
	
	
UITextField.prototype.readableNameForProperty = function UITextField_readableNameForProperty(theProperty) {
		switch (theProperty) {
			case 'text': return LocalizedString('Text');
			case 'placeholder': return LocalizedString('Placeholder');
			case 'secureTextEntry': return LocalizedString('Make Text Unrecognizable');
			case 'enabled': return LocalizedString('Enabled');
			case 'hasBorderStyle': return LocalizedString('Has Border');
			case 'autocapitalizationType': return LocalizedString('Capitalize');
			case 'clearButtonMode': return LocalizedString('Clear Icon');
			case 'keyboardType': return LocalizedString('Keyboard');
			case 'keyboardAppearance': return LocalizedString('Appearance');
			case 'inputView': return LocalizedString('Keyboard Replacement');
			case 'backgroundColor': return LocalizedString('Background Color');
		}
		return __super.prototype.readableNameForProperty.call(this, theProperty);};
	

	Object.defineProperty(UITextField.prototype, "identifier", {
	outlet: true, 
	enumerable: true, get:function () { return this._identifier; }, set:function (v) {if (!Object.hasOwnProperty(this, "_identifier")) Object.defineProperty(this, "_identifier", { writable: true, configurable: true }); this._identifier = v; }});
	

	Object.defineProperty(UITextField.prototype, "heightIsEditable", {
		value: false});
	

	Object.defineProperty(UITextField.prototype, "outlineIconURL", {
		value: 'Resources/UITextField.png'});
	
	
	Object.defineProperty(UITextField.prototype, "hasBorderStyle", {
		get: function () {
			return !!this.borderStyle;
		}, 
		set: function (v) {
			if (v) this.borderStyle = UITextBorderStyleRoundedRect;
			else this.borderStyle = UITextBorderStyleNone;
			this.styleDefault();
		}});
	

	
	var UITextBorderStyleNone = 0,
	   UITextBorderStyleLine = 1,
	   UITextBorderStyleBezel = 2,
	   UITextBorderStyleRoundedRect = 3;

	Object.defineProperty(UITextField.prototype, "borderStyle", {
	outlet: true, 
	enumerable: true, get:function () { return this._borderStyle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_borderStyle")) Object.defineProperty(this, "_borderStyle", { writable: true, configurable: true }); this._borderStyle = v; }});
	


UITextField.prototype.editDefault = function UITextField_editDefault(editor) {
	
		
		var binding = this.bindingForKey('text');
		if (!binding || bindingShouldBeBidirectional(binding)) {
		}
		else {
			this.context.beep();
			return true;
		}
		
		return this.inputView.editDefault(editor, this.dataController);
};
	

UITextField.prototype.prepareForEditor = function UITextField_prepareForEditor(editor) {
	
		__super.prototype.prepareForEditor.call(this, editor);
	
		if (this.DOMNode)
		this.DOMNode.ondblclick = function () {
		
			if (editor.editedSubview === this.superview) {
				this.editDefault(editor);
			}
					
		}.bind(this);

		this.DOMNode.onclick = function (e) {
			if (editor.isActionClick(e)) this.action();
		}.bind(this);
		
		this.DOMNode.className += ' canClickInActionMode';
		
		this.observeObject(this.font);

		getPrototype(this.delegateUTI).addDataProviderToControl(this);
		};
	
	
	Object.defineProperty(UITextField.prototype, "delegateUTI", {
		get: function () {
			return 'info.appdoo-mac.TextFieldDelegate';
		}});
	

	Object.defineProperty(UITextField.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	
	
UITextField.prototype.unprepareForEditor = function UITextField_unprepareForEditor(editor) {
		__super.prototype.unprepareForEditor.call(this, editor);
		this.unobserveObject(this.font);};
	

UITextField.prototype.action = function UITextField_action() {
		this.editDefault(_context.editor);};
	
	
	var storyboardNameForBorderStyle = [
		undefined,
		'line',
		'bezel',
		'roundedRect'
	];

UITextField.prototype.transformData = function UITextField_transformData(data, transformer) {
	
		var result = __super.prototype.transformData.call(this, data, transformer);
		
		
		
		if (transformer.isXIBGenerator)
			result.borderStyle = storyboardNameForBorderStyle[data.borderStyle];
		else
			transformer.setIntegerProperty(result, 'borderStyle', data.borderStyle);

		transformer.setFontProperty(result, data.font, 0, data.fontFamily, true);
		
		if (!this.bindingForKey.call(data))
			transformer.setStringProperty(result, 'text', data.text, true);
		
		transformer.setBooleanProperty(result, 'enabled', data.enabled, true);
		transformer.setStringProperty(result, 'placeholder', data.placeholder, true);
		transformer.setFloatProperty(result, 'minimumFontSize', 17, true);

		if (transformer.isXIBGenerator) {
			result.textInputTraits = { key:"textInputTraits" };
		}
		
		
		if (data.secureTextEntry) {
			if (transformer.isXIBGenerator) {
				result.textInputTraits.secureTextEntry = transformer.transformBoolean(data.secureTextEntry);
			}
			else result.secureTextEntry = 1;
		}

		
		if (transformer.isXIBGenerator)
			result.textInputTraits.autocapitalizationType = storyboardNameForAutocapitalizationType[data.autocapitalizationType];
		else
			transformer.setIntegerProperty(result, '_traits.autocapitalizationType', data.autocapitalizationType); 

		
		if (transformer.isXIBGenerator)
			result.clearButtonMode = storyboardNameForViewMode[data.clearButtonMode];
		else
			transformer.setIntegerProperty(result, 'clearButtonMode', data.clearButtonMode);

		
		if (transformer.isXIBGenerator)
			result.textInputTraits.keyboardType = storyboardNameForKeyboardType[data.keyboardType];
		else
			transformer.setIntegerProperty(result, '_traits.keyboardType', data.keyboardType); 

		
		if (transformer.isXIBGenerator)
			result.textInputTraits.keyboardAppearance = storyboardNameForKeyboardAppearance[data.keyboardAppearance];
		else
			transformer.setIntegerProperty(result, '_traits.keyboardAppearance', data.keyboardAppearance); 
			
		if (!transformer.isXIBGenerator)
			result.contentVerticalAlignment = 0;
		
		
		if (data.dataProvider) {
			var dataProvider = transformer.addDataProviderToObject(result, data);
			transformer.registerInverseBinding(result, data, 'text', 'contents', data.dataProvider.$id, dataProvider);
		}
		
		
		if (data.inputViewProperty && data.$id != data.inputViewProperty) {
			
			
			transformer.setType(result, 'TextFieldInputViewSystem8Compatible');
			transformer.setReferenceProperty(result, 'inputView', data.$id, data.inputViewProperty);
			transformer.demandPlugin('info.appdoo-mac.TextFieldInputViewSystem8Compatible');
		}

		return result;};
	
	
UITextField.prototype.transformChangeForAppdooPreview = function UITextField_transformChangeForAppdooPreview(change, transformer, result) {

		switch (change.keyPath) {
		
			case 'CSSTextColor':
				result.keyPath = 'textColor';
				result.value = transformer.transformCSSColor(change.valueNow);
				return true;
				break;
			case 'text':
			case 'placeholder':
				result.keyPath = change.keyPath;
				result.value = transformer.transformString(change.valueNow);
				return true;
				break;
			case 'textAlignment':
				result.keyPath = change.keyPath;
				result.value = transformer.transformTextAlignment(change.valueNow);
				return true;
				break;
			case 'fontName':
				result.keyPath = 'font';
				result.value = transformer.transformFont(change.valueNow, this.fontSize);
				return true;
			case 'fontSize':
				result.keyPath = 'font';
				result.value = transformer.transformFont(this.fontName, change.valueNow);
				return true;
			case 'fontFamily':
				result.keyPath = 'font';
				result.value = transformer.transformFont(this.fontName, this.fontSize);
				return true;
		}
		
		return __super.prototype.transformChangeForAppdooPreview.call(this, change, transformer, result);};
	
	
UITextField.prototype.layoutSubviews = function UITextField_layoutSubviews() {
		__super.prototype.layoutSubviews.call(this);
		this.inputView.hidden = this.size.width < 30;};
	

	Object.defineProperty(UITextField.prototype, "displaysNoOutlineOnSelection", {
		value: true});
	
	
	Object.defineProperty(UITextField.prototype, "isFormElement", {
		value: true});
	
	
	Object.defineProperty(UITextField.prototype, "value", {
		get: function () { return this.text; }});
	
	

	Object.defineProperty(UITextField.prototype, "performableActions", {
		get: function () {
			return {
				'becomeFirstResponder': { name: LocalizedString('Set Focus'), }
			};
		}});
	

	Object.defineProperty(UITextField.prototype, "inputViewProperty", {
	outlet: true, 
	enumerable: true, get:function () { return this._inputViewProperty; }, set:function (v) {if (!Object.hasOwnProperty(this, "_inputViewProperty")) Object.defineProperty(this, "_inputViewProperty", { writable: true, configurable: true }); this._inputViewProperty = v; }});
	

UITextField.prototype.initPropertiesFromData = function UITextField_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("text")) this.text = data.text;
if (data.hasOwnProperty("placeholder")) this.placeholder = data.placeholder;
if (data.hasOwnProperty("secureTextEntry")) this.secureTextEntry = data.secureTextEntry;
if (data.hasOwnProperty("enabled")) this.enabled = data.enabled;
if (data.hasOwnProperty("font")) this.font = data.font;
if (data.hasOwnProperty("autocapitalizationType")) this.autocapitalizationType = data.autocapitalizationType;
if (data.hasOwnProperty("clearButtonMode")) this.clearButtonMode = data.clearButtonMode;
if (data.hasOwnProperty("keyboardType")) this.keyboardType = data.keyboardType;
if (data.hasOwnProperty("keyboardAppearance")) this.keyboardAppearance = data.keyboardAppearance;
if (data.hasOwnProperty("identifier")) this.identifier = data.identifier;
if (data.hasOwnProperty("borderStyle")) this.borderStyle = data.borderStyle;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
if (data.hasOwnProperty("inputViewProperty")) this.inputViewProperty = data.inputViewProperty;
};

UITextField.prototype.decodeData = function UITextField_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("font")) decoded.font = this.context.decodeObjectTree(data.font);
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

UITextField.prototype.encode = function UITextField_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._font && this._font.encode) {encoded.font = this.font.encode();
}if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

UITextField.prototype.encodeCloned = function UITextField_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._font && this._font.encode) {encoded.font = this.font.encodeCloned();
}if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

UITextField.prototype.expectedTypeForProperty = function UITextField_expectedTypeForProperty(key) {
	if (key === "text") return "String";
	if (key === "placeholder") return "String";
	if (key === "secureTextEntry") return "Boolean";
	if (key === "enabled") return "Boolean";
	if (key === "font") return "UIFont";
	if (key === "fontName") return "String";
	if (key === "fontFamily") return "String";
	if (key === "fontSize") return "Number";
	if (key === "inputView") return "Label";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "backgroundImage") return "SmartScalingImage";
	if (key === "encodesSubviews") return "";
	if (key === "inspectorProperties") return "";
	if (key === "autocapitalizationType") return "Number";
	if (key === "autocapitalizationTypeAsString") return "String";
	if (key === "clearButtonMode") return "Number";
	if (key === "clearButtonModeAsString") return "String";
	if (key === "keyboardType") return "Number";
	if (key === "keyboardTypeAsString") return "String";
	if (key === "keyboardAppearance") return "Number";
	if (key === "keyboardAppearanceAsString") return "String";
	if (key === "bindableProperties") return "";
	if (key === "identifier") return "String";
	if (key === "heightIsEditable") return "";
	if (key === "outlineIconURL") return "";
	if (key === "hasBorderStyle") return "Boolean";
	if (key === "borderStyle") return "Number";
	if (key === "delegateUTI") return "";
	if (key === "dataProvider") return "TextFieldDelegate";
	if (key === "displaysNoOutlineOnSelection") return "";
	if (key === "isFormElement") return "";
	if (key === "value") return "";
	if (key === "performableActions") return "";
	if (key === "inputViewProperty") return "String";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UITextField; }()));
registerType('info.appdoo-mac', (function () { function TextFieldDelegate() {} var __super = setSupertypeFromDomain(TextFieldDelegate, 'ControlDataProvider', 'info.appdoo-mac');

	Object.defineProperty(TextFieldDelegate.prototype, "propertiesForBindings", {
		value: ['text']});
	

	Object.defineProperty(TextFieldDelegate.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(TextFieldDelegate.prototype, "textFieldID", {
	outlet: true, 
	enumerable: true, get:function () { return this._textFieldID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_textFieldID")) Object.defineProperty(this, "_textFieldID", { writable: true, configurable: true }); this._textFieldID = v; }});
	
	
	Object.defineProperty(TextFieldDelegate.prototype, "mutable", {
		
		value: true});
	
	
TextFieldDelegate.prototype.expectedTypeForPropertyWithData = function TextFieldDelegate_expectedTypeForPropertyWithData(name, data) {
		if (name == 'contents.text') return 'String';
		return __super.prototype.expectedTypeForPropertyWithData.call(this, name, data);};
	

TextFieldDelegate.prototype.transformData = function TextFieldDelegate_transformData(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		transformer.setReferenceProperty(result, 'viewController', data.$id, transformer.currentViewControllerId);
		transformer.setReferenceProperty(result, 'control', data.$id, data.textFieldID);
		if (!transformer.isXIBGenerator)
			result.$needsViewControllerReference = true;
		return result;};
	

TextFieldDelegate.prototype.initPropertiesFromData = function TextFieldDelegate_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("textFieldID")) this.textFieldID = data.textFieldID;
};

TextFieldDelegate.prototype.decodeData = function TextFieldDelegate_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

TextFieldDelegate.prototype.encode = function TextFieldDelegate_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

TextFieldDelegate.prototype.encodeCloned = function TextFieldDelegate_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

TextFieldDelegate.prototype.expectedTypeForProperty = function TextFieldDelegate_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (key === "isPlugin") return "";
	if (key === "textFieldID") return "String";
	if (key === "mutable") return "Boolean";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TextFieldDelegate; }()));
registerType('info.appdoo-mac', (function () { function TextViewDelegate() {} var __super = setSupertypeFromDomain(TextViewDelegate, 'TextFieldDelegate', 'info.appdoo-mac');

TextViewDelegate.prototype.expectedTypeForProperty = function TextViewDelegate_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TextViewDelegate; }()));