
registerType('appdoo.iOS', (function () { function UITextView() {} var __super = setSupertypeFromDomain(UITextView, 'UITextField', 'appdoo.iOS');

UITextView.prototype.init = function UITextView_init() {
		__super.prototype.init.call(this);
		this.style({ overflowY: 'auto' });};
	

UITextView.prototype.createForSuperview = function UITextView_createForSuperview(superview) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: 240, height: 128 },
			position: { left: 0, top: 0 },
			autoresizingMask: 36,
			name: superview.context.nameForNewFormControl(this),
			backgroundColor : "rgba(255,255,255,0.0)"
		});
	};
	
	
	Object.defineProperty(UITextView.prototype, "backgroundColor", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_backgroundColor")) Object.defineProperty(this, "_backgroundColor", { writable: true, configurable: true });
			this._backgroundColor = v;
			this.style({ backgroundColor: v||'' });
		}, get:function () { return this._backgroundColor; }});
	

	Object.defineProperty(UITextView.prototype, "heightIsEditable", {
		value: true});
	

	Object.defineProperty(UITextView.prototype, "readableType", {
		get: function () {
			return LocalizedString('Multiline Text Field');
		}});
	

UITextView.prototype.createInputView = function UITextView__createInputView() {
		this.inputView = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			size: this.sizeCopy,
			autoresizingMask: 2,
			text: '',
			position: { top: 0, left: 0 },
			fontName: '_DEFAULT_',
			multiLine: true,
			layoutMode: 'autoFitHeight'})
		;
		this.addSubview(this.inputView);};
	

UITextView.prototype.styleDefaultSystem7 = function UITextView_styleDefaultSystem7() {
		this.inputView.fontSize = this.font.pointSize;
		this.inputView.fontName = this.font.fontName;
		this.inputView.position.left = 5;
		this.inputView.size.width = this.size.width - this.inputView.position.left*2;};
	

	Object.defineProperty(UITextView.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: this.readableNameForProperty('text'), keyPath: 'text', type: 'textarea', positionLeft: true },
						{ name: this.readableNameForProperty('enabled'), keyPath: 'enabled', type: 'boolean', positionLeft: true },

						{ type: 'space' },
						{ name: this.readableNameForProperty('autocapitalizationType'), keyPath: 'autocapitalizationTypeAsString', type: 'select', options:[
							['', LocalizedString('Don\'t')],
							['words', LocalizedString('All Words')],
							['sentences', LocalizedString('All Sentences')],
							['allCharacters', LocalizedString('All Characters')],
						] },
						{ name: this.readableNameForProperty('keyboardType'), keyPath: 'keyboardTypeAsString', type: 'select', options:[

							['',LocalizedString('Default')],
							['alphabet',LocalizedString('ASCII')],
							['numbersAndPunctuation',LocalizedString('Numbers and Punctuation')],
							['URL',LocalizedString('URL')],
							['numberPad',LocalizedString('Number Pad')],
							['phonePad',LocalizedString('Phone Pad')],
							['namePhonePad',LocalizedString('Name or Phone Number')],
							['emailAddress',LocalizedString('Email Address')],
							['decimalPad',LocalizedString('Decimal Pad')],
							['twitter',LocalizedString('Twitter')],
							['webSearch',LocalizedString('Web Search')],
						], marginTop:-3 },

						{ name: this.readableNameForProperty('keyboardAppearance'), keyPath: 'keyboardAppearanceAsString', type: 'select', options:[
							['', LocalizedString('Default Style')],
							['alert', LocalizedString('dark')],
							['light', LocalizedString('light')],
						], numberOfVisibleItems:1, showsIcons: false, marginTop:-3 },
						
					]
				},
				{
					type: 'group',
					title: LocalizedString('Font'),
					id: this.constructor.name+'Font',
					items: [
						{ type: 'font' },
						{ type: 'space' },
						{ type: 'fontSize', keyPath: 'fontSize' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
							{ name: LocalizedString('Background Color'), keyPath: 'backgroundColor', type: 'color', undefinedValue: 'rgba(255,255,255, 0.00)' },
		
					]
				},
		
			];

		}});
	
	
	Object.defineProperty(UITextView.prototype, "bindableProperties", {
		get: function () {
			return [
				['text', this.readableNameForProperty('text')],
				['enabled', this.readableNameForProperty('enabled')],
				['hidden', this.readableNameForProperty('hidden')],
				['backgroundColor', this.readableNameForProperty('backgroundColor')],
			];
		}});
	

	Object.defineProperty(UITextView.prototype, "outlineIconURL", {
		value: 'Resources/UITextView.png'});
	

	Object.defineProperty(UITextView.prototype, "delegateUTI", {
		get: function () { return 'info.appdoo-mac.TextViewDelegate'; }});
	

UITextView.prototype.initPropertiesFromData = function UITextView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("backgroundColor")) this.backgroundColor = data.backgroundColor;
};

UITextView.prototype.decodeData = function UITextView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

UITextView.prototype.encode = function UITextView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

UITextView.prototype.encodeCloned = function UITextView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

UITextView.prototype.expectedTypeForProperty = function UITextView_expectedTypeForProperty(key) {
	if (key === "backgroundColor") return "String";
	if (key === "heightIsEditable") return "";
	if (key === "readableType") return "";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "outlineIconURL") return "";
	if (key === "delegateUTI") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UITextView; }()));