
registerType('com.apple', (function () { function UIToolbar() {} var __super = setSupertypeFromDomain(UIToolbar, 'UIView', 'appdoo.iOS');

UIToolbar.prototype.init = function UIToolbar_init() {
		__super.prototype.init.call(this);

		this.hasDefaultColor = true;
		
		this.styleDefault();
		
		this.addItem(this.context.decodeObjectTree({
			$type: 'UIBarButtonItem',
			$domain: 'appdoo.iOS',
			systemItem: 'refresh'
		}));
		this.addItem(this.context.decodeObjectTree({
			$type: 'UIBarButtonItem',
			$domain: 'appdoo.iOS',
			systemItem: 'bookmarks'
		}));
		this.layoutSubviews();
		
		return this;};
	

	Object.defineProperty(UIToolbar.prototype, "tintColor", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_tintColor")) Object.defineProperty(this, "_tintColor", { writable: true, configurable: true });
			this._tintColor = v;
			this.styleDefault();
		}, get:function () { return this._tintColor; }});
	
	
UIToolbar.prototype.styleDefault = function UIToolbar_styleDefault() {
		getType('appdoo.iOS.StyleDecorator').prototype.styleBar(this);};
	

UIToolbar.prototype.createForSuperview = function UIToolbar_createForSuperview(superview) {
		
		return superview.context.decodeObjectTree({
				$type: this.constructor.name,
				$domain: this.__domain,
				size: { width: superview.size.width, height: 44 },
				position: { left: 0, top: 0 },
				autoresizingMask: 8
			});
};
	
	
	Object.defineProperty(UIToolbar.prototype, "readableValue", {
		get: function () {
			return LocalizedString('Toolbar');
		}});
	
	
	Object.defineProperty(UIToolbar.prototype, "encodesSubviews", {
		value: false});
	

	Object.defineProperty(UIToolbar.prototype, "heightIsEditable", {
		value: false});
	
	
	
UIToolbar.prototype.addItem = function UIToolbar__addItem(item) {
		this.addSubview(item.view);
		item.view.drawBackground();};
	

UIToolbar.prototype.layoutSubviews = function UIToolbar_layoutSubviews() {
		var x = 6;
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			subview.position.left = x;
			subview.position.top = this.size.height/2 - subview.size.height/2;
			x += subview.size.width + 10;return true; }, this);
		};
	

	Object.defineProperty(UIToolbar.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'UIToolbar',
					items: [
						{ name: LocalizedString('Tint Color'), keyPath: 'tintColor', type: 'color' },
					]
				}
			];
		}});
	
	
UIToolbar.prototype.initPropertiesFromData = function UIToolbar_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("tintColor")) this.tintColor = data.tintColor;
};

UIToolbar.prototype.decodeData = function UIToolbar_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

UIToolbar.prototype.encode = function UIToolbar_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

UIToolbar.prototype.encodeCloned = function UIToolbar_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

UIToolbar.prototype.expectedTypeForProperty = function UIToolbar_expectedTypeForProperty(key) {
	if (key === "tintColor") return "String";
	if (key === "readableValue") return "";
	if (key === "encodesSubviews") return "";
	if (key === "heightIsEditable") return "";
	if (key === "inspectorProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIToolbar; }()));