
registerType('appdoo.iOS', (function () { function UIView() {} var __super = setSupertypeFromDomain(UIView, 'View', 'Core.UI');

UIView.prototype.prepareForEditor = function UIView_prepareForEditor(editor) {};
	

UIView.prototype.unprepareForEditor = function UIView_unprepareForEditor(editor) {};
	

	Object.defineProperty(UIView.prototype, "tintColor", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_tintColor")) Object.defineProperty(this, "_tintColor", { writable: true, configurable: true });
			this._tintColor = v;
			this.updateSubviewsForTintColor(v);
		}, get:function () { return this._tintColor; }});
	

	Object.defineProperty(UIView.prototype, "tintColorOrDefault", {
		get: function () {
			return this.tintColor || this.context.defaultOrSystemTintColor;
		}});
	

UIView.prototype.updateSubviewsForTintColor = function UIView__updateSubviewsForTintColor(color) {
		this.superviewDidChangeTintColor(color);};
	
	
UIView.prototype.superviewDidChangeTintColor = function UIView__superviewDidChangeTintColor(color) {
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			if (subview.superviewDidChangeTintColor)
				subview.superviewDidChangeTintColor(color);return true; }, this);
		};
	

	Object.defineProperty(UIView.prototype, "clipsSubviews", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_clipsSubviews")) Object.defineProperty(this, "_clipsSubviews", { writable: true, configurable: true }); this._clipsSubviews = v; this.DOMNode.style.overflow = v ? 'hidden' : ''; }, get:function () { return this._clipsSubviews; }});
	

	Object.defineProperty(UIView.prototype, "clipsToBounds", {
		set: function (v) { this.clipsSubviews = v; }, 
		get: function () { return this.clipsSubviews; }});
	

	
	Object.defineProperty(UIView.prototype, "alpha", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_alpha")) Object.defineProperty(this, "_alpha", { writable: true, configurable: true }); if (isNaN(v)) v = 1; this._alpha = v; this.DOMNode.style.opacity = v; }, get:function () { return this._alpha; }});
	

	Object.defineProperty(UIView.prototype, "alpha100", {
		set: function (v) { this.alpha = v/100||0; }, 
		get: function () { if (isNaN(this.alpha)) return 100; return this.alpha*100; }});
	

	
	Object.defineProperty(UIView.prototype, "transform", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_transform")) Object.defineProperty(this, "_transform", { writable: true, configurable: true }); if (!v) v = ''; this._transform = v; this.DOMNode.style.webkitTransform = v; }, get:function () { return this._transform; }});
	

	Object.defineProperty(UIView.prototype, "userInteractionEnabled", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			return this._userInteractionEnabled !== false;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_userInteractionEnabled")) Object.defineProperty(this, "_userInteractionEnabled", { writable: true, configurable: true }); this._userInteractionEnabled = v; }});
	

	Object.defineProperty(UIView.prototype, "backgroundColor", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_backgroundColor")) Object.defineProperty(this, "_backgroundColor", { writable: true, configurable: true });
			this._backgroundColor = v;
			this.style({ backgroundColor: v||'' });
		}, get:function () { return this._backgroundColor; }});
	

	Object.defineProperty(UIView.prototype, "e_backgroundColor", {
		set: function (v) { this.backgroundColor = v; }, 
		get: function ( ) { return this.backgroundColor; }});
	
	
UIView.prototype.initFromData = function UIView_initFromData(data, nodeTag, holdBindings) {
		var frame = data.frame;
		if (frame) {
			if (frame.origin)
				data.position = { left: frame.origin.x, top: frame.origin.y };
			data.size = frame.size;
			delete data.frame;
		}
		return __super.prototype.initFromData.call(this, data, nodeTag, holdBindings);};
	
	

	

UIView.prototype.view_transformDataForXIB = function UIView_view_transformDataForXIB(data, transformer) {
 
		var result = {
			id: transformer.storyboardIDForObjectID(data.$id),
			userLabel: data.name||undefined,
			tag: transformer.tagForViewWithCID(data.$id)
		};
		
		if (data.frame) {
			result.rect = {
				x: data.frame.origin.x,
				y: data.frame.origin.y,
				width: Math.max(data.frame.size.width,1),
				height: Math.max(data.frame.size.height,1),
				key: 'frame'
			};
		} else {
			result.rect = this.transformPositionAndSize(
				data.position, data.size, 'frame');
		}
		
		result.autoresizingMask = this.transformAutoresizingMask(data.autoresizingMask || 36);
		
		if (data.backgroundColor) {
				result['color backgroundColor'] = transformer.transformCSSColor(
					data.backgroundColor, 'backgroundColor');
		}
		

		
		if (!result['color backgroundColor']) {
			result['color backgroundColor'] = transformer.transformCSSColor(
			'rgba(0, 0, 0, 0)', 'backgroundColor');
		}
		
		if (data.tintColor) {
			result['color tintColor'] = transformer.transformCSSColor(data.tintColor, 'tintColor');
		}
		
		
		if (!transformer.isTransformingRootView) {
			transformer.addOutletForDataAndId(data, result.id);
		}
		
		transformer.isTransformingRootView = false;
		
		if (this.encodesSubviews) {
			result.subviews = {};
			transformer.transformSubviews(data.subviews,
								result.subviews);
		}
		
		if (this.cocoaCustomTypeForData) {
			result.customClass = this.cocoaCustomTypeForData(data);
		}
		if (this.cocoaCustomType) {
			result.customClass = this.cocoaCustomType;
		}
		
		if (data.userInteractionEnabled !== undefined) {
			result.userInteractionEnabled = data.userInteractionEnabled;
		}

		if (!isNaN(data.alpha)) {
			result.alpha = data.alpha;
		}

		if (this.bindingForKey.call(data, 'hidden')) {
			transformer.setBooleanProperty(result, 'hidden', true);
		} else if (data.hidden) {
			transformer.setBooleanProperty(result, 'hidden', true);
		}
		
		return result;
};
	
	
UIView.prototype.cocoaCustomTypeForData = function UIView_cocoaCustomTypeForData(data) {
	
		var type = data.$type;

		if (type.indexOf('UI') === 0 ||
			type.indexOf('MK') === 0 ||
			type.indexOf('NS') === 0) return '';
		
		return type;
	};
	

UIView.prototype.view_transformDataForPreview = function UIView_view_transformDataForPreview(data, transformer, options) {
	
		var useDefaultInitializer = options&&options.useDefaultInitializer;
		var keepUIViewType = options&&options.keepUIViewType;

		if (!data.frame) {
			data.frame = { size: data.size||{width:0,height:0}, origin: data.position ? { x: data.position.left, y: data.position.top } : {x:0,y:0} };
		}
		
		var frame = transformer.transformCGRect(data.frame.origin.x, data.frame.origin.y, data.frame.size.width, data.frame.size.height);
		
		var result = {
			$type: keepUIViewType?'UIView':this.constructor.name,
			$domain: 'com.apple',
			$id: data.$id,
			autoresizingMask: data.autoresizingMask,
			contentMode: contentModeByName[data.contentMode],
			backgroundColor: transformer.transformCSSColor(data.backgroundColor),
			tintColor: transformer.transformCSSColor(data.tintColor),
			$extra: {  },
			$categories: [],
			$connections: [],
			tag: transformer.tagForViewWithCID(data.$id),
			$initialMethodCalls: [],
			$propertyPriorities: { }
		};
		
		if (useDefaultInitializer) {
			result.frame = frame;
		} else {
			result.$initializer = { name: 'initWithFrame:', arguments: [frame] };
		}
		
		if (data.subviews) {
			result.$extra.subviews = [];
			if (Array.isArray(data.subviews)) data.subviews.every(function (viewData) {
				var uti = utiFromData(viewData);
				var proto = getPrototype(uti);
				if (!transformer.checkCompatibility(proto, viewData)) return true;
				if (proto && proto.transformData) {
					var v = proto.transformData(viewData, transformer);
					if (v) result.$extra.subviews.push(v);
				}return true; }, this);
			
		}

		if (this.bindingForKey.call(data, 'hidden')) {
			result.hidden = true;
		} else if (data.hidden) {
			result.hidden = true;
		}
		
		if (!isNaN(data.alpha)) {
			result.alpha = data.alpha;
		}
		
		if (data.userInteractionEnabled !== undefined) {
			result.userInteractionEnabled = data.userInteractionEnabled;
		}
		
		return result;};
	

UIView.prototype.transformData = function UIView_transformData(data, transformer, options) {
		if (transformer.isXIBGenerator) {
			return this.view_transformDataForXIB(data, transformer, options);
		} else {
			return this.view_transformDataForPreview(data, transformer, options);
		}};
	
	
UIView.prototype.transformPositionAndSize = function UIView_transformPositionAndSize(position, size, key) {

		var rect = {
			key: key
		};

		if (position !== undefined) {
			rect.x = (position.left || 0);
			rect.y = (position.top || 0);
		}
		if (size !== undefined) {
			rect.width = Math.max(size.width || 0, 1);
			rect.height = Math.max(size.height || 0, 1);
		}
		
		return rect;
	};
	
	
UIView.prototype.transformAutoresizingMask = function UIView__transformAutoresizingMask(autoresizingMask) {

		var result = {
				key: 'autoresizingMask'
			};
		
		if (autoresizingMask) {
			
			if (autoresizingMask & (1 << 0)) {
				result.flexibleMinX = 'YES';
			}
			
			if (autoresizingMask & (1 << 2)) {
				result.flexibleMaxX = 'YES';
			}
			
			if (autoresizingMask & (1 << 3)) {
				result.flexibleMinY = 'YES';
			}
			
			if (autoresizingMask & (1 << 5)) {
				result.flexibleMaxY = 'YES';
			}
			
			if (autoresizingMask & (1 << 1)) {
				result.widthSizable = 'YES';
			}
			
			if (autoresizingMask & (1 << 4)) {
				result.heightSizable = 'YES';
			}
		}
		
		return result;
		};
	

	Object.defineProperty(UIView.prototype, "cocoaType", {
		get: function () {
			return this.constructor.name;
		}});
	
	
UIView.prototype.deleteForEditor = function UIView_deleteForEditor(editor) {
	
		if (this.subviews)
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			if (subview.deleteForEditor)
				subview.deleteForEditor(editor);return true; }, this);
		
	};
	
	
UIView.prototype.layoutRelationsDidChange = function UIView_layoutRelationsDidChange() {
		this.dataController.setValueForKeyPath(false, 'xIsEditable', this.dataController);};
	

	Object.defineProperty(UIView.prototype, "encodesStyles", {
		value: false});
	

	Object.defineProperty(UIView.prototype, "encodesSubviews", {
		value: false});
	

	Object.defineProperty(UIView.prototype, "frame", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_frame")) Object.defineProperty(this, "_frame", { writable: true, configurable: true });
			this.size = v.size;
			this.position = {
				left: v.origin.x,
				top: v.origin.y
			};
		}, 
		get: function () {
			return {
				origin: { x: this.position.left, y: this.position.top },
				size: { width: this.size.width, height: this.size.height }
			};
		}});
	
	


	
	Object.defineProperty(UIView.prototype, "canHaveLayoutRelations", {
		get: function () {
			return this.constructor.name !== 'UIView';
		}});
	


	
UIView.prototype.encode = function UIView_encode() {
		var data = __super.prototype.encode.call(this);
		delete data.size;
		delete data.position;
		return data;};
	

UIView.prototype.styleDefault = function UIView_styleDefault() {
		this.styleForState('default');};
	

UIView.prototype.styleSelected = function UIView_styleSelected() {
		this.styleForState('selected');};
	

UIView.prototype.styleForState = function UIView_styleForState(state) {
		var methodName = 'style'+ucfirst(state)+'System'+this.context.simulatedSystemVersion;
		if (this[methodName])
			this[methodName].call(this);};
	
	
	function ucfirst(str) { return str[0].toUpperCase() + str.substr(1); }

	Object.defineProperty(UIView.prototype, "rotationInDegrees", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_rotationInDegrees")) Object.defineProperty(this, "_rotationInDegrees", { writable: true, configurable: true });
			this._rotationInDegrees = v;
			this.style({ '-webkit-transform':v ? 'rotate(' + v + 'deg)':'' });
		}, get:function () { return this._rotationInDegrees; }});
	

	Object.defineProperty(UIView.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType||LocalizedString('View'),
					id: 'view',
					items: [
						{ name: LocalizedString('Background Color'), keyPath: 'e_backgroundColor', type: 'color', undefinedValue: 'rgba(255,255,255, 1)' },
					]
				}
			];
		}});
	

	Object.defineProperty(UIView.prototype, "name", {
	outlet: true, 
	enumerable: true, get:function () { return this._name; }, set:function (v) {if (!Object.hasOwnProperty(this, "_name")) Object.defineProperty(this, "_name", { writable: true, configurable: true }); this._name = v; }});
	

	Object.defineProperty(UIView.prototype, "e_name", {
		set: function (v) {
			this.name = v;
			this.readableValueDidChange(v);
		}, 
		get: function ( ) { return this.name; }});
	

	Object.defineProperty(UIView.prototype, "nameIsEditable", {
		value: true});
	

	Object.defineProperty(UIView.prototype, "placeholderLabel", {
	synthesized: true, get:function () { return this._placeholderLabel; }, set:function (v) {if (!Object.hasOwnProperty(this, "_placeholderLabel")) Object.defineProperty(this, "_placeholderLabel", { writable: true, configurable: true }); this._placeholderLabel = v; }});
	
	
UIView.prototype.showPlaceholder = function UIView__showPlaceholder() {
		if (this.placeholderLabel) return;
		this.placeholderLabel = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			text: this.readableValue,
			style: { textAlign: 'center', color: 'rgb(148,163,196)', textShadow: 'rgba(255,255,255,.3)', backgroundColor: '#d9e1f0' },
			size: { width: this.size.width, height: this.size.height },
			position: { left: 0, top: 0 },
			autoresizingMask: 18})
		;
		this.addSubview(this.placeholderLabel);};
	
	
UIView.prototype.hidePlaceholder = function UIView__hidePlaceholder() {
		if (!this.placeholderLabel) return;
		this.placeholderLabel.removeFromSuperview();
		this.placeholderLabel = null;};
	

UIView.prototype.readableNameForProperty = function UIView_readableNameForProperty(theProperty) {
		switch (theProperty) {
			case 'name': return LocalizedString('Name');
			case 'tintColor': return LocalizedString('Color');
			case 'backgroundColor': return LocalizedString('Background Color');
		}
		return __super.prototype.readableNameForProperty.call(this, theProperty);};
	

UIView.prototype.encodeCloned = function UIView_encodeCloned() {
		var data = __super.prototype.encodeCloned.call(this);
		
		
		if (this.cocoaTransformedEncodedData !== undefined) {
			data = this.cocoaTransformedEncodedData(data, true);
		}
		
		return data;};
	

UIView.prototype.encode = function UIView_encode() {
		var data = __super.prototype.encode.call(this);
		
		
		if (this.cocoaTransformedEncodedData !== undefined) {
			data = this.cocoaTransformedEncodedData(data, false);
		}
		
		return data;};
	

UIView.prototype.decodeData = function UIView_decodeData(data) {

		
		if (this.decodeCocoaTransformedData !== undefined) {
			data = this.decodeCocoaTransformedData(data);
		}

		var obj = __super.prototype.decodeData.call(this, data);
		return obj;};
	

	var contentModeByName = {'scaleToFill': 0, 'scaleAspectFit': 1, 'scaleAspectFill': 2, 'redraw': 3, 'center': 4, 'top': 5, 'bottom': 6, 'left': 7, 'right': 8, 'topLeft': 9, 'topRight':10, 'bottomLeft':11, 'bottomRight':12 };


UIView.prototype.transformChangeForAppdooPreview = function UIView_transformChangeForAppdooPreview(change, transformer, result) {

		var livePositionUpdate = false;
	
		if (change.keyPaths) {

			var frame = transformer.transformCGRect(0, 0, this.size.width, this.size.height);
			
			for (var keyPath in change.valuesNow) {
				if (keyPath === 'position.top') frame.origin.y = change.valuesNow[keyPath]-change.valuesBefore[keyPath];
				if (keyPath === 'position.left') frame.origin.x = change.valuesNow[keyPath]-change.valuesBefore[keyPath];
				if (keyPath === 'size.width') frame.size.width = change.valuesNow[keyPath];
				if (keyPath === 'size.height') frame.size.height = change.valuesNow[keyPath];
			}
			
			result.keyPath = 'frameWithOffset';
			result.value = frame;

			return true;
		}


		switch (change.keyPath) {
		
			case 'tintColor':
			case 'e_tintColor':
				result.keyPath = 'tintColor';
				result.value = transformer.transformCSSColor(change.valueNow);
				return true;
				break;
			case 'backgroundColor':
			case 'e_backgroundColor':
				result.keyPath = 'backgroundColor';
				result.value = transformer.transformCSSColor(change.valueNow);
				return true;
				break;
			case 'hidden':
				result.keyPath = change.keyPath;
				result.value = transformer.transformBoolean(change.valueNow);
				return true;
				break;
			case 'frame':
				result.idle = true;
				return true;
				break;
			case 'position.left':
			case 'position.top':
			case 'size.width':
			case 'size.height':
				result.idle = true;
				return true;
			case 'e_locked':
				return true;

		}
		
	};
	
	
	Object.defineProperty(UIView.prototype, "bindableProperties", {
		get: function () {
			return Object.getOwnPropertyDescriptor(__super.prototype, "bindableProperties").get.call(this);
		}});
	

UIView.prototype.outlineIconURLDidChange = function UIView__outlineIconURLDidChange() {
		this.context.broadcastValueChangeForKeyPathInObject('outlineIconURL', this, this);};
	

	Object.defineProperty(UIView.prototype, "heightIsEditable", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_heightIsEditable")) Object.defineProperty(this, "_heightIsEditable", { writable: true, configurable: true });
			if (this._heightIsEditable === v) return;
			this._heightIsEditable = v;
			if (this.dataController) {
				this.dataController.setValueForKeyPath(v, 'heightIsEditable', null, false);
			}
		}, 
		get: function () {
			if (this._heightIsEditable === undefined) return this.sizeIsEditable;
			else return this._heightIsEditable;
		}});
	

	CanvasRenderingContext2D.prototype.roundRect = function (x, y, w, h, r) {
	  if (w < 2 * r) r = w / 2;
	  if (h < 2 * r) r = h / 2;
	  this.beginPath();
	  this.moveTo(x+r, y);
	  this.arcTo(x+w, y,   x+w, y+h, r);
	  this.arcTo(x+w, y+h, x,   y+h, r);
	  this.arcTo(x,   y+h, x,   y,   r);
	  this.arcTo(x,   y,   x+w, y,   r);
	  this.closePath();
	  return this;
	}

UIView.prototype.createForSuperview = function UIView_createForSuperview(superview) {
		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			superview.context,
			{
				size: { width: 100, height: 100 }
			}
		);};
	

UIView.prototype.initPropertiesFromData = function UIView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("tintColor")) this.tintColor = data.tintColor;
if (data.hasOwnProperty("clipsSubviews")) this.clipsSubviews = data.clipsSubviews;
if (data.hasOwnProperty("alpha")) this.alpha = data.alpha;
if (data.hasOwnProperty("transform")) this.transform = data.transform;
if (data.hasOwnProperty("userInteractionEnabled")) this.userInteractionEnabled = data.userInteractionEnabled;
if (data.hasOwnProperty("backgroundColor")) this.backgroundColor = data.backgroundColor;
if (data.hasOwnProperty("frame")) this.frame = data.frame;
if (data.hasOwnProperty("rotationInDegrees")) this.rotationInDegrees = data.rotationInDegrees;
if (data.hasOwnProperty("name")) this.name = data.name;
if (data.hasOwnProperty("heightIsEditable")) this.heightIsEditable = data.heightIsEditable;
};

UIView.prototype.expectedTypeForProperty = function UIView_expectedTypeForProperty(key) {
	if (key === "tintColor") return "String";
	if (key === "tintColorOrDefault") return "String";
	if (key === "clipsSubviews") return "Boolean";
	if (key === "clipsToBounds") return "Boolean";
	if (key === "alpha") return "Number";
	if (key === "alpha100") return "Number";
	if (key === "transform") return "String";
	if (key === "userInteractionEnabled") return "Boolean";
	if (key === "backgroundColor") return "String";
	if (key === "e_backgroundColor") return "String";
	if (key === "cocoaType") return "";
	if (key === "encodesStyles") return "";
	if (key === "encodesSubviews") return "";
	if (key === "frame") return "";
	if (key === "canHaveLayoutRelations") return "";
	if (key === "rotationInDegrees") return "Number";
	if (key === "inspectorProperties") return "";
	if (key === "name") return "";
	if (key === "e_name") return "String";
	if (key === "nameIsEditable") return "";
	if (key === "placeholderLabel") return "";
	if (key === "bindableProperties") return "";
	if (key === "heightIsEditable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIView; }()));
registerType('appdoo.iOS', (function () { function UIControl() {} var __super = setSupertypeFromDomain(UIControl, 'UIView', 'appdoo.iOS');
	
	Object.defineProperty(UIControl.prototype, "enabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._enabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_enabled")) Object.defineProperty(this, "_enabled", { writable: true, configurable: true }); this._enabled = v; }});
	

UIControl.prototype.readableNameForProperty = function UIControl__readableNameForProperty(propertyName) {
		switch (propertyName) {
			case 'enabled': return LocalizedString('Enabled');
		}
		return __super.prototype.readableNameForProperty.call(this, propertyName);};
	

UIControl.prototype.initPropertiesFromData = function UIControl_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("enabled")) this.enabled = data.enabled;
};

UIControl.prototype.decodeData = function UIControl_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

UIControl.prototype.encode = function UIControl_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

UIControl.prototype.encodeCloned = function UIControl_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

UIControl.prototype.expectedTypeForProperty = function UIControl_expectedTypeForProperty(key) {
	if (key === "enabled") return "Boolean";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIControl; }()));