
registerType('appdoo.iOS', (function () { function ViewGroup() {} var __super = setSupertypeFromDomain(ViewGroup, 'UIView', 'appdoo.iOS');

ViewGroup.prototype.init = function ViewGroup_init() {
		__super.prototype.init.call(this);
		return this;};
	

ViewGroup.prototype.destroy = function ViewGroup_destroy() {
		if (this.layoutResolver) { this.layoutResolver.destroy(); this.layoutResolver = null; }
		__super.prototype.destroy.call(this);};
	

	Object.defineProperty(ViewGroup.prototype, "readableValue", {
		get: function () {
			return this.name || this.readableType;
		}});
	

	Object.defineProperty(ViewGroup.prototype, "outlineIconURL", {
		get: function () {
			return this.context.pathForResource('ViewGroup.png');
		}});
	

	Object.defineProperty(ViewGroup.prototype, "viewMayScroll", {
		value: true});
	
	
	Object.defineProperty(ViewGroup.prototype, "defaultBackgroundColor", {
		value: 'rgba(0,255,255,0)'});
	
	
	Object.defineProperty(ViewGroup.prototype, "nameIsEditable", {
		value: true});
	

	Object.defineProperty(ViewGroup.prototype, "inspectorProperties", {
		get: function () {
			var items = [];
		
			if (this.nameIsEditable)
				items.unshift({ name: LocalizedString('Name'), keyPath: 'e_name', placeholder: this.readableType });

			if (this.viewMayScroll !== false)
				items.push({label: LocalizedString('Scrolling'),  name: '  ↕  '+LocalizedString('vertically'), type: 'boolean', keyPath: 'v_scrollsVertically', forceLeftLabel:true },
						{ name: ' ↔ '+LocalizedString('horizontally'), type: 'boolean', keyPath: 'v_scrollsHorizontally',forceLeftLabel:true },
						
						{ type: 'space' });
						
			if (this.constructor.name === 'ViewGroup') {
				items.push({ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true }, { type: 'space' });
			}

			

			items.push({ name: LocalizedString('Background Color'), keyPath: 'e_backgroundColor', type: 'color',
				marginTop: 3 },
						{ type: 'space' });




			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'view',
					items: items
				}
			];
		}});
	
	
	Object.defineProperty(ViewGroup.prototype, "readableType", {
		get: function () { return LocalizedString('Group'); }});
	

	Object.defineProperty(ViewGroup.prototype, "name", {
	outlet: true, 
	enumerable: true, get:function () { return this._name; }, set:function (v) {if (!Object.hasOwnProperty(this, "_name")) Object.defineProperty(this, "_name", { writable: true, configurable: true }); this._name = v; }});
	

	Object.defineProperty(ViewGroup.prototype, "canClickThrough", {
	outlet: true, 
	enumerable: true, get:function () { return this._canClickThrough; }, set:function (v) {if (!Object.hasOwnProperty(this, "_canClickThrough")) Object.defineProperty(this, "_canClickThrough", { writable: true, configurable: true }); this._canClickThrough = v; }});
	

	Object.defineProperty(ViewGroup.prototype, "dataSourceId", {
	outlet: true, 
	synthesized: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_dataSourceId")) Object.defineProperty(this, "_dataSourceId", { writable: true, configurable: true });
			if (!v) return;
			this._dataSourceId = v;
			var ds = this.context.getLivingDataSourceWithId(v);
			if (ds) ds.delegate = this;
		}, get:function () { return this._dataSourceId; }});
	
	
ViewGroup.prototype.dataSourceDidChange = function ViewGroup_dataSourceDidChange(dataSource) {
		if (this.subviews)
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			subview.applyBindings();return true; }, this);
		};
	

ViewGroup.prototype.prepareForEditor = function ViewGroup_prepareForEditor(editor) {
		
		var node = this.node;

		if (!node) {
			console.error('Node not found:', this);
			console.trace();
			return;
		}
		node.isLeaf = false;
		node.removeAllChildNodes(editor);

		if (Array.isArray(clone(this.subviews).reverse())) clone(this.subviews).reverse().every(function (subview) {
			var childNode = node.addChildNodeWithRepresentedObject(subview, editor);
			editor.registerItem(subview, childNode);return true; }, this);
		
		
		this.DOMNode.ondblclick = function (e) {
			if (e.altKey) return;
			if (editor.editedSubview === this.superview) {
				this.editDefault(editor);
				e.stopPropagation();
			}
		}.bind(this);
		
		editor.addLayoutResolverForView(this, false);
		
		if (this.v_scrollsHorizontally || this.v_scrollsVertically) {
			this.DOMNode.scrollLeft = this.scrollLeft;
			this.DOMNode.scrollTop = this.scrollTop;
		}

		this.DOMNode.onscroll = function (e) {
			if (!this.DOMNode) return;
			if (window._context && _context.editor && _context.editor.manipulator) _context.editor.manipulator.updateSizeModifierButtons();
			this._scrollLeft = this.DOMNode.scrollLeft;
			this._scrollTop = this.DOMNode.scrollTop;
		}.bind(this);
};
	
	
ViewGroup.prototype.editDefault = function ViewGroup_editDefault(editor) {
		return editor.beginEditingSubview(this);};
	
	
	Object.defineProperty(ViewGroup.prototype, "encodesSubviews", {
		value: true});
	

ViewGroup.prototype.addSubview = function ViewGroup_addSubview(subview) {
		__super.prototype.addSubview.call(this, subview);};
	
	
	Object.defineProperty(ViewGroup.prototype, "v_scrollsVertically", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_v_scrollsVertically")) Object.defineProperty(this, "_v_scrollsVertically", { writable: true, configurable: true });
			this._v_scrollsVertically = v;
			this.styleForScrolling();

			if (v) {
			} else {
				this.DOMNode.scrollTop = 0;
			}

		}, get:function () { return this._v_scrollsVertically; }});
	

	Object.defineProperty(ViewGroup.prototype, "v_scrollsHorizontally", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_v_scrollsHorizontally")) Object.defineProperty(this, "_v_scrollsHorizontally", { writable: true, configurable: true });
			this._v_scrollsHorizontally = v;
			this.styleForScrolling();

			if (v) {
			} else {
				this.DOMNode.scrollLeft = 0;
			}

		}, get:function () { return this._v_scrollsHorizontally; }});
	
	
ViewGroup.prototype.styleForScrolling = function ViewGroup__styleForScrolling() {

			this.style({
				overflowY:this.v_scrollsVertically?'scroll':'',
				overflowX:this.v_scrollsHorizontally?'scroll':''
			});
	};
	

	Object.defineProperty(ViewGroup.prototype, "scrollLeft", {
	outlet: true, 
	enumerable: true, 
		get: function () { if (this._scrollLeft !== undefined) return this._scrollLeft; return this.DOMNode.scrollLeft; }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_scrollLeft")) Object.defineProperty(this, "_scrollLeft", { writable: true, configurable: true }); this._scrollLeft = v; this.DOMNode.scrollLeft = v; }});
	

	Object.defineProperty(ViewGroup.prototype, "scrollTop", {
	outlet: true, 
	enumerable: true, 
		get: function () { if (this._scrollTop !== undefined) return this._scrollTop; return this.DOMNode.scrollTop; }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_scrollTop")) Object.defineProperty(this, "_scrollTop", { writable: true, configurable: true }); this._scrollTop = v; this.DOMNode.scrollTop = v; }});
	
		
	Object.defineProperty(ViewGroup.prototype, "cocoaType", {
		value: 'UIScrollView'});
	

ViewGroup.prototype.cocoaCustomTypeForData = function ViewGroup_cocoaCustomTypeForData(data) {
		if (data.v_scrollsVertically || data.v_scrollsHorizontally) {
			return 'SimpleScrollView';
		}
		return '';};
	
	
ViewGroup.prototype.acceptsMemberWithUTI = function ViewGroup_acceptsMemberWithUTI(uti) {
		var p = getPrototype(uti);
		if (!p) return false;
		if (p.isStaticCell) return false;
		if (isKindOfType(p, getType('Core.UI.View'))) return true;
		return !!(p && p instanceof getType('Core.UI.View') && !p.isStaticCell);};
		

ViewGroup.prototype.transformData = function ViewGroup_transformData(data, transformer, options) {
		var result = __super.prototype.transformData.call(this, data, transformer, options||{ keepUIViewType: true });
		
		if (data.v_scrollsVertically || data.v_scrollsHorizontally) {
			transformer.setType(result, 'SimpleScrollView');
			transformer.demandPlugin('info.appdoo-mac.SimpleScrollView');
			transformer.setBooleanProperty(result, 'canScrollVertically', data.v_scrollsVertically);
			transformer.setBooleanProperty(result, 'canScrollHorizontally', data.v_scrollsHorizontally);
			transformer.setBooleanProperty(result, 'clipsToBounds', true, true);
		}
		
		return result;};
	

ViewGroup.prototype.generateLayoutCodeFromData = function ViewGroup_generateLayoutCodeFromData(data, propertyKeyPath, appGenerator) {

		if (data.v_scrollsVertically || data.v_scrollsHorizontally) {
			return '\t['+propertyKeyPath+' updateContentSizeDelayed];\n'
		}
		};
	
	
ViewGroup.prototype.initPropertiesFromData = function ViewGroup_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("name")) this.name = data.name;
if (data.hasOwnProperty("canClickThrough")) this.canClickThrough = data.canClickThrough;
if (data.hasOwnProperty("dataSourceId")) this.dataSourceId = data.dataSourceId;
if (data.hasOwnProperty("v_scrollsVertically")) this.v_scrollsVertically = data.v_scrollsVertically;
if (data.hasOwnProperty("v_scrollsHorizontally")) this.v_scrollsHorizontally = data.v_scrollsHorizontally;
if (data.hasOwnProperty("scrollLeft")) this.scrollLeft = data.scrollLeft;
if (data.hasOwnProperty("scrollTop")) this.scrollTop = data.scrollTop;
};

ViewGroup.prototype.decodeData = function ViewGroup_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ViewGroup.prototype.encode = function ViewGroup_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ViewGroup.prototype.encodeCloned = function ViewGroup_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ViewGroup.prototype.expectedTypeForProperty = function ViewGroup_expectedTypeForProperty(key) {
	if (key === "readableValue") return "";
	if (key === "outlineIconURL") return "";
	if (key === "viewMayScroll") return "";
	if (key === "defaultBackgroundColor") return "";
	if (key === "nameIsEditable") return "";
	if (key === "inspectorProperties") return "";
	if (key === "readableType") return "";
	if (key === "name") return "String";
	if (key === "canClickThrough") return "Boolean";
	if (key === "dataSourceId") return "";
	if (key === "encodesSubviews") return "";
	if (key === "v_scrollsVertically") return "";
	if (key === "v_scrollsHorizontally") return "";
	if (key === "scrollLeft") return "";
	if (key === "scrollTop") return "";
	if (key === "cocoaType") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ViewGroup; }()));