
registerType('appdoo.iOS', (function () { function iOSInstruction() {} var __super = setSupertypeFromDomain(iOSInstruction, 'BasicObject', 'Core');

	Object.defineProperty(iOSInstruction.prototype, "readableValue", {
		get: function () { return LocalizedString('Instruction'); }});
	

	Object.defineProperty(iOSInstruction.prototype, "outlineIconURL", {
		value: 'Resources/Procedure3.png'});
	
	
	Object.defineProperty(iOSInstruction.prototype, "enabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._enabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_enabled")) Object.defineProperty(this, "_enabled", { writable: true, configurable: true }); this._enabled = v; }});
	

iOSInstruction.prototype.createForContext = function iOSInstruction_createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
				enabled: true
			}
		);
};
	
	
	Object.defineProperty(iOSInstruction.prototype, "isProcedure", {
		value: true});
	

iOSInstruction.prototype.initPropertiesFromData = function iOSInstruction_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("enabled")) this.enabled = data.enabled;
};

iOSInstruction.prototype.decodeData = function iOSInstruction_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

iOSInstruction.prototype.encode = function iOSInstruction_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

iOSInstruction.prototype.encodeCloned = function iOSInstruction_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

iOSInstruction.prototype.expectedTypeForProperty = function iOSInstruction_expectedTypeForProperty(key) {
	if (key === "readableValue") return "";
	if (key === "outlineIconURL") return "";
	if (key === "enabled") return "";
	if (key === "isProcedure") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return iOSInstruction; }()));
registerType('info.appdoo-mac', (function () { function ShowAnotherSceneInstruction() {} var __super = setSupertypeFromDomain(ShowAnotherSceneInstruction, 'iOSInstruction', 'appdoo.iOS');

	Object.defineProperty(ShowAnotherSceneInstruction.prototype, "targetSceneID", {
	outlet: true, 
	enumerable: true, get:function () { return this._targetSceneID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_targetSceneID")) Object.defineProperty(this, "_targetSceneID", { writable: true, configurable: true }); this._targetSceneID = v; }});
	

	Object.defineProperty(ShowAnotherSceneInstruction.prototype, "modalTransitionStyle", {
	outlet: true, 
	enumerable: true, get:function () { return this._modalTransitionStyle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_modalTransitionStyle")) Object.defineProperty(this, "_modalTransitionStyle", { writable: true, configurable: true }); this._modalTransitionStyle = v; }});
	

	Object.defineProperty(ShowAnotherSceneInstruction.prototype, "transfersDataAsInput", {
	outlet: true, 
	enumerable: true, get:function () { return this._transfersDataAsInput; }, set:function (v) {if (!Object.hasOwnProperty(this, "_transfersDataAsInput")) Object.defineProperty(this, "_transfersDataAsInput", { writable: true, configurable: true }); this._transfersDataAsInput = v; }});
	

	Object.defineProperty(ShowAnotherSceneInstruction.prototype, "transferDataSourceID", {
	outlet: true, 
	enumerable: true, get:function () { return this._transferDataSourceID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_transferDataSourceID")) Object.defineProperty(this, "_transferDataSourceID", { writable: true, configurable: true }); this._transferDataSourceID = v; }});
	

	Object.defineProperty(ShowAnotherSceneInstruction.prototype, "readableValue", {
		get: function () { return LocalizedString('Show Another Screen'); }});
	
		
	Object.defineProperty(ShowAnotherSceneInstruction.prototype, "inspectorProperties", {
		get: function () {

			return [
		
				{
					type: 'group',
					title: this.readableValue,
					id: this.constructor.name,
					items: [
					
						{ type:'info', html: LocalizedString('This action navigates to another screen.'), left: 26, height: 46, showIcon: false },
						
						{ name: LocalizedString('Screen'), keyPath: 'targetSceneID',
							type: 'scene' },

						{ name: LocalizedString('Transition'), keyPath: 'modalTransitionStyle',
							type: 'select',
							options: [
								['0',LocalizedString('none')],
								['UIModalTransitionStyleCoverVertical',LocalizedString('Move In From the Right')],
								['UIModalTransitionStyleFlipHorizontal',LocalizedString('Rotate')],
								['UIModalTransitionStyleCrossDissolve',LocalizedString('Fade In')],
							],
							undefinedValue: '0',
						}
		
					]
				}
			];
		}});
	

ShowAnotherSceneInstruction.prototype.transformDataForObjectiveC = function ShowAnotherSceneInstruction_transformDataForObjectiveC(instruction, generator) {
		
		generator.demandPluginWithIdentifier('info.appdoo-mac.SystemActions');

		if (instruction.transfersDataAsInput && instruction.transferDataSourceID) {
			var dataSourceCodePath = generator.codePathForProjectID(instruction.transferDataSourceID);
			if (dataSourceCodePath) {
				return '[SystemActions goToScene:@"'+instruction.targetSceneID+'" fromController:self withContextData:'+dataSourceCodePath+'.contents animated:YES usingTransition:'+(instruction.modalTransitionStyle||-1)+'];';
			}
		}
		
		return '[SystemActions goToScene:@"'+instruction.targetSceneID+'" fromController:self usingTransition:'+(instruction.modalTransitionStyle||-1)+'];';
		};
	

ShowAnotherSceneInstruction.prototype.initPropertiesFromData = function ShowAnotherSceneInstruction_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("targetSceneID")) this.targetSceneID = data.targetSceneID;
if (data.hasOwnProperty("modalTransitionStyle")) this.modalTransitionStyle = data.modalTransitionStyle;
if (data.hasOwnProperty("transfersDataAsInput")) this.transfersDataAsInput = data.transfersDataAsInput;
if (data.hasOwnProperty("transferDataSourceID")) this.transferDataSourceID = data.transferDataSourceID;
};

ShowAnotherSceneInstruction.prototype.decodeData = function ShowAnotherSceneInstruction_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ShowAnotherSceneInstruction.prototype.encode = function ShowAnotherSceneInstruction_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ShowAnotherSceneInstruction.prototype.encodeCloned = function ShowAnotherSceneInstruction_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ShowAnotherSceneInstruction.prototype.expectedTypeForProperty = function ShowAnotherSceneInstruction_expectedTypeForProperty(key) {
	if (key === "targetSceneID") return "String";
	if (key === "modalTransitionStyle") return "Number";
	if (key === "transfersDataAsInput") return "Boolean";
	if (key === "transferDataSourceID") return "String";
	if (key === "readableValue") return "";
	if (key === "inspectorProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ShowAnotherSceneInstruction; }()));
registerType('info.appdoo-mac', (function () { function NavigateBackInstruction() {} var __super = setSupertypeFromDomain(NavigateBackInstruction, 'iOSInstruction', 'appdoo.iOS');

	Object.defineProperty(NavigateBackInstruction.prototype, "readableValue", {
		get: function () { return LocalizedString('Back'); }});
	

NavigateBackInstruction.prototype.transformDataForObjectiveC = function NavigateBackInstruction_transformDataForObjectiveC(instruction, generator) {
		
		generator.demandPluginWithIdentifier('info.appdoo-mac.SystemActions');

		return '[SystemActions navigateBackFromViewController:self];';};
	
	
NavigateBackInstruction.prototype.expectedTypeForProperty = function NavigateBackInstruction_expectedTypeForProperty(key) {
	if (key === "readableValue") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return NavigateBackInstruction; }()));
registerType('info.appdoo-mac', (function () { function PerformSelectorInstruction() {} var __super = setSupertypeFromDomain(PerformSelectorInstruction, 'iOSInstruction', 'appdoo.iOS');

	Object.defineProperty(PerformSelectorInstruction.prototype, "objectID", {
	outlet: true, 
	enumerable: true, get:function () { return this._objectID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_objectID")) Object.defineProperty(this, "_objectID", { writable: true, configurable: true }); this._objectID = v; }});
	

	Object.defineProperty(PerformSelectorInstruction.prototype, "selector", {
	outlet: true, 
	enumerable: true, get:function () { return this._selector; }, set:function (v) {if (!Object.hasOwnProperty(this, "_selector")) Object.defineProperty(this, "_selector", { writable: true, configurable: true }); this._selector = v; }});
	

	Object.defineProperty(PerformSelectorInstruction.prototype, "arguments", {
	outlet: true, 
	enumerable: true, get:function () { return this._arguments; }, set:function (v) {if (!Object.hasOwnProperty(this, "_arguments")) Object.defineProperty(this, "_arguments", { writable: true, configurable: true }); this._arguments = v; }});
	
	
PerformSelectorInstruction.prototype.transformDataForObjectiveC = function PerformSelectorInstruction_transformDataForObjectiveC(instruction, generator) {
	
		var object = _context.projectContext.connectableObjects[instruction.objectID];
		if (object && object.UTI === 'appdoo.iOS.ActionSet') {
			return object.transformDataForObjectiveC(object, generator);
		}

		if (object && object.transformDataForObjectiveC) {
			return object.transformDataForObjectiveC(object, generator);
		}

		var outletName = generator.codePathForProjectID(instruction.objectID);
		if (!outletName) return '// something went wrong here: the property was not found\n';
		if (!instruction.selector) return '// something went wrong here: the instruction has no selector\n';
		
		function timesCharExist(c) {var t=0,l=0,c=(c+'')[0];while(l=this.indexOf(c,l)+1)++t;return t};
		var numberOfColons = timesCharExist.call(instruction.selector, ':');
		
		if (numberOfColons === 0)
			return '['+outletName+' '+instruction.selector+'];';
		
		var selectorWithParameters = instruction.selector;
		
		if (selectorWithParameters[selectorWithParameters.length-1] === ':') {
			selectorWithParameters = selectorWithParameters+'sender';
		}
		else {
			for (var key in instruction.arguments) {
				if (selectorWithParameters.indexOf('<#'+key+'#>') === -1) continue;
				var value;
				if (key === 'view'||key.indexOf('View') !== -1||key.indexOf('Reference') !== -1) {
					value = generator.codePathForProjectIDOrNil(instruction.arguments[key]);
				}
				else if (key === 'dataSource') {
					if (instruction.arguments[key] === '$dynamic')
						value = '@{ @"contents": _inputData }';
					else
						value = generator.codePathForProjectIDOrNil(instruction.arguments[key]);
				}
				else if (key === 'dataSourceContents') {
					if (instruction.arguments[key] === '$dynamic')
						value = '_inputData';
					else {
						value = generator.codePathForProjectIDOrNil(instruction.arguments[key]);
						if (value !== 'nil') value += '.contents';
					}
				}
				else {
					value = generator.transformString(instruction.arguments[key]);
				}
				selectorWithParameters = selectorWithParameters.replace('<#'+key+'#>', value);
			}
		}
		
		var instruction = '['+outletName+' '+selectorWithParameters+'];';
		
		if (selectorWithParameters.indexOf(':<#') !== -1) {
			instruction = '// '+instruction;
		}
		
		return instruction;
};
	

PerformSelectorInstruction.prototype.initPropertiesFromData = function PerformSelectorInstruction_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("objectID")) this.objectID = data.objectID;
if (data.hasOwnProperty("selector")) this.selector = data.selector;
if (data.hasOwnProperty("arguments")) this.arguments = data.arguments;
};

PerformSelectorInstruction.prototype.decodeData = function PerformSelectorInstruction_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

PerformSelectorInstruction.prototype.encode = function PerformSelectorInstruction_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

PerformSelectorInstruction.prototype.encodeCloned = function PerformSelectorInstruction_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

PerformSelectorInstruction.prototype.expectedTypeForProperty = function PerformSelectorInstruction_expectedTypeForProperty(key) {
	if (key === "objectID") return "String";
	if (key === "selector") return "String";
	if (key === "arguments") return "Object";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return PerformSelectorInstruction; }()));