
window.iOS6SystemFont = 'HelveticaNeue';
window.iOS6SystemFontBold = 'HelveticaNeue-Bold';
window.iOS6SystemFontItalic = 'HelveticaNeue-Italic';
window.iOS7SystemFont = 'HelveticaNeue';
window.iOS7SystemFontBold = 'HelveticaNeue-Medium';
window.iOS7SystemFontItalic = 'HelveticaNeue-Italic';

window.realIOSFont = function (name) {
	if (!window._context || _context.projectContext.simulatedSystemVersion < 7) {
		if (name === '_DEFAULT_') return window.iOS6SystemFont;
		if (name === '_DEFAULT_BOLD_') return window.iOS6SystemFontBold;
		if (name === '_DEFAULT_ITALIC_') return window.iOS6SystemFontItalic;
	}
	else {
		if (name === '_DEFAULT_') return window.iOS7SystemFont;
		if (name === '_DEFAULT_BOLD_') return window.iOS7SystemFontBold;
		if (name === '_DEFAULT_ITALIC_') return window.iOS7SystemFontItalic;
	}
	return name;
};
window.firstChoiceForFontFamily = function (name, previousFontName) {
	var font;
	for (var i = 0, c = iOS6FontsByFamily.length; i < c; i++) {
		font = iOS6FontsByFamily[i];
		if (font.name === name) {
			if (previousFontName) {
				//console.log("previousFontName", previousFontName);

				if ((previousFontName.indexOf('-Italic') !== -1 || previousFontName.indexOf('-Oblique') !== -1)) {
					if (font.variants.Italic) return font.variants.Italic;
					if (font.variants.Oblique) return font.variants.Oblique;
				}
				if ((previousFontName.indexOf('-BoldItalic') !== -1 || previousFontName.indexOf('-BoldOblique') !== -1)) {
					if (font.variants['Bold Oblique']) return font.variants['Bold Oblique'];
					if (font.variants['Bold Italic']) return font.variants['Bold Italic'];
				}
				if (previousFontName.indexOf('-Bold') === previousFontName.length-5) {
					if (font.variants.Bold) return font.variants.Bold;
				}
			}
			if (font.variants.Regular) return font.variants.Regular;
			for (var psName in font.variants) { break; }
			return font.variants[psName];
		}
	}
};

window.regularVariantForFont = function (name) {
	var family = fontFamilyForFontNamed(name);
	if (!family) return name;
	if (name.indexOf('Condensed') !== -1 && family.variants.Condensed) return family.variants.Condensed;
	return family.variants.Regular || family.variants.Book || family.variants.Medium || family.variants.Light || name;
};

window.italicVariantForFont = function (name) {
	var family = fontFamilyForFontNamed(name+'Italic');
	if (family) return name+'Italic';

	var family = fontFamilyForFontNamed(name+'Oblique');
	if (family) return name+'Oblique';

	var family = fontFamilyForFontNamed(name);
	if (!family) return name;
	if (name.indexOf('Condensed') !== -1 && family.variants['Condensed Italic'])
		return family.variants['Condensed Italic'];
	return family.variants.Italic || family.variants.Oblique;
};

window.nonitalicVariantForFont = function (name) {
	if (name === '_DEFAULT_ITALIC_') return '_DEFAULT_';
	if (name === '_DEFAULT_BOLD_' || name === '_DEFAULT_') return name;
	name = name.replace(/Italic/g, '');
	name = name.replace(/Oblique/g, '');
	if (name[name.length-1] === '-') name = name.substr(0,name.length-1);

	var family = fontFamilyForFontNamed(name);
	if (family) return name;
	
	return regularVariantForFont(name);
}

window.boldVariantForFont = function (name) {
	if (name === '_DEFAULT_BOLD_') return name;
	if (name === '_DEFAULT_ITALIC_' || name === '_DEFAULT_') return '_DEFAULT_BOLD_';

	var family = fontFamilyForFontNamed(name);
	if (!family) return name;
	
	var newName;
	
	if (name.indexOf('Condensed') !== -1 && family.variants['Condensed Bold'])
		newName = family.variants['Condensed Bold'];

	else newName = family.variants.Bold || family.variants.SemiBold || family.variants.Medium || family.variants.Heavy || name;
	
	if (fontIsItalic(name)) {
		var family = fontFamilyForFontNamed(newName+'Italic');
		if (family) return newName+'Italic';

		var family = fontFamilyForFontNamed(newName+'Oblique');
		if (family) return newName+'Oblique';
	}
	return newName;
};

window.nonboldVariantForFont = function (name) {
	if (name === '_DEFAULT_BOLD_') return '_DEFAULT_';
	if (name === '_DEFAULT_ITALIC_' || name === '_DEFAULT_') return name;
	
	var newName = name;
	newName = newName.replace(/Bold/g, '');
	newName = newName.replace(/Medium/g, '');
	newName = newName.replace(/Heavy/g, '');
	newName = newName.replace(/Medium/g, '');
	newName = newName.replace(/Black/g, '');
	if (newName[newName.length-1] === '-') newName = newName.substr(0,newName.length-1);
	
	var family = fontFamilyForFontNamed(newName);
	if (family) return newName;

	return regularVariantForFont(name);
}

window.fontFamilyForFontNamed = function (name) {
	for (var i = 0, c = iOS6FontsByFamily.length; i < c; i++) {
		var font = iOS6FontsByFamily[i];
		for (var key in font.variants) {
			if (font.variants[key] === name)
				return font;
		}
	}
};

window.fontFamilyNameForFontNamed = function (name) {
	var family = fontFamilyForFontNamed(name);
	if (family) return family.name;
};

window.fontFamilyNamed = function (name) {
	var font;
	for (var i = 0, c = iOS6FontsByFamily.length; i < c; i++) {
		font = iOS6FontsByFamily[i];
		if (font.name === name) {
			return font;
		}
	}
};

window.fontIsBold = function (name) {
	if (name === '_DEFAULT_BOLD_') return true;
	if (name.indexOf('Bold') !== -1) return true;
	if (name.indexOf('Heavy') !== -1) return true;
	if (name.indexOf('Black') !== -1) return true;
	return false;
};

window.fontIsItalic = function (name) {
	if (name === '_DEFAULT_ITALIC_') return true;
	if (name.indexOf('Italic') !== -1) return true;
	if (name.indexOf('Oblique') !== -1) return true;
	return false;
};

window.iOS6FontsByFamily = [
	{
		"name": "System",
		"variants": {
			"Regular": "_DEFAULT_",
			"Bold": "_DEFAULT_BOLD_",
			"Italic": "_DEFAULT_ITALIC_"
		}
	},
	{
		"name": "Academy Engraved LET",
		"variants": {
			"Regular": "AcademyEngravedLetPlain"
		}
	},
	{
		"name": "American Typewriter",
		"variants": {
			"Regular": "AmericanTypewriter",
			"Bold": "AmericanTypewriter-Bold",
			"Light": "AmericanTypewriter-Light",
			"Condensed": "AmericanTypewriter-Condensed",
			"Condensed Bold": "AmericanTypewriter-CondensedBold",
			"Condensed Light": "AmericanTypewriter-CondensedLight"
		}
	},
	{
		"name": "Apple SD Gothic Neo",
		"variants": {
			"Medium": "AppleSDGothicNeo-Medium",
			"Bold": "AppleSDGothicNeo-Bold"
		}
	},
	{
		"name": "Arial",
		"variants": {
			"Regular": "ArialMT",
			"Bold": "Arial-BoldMT",
			"Italic": "Arial-ItalicMT",
			"Bold Italic": "Arial-BoldItalicMT",
		}
	},
	{
		"name": "Arial Hebrew",
		"variants": {
			"Regular": "ArialHebrew",
			"Bold": "ArialHebrew-Bold",
		}
	},
	{
		"name": "Arial Rounded",
		"variants": {
			"Bold": "ArialRoundedMTBold",
		}
	},
	{
		"name": "Avenir",
		"variants": {
			"Light": "Avenir-Light",
			"Light Oblique": "Avenir-LightOblique",
			"Book": "Avenir-Book",
			"Book Oblique": "Avenir-BookOblique",
			"Roman": "Avenir-Roman",
			"Medium": "Avenir-Medium",
			"Medium Oblique": "Avenir-MediumOblique",
			"Black": "Avenir-Black",
			"Black Oblique": "Avenir-BlackOblique",
			"Heavy": "Avenir-Heavy",
			"Heavy Oblique": "Avenir-HeavyOblique",
		}
	},
	{
		"name": "Avenir Next",
		"variants": {
			"Ultra Light": "AvenirNext-UltraLight",
			"Ultra Light Italic": "AvenirNext-UltraLightItalic",
			"Regular": "AvenirNext-Regular",
			"Italic": "AvenirNext-Italic",
			"Medium": "AvenirNext-Medium",
			"Medium Italic": "AvenirNext-MediumItalic",
			"Demi Bold": "AvenirNext-DemiBold",
			"Demi Bold Italic": "AvenirNext-DemiBoldItalic",
			"Bold": "AvenirNext-Bold",
			"Bold Italic": "AvenirNext-BoldItalic",
			"Heavy": "AvenirNext-Heavy",
			"Heavy Italic": "AvenirNext-HeavyItalic",
		}
	},
	{
		"name": "Avenir Next Condensed",
		"variants": {
			"Ultra Light": "AvenirNextCondensed-UltraLight",
			"Ultra Light Italic": "AvenirNextCondensed-UltraLightItalic",
			"Regular": "AvenirNextCondensed-Regular",
			"Italic": "AvenirNextCondensed-Italic",
			"Medium": "AvenirNextCondensed-Medium",
			"Medium Italic": "AvenirNextCondensed-MediumItalic",
			"Bold": "AvenirNextCondensed-Bold",
			"Bold Italic": "AvenirNextCondensed-BoldItalic",
			"Demi Bold": "AvenirNextCondensed-DemiBold",
			"Demi Bold Italic": "AvenirNextCondensed-DemiBoldItalic",
			"Heavy": "AvenirNextCondensed-Heavy",
			"Heavy Italic": "AvenirNextCondensed-HeavyItalic",
		},
	},
	{
		"name": "Bangla Sangam MN",
		"variants": {
			"Regular": "BanglaSangamMN",
			"Bold": "BanglaSangamMN-Bold",
		}
	},
	{
		"name": "Baskerville",
		"variants": {
			"Regular": "Baskerville",
			"Bold": "Baskerville-Bold",
			"Bold Italic": "Baskerville-BoldItalic",
			"Italic": "Baskerville-Italic",
			"SemiBold": "Baskerville-SemiBold",
			"SemiBold Italic": "Baskerville-SemiBoldItalic",
		}
	},
	{
		"name": "Bodoni Ornaments",
		"variants": {
			"Regular": "BodoniOrnamentsITCTT",
		}
	},
	{
		"name": "Bodoni Seventy Two",
		"variants": {
			"Book": "BodoniSvtyTwoITCTT-Book",
			"Book OS": "BodoniSvtyTwoOSITCTT-Book",
			"Book SC": "BodoniSvtyTwoSCITCTT-Book",
			"Book Italic": "BodoniSvtyTwoITCTT-BookIta",
			"Book Italic OS": "BodoniSvtyTwoOSITCTT-BookIt",
			"Bold": "BodoniSvtyTwoITCTT-Bold",
			"Bold OS": "BodoniSvtyTwoOSITCTT-Bold"
		}
	},
	{
		"name": "Bradley Hand",
		"variants": {
			"Bold": "BradleyHandITCTT-Bold",
		}
	},
	{
		"name": "Chalkboard",
		"variants": {
			"Light": "ChalkboardSE-Light",
			"Regular": "ChalkboardSE-Regular",
			"Bold": "ChalkboardSE-Bold",
		}
	},
	{
		"name": "Chalkduster",
		"variants": {
			"Regular": "Chalkduster"
		}
	},
	{
		"name": "Cochin",
		"variants": {
			"Regular": "Cochin",
			"Italic": "Cochin-Italic",
			"Bold": "Cochin-Bold",
			"Bold Italic": "Cochin-BoldItalic",
		}
	},
	{
		"name": "Copperplate",
		"variants": {
			"Light": "Copperplate-Light",
			"Regular": "Copperplate",
			"Bold": "Copperplate-Bold",
		}
	},
	{
		"name": "Courier",
		"variants": {
			"Regular": "Courier",
			"Oblique": "Courier-Oblique",
			"Bold": "Courier-Bold",
			"Bold Oblique": "Courier-BoldOblique",
		}
	},
	{
		"name": "Courier New",
		"variants": {
			"Regular": "CourierNewPSMT",
			"Italic": "CourierNewPS-ItalicMT",
			"Bold": "CourierNewPS-BoldMT",
			"Bold Italic": "CourierNewPS-BoldItalicMT",
		}
	},
	{
		"name": "DB LCD Temp",
		"variants": {
			"Black": "DBLCDTempBlack",
		}
	},
	{
		"name": "Devanagari Sangam",
		"variants": {
			"Regular": "DevanagariSangamMN",
			"Bold": "DevanagariSangamMN-Bold",
		}
	},
	{
		"name": "Didot",
		"variants": {
			"Regular": "Didot",
			"Italic": "Didot-Italic",
			"Bold": "Didot-Bold",
		}
	},
	{
		"name": "Euphemia",
		"variants": {
			"Regular": "EuphemiaUCAS",
			"Italic": "EuphemiaUCAS-Italic",
			"Bold": "EuphemiaUCAS-Bold",
		}
	},
	{
		"name": "Futura",
		"variants": {
			"Medium": "Futura-Medium",
			"Medium Italic": "Futura-MediumItalic",
			"Condensed Medium": "Futura-CondensedMedium",
			"Condensed ExtraBold": "Futura-CondensedExtraBold",
		}
	},
	{
		"name": "Geeza Pro",
		"variants": {
			"Regular": "GeezaPro",
			"Bold": "GeezaPro-Bold",
		}
	},
	{
		"name": "Georgia",
		"variants": {
			"Regular": "Georgia",
			"Italic": "Georgia-Italic",
			"Bold": "Georgia-Bold",
			"Bold Italic": "Georgia-BoldItalic",
		}
	},
	{
		"name": "Gill Sans",
		"variants": {
			"Light": "GillSans-Light",
			"Light Italic": "GillSans-LightItalic",
			"Regular": "GillSans",
			"Italic": "GillSans-Italic",
			"Bold": "GillSans-Bold",
			"Bold Italic": "GillSans-BoldItalic",
		}
	},
	{
		"name": "Gujarati Sangam",
		"variants": {
			"Regular": "GujaratiSangamMN",
			"Bold": "GujaratiSangamMN-Bold",
		}
	},
	{
		"name": "Gurmukhi",
		"variants": {
			"Regular": "GurmukhiMN",
			"Bold": "GurmukhiMN-Bold",
		}
	},
	{
		"name": "ST Heiti",
		"variants": {
			"Light SC": "STHeitiSC-Light",
			"Light TC": "STHeitiTC-Light",
			"Medium SC": "STHeitiSC-Medium",
			"Medium TC": "STHeitiTC-Medium",
		}
	},
	{
		"name": "Helvetica",
		"variants": {
			"Light": "Helvetica-Light",
			"Light Oblique": "Helvetica-LightOblique",
			"Regular": "Helvetica",
			"Oblique": "Helvetica-Oblique",
			"Bold": "Helvetica-Bold",
			"Bold Oblique": "Helvetica-BoldOblique",
		}
	},
	{
		"name": "Helvetica Neue",
		"variants": {
			"UltraLight": "HelveticaNeue-UltraLight",
			"UltraLight Italic": "HelveticaNeue-UltraLightItalic",
			"Light": "HelveticaNeue-Light",
			"Light Italic": "HelveticaNeue-LightItalic",
			"Regular": "HelveticaNeue",
			"Italic": "HelveticaNeue-Italic",
			"Medium": "HelveticaNeue-Medium",
			"Bold": "HelveticaNeue-Bold",
			"Bold Italic": "HelveticaNeue-BoldItalic",
			"Condensed Bold": "HelveticaNeue-CondensedBold",
			"Condensed Black": "HelveticaNeue-CondensedBlack",
		}
	},
	{
		"name": "Hiragino Kaku Gothic ProN",
		"variants": {
			"W3": "HiraKakuProN-W3",
			"W6": "HiraKakuProN-W6",
		}
	},
	{
		"name": "Hiragino Mincho ProN",
		"variants": {
			"W3": "HiraMinProN-W3",
			"W6": "HiraMinProN-W6",
		}
	},
	{
		"name": "Hoefler Text",
		"variants": {
			"Regular": "HoeflerText-Regular",
			"Italic": "HoeflerText-Italic",
			"Black": "HoeflerText-Black",
			"Black Italic": "HoeflerText-BlackItalic",
		}
	},
	{
		"name": "Kailasa",
		"variants": {
			"Regular": "Kailasa",
		}
	},
	{
		"name": "Kannada Sangam MN",
		"variants": {
			"Regular": "KannadaSangamMN",
			"Bold": "KannadaSangamMN-Bold",
		}
	},
	{
		"name": "Malayalam Sangam MN",
		"variants": {
			"Regular": "MalayalamSangamMN",
			"Bold": "MalayalamSangamMN-Bold",
		}
	},
	{
		"name": "Marion",
		"variants": {
			"Regular": "Marion-Regular",
			"Italic": "Marion-Italic",
			"Bold": "Marion-Bold",
		}
	},
	{
		"name": "Marker Felt",
		"variants": {
			"Thin": "MarkerFelt-Thin",
			"Wide": "MarkerFelt-Wide",
		}
	},
	{
		"name": "Noteworthy",
		"variants": {
			"Light": "Noteworthy-Light",
			"Bold": "Noteworthy-Bold",
		}
	},
	{
		"name": "Optima",
		"variants": {
			"Regular": "Optima-Regular",
			"Italic": "Optima-Italic",
			"Bold": "Optima-Bold",
			"Bold Italic": "Optima-BoldItalic",
			"ExtraBlack": "Optima-ExtraBlack",
		}
	},
	{
		"name": "Oriya Sangam MN",
		"variants": {
			"Regular": "OriyaSangamMN",
			"Bold": "OriyaSangamMN-Bold",
		}
	},
	{
		"name": "Palatino",
		"variants": {
			"Regular": "Palatino-Roman",
			"Italic": "Palatino-Italic",
			"Bold": "Palatino-Bold",
			"Bold Italic": "Palatino-BoldItalic",
		}
	},
	{
		"name": "Papyrus",
		"variants": {
			"Regular": "Papyrus",
			"Condensed": "Papyrus-Condensed",
		}
	},
	{
		"name": "Party LET Plain",
		"variants": {
			"Regular": "PartyLetPlain",
		}
	},
	{
		"name": "Sinhala Sangam MN",
		"variants": {
			"Regular": "SinhalaSangamMN",
			"Bold": "SinhalaSangamMN-Bold",
		}
	},
	{
		"name": "Snell Roundhand",
		"variants": {
			"Regular": "SnellRoundhand",
			"Black": "SnellRoundhand-Black",
			"Bold": "SnellRoundhand-Bold",
		}
	},
	{
		"name": "Symbol",
		"variants": {
			"Regular": "Symbol",
		}
	},
	{
		"name": "Tamil Sangam MN",
		"variants": {
			"Regular": "TamilSangamMN",
			"Bold": "TamilSangamMN-Bold",
		}
	},
	{
		"name": "Telugu Sangam MN",
		"variants": {
			"Regular": "TeluguSangamMN",
			"Bold": "TeluguSangamMN-Bold",
		}
	},
	{
		"name": "Thonburi",
		"variants": {
			"Regular": "Thonburi",
			"Bold": "Thonburi-Bold",
		}
	},
	{
		"name": "Times New Roman",
		"variants": {
			"Regular": "TimesNewRomanPSMT",
			"Italic": "TimesNewRomanPS-ItalicMT",
			"Bold": "TimesNewRomanPS-BoldMT",
			"Bold Italic": "TimesNewRomanPS-BoldItalicMT",
		}
	},
	{
		"name": "Trebuchet MS",
		"variants": {
			"Regular": "TrebuchetMS",
			"Italic": "TrebuchetMS-Italic",
			"Bold": "TrebuchetMS-Bold",
		}
	},
	{
		"name": "Verdana",
		"variants": {
			"Regular": "Verdana",
			"Italic": "Verdana-Italic",
			"Bold": "Verdana-Bold",
			"Bold Italic": "Verdana-BoldItalic",
		}
	},
	{
		"name": "Zapf Dingbats",
		"variants": {
			"Regular": "ZapfDingbatsITC",
		}
	},
	{
		"name": "Zapfino",
		"variants": {
			"Regular": "Zapfino",
		}
	},
];


window.iOS6Fonts = [
	[
		"_DEFAULT_",
		"System"
	],
	[
		"_DEFAULT_BOLD_",
		"System Bold"
	],
	'-',
	[
		"AcademyEngravedLetPlain",
		"Academy Engraved LET"
	],
	[
		"AmericanTypewriter",
		"American Typewriter"
	],
	[
		"AmericanTypewriter-Bold",
		"American Typewriter Bold"
	],
	[
		"AmericanTypewriter-Condensed",
		"American Typewriter Condensed"
	],
	[
		"AmericanTypewriter-CondensedBold",
		"American Typewriter Condensed Bold"
	],
	[
		"AmericanTypewriter-CondensedLight",
		"American Typewriter Condensed Light"
	],
	[
		"AmericanTypewriter-Light",
		"American Typewriter Light"
	],
	[
		"AppleSDGothicNeo-Bold",
		"Apple SD Gothic Neo Bold"
	],
	[
		"AppleSDGothicNeo-Medium",
		"Apple SD Gothic Neo Medium"
	],
	[
		"ArialMT",
		"Arial"
	],
	[
		"Arial-BoldItalicMT",
		"Arial Bold Italic"
	],
	[
		"Arial-BoldMT",
		"Arial Bold"
	],
	[
		"Arial-ItalicMT",
		"Arial Italic"
	],
	[
		"ArialHebrew",
		"Arial Hebrew"
	],
	[
		"ArialHebrew-Bold",
		"Arial Hebrew Bold"
	],
	[
		"ArialRoundedMTBold",
		"Arial Rounded Bold"
	],
	[
		"Avenir-Black",
		"Avenir Black"
	],
	[
		"Avenir-BlackOblique",
		"Avenir Black Oblique"
	],
	[
		"Avenir-Book",
		"Avenir Book"
	],
	[
		"Avenir-BookOblique",
		"Avenir Book Oblique"
	],
	[
		"Avenir-Heavy",
		"Avenir Heavy"
	],
	[
		"Avenir-HeavyOblique",
		"Avenir Heavy Oblique"
	],
	[
		"Avenir-Light",
		"Avenir Light"
	],
	[
		"Avenir-LightOblique",
		"Avenir Light Oblique"
	],
	[
		"Avenir-Medium",
		"Avenir Medium"
	],
	[
		"Avenir-MediumOblique",
		"Avenir Medium Oblique"
	],
	[
		"Avenir-Oblique",
		"Avenir Oblique"
	],
	[
		"Avenir-Roman",
		"Avenir Roman"
	],
	[
		"AvenirNext-Bold",
		"Avenir Next Bold"
	],
	[
		"AvenirNext-BoldItalic",
		"Avenir Next Bold Italic"
	],
	[
		"AvenirNext-DemiBold",
		"Avenir Next Demi Bold"
	],
	[
		"AvenirNext-DemiBoldItalic",
		"Avenir Next Demi Bold Italic"
	],
	[
		"AvenirNext-Heavy",
		"Avenir Next Heavy"
	],
	[
		"AvenirNext-HeavyItalic",
		"Avenir Next Heavy Italic"
	],
	[
		"AvenirNext-Italic",
		"Avenir Next Italic"
	],
	[
		"AvenirNext-Medium",
		"Avenir Next Medium"
	],
	[
		"AvenirNext-MediumItalic",
		"Avenir Next Medium Italic"
	],
	[
		"AvenirNext-Regular",
		"Avenir Next Regular"
	],
	[
		"AvenirNext-UltraLight",
		"Avenir Next Ultra Light"
	],
	[
		"AvenirNext-UltraLightItalic",
		"Avenir Next Ultra Light Italic"
	],
	[
		"AvenirNextCondensed-Bold",
		"Avenir Next Condensed Bold"
	],
	[
		"AvenirNextCondensed-BoldItalic",
		"Avenir Next Condensed Bold Italic"
	],
	[
		"AvenirNextCondensed-DemiBold",
		"Avenir Next Condensed Demi Bold"
	],
	[
		"AvenirNextCondensed-DemiBoldItalic",
		"Avenir Next Condensed Demi Bold"
	],
	[
		"AvenirNextCondensed-Heavy",
		"Avenir Next Condensed Heavy"
	],
	[
		"AvenirNextCondensed-HeavyItalic",
		"Avenir Next Condensed Heavy"
	],
	[
		"AvenirNextCondensed-Italic",
		"Avenir Next Condensed Italic"
	],
	[
		"AvenirNextCondensed-Medium",
		"Avenir Next Condensed Medium"
	],
	[
		"AvenirNextCondensed-MediumItalic",
		"Avenir Next Condensed Medium Italic"
	],
	[
		"AvenirNextCondensed-Regular",
		"Avenir Next Condensed Regular"
	],
	[
		"AvenirNextCondensed-UltraLight",
		"Avenir Next Condensed Ultra Light"
	],
	[
		"AvenirNextCondensed-UltraLightItalic",
		"Avenir Next Condensed Ultra Light Italic"
	],
	[
		"BanglaSangamMN",
		"Bangla Sangam MN"
	],
	[
		"BanglaSangamMN-Bold",
		"Bangla Sangam MN Bold"
	],
	[
		"Baskerville",
		"Baskerville"
	],
	[
		"Baskerville-Bold",
		"Baskerville Bold"
	],
	[
		"Baskerville-BoldItalic",
		"Baskerville Bold Italic"
	],
	[
		"Baskerville-Italic",
		"Baskerville Italic"
	],
	[
		"Baskerville-SemiBold",
		"Baskerville Semi Bold"
	],
	[
		"Baskerville-SemiBoldItalic",
		"Baskerville Semi Bold Italic"
	],
	[
		"BodoniOrnamentsITCTT",
		"Bodoni Ornaments ITC TT"
	],
	[
		"BodoniSvtyTwoITCTT-Bold",
		"Bodoni Svty Two ITC TT Bold"
	],
	[
		"BodoniSvtyTwoITCTT-Book",
		"Bodoni Svty Two ITC TT Book"
	],
	[
		"BodoniSvtyTwoITCTT-BookIta",
		"Bodoni Svty Two ITC TT Book Italic"
	],
	[
		"BodoniSvtyTwoOSITCTT-Bold",
		"Bodoni Svty Two OS ITC TT Bold"
	],
	[
		"BodoniSvtyTwoOSITCTT-Book",
		"Bodoni Svty Two OS ITC TT Book"
	],
	[
		"BodoniSvtyTwoOSITCTT-BookIt",
		"Bodoni Svty Two OS ITC TT Book Italic"
	],
	[
		"BodoniSvtyTwoSCITCTT-Book",
		"Bodoni Svty Two SC ITC TT Book"
	],
	[
		"BradleyHandITCTT-Bold",
		"Bradley Hand ITC TT Bold"
	],
	[
		"ChalkboardSE-Bold",
		"Chalkboard Bold"
	],
	[
		"ChalkboardSE-Light",
		"Chalkboard Light"
	],
	[
		"ChalkboardSE-Regular",
		"Chalkboard Regular"
	],
	[
		"Chalkduster",
		"Chalkduster"
	],
	[
		"Cochin",
		"Cochin"
	],
	[
		"Cochin-Bold",
		"Cochin Bold"
	],
	[
		"Cochin-BoldItalic",
		"Cochin Bold Italic"
	],
	[
		"Cochin-Italic",
		"Cochin Italic"
	],
	[
		"Copperplate",
		"Copperplate"
	],
	[
		"Copperplate-Bold",
		"Copperplate Bold"
	],
	[
		"Copperplate-Light",
		"Copperplate Light"
	],
	[
		"Courier",
		"Courier"
	],
	[
		"Courier-Bold",
		"Courier Bold"
	],
	[
		"Courier-BoldOblique",
		"Courier Bold Oblique"
	],
	[
		"Courier-Oblique",
		"Courier Oblique"
	],
	[
		"CourierNewPS-BoldItalicMT",
		"Courier New Bold Italic"
	],
	[
		"CourierNewPS-BoldMT",
		"Courier New Bold"
	],
	[
		"CourierNewPS-ItalicMT",
		"Courier New Italic"
	],
	[
		"CourierNewPSMT",
		"Courier New"
	],
	[
		"DBLCDTempBlack",
		"DB LCD Temp Black"
	],
	[
		"DevanagariSangamMN",
		"Devanagari Sangam MN"
	],
	[
		"DevanagariSangamMN-Bold",
		"Devanagari Sangam MN Bold"
	],
	[
		"Didot",
		"Didot"
	],
	[
		"Didot-Bold",
		"Didot Bold"
	],
	[
		"Didot-Italic",
		"Didot Italic"
	],
	[
		"EuphemiaUCAS",
		"Euphemia UCAS"
	],
	[
		"EuphemiaUCAS-Bold",
		"Euphemia UCAS Bold"
	],
	[
		"EuphemiaUCAS-Italic",
		"Euphemia UCAS Italic"
	],
	[
		"Futura-Medium",
		"Futura Medium"
	],
	[
		"Futura-MediumItalic",
		"Futura Medium Italic"
	],
	[
		"Futura-CondensedMedium",
		"Futura Condensed Medium"
	],
	[
		"Futura-CondensedExtraBold",
		"Futura Condensed Extra Bold"
	],
	[
		"GeezaPro",
		"Geeza Pro"
	],
	[
		"GeezaPro-Bold",
		"Geeza Pro Bold"
	],
	[
		"Georgia",
		"Georgia"
	],
	[
		"Georgia-Bold",
		"Georgia Bold"
	],
	[
		"Georgia-BoldItalic",
		"Georgia Bold Italic"
	],
	[
		"Georgia-Italic",
		"Georgia Italic"
	],
	[
		"GillSans",
		"Gill Sans"
	],
	[
		"GillSans-Bold",
		"Gill Sans Bold"
	],
	[
		"GillSans-BoldItalic",
		"Gill Sans Bold Italic"
	],
	[
		"GillSans-Italic",
		"Gill Sans Italic"
	],
	[
		"GillSans-Light",
		"Gill Sans Light"
	],
	[
		"GillSans-LightItalic",
		"Gill Sans Light Italic"
	],
	[
		"GujaratiSangamMN",
		"Gujarati Sangam MN"
	],
	[
		"GujaratiSangamMN-Bold",
		"Gujarati Sangam MN Bold"
	],
	[
		"GurmukhiMN",
		"Gurmukhi MN"
	],
	[
		"GurmukhiMN-Bold",
		"Gurmukhi MN Bold"
	],
	[
		"STHeitiSC-Light",
		"ST Heiti SC Light"
	],
	[
		"STHeitiSC-Medium",
		"ST Heiti SC Medium"
	],
	[
		"STHeitiTC-Light",
		"ST Heiti TC Light"
	],
	[
		"STHeitiTC-Medium",
		"ST Heiti TC Medium"
	],
	[
		"Helvetica",
		"Helvetica"
	],
	[
		"Helvetica-Bold",
		"Helvetica Bold"
	],
	[
		"Helvetica-BoldOblique",
		"Helvetica Bold Oblique"
	],
	[
		"Helvetica-Light",
		"Helvetica Light"
	],
	[
		"Helvetica-LightOblique",
		"Helvetica Light Oblique"
	],
	[
		"Helvetica-Oblique",
		"Helvetica Oblique"
	],
	[
		"HelveticaNeue",
		"Helvetica Neue"
	],
	[
		"HelveticaNeue-Bold",
		"Helvetica Neue Bold"
	],
	[
		"HelveticaNeue-BoldItalic",
		"Helvetica Neue Bold Italic"
	],
	[
		"HelveticaNeue-CondensedBlack",
		"Helvetica Neue Condensed Black"
	],
	[
		"HelveticaNeue-CondensedBold",
		"Helvetica Neue Condensed Bold"
	],
	[
		"HelveticaNeue-Italic",
		"Helvetica Neue Italic"
	],
	[
		"HelveticaNeue-Light",
		"Helvetica Neue Light"
	],
	[
		"HelveticaNeue-LightItalic",
		"Helvetica Neue Light Italic"
	],
	[
		"HelveticaNeue-Medium",
		"Helvetica Neue Medium"
	],
	[
		"HelveticaNeue-UltraLight",
		"Helvetica Neue Ultra Light"
	],
	[
		"HelveticaNeue-UltraLightItalic",
		"Helvetica Neue Ultra Light Italic"
	],
	[
		"HiraKakuProN-W3",
		"Hira Kaku Pro N-W3"
	],
	[
		"HiraKakuProN-W6",
		"Hira Kaku Pro N-W6"
	],
	[
		"HiraMinProN-W3",
		"Hira Min Pro N-W3"
	],
	[
		"HiraMinProN-W6",
		"Hira Min Pro N-W6"
	],
	[
		"HoeflerText-Black",
		"Hoefler Text Black"
	],
	[
		"HoeflerText-BlackItalic",
		"Hoefler Text Black Italic"
	],
	[
		"HoeflerText-Italic",
		"Hoefler Text Italic"
	],
	[
		"HoeflerText-Regular",
		"Hoefler Text Regular"
	],
	[
		"Kailasa",
		"Kailasa"
	],
	[
		"KannadaSangamMN",
		"Kannada Sangam MN"
	],
	[
		"KannadaSangamMN-Bold",
		"Kannada Sangam MN Bold"
	],
	[
		"MalayalamSangamMN",
		"Malayalam Sangam MN"
	],
	[
		"MalayalamSangamMN-Bold",
		"Malayalam Sangam MN Bold"
	],
	[
		"Marion-Bold",
		"Marion Bold"
	],
	[
		"Marion-Italic",
		"Marion Italic"
	],
	[
		"Marion-Regular",
		"Marion Regular"
	],
	[
		"MarkerFelt-Thin",
		"Marker Felt Thin"
	],
	[
		"MarkerFelt-Wide",
		"Marker Felt Wide"
	],
	[
		"Noteworthy-Bold",
		"Noteworthy Bold"
	],
	[
		"Noteworthy-Light",
		"Noteworthy Light"
	],
	[
		"Optima-Bold",
		"Optima Bold"
	],
	[
		"Optima-BoldItalic",
		"Optima Bold Italic"
	],
	[
		"Optima-ExtraBlack",
		"Optima Extra Black"
	],
	[
		"Optima-Italic",
		"Optima Italic"
	],
	[
		"Optima-Regular",
		"Optima Regular"
	],
	[
		"OriyaSangamMN",
		"Oriya Sangam MN"
	],
	[
		"OriyaSangamMN-Bold",
		"Oriya Sangam MN Bold"
	],
	[
		"Palatino-Bold",
		"Palatino Bold"
	],
	[
		"Palatino-BoldItalic",
		"Palatino Bold Italic"
	],
	[
		"Palatino-Italic",
		"Palatino Italic"
	],
	[
		"Palatino-Roman",
		"Palatino Roman"
	],
	[
		"Papyrus",
		"Papyrus"
	],
	[
		"Papyrus-Condensed",
		"Papyrus Condensed"
	],
	[
		"PartyLetPlain",
		"Party LET Plain"
	],
	[
		"SinhalaSangamMN",
		"Sinhala Sangam MN"
	],
	[
		"SinhalaSangamMN-Bold",
		"Sinhala Sangam MN Bold"
	],
	[
		"SnellRoundhand",
		"Snell Roundhand"
	],
	[
		"SnellRoundhand-Black",
		"Snell Roundhand Black"
	],
	[
		"SnellRoundhand-Bold",
		"Snell Roundhand Bold"
	],
	[
		"Symbol",
		"Symbol"
	],
	[
		"TamilSangamMN",
		"Tamil Sangam MN"
	],
	[
		"TamilSangamMN-Bold",
		"Tamil Sangam MN Bold"
	],
	[
		"TeluguSangamMN",
		"Telugu Sangam MN"
	],
	[
		"TeluguSangamMN-Bold",
		"Telugu Sangam MN Bold"
	],
	[
		"Thonburi",
		"Thonburi"
	],
	[
		"Thonburi-Bold",
		"Thonburi Bold"
	],
	[
		"TimesNewRomanPSMT",
		"Times New Roman"
	],
	[
		"TimesNewRomanPS-BoldMT",
		"Times New Roman Bold"
	],
	[
		"TimesNewRomanPS-ItalicMT",
		"Times New Roman Italic"
	],
	[
		"TimesNewRomanPS-BoldItalicMT",
		"Times New Roman Bold Italic"
	],
	[
		"Trebuchet-BoldItalic",
		"Trebuchet Bold Italic"
	],
	[
		"TrebuchetMS",
		"Trebuchet MS"
	],
	[
		"TrebuchetMS-Bold",
		"Trebuchet MS Bold"
	],
	[
		"TrebuchetMS-Italic",
		"Trebuchet MS Italic"
	],
	[
		"Verdana",
		"Verdana"
	],
	[
		"Verdana-Bold",
		"Verdana Bold"
	],
	[
		"Verdana-BoldItalic",
		"Verdana Bold Italic"
	],
	[
		"Verdana-Italic",
		"Verdana Italic"
	],
	[
		"ZapfDingbatsITC",
		"Zapf Dingbats ITC"
	],
	[
		"Zapfino",
		"Zapfino"
	]
];

