
// UIBarStyle
var UIBarStyleDefault = 0,
	UIBarStyleBlack = 1;

// UITableViewStyle 
var UITableViewStylePlain = 0,
 	UITableViewStyleGrouped = 1;

var system7DefaultTint = 'rgb(0,123,255)';//'hsl(211,100%,50%)';


window.iOS6Types = {};

// The UILabel class implements a read-only text view.
iOS6Types.UILabel = {

	id: "UILabel",
	type: "UIView",
	properties: [
		{
			id: "text",
			type: "NSString",
			availability: 2.0
		},
		/*{
			id: "attributedText",
			type: "NSAttributedString",
			availability: 6.0
		},*/
		{
			id: "font",
			type: "UIFont",
			availability: 2.0
		},
		{
			id: "textColor",
			type: "UIColor",
			availability: 2.0
		},
		{
			id: "textAlignment",
			type: "NSTextAlignment",
			availability: 2.0
		},
	]
};

iOS6Types.UIView = {

	id: "UIView",
	type: "UIResponder",
	properties: [
		{
			id: "backgroundColor",
			type: "UIColor",
			availability: 2.0
		},
		{
			id: "hidden",
			type: "BOOL",
			availability: 2.0
		},
		{
			id: "alpha",
			type: "CGFloat",
			defaultValue: 1.0,
			availability: 2.0
		},
		{
			id: "opaque",
			type: "BOOL",
			defaultValue: true,
			availability: 2.0
		},
		{
			id: "clipsToBounds",
			type: "BOOL",
			availability: 2.0
		},
		{
			id: "clearsContextBeforeDrawing",
			type: "BOOL",
			defaultValue: true,
			availability: 2.0
		},
		{
			id: "layer",
			type: "CALayer",
			readOnly: true,
			availability: 2.0
		},
		{
			id: "userInteractionEnabled",
			type: "BOOL",
			defaultValue: true,
			availability: 2.0
		},
		{
			id: "multipleTouchEnabled",
			type: "BOOL",
			availability: 2.0
		},
		{
			id: "exclusiveTouch",
			type: "BOOL",
			availability: 2.0
		},
		{
			id: "frame",
			type: "CGRect",
			availability: 2.0
		},
		{
			id: "bounds",
			type: "CGRect",
			availability: 2.0
		},
		{
			id: "center",
			type: "CGPoint",
			availability: 2.0
		},
		{
			id: "transform",
			type: "CGAffineTransform",
			availability: 2.0
		},
		{
			id: "superview",
			type: "UIView",
			readOnly: true,
			availability: 2.0
		},
		{
			id: "subviews",
			type: "NSArray",
			readOnly: true,
			availability: 2.0
		},
		{
			id: "window",
			type: "UIWindow",
			readOnly: true,
			availability: 2.0
		},
		{
			id: "autoresizingMask",
			type: "NSAutoresizingMask",
			availability: 2.0
		},
		{
			id: "autoresizesSubviews",
			type: "BOOL",
			defaultValue: true,
			availability: 2.0
		},
		{
			id: "contentMode",
			type: "UIViewContentMode",
			availability: 2.0
		},
	]
};

iOS6Types.UIFont = {

	id: "UIFont",
	type: "NSObject",
	properties: [
		{
			id: "fontName",
			type: "NSString",
			availability: 2.0,
			readOnly: true
		},
		{
			id: "pointSize",
			type: "CGFloat",
			availability: 2.0,
			readOnly: true
		},
	],
	
};

iOS6Types.UIImageView = {

	id: "UIImageView",
	type: "UIView",
	properties: [
		{
			id: "image",
			type: "UIImage",
			availability: 2.0
		}
	]
};

iOS6Types.UIImageView_URI = {

	id: "UIImageView_URI",
	type: "UIImageView",
	properties: []

};

iOS6Types.UIScrollView = {

	id: "UIScrollView",
	type: "UIView",
	properties: [
	]
};

iOS6Types.UITableView = {

	id: "UITableView",
	type: "UIScrollView",
	properties: [
	]
};

iOS6Types.UIControl = {

	id: "UIControl",
	type: "UIView",
	properties: [
		{
			id: "state",
			type: "UIControlState",
			availability: 2.0
		},
		{
			id: "enabled",
			type: "BOOL",
			defaultValue: true,
			availability: 2.0
		},
		{
			id: "selected",
			type: "BOOL",
			availability: 2.0
		},
		{
			id: "highlighted",
			type: "BOOL",
			availability: 2.0
		},
		{
			id: "contentVerticalAlignment",
			type: "UIControlContentVerticalAlignment",
			availability: 2.0
		},
		{
			id: "contentHorizontalAlignment",
			type: "UIControlContentHorizontalAlignment",
			availability: 2.0
		},
		{
			id: "tracking",
			type: "BOOL",
			readOnly: true,
			availability: 2.0
		},
		{
			id: "touchInside",
			type: "BOOL",
			readOnly: true,
			availability: 2.0
		},
	],
	"methods": [
		{
			id: "addTarget:action:forControlEvents:",
			type: "void",
			availability: 2.0
		},
	]
};

iOS6Types.UIButton = {

	id: "UIButton",
	type: "UIControl",
	properties: [
		{
			id: "titleLabel",
			type: "UILabel",
			readOnly: true,
			availability: 3.0
		},
		{
			id: "reversesTitleShadowWhenHighlighted",
			type: "BOOL",
			availability: 2.0
		},
		{
			id: "adjustsImageWhenHighlighted",
			type: "BOOL",
			defaultValue: true,
			availability: 2.0
		},
		{
			id: "adjustsImageWhenDisabled",
			type: "BOOL",
			defaultValue: true,
			availability: 2.0
		},
		{
			id: "showsTouchWhenHighlighted",
			type: "BOOL",
			availability: 2.0
		},
		{
			id: "tintColor",
			type: "UIColor",
			availability: 5.0
		},
	],
	methods: [
	]
};

iOS6Types.UIImage = {

	id: "UIImage",
	type: "NSObject",
	properties: [
		{
			id: "imageOrientation",
			type: "UIImageOrientation",
			availability: 2.0,
			readOnly: true
		},
		{
			id: "size",
			type: "CGSize",
			availability: 2.0,
			readOnly: true
		},
		{
			id: "scale",
			type: "CGFloat",
			availability: 4.0,
			readOnly: true
		},
		{
			id: "CGImage",
			type: "CGImageRef",
			availability: 2.0,
			readOnly: true
		},
	],
	
};

iOS6Types.UITableViewCell = {

	id: "UITableViewCell",
	type: "UIView"

};

iOS6Types.CGRect = {

	id: "CGRect",
	type: "struct",
	properties: [
		{
			id: "origin",
			type: "CGPoint",
			availability: 2.0
		},
		{
			id: "size",
			type: "CGSize",
			availability: 2.0
		},
	],
	
};

iOS6Types.NSAutoresizingMask = {

	id: "NSAutoresizingMask",
	type: "NSUInteger",
	properties: [],
	
};

iOS6Types.UICollectionView = {

	id: "UICollectionView",
	type: "UIScrollView",
	properties: []

};

var localizedIdentifiers = {};
localizedIdentifiers.de = {
	"UILabel": "Beschriftung",
	"text": "Text",
	"attributedText": "Text mit Attributen",
//	"textColor": "Textfarbe",
	"NSTextAlignment": "Ausrichtung",
	"UIFont": "Schrift",
	"UIColor": "Farbe",

	"UIView": "Ansicht",
	"frame": "Rahmen",
	"bounds": "Abgrenzungen",
	"contentMode": "Inhalt-Modus",
	"autoresizingMask": "Autosizing",
	"fontName": "Schriftname",
	"pointSize": "Größe in pt",
	"backgroundColor": "Hintergrundfarbe",
	"hidden": "versteckt",
	"opaque": "deckend",
	"alpha": "Sichtbarkeit",

	"UIScrollView": "Scrollender Bereich",

	"CGRect": "Position & Größe",
	"UIImageView": "Bildansicht",
	"image": "Bild",
	"UIImage": "Bildobjekt",
	"NSAutoresizingMask": "Auto Resizing",
	"UIControl": "Steuerelement",
	"UIButton": "Schaltfläche",
};
